// Code generated by go-swagger; DO NOT EDIT.

package correlations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetCorrelationsReader is a Reader for the GetCorrelations structure.
type GetCorrelationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetCorrelationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetCorrelationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetCorrelationsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetCorrelationsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetCorrelationsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /datasources/correlations] getCorrelations", response, response.Code())
	}
}

// NewGetCorrelationsOK creates a GetCorrelationsOK with default headers values
func NewGetCorrelationsOK() *GetCorrelationsOK {
	return &GetCorrelationsOK{}
}

/*
GetCorrelationsOK describes a response with status code 200, with default header values.

(empty)
*/
type GetCorrelationsOK struct {
	Payload []*models.Correlation
}

// IsSuccess returns true when this get correlations Ok response has a 2xx status code
func (o *GetCorrelationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get correlations Ok response has a 3xx status code
func (o *GetCorrelationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get correlations Ok response has a 4xx status code
func (o *GetCorrelationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get correlations Ok response has a 5xx status code
func (o *GetCorrelationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get correlations Ok response a status code equal to that given
func (o *GetCorrelationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get correlations Ok response
func (o *GetCorrelationsOK) Code() int {
	return 200
}

func (o *GetCorrelationsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/correlations][%d] getCorrelationsOk %s", 200, payload)
}

func (o *GetCorrelationsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/correlations][%d] getCorrelationsOk %s", 200, payload)
}

func (o *GetCorrelationsOK) GetPayload() []*models.Correlation {
	return o.Payload
}

func (o *GetCorrelationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCorrelationsUnauthorized creates a GetCorrelationsUnauthorized with default headers values
func NewGetCorrelationsUnauthorized() *GetCorrelationsUnauthorized {
	return &GetCorrelationsUnauthorized{}
}

/*
GetCorrelationsUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetCorrelationsUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get correlations unauthorized response has a 2xx status code
func (o *GetCorrelationsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get correlations unauthorized response has a 3xx status code
func (o *GetCorrelationsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get correlations unauthorized response has a 4xx status code
func (o *GetCorrelationsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get correlations unauthorized response has a 5xx status code
func (o *GetCorrelationsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get correlations unauthorized response a status code equal to that given
func (o *GetCorrelationsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get correlations unauthorized response
func (o *GetCorrelationsUnauthorized) Code() int {
	return 401
}

func (o *GetCorrelationsUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/correlations][%d] getCorrelationsUnauthorized %s", 401, payload)
}

func (o *GetCorrelationsUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/correlations][%d] getCorrelationsUnauthorized %s", 401, payload)
}

func (o *GetCorrelationsUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetCorrelationsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCorrelationsNotFound creates a GetCorrelationsNotFound with default headers values
func NewGetCorrelationsNotFound() *GetCorrelationsNotFound {
	return &GetCorrelationsNotFound{}
}

/*
GetCorrelationsNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetCorrelationsNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get correlations not found response has a 2xx status code
func (o *GetCorrelationsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get correlations not found response has a 3xx status code
func (o *GetCorrelationsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get correlations not found response has a 4xx status code
func (o *GetCorrelationsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get correlations not found response has a 5xx status code
func (o *GetCorrelationsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get correlations not found response a status code equal to that given
func (o *GetCorrelationsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get correlations not found response
func (o *GetCorrelationsNotFound) Code() int {
	return 404
}

func (o *GetCorrelationsNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/correlations][%d] getCorrelationsNotFound %s", 404, payload)
}

func (o *GetCorrelationsNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/correlations][%d] getCorrelationsNotFound %s", 404, payload)
}

func (o *GetCorrelationsNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetCorrelationsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetCorrelationsInternalServerError creates a GetCorrelationsInternalServerError with default headers values
func NewGetCorrelationsInternalServerError() *GetCorrelationsInternalServerError {
	return &GetCorrelationsInternalServerError{}
}

/*
GetCorrelationsInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetCorrelationsInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get correlations internal server error response has a 2xx status code
func (o *GetCorrelationsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get correlations internal server error response has a 3xx status code
func (o *GetCorrelationsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get correlations internal server error response has a 4xx status code
func (o *GetCorrelationsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get correlations internal server error response has a 5xx status code
func (o *GetCorrelationsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get correlations internal server error response a status code equal to that given
func (o *GetCorrelationsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get correlations internal server error response
func (o *GetCorrelationsInternalServerError) Code() int {
	return 500
}

func (o *GetCorrelationsInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/correlations][%d] getCorrelationsInternalServerError %s", 500, payload)
}

func (o *GetCorrelationsInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/correlations][%d] getCorrelationsInternalServerError %s", 500, payload)
}

func (o *GetCorrelationsInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetCorrelationsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
