// Code generated by go-swagger; DO NOT EDIT.

package dashboard_public

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetPublicAnnotationsReader is a Reader for the GetPublicAnnotations structure.
type GetPublicAnnotationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetPublicAnnotationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetPublicAnnotationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetPublicAnnotationsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetPublicAnnotationsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetPublicAnnotationsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetPublicAnnotationsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetPublicAnnotationsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /public/dashboards/{accessToken}/annotations] getPublicAnnotations", response, response.Code())
	}
}

// NewGetPublicAnnotationsOK creates a GetPublicAnnotationsOK with default headers values
func NewGetPublicAnnotationsOK() *GetPublicAnnotationsOK {
	return &GetPublicAnnotationsOK{}
}

/*
GetPublicAnnotationsOK describes a response with status code 200, with default header values.

(empty)
*/
type GetPublicAnnotationsOK struct {
	Payload []*models.AnnotationEvent
}

// IsSuccess returns true when this get public annotations Ok response has a 2xx status code
func (o *GetPublicAnnotationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get public annotations Ok response has a 3xx status code
func (o *GetPublicAnnotationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get public annotations Ok response has a 4xx status code
func (o *GetPublicAnnotationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get public annotations Ok response has a 5xx status code
func (o *GetPublicAnnotationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get public annotations Ok response a status code equal to that given
func (o *GetPublicAnnotationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get public annotations Ok response
func (o *GetPublicAnnotationsOK) Code() int {
	return 200
}

func (o *GetPublicAnnotationsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}/annotations][%d] getPublicAnnotationsOk %s", 200, payload)
}

func (o *GetPublicAnnotationsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}/annotations][%d] getPublicAnnotationsOk %s", 200, payload)
}

func (o *GetPublicAnnotationsOK) GetPayload() []*models.AnnotationEvent {
	return o.Payload
}

func (o *GetPublicAnnotationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPublicAnnotationsBadRequest creates a GetPublicAnnotationsBadRequest with default headers values
func NewGetPublicAnnotationsBadRequest() *GetPublicAnnotationsBadRequest {
	return &GetPublicAnnotationsBadRequest{}
}

/*
GetPublicAnnotationsBadRequest describes a response with status code 400, with default header values.

BadRequestPublicError is returned when the request is invalid and it cannot be processed.
*/
type GetPublicAnnotationsBadRequest struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this get public annotations bad request response has a 2xx status code
func (o *GetPublicAnnotationsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get public annotations bad request response has a 3xx status code
func (o *GetPublicAnnotationsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get public annotations bad request response has a 4xx status code
func (o *GetPublicAnnotationsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get public annotations bad request response has a 5xx status code
func (o *GetPublicAnnotationsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get public annotations bad request response a status code equal to that given
func (o *GetPublicAnnotationsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get public annotations bad request response
func (o *GetPublicAnnotationsBadRequest) Code() int {
	return 400
}

func (o *GetPublicAnnotationsBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}/annotations][%d] getPublicAnnotationsBadRequest %s", 400, payload)
}

func (o *GetPublicAnnotationsBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}/annotations][%d] getPublicAnnotationsBadRequest %s", 400, payload)
}

func (o *GetPublicAnnotationsBadRequest) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *GetPublicAnnotationsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPublicAnnotationsUnauthorized creates a GetPublicAnnotationsUnauthorized with default headers values
func NewGetPublicAnnotationsUnauthorized() *GetPublicAnnotationsUnauthorized {
	return &GetPublicAnnotationsUnauthorized{}
}

/*
GetPublicAnnotationsUnauthorized describes a response with status code 401, with default header values.

UnauthorisedPublicError is returned when the request is not authenticated.
*/
type GetPublicAnnotationsUnauthorized struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this get public annotations unauthorized response has a 2xx status code
func (o *GetPublicAnnotationsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get public annotations unauthorized response has a 3xx status code
func (o *GetPublicAnnotationsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get public annotations unauthorized response has a 4xx status code
func (o *GetPublicAnnotationsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get public annotations unauthorized response has a 5xx status code
func (o *GetPublicAnnotationsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get public annotations unauthorized response a status code equal to that given
func (o *GetPublicAnnotationsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get public annotations unauthorized response
func (o *GetPublicAnnotationsUnauthorized) Code() int {
	return 401
}

func (o *GetPublicAnnotationsUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}/annotations][%d] getPublicAnnotationsUnauthorized %s", 401, payload)
}

func (o *GetPublicAnnotationsUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}/annotations][%d] getPublicAnnotationsUnauthorized %s", 401, payload)
}

func (o *GetPublicAnnotationsUnauthorized) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *GetPublicAnnotationsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPublicAnnotationsForbidden creates a GetPublicAnnotationsForbidden with default headers values
func NewGetPublicAnnotationsForbidden() *GetPublicAnnotationsForbidden {
	return &GetPublicAnnotationsForbidden{}
}

/*
GetPublicAnnotationsForbidden describes a response with status code 403, with default header values.

ForbiddenPublicError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetPublicAnnotationsForbidden struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this get public annotations forbidden response has a 2xx status code
func (o *GetPublicAnnotationsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get public annotations forbidden response has a 3xx status code
func (o *GetPublicAnnotationsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get public annotations forbidden response has a 4xx status code
func (o *GetPublicAnnotationsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get public annotations forbidden response has a 5xx status code
func (o *GetPublicAnnotationsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get public annotations forbidden response a status code equal to that given
func (o *GetPublicAnnotationsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get public annotations forbidden response
func (o *GetPublicAnnotationsForbidden) Code() int {
	return 403
}

func (o *GetPublicAnnotationsForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}/annotations][%d] getPublicAnnotationsForbidden %s", 403, payload)
}

func (o *GetPublicAnnotationsForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}/annotations][%d] getPublicAnnotationsForbidden %s", 403, payload)
}

func (o *GetPublicAnnotationsForbidden) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *GetPublicAnnotationsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPublicAnnotationsNotFound creates a GetPublicAnnotationsNotFound with default headers values
func NewGetPublicAnnotationsNotFound() *GetPublicAnnotationsNotFound {
	return &GetPublicAnnotationsNotFound{}
}

/*
GetPublicAnnotationsNotFound describes a response with status code 404, with default header values.

NotFoundPublicError is returned when the requested resource was not found.
*/
type GetPublicAnnotationsNotFound struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this get public annotations not found response has a 2xx status code
func (o *GetPublicAnnotationsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get public annotations not found response has a 3xx status code
func (o *GetPublicAnnotationsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get public annotations not found response has a 4xx status code
func (o *GetPublicAnnotationsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get public annotations not found response has a 5xx status code
func (o *GetPublicAnnotationsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get public annotations not found response a status code equal to that given
func (o *GetPublicAnnotationsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get public annotations not found response
func (o *GetPublicAnnotationsNotFound) Code() int {
	return 404
}

func (o *GetPublicAnnotationsNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}/annotations][%d] getPublicAnnotationsNotFound %s", 404, payload)
}

func (o *GetPublicAnnotationsNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}/annotations][%d] getPublicAnnotationsNotFound %s", 404, payload)
}

func (o *GetPublicAnnotationsNotFound) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *GetPublicAnnotationsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPublicAnnotationsInternalServerError creates a GetPublicAnnotationsInternalServerError with default headers values
func NewGetPublicAnnotationsInternalServerError() *GetPublicAnnotationsInternalServerError {
	return &GetPublicAnnotationsInternalServerError{}
}

/*
GetPublicAnnotationsInternalServerError describes a response with status code 500, with default header values.

InternalServerPublicError is a general error indicating something went wrong internally.
*/
type GetPublicAnnotationsInternalServerError struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this get public annotations internal server error response has a 2xx status code
func (o *GetPublicAnnotationsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get public annotations internal server error response has a 3xx status code
func (o *GetPublicAnnotationsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get public annotations internal server error response has a 4xx status code
func (o *GetPublicAnnotationsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get public annotations internal server error response has a 5xx status code
func (o *GetPublicAnnotationsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get public annotations internal server error response a status code equal to that given
func (o *GetPublicAnnotationsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get public annotations internal server error response
func (o *GetPublicAnnotationsInternalServerError) Code() int {
	return 500
}

func (o *GetPublicAnnotationsInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}/annotations][%d] getPublicAnnotationsInternalServerError %s", 500, payload)
}

func (o *GetPublicAnnotationsInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}/annotations][%d] getPublicAnnotationsInternalServerError %s", 500, payload)
}

func (o *GetPublicAnnotationsInternalServerError) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *GetPublicAnnotationsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
