// Code generated by go-swagger; DO NOT EDIT.

package dashboard_public

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// ViewPublicDashboardReader is a Reader for the ViewPublicDashboard structure.
type ViewPublicDashboardReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ViewPublicDashboardReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewViewPublicDashboardOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewViewPublicDashboardBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewViewPublicDashboardUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewViewPublicDashboardForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewViewPublicDashboardNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewViewPublicDashboardInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /public/dashboards/{accessToken}] viewPublicDashboard", response, response.Code())
	}
}

// NewViewPublicDashboardOK creates a ViewPublicDashboardOK with default headers values
func NewViewPublicDashboardOK() *ViewPublicDashboardOK {
	return &ViewPublicDashboardOK{}
}

/*
ViewPublicDashboardOK describes a response with status code 200, with default header values.

(empty)
*/
type ViewPublicDashboardOK struct {
	Payload *models.DashboardFullWithMeta
}

// IsSuccess returns true when this view public dashboard Ok response has a 2xx status code
func (o *ViewPublicDashboardOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this view public dashboard Ok response has a 3xx status code
func (o *ViewPublicDashboardOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this view public dashboard Ok response has a 4xx status code
func (o *ViewPublicDashboardOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this view public dashboard Ok response has a 5xx status code
func (o *ViewPublicDashboardOK) IsServerError() bool {
	return false
}

// IsCode returns true when this view public dashboard Ok response a status code equal to that given
func (o *ViewPublicDashboardOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the view public dashboard Ok response
func (o *ViewPublicDashboardOK) Code() int {
	return 200
}

func (o *ViewPublicDashboardOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}][%d] viewPublicDashboardOk %s", 200, payload)
}

func (o *ViewPublicDashboardOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}][%d] viewPublicDashboardOk %s", 200, payload)
}

func (o *ViewPublicDashboardOK) GetPayload() *models.DashboardFullWithMeta {
	return o.Payload
}

func (o *ViewPublicDashboardOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DashboardFullWithMeta)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewViewPublicDashboardBadRequest creates a ViewPublicDashboardBadRequest with default headers values
func NewViewPublicDashboardBadRequest() *ViewPublicDashboardBadRequest {
	return &ViewPublicDashboardBadRequest{}
}

/*
ViewPublicDashboardBadRequest describes a response with status code 400, with default header values.

BadRequestPublicError is returned when the request is invalid and it cannot be processed.
*/
type ViewPublicDashboardBadRequest struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this view public dashboard bad request response has a 2xx status code
func (o *ViewPublicDashboardBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this view public dashboard bad request response has a 3xx status code
func (o *ViewPublicDashboardBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this view public dashboard bad request response has a 4xx status code
func (o *ViewPublicDashboardBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this view public dashboard bad request response has a 5xx status code
func (o *ViewPublicDashboardBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this view public dashboard bad request response a status code equal to that given
func (o *ViewPublicDashboardBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the view public dashboard bad request response
func (o *ViewPublicDashboardBadRequest) Code() int {
	return 400
}

func (o *ViewPublicDashboardBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}][%d] viewPublicDashboardBadRequest %s", 400, payload)
}

func (o *ViewPublicDashboardBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}][%d] viewPublicDashboardBadRequest %s", 400, payload)
}

func (o *ViewPublicDashboardBadRequest) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *ViewPublicDashboardBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewViewPublicDashboardUnauthorized creates a ViewPublicDashboardUnauthorized with default headers values
func NewViewPublicDashboardUnauthorized() *ViewPublicDashboardUnauthorized {
	return &ViewPublicDashboardUnauthorized{}
}

/*
ViewPublicDashboardUnauthorized describes a response with status code 401, with default header values.

UnauthorisedPublicError is returned when the request is not authenticated.
*/
type ViewPublicDashboardUnauthorized struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this view public dashboard unauthorized response has a 2xx status code
func (o *ViewPublicDashboardUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this view public dashboard unauthorized response has a 3xx status code
func (o *ViewPublicDashboardUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this view public dashboard unauthorized response has a 4xx status code
func (o *ViewPublicDashboardUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this view public dashboard unauthorized response has a 5xx status code
func (o *ViewPublicDashboardUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this view public dashboard unauthorized response a status code equal to that given
func (o *ViewPublicDashboardUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the view public dashboard unauthorized response
func (o *ViewPublicDashboardUnauthorized) Code() int {
	return 401
}

func (o *ViewPublicDashboardUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}][%d] viewPublicDashboardUnauthorized %s", 401, payload)
}

func (o *ViewPublicDashboardUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}][%d] viewPublicDashboardUnauthorized %s", 401, payload)
}

func (o *ViewPublicDashboardUnauthorized) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *ViewPublicDashboardUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewViewPublicDashboardForbidden creates a ViewPublicDashboardForbidden with default headers values
func NewViewPublicDashboardForbidden() *ViewPublicDashboardForbidden {
	return &ViewPublicDashboardForbidden{}
}

/*
ViewPublicDashboardForbidden describes a response with status code 403, with default header values.

ForbiddenPublicError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type ViewPublicDashboardForbidden struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this view public dashboard forbidden response has a 2xx status code
func (o *ViewPublicDashboardForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this view public dashboard forbidden response has a 3xx status code
func (o *ViewPublicDashboardForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this view public dashboard forbidden response has a 4xx status code
func (o *ViewPublicDashboardForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this view public dashboard forbidden response has a 5xx status code
func (o *ViewPublicDashboardForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this view public dashboard forbidden response a status code equal to that given
func (o *ViewPublicDashboardForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the view public dashboard forbidden response
func (o *ViewPublicDashboardForbidden) Code() int {
	return 403
}

func (o *ViewPublicDashboardForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}][%d] viewPublicDashboardForbidden %s", 403, payload)
}

func (o *ViewPublicDashboardForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}][%d] viewPublicDashboardForbidden %s", 403, payload)
}

func (o *ViewPublicDashboardForbidden) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *ViewPublicDashboardForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewViewPublicDashboardNotFound creates a ViewPublicDashboardNotFound with default headers values
func NewViewPublicDashboardNotFound() *ViewPublicDashboardNotFound {
	return &ViewPublicDashboardNotFound{}
}

/*
ViewPublicDashboardNotFound describes a response with status code 404, with default header values.

NotFoundPublicError is returned when the requested resource was not found.
*/
type ViewPublicDashboardNotFound struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this view public dashboard not found response has a 2xx status code
func (o *ViewPublicDashboardNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this view public dashboard not found response has a 3xx status code
func (o *ViewPublicDashboardNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this view public dashboard not found response has a 4xx status code
func (o *ViewPublicDashboardNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this view public dashboard not found response has a 5xx status code
func (o *ViewPublicDashboardNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this view public dashboard not found response a status code equal to that given
func (o *ViewPublicDashboardNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the view public dashboard not found response
func (o *ViewPublicDashboardNotFound) Code() int {
	return 404
}

func (o *ViewPublicDashboardNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}][%d] viewPublicDashboardNotFound %s", 404, payload)
}

func (o *ViewPublicDashboardNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}][%d] viewPublicDashboardNotFound %s", 404, payload)
}

func (o *ViewPublicDashboardNotFound) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *ViewPublicDashboardNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewViewPublicDashboardInternalServerError creates a ViewPublicDashboardInternalServerError with default headers values
func NewViewPublicDashboardInternalServerError() *ViewPublicDashboardInternalServerError {
	return &ViewPublicDashboardInternalServerError{}
}

/*
ViewPublicDashboardInternalServerError describes a response with status code 500, with default header values.

InternalServerPublicError is a general error indicating something went wrong internally.
*/
type ViewPublicDashboardInternalServerError struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this view public dashboard internal server error response has a 2xx status code
func (o *ViewPublicDashboardInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this view public dashboard internal server error response has a 3xx status code
func (o *ViewPublicDashboardInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this view public dashboard internal server error response has a 4xx status code
func (o *ViewPublicDashboardInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this view public dashboard internal server error response has a 5xx status code
func (o *ViewPublicDashboardInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this view public dashboard internal server error response a status code equal to that given
func (o *ViewPublicDashboardInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the view public dashboard internal server error response
func (o *ViewPublicDashboardInternalServerError) Code() int {
	return 500
}

func (o *ViewPublicDashboardInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}][%d] viewPublicDashboardInternalServerError %s", 500, payload)
}

func (o *ViewPublicDashboardInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /public/dashboards/{accessToken}][%d] viewPublicDashboardInternalServerError %s", 500, payload)
}

func (o *ViewPublicDashboardInternalServerError) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *ViewPublicDashboardInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
