// Code generated by go-swagger; DO NOT EDIT.

package datasources

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// CheckDatasourceHealthByIDReader is a Reader for the CheckDatasourceHealthByID structure.
type CheckDatasourceHealthByIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CheckDatasourceHealthByIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCheckDatasourceHealthByIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCheckDatasourceHealthByIDBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewCheckDatasourceHealthByIDUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCheckDatasourceHealthByIDForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCheckDatasourceHealthByIDInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /datasources/{id}/health] checkDatasourceHealthByID", response, response.Code())
	}
}

// NewCheckDatasourceHealthByIDOK creates a CheckDatasourceHealthByIDOK with default headers values
func NewCheckDatasourceHealthByIDOK() *CheckDatasourceHealthByIDOK {
	return &CheckDatasourceHealthByIDOK{}
}

/*
CheckDatasourceHealthByIDOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type CheckDatasourceHealthByIDOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this check datasource health by Id Ok response has a 2xx status code
func (o *CheckDatasourceHealthByIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this check datasource health by Id Ok response has a 3xx status code
func (o *CheckDatasourceHealthByIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this check datasource health by Id Ok response has a 4xx status code
func (o *CheckDatasourceHealthByIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this check datasource health by Id Ok response has a 5xx status code
func (o *CheckDatasourceHealthByIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this check datasource health by Id Ok response a status code equal to that given
func (o *CheckDatasourceHealthByIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the check datasource health by Id Ok response
func (o *CheckDatasourceHealthByIDOK) Code() int {
	return 200
}

func (o *CheckDatasourceHealthByIDOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/{id}/health][%d] checkDatasourceHealthByIdOk %s", 200, payload)
}

func (o *CheckDatasourceHealthByIDOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/{id}/health][%d] checkDatasourceHealthByIdOk %s", 200, payload)
}

func (o *CheckDatasourceHealthByIDOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *CheckDatasourceHealthByIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCheckDatasourceHealthByIDBadRequest creates a CheckDatasourceHealthByIDBadRequest with default headers values
func NewCheckDatasourceHealthByIDBadRequest() *CheckDatasourceHealthByIDBadRequest {
	return &CheckDatasourceHealthByIDBadRequest{}
}

/*
CheckDatasourceHealthByIDBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type CheckDatasourceHealthByIDBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this check datasource health by Id bad request response has a 2xx status code
func (o *CheckDatasourceHealthByIDBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this check datasource health by Id bad request response has a 3xx status code
func (o *CheckDatasourceHealthByIDBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this check datasource health by Id bad request response has a 4xx status code
func (o *CheckDatasourceHealthByIDBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this check datasource health by Id bad request response has a 5xx status code
func (o *CheckDatasourceHealthByIDBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this check datasource health by Id bad request response a status code equal to that given
func (o *CheckDatasourceHealthByIDBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the check datasource health by Id bad request response
func (o *CheckDatasourceHealthByIDBadRequest) Code() int {
	return 400
}

func (o *CheckDatasourceHealthByIDBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/{id}/health][%d] checkDatasourceHealthByIdBadRequest %s", 400, payload)
}

func (o *CheckDatasourceHealthByIDBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/{id}/health][%d] checkDatasourceHealthByIdBadRequest %s", 400, payload)
}

func (o *CheckDatasourceHealthByIDBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CheckDatasourceHealthByIDBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCheckDatasourceHealthByIDUnauthorized creates a CheckDatasourceHealthByIDUnauthorized with default headers values
func NewCheckDatasourceHealthByIDUnauthorized() *CheckDatasourceHealthByIDUnauthorized {
	return &CheckDatasourceHealthByIDUnauthorized{}
}

/*
CheckDatasourceHealthByIDUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type CheckDatasourceHealthByIDUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this check datasource health by Id unauthorized response has a 2xx status code
func (o *CheckDatasourceHealthByIDUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this check datasource health by Id unauthorized response has a 3xx status code
func (o *CheckDatasourceHealthByIDUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this check datasource health by Id unauthorized response has a 4xx status code
func (o *CheckDatasourceHealthByIDUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this check datasource health by Id unauthorized response has a 5xx status code
func (o *CheckDatasourceHealthByIDUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this check datasource health by Id unauthorized response a status code equal to that given
func (o *CheckDatasourceHealthByIDUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the check datasource health by Id unauthorized response
func (o *CheckDatasourceHealthByIDUnauthorized) Code() int {
	return 401
}

func (o *CheckDatasourceHealthByIDUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/{id}/health][%d] checkDatasourceHealthByIdUnauthorized %s", 401, payload)
}

func (o *CheckDatasourceHealthByIDUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/{id}/health][%d] checkDatasourceHealthByIdUnauthorized %s", 401, payload)
}

func (o *CheckDatasourceHealthByIDUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CheckDatasourceHealthByIDUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCheckDatasourceHealthByIDForbidden creates a CheckDatasourceHealthByIDForbidden with default headers values
func NewCheckDatasourceHealthByIDForbidden() *CheckDatasourceHealthByIDForbidden {
	return &CheckDatasourceHealthByIDForbidden{}
}

/*
CheckDatasourceHealthByIDForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type CheckDatasourceHealthByIDForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this check datasource health by Id forbidden response has a 2xx status code
func (o *CheckDatasourceHealthByIDForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this check datasource health by Id forbidden response has a 3xx status code
func (o *CheckDatasourceHealthByIDForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this check datasource health by Id forbidden response has a 4xx status code
func (o *CheckDatasourceHealthByIDForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this check datasource health by Id forbidden response has a 5xx status code
func (o *CheckDatasourceHealthByIDForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this check datasource health by Id forbidden response a status code equal to that given
func (o *CheckDatasourceHealthByIDForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the check datasource health by Id forbidden response
func (o *CheckDatasourceHealthByIDForbidden) Code() int {
	return 403
}

func (o *CheckDatasourceHealthByIDForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/{id}/health][%d] checkDatasourceHealthByIdForbidden %s", 403, payload)
}

func (o *CheckDatasourceHealthByIDForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/{id}/health][%d] checkDatasourceHealthByIdForbidden %s", 403, payload)
}

func (o *CheckDatasourceHealthByIDForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CheckDatasourceHealthByIDForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCheckDatasourceHealthByIDInternalServerError creates a CheckDatasourceHealthByIDInternalServerError with default headers values
func NewCheckDatasourceHealthByIDInternalServerError() *CheckDatasourceHealthByIDInternalServerError {
	return &CheckDatasourceHealthByIDInternalServerError{}
}

/*
CheckDatasourceHealthByIDInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type CheckDatasourceHealthByIDInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this check datasource health by Id internal server error response has a 2xx status code
func (o *CheckDatasourceHealthByIDInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this check datasource health by Id internal server error response has a 3xx status code
func (o *CheckDatasourceHealthByIDInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this check datasource health by Id internal server error response has a 4xx status code
func (o *CheckDatasourceHealthByIDInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this check datasource health by Id internal server error response has a 5xx status code
func (o *CheckDatasourceHealthByIDInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this check datasource health by Id internal server error response a status code equal to that given
func (o *CheckDatasourceHealthByIDInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the check datasource health by Id internal server error response
func (o *CheckDatasourceHealthByIDInternalServerError) Code() int {
	return 500
}

func (o *CheckDatasourceHealthByIDInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/{id}/health][%d] checkDatasourceHealthByIdInternalServerError %s", 500, payload)
}

func (o *CheckDatasourceHealthByIDInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /datasources/{id}/health][%d] checkDatasourceHealthByIdInternalServerError %s", 500, payload)
}

func (o *CheckDatasourceHealthByIDInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CheckDatasourceHealthByIDInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
