// Code generated by go-swagger; DO NOT EDIT.

package devices

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// ListDevicesReader is a Reader for the ListDevices structure.
type ListDevicesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListDevicesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListDevicesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewListDevicesUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewListDevicesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewListDevicesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewListDevicesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /stats] listDevices", response, response.Code())
	}
}

// NewListDevicesOK creates a ListDevicesOK with default headers values
func NewListDevicesOK() *ListDevicesOK {
	return &ListDevicesOK{}
}

/*
ListDevicesOK describes a response with status code 200, with default header values.

(empty)
*/
type ListDevicesOK struct {
	Payload []*models.DeviceDTO
}

// IsSuccess returns true when this list devices Ok response has a 2xx status code
func (o *ListDevicesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list devices Ok response has a 3xx status code
func (o *ListDevicesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list devices Ok response has a 4xx status code
func (o *ListDevicesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list devices Ok response has a 5xx status code
func (o *ListDevicesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list devices Ok response a status code equal to that given
func (o *ListDevicesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list devices Ok response
func (o *ListDevicesOK) Code() int {
	return 200
}

func (o *ListDevicesOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /stats][%d] listDevicesOk %s", 200, payload)
}

func (o *ListDevicesOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /stats][%d] listDevicesOk %s", 200, payload)
}

func (o *ListDevicesOK) GetPayload() []*models.DeviceDTO {
	return o.Payload
}

func (o *ListDevicesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListDevicesUnauthorized creates a ListDevicesUnauthorized with default headers values
func NewListDevicesUnauthorized() *ListDevicesUnauthorized {
	return &ListDevicesUnauthorized{}
}

/*
ListDevicesUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type ListDevicesUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list devices unauthorized response has a 2xx status code
func (o *ListDevicesUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list devices unauthorized response has a 3xx status code
func (o *ListDevicesUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list devices unauthorized response has a 4xx status code
func (o *ListDevicesUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this list devices unauthorized response has a 5xx status code
func (o *ListDevicesUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this list devices unauthorized response a status code equal to that given
func (o *ListDevicesUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the list devices unauthorized response
func (o *ListDevicesUnauthorized) Code() int {
	return 401
}

func (o *ListDevicesUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /stats][%d] listDevicesUnauthorized %s", 401, payload)
}

func (o *ListDevicesUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /stats][%d] listDevicesUnauthorized %s", 401, payload)
}

func (o *ListDevicesUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListDevicesUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListDevicesForbidden creates a ListDevicesForbidden with default headers values
func NewListDevicesForbidden() *ListDevicesForbidden {
	return &ListDevicesForbidden{}
}

/*
ListDevicesForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type ListDevicesForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list devices forbidden response has a 2xx status code
func (o *ListDevicesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list devices forbidden response has a 3xx status code
func (o *ListDevicesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list devices forbidden response has a 4xx status code
func (o *ListDevicesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this list devices forbidden response has a 5xx status code
func (o *ListDevicesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this list devices forbidden response a status code equal to that given
func (o *ListDevicesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the list devices forbidden response
func (o *ListDevicesForbidden) Code() int {
	return 403
}

func (o *ListDevicesForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /stats][%d] listDevicesForbidden %s", 403, payload)
}

func (o *ListDevicesForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /stats][%d] listDevicesForbidden %s", 403, payload)
}

func (o *ListDevicesForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListDevicesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListDevicesNotFound creates a ListDevicesNotFound with default headers values
func NewListDevicesNotFound() *ListDevicesNotFound {
	return &ListDevicesNotFound{}
}

/*
ListDevicesNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type ListDevicesNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list devices not found response has a 2xx status code
func (o *ListDevicesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list devices not found response has a 3xx status code
func (o *ListDevicesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list devices not found response has a 4xx status code
func (o *ListDevicesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this list devices not found response has a 5xx status code
func (o *ListDevicesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this list devices not found response a status code equal to that given
func (o *ListDevicesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the list devices not found response
func (o *ListDevicesNotFound) Code() int {
	return 404
}

func (o *ListDevicesNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /stats][%d] listDevicesNotFound %s", 404, payload)
}

func (o *ListDevicesNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /stats][%d] listDevicesNotFound %s", 404, payload)
}

func (o *ListDevicesNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListDevicesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListDevicesInternalServerError creates a ListDevicesInternalServerError with default headers values
func NewListDevicesInternalServerError() *ListDevicesInternalServerError {
	return &ListDevicesInternalServerError{}
}

/*
ListDevicesInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type ListDevicesInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list devices internal server error response has a 2xx status code
func (o *ListDevicesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list devices internal server error response has a 3xx status code
func (o *ListDevicesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list devices internal server error response has a 4xx status code
func (o *ListDevicesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this list devices internal server error response has a 5xx status code
func (o *ListDevicesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this list devices internal server error response a status code equal to that given
func (o *ListDevicesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the list devices internal server error response
func (o *ListDevicesInternalServerError) Code() int {
	return 500
}

func (o *ListDevicesInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /stats][%d] listDevicesInternalServerError %s", 500, payload)
}

func (o *ListDevicesInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /stats][%d] listDevicesInternalServerError %s", 500, payload)
}

func (o *ListDevicesInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListDevicesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
