// Code generated by go-swagger; DO NOT EDIT.

package group_attribute_sync

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetMappedGroupsReader is a Reader for the GetMappedGroups structure.
type GetMappedGroupsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetMappedGroupsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetMappedGroupsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetMappedGroupsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetMappedGroupsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetMappedGroupsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetMappedGroupsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /groupsync/groups] getMappedGroups", response, response.Code())
	}
}

// NewGetMappedGroupsOK creates a GetMappedGroupsOK with default headers values
func NewGetMappedGroupsOK() *GetMappedGroupsOK {
	return &GetMappedGroupsOK{}
}

/*
GetMappedGroupsOK describes a response with status code 200, with default header values.

(empty)
*/
type GetMappedGroupsOK struct {
	Payload *models.GetGroupsResponse
}

// IsSuccess returns true when this get mapped groups Ok response has a 2xx status code
func (o *GetMappedGroupsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get mapped groups Ok response has a 3xx status code
func (o *GetMappedGroupsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get mapped groups Ok response has a 4xx status code
func (o *GetMappedGroupsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get mapped groups Ok response has a 5xx status code
func (o *GetMappedGroupsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get mapped groups Ok response a status code equal to that given
func (o *GetMappedGroupsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get mapped groups Ok response
func (o *GetMappedGroupsOK) Code() int {
	return 200
}

func (o *GetMappedGroupsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups][%d] getMappedGroupsOk %s", 200, payload)
}

func (o *GetMappedGroupsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups][%d] getMappedGroupsOk %s", 200, payload)
}

func (o *GetMappedGroupsOK) GetPayload() *models.GetGroupsResponse {
	return o.Payload
}

func (o *GetMappedGroupsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GetGroupsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMappedGroupsBadRequest creates a GetMappedGroupsBadRequest with default headers values
func NewGetMappedGroupsBadRequest() *GetMappedGroupsBadRequest {
	return &GetMappedGroupsBadRequest{}
}

/*
GetMappedGroupsBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type GetMappedGroupsBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get mapped groups bad request response has a 2xx status code
func (o *GetMappedGroupsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get mapped groups bad request response has a 3xx status code
func (o *GetMappedGroupsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get mapped groups bad request response has a 4xx status code
func (o *GetMappedGroupsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get mapped groups bad request response has a 5xx status code
func (o *GetMappedGroupsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get mapped groups bad request response a status code equal to that given
func (o *GetMappedGroupsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get mapped groups bad request response
func (o *GetMappedGroupsBadRequest) Code() int {
	return 400
}

func (o *GetMappedGroupsBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups][%d] getMappedGroupsBadRequest %s", 400, payload)
}

func (o *GetMappedGroupsBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups][%d] getMappedGroupsBadRequest %s", 400, payload)
}

func (o *GetMappedGroupsBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetMappedGroupsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMappedGroupsUnauthorized creates a GetMappedGroupsUnauthorized with default headers values
func NewGetMappedGroupsUnauthorized() *GetMappedGroupsUnauthorized {
	return &GetMappedGroupsUnauthorized{}
}

/*
GetMappedGroupsUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetMappedGroupsUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get mapped groups unauthorized response has a 2xx status code
func (o *GetMappedGroupsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get mapped groups unauthorized response has a 3xx status code
func (o *GetMappedGroupsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get mapped groups unauthorized response has a 4xx status code
func (o *GetMappedGroupsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get mapped groups unauthorized response has a 5xx status code
func (o *GetMappedGroupsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get mapped groups unauthorized response a status code equal to that given
func (o *GetMappedGroupsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get mapped groups unauthorized response
func (o *GetMappedGroupsUnauthorized) Code() int {
	return 401
}

func (o *GetMappedGroupsUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups][%d] getMappedGroupsUnauthorized %s", 401, payload)
}

func (o *GetMappedGroupsUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups][%d] getMappedGroupsUnauthorized %s", 401, payload)
}

func (o *GetMappedGroupsUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetMappedGroupsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMappedGroupsForbidden creates a GetMappedGroupsForbidden with default headers values
func NewGetMappedGroupsForbidden() *GetMappedGroupsForbidden {
	return &GetMappedGroupsForbidden{}
}

/*
GetMappedGroupsForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetMappedGroupsForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get mapped groups forbidden response has a 2xx status code
func (o *GetMappedGroupsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get mapped groups forbidden response has a 3xx status code
func (o *GetMappedGroupsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get mapped groups forbidden response has a 4xx status code
func (o *GetMappedGroupsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get mapped groups forbidden response has a 5xx status code
func (o *GetMappedGroupsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get mapped groups forbidden response a status code equal to that given
func (o *GetMappedGroupsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get mapped groups forbidden response
func (o *GetMappedGroupsForbidden) Code() int {
	return 403
}

func (o *GetMappedGroupsForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups][%d] getMappedGroupsForbidden %s", 403, payload)
}

func (o *GetMappedGroupsForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups][%d] getMappedGroupsForbidden %s", 403, payload)
}

func (o *GetMappedGroupsForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetMappedGroupsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetMappedGroupsInternalServerError creates a GetMappedGroupsInternalServerError with default headers values
func NewGetMappedGroupsInternalServerError() *GetMappedGroupsInternalServerError {
	return &GetMappedGroupsInternalServerError{}
}

/*
GetMappedGroupsInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetMappedGroupsInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get mapped groups internal server error response has a 2xx status code
func (o *GetMappedGroupsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get mapped groups internal server error response has a 3xx status code
func (o *GetMappedGroupsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get mapped groups internal server error response has a 4xx status code
func (o *GetMappedGroupsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get mapped groups internal server error response has a 5xx status code
func (o *GetMappedGroupsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get mapped groups internal server error response a status code equal to that given
func (o *GetMappedGroupsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get mapped groups internal server error response
func (o *GetMappedGroupsInternalServerError) Code() int {
	return 500
}

func (o *GetMappedGroupsInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups][%d] getMappedGroupsInternalServerError %s", 500, payload)
}

func (o *GetMappedGroupsInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups][%d] getMappedGroupsInternalServerError %s", 500, payload)
}

func (o *GetMappedGroupsInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetMappedGroupsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
