// Code generated by go-swagger; DO NOT EDIT.

package migrations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DeleteSessionReader is a Reader for the DeleteSession structure.
type DeleteSessionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteSessionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 400:
		result := NewDeleteSessionBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewDeleteSessionUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteSessionForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteSessionInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /cloudmigration/migration/{uid}] deleteSession", response, response.Code())
	}
}

// NewDeleteSessionBadRequest creates a DeleteSessionBadRequest with default headers values
func NewDeleteSessionBadRequest() *DeleteSessionBadRequest {
	return &DeleteSessionBadRequest{}
}

/*
DeleteSessionBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type DeleteSessionBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete session bad request response has a 2xx status code
func (o *DeleteSessionBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete session bad request response has a 3xx status code
func (o *DeleteSessionBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete session bad request response has a 4xx status code
func (o *DeleteSessionBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete session bad request response has a 5xx status code
func (o *DeleteSessionBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this delete session bad request response a status code equal to that given
func (o *DeleteSessionBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the delete session bad request response
func (o *DeleteSessionBadRequest) Code() int {
	return 400
}

func (o *DeleteSessionBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cloudmigration/migration/{uid}][%d] deleteSessionBadRequest %s", 400, payload)
}

func (o *DeleteSessionBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cloudmigration/migration/{uid}][%d] deleteSessionBadRequest %s", 400, payload)
}

func (o *DeleteSessionBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteSessionBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteSessionUnauthorized creates a DeleteSessionUnauthorized with default headers values
func NewDeleteSessionUnauthorized() *DeleteSessionUnauthorized {
	return &DeleteSessionUnauthorized{}
}

/*
DeleteSessionUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type DeleteSessionUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete session unauthorized response has a 2xx status code
func (o *DeleteSessionUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete session unauthorized response has a 3xx status code
func (o *DeleteSessionUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete session unauthorized response has a 4xx status code
func (o *DeleteSessionUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete session unauthorized response has a 5xx status code
func (o *DeleteSessionUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this delete session unauthorized response a status code equal to that given
func (o *DeleteSessionUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the delete session unauthorized response
func (o *DeleteSessionUnauthorized) Code() int {
	return 401
}

func (o *DeleteSessionUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cloudmigration/migration/{uid}][%d] deleteSessionUnauthorized %s", 401, payload)
}

func (o *DeleteSessionUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cloudmigration/migration/{uid}][%d] deleteSessionUnauthorized %s", 401, payload)
}

func (o *DeleteSessionUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteSessionUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteSessionForbidden creates a DeleteSessionForbidden with default headers values
func NewDeleteSessionForbidden() *DeleteSessionForbidden {
	return &DeleteSessionForbidden{}
}

/*
DeleteSessionForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type DeleteSessionForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete session forbidden response has a 2xx status code
func (o *DeleteSessionForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete session forbidden response has a 3xx status code
func (o *DeleteSessionForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete session forbidden response has a 4xx status code
func (o *DeleteSessionForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete session forbidden response has a 5xx status code
func (o *DeleteSessionForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete session forbidden response a status code equal to that given
func (o *DeleteSessionForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete session forbidden response
func (o *DeleteSessionForbidden) Code() int {
	return 403
}

func (o *DeleteSessionForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cloudmigration/migration/{uid}][%d] deleteSessionForbidden %s", 403, payload)
}

func (o *DeleteSessionForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cloudmigration/migration/{uid}][%d] deleteSessionForbidden %s", 403, payload)
}

func (o *DeleteSessionForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteSessionForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteSessionInternalServerError creates a DeleteSessionInternalServerError with default headers values
func NewDeleteSessionInternalServerError() *DeleteSessionInternalServerError {
	return &DeleteSessionInternalServerError{}
}

/*
DeleteSessionInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type DeleteSessionInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete session internal server error response has a 2xx status code
func (o *DeleteSessionInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete session internal server error response has a 3xx status code
func (o *DeleteSessionInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete session internal server error response has a 4xx status code
func (o *DeleteSessionInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete session internal server error response has a 5xx status code
func (o *DeleteSessionInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete session internal server error response a status code equal to that given
func (o *DeleteSessionInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete session internal server error response
func (o *DeleteSessionInternalServerError) Code() int {
	return 500
}

func (o *DeleteSessionInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cloudmigration/migration/{uid}][%d] deleteSessionInternalServerError %s", 500, payload)
}

func (o *DeleteSessionInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /cloudmigration/migration/{uid}][%d] deleteSessionInternalServerError %s", 500, payload)
}

func (o *DeleteSessionInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteSessionInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
