// Code generated by go-swagger; DO NOT EDIT.

package query_history

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// StarQueryReader is a Reader for the StarQuery structure.
type StarQueryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *StarQueryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewStarQueryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewStarQueryUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewStarQueryInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /query-history/star/{query_history_uid}] starQuery", response, response.Code())
	}
}

// NewStarQueryOK creates a StarQueryOK with default headers values
func NewStarQueryOK() *StarQueryOK {
	return &StarQueryOK{}
}

/*
StarQueryOK describes a response with status code 200, with default header values.

(empty)
*/
type StarQueryOK struct {
	Payload *models.QueryHistoryResponse
}

// IsSuccess returns true when this star query Ok response has a 2xx status code
func (o *StarQueryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this star query Ok response has a 3xx status code
func (o *StarQueryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this star query Ok response has a 4xx status code
func (o *StarQueryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this star query Ok response has a 5xx status code
func (o *StarQueryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this star query Ok response a status code equal to that given
func (o *StarQueryOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the star query Ok response
func (o *StarQueryOK) Code() int {
	return 200
}

func (o *StarQueryOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /query-history/star/{query_history_uid}][%d] starQueryOk %s", 200, payload)
}

func (o *StarQueryOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /query-history/star/{query_history_uid}][%d] starQueryOk %s", 200, payload)
}

func (o *StarQueryOK) GetPayload() *models.QueryHistoryResponse {
	return o.Payload
}

func (o *StarQueryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QueryHistoryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStarQueryUnauthorized creates a StarQueryUnauthorized with default headers values
func NewStarQueryUnauthorized() *StarQueryUnauthorized {
	return &StarQueryUnauthorized{}
}

/*
StarQueryUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type StarQueryUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this star query unauthorized response has a 2xx status code
func (o *StarQueryUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this star query unauthorized response has a 3xx status code
func (o *StarQueryUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this star query unauthorized response has a 4xx status code
func (o *StarQueryUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this star query unauthorized response has a 5xx status code
func (o *StarQueryUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this star query unauthorized response a status code equal to that given
func (o *StarQueryUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the star query unauthorized response
func (o *StarQueryUnauthorized) Code() int {
	return 401
}

func (o *StarQueryUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /query-history/star/{query_history_uid}][%d] starQueryUnauthorized %s", 401, payload)
}

func (o *StarQueryUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /query-history/star/{query_history_uid}][%d] starQueryUnauthorized %s", 401, payload)
}

func (o *StarQueryUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *StarQueryUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewStarQueryInternalServerError creates a StarQueryInternalServerError with default headers values
func NewStarQueryInternalServerError() *StarQueryInternalServerError {
	return &StarQueryInternalServerError{}
}

/*
StarQueryInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type StarQueryInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this star query internal server error response has a 2xx status code
func (o *StarQueryInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this star query internal server error response has a 3xx status code
func (o *StarQueryInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this star query internal server error response has a 4xx status code
func (o *StarQueryInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this star query internal server error response has a 5xx status code
func (o *StarQueryInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this star query internal server error response a status code equal to that given
func (o *StarQueryInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the star query internal server error response
func (o *StarQueryInternalServerError) Code() int {
	return 500
}

func (o *StarQueryInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /query-history/star/{query_history_uid}][%d] starQueryInternalServerError %s", 500, payload)
}

func (o *StarQueryInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /query-history/star/{query_history_uid}][%d] starQueryInternalServerError %s", 500, payload)
}

func (o *StarQueryInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *StarQueryInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
