// Code generated by go-swagger; DO NOT EDIT.

package saml

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new saml API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for saml API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	GetMetadata(opts ...ClientOption) (*GetMetadataOK, error)
	GetMetadataWithParams(params *GetMetadataParams, opts ...ClientOption) (*GetMetadataOK, error)

	GetSAMLLogout(opts ...ClientOption) error
	GetSAMLLogoutWithParams(params *GetSAMLLogoutParams, opts ...ClientOption) error

	GetSLO(opts ...ClientOption) error
	GetSLOWithParams(params *GetSLOParams, opts ...ClientOption) error

	PostACS(params *PostACSParams, opts ...ClientOption) error

	PostSLO(params *PostSLOParams, opts ...ClientOption) error

	SetTransport(transport runtime.ClientTransport)
}

/*
GetMetadata its exposes the s p grafana s metadata for the Id p s consumption
*/
func (a *Client) GetMetadata(opts ...ClientOption) (*GetMetadataOK, error) {
	params := NewGetMetadataParams()
	return a.GetMetadataWithParams(params, opts...)
}

func (a *Client) GetMetadataWithParams(params *GetMetadataParams, opts ...ClientOption) (*GetMetadataOK, error) {
	if params == nil {
		params = NewGetMetadataParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getMetadata",
		Method:             "GET",
		PathPattern:        "/saml/metadata",
		ProducesMediaTypes: []string{"application/xml;application/samlmetadata+xml"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetMetadataReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetMetadataOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getMetadata: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetSAMLLogout gets logout initiates single logout process
*/
func (a *Client) GetSAMLLogout(opts ...ClientOption) error {
	params := NewGetSAMLLogoutParams()
	return a.GetSAMLLogoutWithParams(params, opts...)
}

func (a *Client) GetSAMLLogoutWithParams(params *GetSAMLLogoutParams, opts ...ClientOption) error {
	if params == nil {
		params = NewGetSAMLLogoutParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getSAMLLogout",
		Method:             "GET",
		PathPattern:        "/logout/saml",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetSAMLLogoutReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	_, err := a.transport.Submit(op)
	if err != nil {
		return err
	}
	return nil
}

/*
GetSLO its performs single logout s l o callback

There might be two possible requests:
1. Logout response (callback) when Grafana initiates single logout and IdP returns response to logout request.
2. Logout request when another SP initiates single logout and IdP sends logout request to the Grafana,
or in case of IdP-initiated logout.
*/
func (a *Client) GetSLO(opts ...ClientOption) error {
	params := NewGetSLOParams()
	return a.GetSLOWithParams(params, opts...)
}

func (a *Client) GetSLOWithParams(params *GetSLOParams, opts ...ClientOption) error {
	if params == nil {
		params = NewGetSLOParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getSLO",
		Method:             "GET",
		PathPattern:        "/saml/slo",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetSLOReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	_, err := a.transport.Submit(op)
	if err != nil {
		return err
	}
	return nil
}

/*
PostACS its performs assertion consumer service a c s
*/

func (a *Client) PostACS(params *PostACSParams, opts ...ClientOption) error {
	if params == nil {
		params = NewPostACSParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "postACS",
		Method:             "POST",
		PathPattern:        "/saml/acs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PostACSReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	_, err := a.transport.Submit(op)
	if err != nil {
		return err
	}
	return nil
}

/*
PostSLO its performs single logout s l o callback

There might be two possible requests:
1. Logout response (callback) when Grafana initiates single logout and IdP returns response to logout request.
2. Logout request when another SP initiates single logout and IdP sends logout request to the Grafana,
or in case of IdP-initiated logout.
*/

func (a *Client) PostSLO(params *PostSLOParams, opts ...ClientOption) error {
	if params == nil {
		params = NewPostSLOParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "postSLO",
		Method:             "POST",
		PathPattern:        "/saml/slo",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &PostSLOReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	_, err := a.transport.Submit(op)
	if err != nil {
		return err
	}
	return nil
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
