// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// QueryStat QueryStat is used for storing arbitrary statistics metadata related to a query and its result, e.g. total request time, data processing time.
//
// The embedded FieldConfig's display name must be set.
// It corresponds to the QueryResultMetaStat on the frontend (https://github.com/grafana/grafana/blob/master/packages/grafana-data/src/types/data.ts#L53).
//
// swagger:model QueryStat
type QueryStat struct {

	// Map values to a display color
	// NOTE: this interface is under development in the frontend... so simple map for now
	Color interface{} `json:"color,omitempty"`

	// Panel Specific Values
	Custom interface{} `json:"custom,omitempty"`

	// decimals
	Decimals uint16 `json:"decimals,omitempty"`

	// Description is human readable field metadata
	Description string `json:"description,omitempty"`

	// DisplayName overrides Grafana default naming, should not be used from a data source
	DisplayName string `json:"displayName,omitempty"`

	// DisplayNameFromDS overrides Grafana default naming strategy.
	DisplayNameFromDS string `json:"displayNameFromDS,omitempty"`

	// Filterable indicates if the Field's data can be filtered by additional calls.
	Filterable bool `json:"filterable,omitempty"`

	// Interval indicates the expected regular step between values in the series.
	// When an interval exists, consumers can identify "missing" values when the expected value is not present.
	// The grafana timeseries visualization will render disconnected values when missing values are found it the time field.
	// The interval uses the same units as the values.  For time.Time, this is defined in milliseconds.
	Interval float64 `json:"interval,omitempty"`

	// The behavior when clicking on a result
	Links []*DataLink `json:"links"`

	// mappings
	Mappings ValueMappings `json:"mappings,omitempty"`

	// max
	Max ConfFloat64 `json:"max,omitempty"`

	// min
	Min ConfFloat64 `json:"min,omitempty"`

	// Alternative to empty string
	NoValue string `json:"noValue,omitempty"`

	// Path is an explicit path to the field in the datasource. When the frame meta includes a path,
	// this will default to `${frame.meta.path}/${field.name}
	//
	// When defined, this value can be used as an identifier within the datasource scope, and
	// may be used as an identifier to update values in a subsequent request
	Path string `json:"path,omitempty"`

	// thresholds
	Thresholds *ThresholdsConfig `json:"thresholds,omitempty"`

	// type
	Type *FieldTypeConfig `json:"type,omitempty"`

	// Numeric Options
	Unit string `json:"unit,omitempty"`

	// value
	Value float64 `json:"value,omitempty"`

	// Writeable indicates that the datasource knows how to update this value
	Writeable bool `json:"writeable,omitempty"`
}

// Validate validates this query stat
func (m *QueryStat) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMappings(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMax(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMin(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThresholds(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QueryStat) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	for i := 0; i < len(m.Links); i++ {
		if swag.IsZero(m.Links[i]) { // not required
			continue
		}

		if m.Links[i] != nil {
			if err := m.Links[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("links" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("links" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *QueryStat) validateMappings(formats strfmt.Registry) error {
	if swag.IsZero(m.Mappings) { // not required
		return nil
	}

	if err := m.Mappings.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("mappings")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("mappings")
		}
		return err
	}

	return nil
}

func (m *QueryStat) validateMax(formats strfmt.Registry) error {
	if swag.IsZero(m.Max) { // not required
		return nil
	}

	if err := m.Max.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("max")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("max")
		}
		return err
	}

	return nil
}

func (m *QueryStat) validateMin(formats strfmt.Registry) error {
	if swag.IsZero(m.Min) { // not required
		return nil
	}

	if err := m.Min.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("min")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("min")
		}
		return err
	}

	return nil
}

func (m *QueryStat) validateThresholds(formats strfmt.Registry) error {
	if swag.IsZero(m.Thresholds) { // not required
		return nil
	}

	if m.Thresholds != nil {
		if err := m.Thresholds.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("thresholds")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("thresholds")
			}
			return err
		}
	}

	return nil
}

func (m *QueryStat) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	if m.Type != nil {
		if err := m.Type.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("type")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this query stat based on the context it is used
func (m *QueryStat) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMappings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMax(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMin(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThresholds(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *QueryStat) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Links); i++ {

		if m.Links[i] != nil {

			if swag.IsZero(m.Links[i]) { // not required
				return nil
			}

			if err := m.Links[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("links" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("links" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *QueryStat) contextValidateMappings(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Mappings.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("mappings")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("mappings")
		}
		return err
	}

	return nil
}

func (m *QueryStat) contextValidateMax(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.Max) { // not required
		return nil
	}

	if err := m.Max.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("max")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("max")
		}
		return err
	}

	return nil
}

func (m *QueryStat) contextValidateMin(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.Min) { // not required
		return nil
	}

	if err := m.Min.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("min")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("min")
		}
		return err
	}

	return nil
}

func (m *QueryStat) contextValidateThresholds(ctx context.Context, formats strfmt.Registry) error {

	if m.Thresholds != nil {

		if swag.IsZero(m.Thresholds) { // not required
			return nil
		}

		if err := m.Thresholds.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("thresholds")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("thresholds")
			}
			return err
		}
	}

	return nil
}

func (m *QueryStat) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if m.Type != nil {

		if swag.IsZero(m.Type) { // not required
			return nil
		}

		if err := m.Type.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("type")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *QueryStat) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *QueryStat) UnmarshalBinary(b []byte) error {
	var res QueryStat
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
