// DO NOT EDIT: This file is autogenerated via the builtin command.

package alerta

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 6,
					Line:   100,
				},
				File:   "alerta.flux",
				Source: "package alerta\n\n\nimport \"http\"\nimport \"json\"\nimport \"strings\"\n\n// alert sends an alert to Alerta.\n// `url` - string - Alerta URL.\n// `apiKey` - string - Alerta API key.\n// `resource` - string - resource under alarm.\n// `event` - string - event name.\n// `environment` - string - environment. Valid values: \"Production\", \"Development\" or empty string (default).\n// `severity` - string - event severity. See https://docs.alerta.io/en/latest/api/alert.html#alert-severities.\n// `service` - arrays of string - list of affected services.\n// `group` - string - event group.\n// `value` - string - event value.\n// `text` - string - text description.\n// `type` - string - event type.\n// `origin` - string - monitoring component.\n// `timestamp` - time - time alert was generated.\n// `timeout` - int - seconds before alert is considered stale.\nalert = (\n        url,\n        apiKey,\n        resource,\n        event,\n        environment=\"\",\n        severity,\n        service=[],\n        group=\"\",\n        value=\"\",\n        text=\"\",\n        tags=[],\n        attributes,\n        origin=\"InfluxDB\",\n        type=\"\",\n        timestamp=now(),\n) => {\n    alert = {\n        resource: resource,\n        event: event,\n        environment: environment,\n        severity: severity,\n        service: service,\n        group: group,\n        value: value,\n        text: text,\n        tags: tags,\n        attributes: attributes,\n        origin: origin,\n        type: type,\n        createTime: strings.substring(v: string(v: timestamp), start: 0, end: 23) + \"Z\",\n    // Alerta supports ISO 8601 date format YYYY-MM-DDThh:mm:ss.sssZ only\n    }\n    headers = {\n        \"Authorization\": \"Key \" + apiKey,\n        \"Content-Type\": \"application/json\",\n    }\n    body = json.encode(v: alert)\n\n    return http.post(headers: headers, url: url, data: body)\n}\n\n// endpoint creates the endpoint for the Alerta.\n// `url` - string - VictorOps REST endpoint URL. No default.\n// `apiKey` - string - Alerta API key.\n// `environment` - string - environment. Valid values: \"Production\", \"Development\" or empty string (default).\n// `origin` - string - monitoring component.\n// The returned factory function accepts a `mapFn` parameter.\n// The `mapFn` must return an object with `resource`, `event`, `severity`, `service`, `group`, `value`, `text`,\n// `tags`, `attributes`, `origin`, `type` and `timestamp` fields as defined in the `alert` function arguments.\nendpoint = (url, apiKey, environment=\"\", origin=\"\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   63,
					},
					File:   "alerta.flux",
					Source: "alert = (\n        url,\n        apiKey,\n        resource,\n        event,\n        environment=\"\",\n        severity,\n        service=[],\n        group=\"\",\n        value=\"\",\n        text=\"\",\n        tags=[],\n        attributes,\n        origin=\"InfluxDB\",\n        type=\"\",\n        timestamp=now(),\n) => {\n    alert = {\n        resource: resource,\n        event: event,\n        environment: environment,\n        severity: severity,\n        service: service,\n        group: group,\n        value: value,\n        text: text,\n        tags: tags,\n        attributes: attributes,\n        origin: origin,\n        type: type,\n        createTime: strings.substring(v: string(v: timestamp), start: 0, end: 23) + \"Z\",\n    // Alerta supports ISO 8601 date format YYYY-MM-DDThh:mm:ss.sssZ only\n    }\n    headers = {\n        \"Authorization\": \"Key \" + apiKey,\n        \"Content-Type\": \"application/json\",\n    }\n    body = json.encode(v: alert)\n\n    return http.post(headers: headers, url: url, data: body)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   23,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// alert sends an alert to Alerta.\n"}, ast.Comment{Text: "// `url` - string - Alerta URL.\n"}, ast.Comment{Text: "// `apiKey` - string - Alerta API key.\n"}, ast.Comment{Text: "// `resource` - string - resource under alarm.\n"}, ast.Comment{Text: "// `event` - string - event name.\n"}, ast.Comment{Text: "// `environment` - string - environment. Valid values: \"Production\", \"Development\" or empty string (default).\n"}, ast.Comment{Text: "// `severity` - string - event severity. See https://docs.alerta.io/en/latest/api/alert.html#alert-severities.\n"}, ast.Comment{Text: "// `service` - arrays of string - list of affected services.\n"}, ast.Comment{Text: "// `group` - string - event group.\n"}, ast.Comment{Text: "// `value` - string - event value.\n"}, ast.Comment{Text: "// `text` - string - text description.\n"}, ast.Comment{Text: "// `type` - string - event type.\n"}, ast.Comment{Text: "// `origin` - string - monitoring component.\n"}, ast.Comment{Text: "// `timestamp` - time - time alert was generated.\n"}, ast.Comment{Text: "// `timeout` - int - seconds before alert is considered stale.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   23,
						},
						File:   "alerta.flux",
						Source: "alert",
						Start: ast.Position{
							Column: 1,
							Line:   23,
						},
					},
				},
				Name: "alert",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   63,
						},
						File:   "alerta.flux",
						Source: "(\n        url,\n        apiKey,\n        resource,\n        event,\n        environment=\"\",\n        severity,\n        service=[],\n        group=\"\",\n        value=\"\",\n        text=\"\",\n        tags=[],\n        attributes,\n        origin=\"InfluxDB\",\n        type=\"\",\n        timestamp=now(),\n) => {\n    alert = {\n        resource: resource,\n        event: event,\n        environment: environment,\n        severity: severity,\n        service: service,\n        group: group,\n        value: value,\n        text: text,\n        tags: tags,\n        attributes: attributes,\n        origin: origin,\n        type: type,\n        createTime: strings.substring(v: string(v: timestamp), start: 0, end: 23) + \"Z\",\n    // Alerta supports ISO 8601 date format YYYY-MM-DDThh:mm:ss.sssZ only\n    }\n    headers = {\n        \"Authorization\": \"Key \" + apiKey,\n        \"Content-Type\": \"application/json\",\n    }\n    body = json.encode(v: alert)\n\n    return http.post(headers: headers, url: url, data: body)\n}",
						Start: ast.Position{
							Column: 9,
							Line:   23,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   63,
							},
							File:   "alerta.flux",
							Source: "{\n    alert = {\n        resource: resource,\n        event: event,\n        environment: environment,\n        severity: severity,\n        service: service,\n        group: group,\n        value: value,\n        text: text,\n        tags: tags,\n        attributes: attributes,\n        origin: origin,\n        type: type,\n        createTime: strings.substring(v: string(v: timestamp), start: 0, end: 23) + \"Z\",\n    // Alerta supports ISO 8601 date format YYYY-MM-DDThh:mm:ss.sssZ only\n    }\n    headers = {\n        \"Authorization\": \"Key \" + apiKey,\n        \"Content-Type\": \"application/json\",\n    }\n    body = json.encode(v: alert)\n\n    return http.post(headers: headers, url: url, data: body)\n}",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   55,
								},
								File:   "alerta.flux",
								Source: "alert = {\n        resource: resource,\n        event: event,\n        environment: environment,\n        severity: severity,\n        service: service,\n        group: group,\n        value: value,\n        text: text,\n        tags: tags,\n        attributes: attributes,\n        origin: origin,\n        type: type,\n        createTime: strings.substring(v: string(v: timestamp), start: 0, end: 23) + \"Z\",\n    // Alerta supports ISO 8601 date format YYYY-MM-DDThh:mm:ss.sssZ only\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   40,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   40,
									},
									File:   "alerta.flux",
									Source: "alert",
									Start: ast.Position{
										Column: 5,
										Line:   40,
									},
								},
							},
							Name: "alert",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   55,
									},
									File:   "alerta.flux",
									Source: "{\n        resource: resource,\n        event: event,\n        environment: environment,\n        severity: severity,\n        service: service,\n        group: group,\n        value: value,\n        text: text,\n        tags: tags,\n        attributes: attributes,\n        origin: origin,\n        type: type,\n        createTime: strings.substring(v: string(v: timestamp), start: 0, end: 23) + \"Z\",\n    // Alerta supports ISO 8601 date format YYYY-MM-DDThh:mm:ss.sssZ only\n    }",
									Start: ast.Position{
										Column: 13,
										Line:   40,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   41,
										},
										File:   "alerta.flux",
										Source: "resource: resource",
										Start: ast.Position{
											Column: 9,
											Line:   41,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   41,
											},
											File:   "alerta.flux",
											Source: "resource",
											Start: ast.Position{
												Column: 9,
												Line:   41,
											},
										},
									},
									Name: "resource",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   41,
											},
											File:   "alerta.flux",
											Source: "resource",
											Start: ast.Position{
												Column: 19,
												Line:   41,
											},
										},
									},
									Name: "resource",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   42,
										},
										File:   "alerta.flux",
										Source: "event: event",
										Start: ast.Position{
											Column: 9,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   42,
											},
											File:   "alerta.flux",
											Source: "event",
											Start: ast.Position{
												Column: 9,
												Line:   42,
											},
										},
									},
									Name: "event",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   42,
											},
											File:   "alerta.flux",
											Source: "event",
											Start: ast.Position{
												Column: 16,
												Line:   42,
											},
										},
									},
									Name: "event",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   43,
										},
										File:   "alerta.flux",
										Source: "environment: environment",
										Start: ast.Position{
											Column: 9,
											Line:   43,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   43,
											},
											File:   "alerta.flux",
											Source: "environment",
											Start: ast.Position{
												Column: 9,
												Line:   43,
											},
										},
									},
									Name: "environment",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   43,
											},
											File:   "alerta.flux",
											Source: "environment",
											Start: ast.Position{
												Column: 22,
												Line:   43,
											},
										},
									},
									Name: "environment",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   44,
										},
										File:   "alerta.flux",
										Source: "severity: severity",
										Start: ast.Position{
											Column: 9,
											Line:   44,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   44,
											},
											File:   "alerta.flux",
											Source: "severity",
											Start: ast.Position{
												Column: 9,
												Line:   44,
											},
										},
									},
									Name: "severity",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   44,
											},
											File:   "alerta.flux",
											Source: "severity",
											Start: ast.Position{
												Column: 19,
												Line:   44,
											},
										},
									},
									Name: "severity",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   45,
										},
										File:   "alerta.flux",
										Source: "service: service",
										Start: ast.Position{
											Column: 9,
											Line:   45,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   45,
											},
											File:   "alerta.flux",
											Source: "service",
											Start: ast.Position{
												Column: 9,
												Line:   45,
											},
										},
									},
									Name: "service",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   45,
											},
											File:   "alerta.flux",
											Source: "service",
											Start: ast.Position{
												Column: 18,
												Line:   45,
											},
										},
									},
									Name: "service",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   46,
										},
										File:   "alerta.flux",
										Source: "group: group",
										Start: ast.Position{
											Column: 9,
											Line:   46,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   46,
											},
											File:   "alerta.flux",
											Source: "group",
											Start: ast.Position{
												Column: 9,
												Line:   46,
											},
										},
									},
									Name: "group",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   46,
											},
											File:   "alerta.flux",
											Source: "group",
											Start: ast.Position{
												Column: 16,
												Line:   46,
											},
										},
									},
									Name: "group",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   47,
										},
										File:   "alerta.flux",
										Source: "value: value",
										Start: ast.Position{
											Column: 9,
											Line:   47,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   47,
											},
											File:   "alerta.flux",
											Source: "value",
											Start: ast.Position{
												Column: 9,
												Line:   47,
											},
										},
									},
									Name: "value",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   47,
											},
											File:   "alerta.flux",
											Source: "value",
											Start: ast.Position{
												Column: 16,
												Line:   47,
											},
										},
									},
									Name: "value",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   48,
										},
										File:   "alerta.flux",
										Source: "text: text",
										Start: ast.Position{
											Column: 9,
											Line:   48,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   48,
											},
											File:   "alerta.flux",
											Source: "text",
											Start: ast.Position{
												Column: 9,
												Line:   48,
											},
										},
									},
									Name: "text",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   48,
											},
											File:   "alerta.flux",
											Source: "text",
											Start: ast.Position{
												Column: 15,
												Line:   48,
											},
										},
									},
									Name: "text",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   49,
										},
										File:   "alerta.flux",
										Source: "tags: tags",
										Start: ast.Position{
											Column: 9,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   49,
											},
											File:   "alerta.flux",
											Source: "tags",
											Start: ast.Position{
												Column: 9,
												Line:   49,
											},
										},
									},
									Name: "tags",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   49,
											},
											File:   "alerta.flux",
											Source: "tags",
											Start: ast.Position{
												Column: 15,
												Line:   49,
											},
										},
									},
									Name: "tags",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   50,
										},
										File:   "alerta.flux",
										Source: "attributes: attributes",
										Start: ast.Position{
											Column: 9,
											Line:   50,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   50,
											},
											File:   "alerta.flux",
											Source: "attributes",
											Start: ast.Position{
												Column: 9,
												Line:   50,
											},
										},
									},
									Name: "attributes",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   50,
											},
											File:   "alerta.flux",
											Source: "attributes",
											Start: ast.Position{
												Column: 21,
												Line:   50,
											},
										},
									},
									Name: "attributes",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   51,
										},
										File:   "alerta.flux",
										Source: "origin: origin",
										Start: ast.Position{
											Column: 9,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   51,
											},
											File:   "alerta.flux",
											Source: "origin",
											Start: ast.Position{
												Column: 9,
												Line:   51,
											},
										},
									},
									Name: "origin",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   51,
											},
											File:   "alerta.flux",
											Source: "origin",
											Start: ast.Position{
												Column: 17,
												Line:   51,
											},
										},
									},
									Name: "origin",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   52,
										},
										File:   "alerta.flux",
										Source: "type: type",
										Start: ast.Position{
											Column: 9,
											Line:   52,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   52,
											},
											File:   "alerta.flux",
											Source: "type",
											Start: ast.Position{
												Column: 9,
												Line:   52,
											},
										},
									},
									Name: "type",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   52,
											},
											File:   "alerta.flux",
											Source: "type",
											Start: ast.Position{
												Column: 15,
												Line:   52,
											},
										},
									},
									Name: "type",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   53,
										},
										File:   "alerta.flux",
										Source: "createTime: strings.substring(v: string(v: timestamp), start: 0, end: 23) + \"Z\"",
										Start: ast.Position{
											Column: 9,
											Line:   53,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   53,
											},
											File:   "alerta.flux",
											Source: "createTime",
											Start: ast.Position{
												Column: 9,
												Line:   53,
											},
										},
									},
									Name: "createTime",
								},
								Separator: nil,
								Value: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 88,
												Line:   53,
											},
											File:   "alerta.flux",
											Source: "strings.substring(v: string(v: timestamp), start: 0, end: 23) + \"Z\"",
											Start: ast.Position{
												Column: 21,
												Line:   53,
											},
										},
									},
									Left: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 81,
														Line:   53,
													},
													File:   "alerta.flux",
													Source: "v: string(v: timestamp), start: 0, end: 23",
													Start: ast.Position{
														Column: 39,
														Line:   53,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   53,
														},
														File:   "alerta.flux",
														Source: "v: string(v: timestamp)",
														Start: ast.Position{
															Column: 39,
															Line:   53,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   53,
															},
															File:   "alerta.flux",
															Source: "v",
															Start: ast.Position{
																Column: 39,
																Line:   53,
															},
														},
													},
													Name: "v",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 61,
																	Line:   53,
																},
																File:   "alerta.flux",
																Source: "v: timestamp",
																Start: ast.Position{
																	Column: 49,
																	Line:   53,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 61,
																		Line:   53,
																	},
																	File:   "alerta.flux",
																	Source: "v: timestamp",
																	Start: ast.Position{
																		Column: 49,
																		Line:   53,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 50,
																			Line:   53,
																		},
																		File:   "alerta.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 49,
																			Line:   53,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 61,
																			Line:   53,
																		},
																		File:   "alerta.flux",
																		Source: "timestamp",
																		Start: ast.Position{
																			Column: 52,
																			Line:   53,
																		},
																	},
																},
																Name: "timestamp",
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 62,
																Line:   53,
															},
															File:   "alerta.flux",
															Source: "string(v: timestamp)",
															Start: ast.Position{
																Column: 42,
																Line:   53,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 48,
																	Line:   53,
																},
																File:   "alerta.flux",
																Source: "string",
																Start: ast.Position{
																	Column: 42,
																	Line:   53,
																},
															},
														},
														Name: "string",
													},
													Lparen: nil,
													Rparen: nil,
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   53,
														},
														File:   "alerta.flux",
														Source: "start: 0",
														Start: ast.Position{
															Column: 64,
															Line:   53,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   53,
															},
															File:   "alerta.flux",
															Source: "start",
															Start: ast.Position{
																Column: 64,
																Line:   53,
															},
														},
													},
													Name: "start",
												},
												Separator: nil,
												Value: &ast.IntegerLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 72,
																Line:   53,
															},
															File:   "alerta.flux",
															Source: "0",
															Start: ast.Position{
																Column: 71,
																Line:   53,
															},
														},
													},
													Value: int64(0),
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 81,
															Line:   53,
														},
														File:   "alerta.flux",
														Source: "end: 23",
														Start: ast.Position{
															Column: 74,
															Line:   53,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   53,
															},
															File:   "alerta.flux",
															Source: "end",
															Start: ast.Position{
																Column: 74,
																Line:   53,
															},
														},
													},
													Name: "end",
												},
												Separator: nil,
												Value: &ast.IntegerLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 81,
																Line:   53,
															},
															File:   "alerta.flux",
															Source: "23",
															Start: ast.Position{
																Column: 79,
																Line:   53,
															},
														},
													},
													Value: int64(23),
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 82,
													Line:   53,
												},
												File:   "alerta.flux",
												Source: "strings.substring(v: string(v: timestamp), start: 0, end: 23)",
												Start: ast.Position{
													Column: 21,
													Line:   53,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   53,
													},
													File:   "alerta.flux",
													Source: "strings.substring",
													Start: ast.Position{
														Column: 21,
														Line:   53,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 28,
															Line:   53,
														},
														File:   "alerta.flux",
														Source: "strings",
														Start: ast.Position{
															Column: 21,
															Line:   53,
														},
													},
												},
												Name: "strings",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   53,
														},
														File:   "alerta.flux",
														Source: "substring",
														Start: ast.Position{
															Column: 29,
															Line:   53,
														},
													},
												},
												Name: "substring",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
									Operator: 5,
									Right: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 88,
													Line:   53,
												},
												File:   "alerta.flux",
												Source: "\"Z\"",
												Start: ast.Position{
													Column: 85,
													Line:   53,
												},
											},
										},
										Value: "Z",
									},
								},
							}},
							Rbrace: []ast.Comment{ast.Comment{Text: "// Alerta supports ISO 8601 date format YYYY-MM-DDThh:mm:ss.sssZ only\n"}},
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   59,
								},
								File:   "alerta.flux",
								Source: "headers = {\n        \"Authorization\": \"Key \" + apiKey,\n        \"Content-Type\": \"application/json\",\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   56,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   56,
									},
									File:   "alerta.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   56,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   59,
									},
									File:   "alerta.flux",
									Source: "{\n        \"Authorization\": \"Key \" + apiKey,\n        \"Content-Type\": \"application/json\",\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   56,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   57,
										},
										File:   "alerta.flux",
										Source: "\"Authorization\": \"Key \" + apiKey",
										Start: ast.Position{
											Column: 9,
											Line:   57,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   57,
											},
											File:   "alerta.flux",
											Source: "\"Authorization\"",
											Start: ast.Position{
												Column: 9,
												Line:   57,
											},
										},
									},
									Value: "Authorization",
								},
								Separator: nil,
								Value: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   57,
											},
											File:   "alerta.flux",
											Source: "\"Key \" + apiKey",
											Start: ast.Position{
												Column: 26,
												Line:   57,
											},
										},
									},
									Left: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   57,
												},
												File:   "alerta.flux",
												Source: "\"Key \"",
												Start: ast.Position{
													Column: 26,
													Line:   57,
												},
											},
										},
										Value: "Key ",
									},
									Operator: 5,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   57,
												},
												File:   "alerta.flux",
												Source: "apiKey",
												Start: ast.Position{
													Column: 35,
													Line:   57,
												},
											},
										},
										Name: "apiKey",
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   58,
										},
										File:   "alerta.flux",
										Source: "\"Content-Type\": \"application/json\"",
										Start: ast.Position{
											Column: 9,
											Line:   58,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   58,
											},
											File:   "alerta.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   58,
											},
										},
									},
									Value: "Content-Type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   58,
											},
											File:   "alerta.flux",
											Source: "\"application/json\"",
											Start: ast.Position{
												Column: 25,
												Line:   58,
											},
										},
									},
									Value: "application/json",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   60,
								},
								File:   "alerta.flux",
								Source: "body = json.encode(v: alert)",
								Start: ast.Position{
									Column: 5,
									Line:   60,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   60,
									},
									File:   "alerta.flux",
									Source: "body",
									Start: ast.Position{
										Column: 5,
										Line:   60,
									},
								},
							},
							Name: "body",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   60,
										},
										File:   "alerta.flux",
										Source: "v: alert",
										Start: ast.Position{
											Column: 24,
											Line:   60,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   60,
											},
											File:   "alerta.flux",
											Source: "v: alert",
											Start: ast.Position{
												Column: 24,
												Line:   60,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   60,
												},
												File:   "alerta.flux",
												Source: "v",
												Start: ast.Position{
													Column: 24,
													Line:   60,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   60,
												},
												File:   "alerta.flux",
												Source: "alert",
												Start: ast.Position{
													Column: 27,
													Line:   60,
												},
											},
										},
										Name: "alert",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   60,
									},
									File:   "alerta.flux",
									Source: "json.encode(v: alert)",
									Start: ast.Position{
										Column: 12,
										Line:   60,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   60,
										},
										File:   "alerta.flux",
										Source: "json.encode",
										Start: ast.Position{
											Column: 12,
											Line:   60,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   60,
											},
											File:   "alerta.flux",
											Source: "json",
											Start: ast.Position{
												Column: 12,
												Line:   60,
											},
										},
									},
									Name: "json",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   60,
											},
											File:   "alerta.flux",
											Source: "encode",
											Start: ast.Position{
												Column: 17,
												Line:   60,
											},
										},
									},
									Name: "encode",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 60,
											Line:   62,
										},
										File:   "alerta.flux",
										Source: "headers: headers, url: url, data: body",
										Start: ast.Position{
											Column: 22,
											Line:   62,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   62,
											},
											File:   "alerta.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   62,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   62,
												},
												File:   "alerta.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   62,
												},
											},
										},
										Name: "headers",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   62,
												},
												File:   "alerta.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   62,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   62,
											},
											File:   "alerta.flux",
											Source: "url: url",
											Start: ast.Position{
												Column: 40,
												Line:   62,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   62,
												},
												File:   "alerta.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   62,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   62,
												},
												File:   "alerta.flux",
												Source: "url",
												Start: ast.Position{
													Column: 45,
													Line:   62,
												},
											},
										},
										Name: "url",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 60,
												Line:   62,
											},
											File:   "alerta.flux",
											Source: "data: body",
											Start: ast.Position{
												Column: 50,
												Line:   62,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   62,
												},
												File:   "alerta.flux",
												Source: "data",
												Start: ast.Position{
													Column: 50,
													Line:   62,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   62,
												},
												File:   "alerta.flux",
												Source: "body",
												Start: ast.Position{
													Column: 56,
													Line:   62,
												},
											},
										},
										Name: "body",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 61,
										Line:   62,
									},
									File:   "alerta.flux",
									Source: "http.post(headers: headers, url: url, data: body)",
									Start: ast.Position{
										Column: 12,
										Line:   62,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   62,
										},
										File:   "alerta.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   62,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   62,
											},
											File:   "alerta.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   62,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   62,
											},
											File:   "alerta.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   62,
											},
										},
									},
									Name: "post",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   62,
								},
								File:   "alerta.flux",
								Source: "return http.post(headers: headers, url: url, data: body)",
								Start: ast.Position{
									Column: 5,
									Line:   62,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   24,
							},
							File:   "alerta.flux",
							Source: "url",
							Start: ast.Position{
								Column: 9,
								Line:   24,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   24,
								},
								File:   "alerta.flux",
								Source: "url",
								Start: ast.Position{
									Column: 9,
									Line:   24,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   25,
							},
							File:   "alerta.flux",
							Source: "apiKey",
							Start: ast.Position{
								Column: 9,
								Line:   25,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   25,
								},
								File:   "alerta.flux",
								Source: "apiKey",
								Start: ast.Position{
									Column: 9,
									Line:   25,
								},
							},
						},
						Name: "apiKey",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   26,
							},
							File:   "alerta.flux",
							Source: "resource",
							Start: ast.Position{
								Column: 9,
								Line:   26,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   26,
								},
								File:   "alerta.flux",
								Source: "resource",
								Start: ast.Position{
									Column: 9,
									Line:   26,
								},
							},
						},
						Name: "resource",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   27,
							},
							File:   "alerta.flux",
							Source: "event",
							Start: ast.Position{
								Column: 9,
								Line:   27,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   27,
								},
								File:   "alerta.flux",
								Source: "event",
								Start: ast.Position{
									Column: 9,
									Line:   27,
								},
							},
						},
						Name: "event",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   28,
							},
							File:   "alerta.flux",
							Source: "environment=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   28,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   28,
								},
								File:   "alerta.flux",
								Source: "environment",
								Start: ast.Position{
									Column: 9,
									Line:   28,
								},
							},
						},
						Name: "environment",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   28,
								},
								File:   "alerta.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 21,
									Line:   28,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   29,
							},
							File:   "alerta.flux",
							Source: "severity",
							Start: ast.Position{
								Column: 9,
								Line:   29,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   29,
								},
								File:   "alerta.flux",
								Source: "severity",
								Start: ast.Position{
									Column: 9,
									Line:   29,
								},
							},
						},
						Name: "severity",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   30,
							},
							File:   "alerta.flux",
							Source: "service=[]",
							Start: ast.Position{
								Column: 9,
								Line:   30,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   30,
								},
								File:   "alerta.flux",
								Source: "service",
								Start: ast.Position{
									Column: 9,
									Line:   30,
								},
							},
						},
						Name: "service",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   30,
								},
								File:   "alerta.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 17,
									Line:   30,
								},
							},
						},
						Elements: []ast.Expression{},
						Lbrack:   nil,
						Rbrack:   nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   31,
							},
							File:   "alerta.flux",
							Source: "group=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   31,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   31,
								},
								File:   "alerta.flux",
								Source: "group",
								Start: ast.Position{
									Column: 9,
									Line:   31,
								},
							},
						},
						Name: "group",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   31,
								},
								File:   "alerta.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 15,
									Line:   31,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   32,
							},
							File:   "alerta.flux",
							Source: "value=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   32,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   32,
								},
								File:   "alerta.flux",
								Source: "value",
								Start: ast.Position{
									Column: 9,
									Line:   32,
								},
							},
						},
						Name: "value",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   32,
								},
								File:   "alerta.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 15,
									Line:   32,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   33,
							},
							File:   "alerta.flux",
							Source: "text=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   33,
								},
								File:   "alerta.flux",
								Source: "text",
								Start: ast.Position{
									Column: 9,
									Line:   33,
								},
							},
						},
						Name: "text",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   33,
								},
								File:   "alerta.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 14,
									Line:   33,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   34,
							},
							File:   "alerta.flux",
							Source: "tags=[]",
							Start: ast.Position{
								Column: 9,
								Line:   34,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   34,
								},
								File:   "alerta.flux",
								Source: "tags",
								Start: ast.Position{
									Column: 9,
									Line:   34,
								},
							},
						},
						Name: "tags",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   34,
								},
								File:   "alerta.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 14,
									Line:   34,
								},
							},
						},
						Elements: []ast.Expression{},
						Lbrack:   nil,
						Rbrack:   nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   35,
							},
							File:   "alerta.flux",
							Source: "attributes",
							Start: ast.Position{
								Column: 9,
								Line:   35,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   35,
								},
								File:   "alerta.flux",
								Source: "attributes",
								Start: ast.Position{
									Column: 9,
									Line:   35,
								},
							},
						},
						Name: "attributes",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   36,
							},
							File:   "alerta.flux",
							Source: "origin=\"InfluxDB\"",
							Start: ast.Position{
								Column: 9,
								Line:   36,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   36,
								},
								File:   "alerta.flux",
								Source: "origin",
								Start: ast.Position{
									Column: 9,
									Line:   36,
								},
							},
						},
						Name: "origin",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   36,
								},
								File:   "alerta.flux",
								Source: "\"InfluxDB\"",
								Start: ast.Position{
									Column: 16,
									Line:   36,
								},
							},
						},
						Value: "InfluxDB",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   37,
							},
							File:   "alerta.flux",
							Source: "type=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   37,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   37,
								},
								File:   "alerta.flux",
								Source: "type",
								Start: ast.Position{
									Column: 9,
									Line:   37,
								},
							},
						},
						Name: "type",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   37,
								},
								File:   "alerta.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 14,
									Line:   37,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   38,
							},
							File:   "alerta.flux",
							Source: "timestamp=now()",
							Start: ast.Position{
								Column: 9,
								Line:   38,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   38,
								},
								File:   "alerta.flux",
								Source: "timestamp",
								Start: ast.Position{
									Column: 9,
									Line:   38,
								},
							},
						},
						Name: "timestamp",
					},
					Separator: nil,
					Value: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   38,
								},
								File:   "alerta.flux",
								Source: "now()",
								Start: ast.Position{
									Column: 19,
									Line:   38,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   38,
									},
									File:   "alerta.flux",
									Source: "now",
									Start: ast.Position{
										Column: 19,
										Line:   38,
									},
								},
							},
							Name: "now",
						},
						Lparen: nil,
						Rparen: nil,
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   100,
					},
					File:   "alerta.flux",
					Source: "endpoint = (url, apiKey, environment=\"\", origin=\"\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   73,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// endpoint creates the endpoint for the Alerta.\n"}, ast.Comment{Text: "// `url` - string - VictorOps REST endpoint URL. No default.\n"}, ast.Comment{Text: "// `apiKey` - string - Alerta API key.\n"}, ast.Comment{Text: "// `environment` - string - environment. Valid values: \"Production\", \"Development\" or empty string (default).\n"}, ast.Comment{Text: "// `origin` - string - monitoring component.\n"}, ast.Comment{Text: "// The returned factory function accepts a `mapFn` parameter.\n"}, ast.Comment{Text: "// The `mapFn` must return an object with `resource`, `event`, `severity`, `service`, `group`, `value`, `text`,\n"}, ast.Comment{Text: "// `tags`, `attributes`, `origin`, `type` and `timestamp` fields as defined in the `alert` function arguments.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   73,
						},
						File:   "alerta.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   73,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   100,
						},
						File:   "alerta.flux",
						Source: "(url, apiKey, environment=\"\", origin=\"\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
						Start: ast.Position{
							Column: 12,
							Line:   73,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   100,
							},
							File:   "alerta.flux",
							Source: "(mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
							Start: ast.Position{
								Column: 56,
								Line:   73,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   100,
								},
								File:   "alerta.flux",
								Source: "(tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
								Start: ast.Position{
									Column: 67,
									Line:   73,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   73,
										},
										File:   "alerta.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 82,
											Line:   73,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   100,
									},
									File:   "alerta.flux",
									Source: "tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
									Start: ast.Position{
										Column: 82,
										Line:   73,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   99,
											},
											File:   "alerta.flux",
											Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        }",
											Start: ast.Position{
												Column: 9,
												Line:   75,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   99,
												},
												File:   "alerta.flux",
												Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        }",
												Start: ast.Position{
													Column: 9,
													Line:   75,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   75,
													},
													File:   "alerta.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 9,
														Line:   75,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   99,
													},
													File:   "alerta.flux",
													Source: "(r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        }",
													Start: ast.Position{
														Column: 13,
														Line:   75,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   99,
														},
														File:   "alerta.flux",
														Source: "{\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        }",
														Start: ast.Position{
															Column: 20,
															Line:   75,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   76,
															},
															File:   "alerta.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 13,
																Line:   76,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 16,
																	Line:   76,
																},
																File:   "alerta.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 13,
																	Line:   76,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 29,
																		Line:   76,
																	},
																	File:   "alerta.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   76,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 29,
																			Line:   76,
																		},
																		File:   "alerta.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 25,
																			Line:   76,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 26,
																				Line:   76,
																			},
																			File:   "alerta.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 25,
																				Line:   76,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   76,
																			},
																			File:   "alerta.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 28,
																				Line:   76,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   76,
																},
																File:   "alerta.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 19,
																	Line:   76,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   76,
																	},
																	File:   "alerta.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 19,
																		Line:   76,
																	},
																},
															},
															Name: "mapFn",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   98,
																},
																File:   "alerta.flux",
																Source: "{r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }",
																Start: ast.Position{
																	Column: 20,
																	Line:   78,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   97,
																	},
																	File:   "alerta.flux",
																	Source: "_sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                )",
																	Start: ast.Position{
																		Column: 17,
																		Line:   79,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   79,
																		},
																		File:   "alerta.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 17,
																			Line:   79,
																		},
																	},
																},
																Name: "_sent",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   96,
																			},
																			File:   "alerta.flux",
																			Source: "v: 2 == alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100",
																			Start: ast.Position{
																				Column: 21,
																				Line:   80,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   96,
																				},
																				File:   "alerta.flux",
																				Source: "v: 2 == alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100",
																				Start: ast.Position{
																					Column: 21,
																					Line:   80,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 22,
																						Line:   80,
																					},
																					File:   "alerta.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 21,
																						Line:   80,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 28,
																						Line:   96,
																					},
																					File:   "alerta.flux",
																					Source: "2 == alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100",
																					Start: ast.Position{
																						Column: 24,
																						Line:   80,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   80,
																						},
																						File:   "alerta.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 24,
																							Line:   80,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 28,
																							Line:   96,
																						},
																						File:   "alerta.flux",
																						Source: "alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100",
																						Start: ast.Position{
																							Column: 29,
																							Line:   80,
																						},
																					},
																				},
																				Left: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 49,
																									Line:   95,
																								},
																								File:   "alerta.flux",
																								Source: "url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp",
																								Start: ast.Position{
																									Column: 25,
																									Line:   81,
																								},
																							},
																						},
																						Lbrace: nil,
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 33,
																										Line:   81,
																									},
																									File:   "alerta.flux",
																									Source: "url: url",
																									Start: ast.Position{
																										Column: 25,
																										Line:   81,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   81,
																										},
																										File:   "alerta.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 25,
																											Line:   81,
																										},
																									},
																								},
																								Name: "url",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   81,
																										},
																										File:   "alerta.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 30,
																											Line:   81,
																										},
																									},
																								},
																								Name: "url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   82,
																									},
																									File:   "alerta.flux",
																									Source: "apiKey: apiKey",
																									Start: ast.Position{
																										Column: 25,
																										Line:   82,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 31,
																											Line:   82,
																										},
																										File:   "alerta.flux",
																										Source: "apiKey",
																										Start: ast.Position{
																											Column: 25,
																											Line:   82,
																										},
																									},
																								},
																								Name: "apiKey",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   82,
																										},
																										File:   "alerta.flux",
																										Source: "apiKey",
																										Start: ast.Position{
																											Column: 33,
																											Line:   82,
																										},
																									},
																								},
																								Name: "apiKey",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 47,
																										Line:   83,
																									},
																									File:   "alerta.flux",
																									Source: "resource: obj.resource",
																									Start: ast.Position{
																										Column: 25,
																										Line:   83,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   83,
																										},
																										File:   "alerta.flux",
																										Source: "resource",
																										Start: ast.Position{
																											Column: 25,
																											Line:   83,
																										},
																									},
																								},
																								Name: "resource",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 47,
																											Line:   83,
																										},
																										File:   "alerta.flux",
																										Source: "obj.resource",
																										Start: ast.Position{
																											Column: 35,
																											Line:   83,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 38,
																												Line:   83,
																											},
																											File:   "alerta.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 35,
																												Line:   83,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 47,
																												Line:   83,
																											},
																											File:   "alerta.flux",
																											Source: "resource",
																											Start: ast.Position{
																												Column: 39,
																												Line:   83,
																											},
																										},
																									},
																									Name: "resource",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 41,
																										Line:   84,
																									},
																									File:   "alerta.flux",
																									Source: "event: obj.event",
																									Start: ast.Position{
																										Column: 25,
																										Line:   84,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   84,
																										},
																										File:   "alerta.flux",
																										Source: "event",
																										Start: ast.Position{
																											Column: 25,
																											Line:   84,
																										},
																									},
																								},
																								Name: "event",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   84,
																										},
																										File:   "alerta.flux",
																										Source: "obj.event",
																										Start: ast.Position{
																											Column: 32,
																											Line:   84,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 35,
																												Line:   84,
																											},
																											File:   "alerta.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 32,
																												Line:   84,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   84,
																											},
																											File:   "alerta.flux",
																											Source: "event",
																											Start: ast.Position{
																												Column: 36,
																												Line:   84,
																											},
																										},
																									},
																									Name: "event",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 49,
																										Line:   85,
																									},
																									File:   "alerta.flux",
																									Source: "environment: environment",
																									Start: ast.Position{
																										Column: 25,
																										Line:   85,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 36,
																											Line:   85,
																										},
																										File:   "alerta.flux",
																										Source: "environment",
																										Start: ast.Position{
																											Column: 25,
																											Line:   85,
																										},
																									},
																								},
																								Name: "environment",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 49,
																											Line:   85,
																										},
																										File:   "alerta.flux",
																										Source: "environment",
																										Start: ast.Position{
																											Column: 38,
																											Line:   85,
																										},
																									},
																								},
																								Name: "environment",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 47,
																										Line:   86,
																									},
																									File:   "alerta.flux",
																									Source: "severity: obj.severity",
																									Start: ast.Position{
																										Column: 25,
																										Line:   86,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   86,
																										},
																										File:   "alerta.flux",
																										Source: "severity",
																										Start: ast.Position{
																											Column: 25,
																											Line:   86,
																										},
																									},
																								},
																								Name: "severity",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 47,
																											Line:   86,
																										},
																										File:   "alerta.flux",
																										Source: "obj.severity",
																										Start: ast.Position{
																											Column: 35,
																											Line:   86,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 38,
																												Line:   86,
																											},
																											File:   "alerta.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 35,
																												Line:   86,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 47,
																												Line:   86,
																											},
																											File:   "alerta.flux",
																											Source: "severity",
																											Start: ast.Position{
																												Column: 39,
																												Line:   86,
																											},
																										},
																									},
																									Name: "severity",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 45,
																										Line:   87,
																									},
																									File:   "alerta.flux",
																									Source: "service: obj.service",
																									Start: ast.Position{
																										Column: 25,
																										Line:   87,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 32,
																											Line:   87,
																										},
																										File:   "alerta.flux",
																										Source: "service",
																										Start: ast.Position{
																											Column: 25,
																											Line:   87,
																										},
																									},
																								},
																								Name: "service",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   87,
																										},
																										File:   "alerta.flux",
																										Source: "obj.service",
																										Start: ast.Position{
																											Column: 34,
																											Line:   87,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 37,
																												Line:   87,
																											},
																											File:   "alerta.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 34,
																												Line:   87,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   87,
																											},
																											File:   "alerta.flux",
																											Source: "service",
																											Start: ast.Position{
																												Column: 38,
																												Line:   87,
																											},
																										},
																									},
																									Name: "service",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 41,
																										Line:   88,
																									},
																									File:   "alerta.flux",
																									Source: "group: obj.group",
																									Start: ast.Position{
																										Column: 25,
																										Line:   88,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   88,
																										},
																										File:   "alerta.flux",
																										Source: "group",
																										Start: ast.Position{
																											Column: 25,
																											Line:   88,
																										},
																									},
																								},
																								Name: "group",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   88,
																										},
																										File:   "alerta.flux",
																										Source: "obj.group",
																										Start: ast.Position{
																											Column: 32,
																											Line:   88,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 35,
																												Line:   88,
																											},
																											File:   "alerta.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 32,
																												Line:   88,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   88,
																											},
																											File:   "alerta.flux",
																											Source: "group",
																											Start: ast.Position{
																												Column: 36,
																												Line:   88,
																											},
																										},
																									},
																									Name: "group",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 41,
																										Line:   89,
																									},
																									File:   "alerta.flux",
																									Source: "value: obj.value",
																									Start: ast.Position{
																										Column: 25,
																										Line:   89,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   89,
																										},
																										File:   "alerta.flux",
																										Source: "value",
																										Start: ast.Position{
																											Column: 25,
																											Line:   89,
																										},
																									},
																								},
																								Name: "value",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   89,
																										},
																										File:   "alerta.flux",
																										Source: "obj.value",
																										Start: ast.Position{
																											Column: 32,
																											Line:   89,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 35,
																												Line:   89,
																											},
																											File:   "alerta.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 32,
																												Line:   89,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   89,
																											},
																											File:   "alerta.flux",
																											Source: "value",
																											Start: ast.Position{
																												Column: 36,
																												Line:   89,
																											},
																										},
																									},
																									Name: "value",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   90,
																									},
																									File:   "alerta.flux",
																									Source: "text: obj.text",
																									Start: ast.Position{
																										Column: 25,
																										Line:   90,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   90,
																										},
																										File:   "alerta.flux",
																										Source: "text",
																										Start: ast.Position{
																											Column: 25,
																											Line:   90,
																										},
																									},
																								},
																								Name: "text",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   90,
																										},
																										File:   "alerta.flux",
																										Source: "obj.text",
																										Start: ast.Position{
																											Column: 31,
																											Line:   90,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 34,
																												Line:   90,
																											},
																											File:   "alerta.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 31,
																												Line:   90,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   90,
																											},
																											File:   "alerta.flux",
																											Source: "text",
																											Start: ast.Position{
																												Column: 35,
																												Line:   90,
																											},
																										},
																									},
																									Name: "text",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   91,
																									},
																									File:   "alerta.flux",
																									Source: "tags: obj.tags",
																									Start: ast.Position{
																										Column: 25,
																										Line:   91,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   91,
																										},
																										File:   "alerta.flux",
																										Source: "tags",
																										Start: ast.Position{
																											Column: 25,
																											Line:   91,
																										},
																									},
																								},
																								Name: "tags",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   91,
																										},
																										File:   "alerta.flux",
																										Source: "obj.tags",
																										Start: ast.Position{
																											Column: 31,
																											Line:   91,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 34,
																												Line:   91,
																											},
																											File:   "alerta.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 31,
																												Line:   91,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   91,
																											},
																											File:   "alerta.flux",
																											Source: "tags",
																											Start: ast.Position{
																												Column: 35,
																												Line:   91,
																											},
																										},
																									},
																									Name: "tags",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 51,
																										Line:   92,
																									},
																									File:   "alerta.flux",
																									Source: "attributes: obj.attributes",
																									Start: ast.Position{
																										Column: 25,
																										Line:   92,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 35,
																											Line:   92,
																										},
																										File:   "alerta.flux",
																										Source: "attributes",
																										Start: ast.Position{
																											Column: 25,
																											Line:   92,
																										},
																									},
																								},
																								Name: "attributes",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 51,
																											Line:   92,
																										},
																										File:   "alerta.flux",
																										Source: "obj.attributes",
																										Start: ast.Position{
																											Column: 37,
																											Line:   92,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 40,
																												Line:   92,
																											},
																											File:   "alerta.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 37,
																												Line:   92,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 51,
																												Line:   92,
																											},
																											File:   "alerta.flux",
																											Source: "attributes",
																											Start: ast.Position{
																												Column: 41,
																												Line:   92,
																											},
																										},
																									},
																									Name: "attributes",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   93,
																									},
																									File:   "alerta.flux",
																									Source: "origin: origin",
																									Start: ast.Position{
																										Column: 25,
																										Line:   93,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 31,
																											Line:   93,
																										},
																										File:   "alerta.flux",
																										Source: "origin",
																										Start: ast.Position{
																											Column: 25,
																											Line:   93,
																										},
																									},
																								},
																								Name: "origin",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   93,
																										},
																										File:   "alerta.flux",
																										Source: "origin",
																										Start: ast.Position{
																											Column: 33,
																											Line:   93,
																										},
																									},
																								},
																								Name: "origin",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   94,
																									},
																									File:   "alerta.flux",
																									Source: "type: obj.type",
																									Start: ast.Position{
																										Column: 25,
																										Line:   94,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   94,
																										},
																										File:   "alerta.flux",
																										Source: "type",
																										Start: ast.Position{
																											Column: 25,
																											Line:   94,
																										},
																									},
																								},
																								Name: "type",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   94,
																										},
																										File:   "alerta.flux",
																										Source: "obj.type",
																										Start: ast.Position{
																											Column: 31,
																											Line:   94,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 34,
																												Line:   94,
																											},
																											File:   "alerta.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 31,
																												Line:   94,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   94,
																											},
																											File:   "alerta.flux",
																											Source: "type",
																											Start: ast.Position{
																												Column: 35,
																												Line:   94,
																											},
																										},
																									},
																									Name: "type",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 49,
																										Line:   95,
																									},
																									File:   "alerta.flux",
																									Source: "timestamp: obj.timestamp",
																									Start: ast.Position{
																										Column: 25,
																										Line:   95,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 34,
																											Line:   95,
																										},
																										File:   "alerta.flux",
																										Source: "timestamp",
																										Start: ast.Position{
																											Column: 25,
																											Line:   95,
																										},
																									},
																								},
																								Name: "timestamp",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 49,
																											Line:   95,
																										},
																										File:   "alerta.flux",
																										Source: "obj.timestamp",
																										Start: ast.Position{
																											Column: 36,
																											Line:   95,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   95,
																											},
																											File:   "alerta.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 36,
																												Line:   95,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 49,
																												Line:   95,
																											},
																											File:   "alerta.flux",
																											Source: "timestamp",
																											Start: ast.Position{
																												Column: 40,
																												Line:   95,
																											},
																										},
																									},
																									Name: "timestamp",
																								},
																								Rbrack: nil,
																							},
																						}},
																						Rbrace: nil,
																						With:   nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 22,
																								Line:   96,
																							},
																							File:   "alerta.flux",
																							Source: "alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    )",
																							Start: ast.Position{
																								Column: 29,
																								Line:   80,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 34,
																									Line:   80,
																								},
																								File:   "alerta.flux",
																								Source: "alert",
																								Start: ast.Position{
																									Column: 29,
																									Line:   80,
																								},
																							},
																						},
																						Name: "alert",
																					},
																					Lparen: nil,
																					Rparen: nil,
																				},
																				Operator: 2,
																				Right: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 28,
																								Line:   96,
																							},
																							File:   "alerta.flux",
																							Source: "100",
																							Start: ast.Position{
																								Column: 25,
																								Line:   96,
																							},
																						},
																					},
																					Value: int64(100),
																				},
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   97,
																		},
																		File:   "alerta.flux",
																		Source: "string(\n                    v: 2 == alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                )",
																		Start: ast.Position{
																			Column: 24,
																			Line:   79,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   79,
																			},
																			File:   "alerta.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 24,
																				Line:   79,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   78,
																	},
																	File:   "alerta.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   78,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   98,
															},
															File:   "alerta.flux",
															Source: "return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }",
															Start: ast.Position{
																Column: 13,
																Line:   78,
															},
														},
													},
												}},
												Lbrace: nil,
												Rbrace: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   75,
														},
														File:   "alerta.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   75,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   75,
															},
															File:   "alerta.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   75,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   100,
										},
										File:   "alerta.flux",
										Source: "map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        apiKey: apiKey,\n                        resource: obj.resource,\n                        event: obj.event,\n                        environment: environment,\n                        severity: obj.severity,\n                        service: obj.service,\n                        group: obj.group,\n                        value: obj.value,\n                        text: obj.text,\n                        tags: obj.tags,\n                        attributes: obj.attributes,\n                        origin: origin,\n                        type: obj.type,\n                        timestamp: obj.timestamp,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   74,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   74,
											},
											File:   "alerta.flux",
											Source: "map",
											Start: ast.Position{
												Column: 8,
												Line:   74,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 77,
										Line:   73,
									},
									File:   "alerta.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 68,
										Line:   73,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   73,
										},
										File:   "alerta.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 68,
											Line:   73,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 77,
										Line:   73,
									},
									File:   "alerta.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 75,
										Line:   73,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   73,
								},
								File:   "alerta.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 57,
									Line:   73,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   73,
									},
									File:   "alerta.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 57,
										Line:   73,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   73,
							},
							File:   "alerta.flux",
							Source: "url",
							Start: ast.Position{
								Column: 13,
								Line:   73,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   73,
								},
								File:   "alerta.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   73,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   73,
							},
							File:   "alerta.flux",
							Source: "apiKey",
							Start: ast.Position{
								Column: 18,
								Line:   73,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   73,
								},
								File:   "alerta.flux",
								Source: "apiKey",
								Start: ast.Position{
									Column: 18,
									Line:   73,
								},
							},
						},
						Name: "apiKey",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   73,
							},
							File:   "alerta.flux",
							Source: "environment=\"\"",
							Start: ast.Position{
								Column: 26,
								Line:   73,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   73,
								},
								File:   "alerta.flux",
								Source: "environment",
								Start: ast.Position{
									Column: 26,
									Line:   73,
								},
							},
						},
						Name: "environment",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   73,
								},
								File:   "alerta.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 38,
									Line:   73,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 51,
								Line:   73,
							},
							File:   "alerta.flux",
							Source: "origin=\"\"",
							Start: ast.Position{
								Column: 42,
								Line:   73,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   73,
								},
								File:   "alerta.flux",
								Source: "origin",
								Start: ast.Position{
									Column: 42,
									Line:   73,
								},
							},
						},
						Name: "origin",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   73,
								},
								File:   "alerta.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 49,
									Line:   73,
								},
							},
						},
						Value: "",
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "alerta.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "alerta.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "alerta.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "alerta.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "json",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   6,
					},
					File:   "alerta.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   6,
						},
						File:   "alerta.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "alerta.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   1,
					},
					File:   "alerta.flux",
					Source: "package alerta",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   1,
						},
						File:   "alerta.flux",
						Source: "alerta",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "alerta",
			},
		},
	}},
	Package: "alerta",
	Path:    "contrib/bonitoo-io/alerta",
}
