// DO NOT EDIT: This file is autogenerated via the builtin command.

package victorops

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 6,
					Line:   65,
				},
				File:   "victorops.flux",
				Source: "package victorops\n\n\nimport \"http\"\nimport \"json\"\n\n// `alert` sends an alert to VictorOps.\n// `url` - string - VictorOps REST endpoint URL. No default.\n// `messageType` - string - Alert behaviour. Valid values: \"CRITICAL\", \"WARNING\", \"INFO\".\n// `entityID` - string - Incident ID.\n// `entityDisplayName` - string - Incident summary.\n// `stateMessage` - string - Incident verbose message.\n// `timestamp` - time - Incident timestamp. Default value: now().\n// `monitoringTool` - string - Monitoring agent name. Default value: \"InfluxDB\".\nalert = (\n        url,\n        messageType,\n        entityID=\"\",\n        entityDisplayName=\"\",\n        stateMessage=\"\",\n        timestamp=now(),\n        monitoringTool=\"InfluxDB\",\n) => {\n    alert = {\n        message_type: messageType,\n        entity_id: entityID,\n        entity_display_name: entityDisplayName,\n        state_message: stateMessage,\n        // required in seconds\n        state_start_time: uint(v: timestamp) / uint(v: 1000000000),\n        monitoring_tool: monitoringTool,\n    }\n    headers = {\n        \"Content-Type\": \"application/json\",\n    }\n    body = json.encode(v: alert)\n\n    return http.post(headers: headers, url: url, data: body)\n}\n\n// `endpoint` creates the endpoint for the VictorOps.\n// `url` - string - VictorOps REST endpoint URL. No default.\n// The returned factory function accepts a `mapFn` parameter.\n// `monitoringTool` - string - Monitoring agent name. Default value: \"InfluxDB\".\n// The `mapFn` must return an object with `messageType`, `entityID`, `entityDisplayName`, `stateMessage`, `timestamp` fields as defined in the `alert` function arguments.\nendpoint = (url, monitoringTool=\"InfluxDB\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   39,
					},
					File:   "victorops.flux",
					Source: "alert = (\n        url,\n        messageType,\n        entityID=\"\",\n        entityDisplayName=\"\",\n        stateMessage=\"\",\n        timestamp=now(),\n        monitoringTool=\"InfluxDB\",\n) => {\n    alert = {\n        message_type: messageType,\n        entity_id: entityID,\n        entity_display_name: entityDisplayName,\n        state_message: stateMessage,\n        // required in seconds\n        state_start_time: uint(v: timestamp) / uint(v: 1000000000),\n        monitoring_tool: monitoringTool,\n    }\n    headers = {\n        \"Content-Type\": \"application/json\",\n    }\n    body = json.encode(v: alert)\n\n    return http.post(headers: headers, url: url, data: body)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   15,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `alert` sends an alert to VictorOps.\n"}, ast.Comment{Text: "// `url` - string - VictorOps REST endpoint URL. No default.\n"}, ast.Comment{Text: "// `messageType` - string - Alert behaviour. Valid values: \"CRITICAL\", \"WARNING\", \"INFO\".\n"}, ast.Comment{Text: "// `entityID` - string - Incident ID.\n"}, ast.Comment{Text: "// `entityDisplayName` - string - Incident summary.\n"}, ast.Comment{Text: "// `stateMessage` - string - Incident verbose message.\n"}, ast.Comment{Text: "// `timestamp` - time - Incident timestamp. Default value: now().\n"}, ast.Comment{Text: "// `monitoringTool` - string - Monitoring agent name. Default value: \"InfluxDB\".\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   15,
						},
						File:   "victorops.flux",
						Source: "alert",
						Start: ast.Position{
							Column: 1,
							Line:   15,
						},
					},
				},
				Name: "alert",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   39,
						},
						File:   "victorops.flux",
						Source: "(\n        url,\n        messageType,\n        entityID=\"\",\n        entityDisplayName=\"\",\n        stateMessage=\"\",\n        timestamp=now(),\n        monitoringTool=\"InfluxDB\",\n) => {\n    alert = {\n        message_type: messageType,\n        entity_id: entityID,\n        entity_display_name: entityDisplayName,\n        state_message: stateMessage,\n        // required in seconds\n        state_start_time: uint(v: timestamp) / uint(v: 1000000000),\n        monitoring_tool: monitoringTool,\n    }\n    headers = {\n        \"Content-Type\": \"application/json\",\n    }\n    body = json.encode(v: alert)\n\n    return http.post(headers: headers, url: url, data: body)\n}",
						Start: ast.Position{
							Column: 9,
							Line:   15,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   39,
							},
							File:   "victorops.flux",
							Source: "{\n    alert = {\n        message_type: messageType,\n        entity_id: entityID,\n        entity_display_name: entityDisplayName,\n        state_message: stateMessage,\n        // required in seconds\n        state_start_time: uint(v: timestamp) / uint(v: 1000000000),\n        monitoring_tool: monitoringTool,\n    }\n    headers = {\n        \"Content-Type\": \"application/json\",\n    }\n    body = json.encode(v: alert)\n\n    return http.post(headers: headers, url: url, data: body)\n}",
							Start: ast.Position{
								Column: 6,
								Line:   23,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   32,
								},
								File:   "victorops.flux",
								Source: "alert = {\n        message_type: messageType,\n        entity_id: entityID,\n        entity_display_name: entityDisplayName,\n        state_message: stateMessage,\n        // required in seconds\n        state_start_time: uint(v: timestamp) / uint(v: 1000000000),\n        monitoring_tool: monitoringTool,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   24,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   24,
									},
									File:   "victorops.flux",
									Source: "alert",
									Start: ast.Position{
										Column: 5,
										Line:   24,
									},
								},
							},
							Name: "alert",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   32,
									},
									File:   "victorops.flux",
									Source: "{\n        message_type: messageType,\n        entity_id: entityID,\n        entity_display_name: entityDisplayName,\n        state_message: stateMessage,\n        // required in seconds\n        state_start_time: uint(v: timestamp) / uint(v: 1000000000),\n        monitoring_tool: monitoringTool,\n    }",
									Start: ast.Position{
										Column: 13,
										Line:   24,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   25,
										},
										File:   "victorops.flux",
										Source: "message_type: messageType",
										Start: ast.Position{
											Column: 9,
											Line:   25,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   25,
											},
											File:   "victorops.flux",
											Source: "message_type",
											Start: ast.Position{
												Column: 9,
												Line:   25,
											},
										},
									},
									Name: "message_type",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   25,
											},
											File:   "victorops.flux",
											Source: "messageType",
											Start: ast.Position{
												Column: 23,
												Line:   25,
											},
										},
									},
									Name: "messageType",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   26,
										},
										File:   "victorops.flux",
										Source: "entity_id: entityID",
										Start: ast.Position{
											Column: 9,
											Line:   26,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   26,
											},
											File:   "victorops.flux",
											Source: "entity_id",
											Start: ast.Position{
												Column: 9,
												Line:   26,
											},
										},
									},
									Name: "entity_id",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   26,
											},
											File:   "victorops.flux",
											Source: "entityID",
											Start: ast.Position{
												Column: 20,
												Line:   26,
											},
										},
									},
									Name: "entityID",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   27,
										},
										File:   "victorops.flux",
										Source: "entity_display_name: entityDisplayName",
										Start: ast.Position{
											Column: 9,
											Line:   27,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   27,
											},
											File:   "victorops.flux",
											Source: "entity_display_name",
											Start: ast.Position{
												Column: 9,
												Line:   27,
											},
										},
									},
									Name: "entity_display_name",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   27,
											},
											File:   "victorops.flux",
											Source: "entityDisplayName",
											Start: ast.Position{
												Column: 30,
												Line:   27,
											},
										},
									},
									Name: "entityDisplayName",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   28,
										},
										File:   "victorops.flux",
										Source: "state_message: stateMessage",
										Start: ast.Position{
											Column: 9,
											Line:   28,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   28,
											},
											File:   "victorops.flux",
											Source: "state_message",
											Start: ast.Position{
												Column: 9,
												Line:   28,
											},
										},
									},
									Name: "state_message",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   28,
											},
											File:   "victorops.flux",
											Source: "stateMessage",
											Start: ast.Position{
												Column: 24,
												Line:   28,
											},
										},
									},
									Name: "stateMessage",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   30,
										},
										File:   "victorops.flux",
										Source: "state_start_time: uint(v: timestamp) / uint(v: 1000000000)",
										Start: ast.Position{
											Column: 9,
											Line:   30,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: []ast.Comment{ast.Comment{Text: "// required in seconds\n"}},
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   30,
											},
											File:   "victorops.flux",
											Source: "state_start_time",
											Start: ast.Position{
												Column: 9,
												Line:   30,
											},
										},
									},
									Name: "state_start_time",
								},
								Separator: nil,
								Value: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   30,
											},
											File:   "victorops.flux",
											Source: "uint(v: timestamp) / uint(v: 1000000000)",
											Start: ast.Position{
												Column: 27,
												Line:   30,
											},
										},
									},
									Left: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   30,
													},
													File:   "victorops.flux",
													Source: "v: timestamp",
													Start: ast.Position{
														Column: 32,
														Line:   30,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   30,
														},
														File:   "victorops.flux",
														Source: "v: timestamp",
														Start: ast.Position{
															Column: 32,
															Line:   30,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 33,
																Line:   30,
															},
															File:   "victorops.flux",
															Source: "v",
															Start: ast.Position{
																Column: 32,
																Line:   30,
															},
														},
													},
													Name: "v",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 44,
																Line:   30,
															},
															File:   "victorops.flux",
															Source: "timestamp",
															Start: ast.Position{
																Column: 35,
																Line:   30,
															},
														},
													},
													Name: "timestamp",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   30,
												},
												File:   "victorops.flux",
												Source: "uint(v: timestamp)",
												Start: ast.Position{
													Column: 27,
													Line:   30,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   30,
													},
													File:   "victorops.flux",
													Source: "uint",
													Start: ast.Position{
														Column: 27,
														Line:   30,
													},
												},
											},
											Name: "uint",
										},
										Lparen: nil,
										Rparen: nil,
									},
									Operator: 2,
									Right: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   30,
													},
													File:   "victorops.flux",
													Source: "v: 1000000000",
													Start: ast.Position{
														Column: 53,
														Line:   30,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 66,
															Line:   30,
														},
														File:   "victorops.flux",
														Source: "v: 1000000000",
														Start: ast.Position{
															Column: 53,
															Line:   30,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 54,
																Line:   30,
															},
															File:   "victorops.flux",
															Source: "v",
															Start: ast.Position{
																Column: 53,
																Line:   30,
															},
														},
													},
													Name: "v",
												},
												Separator: nil,
												Value: &ast.IntegerLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 66,
																Line:   30,
															},
															File:   "victorops.flux",
															Source: "1000000000",
															Start: ast.Position{
																Column: 56,
																Line:   30,
															},
														},
													},
													Value: int64(1000000000),
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   30,
												},
												File:   "victorops.flux",
												Source: "uint(v: 1000000000)",
												Start: ast.Position{
													Column: 48,
													Line:   30,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 52,
														Line:   30,
													},
													File:   "victorops.flux",
													Source: "uint",
													Start: ast.Position{
														Column: 48,
														Line:   30,
													},
												},
											},
											Name: "uint",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   31,
										},
										File:   "victorops.flux",
										Source: "monitoring_tool: monitoringTool",
										Start: ast.Position{
											Column: 9,
											Line:   31,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   31,
											},
											File:   "victorops.flux",
											Source: "monitoring_tool",
											Start: ast.Position{
												Column: 9,
												Line:   31,
											},
										},
									},
									Name: "monitoring_tool",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   31,
											},
											File:   "victorops.flux",
											Source: "monitoringTool",
											Start: ast.Position{
												Column: 26,
												Line:   31,
											},
										},
									},
									Name: "monitoringTool",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   35,
								},
								File:   "victorops.flux",
								Source: "headers = {\n        \"Content-Type\": \"application/json\",\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   33,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   33,
									},
									File:   "victorops.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   33,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   35,
									},
									File:   "victorops.flux",
									Source: "{\n        \"Content-Type\": \"application/json\",\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   33,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   34,
										},
										File:   "victorops.flux",
										Source: "\"Content-Type\": \"application/json\"",
										Start: ast.Position{
											Column: 9,
											Line:   34,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   34,
											},
											File:   "victorops.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   34,
											},
										},
									},
									Value: "Content-Type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   34,
											},
											File:   "victorops.flux",
											Source: "\"application/json\"",
											Start: ast.Position{
												Column: 25,
												Line:   34,
											},
										},
									},
									Value: "application/json",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   36,
								},
								File:   "victorops.flux",
								Source: "body = json.encode(v: alert)",
								Start: ast.Position{
									Column: 5,
									Line:   36,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   36,
									},
									File:   "victorops.flux",
									Source: "body",
									Start: ast.Position{
										Column: 5,
										Line:   36,
									},
								},
							},
							Name: "body",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   36,
										},
										File:   "victorops.flux",
										Source: "v: alert",
										Start: ast.Position{
											Column: 24,
											Line:   36,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   36,
											},
											File:   "victorops.flux",
											Source: "v: alert",
											Start: ast.Position{
												Column: 24,
												Line:   36,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   36,
												},
												File:   "victorops.flux",
												Source: "v",
												Start: ast.Position{
													Column: 24,
													Line:   36,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 32,
													Line:   36,
												},
												File:   "victorops.flux",
												Source: "alert",
												Start: ast.Position{
													Column: 27,
													Line:   36,
												},
											},
										},
										Name: "alert",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   36,
									},
									File:   "victorops.flux",
									Source: "json.encode(v: alert)",
									Start: ast.Position{
										Column: 12,
										Line:   36,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   36,
										},
										File:   "victorops.flux",
										Source: "json.encode",
										Start: ast.Position{
											Column: 12,
											Line:   36,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   36,
											},
											File:   "victorops.flux",
											Source: "json",
											Start: ast.Position{
												Column: 12,
												Line:   36,
											},
										},
									},
									Name: "json",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   36,
											},
											File:   "victorops.flux",
											Source: "encode",
											Start: ast.Position{
												Column: 17,
												Line:   36,
											},
										},
									},
									Name: "encode",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 60,
											Line:   38,
										},
										File:   "victorops.flux",
										Source: "headers: headers, url: url, data: body",
										Start: ast.Position{
											Column: 22,
											Line:   38,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   38,
											},
											File:   "victorops.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   38,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   38,
												},
												File:   "victorops.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   38,
												},
											},
										},
										Name: "headers",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   38,
												},
												File:   "victorops.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   38,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   38,
											},
											File:   "victorops.flux",
											Source: "url: url",
											Start: ast.Position{
												Column: 40,
												Line:   38,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   38,
												},
												File:   "victorops.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   38,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   38,
												},
												File:   "victorops.flux",
												Source: "url",
												Start: ast.Position{
													Column: 45,
													Line:   38,
												},
											},
										},
										Name: "url",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 60,
												Line:   38,
											},
											File:   "victorops.flux",
											Source: "data: body",
											Start: ast.Position{
												Column: 50,
												Line:   38,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   38,
												},
												File:   "victorops.flux",
												Source: "data",
												Start: ast.Position{
													Column: 50,
													Line:   38,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   38,
												},
												File:   "victorops.flux",
												Source: "body",
												Start: ast.Position{
													Column: 56,
													Line:   38,
												},
											},
										},
										Name: "body",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 61,
										Line:   38,
									},
									File:   "victorops.flux",
									Source: "http.post(headers: headers, url: url, data: body)",
									Start: ast.Position{
										Column: 12,
										Line:   38,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   38,
										},
										File:   "victorops.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   38,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   38,
											},
											File:   "victorops.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   38,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   38,
											},
											File:   "victorops.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   38,
											},
										},
									},
									Name: "post",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   38,
								},
								File:   "victorops.flux",
								Source: "return http.post(headers: headers, url: url, data: body)",
								Start: ast.Position{
									Column: 5,
									Line:   38,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   16,
							},
							File:   "victorops.flux",
							Source: "url",
							Start: ast.Position{
								Column: 9,
								Line:   16,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   16,
								},
								File:   "victorops.flux",
								Source: "url",
								Start: ast.Position{
									Column: 9,
									Line:   16,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   17,
							},
							File:   "victorops.flux",
							Source: "messageType",
							Start: ast.Position{
								Column: 9,
								Line:   17,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   17,
								},
								File:   "victorops.flux",
								Source: "messageType",
								Start: ast.Position{
									Column: 9,
									Line:   17,
								},
							},
						},
						Name: "messageType",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   18,
							},
							File:   "victorops.flux",
							Source: "entityID=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   18,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   18,
								},
								File:   "victorops.flux",
								Source: "entityID",
								Start: ast.Position{
									Column: 9,
									Line:   18,
								},
							},
						},
						Name: "entityID",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   18,
								},
								File:   "victorops.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 18,
									Line:   18,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   19,
							},
							File:   "victorops.flux",
							Source: "entityDisplayName=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   19,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   19,
								},
								File:   "victorops.flux",
								Source: "entityDisplayName",
								Start: ast.Position{
									Column: 9,
									Line:   19,
								},
							},
						},
						Name: "entityDisplayName",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   19,
								},
								File:   "victorops.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 27,
									Line:   19,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   20,
							},
							File:   "victorops.flux",
							Source: "stateMessage=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   20,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   20,
								},
								File:   "victorops.flux",
								Source: "stateMessage",
								Start: ast.Position{
									Column: 9,
									Line:   20,
								},
							},
						},
						Name: "stateMessage",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   20,
								},
								File:   "victorops.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 22,
									Line:   20,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   21,
							},
							File:   "victorops.flux",
							Source: "timestamp=now()",
							Start: ast.Position{
								Column: 9,
								Line:   21,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   21,
								},
								File:   "victorops.flux",
								Source: "timestamp",
								Start: ast.Position{
									Column: 9,
									Line:   21,
								},
							},
						},
						Name: "timestamp",
					},
					Separator: nil,
					Value: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   21,
								},
								File:   "victorops.flux",
								Source: "now()",
								Start: ast.Position{
									Column: 19,
									Line:   21,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   21,
									},
									File:   "victorops.flux",
									Source: "now",
									Start: ast.Position{
										Column: 19,
										Line:   21,
									},
								},
							},
							Name: "now",
						},
						Lparen: nil,
						Rparen: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   22,
							},
							File:   "victorops.flux",
							Source: "monitoringTool=\"InfluxDB\"",
							Start: ast.Position{
								Column: 9,
								Line:   22,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   22,
								},
								File:   "victorops.flux",
								Source: "monitoringTool",
								Start: ast.Position{
									Column: 9,
									Line:   22,
								},
							},
						},
						Name: "monitoringTool",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   22,
								},
								File:   "victorops.flux",
								Source: "\"InfluxDB\"",
								Start: ast.Position{
									Column: 24,
									Line:   22,
								},
							},
						},
						Value: "InfluxDB",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   65,
					},
					File:   "victorops.flux",
					Source: "endpoint = (url, monitoringTool=\"InfluxDB\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// `endpoint` creates the endpoint for the VictorOps.\n"}, ast.Comment{Text: "// `url` - string - VictorOps REST endpoint URL. No default.\n"}, ast.Comment{Text: "// The returned factory function accepts a `mapFn` parameter.\n"}, ast.Comment{Text: "// `monitoringTool` - string - Monitoring agent name. Default value: \"InfluxDB\".\n"}, ast.Comment{Text: "// The `mapFn` must return an object with `messageType`, `entityID`, `entityDisplayName`, `stateMessage`, `timestamp` fields as defined in the `alert` function arguments.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   46,
						},
						File:   "victorops.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   65,
						},
						File:   "victorops.flux",
						Source: "(url, monitoringTool=\"InfluxDB\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
						Start: ast.Position{
							Column: 12,
							Line:   46,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   65,
							},
							File:   "victorops.flux",
							Source: "(mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
							Start: ast.Position{
								Column: 48,
								Line:   46,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   65,
								},
								File:   "victorops.flux",
								Source: "(tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
								Start: ast.Position{
									Column: 59,
									Line:   46,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   46,
										},
										File:   "victorops.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 74,
											Line:   46,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   65,
									},
									File:   "victorops.flux",
									Source: "tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
									Start: ast.Position{
										Column: 74,
										Line:   46,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   64,
											},
											File:   "victorops.flux",
											Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100,\n                ),\n            }\n        }",
											Start: ast.Position{
												Column: 9,
												Line:   48,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   64,
												},
												File:   "victorops.flux",
												Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100,\n                ),\n            }\n        }",
												Start: ast.Position{
													Column: 9,
													Line:   48,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   48,
													},
													File:   "victorops.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 9,
														Line:   48,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   64,
													},
													File:   "victorops.flux",
													Source: "(r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100,\n                ),\n            }\n        }",
													Start: ast.Position{
														Column: 13,
														Line:   48,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   64,
														},
														File:   "victorops.flux",
														Source: "{\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100,\n                ),\n            }\n        }",
														Start: ast.Position{
															Column: 20,
															Line:   48,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   49,
															},
															File:   "victorops.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 13,
																Line:   49,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 16,
																	Line:   49,
																},
																File:   "victorops.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 13,
																	Line:   49,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 29,
																		Line:   49,
																	},
																	File:   "victorops.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   49,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 29,
																			Line:   49,
																		},
																		File:   "victorops.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 25,
																			Line:   49,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 26,
																				Line:   49,
																			},
																			File:   "victorops.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 25,
																				Line:   49,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   49,
																			},
																			File:   "victorops.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 28,
																				Line:   49,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   49,
																},
																File:   "victorops.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 19,
																	Line:   49,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   49,
																	},
																	File:   "victorops.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 19,
																		Line:   49,
																	},
																},
															},
															Name: "mapFn",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   63,
																},
																File:   "victorops.flux",
																Source: "{r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100,\n                ),\n            }",
																Start: ast.Position{
																	Column: 20,
																	Line:   51,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   62,
																	},
																	File:   "victorops.flux",
																	Source: "_sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100,\n                )",
																	Start: ast.Position{
																		Column: 17,
																		Line:   52,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   52,
																		},
																		File:   "victorops.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 17,
																			Line:   52,
																		},
																	},
																},
																Name: "_sent",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   61,
																			},
																			File:   "victorops.flux",
																			Source: "v: 2 == alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100",
																			Start: ast.Position{
																				Column: 21,
																				Line:   53,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   61,
																				},
																				File:   "victorops.flux",
																				Source: "v: 2 == alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100",
																				Start: ast.Position{
																					Column: 21,
																					Line:   53,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 22,
																						Line:   53,
																					},
																					File:   "victorops.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 21,
																						Line:   53,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 28,
																						Line:   61,
																					},
																					File:   "victorops.flux",
																					Source: "2 == alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100",
																					Start: ast.Position{
																						Column: 24,
																						Line:   53,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   53,
																						},
																						File:   "victorops.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 24,
																							Line:   53,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 28,
																							Line:   61,
																						},
																						File:   "victorops.flux",
																						Source: "alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100",
																						Start: ast.Position{
																							Column: 29,
																							Line:   53,
																						},
																					},
																				},
																				Left: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 55,
																									Line:   60,
																								},
																								File:   "victorops.flux",
																								Source: "url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool",
																								Start: ast.Position{
																									Column: 25,
																									Line:   54,
																								},
																							},
																						},
																						Lbrace: nil,
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 33,
																										Line:   54,
																									},
																									File:   "victorops.flux",
																									Source: "url: url",
																									Start: ast.Position{
																										Column: 25,
																										Line:   54,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   54,
																										},
																										File:   "victorops.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 25,
																											Line:   54,
																										},
																									},
																								},
																								Name: "url",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   54,
																										},
																										File:   "victorops.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 30,
																											Line:   54,
																										},
																									},
																								},
																								Name: "url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 53,
																										Line:   55,
																									},
																									File:   "victorops.flux",
																									Source: "messageType: obj.messageType",
																									Start: ast.Position{
																										Column: 25,
																										Line:   55,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 36,
																											Line:   55,
																										},
																										File:   "victorops.flux",
																										Source: "messageType",
																										Start: ast.Position{
																											Column: 25,
																											Line:   55,
																										},
																									},
																								},
																								Name: "messageType",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 53,
																											Line:   55,
																										},
																										File:   "victorops.flux",
																										Source: "obj.messageType",
																										Start: ast.Position{
																											Column: 38,
																											Line:   55,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   55,
																											},
																											File:   "victorops.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 38,
																												Line:   55,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 53,
																												Line:   55,
																											},
																											File:   "victorops.flux",
																											Source: "messageType",
																											Start: ast.Position{
																												Column: 42,
																												Line:   55,
																											},
																										},
																									},
																									Name: "messageType",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 47,
																										Line:   56,
																									},
																									File:   "victorops.flux",
																									Source: "entityID: obj.entityID",
																									Start: ast.Position{
																										Column: 25,
																										Line:   56,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   56,
																										},
																										File:   "victorops.flux",
																										Source: "entityID",
																										Start: ast.Position{
																											Column: 25,
																											Line:   56,
																										},
																									},
																								},
																								Name: "entityID",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 47,
																											Line:   56,
																										},
																										File:   "victorops.flux",
																										Source: "obj.entityID",
																										Start: ast.Position{
																											Column: 35,
																											Line:   56,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 38,
																												Line:   56,
																											},
																											File:   "victorops.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 35,
																												Line:   56,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 47,
																												Line:   56,
																											},
																											File:   "victorops.flux",
																											Source: "entityID",
																											Start: ast.Position{
																												Column: 39,
																												Line:   56,
																											},
																										},
																									},
																									Name: "entityID",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 65,
																										Line:   57,
																									},
																									File:   "victorops.flux",
																									Source: "entityDisplayName: obj.entityDisplayName",
																									Start: ast.Position{
																										Column: 25,
																										Line:   57,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 42,
																											Line:   57,
																										},
																										File:   "victorops.flux",
																										Source: "entityDisplayName",
																										Start: ast.Position{
																											Column: 25,
																											Line:   57,
																										},
																									},
																								},
																								Name: "entityDisplayName",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 65,
																											Line:   57,
																										},
																										File:   "victorops.flux",
																										Source: "obj.entityDisplayName",
																										Start: ast.Position{
																											Column: 44,
																											Line:   57,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 47,
																												Line:   57,
																											},
																											File:   "victorops.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 44,
																												Line:   57,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 65,
																												Line:   57,
																											},
																											File:   "victorops.flux",
																											Source: "entityDisplayName",
																											Start: ast.Position{
																												Column: 48,
																												Line:   57,
																											},
																										},
																									},
																									Name: "entityDisplayName",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 55,
																										Line:   58,
																									},
																									File:   "victorops.flux",
																									Source: "stateMessage: obj.stateMessage",
																									Start: ast.Position{
																										Column: 25,
																										Line:   58,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 37,
																											Line:   58,
																										},
																										File:   "victorops.flux",
																										Source: "stateMessage",
																										Start: ast.Position{
																											Column: 25,
																											Line:   58,
																										},
																									},
																								},
																								Name: "stateMessage",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 55,
																											Line:   58,
																										},
																										File:   "victorops.flux",
																										Source: "obj.stateMessage",
																										Start: ast.Position{
																											Column: 39,
																											Line:   58,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 42,
																												Line:   58,
																											},
																											File:   "victorops.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 39,
																												Line:   58,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 55,
																												Line:   58,
																											},
																											File:   "victorops.flux",
																											Source: "stateMessage",
																											Start: ast.Position{
																												Column: 43,
																												Line:   58,
																											},
																										},
																									},
																									Name: "stateMessage",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 49,
																										Line:   59,
																									},
																									File:   "victorops.flux",
																									Source: "timestamp: obj.timestamp",
																									Start: ast.Position{
																										Column: 25,
																										Line:   59,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 34,
																											Line:   59,
																										},
																										File:   "victorops.flux",
																										Source: "timestamp",
																										Start: ast.Position{
																											Column: 25,
																											Line:   59,
																										},
																									},
																								},
																								Name: "timestamp",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 49,
																											Line:   59,
																										},
																										File:   "victorops.flux",
																										Source: "obj.timestamp",
																										Start: ast.Position{
																											Column: 36,
																											Line:   59,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   59,
																											},
																											File:   "victorops.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 36,
																												Line:   59,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 49,
																												Line:   59,
																											},
																											File:   "victorops.flux",
																											Source: "timestamp",
																											Start: ast.Position{
																												Column: 40,
																												Line:   59,
																											},
																										},
																									},
																									Name: "timestamp",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 55,
																										Line:   60,
																									},
																									File:   "victorops.flux",
																									Source: "monitoringTool: monitoringTool",
																									Start: ast.Position{
																										Column: 25,
																										Line:   60,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   60,
																										},
																										File:   "victorops.flux",
																										Source: "monitoringTool",
																										Start: ast.Position{
																											Column: 25,
																											Line:   60,
																										},
																									},
																								},
																								Name: "monitoringTool",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 55,
																											Line:   60,
																										},
																										File:   "victorops.flux",
																										Source: "monitoringTool",
																										Start: ast.Position{
																											Column: 41,
																											Line:   60,
																										},
																									},
																								},
																								Name: "monitoringTool",
																							},
																						}},
																						Rbrace: nil,
																						With:   nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 22,
																								Line:   61,
																							},
																							File:   "victorops.flux",
																							Source: "alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    )",
																							Start: ast.Position{
																								Column: 29,
																								Line:   53,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 34,
																									Line:   53,
																								},
																								File:   "victorops.flux",
																								Source: "alert",
																								Start: ast.Position{
																									Column: 29,
																									Line:   53,
																								},
																							},
																						},
																						Name: "alert",
																					},
																					Lparen: nil,
																					Rparen: nil,
																				},
																				Operator: 2,
																				Right: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 28,
																								Line:   61,
																							},
																							File:   "victorops.flux",
																							Source: "100",
																							Start: ast.Position{
																								Column: 25,
																								Line:   61,
																							},
																						},
																					},
																					Value: int64(100),
																				},
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   62,
																		},
																		File:   "victorops.flux",
																		Source: "string(\n                    v: 2 == alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100,\n                )",
																		Start: ast.Position{
																			Column: 24,
																			Line:   52,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   52,
																			},
																			File:   "victorops.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 24,
																				Line:   52,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   51,
																	},
																	File:   "victorops.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   51,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   63,
															},
															File:   "victorops.flux",
															Source: "return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100,\n                ),\n            }",
															Start: ast.Position{
																Column: 13,
																Line:   51,
															},
														},
													},
												}},
												Lbrace: nil,
												Rbrace: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   48,
														},
														File:   "victorops.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   48,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   48,
															},
															File:   "victorops.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   48,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   65,
										},
										File:   "victorops.flux",
										Source: "map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == alert(\n                        url: url,\n                        messageType: obj.messageType,\n                        entityID: obj.entityID,\n                        entityDisplayName: obj.entityDisplayName,\n                        stateMessage: obj.stateMessage,\n                        timestamp: obj.timestamp,\n                        monitoringTool: monitoringTool,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   47,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   47,
											},
											File:   "victorops.flux",
											Source: "map",
											Start: ast.Position{
												Column: 8,
												Line:   47,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   46,
									},
									File:   "victorops.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 60,
										Line:   46,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   46,
										},
										File:   "victorops.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 60,
											Line:   46,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   46,
									},
									File:   "victorops.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 67,
										Line:   46,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   46,
								},
								File:   "victorops.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 49,
									Line:   46,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   46,
									},
									File:   "victorops.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 49,
										Line:   46,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   46,
							},
							File:   "victorops.flux",
							Source: "url",
							Start: ast.Position{
								Column: 13,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   46,
								},
								File:   "victorops.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   46,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   46,
							},
							File:   "victorops.flux",
							Source: "monitoringTool=\"InfluxDB\"",
							Start: ast.Position{
								Column: 18,
								Line:   46,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   46,
								},
								File:   "victorops.flux",
								Source: "monitoringTool",
								Start: ast.Position{
									Column: 18,
									Line:   46,
								},
							},
						},
						Name: "monitoringTool",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   46,
								},
								File:   "victorops.flux",
								Source: "\"InfluxDB\"",
								Start: ast.Position{
									Column: 33,
									Line:   46,
								},
							},
						},
						Value: "InfluxDB",
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "victorops.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "victorops.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "victorops.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "victorops.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "json",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "victorops.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "victorops.flux",
					Source: "package victorops",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "victorops.flux",
						Source: "victorops",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "victorops",
			},
		},
	}},
	Package: "victorops",
	Path:    "contrib/bonitoo-io/victorops",
}
