# Sensu Package

Use this Flux Package to send an event to [Sensu Go](https://docs.sensu.io/sensu-go/latest/).

## sensu.event

`event` function sends a single event to Sensu as described in https://docs.sensu.io/sensu-go/latest/api/events/#create-a-new-event API. 

Arguments:

| Name     | Type   | Description                                                       |
| ----     | ----   | -----------                                                       |
| url | string | base URL of [Sensu API](https://docs.sensu.io/sensu-go/latest/migrate/#architecture) without a trailing slash, for example "http://localhost:8080", required. |
| apiKey  | string | Sensu [API Key](https://docs.sensu.io/sensu-go/latest/operations/control-access/), required. |
| checkName | string | Check name, it can contain [a-zA-Z0-9_.\-] characters, other characters are replaced by underscore. Required. 
| text | string | The event text (named output in a Sensu Event), required. |
| handlers | array<string> | Sensu handlers to execute, optional. |
| status | int | The event status, 0 (default) indicates "OK", 1 indicates "WARNING", 2 indicates "CRITICAL", any other value indicates an “UNKNOWN” or custom status. Defaults to 0. |
| state | string | The event state can be "failing", "passing" or "flapping". Defaults to "passing" for 0 status, "failing" otherwise. |
| namespace | string | The Sensu namespace. Defaults to "default". |
| entityName | string | Source of the event, it can contain [a-zA-Z0-9_.\-] characters, other characters are replaced by underscore. Defaults to "influxdb". |

Basic Example:

    import "contrib/sranka/sensu"
    import "influxdata/influxdb/secrets"

    //this value can be stored in the secret-store()
    apiKey = secrets.get(key: "SENSU_API_KEY")

    lastReported =
      from(bucket: "example-bucket")
        |> range(start: -1m)
        |> filter(fn: (r) => r._measurement == "statuses")
        |> last()
        |> tableFind(fn: (key) => true)
        |> getRecord(idx: 0)

    sensu.event(
      url: "http://localhost:8080",
      apiKey: apiKey,
      checkName: "diskUsage",
      text: "Great Scott!- Disk usage is: ${lastReported.status}."
    )

## sensu.endpoint 

`endpoint` function creates a factory function that accepts a mapping function `mapFn` and creates a target function for pipeline `|>` that sends events from table rows. The `mapFn` accepts a table row and returns an object with `checkName`, `text`, and `status` as defined in the `sensu.event` function arguments. Arguments:

| Name     | Type   | Description                                                       |
| ----     | ----   | -----------                                                       |
| url | string | base URL of [Sensu API](https://docs.sensu.io/sensu-go/latest/migrate/#architecture) without a trailing slash, for example "http://localhost:8080", required. |
| apiKey  | string | Sensu [API Key](https://docs.sensu.io/sensu-go/latest/operations/control-access/), required. |
| handlers | array<string> | Sensu handlers to execute, optional. |
| namespace | string | The Sensu namespace. Defaults to "default". |
| entityName | string | Source of the event, it can contain [a-zA-Z0-9_.\-] characters, other characters are replaced by underscore. Defaults to "influxdb". |

Basic Example:

    import "contrib/sranka/sensu"
    import "influxdata/influxdb/secrets"

    // this value can be stored in the secret-store()
    apiKey = secrets.get(key: "SENSU_API_KEY")

    lastReported =
    from(bucket: "example-bucket")
      |> range(start: -1m)
      |> filter(fn: (r) => r._measurement == "statuses")
      |> last()
      |> tableFind(fn: (key) => true)
      |> sensu.endpoint(url: "http://localhost:8080", apiKey: apiKey)(mapFn: (r) => ({
              checkName: "diskUsage", 
              text: "Great Scott!- Disk usage is: **${r.status}**.", 
              status: 0
            })
         )()


## Contact

- Author: Pavel Zavora
- Email: pavel.zavora@bonitoo.io
- Github: [@sranka](https://github.com/sranka)
- Influx Slack: [@sranka](https://influxdata.com/slack)
