// DO NOT EDIT: This file is autogenerated via the builtin command.

package promql

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 25,
					Line:   133,
				},
				File:   "promql.flux",
				Source: "package promql\n\n\nimport \"math\"\nimport \"universe\"\nimport \"experimental\"\n\n// changes() implements functionality equivalent to PromQL's changes() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#changes\nbuiltin changes : (<-tables: [{A with _value: float}]) => [{B with _value: float}]\n\n// promqlDayOfMonth() implements functionality equivalent to PromQL's day_of_month() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#day_of_month\nbuiltin promqlDayOfMonth : (timestamp: float) => float\n\n// promqlDayOfWeek() implements functionality equivalent to PromQL's day_of_week() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#day_of_week\nbuiltin promqlDayOfWeek : (timestamp: float) => float\n\n// promqlDaysInMonth() implements functionality equivalent to PromQL's days_in_month() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#days_in_month\nbuiltin promqlDaysInMonth : (timestamp: float) => float\n\n// emptyTable() returns an empty table, which is used as a helper function to implement\n// PromQL's time() and vector() functions:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#time\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#vector\nbuiltin emptyTable : () => [{_start: time, _stop: time, _time: time, _value: float}]\n\n// extrapolatedRate() is a helper function that calculates extrapolated rates over\n// counters and is used to implement PromQL's rate(), delta(), and increase() functions.\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#rate\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#increase\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#delta\nbuiltin extrapolatedRate : (<-tables: [{A with _start: time, _stop: time, _time: time, _value: float}], ?isCounter: bool, ?isRate: bool) => [{B with _value: float}]\n\n// holtWinters() implements functionality equivalent to PromQL's holt_winters()\n// function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#holt_winters\nbuiltin holtWinters : (<-tables: [{A with _time: time, _value: float}], ?smoothingFactor: float, ?trendFactor: float) => [{B with _value: float}]\n\n// promqlHour() implements functionality equivalent to PromQL's hour() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#hour\nbuiltin promqlHour : (timestamp: float) => float\n\n// instantRate() is a helper function that calculates instant rates over\n// counters and is used to implement PromQL's irate() and idelta() functions.\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#irate\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#idelta\nbuiltin instantRate : (<-tables: [{A with _time: time, _value: float}], ?isRate: bool) => [{B with _value: float}]\n\n// labelReplace implements functionality equivalent to PromQL's label_replace() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#label_replace\nbuiltin labelReplace : (\n    <-tables: [{A with _value: float}],\n    source: string,\n    destination: string,\n    regex: string,\n    replacement: string,\n) => [{B with _value: float}]\n\n// linearRegression implements linear regression functionality required to implement\n// PromQL's deriv() and predict_linear() functions:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#deriv\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#predict_linear\nbuiltin linearRegression : (<-tables: [{A with _time: time, _stop: time, _value: float}], ?predict: bool, ?fromNow: float) => [{B with _value: float}]\n\n// promqlMinute() implements functionality equivalent to PromQL's minute() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#minute\nbuiltin promqlMinute : (timestamp: float) => float\n\n// promqlMonth() implements functionality equivalent to PromQL's month() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#month\nbuiltin promqlMonth : (timestamp: float) => float\n\n// promHistogramQuantile() implements functionality equivalent to PromQL's\n// histogram_quantile() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#histogram_quantile\nbuiltin promHistogramQuantile : (\n    <-tables: [A],\n    ?quantile: float,\n    ?countColumn: string,\n    ?upperBoundColumn: string,\n    ?valueColumn: string,\n) => [B] where\n    A: Record,\n    B: Record\n\n// resets() implements functionality equivalent to PromQL's resets() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#resets\nbuiltin resets : (<-tables: [{A with _value: float}]) => [{B with _value: float}]\n\n// timestamp() implements functionality equivalent to PromQL's timestamp() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#timestamp\nbuiltin timestamp : (<-tables: [{A with _value: float}]) => [{A with _value: float}]\n\n// promqlYear() implements functionality equivalent to PromQL's year() function:\n//\n// https://prometheus.io/docs/prometheus/latest/querying/functions/#year\nbuiltin promqlYear : (timestamp: float) => float\n\n// quantile() accounts checks for quantile values that are out of range, above 1.0 or \n// below 0.0, by either returning positive infinity or negative infinity in the `_value` \n// column respectively. q must be a float \nquantile = (q, tables=<-, method=\"exact_mean\") => \n    // value is in normal range. We can use the normal quantile function\n    if q <= 1.0 and q >= 0.0 then\n        tables\n            |> universe.quantile(q: q, method: method)\n    else if q < 0.0 then\n        tables\n            |> reduce(identity: {_value: math.mInf(sign: -1)}, fn: (r, accumulator) => accumulator)\n    else\n        tables\n            |> reduce(identity: {_value: math.mInf(sign: 1)}, fn: (r, accumulator) => accumulator)\njoin = experimental.join",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// changes() implements functionality equivalent to PromQL's changes() function:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#changes\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   12,
					},
					File:   "promql.flux",
					Source: "builtin changes",
					Start: ast.Position{
						Column: 1,
						Line:   12,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   12,
						},
						File:   "promql.flux",
						Source: "changes",
						Start: ast.Position{
							Column: 9,
							Line:   12,
						},
					},
				},
				Name: "changes",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 83,
							Line:   12,
						},
						File:   "promql.flux",
						Source: "(<-tables: [{A with _value: float}]) => [{B with _value: float}]",
						Start: ast.Position{
							Column: 19,
							Line:   12,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 83,
								Line:   12,
							},
							File:   "promql.flux",
							Source: "(<-tables: [{A with _value: float}]) => [{B with _value: float}]",
							Start: ast.Position{
								Column: 19,
								Line:   12,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   12,
								},
								File:   "promql.flux",
								Source: "<-tables: [{A with _value: float}]",
								Start: ast.Position{
									Column: 20,
									Line:   12,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   12,
									},
									File:   "promql.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 22,
										Line:   12,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   12,
									},
									File:   "promql.flux",
									Source: "[{A with _value: float}]",
									Start: ast.Position{
										Column: 30,
										Line:   12,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   12,
										},
										File:   "promql.flux",
										Source: "{A with _value: float}",
										Start: ast.Position{
											Column: 31,
											Line:   12,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   12,
											},
											File:   "promql.flux",
											Source: "_value: float",
											Start: ast.Position{
												Column: 39,
												Line:   12,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   12,
												},
												File:   "promql.flux",
												Source: "_value",
												Start: ast.Position{
													Column: 39,
													Line:   12,
												},
											},
										},
										Name: "_value",
									},
									Ty: &ast.NamedType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   12,
												},
												File:   "promql.flux",
												Source: "float",
												Start: ast.Position{
													Column: 47,
													Line:   12,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 52,
														Line:   12,
													},
													File:   "promql.flux",
													Source: "float",
													Start: ast.Position{
														Column: 47,
														Line:   12,
													},
												},
											},
											Name: "float",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   12,
											},
											File:   "promql.flux",
											Source: "A",
											Start: ast.Position{
												Column: 32,
												Line:   12,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   12,
								},
								File:   "promql.flux",
								Source: "[{B with _value: float}]",
								Start: ast.Position{
									Column: 59,
									Line:   12,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 82,
										Line:   12,
									},
									File:   "promql.flux",
									Source: "{B with _value: float}",
									Start: ast.Position{
										Column: 60,
										Line:   12,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   12,
										},
										File:   "promql.flux",
										Source: "_value: float",
										Start: ast.Position{
											Column: 68,
											Line:   12,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   12,
											},
											File:   "promql.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 68,
												Line:   12,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   12,
											},
											File:   "promql.flux",
											Source: "float",
											Start: ast.Position{
												Column: 76,
												Line:   12,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 81,
													Line:   12,
												},
												File:   "promql.flux",
												Source: "float",
												Start: ast.Position{
													Column: 76,
													Line:   12,
												},
											},
										},
										Name: "float",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 62,
											Line:   12,
										},
										File:   "promql.flux",
										Source: "B",
										Start: ast.Position{
											Column: 61,
											Line:   12,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// promqlDayOfMonth() implements functionality equivalent to PromQL's day_of_month() function:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#day_of_month\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   17,
					},
					File:   "promql.flux",
					Source: "builtin promqlDayOfMonth",
					Start: ast.Position{
						Column: 1,
						Line:   17,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   17,
						},
						File:   "promql.flux",
						Source: "promqlDayOfMonth",
						Start: ast.Position{
							Column: 9,
							Line:   17,
						},
					},
				},
				Name: "promqlDayOfMonth",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 55,
							Line:   17,
						},
						File:   "promql.flux",
						Source: "(timestamp: float) => float",
						Start: ast.Position{
							Column: 28,
							Line:   17,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   17,
							},
							File:   "promql.flux",
							Source: "(timestamp: float) => float",
							Start: ast.Position{
								Column: 28,
								Line:   17,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   17,
								},
								File:   "promql.flux",
								Source: "timestamp: float",
								Start: ast.Position{
									Column: 29,
									Line:   17,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   17,
									},
									File:   "promql.flux",
									Source: "timestamp",
									Start: ast.Position{
										Column: 29,
										Line:   17,
									},
								},
							},
							Name: "timestamp",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   17,
									},
									File:   "promql.flux",
									Source: "float",
									Start: ast.Position{
										Column: 40,
										Line:   17,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   17,
										},
										File:   "promql.flux",
										Source: "float",
										Start: ast.Position{
											Column: 40,
											Line:   17,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   17,
								},
								File:   "promql.flux",
								Source: "float",
								Start: ast.Position{
									Column: 50,
									Line:   17,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   17,
									},
									File:   "promql.flux",
									Source: "float",
									Start: ast.Position{
										Column: 50,
										Line:   17,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// promqlDayOfWeek() implements functionality equivalent to PromQL's day_of_week() function:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#day_of_week\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   22,
					},
					File:   "promql.flux",
					Source: "builtin promqlDayOfWeek",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   22,
						},
						File:   "promql.flux",
						Source: "promqlDayOfWeek",
						Start: ast.Position{
							Column: 9,
							Line:   22,
						},
					},
				},
				Name: "promqlDayOfWeek",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 54,
							Line:   22,
						},
						File:   "promql.flux",
						Source: "(timestamp: float) => float",
						Start: ast.Position{
							Column: 27,
							Line:   22,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   22,
							},
							File:   "promql.flux",
							Source: "(timestamp: float) => float",
							Start: ast.Position{
								Column: 27,
								Line:   22,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   22,
								},
								File:   "promql.flux",
								Source: "timestamp: float",
								Start: ast.Position{
									Column: 28,
									Line:   22,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   22,
									},
									File:   "promql.flux",
									Source: "timestamp",
									Start: ast.Position{
										Column: 28,
										Line:   22,
									},
								},
							},
							Name: "timestamp",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   22,
									},
									File:   "promql.flux",
									Source: "float",
									Start: ast.Position{
										Column: 39,
										Line:   22,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   22,
										},
										File:   "promql.flux",
										Source: "float",
										Start: ast.Position{
											Column: 39,
											Line:   22,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   22,
								},
								File:   "promql.flux",
								Source: "float",
								Start: ast.Position{
									Column: 49,
									Line:   22,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   22,
									},
									File:   "promql.flux",
									Source: "float",
									Start: ast.Position{
										Column: 49,
										Line:   22,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// promqlDaysInMonth() implements functionality equivalent to PromQL's days_in_month() function:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#days_in_month\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 26,
						Line:   27,
					},
					File:   "promql.flux",
					Source: "builtin promqlDaysInMonth",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   27,
						},
						File:   "promql.flux",
						Source: "promqlDaysInMonth",
						Start: ast.Position{
							Column: 9,
							Line:   27,
						},
					},
				},
				Name: "promqlDaysInMonth",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 56,
							Line:   27,
						},
						File:   "promql.flux",
						Source: "(timestamp: float) => float",
						Start: ast.Position{
							Column: 29,
							Line:   27,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   27,
							},
							File:   "promql.flux",
							Source: "(timestamp: float) => float",
							Start: ast.Position{
								Column: 29,
								Line:   27,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   27,
								},
								File:   "promql.flux",
								Source: "timestamp: float",
								Start: ast.Position{
									Column: 30,
									Line:   27,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   27,
									},
									File:   "promql.flux",
									Source: "timestamp",
									Start: ast.Position{
										Column: 30,
										Line:   27,
									},
								},
							},
							Name: "timestamp",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   27,
									},
									File:   "promql.flux",
									Source: "float",
									Start: ast.Position{
										Column: 41,
										Line:   27,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   27,
										},
										File:   "promql.flux",
										Source: "float",
										Start: ast.Position{
											Column: 41,
											Line:   27,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   27,
								},
								File:   "promql.flux",
								Source: "float",
								Start: ast.Position{
									Column: 51,
									Line:   27,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   27,
									},
									File:   "promql.flux",
									Source: "float",
									Start: ast.Position{
										Column: 51,
										Line:   27,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// emptyTable() returns an empty table, which is used as a helper function to implement\n"}, ast.Comment{Text: "// PromQL's time() and vector() functions:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#time\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#vector\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   34,
					},
					File:   "promql.flux",
					Source: "builtin emptyTable",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   34,
						},
						File:   "promql.flux",
						Source: "emptyTable",
						Start: ast.Position{
							Column: 9,
							Line:   34,
						},
					},
				},
				Name: "emptyTable",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 85,
							Line:   34,
						},
						File:   "promql.flux",
						Source: "() => [{_start: time, _stop: time, _time: time, _value: float}]",
						Start: ast.Position{
							Column: 22,
							Line:   34,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 85,
								Line:   34,
							},
							File:   "promql.flux",
							Source: "() => [{_start: time, _stop: time, _time: time, _value: float}]",
							Start: ast.Position{
								Column: 22,
								Line:   34,
							},
						},
					},
					Parameters: []*ast.ParameterType{},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   34,
								},
								File:   "promql.flux",
								Source: "[{_start: time, _stop: time, _time: time, _value: float}]",
								Start: ast.Position{
									Column: 28,
									Line:   34,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   34,
									},
									File:   "promql.flux",
									Source: "{_start: time, _stop: time, _time: time, _value: float}",
									Start: ast.Position{
										Column: 29,
										Line:   34,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   34,
										},
										File:   "promql.flux",
										Source: "_start: time",
										Start: ast.Position{
											Column: 30,
											Line:   34,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   34,
											},
											File:   "promql.flux",
											Source: "_start",
											Start: ast.Position{
												Column: 30,
												Line:   34,
											},
										},
									},
									Name: "_start",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   34,
											},
											File:   "promql.flux",
											Source: "time",
											Start: ast.Position{
												Column: 38,
												Line:   34,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 42,
													Line:   34,
												},
												File:   "promql.flux",
												Source: "time",
												Start: ast.Position{
													Column: 38,
													Line:   34,
												},
											},
										},
										Name: "time",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   34,
										},
										File:   "promql.flux",
										Source: "_stop: time",
										Start: ast.Position{
											Column: 44,
											Line:   34,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   34,
											},
											File:   "promql.flux",
											Source: "_stop",
											Start: ast.Position{
												Column: 44,
												Line:   34,
											},
										},
									},
									Name: "_stop",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 55,
												Line:   34,
											},
											File:   "promql.flux",
											Source: "time",
											Start: ast.Position{
												Column: 51,
												Line:   34,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 55,
													Line:   34,
												},
												File:   "promql.flux",
												Source: "time",
												Start: ast.Position{
													Column: 51,
													Line:   34,
												},
											},
										},
										Name: "time",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   34,
										},
										File:   "promql.flux",
										Source: "_time: time",
										Start: ast.Position{
											Column: 57,
											Line:   34,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 62,
												Line:   34,
											},
											File:   "promql.flux",
											Source: "_time",
											Start: ast.Position{
												Column: 57,
												Line:   34,
											},
										},
									},
									Name: "_time",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   34,
											},
											File:   "promql.flux",
											Source: "time",
											Start: ast.Position{
												Column: 64,
												Line:   34,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   34,
												},
												File:   "promql.flux",
												Source: "time",
												Start: ast.Position{
													Column: 64,
													Line:   34,
												},
											},
										},
										Name: "time",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 83,
											Line:   34,
										},
										File:   "promql.flux",
										Source: "_value: float",
										Start: ast.Position{
											Column: 70,
											Line:   34,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   34,
											},
											File:   "promql.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 70,
												Line:   34,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 83,
												Line:   34,
											},
											File:   "promql.flux",
											Source: "float",
											Start: ast.Position{
												Column: 78,
												Line:   34,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 83,
													Line:   34,
												},
												File:   "promql.flux",
												Source: "float",
												Start: ast.Position{
													Column: 78,
													Line:   34,
												},
											},
										},
										Name: "float",
									},
								},
							}},
							Tvar: nil,
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// extrapolatedRate() is a helper function that calculates extrapolated rates over\n"}, ast.Comment{Text: "// counters and is used to implement PromQL's rate(), delta(), and increase() functions.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#rate\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#increase\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#delta\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   42,
					},
					File:   "promql.flux",
					Source: "builtin extrapolatedRate",
					Start: ast.Position{
						Column: 1,
						Line:   42,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   42,
						},
						File:   "promql.flux",
						Source: "extrapolatedRate",
						Start: ast.Position{
							Column: 9,
							Line:   42,
						},
					},
				},
				Name: "extrapolatedRate",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 165,
							Line:   42,
						},
						File:   "promql.flux",
						Source: "(<-tables: [{A with _start: time, _stop: time, _time: time, _value: float}], ?isCounter: bool, ?isRate: bool) => [{B with _value: float}]",
						Start: ast.Position{
							Column: 28,
							Line:   42,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 165,
								Line:   42,
							},
							File:   "promql.flux",
							Source: "(<-tables: [{A with _start: time, _stop: time, _time: time, _value: float}], ?isCounter: bool, ?isRate: bool) => [{B with _value: float}]",
							Start: ast.Position{
								Column: 28,
								Line:   42,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 103,
									Line:   42,
								},
								File:   "promql.flux",
								Source: "<-tables: [{A with _start: time, _stop: time, _time: time, _value: float}]",
								Start: ast.Position{
									Column: 29,
									Line:   42,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   42,
									},
									File:   "promql.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 31,
										Line:   42,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 103,
										Line:   42,
									},
									File:   "promql.flux",
									Source: "[{A with _start: time, _stop: time, _time: time, _value: float}]",
									Start: ast.Position{
										Column: 39,
										Line:   42,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 102,
											Line:   42,
										},
										File:   "promql.flux",
										Source: "{A with _start: time, _stop: time, _time: time, _value: float}",
										Start: ast.Position{
											Column: 40,
											Line:   42,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 60,
												Line:   42,
											},
											File:   "promql.flux",
											Source: "_start: time",
											Start: ast.Position{
												Column: 48,
												Line:   42,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   42,
												},
												File:   "promql.flux",
												Source: "_start",
												Start: ast.Position{
													Column: 48,
													Line:   42,
												},
											},
										},
										Name: "_start",
									},
									Ty: &ast.NamedType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   42,
												},
												File:   "promql.flux",
												Source: "time",
												Start: ast.Position{
													Column: 56,
													Line:   42,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   42,
													},
													File:   "promql.flux",
													Source: "time",
													Start: ast.Position{
														Column: 56,
														Line:   42,
													},
												},
											},
											Name: "time",
										},
									},
								}, &ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   42,
											},
											File:   "promql.flux",
											Source: "_stop: time",
											Start: ast.Position{
												Column: 62,
												Line:   42,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   42,
												},
												File:   "promql.flux",
												Source: "_stop",
												Start: ast.Position{
													Column: 62,
													Line:   42,
												},
											},
										},
										Name: "_stop",
									},
									Ty: &ast.NamedType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 73,
													Line:   42,
												},
												File:   "promql.flux",
												Source: "time",
												Start: ast.Position{
													Column: 69,
													Line:   42,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 73,
														Line:   42,
													},
													File:   "promql.flux",
													Source: "time",
													Start: ast.Position{
														Column: 69,
														Line:   42,
													},
												},
											},
											Name: "time",
										},
									},
								}, &ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 86,
												Line:   42,
											},
											File:   "promql.flux",
											Source: "_time: time",
											Start: ast.Position{
												Column: 75,
												Line:   42,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   42,
												},
												File:   "promql.flux",
												Source: "_time",
												Start: ast.Position{
													Column: 75,
													Line:   42,
												},
											},
										},
										Name: "_time",
									},
									Ty: &ast.NamedType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 86,
													Line:   42,
												},
												File:   "promql.flux",
												Source: "time",
												Start: ast.Position{
													Column: 82,
													Line:   42,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 86,
														Line:   42,
													},
													File:   "promql.flux",
													Source: "time",
													Start: ast.Position{
														Column: 82,
														Line:   42,
													},
												},
											},
											Name: "time",
										},
									},
								}, &ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 101,
												Line:   42,
											},
											File:   "promql.flux",
											Source: "_value: float",
											Start: ast.Position{
												Column: 88,
												Line:   42,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 94,
													Line:   42,
												},
												File:   "promql.flux",
												Source: "_value",
												Start: ast.Position{
													Column: 88,
													Line:   42,
												},
											},
										},
										Name: "_value",
									},
									Ty: &ast.NamedType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 101,
													Line:   42,
												},
												File:   "promql.flux",
												Source: "float",
												Start: ast.Position{
													Column: 96,
													Line:   42,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 101,
														Line:   42,
													},
													File:   "promql.flux",
													Source: "float",
													Start: ast.Position{
														Column: 96,
														Line:   42,
													},
												},
											},
											Name: "float",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   42,
											},
											File:   "promql.flux",
											Source: "A",
											Start: ast.Position{
												Column: 41,
												Line:   42,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 121,
									Line:   42,
								},
								File:   "promql.flux",
								Source: "?isCounter: bool",
								Start: ast.Position{
									Column: 105,
									Line:   42,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 115,
										Line:   42,
									},
									File:   "promql.flux",
									Source: "isCounter",
									Start: ast.Position{
										Column: 106,
										Line:   42,
									},
								},
							},
							Name: "isCounter",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 121,
										Line:   42,
									},
									File:   "promql.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 117,
										Line:   42,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 121,
											Line:   42,
										},
										File:   "promql.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 117,
											Line:   42,
										},
									},
								},
								Name: "bool",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 136,
									Line:   42,
								},
								File:   "promql.flux",
								Source: "?isRate: bool",
								Start: ast.Position{
									Column: 123,
									Line:   42,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 130,
										Line:   42,
									},
									File:   "promql.flux",
									Source: "isRate",
									Start: ast.Position{
										Column: 124,
										Line:   42,
									},
								},
							},
							Name: "isRate",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 136,
										Line:   42,
									},
									File:   "promql.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 132,
										Line:   42,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 136,
											Line:   42,
										},
										File:   "promql.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 132,
											Line:   42,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 165,
									Line:   42,
								},
								File:   "promql.flux",
								Source: "[{B with _value: float}]",
								Start: ast.Position{
									Column: 141,
									Line:   42,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 164,
										Line:   42,
									},
									File:   "promql.flux",
									Source: "{B with _value: float}",
									Start: ast.Position{
										Column: 142,
										Line:   42,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 163,
											Line:   42,
										},
										File:   "promql.flux",
										Source: "_value: float",
										Start: ast.Position{
											Column: 150,
											Line:   42,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 156,
												Line:   42,
											},
											File:   "promql.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 150,
												Line:   42,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 163,
												Line:   42,
											},
											File:   "promql.flux",
											Source: "float",
											Start: ast.Position{
												Column: 158,
												Line:   42,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 163,
													Line:   42,
												},
												File:   "promql.flux",
												Source: "float",
												Start: ast.Position{
													Column: 158,
													Line:   42,
												},
											},
										},
										Name: "float",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 144,
											Line:   42,
										},
										File:   "promql.flux",
										Source: "B",
										Start: ast.Position{
											Column: 143,
											Line:   42,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// holtWinters() implements functionality equivalent to PromQL's holt_winters()\n"}, ast.Comment{Text: "// function:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#holt_winters\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   48,
					},
					File:   "promql.flux",
					Source: "builtin holtWinters",
					Start: ast.Position{
						Column: 1,
						Line:   48,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   48,
						},
						File:   "promql.flux",
						Source: "holtWinters",
						Start: ast.Position{
							Column: 9,
							Line:   48,
						},
					},
				},
				Name: "holtWinters",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 146,
							Line:   48,
						},
						File:   "promql.flux",
						Source: "(<-tables: [{A with _time: time, _value: float}], ?smoothingFactor: float, ?trendFactor: float) => [{B with _value: float}]",
						Start: ast.Position{
							Column: 23,
							Line:   48,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 146,
								Line:   48,
							},
							File:   "promql.flux",
							Source: "(<-tables: [{A with _time: time, _value: float}], ?smoothingFactor: float, ?trendFactor: float) => [{B with _value: float}]",
							Start: ast.Position{
								Column: 23,
								Line:   48,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   48,
								},
								File:   "promql.flux",
								Source: "<-tables: [{A with _time: time, _value: float}]",
								Start: ast.Position{
									Column: 24,
									Line:   48,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   48,
									},
									File:   "promql.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 26,
										Line:   48,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   48,
									},
									File:   "promql.flux",
									Source: "[{A with _time: time, _value: float}]",
									Start: ast.Position{
										Column: 34,
										Line:   48,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   48,
										},
										File:   "promql.flux",
										Source: "{A with _time: time, _value: float}",
										Start: ast.Position{
											Column: 35,
											Line:   48,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   48,
											},
											File:   "promql.flux",
											Source: "_time: time",
											Start: ast.Position{
												Column: 43,
												Line:   48,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   48,
												},
												File:   "promql.flux",
												Source: "_time",
												Start: ast.Position{
													Column: 43,
													Line:   48,
												},
											},
										},
										Name: "_time",
									},
									Ty: &ast.NamedType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   48,
												},
												File:   "promql.flux",
												Source: "time",
												Start: ast.Position{
													Column: 50,
													Line:   48,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   48,
													},
													File:   "promql.flux",
													Source: "time",
													Start: ast.Position{
														Column: 50,
														Line:   48,
													},
												},
											},
											Name: "time",
										},
									},
								}, &ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   48,
											},
											File:   "promql.flux",
											Source: "_value: float",
											Start: ast.Position{
												Column: 56,
												Line:   48,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 62,
													Line:   48,
												},
												File:   "promql.flux",
												Source: "_value",
												Start: ast.Position{
													Column: 56,
													Line:   48,
												},
											},
										},
										Name: "_value",
									},
									Ty: &ast.NamedType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   48,
												},
												File:   "promql.flux",
												Source: "float",
												Start: ast.Position{
													Column: 64,
													Line:   48,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   48,
													},
													File:   "promql.flux",
													Source: "float",
													Start: ast.Position{
														Column: 64,
														Line:   48,
													},
												},
											},
											Name: "float",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   48,
											},
											File:   "promql.flux",
											Source: "A",
											Start: ast.Position{
												Column: 36,
												Line:   48,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 96,
									Line:   48,
								},
								File:   "promql.flux",
								Source: "?smoothingFactor: float",
								Start: ast.Position{
									Column: 73,
									Line:   48,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 89,
										Line:   48,
									},
									File:   "promql.flux",
									Source: "smoothingFactor",
									Start: ast.Position{
										Column: 74,
										Line:   48,
									},
								},
							},
							Name: "smoothingFactor",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 96,
										Line:   48,
									},
									File:   "promql.flux",
									Source: "float",
									Start: ast.Position{
										Column: 91,
										Line:   48,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 96,
											Line:   48,
										},
										File:   "promql.flux",
										Source: "float",
										Start: ast.Position{
											Column: 91,
											Line:   48,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 117,
									Line:   48,
								},
								File:   "promql.flux",
								Source: "?trendFactor: float",
								Start: ast.Position{
									Column: 98,
									Line:   48,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 110,
										Line:   48,
									},
									File:   "promql.flux",
									Source: "trendFactor",
									Start: ast.Position{
										Column: 99,
										Line:   48,
									},
								},
							},
							Name: "trendFactor",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 117,
										Line:   48,
									},
									File:   "promql.flux",
									Source: "float",
									Start: ast.Position{
										Column: 112,
										Line:   48,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 117,
											Line:   48,
										},
										File:   "promql.flux",
										Source: "float",
										Start: ast.Position{
											Column: 112,
											Line:   48,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 146,
									Line:   48,
								},
								File:   "promql.flux",
								Source: "[{B with _value: float}]",
								Start: ast.Position{
									Column: 122,
									Line:   48,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 145,
										Line:   48,
									},
									File:   "promql.flux",
									Source: "{B with _value: float}",
									Start: ast.Position{
										Column: 123,
										Line:   48,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 144,
											Line:   48,
										},
										File:   "promql.flux",
										Source: "_value: float",
										Start: ast.Position{
											Column: 131,
											Line:   48,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 137,
												Line:   48,
											},
											File:   "promql.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 131,
												Line:   48,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 144,
												Line:   48,
											},
											File:   "promql.flux",
											Source: "float",
											Start: ast.Position{
												Column: 139,
												Line:   48,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 144,
													Line:   48,
												},
												File:   "promql.flux",
												Source: "float",
												Start: ast.Position{
													Column: 139,
													Line:   48,
												},
											},
										},
										Name: "float",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 125,
											Line:   48,
										},
										File:   "promql.flux",
										Source: "B",
										Start: ast.Position{
											Column: 124,
											Line:   48,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// promqlHour() implements functionality equivalent to PromQL's hour() function:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#hour\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   53,
					},
					File:   "promql.flux",
					Source: "builtin promqlHour",
					Start: ast.Position{
						Column: 1,
						Line:   53,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   53,
						},
						File:   "promql.flux",
						Source: "promqlHour",
						Start: ast.Position{
							Column: 9,
							Line:   53,
						},
					},
				},
				Name: "promqlHour",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 49,
							Line:   53,
						},
						File:   "promql.flux",
						Source: "(timestamp: float) => float",
						Start: ast.Position{
							Column: 22,
							Line:   53,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   53,
							},
							File:   "promql.flux",
							Source: "(timestamp: float) => float",
							Start: ast.Position{
								Column: 22,
								Line:   53,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   53,
								},
								File:   "promql.flux",
								Source: "timestamp: float",
								Start: ast.Position{
									Column: 23,
									Line:   53,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   53,
									},
									File:   "promql.flux",
									Source: "timestamp",
									Start: ast.Position{
										Column: 23,
										Line:   53,
									},
								},
							},
							Name: "timestamp",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   53,
									},
									File:   "promql.flux",
									Source: "float",
									Start: ast.Position{
										Column: 34,
										Line:   53,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   53,
										},
										File:   "promql.flux",
										Source: "float",
										Start: ast.Position{
											Column: 34,
											Line:   53,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   53,
								},
								File:   "promql.flux",
								Source: "float",
								Start: ast.Position{
									Column: 44,
									Line:   53,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   53,
									},
									File:   "promql.flux",
									Source: "float",
									Start: ast.Position{
										Column: 44,
										Line:   53,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// instantRate() is a helper function that calculates instant rates over\n"}, ast.Comment{Text: "// counters and is used to implement PromQL's irate() and idelta() functions.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#irate\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#idelta\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   60,
					},
					File:   "promql.flux",
					Source: "builtin instantRate",
					Start: ast.Position{
						Column: 1,
						Line:   60,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   60,
						},
						File:   "promql.flux",
						Source: "instantRate",
						Start: ast.Position{
							Column: 9,
							Line:   60,
						},
					},
				},
				Name: "instantRate",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 115,
							Line:   60,
						},
						File:   "promql.flux",
						Source: "(<-tables: [{A with _time: time, _value: float}], ?isRate: bool) => [{B with _value: float}]",
						Start: ast.Position{
							Column: 23,
							Line:   60,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 115,
								Line:   60,
							},
							File:   "promql.flux",
							Source: "(<-tables: [{A with _time: time, _value: float}], ?isRate: bool) => [{B with _value: float}]",
							Start: ast.Position{
								Column: 23,
								Line:   60,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   60,
								},
								File:   "promql.flux",
								Source: "<-tables: [{A with _time: time, _value: float}]",
								Start: ast.Position{
									Column: 24,
									Line:   60,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   60,
									},
									File:   "promql.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 26,
										Line:   60,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   60,
									},
									File:   "promql.flux",
									Source: "[{A with _time: time, _value: float}]",
									Start: ast.Position{
										Column: 34,
										Line:   60,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   60,
										},
										File:   "promql.flux",
										Source: "{A with _time: time, _value: float}",
										Start: ast.Position{
											Column: 35,
											Line:   60,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   60,
											},
											File:   "promql.flux",
											Source: "_time: time",
											Start: ast.Position{
												Column: 43,
												Line:   60,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   60,
												},
												File:   "promql.flux",
												Source: "_time",
												Start: ast.Position{
													Column: 43,
													Line:   60,
												},
											},
										},
										Name: "_time",
									},
									Ty: &ast.NamedType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   60,
												},
												File:   "promql.flux",
												Source: "time",
												Start: ast.Position{
													Column: 50,
													Line:   60,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   60,
													},
													File:   "promql.flux",
													Source: "time",
													Start: ast.Position{
														Column: 50,
														Line:   60,
													},
												},
											},
											Name: "time",
										},
									},
								}, &ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   60,
											},
											File:   "promql.flux",
											Source: "_value: float",
											Start: ast.Position{
												Column: 56,
												Line:   60,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 62,
													Line:   60,
												},
												File:   "promql.flux",
												Source: "_value",
												Start: ast.Position{
													Column: 56,
													Line:   60,
												},
											},
										},
										Name: "_value",
									},
									Ty: &ast.NamedType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   60,
												},
												File:   "promql.flux",
												Source: "float",
												Start: ast.Position{
													Column: 64,
													Line:   60,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   60,
													},
													File:   "promql.flux",
													Source: "float",
													Start: ast.Position{
														Column: 64,
														Line:   60,
													},
												},
											},
											Name: "float",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   60,
											},
											File:   "promql.flux",
											Source: "A",
											Start: ast.Position{
												Column: 36,
												Line:   60,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   60,
								},
								File:   "promql.flux",
								Source: "?isRate: bool",
								Start: ast.Position{
									Column: 73,
									Line:   60,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 80,
										Line:   60,
									},
									File:   "promql.flux",
									Source: "isRate",
									Start: ast.Position{
										Column: 74,
										Line:   60,
									},
								},
							},
							Name: "isRate",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 86,
										Line:   60,
									},
									File:   "promql.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 82,
										Line:   60,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 86,
											Line:   60,
										},
										File:   "promql.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 82,
											Line:   60,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 115,
									Line:   60,
								},
								File:   "promql.flux",
								Source: "[{B with _value: float}]",
								Start: ast.Position{
									Column: 91,
									Line:   60,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 114,
										Line:   60,
									},
									File:   "promql.flux",
									Source: "{B with _value: float}",
									Start: ast.Position{
										Column: 92,
										Line:   60,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 113,
											Line:   60,
										},
										File:   "promql.flux",
										Source: "_value: float",
										Start: ast.Position{
											Column: 100,
											Line:   60,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 106,
												Line:   60,
											},
											File:   "promql.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 100,
												Line:   60,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 113,
												Line:   60,
											},
											File:   "promql.flux",
											Source: "float",
											Start: ast.Position{
												Column: 108,
												Line:   60,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 113,
													Line:   60,
												},
												File:   "promql.flux",
												Source: "float",
												Start: ast.Position{
													Column: 108,
													Line:   60,
												},
											},
										},
										Name: "float",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 94,
											Line:   60,
										},
										File:   "promql.flux",
										Source: "B",
										Start: ast.Position{
											Column: 93,
											Line:   60,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// labelReplace implements functionality equivalent to PromQL's label_replace() function:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#label_replace\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   65,
					},
					File:   "promql.flux",
					Source: "builtin labelReplace",
					Start: ast.Position{
						Column: 1,
						Line:   65,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   65,
						},
						File:   "promql.flux",
						Source: "labelReplace",
						Start: ast.Position{
							Column: 9,
							Line:   65,
						},
					},
				},
				Name: "labelReplace",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   71,
						},
						File:   "promql.flux",
						Source: "(\n    <-tables: [{A with _value: float}],\n    source: string,\n    destination: string,\n    regex: string,\n    replacement: string,\n) => [{B with _value: float}]",
						Start: ast.Position{
							Column: 24,
							Line:   65,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   71,
							},
							File:   "promql.flux",
							Source: "(\n    <-tables: [{A with _value: float}],\n    source: string,\n    destination: string,\n    regex: string,\n    replacement: string,\n) => [{B with _value: float}]",
							Start: ast.Position{
								Column: 24,
								Line:   65,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   66,
								},
								File:   "promql.flux",
								Source: "<-tables: [{A with _value: float}]",
								Start: ast.Position{
									Column: 5,
									Line:   66,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   66,
									},
									File:   "promql.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   66,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   66,
									},
									File:   "promql.flux",
									Source: "[{A with _value: float}]",
									Start: ast.Position{
										Column: 15,
										Line:   66,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   66,
										},
										File:   "promql.flux",
										Source: "{A with _value: float}",
										Start: ast.Position{
											Column: 16,
											Line:   66,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   66,
											},
											File:   "promql.flux",
											Source: "_value: float",
											Start: ast.Position{
												Column: 24,
												Line:   66,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   66,
												},
												File:   "promql.flux",
												Source: "_value",
												Start: ast.Position{
													Column: 24,
													Line:   66,
												},
											},
										},
										Name: "_value",
									},
									Ty: &ast.NamedType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   66,
												},
												File:   "promql.flux",
												Source: "float",
												Start: ast.Position{
													Column: 32,
													Line:   66,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   66,
													},
													File:   "promql.flux",
													Source: "float",
													Start: ast.Position{
														Column: 32,
														Line:   66,
													},
												},
											},
											Name: "float",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   66,
											},
											File:   "promql.flux",
											Source: "A",
											Start: ast.Position{
												Column: 17,
												Line:   66,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   67,
								},
								File:   "promql.flux",
								Source: "source: string",
								Start: ast.Position{
									Column: 5,
									Line:   67,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   67,
									},
									File:   "promql.flux",
									Source: "source",
									Start: ast.Position{
										Column: 5,
										Line:   67,
									},
								},
							},
							Name: "source",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   67,
									},
									File:   "promql.flux",
									Source: "string",
									Start: ast.Position{
										Column: 13,
										Line:   67,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   67,
										},
										File:   "promql.flux",
										Source: "string",
										Start: ast.Position{
											Column: 13,
											Line:   67,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   68,
								},
								File:   "promql.flux",
								Source: "destination: string",
								Start: ast.Position{
									Column: 5,
									Line:   68,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   68,
									},
									File:   "promql.flux",
									Source: "destination",
									Start: ast.Position{
										Column: 5,
										Line:   68,
									},
								},
							},
							Name: "destination",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   68,
									},
									File:   "promql.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   68,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   68,
										},
										File:   "promql.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   68,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   69,
								},
								File:   "promql.flux",
								Source: "regex: string",
								Start: ast.Position{
									Column: 5,
									Line:   69,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   69,
									},
									File:   "promql.flux",
									Source: "regex",
									Start: ast.Position{
										Column: 5,
										Line:   69,
									},
								},
							},
							Name: "regex",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   69,
									},
									File:   "promql.flux",
									Source: "string",
									Start: ast.Position{
										Column: 12,
										Line:   69,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   69,
										},
										File:   "promql.flux",
										Source: "string",
										Start: ast.Position{
											Column: 12,
											Line:   69,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   70,
								},
								File:   "promql.flux",
								Source: "replacement: string",
								Start: ast.Position{
									Column: 5,
									Line:   70,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   70,
									},
									File:   "promql.flux",
									Source: "replacement",
									Start: ast.Position{
										Column: 5,
										Line:   70,
									},
								},
							},
							Name: "replacement",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   70,
									},
									File:   "promql.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   70,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   70,
										},
										File:   "promql.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   70,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   71,
								},
								File:   "promql.flux",
								Source: "[{B with _value: float}]",
								Start: ast.Position{
									Column: 6,
									Line:   71,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   71,
									},
									File:   "promql.flux",
									Source: "{B with _value: float}",
									Start: ast.Position{
										Column: 7,
										Line:   71,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   71,
										},
										File:   "promql.flux",
										Source: "_value: float",
										Start: ast.Position{
											Column: 15,
											Line:   71,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   71,
											},
											File:   "promql.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 15,
												Line:   71,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   71,
											},
											File:   "promql.flux",
											Source: "float",
											Start: ast.Position{
												Column: 23,
												Line:   71,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   71,
												},
												File:   "promql.flux",
												Source: "float",
												Start: ast.Position{
													Column: 23,
													Line:   71,
												},
											},
										},
										Name: "float",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   71,
										},
										File:   "promql.flux",
										Source: "B",
										Start: ast.Position{
											Column: 8,
											Line:   71,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// linearRegression implements linear regression functionality required to implement\n"}, ast.Comment{Text: "// PromQL's deriv() and predict_linear() functions:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#deriv\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#predict_linear\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   78,
					},
					File:   "promql.flux",
					Source: "builtin linearRegression",
					Start: ast.Position{
						Column: 1,
						Line:   78,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   78,
						},
						File:   "promql.flux",
						Source: "linearRegression",
						Start: ast.Position{
							Column: 9,
							Line:   78,
						},
					},
				},
				Name: "linearRegression",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 151,
							Line:   78,
						},
						File:   "promql.flux",
						Source: "(<-tables: [{A with _time: time, _stop: time, _value: float}], ?predict: bool, ?fromNow: float) => [{B with _value: float}]",
						Start: ast.Position{
							Column: 28,
							Line:   78,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 151,
								Line:   78,
							},
							File:   "promql.flux",
							Source: "(<-tables: [{A with _time: time, _stop: time, _value: float}], ?predict: bool, ?fromNow: float) => [{B with _value: float}]",
							Start: ast.Position{
								Column: 28,
								Line:   78,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   78,
								},
								File:   "promql.flux",
								Source: "<-tables: [{A with _time: time, _stop: time, _value: float}]",
								Start: ast.Position{
									Column: 29,
									Line:   78,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   78,
									},
									File:   "promql.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 31,
										Line:   78,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 89,
										Line:   78,
									},
									File:   "promql.flux",
									Source: "[{A with _time: time, _stop: time, _value: float}]",
									Start: ast.Position{
										Column: 39,
										Line:   78,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   78,
										},
										File:   "promql.flux",
										Source: "{A with _time: time, _stop: time, _value: float}",
										Start: ast.Position{
											Column: 40,
											Line:   78,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   78,
											},
											File:   "promql.flux",
											Source: "_time: time",
											Start: ast.Position{
												Column: 48,
												Line:   78,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   78,
												},
												File:   "promql.flux",
												Source: "_time",
												Start: ast.Position{
													Column: 48,
													Line:   78,
												},
											},
										},
										Name: "_time",
									},
									Ty: &ast.NamedType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   78,
												},
												File:   "promql.flux",
												Source: "time",
												Start: ast.Position{
													Column: 55,
													Line:   78,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   78,
													},
													File:   "promql.flux",
													Source: "time",
													Start: ast.Position{
														Column: 55,
														Line:   78,
													},
												},
											},
											Name: "time",
										},
									},
								}, &ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   78,
											},
											File:   "promql.flux",
											Source: "_stop: time",
											Start: ast.Position{
												Column: 61,
												Line:   78,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   78,
												},
												File:   "promql.flux",
												Source: "_stop",
												Start: ast.Position{
													Column: 61,
													Line:   78,
												},
											},
										},
										Name: "_stop",
									},
									Ty: &ast.NamedType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 72,
													Line:   78,
												},
												File:   "promql.flux",
												Source: "time",
												Start: ast.Position{
													Column: 68,
													Line:   78,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 72,
														Line:   78,
													},
													File:   "promql.flux",
													Source: "time",
													Start: ast.Position{
														Column: 68,
														Line:   78,
													},
												},
											},
											Name: "time",
										},
									},
								}, &ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 87,
												Line:   78,
											},
											File:   "promql.flux",
											Source: "_value: float",
											Start: ast.Position{
												Column: 74,
												Line:   78,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   78,
												},
												File:   "promql.flux",
												Source: "_value",
												Start: ast.Position{
													Column: 74,
													Line:   78,
												},
											},
										},
										Name: "_value",
									},
									Ty: &ast.NamedType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 87,
													Line:   78,
												},
												File:   "promql.flux",
												Source: "float",
												Start: ast.Position{
													Column: 82,
													Line:   78,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   78,
													},
													File:   "promql.flux",
													Source: "float",
													Start: ast.Position{
														Column: 82,
														Line:   78,
													},
												},
											},
											Name: "float",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   78,
											},
											File:   "promql.flux",
											Source: "A",
											Start: ast.Position{
												Column: 41,
												Line:   78,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   78,
								},
								File:   "promql.flux",
								Source: "?predict: bool",
								Start: ast.Position{
									Column: 91,
									Line:   78,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   78,
									},
									File:   "promql.flux",
									Source: "predict",
									Start: ast.Position{
										Column: 92,
										Line:   78,
									},
								},
							},
							Name: "predict",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 105,
										Line:   78,
									},
									File:   "promql.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 101,
										Line:   78,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 105,
											Line:   78,
										},
										File:   "promql.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 101,
											Line:   78,
										},
									},
								},
								Name: "bool",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 122,
									Line:   78,
								},
								File:   "promql.flux",
								Source: "?fromNow: float",
								Start: ast.Position{
									Column: 107,
									Line:   78,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 115,
										Line:   78,
									},
									File:   "promql.flux",
									Source: "fromNow",
									Start: ast.Position{
										Column: 108,
										Line:   78,
									},
								},
							},
							Name: "fromNow",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 122,
										Line:   78,
									},
									File:   "promql.flux",
									Source: "float",
									Start: ast.Position{
										Column: 117,
										Line:   78,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 122,
											Line:   78,
										},
										File:   "promql.flux",
										Source: "float",
										Start: ast.Position{
											Column: 117,
											Line:   78,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 151,
									Line:   78,
								},
								File:   "promql.flux",
								Source: "[{B with _value: float}]",
								Start: ast.Position{
									Column: 127,
									Line:   78,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 150,
										Line:   78,
									},
									File:   "promql.flux",
									Source: "{B with _value: float}",
									Start: ast.Position{
										Column: 128,
										Line:   78,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 149,
											Line:   78,
										},
										File:   "promql.flux",
										Source: "_value: float",
										Start: ast.Position{
											Column: 136,
											Line:   78,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 142,
												Line:   78,
											},
											File:   "promql.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 136,
												Line:   78,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 149,
												Line:   78,
											},
											File:   "promql.flux",
											Source: "float",
											Start: ast.Position{
												Column: 144,
												Line:   78,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 149,
													Line:   78,
												},
												File:   "promql.flux",
												Source: "float",
												Start: ast.Position{
													Column: 144,
													Line:   78,
												},
											},
										},
										Name: "float",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 130,
											Line:   78,
										},
										File:   "promql.flux",
										Source: "B",
										Start: ast.Position{
											Column: 129,
											Line:   78,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// promqlMinute() implements functionality equivalent to PromQL's minute() function:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#minute\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 21,
						Line:   83,
					},
					File:   "promql.flux",
					Source: "builtin promqlMinute",
					Start: ast.Position{
						Column: 1,
						Line:   83,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   83,
						},
						File:   "promql.flux",
						Source: "promqlMinute",
						Start: ast.Position{
							Column: 9,
							Line:   83,
						},
					},
				},
				Name: "promqlMinute",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 51,
							Line:   83,
						},
						File:   "promql.flux",
						Source: "(timestamp: float) => float",
						Start: ast.Position{
							Column: 24,
							Line:   83,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 51,
								Line:   83,
							},
							File:   "promql.flux",
							Source: "(timestamp: float) => float",
							Start: ast.Position{
								Column: 24,
								Line:   83,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   83,
								},
								File:   "promql.flux",
								Source: "timestamp: float",
								Start: ast.Position{
									Column: 25,
									Line:   83,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   83,
									},
									File:   "promql.flux",
									Source: "timestamp",
									Start: ast.Position{
										Column: 25,
										Line:   83,
									},
								},
							},
							Name: "timestamp",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   83,
									},
									File:   "promql.flux",
									Source: "float",
									Start: ast.Position{
										Column: 36,
										Line:   83,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   83,
										},
										File:   "promql.flux",
										Source: "float",
										Start: ast.Position{
											Column: 36,
											Line:   83,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   83,
								},
								File:   "promql.flux",
								Source: "float",
								Start: ast.Position{
									Column: 46,
									Line:   83,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   83,
									},
									File:   "promql.flux",
									Source: "float",
									Start: ast.Position{
										Column: 46,
										Line:   83,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// promqlMonth() implements functionality equivalent to PromQL's month() function:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#month\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   88,
					},
					File:   "promql.flux",
					Source: "builtin promqlMonth",
					Start: ast.Position{
						Column: 1,
						Line:   88,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   88,
						},
						File:   "promql.flux",
						Source: "promqlMonth",
						Start: ast.Position{
							Column: 9,
							Line:   88,
						},
					},
				},
				Name: "promqlMonth",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 50,
							Line:   88,
						},
						File:   "promql.flux",
						Source: "(timestamp: float) => float",
						Start: ast.Position{
							Column: 23,
							Line:   88,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   88,
							},
							File:   "promql.flux",
							Source: "(timestamp: float) => float",
							Start: ast.Position{
								Column: 23,
								Line:   88,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   88,
								},
								File:   "promql.flux",
								Source: "timestamp: float",
								Start: ast.Position{
									Column: 24,
									Line:   88,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   88,
									},
									File:   "promql.flux",
									Source: "timestamp",
									Start: ast.Position{
										Column: 24,
										Line:   88,
									},
								},
							},
							Name: "timestamp",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   88,
									},
									File:   "promql.flux",
									Source: "float",
									Start: ast.Position{
										Column: 35,
										Line:   88,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   88,
										},
										File:   "promql.flux",
										Source: "float",
										Start: ast.Position{
											Column: 35,
											Line:   88,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   88,
								},
								File:   "promql.flux",
								Source: "float",
								Start: ast.Position{
									Column: 45,
									Line:   88,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   88,
									},
									File:   "promql.flux",
									Source: "float",
									Start: ast.Position{
										Column: 45,
										Line:   88,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// promHistogramQuantile() implements functionality equivalent to PromQL's\n"}, ast.Comment{Text: "// histogram_quantile() function:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#histogram_quantile\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 30,
						Line:   94,
					},
					File:   "promql.flux",
					Source: "builtin promHistogramQuantile",
					Start: ast.Position{
						Column: 1,
						Line:   94,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   94,
						},
						File:   "promql.flux",
						Source: "promHistogramQuantile",
						Start: ast.Position{
							Column: 9,
							Line:   94,
						},
					},
				},
				Name: "promHistogramQuantile",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   102,
						},
						File:   "promql.flux",
						Source: "(\n    <-tables: [A],\n    ?quantile: float,\n    ?countColumn: string,\n    ?upperBoundColumn: string,\n    ?valueColumn: string,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 33,
							Line:   94,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   101,
							},
							File:   "promql.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   101,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   101,
								},
								File:   "promql.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   101,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   101,
								},
								File:   "promql.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   101,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   102,
							},
							File:   "promql.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   102,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   102,
								},
								File:   "promql.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   102,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   102,
								},
								File:   "promql.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   102,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   100,
							},
							File:   "promql.flux",
							Source: "(\n    <-tables: [A],\n    ?quantile: float,\n    ?countColumn: string,\n    ?upperBoundColumn: string,\n    ?valueColumn: string,\n) => [B]",
							Start: ast.Position{
								Column: 33,
								Line:   94,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   95,
								},
								File:   "promql.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   95,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   95,
									},
									File:   "promql.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   95,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   95,
									},
									File:   "promql.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   95,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   95,
										},
										File:   "promql.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   95,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   95,
											},
											File:   "promql.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   95,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   96,
								},
								File:   "promql.flux",
								Source: "?quantile: float",
								Start: ast.Position{
									Column: 5,
									Line:   96,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   96,
									},
									File:   "promql.flux",
									Source: "quantile",
									Start: ast.Position{
										Column: 6,
										Line:   96,
									},
								},
							},
							Name: "quantile",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   96,
									},
									File:   "promql.flux",
									Source: "float",
									Start: ast.Position{
										Column: 16,
										Line:   96,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   96,
										},
										File:   "promql.flux",
										Source: "float",
										Start: ast.Position{
											Column: 16,
											Line:   96,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   97,
								},
								File:   "promql.flux",
								Source: "?countColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   97,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   97,
									},
									File:   "promql.flux",
									Source: "countColumn",
									Start: ast.Position{
										Column: 6,
										Line:   97,
									},
								},
							},
							Name: "countColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   97,
									},
									File:   "promql.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   97,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   97,
										},
										File:   "promql.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   97,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   98,
								},
								File:   "promql.flux",
								Source: "?upperBoundColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   98,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   98,
									},
									File:   "promql.flux",
									Source: "upperBoundColumn",
									Start: ast.Position{
										Column: 6,
										Line:   98,
									},
								},
							},
							Name: "upperBoundColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   98,
									},
									File:   "promql.flux",
									Source: "string",
									Start: ast.Position{
										Column: 24,
										Line:   98,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   98,
										},
										File:   "promql.flux",
										Source: "string",
										Start: ast.Position{
											Column: 24,
											Line:   98,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   99,
								},
								File:   "promql.flux",
								Source: "?valueColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   99,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   99,
									},
									File:   "promql.flux",
									Source: "valueColumn",
									Start: ast.Position{
										Column: 6,
										Line:   99,
									},
								},
							},
							Name: "valueColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   99,
									},
									File:   "promql.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   99,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   99,
										},
										File:   "promql.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   99,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   100,
								},
								File:   "promql.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   100,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   100,
									},
									File:   "promql.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   100,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   100,
										},
										File:   "promql.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   100,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// resets() implements functionality equivalent to PromQL's resets() function:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#resets\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   107,
					},
					File:   "promql.flux",
					Source: "builtin resets",
					Start: ast.Position{
						Column: 1,
						Line:   107,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   107,
						},
						File:   "promql.flux",
						Source: "resets",
						Start: ast.Position{
							Column: 9,
							Line:   107,
						},
					},
				},
				Name: "resets",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 82,
							Line:   107,
						},
						File:   "promql.flux",
						Source: "(<-tables: [{A with _value: float}]) => [{B with _value: float}]",
						Start: ast.Position{
							Column: 18,
							Line:   107,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   107,
							},
							File:   "promql.flux",
							Source: "(<-tables: [{A with _value: float}]) => [{B with _value: float}]",
							Start: ast.Position{
								Column: 18,
								Line:   107,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   107,
								},
								File:   "promql.flux",
								Source: "<-tables: [{A with _value: float}]",
								Start: ast.Position{
									Column: 19,
									Line:   107,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   107,
									},
									File:   "promql.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   107,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   107,
									},
									File:   "promql.flux",
									Source: "[{A with _value: float}]",
									Start: ast.Position{
										Column: 29,
										Line:   107,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   107,
										},
										File:   "promql.flux",
										Source: "{A with _value: float}",
										Start: ast.Position{
											Column: 30,
											Line:   107,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 51,
												Line:   107,
											},
											File:   "promql.flux",
											Source: "_value: float",
											Start: ast.Position{
												Column: 38,
												Line:   107,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 44,
													Line:   107,
												},
												File:   "promql.flux",
												Source: "_value",
												Start: ast.Position{
													Column: 38,
													Line:   107,
												},
											},
										},
										Name: "_value",
									},
									Ty: &ast.NamedType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   107,
												},
												File:   "promql.flux",
												Source: "float",
												Start: ast.Position{
													Column: 46,
													Line:   107,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 51,
														Line:   107,
													},
													File:   "promql.flux",
													Source: "float",
													Start: ast.Position{
														Column: 46,
														Line:   107,
													},
												},
											},
											Name: "float",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   107,
											},
											File:   "promql.flux",
											Source: "A",
											Start: ast.Position{
												Column: 31,
												Line:   107,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   107,
								},
								File:   "promql.flux",
								Source: "[{B with _value: float}]",
								Start: ast.Position{
									Column: 58,
									Line:   107,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   107,
									},
									File:   "promql.flux",
									Source: "{B with _value: float}",
									Start: ast.Position{
										Column: 59,
										Line:   107,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   107,
										},
										File:   "promql.flux",
										Source: "_value: float",
										Start: ast.Position{
											Column: 67,
											Line:   107,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   107,
											},
											File:   "promql.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 67,
												Line:   107,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   107,
											},
											File:   "promql.flux",
											Source: "float",
											Start: ast.Position{
												Column: 75,
												Line:   107,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   107,
												},
												File:   "promql.flux",
												Source: "float",
												Start: ast.Position{
													Column: 75,
													Line:   107,
												},
											},
										},
										Name: "float",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   107,
										},
										File:   "promql.flux",
										Source: "B",
										Start: ast.Position{
											Column: 60,
											Line:   107,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// timestamp() implements functionality equivalent to PromQL's timestamp() function:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#timestamp\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   112,
					},
					File:   "promql.flux",
					Source: "builtin timestamp",
					Start: ast.Position{
						Column: 1,
						Line:   112,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   112,
						},
						File:   "promql.flux",
						Source: "timestamp",
						Start: ast.Position{
							Column: 9,
							Line:   112,
						},
					},
				},
				Name: "timestamp",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 85,
							Line:   112,
						},
						File:   "promql.flux",
						Source: "(<-tables: [{A with _value: float}]) => [{A with _value: float}]",
						Start: ast.Position{
							Column: 21,
							Line:   112,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 85,
								Line:   112,
							},
							File:   "promql.flux",
							Source: "(<-tables: [{A with _value: float}]) => [{A with _value: float}]",
							Start: ast.Position{
								Column: 21,
								Line:   112,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   112,
								},
								File:   "promql.flux",
								Source: "<-tables: [{A with _value: float}]",
								Start: ast.Position{
									Column: 22,
									Line:   112,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   112,
									},
									File:   "promql.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 24,
										Line:   112,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   112,
									},
									File:   "promql.flux",
									Source: "[{A with _value: float}]",
									Start: ast.Position{
										Column: 32,
										Line:   112,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   112,
										},
										File:   "promql.flux",
										Source: "{A with _value: float}",
										Start: ast.Position{
											Column: 33,
											Line:   112,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   112,
											},
											File:   "promql.flux",
											Source: "_value: float",
											Start: ast.Position{
												Column: 41,
												Line:   112,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   112,
												},
												File:   "promql.flux",
												Source: "_value",
												Start: ast.Position{
													Column: 41,
													Line:   112,
												},
											},
										},
										Name: "_value",
									},
									Ty: &ast.NamedType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   112,
												},
												File:   "promql.flux",
												Source: "float",
												Start: ast.Position{
													Column: 49,
													Line:   112,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   112,
													},
													File:   "promql.flux",
													Source: "float",
													Start: ast.Position{
														Column: 49,
														Line:   112,
													},
												},
											},
											Name: "float",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   112,
											},
											File:   "promql.flux",
											Source: "A",
											Start: ast.Position{
												Column: 34,
												Line:   112,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   112,
								},
								File:   "promql.flux",
								Source: "[{A with _value: float}]",
								Start: ast.Position{
									Column: 61,
									Line:   112,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   112,
									},
									File:   "promql.flux",
									Source: "{A with _value: float}",
									Start: ast.Position{
										Column: 62,
										Line:   112,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 83,
											Line:   112,
										},
										File:   "promql.flux",
										Source: "_value: float",
										Start: ast.Position{
											Column: 70,
											Line:   112,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   112,
											},
											File:   "promql.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 70,
												Line:   112,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 83,
												Line:   112,
											},
											File:   "promql.flux",
											Source: "float",
											Start: ast.Position{
												Column: 78,
												Line:   112,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 83,
													Line:   112,
												},
												File:   "promql.flux",
												Source: "float",
												Start: ast.Position{
													Column: 78,
													Line:   112,
												},
											},
										},
										Name: "float",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   112,
										},
										File:   "promql.flux",
										Source: "A",
										Start: ast.Position{
											Column: 63,
											Line:   112,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// promqlYear() implements functionality equivalent to PromQL's year() function:\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// https://prometheus.io/docs/prometheus/latest/querying/functions/#year\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   117,
					},
					File:   "promql.flux",
					Source: "builtin promqlYear",
					Start: ast.Position{
						Column: 1,
						Line:   117,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   117,
						},
						File:   "promql.flux",
						Source: "promqlYear",
						Start: ast.Position{
							Column: 9,
							Line:   117,
						},
					},
				},
				Name: "promqlYear",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 49,
							Line:   117,
						},
						File:   "promql.flux",
						Source: "(timestamp: float) => float",
						Start: ast.Position{
							Column: 22,
							Line:   117,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   117,
							},
							File:   "promql.flux",
							Source: "(timestamp: float) => float",
							Start: ast.Position{
								Column: 22,
								Line:   117,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   117,
								},
								File:   "promql.flux",
								Source: "timestamp: float",
								Start: ast.Position{
									Column: 23,
									Line:   117,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   117,
									},
									File:   "promql.flux",
									Source: "timestamp",
									Start: ast.Position{
										Column: 23,
										Line:   117,
									},
								},
							},
							Name: "timestamp",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   117,
									},
									File:   "promql.flux",
									Source: "float",
									Start: ast.Position{
										Column: 34,
										Line:   117,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   117,
										},
										File:   "promql.flux",
										Source: "float",
										Start: ast.Position{
											Column: 34,
											Line:   117,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   117,
								},
								File:   "promql.flux",
								Source: "float",
								Start: ast.Position{
									Column: 44,
									Line:   117,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   117,
									},
									File:   "promql.flux",
									Source: "float",
									Start: ast.Position{
										Column: 44,
										Line:   117,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 99,
						Line:   132,
					},
					File:   "promql.flux",
					Source: "quantile = (q, tables=<-, method=\"exact_mean\") => \n    // value is in normal range. We can use the normal quantile function\n    if q <= 1.0 and q >= 0.0 then\n        tables\n            |> universe.quantile(q: q, method: method)\n    else if q < 0.0 then\n        tables\n            |> reduce(identity: {_value: math.mInf(sign: -1)}, fn: (r, accumulator) => accumulator)\n    else\n        tables\n            |> reduce(identity: {_value: math.mInf(sign: 1)}, fn: (r, accumulator) => accumulator)",
					Start: ast.Position{
						Column: 1,
						Line:   122,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// quantile() accounts checks for quantile values that are out of range, above 1.0 or \n"}, ast.Comment{Text: "// below 0.0, by either returning positive infinity or negative infinity in the `_value` \n"}, ast.Comment{Text: "// column respectively. q must be a float \n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   122,
						},
						File:   "promql.flux",
						Source: "quantile",
						Start: ast.Position{
							Column: 1,
							Line:   122,
						},
					},
				},
				Name: "quantile",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 99,
							Line:   132,
						},
						File:   "promql.flux",
						Source: "(q, tables=<-, method=\"exact_mean\") => \n    // value is in normal range. We can use the normal quantile function\n    if q <= 1.0 and q >= 0.0 then\n        tables\n            |> universe.quantile(q: q, method: method)\n    else if q < 0.0 then\n        tables\n            |> reduce(identity: {_value: math.mInf(sign: -1)}, fn: (r, accumulator) => accumulator)\n    else\n        tables\n            |> reduce(identity: {_value: math.mInf(sign: 1)}, fn: (r, accumulator) => accumulator)",
						Start: ast.Position{
							Column: 12,
							Line:   122,
						},
					},
				},
				Body: &ast.ConditionalExpression{
					Alternate: &ast.ConditionalExpression{
						Alternate: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   131,
										},
										File:   "promql.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 9,
											Line:   131,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   132,
									},
									File:   "promql.flux",
									Source: "tables\n            |> reduce(identity: {_value: math.mInf(sign: 1)}, fn: (r, accumulator) => accumulator)",
									Start: ast.Position{
										Column: 9,
										Line:   131,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   132,
											},
											File:   "promql.flux",
											Source: "identity: {_value: math.mInf(sign: 1)}, fn: (r, accumulator) => accumulator",
											Start: ast.Position{
												Column: 23,
												Line:   132,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   132,
												},
												File:   "promql.flux",
												Source: "identity: {_value: math.mInf(sign: 1)}",
												Start: ast.Position{
													Column: 23,
													Line:   132,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   132,
													},
													File:   "promql.flux",
													Source: "identity",
													Start: ast.Position{
														Column: 23,
														Line:   132,
													},
												},
											},
											Name: "identity",
										},
										Separator: nil,
										Value: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   132,
													},
													File:   "promql.flux",
													Source: "{_value: math.mInf(sign: 1)}",
													Start: ast.Position{
														Column: 33,
														Line:   132,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   132,
														},
														File:   "promql.flux",
														Source: "_value: math.mInf(sign: 1)",
														Start: ast.Position{
															Column: 34,
															Line:   132,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   132,
															},
															File:   "promql.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 34,
																Line:   132,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 59,
																	Line:   132,
																},
																File:   "promql.flux",
																Source: "sign: 1",
																Start: ast.Position{
																	Column: 52,
																	Line:   132,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 59,
																		Line:   132,
																	},
																	File:   "promql.flux",
																	Source: "sign: 1",
																	Start: ast.Position{
																		Column: 52,
																		Line:   132,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 56,
																			Line:   132,
																		},
																		File:   "promql.flux",
																		Source: "sign",
																		Start: ast.Position{
																			Column: 52,
																			Line:   132,
																		},
																	},
																},
																Name: "sign",
															},
															Separator: nil,
															Value: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 59,
																			Line:   132,
																		},
																		File:   "promql.flux",
																		Source: "1",
																		Start: ast.Position{
																			Column: 58,
																			Line:   132,
																		},
																	},
																},
																Value: int64(1),
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 60,
																Line:   132,
															},
															File:   "promql.flux",
															Source: "math.mInf(sign: 1)",
															Start: ast.Position{
																Column: 42,
																Line:   132,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 51,
																	Line:   132,
																},
																File:   "promql.flux",
																Source: "math.mInf",
																Start: ast.Position{
																	Column: 42,
																	Line:   132,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   132,
																	},
																	File:   "promql.flux",
																	Source: "math",
																	Start: ast.Position{
																		Column: 42,
																		Line:   132,
																	},
																},
															},
															Name: "math",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 51,
																		Line:   132,
																	},
																	File:   "promql.flux",
																	Source: "mInf",
																	Start: ast.Position{
																		Column: 47,
																		Line:   132,
																	},
																},
															},
															Name: "mInf",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 98,
													Line:   132,
												},
												File:   "promql.flux",
												Source: "fn: (r, accumulator) => accumulator",
												Start: ast.Position{
													Column: 63,
													Line:   132,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 65,
														Line:   132,
													},
													File:   "promql.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 63,
														Line:   132,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 98,
														Line:   132,
													},
													File:   "promql.flux",
													Source: "(r, accumulator) => accumulator",
													Start: ast.Position{
														Column: 67,
														Line:   132,
													},
												},
											},
											Body: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 98,
															Line:   132,
														},
														File:   "promql.flux",
														Source: "accumulator",
														Start: ast.Position{
															Column: 87,
															Line:   132,
														},
													},
												},
												Name: "accumulator",
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   132,
														},
														File:   "promql.flux",
														Source: "r",
														Start: ast.Position{
															Column: 68,
															Line:   132,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   132,
															},
															File:   "promql.flux",
															Source: "r",
															Start: ast.Position{
																Column: 68,
																Line:   132,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   132,
														},
														File:   "promql.flux",
														Source: "accumulator",
														Start: ast.Position{
															Column: 71,
															Line:   132,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 82,
																Line:   132,
															},
															File:   "promql.flux",
															Source: "accumulator",
															Start: ast.Position{
																Column: 71,
																Line:   132,
															},
														},
													},
													Name: "accumulator",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 99,
											Line:   132,
										},
										File:   "promql.flux",
										Source: "reduce(identity: {_value: math.mInf(sign: 1)}, fn: (r, accumulator) => accumulator)",
										Start: ast.Position{
											Column: 16,
											Line:   132,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   132,
											},
											File:   "promql.flux",
											Source: "reduce",
											Start: ast.Position{
												Column: 16,
												Line:   132,
											},
										},
									},
									Name: "reduce",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   132,
								},
								File:   "promql.flux",
								Source: "if q < 0.0 then\n        tables\n            |> reduce(identity: {_value: math.mInf(sign: -1)}, fn: (r, accumulator) => accumulator)\n    else\n        tables\n            |> reduce(identity: {_value: math.mInf(sign: 1)}, fn: (r, accumulator) => accumulator)",
								Start: ast.Position{
									Column: 10,
									Line:   127,
								},
							},
						},
						Consequent: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 15,
											Line:   128,
										},
										File:   "promql.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 9,
											Line:   128,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 100,
										Line:   129,
									},
									File:   "promql.flux",
									Source: "tables\n            |> reduce(identity: {_value: math.mInf(sign: -1)}, fn: (r, accumulator) => accumulator)",
									Start: ast.Position{
										Column: 9,
										Line:   128,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 99,
												Line:   129,
											},
											File:   "promql.flux",
											Source: "identity: {_value: math.mInf(sign: -1)}, fn: (r, accumulator) => accumulator",
											Start: ast.Position{
												Column: 23,
												Line:   129,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 62,
													Line:   129,
												},
												File:   "promql.flux",
												Source: "identity: {_value: math.mInf(sign: -1)}",
												Start: ast.Position{
													Column: 23,
													Line:   129,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   129,
													},
													File:   "promql.flux",
													Source: "identity",
													Start: ast.Position{
														Column: 23,
														Line:   129,
													},
												},
											},
											Name: "identity",
										},
										Separator: nil,
										Value: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 62,
														Line:   129,
													},
													File:   "promql.flux",
													Source: "{_value: math.mInf(sign: -1)}",
													Start: ast.Position{
														Column: 33,
														Line:   129,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   129,
														},
														File:   "promql.flux",
														Source: "_value: math.mInf(sign: -1)",
														Start: ast.Position{
															Column: 34,
															Line:   129,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   129,
															},
															File:   "promql.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 34,
																Line:   129,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 60,
																	Line:   129,
																},
																File:   "promql.flux",
																Source: "sign: -1",
																Start: ast.Position{
																	Column: 52,
																	Line:   129,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 60,
																		Line:   129,
																	},
																	File:   "promql.flux",
																	Source: "sign: -1",
																	Start: ast.Position{
																		Column: 52,
																		Line:   129,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 56,
																			Line:   129,
																		},
																		File:   "promql.flux",
																		Source: "sign",
																		Start: ast.Position{
																			Column: 52,
																			Line:   129,
																		},
																	},
																},
																Name: "sign",
															},
															Separator: nil,
															Value: &ast.UnaryExpression{
																Argument: &ast.IntegerLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 60,
																				Line:   129,
																			},
																			File:   "promql.flux",
																			Source: "1",
																			Start: ast.Position{
																				Column: 59,
																				Line:   129,
																			},
																		},
																	},
																	Value: int64(1),
																},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 60,
																			Line:   129,
																		},
																		File:   "promql.flux",
																		Source: "-1",
																		Start: ast.Position{
																			Column: 58,
																			Line:   129,
																		},
																	},
																},
																Operator: 6,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 61,
																Line:   129,
															},
															File:   "promql.flux",
															Source: "math.mInf(sign: -1)",
															Start: ast.Position{
																Column: 42,
																Line:   129,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 51,
																	Line:   129,
																},
																File:   "promql.flux",
																Source: "math.mInf",
																Start: ast.Position{
																	Column: 42,
																	Line:   129,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   129,
																	},
																	File:   "promql.flux",
																	Source: "math",
																	Start: ast.Position{
																		Column: 42,
																		Line:   129,
																	},
																},
															},
															Name: "math",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 51,
																		Line:   129,
																	},
																	File:   "promql.flux",
																	Source: "mInf",
																	Start: ast.Position{
																		Column: 47,
																		Line:   129,
																	},
																},
															},
															Name: "mInf",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 99,
													Line:   129,
												},
												File:   "promql.flux",
												Source: "fn: (r, accumulator) => accumulator",
												Start: ast.Position{
													Column: 64,
													Line:   129,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   129,
													},
													File:   "promql.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 64,
														Line:   129,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 99,
														Line:   129,
													},
													File:   "promql.flux",
													Source: "(r, accumulator) => accumulator",
													Start: ast.Position{
														Column: 68,
														Line:   129,
													},
												},
											},
											Body: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 99,
															Line:   129,
														},
														File:   "promql.flux",
														Source: "accumulator",
														Start: ast.Position{
															Column: 88,
															Line:   129,
														},
													},
												},
												Name: "accumulator",
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   129,
														},
														File:   "promql.flux",
														Source: "r",
														Start: ast.Position{
															Column: 69,
															Line:   129,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 70,
																Line:   129,
															},
															File:   "promql.flux",
															Source: "r",
															Start: ast.Position{
																Column: 69,
																Line:   129,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 83,
															Line:   129,
														},
														File:   "promql.flux",
														Source: "accumulator",
														Start: ast.Position{
															Column: 72,
															Line:   129,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 83,
																Line:   129,
															},
															File:   "promql.flux",
															Source: "accumulator",
															Start: ast.Position{
																Column: 72,
																Line:   129,
															},
														},
													},
													Name: "accumulator",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 100,
											Line:   129,
										},
										File:   "promql.flux",
										Source: "reduce(identity: {_value: math.mInf(sign: -1)}, fn: (r, accumulator) => accumulator)",
										Start: ast.Position{
											Column: 16,
											Line:   129,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   129,
											},
											File:   "promql.flux",
											Source: "reduce",
											Start: ast.Position{
												Column: 16,
												Line:   129,
											},
										},
									},
									Name: "reduce",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Test: &ast.BinaryExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   127,
									},
									File:   "promql.flux",
									Source: "q < 0.0",
									Start: ast.Position{
										Column: 13,
										Line:   127,
									},
								},
							},
							Left: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   127,
										},
										File:   "promql.flux",
										Source: "q",
										Start: ast.Position{
											Column: 13,
											Line:   127,
										},
									},
								},
								Name: "q",
							},
							Operator: 8,
							Right: &ast.FloatLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   127,
										},
										File:   "promql.flux",
										Source: "0.0",
										Start: ast.Position{
											Column: 17,
											Line:   127,
										},
									},
								},
								Value: 0.0,
							},
						},
						Tk_else: nil,
						Tk_if:   nil,
						Tk_then: nil,
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   132,
							},
							File:   "promql.flux",
							Source: "if q <= 1.0 and q >= 0.0 then\n        tables\n            |> universe.quantile(q: q, method: method)\n    else if q < 0.0 then\n        tables\n            |> reduce(identity: {_value: math.mInf(sign: -1)}, fn: (r, accumulator) => accumulator)\n    else\n        tables\n            |> reduce(identity: {_value: math.mInf(sign: 1)}, fn: (r, accumulator) => accumulator)",
							Start: ast.Position{
								Column: 5,
								Line:   124,
							},
						},
					},
					Consequent: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   125,
									},
									File:   "promql.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 9,
										Line:   125,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   126,
								},
								File:   "promql.flux",
								Source: "tables\n            |> universe.quantile(q: q, method: method)",
								Start: ast.Position{
									Column: 9,
									Line:   125,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   126,
										},
										File:   "promql.flux",
										Source: "q: q, method: method",
										Start: ast.Position{
											Column: 34,
											Line:   126,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   126,
											},
											File:   "promql.flux",
											Source: "q: q",
											Start: ast.Position{
												Column: 34,
												Line:   126,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   126,
												},
												File:   "promql.flux",
												Source: "q",
												Start: ast.Position{
													Column: 34,
													Line:   126,
												},
											},
										},
										Name: "q",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   126,
												},
												File:   "promql.flux",
												Source: "q",
												Start: ast.Position{
													Column: 37,
													Line:   126,
												},
											},
										},
										Name: "q",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   126,
											},
											File:   "promql.flux",
											Source: "method: method",
											Start: ast.Position{
												Column: 40,
												Line:   126,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   126,
												},
												File:   "promql.flux",
												Source: "method",
												Start: ast.Position{
													Column: 40,
													Line:   126,
												},
											},
										},
										Name: "method",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   126,
												},
												File:   "promql.flux",
												Source: "method",
												Start: ast.Position{
													Column: 48,
													Line:   126,
												},
											},
										},
										Name: "method",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   126,
									},
									File:   "promql.flux",
									Source: "universe.quantile(q: q, method: method)",
									Start: ast.Position{
										Column: 16,
										Line:   126,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   126,
										},
										File:   "promql.flux",
										Source: "universe.quantile",
										Start: ast.Position{
											Column: 16,
											Line:   126,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   126,
											},
											File:   "promql.flux",
											Source: "universe",
											Start: ast.Position{
												Column: 16,
												Line:   126,
											},
										},
									},
									Name: "universe",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   126,
											},
											File:   "promql.flux",
											Source: "quantile",
											Start: ast.Position{
												Column: 25,
												Line:   126,
											},
										},
									},
									Name: "quantile",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Test: &ast.LogicalExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   124,
								},
								File:   "promql.flux",
								Source: "q <= 1.0 and q >= 0.0",
								Start: ast.Position{
									Column: 8,
									Line:   124,
								},
							},
						},
						Left: &ast.BinaryExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   124,
									},
									File:   "promql.flux",
									Source: "q <= 1.0",
									Start: ast.Position{
										Column: 8,
										Line:   124,
									},
								},
							},
							Left: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   124,
										},
										File:   "promql.flux",
										Source: "q",
										Start: ast.Position{
											Column: 8,
											Line:   124,
										},
									},
								},
								Name: "q",
							},
							Operator: 7,
							Right: &ast.FloatLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   124,
										},
										File:   "promql.flux",
										Source: "1.0",
										Start: ast.Position{
											Column: 13,
											Line:   124,
										},
									},
								},
								Value: 1.0,
							},
						},
						Operator: 1,
						Right: &ast.BinaryExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   124,
									},
									File:   "promql.flux",
									Source: "q >= 0.0",
									Start: ast.Position{
										Column: 21,
										Line:   124,
									},
								},
							},
							Left: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   124,
										},
										File:   "promql.flux",
										Source: "q",
										Start: ast.Position{
											Column: 21,
											Line:   124,
										},
									},
								},
								Name: "q",
							},
							Operator: 9,
							Right: &ast.FloatLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   124,
										},
										File:   "promql.flux",
										Source: "0.0",
										Start: ast.Position{
											Column: 26,
											Line:   124,
										},
									},
								},
								Value: 0.0,
							},
						},
					},
					Tk_else: nil,
					Tk_if:   []ast.Comment{ast.Comment{Text: "// value is in normal range. We can use the normal quantile function\n"}},
					Tk_then: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   122,
							},
							File:   "promql.flux",
							Source: "q",
							Start: ast.Position{
								Column: 13,
								Line:   122,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   122,
								},
								File:   "promql.flux",
								Source: "q",
								Start: ast.Position{
									Column: 13,
									Line:   122,
								},
							},
						},
						Name: "q",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   122,
							},
							File:   "promql.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 16,
								Line:   122,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   122,
								},
								File:   "promql.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 16,
									Line:   122,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   122,
							},
							File:   "promql.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 23,
								Line:   122,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 46,
								Line:   122,
							},
							File:   "promql.flux",
							Source: "method=\"exact_mean\"",
							Start: ast.Position{
								Column: 27,
								Line:   122,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   122,
								},
								File:   "promql.flux",
								Source: "method",
								Start: ast.Position{
									Column: 27,
									Line:   122,
								},
							},
						},
						Name: "method",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   122,
								},
								File:   "promql.flux",
								Source: "\"exact_mean\"",
								Start: ast.Position{
									Column: 34,
									Line:   122,
								},
							},
						},
						Value: "exact_mean",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   133,
					},
					File:   "promql.flux",
					Source: "join = experimental.join",
					Start: ast.Position{
						Column: 1,
						Line:   133,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   133,
						},
						File:   "promql.flux",
						Source: "join",
						Start: ast.Position{
							Column: 1,
							Line:   133,
						},
					},
				},
				Name: "join",
			},
			Init: &ast.MemberExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   133,
						},
						File:   "promql.flux",
						Source: "experimental.join",
						Start: ast.Position{
							Column: 8,
							Line:   133,
						},
					},
				},
				Lbrack: nil,
				Object: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   133,
							},
							File:   "promql.flux",
							Source: "experimental",
							Start: ast.Position{
								Column: 8,
								Line:   133,
							},
						},
					},
					Name: "experimental",
				},
				Property: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   133,
							},
							File:   "promql.flux",
							Source: "join",
							Start: ast.Position{
								Column: 21,
								Line:   133,
							},
						},
					},
					Name: "join",
				},
				Rbrack: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "promql.flux",
					Source: "import \"math\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "promql.flux",
						Source: "\"math\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "math",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   6,
					},
					File:   "promql.flux",
					Source: "import \"universe\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   6,
						},
						File:   "promql.flux",
						Source: "\"universe\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "universe",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   7,
					},
					File:   "promql.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   7,
						},
						File:   "promql.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "experimental",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "promql.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// THIS PACKAGE IS NOT MEANT FOR EXTERNAL USE.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   2,
					},
					File:   "promql.flux",
					Source: "package promql",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   2,
						},
						File:   "promql.flux",
						Source: "promql",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "promql",
			},
		},
	}},
	Package: "promql",
	Path:    "internal/promql",
}
