// DO NOT EDIT: This file is autogenerated via the builtin command.

package pandas

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 132,
					Line:   37,
				},
				File:   "capitalize_strings_toUpper_test.flux",
				Source: "package pandas_test\n\n\nimport \"testing\"\nimport \"strings\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,A,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,K9N  GM,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,B  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDE,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,CLNSKNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\nt_string_toUpper = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.toUpper(v: r._value), _time: r._time}))\n\ntest _string_toUpper = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toUpper})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "capitalize_strings_toUpper_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "capitalize_strings_toUpper_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "capitalize_strings_toUpper_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "capitalize_strings_toUpper_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "capitalize_strings_toUpper_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "capitalize_strings_toUpper_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,A,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,K9N  GM,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,B  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDE,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,CLNSKNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,A,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,K9N  GM,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,B  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDE,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,CLNSKNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,A,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,K9N  GM,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,B  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDE,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,CLNSKNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 87,
						Line:   35,
					},
					File:   "capitalize_strings_toUpper_test.flux",
					Source: "t_string_toUpper = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.toUpper(v: r._value), _time: r._time}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   33,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "t_string_toUpper",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_toUpper",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 87,
							Line:   35,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.toUpper(v: r._value), _time: r._time}))",
						Start: ast.Position{
							Column: 20,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   33,
									},
									File:   "capitalize_strings_toUpper_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 34,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "capitalize_strings_toUpper_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)",
								Start: ast.Position{
									Column: 34,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "capitalize_strings_toUpper_test.flux",
										Source: "start: 2018-05-22T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "capitalize_strings_toUpper_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "capitalize_strings_toUpper_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "capitalize_strings_toUpper_test.flux",
												Source: "2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "capitalize_strings_toUpper_test.flux",
									Source: "range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "capitalize_strings_toUpper_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 87,
								Line:   35,
							},
							File:   "capitalize_strings_toUpper_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.toUpper(v: r._value), _time: r._time}))",
							Start: ast.Position{
								Column: 34,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 86,
										Line:   35,
									},
									File:   "capitalize_strings_toUpper_test.flux",
									Source: "fn: (r) => ({r with _value: strings.toUpper(v: r._value), _time: r._time})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 86,
											Line:   35,
										},
										File:   "capitalize_strings_toUpper_test.flux",
										Source: "fn: (r) => ({r with _value: strings.toUpper(v: r._value), _time: r._time})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "capitalize_strings_toUpper_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 86,
												Line:   35,
											},
											File:   "capitalize_strings_toUpper_test.flux",
											Source: "(r) => ({r with _value: strings.toUpper(v: r._value), _time: r._time})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 86,
													Line:   35,
												},
												File:   "capitalize_strings_toUpper_test.flux",
												Source: "({r with _value: strings.toUpper(v: r._value), _time: r._time})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 85,
														Line:   35,
													},
													File:   "capitalize_strings_toUpper_test.flux",
													Source: "{r with _value: strings.toUpper(v: r._value), _time: r._time}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 68,
															Line:   35,
														},
														File:   "capitalize_strings_toUpper_test.flux",
														Source: "_value: strings.toUpper(v: r._value)",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "capitalize_strings_toUpper_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 67,
																	Line:   35,
																},
																File:   "capitalize_strings_toUpper_test.flux",
																Source: "v: r._value",
																Start: ast.Position{
																	Column: 56,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 67,
																		Line:   35,
																	},
																	File:   "capitalize_strings_toUpper_test.flux",
																	Source: "v: r._value",
																	Start: ast.Position{
																		Column: 56,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 57,
																			Line:   35,
																		},
																		File:   "capitalize_strings_toUpper_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 56,
																			Line:   35,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 67,
																			Line:   35,
																		},
																		File:   "capitalize_strings_toUpper_test.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 59,
																			Line:   35,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 60,
																				Line:   35,
																			},
																			File:   "capitalize_strings_toUpper_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 59,
																				Line:   35,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 67,
																				Line:   35,
																			},
																			File:   "capitalize_strings_toUpper_test.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 61,
																				Line:   35,
																			},
																		},
																	},
																	Name: "_value",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   35,
															},
															File:   "capitalize_strings_toUpper_test.flux",
															Source: "strings.toUpper(v: r._value)",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   35,
																},
																File:   "capitalize_strings_toUpper_test.flux",
																Source: "strings.toUpper",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   35,
																	},
																	File:   "capitalize_strings_toUpper_test.flux",
																	Source: "strings",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "strings",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   35,
																	},
																	File:   "capitalize_strings_toUpper_test.flux",
																	Source: "toUpper",
																	Start: ast.Position{
																		Column: 48,
																		Line:   35,
																	},
																},
															},
															Name: "toUpper",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 84,
															Line:   35,
														},
														File:   "capitalize_strings_toUpper_test.flux",
														Source: "_time: r._time",
														Start: ast.Position{
															Column: 70,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 75,
																Line:   35,
															},
															File:   "capitalize_strings_toUpper_test.flux",
															Source: "_time",
															Start: ast.Position{
																Column: 70,
																Line:   35,
															},
														},
													},
													Name: "_time",
												},
												Separator: nil,
												Value: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 84,
																Line:   35,
															},
															File:   "capitalize_strings_toUpper_test.flux",
															Source: "r._time",
															Start: ast.Position{
																Column: 77,
																Line:   35,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 78,
																	Line:   35,
																},
																File:   "capitalize_strings_toUpper_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 77,
																	Line:   35,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 84,
																	Line:   35,
																},
																File:   "capitalize_strings_toUpper_test.flux",
																Source: "_time",
																Start: ast.Position{
																	Column: 79,
																	Line:   35,
																},
															},
														},
														Name: "_time",
													},
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "capitalize_strings_toUpper_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "capitalize_strings_toUpper_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "capitalize_strings_toUpper_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 87,
									Line:   35,
								},
								File:   "capitalize_strings_toUpper_test.flux",
								Source: "map(fn: (r) => ({r with _value: strings.toUpper(v: r._value), _time: r._time}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "capitalize_strings_toUpper_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "capitalize_strings_toUpper_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   33,
								},
								File:   "capitalize_strings_toUpper_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "capitalize_strings_toUpper_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 132,
							Line:   37,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "_string_toUpper = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toUpper})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   37,
							},
							File:   "capitalize_strings_toUpper_test.flux",
							Source: "_string_toUpper",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_string_toUpper",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 132,
								Line:   37,
							},
							File:   "capitalize_strings_toUpper_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toUpper})",
							Start: ast.Position{
								Column: 24,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 132,
									Line:   37,
								},
								File:   "capitalize_strings_toUpper_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toUpper})",
								Start: ast.Position{
									Column: 30,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 131,
										Line:   37,
									},
									File:   "capitalize_strings_toUpper_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toUpper}",
									Start: ast.Position{
										Column: 31,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   37,
										},
										File:   "capitalize_strings_toUpper_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 32,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   37,
											},
											File:   "capitalize_strings_toUpper_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 32,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   37,
												},
												File:   "capitalize_strings_toUpper_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 59,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   37,
													},
													File:   "capitalize_strings_toUpper_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 59,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   37,
														},
														File:   "capitalize_strings_toUpper_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 59,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   37,
														},
														File:   "capitalize_strings_toUpper_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 64,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   37,
											},
											File:   "capitalize_strings_toUpper_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 39,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   37,
												},
												File:   "capitalize_strings_toUpper_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 39,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   37,
													},
													File:   "capitalize_strings_toUpper_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 39,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   37,
													},
													File:   "capitalize_strings_toUpper_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 47,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 108,
											Line:   37,
										},
										File:   "capitalize_strings_toUpper_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 73,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   37,
											},
											File:   "capitalize_strings_toUpper_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 73,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 107,
													Line:   37,
												},
												File:   "capitalize_strings_toUpper_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 95,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 107,
														Line:   37,
													},
													File:   "capitalize_strings_toUpper_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 95,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 98,
															Line:   37,
														},
														File:   "capitalize_strings_toUpper_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 95,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 107,
															Line:   37,
														},
														File:   "capitalize_strings_toUpper_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 100,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 108,
												Line:   37,
											},
											File:   "capitalize_strings_toUpper_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 79,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 94,
													Line:   37,
												},
												File:   "capitalize_strings_toUpper_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 79,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 86,
														Line:   37,
													},
													File:   "capitalize_strings_toUpper_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 79,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 94,
														Line:   37,
													},
													File:   "capitalize_strings_toUpper_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 87,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 130,
											Line:   37,
										},
										File:   "capitalize_strings_toUpper_test.flux",
										Source: "fn: t_string_toUpper",
										Start: ast.Position{
											Column: 110,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 112,
												Line:   37,
											},
											File:   "capitalize_strings_toUpper_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 110,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 130,
												Line:   37,
											},
											File:   "capitalize_strings_toUpper_test.flux",
											Source: "t_string_toUpper",
											Start: ast.Position{
												Column: 114,
												Line:   37,
											},
										},
									},
									Name: "t_string_toUpper",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 132,
						Line:   37,
					},
					File:   "capitalize_strings_toUpper_test.flux",
					Source: "test _string_toUpper = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toUpper})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "capitalize_strings_toUpper_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "capitalize_strings_toUpper_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "capitalize_strings_toUpper_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "capitalize_strings_toUpper_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "capitalize_strings_toUpper_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 132,
					Line:   37,
				},
				File:   "cat_strings_joinStr_test.flux",
				Source: "package pandas_test\n\n\nimport \"testing\"\nimport \"strings\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,aPLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gmPLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  PLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDePLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI  PLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  PLUS,used_percent,disk,disk1,apfs,host.local,/\n\"\nt_string_joinStr = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")}))\n\ntest _string_joinStr = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_joinStr})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "cat_strings_joinStr_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "cat_strings_joinStr_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "cat_strings_joinStr_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "cat_strings_joinStr_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "cat_strings_joinStr_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "cat_strings_joinStr_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,aPLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gmPLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  PLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDePLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI  PLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  PLUS,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,aPLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gmPLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  PLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDePLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI  PLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  PLUS,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,aPLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gmPLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  PLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDePLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI  PLUS,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  PLUS,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 90,
						Line:   35,
					},
					File:   "cat_strings_joinStr_test.flux",
					Source: "t_string_joinStr = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   33,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "t_string_joinStr",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_joinStr",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 90,
							Line:   35,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")}))",
						Start: ast.Position{
							Column: 20,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   33,
									},
									File:   "cat_strings_joinStr_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 34,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "cat_strings_joinStr_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)",
								Start: ast.Position{
									Column: 34,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "cat_strings_joinStr_test.flux",
										Source: "start: 2018-05-22T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "cat_strings_joinStr_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "cat_strings_joinStr_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "cat_strings_joinStr_test.flux",
												Source: "2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "cat_strings_joinStr_test.flux",
									Source: "range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "cat_strings_joinStr_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 90,
								Line:   35,
							},
							File:   "cat_strings_joinStr_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")}))",
							Start: ast.Position{
								Column: 34,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 89,
										Line:   35,
									},
									File:   "cat_strings_joinStr_test.flux",
									Source: "fn: (r) => ({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 89,
											Line:   35,
										},
										File:   "cat_strings_joinStr_test.flux",
										Source: "fn: (r) => ({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "cat_strings_joinStr_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 89,
												Line:   35,
											},
											File:   "cat_strings_joinStr_test.flux",
											Source: "(r) => ({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 89,
													Line:   35,
												},
												File:   "cat_strings_joinStr_test.flux",
												Source: "({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 88,
														Line:   35,
													},
													File:   "cat_strings_joinStr_test.flux",
													Source: "{r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 87,
															Line:   35,
														},
														File:   "cat_strings_joinStr_test.flux",
														Source: "_value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "cat_strings_joinStr_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 86,
																	Line:   35,
																},
																File:   "cat_strings_joinStr_test.flux",
																Source: "arr: [r._value, \"PLUS\"], v: \"\"",
																Start: ast.Position{
																	Column: 56,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 79,
																		Line:   35,
																	},
																	File:   "cat_strings_joinStr_test.flux",
																	Source: "arr: [r._value, \"PLUS\"]",
																	Start: ast.Position{
																		Column: 56,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 59,
																			Line:   35,
																		},
																		File:   "cat_strings_joinStr_test.flux",
																		Source: "arr",
																		Start: ast.Position{
																			Column: 56,
																			Line:   35,
																		},
																	},
																},
																Name: "arr",
															},
															Separator: nil,
															Value: &ast.ArrayExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 79,
																			Line:   35,
																		},
																		File:   "cat_strings_joinStr_test.flux",
																		Source: "[r._value, \"PLUS\"]",
																		Start: ast.Position{
																			Column: 61,
																			Line:   35,
																		},
																	},
																},
																Elements: []ast.Expression{&ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 70,
																				Line:   35,
																			},
																			File:   "cat_strings_joinStr_test.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 62,
																				Line:   35,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 63,
																					Line:   35,
																				},
																				File:   "cat_strings_joinStr_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 62,
																					Line:   35,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 70,
																					Line:   35,
																				},
																				File:   "cat_strings_joinStr_test.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 64,
																					Line:   35,
																				},
																			},
																		},
																		Name: "_value",
																	},
																	Rbrack: nil,
																}, &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 78,
																				Line:   35,
																			},
																			File:   "cat_strings_joinStr_test.flux",
																			Source: "\"PLUS\"",
																			Start: ast.Position{
																				Column: 72,
																				Line:   35,
																			},
																		},
																	},
																	Value: "PLUS",
																}},
																Lbrack: nil,
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 86,
																		Line:   35,
																	},
																	File:   "cat_strings_joinStr_test.flux",
																	Source: "v: \"\"",
																	Start: ast.Position{
																		Column: 81,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 82,
																			Line:   35,
																		},
																		File:   "cat_strings_joinStr_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 81,
																			Line:   35,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 86,
																			Line:   35,
																		},
																		File:   "cat_strings_joinStr_test.flux",
																		Source: "\"\"",
																		Start: ast.Position{
																			Column: 84,
																			Line:   35,
																		},
																	},
																},
																Value: "",
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 87,
																Line:   35,
															},
															File:   "cat_strings_joinStr_test.flux",
															Source: "strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   35,
																},
																File:   "cat_strings_joinStr_test.flux",
																Source: "strings.joinStr",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   35,
																	},
																	File:   "cat_strings_joinStr_test.flux",
																	Source: "strings",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "strings",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   35,
																	},
																	File:   "cat_strings_joinStr_test.flux",
																	Source: "joinStr",
																	Start: ast.Position{
																		Column: 48,
																		Line:   35,
																	},
																},
															},
															Name: "joinStr",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "cat_strings_joinStr_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "cat_strings_joinStr_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "cat_strings_joinStr_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   35,
								},
								File:   "cat_strings_joinStr_test.flux",
								Source: "map(fn: (r) => ({r with _value: strings.joinStr(arr: [r._value, \"PLUS\"], v: \"\")}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "cat_strings_joinStr_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "cat_strings_joinStr_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   33,
								},
								File:   "cat_strings_joinStr_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "cat_strings_joinStr_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 132,
							Line:   37,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "_string_joinStr = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_joinStr})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   37,
							},
							File:   "cat_strings_joinStr_test.flux",
							Source: "_string_joinStr",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_string_joinStr",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 132,
								Line:   37,
							},
							File:   "cat_strings_joinStr_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_joinStr})",
							Start: ast.Position{
								Column: 24,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 132,
									Line:   37,
								},
								File:   "cat_strings_joinStr_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_joinStr})",
								Start: ast.Position{
									Column: 30,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 131,
										Line:   37,
									},
									File:   "cat_strings_joinStr_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_joinStr}",
									Start: ast.Position{
										Column: 31,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   37,
										},
										File:   "cat_strings_joinStr_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 32,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   37,
											},
											File:   "cat_strings_joinStr_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 32,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   37,
												},
												File:   "cat_strings_joinStr_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 59,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   37,
													},
													File:   "cat_strings_joinStr_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 59,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   37,
														},
														File:   "cat_strings_joinStr_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 59,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   37,
														},
														File:   "cat_strings_joinStr_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 64,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   37,
											},
											File:   "cat_strings_joinStr_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 39,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   37,
												},
												File:   "cat_strings_joinStr_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 39,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   37,
													},
													File:   "cat_strings_joinStr_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 39,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   37,
													},
													File:   "cat_strings_joinStr_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 47,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 108,
											Line:   37,
										},
										File:   "cat_strings_joinStr_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 73,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   37,
											},
											File:   "cat_strings_joinStr_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 73,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 107,
													Line:   37,
												},
												File:   "cat_strings_joinStr_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 95,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 107,
														Line:   37,
													},
													File:   "cat_strings_joinStr_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 95,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 98,
															Line:   37,
														},
														File:   "cat_strings_joinStr_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 95,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 107,
															Line:   37,
														},
														File:   "cat_strings_joinStr_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 100,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 108,
												Line:   37,
											},
											File:   "cat_strings_joinStr_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 79,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 94,
													Line:   37,
												},
												File:   "cat_strings_joinStr_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 79,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 86,
														Line:   37,
													},
													File:   "cat_strings_joinStr_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 79,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 94,
														Line:   37,
													},
													File:   "cat_strings_joinStr_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 87,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 130,
											Line:   37,
										},
										File:   "cat_strings_joinStr_test.flux",
										Source: "fn: t_string_joinStr",
										Start: ast.Position{
											Column: 110,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 112,
												Line:   37,
											},
											File:   "cat_strings_joinStr_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 110,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 130,
												Line:   37,
											},
											File:   "cat_strings_joinStr_test.flux",
											Source: "t_string_joinStr",
											Start: ast.Position{
												Column: 114,
												Line:   37,
											},
										},
									},
									Name: "t_string_joinStr",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 132,
						Line:   37,
					},
					File:   "cat_strings_joinStr_test.flux",
					Source: "test _string_joinStr = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_joinStr})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "cat_strings_joinStr_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "cat_strings_joinStr_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "cat_strings_joinStr_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "cat_strings_joinStr_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "cat_strings_joinStr_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 130,
					Line:   37,
				},
				File:   "center_strings_joinStr_test.flux",
				Source: "package pandas_test\n\n\nimport \"testing\"\nimport \"strings\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z, a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z, k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z, b ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z, 2COTDe ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z, cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z, 13F2 ,used_percent,disk,disk1,apfs,host.local,/\n\"\nt_string_center = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time}))\n\ntest _string_center = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_center})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "center_strings_joinStr_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "center_strings_joinStr_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "center_strings_joinStr_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "center_strings_joinStr_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "center_strings_joinStr_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "center_strings_joinStr_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z, a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z, k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z, b ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z, 2COTDe ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z, cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z, 13F2 ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z, a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z, k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z, b ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z, 2COTDe ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z, cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z, 13F2 ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z, a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z, k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z, b ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z, 2COTDe ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z, cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z, 13F2 ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 108,
						Line:   35,
					},
					File:   "center_strings_joinStr_test.flux",
					Source: "t_string_center = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   33,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "t_string_center",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_center",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 108,
							Line:   35,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time}))",
						Start: ast.Position{
							Column: 19,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   33,
									},
									File:   "center_strings_joinStr_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 33,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "center_strings_joinStr_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)",
								Start: ast.Position{
									Column: 33,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "center_strings_joinStr_test.flux",
										Source: "start: 2018-05-22T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "center_strings_joinStr_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "center_strings_joinStr_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "center_strings_joinStr_test.flux",
												Source: "2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "center_strings_joinStr_test.flux",
									Source: "range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "center_strings_joinStr_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 108,
								Line:   35,
							},
							File:   "center_strings_joinStr_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time}))",
							Start: ast.Position{
								Column: 33,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 107,
										Line:   35,
									},
									File:   "center_strings_joinStr_test.flux",
									Source: "fn: (r) => ({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 107,
											Line:   35,
										},
										File:   "center_strings_joinStr_test.flux",
										Source: "fn: (r) => ({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "center_strings_joinStr_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 107,
												Line:   35,
											},
											File:   "center_strings_joinStr_test.flux",
											Source: "(r) => ({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 107,
													Line:   35,
												},
												File:   "center_strings_joinStr_test.flux",
												Source: "({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 106,
														Line:   35,
													},
													File:   "center_strings_joinStr_test.flux",
													Source: "{r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 89,
															Line:   35,
														},
														File:   "center_strings_joinStr_test.flux",
														Source: "_value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\")",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "center_strings_joinStr_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 88,
																	Line:   35,
																},
																File:   "center_strings_joinStr_test.flux",
																Source: "arr: [\" \", r._value, \" \"], v: \"\"",
																Start: ast.Position{
																	Column: 56,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 81,
																		Line:   35,
																	},
																	File:   "center_strings_joinStr_test.flux",
																	Source: "arr: [\" \", r._value, \" \"]",
																	Start: ast.Position{
																		Column: 56,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 59,
																			Line:   35,
																		},
																		File:   "center_strings_joinStr_test.flux",
																		Source: "arr",
																		Start: ast.Position{
																			Column: 56,
																			Line:   35,
																		},
																	},
																},
																Name: "arr",
															},
															Separator: nil,
															Value: &ast.ArrayExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 81,
																			Line:   35,
																		},
																		File:   "center_strings_joinStr_test.flux",
																		Source: "[\" \", r._value, \" \"]",
																		Start: ast.Position{
																			Column: 61,
																			Line:   35,
																		},
																	},
																},
																Elements: []ast.Expression{&ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 65,
																				Line:   35,
																			},
																			File:   "center_strings_joinStr_test.flux",
																			Source: "\" \"",
																			Start: ast.Position{
																				Column: 62,
																				Line:   35,
																			},
																		},
																	},
																	Value: " ",
																}, &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 75,
																				Line:   35,
																			},
																			File:   "center_strings_joinStr_test.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 67,
																				Line:   35,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 68,
																					Line:   35,
																				},
																				File:   "center_strings_joinStr_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 67,
																					Line:   35,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 75,
																					Line:   35,
																				},
																				File:   "center_strings_joinStr_test.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 69,
																					Line:   35,
																				},
																			},
																		},
																		Name: "_value",
																	},
																	Rbrack: nil,
																}, &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 80,
																				Line:   35,
																			},
																			File:   "center_strings_joinStr_test.flux",
																			Source: "\" \"",
																			Start: ast.Position{
																				Column: 77,
																				Line:   35,
																			},
																		},
																	},
																	Value: " ",
																}},
																Lbrack: nil,
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 88,
																		Line:   35,
																	},
																	File:   "center_strings_joinStr_test.flux",
																	Source: "v: \"\"",
																	Start: ast.Position{
																		Column: 83,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 84,
																			Line:   35,
																		},
																		File:   "center_strings_joinStr_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 83,
																			Line:   35,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 88,
																			Line:   35,
																		},
																		File:   "center_strings_joinStr_test.flux",
																		Source: "\"\"",
																		Start: ast.Position{
																			Column: 86,
																			Line:   35,
																		},
																	},
																},
																Value: "",
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 89,
																Line:   35,
															},
															File:   "center_strings_joinStr_test.flux",
															Source: "strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\")",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   35,
																},
																File:   "center_strings_joinStr_test.flux",
																Source: "strings.joinStr",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   35,
																	},
																	File:   "center_strings_joinStr_test.flux",
																	Source: "strings",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "strings",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   35,
																	},
																	File:   "center_strings_joinStr_test.flux",
																	Source: "joinStr",
																	Start: ast.Position{
																		Column: 48,
																		Line:   35,
																	},
																},
															},
															Name: "joinStr",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 105,
															Line:   35,
														},
														File:   "center_strings_joinStr_test.flux",
														Source: "_time: r._time",
														Start: ast.Position{
															Column: 91,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 96,
																Line:   35,
															},
															File:   "center_strings_joinStr_test.flux",
															Source: "_time",
															Start: ast.Position{
																Column: 91,
																Line:   35,
															},
														},
													},
													Name: "_time",
												},
												Separator: nil,
												Value: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 105,
																Line:   35,
															},
															File:   "center_strings_joinStr_test.flux",
															Source: "r._time",
															Start: ast.Position{
																Column: 98,
																Line:   35,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 99,
																	Line:   35,
																},
																File:   "center_strings_joinStr_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 98,
																	Line:   35,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 105,
																	Line:   35,
																},
																File:   "center_strings_joinStr_test.flux",
																Source: "_time",
																Start: ast.Position{
																	Column: 100,
																	Line:   35,
																},
															},
														},
														Name: "_time",
													},
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "center_strings_joinStr_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "center_strings_joinStr_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "center_strings_joinStr_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 108,
									Line:   35,
								},
								File:   "center_strings_joinStr_test.flux",
								Source: "map(fn: (r) => ({r with _value: strings.joinStr(arr: [\" \", r._value, \" \"], v: \"\"), _time: r._time}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "center_strings_joinStr_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   33,
							},
							File:   "center_strings_joinStr_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 20,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   33,
								},
								File:   "center_strings_joinStr_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 20,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   33,
							},
							File:   "center_strings_joinStr_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 26,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 130,
							Line:   37,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "_string_center = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_center})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   37,
							},
							File:   "center_strings_joinStr_test.flux",
							Source: "_string_center",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_string_center",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 130,
								Line:   37,
							},
							File:   "center_strings_joinStr_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_center})",
							Start: ast.Position{
								Column: 23,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 130,
									Line:   37,
								},
								File:   "center_strings_joinStr_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_center})",
								Start: ast.Position{
									Column: 29,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 129,
										Line:   37,
									},
									File:   "center_strings_joinStr_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_center}",
									Start: ast.Position{
										Column: 30,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   37,
										},
										File:   "center_strings_joinStr_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 31,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   37,
											},
											File:   "center_strings_joinStr_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 31,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   37,
												},
												File:   "center_strings_joinStr_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 58,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   37,
													},
													File:   "center_strings_joinStr_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 58,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   37,
														},
														File:   "center_strings_joinStr_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 58,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   37,
														},
														File:   "center_strings_joinStr_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 63,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   37,
											},
											File:   "center_strings_joinStr_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 38,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   37,
												},
												File:   "center_strings_joinStr_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 38,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   37,
													},
													File:   "center_strings_joinStr_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 38,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   37,
													},
													File:   "center_strings_joinStr_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 46,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 107,
											Line:   37,
										},
										File:   "center_strings_joinStr_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 72,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   37,
											},
											File:   "center_strings_joinStr_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 72,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 106,
													Line:   37,
												},
												File:   "center_strings_joinStr_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 94,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 106,
														Line:   37,
													},
													File:   "center_strings_joinStr_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 94,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 97,
															Line:   37,
														},
														File:   "center_strings_joinStr_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 94,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 106,
															Line:   37,
														},
														File:   "center_strings_joinStr_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 99,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 107,
												Line:   37,
											},
											File:   "center_strings_joinStr_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 78,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 93,
													Line:   37,
												},
												File:   "center_strings_joinStr_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 78,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 85,
														Line:   37,
													},
													File:   "center_strings_joinStr_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 78,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 93,
														Line:   37,
													},
													File:   "center_strings_joinStr_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 86,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 128,
											Line:   37,
										},
										File:   "center_strings_joinStr_test.flux",
										Source: "fn: t_string_center",
										Start: ast.Position{
											Column: 109,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 111,
												Line:   37,
											},
											File:   "center_strings_joinStr_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 109,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 128,
												Line:   37,
											},
											File:   "center_strings_joinStr_test.flux",
											Source: "t_string_center",
											Start: ast.Position{
												Column: 113,
												Line:   37,
											},
										},
									},
									Name: "t_string_center",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 130,
						Line:   37,
					},
					File:   "center_strings_joinStr_test.flux",
					Source: "test _string_center = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_center})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "center_strings_joinStr_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "center_strings_joinStr_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "center_strings_joinStr_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "center_strings_joinStr_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "center_strings_joinStr_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 134,
					Line:   44,
				},
				File:   "contains_filter_by_regex_match_test.flux",
				Source: "package pandas_test\n\n\nimport \"testing\"\nimport \"regexp\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,false,false,true,true,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,name\n,,0,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n,,1,2018-05-22T19:53:26Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:36Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:46Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:56Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:06Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:16Z,648,io_time,diskio,host.local,disk2\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,host,name\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n\"\nre = regexp.compile(v: \".*0\")\nt_filter_by_regex = (table=<-) => table\n    |> range(start: 2018-05-20T19:53:26Z)\n    |> filter(fn: (r) => regexp.matchRegexpString(r: re, v: r.name))\n\ntest _filter_by_regex = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_filter_by_regex})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "contains_filter_by_regex_match_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "contains_filter_by_regex_match_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "contains_filter_by_regex_match_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "contains_filter_by_regex_match_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   26,
					},
					File:   "contains_filter_by_regex_match_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,false,false,true,true,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,name\n,,0,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n,,1,2018-05-22T19:53:26Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:36Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:46Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:56Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:06Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:16Z,648,io_time,diskio,host.local,disk2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   26,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,false,false,true,true,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,name\n,,0,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n,,1,2018-05-22T19:53:26Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:36Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:46Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:56Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:06Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:16Z,648,io_time,diskio,host.local,disk2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,false,false,true,true,true,true\n#default,_result,,,,,,,\n,result,table,_time,_value,_field,_measurement,host,name\n,,0,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n,,1,2018-05-22T19:53:26Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:36Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:46Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:53:56Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:06Z,648,io_time,diskio,host.local,disk2\n,,1,2018-05-22T19:54:16Z,648,io_time,diskio,host.local,disk2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   38,
					},
					File:   "contains_filter_by_regex_match_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,host,name\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   27,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   27,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   38,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,host,name\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   27,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,host,name\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,15204688,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,15204894,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,15205102,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,15205226,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,15205499,io_time,diskio,host.local,disk0\n,,0,2018-05-20T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,15205755,io_time,diskio,host.local,disk0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 30,
						Line:   39,
					},
					File:   "contains_filter_by_regex_match_test.flux",
					Source: "re = regexp.compile(v: \".*0\")",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   39,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "re",
						Start: ast.Position{
							Column: 1,
							Line:   39,
						},
					},
				},
				Name: "re",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   39,
							},
							File:   "contains_filter_by_regex_match_test.flux",
							Source: "v: \".*0\"",
							Start: ast.Position{
								Column: 21,
								Line:   39,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   39,
								},
								File:   "contains_filter_by_regex_match_test.flux",
								Source: "v: \".*0\"",
								Start: ast.Position{
									Column: 21,
									Line:   39,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   39,
									},
									File:   "contains_filter_by_regex_match_test.flux",
									Source: "v",
									Start: ast.Position{
										Column: 21,
										Line:   39,
									},
								},
							},
							Name: "v",
						},
						Separator: nil,
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   39,
									},
									File:   "contains_filter_by_regex_match_test.flux",
									Source: "\".*0\"",
									Start: ast.Position{
										Column: 24,
										Line:   39,
									},
								},
							},
							Value: ".*0",
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   39,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "regexp.compile(v: \".*0\")",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				Callee: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   39,
							},
							File:   "contains_filter_by_regex_match_test.flux",
							Source: "regexp.compile",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   39,
								},
								File:   "contains_filter_by_regex_match_test.flux",
								Source: "regexp",
								Start: ast.Position{
									Column: 6,
									Line:   39,
								},
							},
						},
						Name: "regexp",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   39,
								},
								File:   "contains_filter_by_regex_match_test.flux",
								Source: "compile",
								Start: ast.Position{
									Column: 13,
									Line:   39,
								},
							},
						},
						Name: "compile",
					},
					Rbrack: nil,
				},
				Lparen: nil,
				Rparen: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 69,
						Line:   42,
					},
					File:   "contains_filter_by_regex_match_test.flux",
					Source: "t_filter_by_regex = (table=<-) => table\n    |> range(start: 2018-05-20T19:53:26Z)\n    |> filter(fn: (r) => regexp.matchRegexpString(r: re, v: r.name))",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   40,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "t_filter_by_regex",
						Start: ast.Position{
							Column: 1,
							Line:   40,
						},
					},
				},
				Name: "t_filter_by_regex",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 69,
							Line:   42,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-20T19:53:26Z)\n    |> filter(fn: (r) => regexp.matchRegexpString(r: re, v: r.name))",
						Start: ast.Position{
							Column: 21,
							Line:   40,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   40,
									},
									File:   "contains_filter_by_regex_match_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 35,
										Line:   40,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   41,
								},
								File:   "contains_filter_by_regex_match_test.flux",
								Source: "table\n    |> range(start: 2018-05-20T19:53:26Z)",
								Start: ast.Position{
									Column: 35,
									Line:   40,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   41,
										},
										File:   "contains_filter_by_regex_match_test.flux",
										Source: "start: 2018-05-20T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   41,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   41,
											},
											File:   "contains_filter_by_regex_match_test.flux",
											Source: "start: 2018-05-20T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   41,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   41,
												},
												File:   "contains_filter_by_regex_match_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   41,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   41,
												},
												File:   "contains_filter_by_regex_match_test.flux",
												Source: "2018-05-20T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   41,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-20T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   41,
									},
									File:   "contains_filter_by_regex_match_test.flux",
									Source: "range(start: 2018-05-20T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   41,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   41,
										},
										File:   "contains_filter_by_regex_match_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   41,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 69,
								Line:   42,
							},
							File:   "contains_filter_by_regex_match_test.flux",
							Source: "table\n    |> range(start: 2018-05-20T19:53:26Z)\n    |> filter(fn: (r) => regexp.matchRegexpString(r: re, v: r.name))",
							Start: ast.Position{
								Column: 35,
								Line:   40,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   42,
									},
									File:   "contains_filter_by_regex_match_test.flux",
									Source: "fn: (r) => regexp.matchRegexpString(r: re, v: r.name)",
									Start: ast.Position{
										Column: 15,
										Line:   42,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   42,
										},
										File:   "contains_filter_by_regex_match_test.flux",
										Source: "fn: (r) => regexp.matchRegexpString(r: re, v: r.name)",
										Start: ast.Position{
											Column: 15,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   42,
											},
											File:   "contains_filter_by_regex_match_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 15,
												Line:   42,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   42,
											},
											File:   "contains_filter_by_regex_match_test.flux",
											Source: "(r) => regexp.matchRegexpString(r: re, v: r.name)",
											Start: ast.Position{
												Column: 19,
												Line:   42,
											},
										},
									},
									Body: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 67,
														Line:   42,
													},
													File:   "contains_filter_by_regex_match_test.flux",
													Source: "r: re, v: r.name",
													Start: ast.Position{
														Column: 51,
														Line:   42,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   42,
														},
														File:   "contains_filter_by_regex_match_test.flux",
														Source: "r: re",
														Start: ast.Position{
															Column: 51,
															Line:   42,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 52,
																Line:   42,
															},
															File:   "contains_filter_by_regex_match_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 51,
																Line:   42,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   42,
															},
															File:   "contains_filter_by_regex_match_test.flux",
															Source: "re",
															Start: ast.Position{
																Column: 54,
																Line:   42,
															},
														},
													},
													Name: "re",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 67,
															Line:   42,
														},
														File:   "contains_filter_by_regex_match_test.flux",
														Source: "v: r.name",
														Start: ast.Position{
															Column: 58,
															Line:   42,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 59,
																Line:   42,
															},
															File:   "contains_filter_by_regex_match_test.flux",
															Source: "v",
															Start: ast.Position{
																Column: 58,
																Line:   42,
															},
														},
													},
													Name: "v",
												},
												Separator: nil,
												Value: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 67,
																Line:   42,
															},
															File:   "contains_filter_by_regex_match_test.flux",
															Source: "r.name",
															Start: ast.Position{
																Column: 61,
																Line:   42,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 62,
																	Line:   42,
																},
																File:   "contains_filter_by_regex_match_test.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 61,
																	Line:   42,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 67,
																	Line:   42,
																},
																File:   "contains_filter_by_regex_match_test.flux",
																Source: "name",
																Start: ast.Position{
																	Column: 63,
																	Line:   42,
																},
															},
														},
														Name: "name",
													},
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   42,
												},
												File:   "contains_filter_by_regex_match_test.flux",
												Source: "regexp.matchRegexpString(r: re, v: r.name)",
												Start: ast.Position{
													Column: 26,
													Line:   42,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   42,
													},
													File:   "contains_filter_by_regex_match_test.flux",
													Source: "regexp.matchRegexpString",
													Start: ast.Position{
														Column: 26,
														Line:   42,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   42,
														},
														File:   "contains_filter_by_regex_match_test.flux",
														Source: "regexp",
														Start: ast.Position{
															Column: 26,
															Line:   42,
														},
													},
												},
												Name: "regexp",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   42,
														},
														File:   "contains_filter_by_regex_match_test.flux",
														Source: "matchRegexpString",
														Start: ast.Position{
															Column: 33,
															Line:   42,
														},
													},
												},
												Name: "matchRegexpString",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   42,
												},
												File:   "contains_filter_by_regex_match_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 20,
													Line:   42,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   42,
													},
													File:   "contains_filter_by_regex_match_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 20,
														Line:   42,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 69,
									Line:   42,
								},
								File:   "contains_filter_by_regex_match_test.flux",
								Source: "filter(fn: (r) => regexp.matchRegexpString(r: re, v: r.name))",
								Start: ast.Position{
									Column: 8,
									Line:   42,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   42,
									},
									File:   "contains_filter_by_regex_match_test.flux",
									Source: "filter",
									Start: ast.Position{
										Column: 8,
										Line:   42,
									},
								},
							},
							Name: "filter",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   40,
							},
							File:   "contains_filter_by_regex_match_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 22,
								Line:   40,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   40,
								},
								File:   "contains_filter_by_regex_match_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 22,
									Line:   40,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   40,
							},
							File:   "contains_filter_by_regex_match_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   40,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 134,
							Line:   44,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "_filter_by_regex = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_filter_by_regex})",
						Start: ast.Position{
							Column: 6,
							Line:   44,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   44,
							},
							File:   "contains_filter_by_regex_match_test.flux",
							Source: "_filter_by_regex",
							Start: ast.Position{
								Column: 6,
								Line:   44,
							},
						},
					},
					Name: "_filter_by_regex",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 134,
								Line:   44,
							},
							File:   "contains_filter_by_regex_match_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_filter_by_regex})",
							Start: ast.Position{
								Column: 25,
								Line:   44,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 134,
									Line:   44,
								},
								File:   "contains_filter_by_regex_match_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_filter_by_regex})",
								Start: ast.Position{
									Column: 31,
									Line:   44,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 133,
										Line:   44,
									},
									File:   "contains_filter_by_regex_match_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_filter_by_regex}",
									Start: ast.Position{
										Column: 32,
										Line:   44,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   44,
										},
										File:   "contains_filter_by_regex_match_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 33,
											Line:   44,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   44,
											},
											File:   "contains_filter_by_regex_match_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 33,
												Line:   44,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   44,
												},
												File:   "contains_filter_by_regex_match_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 60,
													Line:   44,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 71,
														Line:   44,
													},
													File:   "contains_filter_by_regex_match_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 60,
														Line:   44,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   44,
														},
														File:   "contains_filter_by_regex_match_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 60,
															Line:   44,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   44,
														},
														File:   "contains_filter_by_regex_match_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 65,
															Line:   44,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   44,
											},
											File:   "contains_filter_by_regex_match_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 40,
												Line:   44,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   44,
												},
												File:   "contains_filter_by_regex_match_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 40,
													Line:   44,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   44,
													},
													File:   "contains_filter_by_regex_match_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 40,
														Line:   44,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   44,
													},
													File:   "contains_filter_by_regex_match_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 48,
														Line:   44,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 109,
											Line:   44,
										},
										File:   "contains_filter_by_regex_match_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 74,
											Line:   44,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   44,
											},
											File:   "contains_filter_by_regex_match_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 74,
												Line:   44,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 108,
													Line:   44,
												},
												File:   "contains_filter_by_regex_match_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 96,
													Line:   44,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 108,
														Line:   44,
													},
													File:   "contains_filter_by_regex_match_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 96,
														Line:   44,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 99,
															Line:   44,
														},
														File:   "contains_filter_by_regex_match_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 96,
															Line:   44,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 108,
															Line:   44,
														},
														File:   "contains_filter_by_regex_match_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 101,
															Line:   44,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 109,
												Line:   44,
											},
											File:   "contains_filter_by_regex_match_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 80,
												Line:   44,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 95,
													Line:   44,
												},
												File:   "contains_filter_by_regex_match_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 80,
													Line:   44,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   44,
													},
													File:   "contains_filter_by_regex_match_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 80,
														Line:   44,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 95,
														Line:   44,
													},
													File:   "contains_filter_by_regex_match_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 88,
														Line:   44,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 132,
											Line:   44,
										},
										File:   "contains_filter_by_regex_match_test.flux",
										Source: "fn: t_filter_by_regex",
										Start: ast.Position{
											Column: 111,
											Line:   44,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 113,
												Line:   44,
											},
											File:   "contains_filter_by_regex_match_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 111,
												Line:   44,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 132,
												Line:   44,
											},
											File:   "contains_filter_by_regex_match_test.flux",
											Source: "t_filter_by_regex",
											Start: ast.Position{
												Column: 115,
												Line:   44,
											},
										},
									},
									Name: "t_filter_by_regex",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 134,
						Line:   44,
					},
					File:   "contains_filter_by_regex_match_test.flux",
					Source: "test _filter_by_regex = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_filter_by_regex})",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "contains_filter_by_regex_match_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   5,
					},
					File:   "contains_filter_by_regex_match_test.flux",
					Source: "import \"regexp\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   5,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "\"regexp\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "regexp",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "contains_filter_by_regex_match_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "contains_filter_by_regex_match_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "contains_filter_by_regex_match_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 128,
					Line:   38,
				},
				File:   "count_string_countStr_test.flux",
				Source: "package pandas_test\n\n\nimport \"testing\"\nimport \"strings\"\nimport \"regexp\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,long\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,count\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,0\n\"\nt_string_count = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with count: strings.countStr(v: r._value, substr: \"n\")}))\n\ntest _string_count = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_count})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   8,
						},
						File:   "count_string_countStr_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   8,
							},
							File:   "count_string_countStr_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   8,
							},
							File:   "count_string_countStr_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   8,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   8,
								},
								File:   "count_string_countStr_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   8,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   8,
					},
					File:   "count_string_countStr_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   21,
					},
					File:   "count_string_countStr_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   10,
						},
						File:   "count_string_countStr_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   10,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   21,
						},
						File:   "count_string_countStr_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   10,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   33,
					},
					File:   "count_string_countStr_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,long\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,count\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   22,
						},
						File:   "count_string_countStr_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   22,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   33,
						},
						File:   "count_string_countStr_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,long\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,count\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,0\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   22,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,long\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,count\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 84,
						Line:   36,
					},
					File:   "count_string_countStr_test.flux",
					Source: "t_string_count = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with count: strings.countStr(v: r._value, substr: \"n\")}))",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   34,
						},
						File:   "count_string_countStr_test.flux",
						Source: "t_string_count",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "t_string_count",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 84,
							Line:   36,
						},
						File:   "count_string_countStr_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with count: strings.countStr(v: r._value, substr: \"n\")}))",
						Start: ast.Position{
							Column: 18,
							Line:   34,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   34,
									},
									File:   "count_string_countStr_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 32,
										Line:   34,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   35,
								},
								File:   "count_string_countStr_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)",
								Start: ast.Position{
									Column: 32,
									Line:   34,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   35,
										},
										File:   "count_string_countStr_test.flux",
										Source: "start: 2018-05-22T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   35,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   35,
											},
											File:   "count_string_countStr_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   35,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   35,
												},
												File:   "count_string_countStr_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   35,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   35,
												},
												File:   "count_string_countStr_test.flux",
												Source: "2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   35,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   35,
									},
									File:   "count_string_countStr_test.flux",
									Source: "range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   35,
										},
										File:   "count_string_countStr_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   35,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   36,
							},
							File:   "count_string_countStr_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with count: strings.countStr(v: r._value, substr: \"n\")}))",
							Start: ast.Position{
								Column: 32,
								Line:   34,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 83,
										Line:   36,
									},
									File:   "count_string_countStr_test.flux",
									Source: "fn: (r) => ({r with count: strings.countStr(v: r._value, substr: \"n\")})",
									Start: ast.Position{
										Column: 12,
										Line:   36,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 83,
											Line:   36,
										},
										File:   "count_string_countStr_test.flux",
										Source: "fn: (r) => ({r with count: strings.countStr(v: r._value, substr: \"n\")})",
										Start: ast.Position{
											Column: 12,
											Line:   36,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   36,
											},
											File:   "count_string_countStr_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   36,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 83,
												Line:   36,
											},
											File:   "count_string_countStr_test.flux",
											Source: "(r) => ({r with count: strings.countStr(v: r._value, substr: \"n\")})",
											Start: ast.Position{
												Column: 16,
												Line:   36,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 83,
													Line:   36,
												},
												File:   "count_string_countStr_test.flux",
												Source: "({r with count: strings.countStr(v: r._value, substr: \"n\")})",
												Start: ast.Position{
													Column: 23,
													Line:   36,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 82,
														Line:   36,
													},
													File:   "count_string_countStr_test.flux",
													Source: "{r with count: strings.countStr(v: r._value, substr: \"n\")}",
													Start: ast.Position{
														Column: 24,
														Line:   36,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 81,
															Line:   36,
														},
														File:   "count_string_countStr_test.flux",
														Source: "count: strings.countStr(v: r._value, substr: \"n\")",
														Start: ast.Position{
															Column: 32,
															Line:   36,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   36,
															},
															File:   "count_string_countStr_test.flux",
															Source: "count",
															Start: ast.Position{
																Column: 32,
																Line:   36,
															},
														},
													},
													Name: "count",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 80,
																	Line:   36,
																},
																File:   "count_string_countStr_test.flux",
																Source: "v: r._value, substr: \"n\"",
																Start: ast.Position{
																	Column: 56,
																	Line:   36,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 67,
																		Line:   36,
																	},
																	File:   "count_string_countStr_test.flux",
																	Source: "v: r._value",
																	Start: ast.Position{
																		Column: 56,
																		Line:   36,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 57,
																			Line:   36,
																		},
																		File:   "count_string_countStr_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 56,
																			Line:   36,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 67,
																			Line:   36,
																		},
																		File:   "count_string_countStr_test.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 59,
																			Line:   36,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 60,
																				Line:   36,
																			},
																			File:   "count_string_countStr_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 59,
																				Line:   36,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 67,
																				Line:   36,
																			},
																			File:   "count_string_countStr_test.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 61,
																				Line:   36,
																			},
																		},
																	},
																	Name: "_value",
																},
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 80,
																		Line:   36,
																	},
																	File:   "count_string_countStr_test.flux",
																	Source: "substr: \"n\"",
																	Start: ast.Position{
																		Column: 69,
																		Line:   36,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 75,
																			Line:   36,
																		},
																		File:   "count_string_countStr_test.flux",
																		Source: "substr",
																		Start: ast.Position{
																			Column: 69,
																			Line:   36,
																		},
																	},
																},
																Name: "substr",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 80,
																			Line:   36,
																		},
																		File:   "count_string_countStr_test.flux",
																		Source: "\"n\"",
																		Start: ast.Position{
																			Column: 77,
																			Line:   36,
																		},
																	},
																},
																Value: "n",
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 81,
																Line:   36,
															},
															File:   "count_string_countStr_test.flux",
															Source: "strings.countStr(v: r._value, substr: \"n\")",
															Start: ast.Position{
																Column: 39,
																Line:   36,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   36,
																},
																File:   "count_string_countStr_test.flux",
																Source: "strings.countStr",
																Start: ast.Position{
																	Column: 39,
																	Line:   36,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   36,
																	},
																	File:   "count_string_countStr_test.flux",
																	Source: "strings",
																	Start: ast.Position{
																		Column: 39,
																		Line:   36,
																	},
																},
															},
															Name: "strings",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   36,
																	},
																	File:   "count_string_countStr_test.flux",
																	Source: "countStr",
																	Start: ast.Position{
																		Column: 47,
																		Line:   36,
																	},
																},
															},
															Name: "countStr",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   36,
														},
														File:   "count_string_countStr_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   36,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   36,
												},
												File:   "count_string_countStr_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   36,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   36,
													},
													File:   "count_string_countStr_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   36,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   36,
								},
								File:   "count_string_countStr_test.flux",
								Source: "map(fn: (r) => ({r with count: strings.countStr(v: r._value, substr: \"n\")}))",
								Start: ast.Position{
									Column: 8,
									Line:   36,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   36,
									},
									File:   "count_string_countStr_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   36,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   34,
							},
							File:   "count_string_countStr_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 19,
								Line:   34,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   34,
								},
								File:   "count_string_countStr_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 19,
									Line:   34,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   34,
							},
							File:   "count_string_countStr_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 25,
								Line:   34,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 128,
							Line:   38,
						},
						File:   "count_string_countStr_test.flux",
						Source: "_string_count = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_count})",
						Start: ast.Position{
							Column: 6,
							Line:   38,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   38,
							},
							File:   "count_string_countStr_test.flux",
							Source: "_string_count",
							Start: ast.Position{
								Column: 6,
								Line:   38,
							},
						},
					},
					Name: "_string_count",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 128,
								Line:   38,
							},
							File:   "count_string_countStr_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_count})",
							Start: ast.Position{
								Column: 22,
								Line:   38,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 128,
									Line:   38,
								},
								File:   "count_string_countStr_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_count})",
								Start: ast.Position{
									Column: 28,
									Line:   38,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 127,
										Line:   38,
									},
									File:   "count_string_countStr_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_count}",
									Start: ast.Position{
										Column: 29,
										Line:   38,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   38,
										},
										File:   "count_string_countStr_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 30,
											Line:   38,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   38,
											},
											File:   "count_string_countStr_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 30,
												Line:   38,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   38,
												},
												File:   "count_string_countStr_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 57,
													Line:   38,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   38,
													},
													File:   "count_string_countStr_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 57,
														Line:   38,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   38,
														},
														File:   "count_string_countStr_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 57,
															Line:   38,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 68,
															Line:   38,
														},
														File:   "count_string_countStr_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 62,
															Line:   38,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   38,
											},
											File:   "count_string_countStr_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 37,
												Line:   38,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   38,
												},
												File:   "count_string_countStr_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 37,
													Line:   38,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   38,
													},
													File:   "count_string_countStr_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 37,
														Line:   38,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   38,
													},
													File:   "count_string_countStr_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 45,
														Line:   38,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 106,
											Line:   38,
										},
										File:   "count_string_countStr_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 71,
											Line:   38,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 75,
												Line:   38,
											},
											File:   "count_string_countStr_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 71,
												Line:   38,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 105,
													Line:   38,
												},
												File:   "count_string_countStr_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 93,
													Line:   38,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 105,
														Line:   38,
													},
													File:   "count_string_countStr_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 93,
														Line:   38,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 96,
															Line:   38,
														},
														File:   "count_string_countStr_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 93,
															Line:   38,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 105,
															Line:   38,
														},
														File:   "count_string_countStr_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 98,
															Line:   38,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 106,
												Line:   38,
											},
											File:   "count_string_countStr_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 77,
												Line:   38,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 92,
													Line:   38,
												},
												File:   "count_string_countStr_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 77,
													Line:   38,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 84,
														Line:   38,
													},
													File:   "count_string_countStr_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 77,
														Line:   38,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 92,
														Line:   38,
													},
													File:   "count_string_countStr_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 85,
														Line:   38,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 126,
											Line:   38,
										},
										File:   "count_string_countStr_test.flux",
										Source: "fn: t_string_count",
										Start: ast.Position{
											Column: 108,
											Line:   38,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 110,
												Line:   38,
											},
											File:   "count_string_countStr_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 108,
												Line:   38,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 126,
												Line:   38,
											},
											File:   "count_string_countStr_test.flux",
											Source: "t_string_count",
											Start: ast.Position{
												Column: 112,
												Line:   38,
											},
										},
									},
									Name: "t_string_count",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 128,
						Line:   38,
					},
					File:   "count_string_countStr_test.flux",
					Source: "test _string_count = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_count})",
					Start: ast.Position{
						Column: 1,
						Line:   38,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "count_string_countStr_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "count_string_countStr_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "count_string_countStr_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "count_string_countStr_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   6,
					},
					File:   "count_string_countStr_test.flux",
					Source: "import \"regexp\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   6,
						},
						File:   "count_string_countStr_test.flux",
						Source: "\"regexp\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "regexp",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "count_string_countStr_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "count_string_countStr_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "count_string_countStr_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 150,
					Line:   41,
				},
				File:   "endswith_strings_regexp_hasSuffix_test.flux",
				Source: "package pandas_test\n\n\nimport \"testing\"\nimport \"strings\"\nimport \"regexp\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2 ,used_percent,disk,disk1,apfs,host.local,/\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2 ,used_percent,disk,disk1,apfs,host.local,/\n\"\nre = regexp.compile(v: \" \")\nt_string_regexp_hasSuffix = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> filter(\n        fn: (r) => regexp.matchRegexpString(\n            r: re,\n            v: strings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)),\n        ),\n    )\n\ntest _string_regexp_hasSuffix = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasSuffix})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   8,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   8,
							},
							File:   "endswith_strings_regexp_hasSuffix_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   8,
							},
							File:   "endswith_strings_regexp_hasSuffix_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   8,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   8,
								},
								File:   "endswith_strings_regexp_hasSuffix_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   8,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   8,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   21,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2 ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   10,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   10,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   21,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2 ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   10,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2 ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   30,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2 ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   22,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   22,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   30,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2 ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   22,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2 ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 28,
						Line:   31,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "re = regexp.compile(v: \" \")",
					Start: ast.Position{
						Column: 1,
						Line:   31,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   31,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "re",
						Start: ast.Position{
							Column: 1,
							Line:   31,
						},
					},
				},
				Name: "re",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   31,
							},
							File:   "endswith_strings_regexp_hasSuffix_test.flux",
							Source: "v: \" \"",
							Start: ast.Position{
								Column: 21,
								Line:   31,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   31,
								},
								File:   "endswith_strings_regexp_hasSuffix_test.flux",
								Source: "v: \" \"",
								Start: ast.Position{
									Column: 21,
									Line:   31,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   31,
									},
									File:   "endswith_strings_regexp_hasSuffix_test.flux",
									Source: "v",
									Start: ast.Position{
										Column: 21,
										Line:   31,
									},
								},
							},
							Name: "v",
						},
						Separator: nil,
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   31,
									},
									File:   "endswith_strings_regexp_hasSuffix_test.flux",
									Source: "\" \"",
									Start: ast.Position{
										Column: 24,
										Line:   31,
									},
								},
							},
							Value: " ",
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 28,
							Line:   31,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "regexp.compile(v: \" \")",
						Start: ast.Position{
							Column: 6,
							Line:   31,
						},
					},
				},
				Callee: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   31,
							},
							File:   "endswith_strings_regexp_hasSuffix_test.flux",
							Source: "regexp.compile",
							Start: ast.Position{
								Column: 6,
								Line:   31,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   31,
								},
								File:   "endswith_strings_regexp_hasSuffix_test.flux",
								Source: "regexp",
								Start: ast.Position{
									Column: 6,
									Line:   31,
								},
							},
						},
						Name: "regexp",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   31,
								},
								File:   "endswith_strings_regexp_hasSuffix_test.flux",
								Source: "compile",
								Start: ast.Position{
									Column: 13,
									Line:   31,
								},
							},
						},
						Name: "compile",
					},
					Rbrack: nil,
				},
				Lparen: nil,
				Rparen: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   39,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "t_string_regexp_hasSuffix = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> filter(\n        fn: (r) => regexp.matchRegexpString(\n            r: re,\n            v: strings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)),\n        ),\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   32,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   32,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "t_string_regexp_hasSuffix",
						Start: ast.Position{
							Column: 1,
							Line:   32,
						},
					},
				},
				Name: "t_string_regexp_hasSuffix",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   39,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> filter(\n        fn: (r) => regexp.matchRegexpString(\n            r: re,\n            v: strings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)),\n        ),\n    )",
						Start: ast.Position{
							Column: 29,
							Line:   32,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   32,
									},
									File:   "endswith_strings_regexp_hasSuffix_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 43,
										Line:   32,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   33,
								},
								File:   "endswith_strings_regexp_hasSuffix_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)",
								Start: ast.Position{
									Column: 43,
									Line:   32,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   33,
										},
										File:   "endswith_strings_regexp_hasSuffix_test.flux",
										Source: "start: 2018-05-22T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   33,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   33,
											},
											File:   "endswith_strings_regexp_hasSuffix_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   33,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   33,
												},
												File:   "endswith_strings_regexp_hasSuffix_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   33,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   33,
												},
												File:   "endswith_strings_regexp_hasSuffix_test.flux",
												Source: "2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   33,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   33,
									},
									File:   "endswith_strings_regexp_hasSuffix_test.flux",
									Source: "range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   33,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   33,
										},
										File:   "endswith_strings_regexp_hasSuffix_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   33,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   39,
							},
							File:   "endswith_strings_regexp_hasSuffix_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> filter(\n        fn: (r) => regexp.matchRegexpString(\n            r: re,\n            v: strings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)),\n        ),\n    )",
							Start: ast.Position{
								Column: 43,
								Line:   32,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   38,
									},
									File:   "endswith_strings_regexp_hasSuffix_test.flux",
									Source: "fn: (r) => regexp.matchRegexpString(\n            r: re,\n            v: strings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)),\n        )",
									Start: ast.Position{
										Column: 9,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   38,
										},
										File:   "endswith_strings_regexp_hasSuffix_test.flux",
										Source: "fn: (r) => regexp.matchRegexpString(\n            r: re,\n            v: strings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)),\n        )",
										Start: ast.Position{
											Column: 9,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   35,
											},
											File:   "endswith_strings_regexp_hasSuffix_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 9,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   38,
											},
											File:   "endswith_strings_regexp_hasSuffix_test.flux",
											Source: "(r) => regexp.matchRegexpString(\n            r: re,\n            v: strings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)),\n        )",
											Start: ast.Position{
												Column: 13,
												Line:   35,
											},
										},
									},
									Body: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 120,
														Line:   37,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "r: re,\n            v: strings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value))",
													Start: ast.Position{
														Column: 13,
														Line:   36,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   36,
														},
														File:   "endswith_strings_regexp_hasSuffix_test.flux",
														Source: "r: re",
														Start: ast.Position{
															Column: 13,
															Line:   36,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   36,
															},
															File:   "endswith_strings_regexp_hasSuffix_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 13,
																Line:   36,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 18,
																Line:   36,
															},
															File:   "endswith_strings_regexp_hasSuffix_test.flux",
															Source: "re",
															Start: ast.Position{
																Column: 16,
																Line:   36,
															},
														},
													},
													Name: "re",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 120,
															Line:   37,
														},
														File:   "endswith_strings_regexp_hasSuffix_test.flux",
														Source: "v: strings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value))",
														Start: ast.Position{
															Column: 13,
															Line:   37,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   37,
															},
															File:   "endswith_strings_regexp_hasSuffix_test.flux",
															Source: "v",
															Start: ast.Position{
																Column: 13,
																Line:   37,
															},
														},
													},
													Name: "v",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 119,
																	Line:   37,
																},
																File:   "endswith_strings_regexp_hasSuffix_test.flux",
																Source: "v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)",
																Start: ast.Position{
																	Column: 34,
																	Line:   37,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 45,
																		Line:   37,
																	},
																	File:   "endswith_strings_regexp_hasSuffix_test.flux",
																	Source: "v: r._value",
																	Start: ast.Position{
																		Column: 34,
																		Line:   37,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 35,
																			Line:   37,
																		},
																		File:   "endswith_strings_regexp_hasSuffix_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 34,
																			Line:   37,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 45,
																			Line:   37,
																		},
																		File:   "endswith_strings_regexp_hasSuffix_test.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 37,
																			Line:   37,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 38,
																				Line:   37,
																			},
																			File:   "endswith_strings_regexp_hasSuffix_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 37,
																				Line:   37,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   37,
																			},
																			File:   "endswith_strings_regexp_hasSuffix_test.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 39,
																				Line:   37,
																			},
																		},
																	},
																	Name: "_value",
																},
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 85,
																		Line:   37,
																	},
																	File:   "endswith_strings_regexp_hasSuffix_test.flux",
																	Source: "start: strings.strlen(v: r._value) - 1",
																	Start: ast.Position{
																		Column: 47,
																		Line:   37,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 52,
																			Line:   37,
																		},
																		File:   "endswith_strings_regexp_hasSuffix_test.flux",
																		Source: "start",
																		Start: ast.Position{
																			Column: 47,
																			Line:   37,
																		},
																	},
																},
																Name: "start",
															},
															Separator: nil,
															Value: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 85,
																			Line:   37,
																		},
																		File:   "endswith_strings_regexp_hasSuffix_test.flux",
																		Source: "strings.strlen(v: r._value) - 1",
																		Start: ast.Position{
																			Column: 54,
																			Line:   37,
																		},
																	},
																},
																Left: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 80,
																					Line:   37,
																				},
																				File:   "endswith_strings_regexp_hasSuffix_test.flux",
																				Source: "v: r._value",
																				Start: ast.Position{
																					Column: 69,
																					Line:   37,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 80,
																						Line:   37,
																					},
																					File:   "endswith_strings_regexp_hasSuffix_test.flux",
																					Source: "v: r._value",
																					Start: ast.Position{
																						Column: 69,
																						Line:   37,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 70,
																							Line:   37,
																						},
																						File:   "endswith_strings_regexp_hasSuffix_test.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 69,
																							Line:   37,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Separator: nil,
																			Value: &ast.MemberExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 80,
																							Line:   37,
																						},
																						File:   "endswith_strings_regexp_hasSuffix_test.flux",
																						Source: "r._value",
																						Start: ast.Position{
																							Column: 72,
																							Line:   37,
																						},
																					},
																				},
																				Lbrack: nil,
																				Object: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 73,
																								Line:   37,
																							},
																							File:   "endswith_strings_regexp_hasSuffix_test.flux",
																							Source: "r",
																							Start: ast.Position{
																								Column: 72,
																								Line:   37,
																							},
																						},
																					},
																					Name: "r",
																				},
																				Property: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 80,
																								Line:   37,
																							},
																							File:   "endswith_strings_regexp_hasSuffix_test.flux",
																							Source: "_value",
																							Start: ast.Position{
																								Column: 74,
																								Line:   37,
																							},
																						},
																					},
																					Name: "_value",
																				},
																				Rbrack: nil,
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 81,
																				Line:   37,
																			},
																			File:   "endswith_strings_regexp_hasSuffix_test.flux",
																			Source: "strings.strlen(v: r._value)",
																			Start: ast.Position{
																				Column: 54,
																				Line:   37,
																			},
																		},
																	},
																	Callee: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 68,
																					Line:   37,
																				},
																				File:   "endswith_strings_regexp_hasSuffix_test.flux",
																				Source: "strings.strlen",
																				Start: ast.Position{
																					Column: 54,
																					Line:   37,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 61,
																						Line:   37,
																					},
																					File:   "endswith_strings_regexp_hasSuffix_test.flux",
																					Source: "strings",
																					Start: ast.Position{
																						Column: 54,
																						Line:   37,
																					},
																				},
																			},
																			Name: "strings",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 68,
																						Line:   37,
																					},
																					File:   "endswith_strings_regexp_hasSuffix_test.flux",
																					Source: "strlen",
																					Start: ast.Position{
																						Column: 62,
																						Line:   37,
																					},
																				},
																			},
																			Name: "strlen",
																		},
																		Rbrack: nil,
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
																Operator: 6,
																Right: &ast.IntegerLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 85,
																				Line:   37,
																			},
																			File:   "endswith_strings_regexp_hasSuffix_test.flux",
																			Source: "1",
																			Start: ast.Position{
																				Column: 84,
																				Line:   37,
																			},
																		},
																	},
																	Value: int64(1),
																},
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 119,
																		Line:   37,
																	},
																	File:   "endswith_strings_regexp_hasSuffix_test.flux",
																	Source: "end: strings.strlen(v: r._value)",
																	Start: ast.Position{
																		Column: 87,
																		Line:   37,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 90,
																			Line:   37,
																		},
																		File:   "endswith_strings_regexp_hasSuffix_test.flux",
																		Source: "end",
																		Start: ast.Position{
																			Column: 87,
																			Line:   37,
																		},
																	},
																},
																Name: "end",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 118,
																				Line:   37,
																			},
																			File:   "endswith_strings_regexp_hasSuffix_test.flux",
																			Source: "v: r._value",
																			Start: ast.Position{
																				Column: 107,
																				Line:   37,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 118,
																					Line:   37,
																				},
																				File:   "endswith_strings_regexp_hasSuffix_test.flux",
																				Source: "v: r._value",
																				Start: ast.Position{
																					Column: 107,
																					Line:   37,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 108,
																						Line:   37,
																					},
																					File:   "endswith_strings_regexp_hasSuffix_test.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 107,
																						Line:   37,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 118,
																						Line:   37,
																					},
																					File:   "endswith_strings_regexp_hasSuffix_test.flux",
																					Source: "r._value",
																					Start: ast.Position{
																						Column: 110,
																						Line:   37,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 111,
																							Line:   37,
																						},
																						File:   "endswith_strings_regexp_hasSuffix_test.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 110,
																							Line:   37,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 118,
																							Line:   37,
																						},
																						File:   "endswith_strings_regexp_hasSuffix_test.flux",
																						Source: "_value",
																						Start: ast.Position{
																							Column: 112,
																							Line:   37,
																						},
																					},
																				},
																				Name: "_value",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 119,
																			Line:   37,
																		},
																		File:   "endswith_strings_regexp_hasSuffix_test.flux",
																		Source: "strings.strlen(v: r._value)",
																		Start: ast.Position{
																			Column: 92,
																			Line:   37,
																		},
																	},
																},
																Callee: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 106,
																				Line:   37,
																			},
																			File:   "endswith_strings_regexp_hasSuffix_test.flux",
																			Source: "strings.strlen",
																			Start: ast.Position{
																				Column: 92,
																				Line:   37,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 99,
																					Line:   37,
																				},
																				File:   "endswith_strings_regexp_hasSuffix_test.flux",
																				Source: "strings",
																				Start: ast.Position{
																					Column: 92,
																					Line:   37,
																				},
																			},
																		},
																		Name: "strings",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 106,
																					Line:   37,
																				},
																				File:   "endswith_strings_regexp_hasSuffix_test.flux",
																				Source: "strlen",
																				Start: ast.Position{
																					Column: 100,
																					Line:   37,
																				},
																			},
																		},
																		Name: "strlen",
																	},
																	Rbrack: nil,
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 120,
																Line:   37,
															},
															File:   "endswith_strings_regexp_hasSuffix_test.flux",
															Source: "strings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value))",
															Start: ast.Position{
																Column: 16,
																Line:   37,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 33,
																	Line:   37,
																},
																File:   "endswith_strings_regexp_hasSuffix_test.flux",
																Source: "strings.substring",
																Start: ast.Position{
																	Column: 16,
																	Line:   37,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 23,
																		Line:   37,
																	},
																	File:   "endswith_strings_regexp_hasSuffix_test.flux",
																	Source: "strings",
																	Start: ast.Position{
																		Column: 16,
																		Line:   37,
																	},
																},
															},
															Name: "strings",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 33,
																		Line:   37,
																	},
																	File:   "endswith_strings_regexp_hasSuffix_test.flux",
																	Source: "substring",
																	Start: ast.Position{
																		Column: 24,
																		Line:   37,
																	},
																},
															},
															Name: "substring",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   38,
												},
												File:   "endswith_strings_regexp_hasSuffix_test.flux",
												Source: "regexp.matchRegexpString(\n            r: re,\n            v: strings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)),\n        )",
												Start: ast.Position{
													Column: 20,
													Line:   35,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   35,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "regexp.matchRegexpString",
													Start: ast.Position{
														Column: 20,
														Line:   35,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "endswith_strings_regexp_hasSuffix_test.flux",
														Source: "regexp",
														Start: ast.Position{
															Column: 20,
															Line:   35,
														},
													},
												},
												Name: "regexp",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 44,
															Line:   35,
														},
														File:   "endswith_strings_regexp_hasSuffix_test.flux",
														Source: "matchRegexpString",
														Start: ast.Position{
															Column: 27,
															Line:   35,
														},
													},
												},
												Name: "matchRegexpString",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   35,
												},
												File:   "endswith_strings_regexp_hasSuffix_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 14,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   35,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 14,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   39,
								},
								File:   "endswith_strings_regexp_hasSuffix_test.flux",
								Source: "filter(\n        fn: (r) => regexp.matchRegexpString(\n            r: re,\n            v: strings.substring(v: r._value, start: strings.strlen(v: r._value) - 1, end: strings.strlen(v: r._value)),\n        ),\n    )",
								Start: ast.Position{
									Column: 8,
									Line:   34,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   34,
									},
									File:   "endswith_strings_regexp_hasSuffix_test.flux",
									Source: "filter",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Name: "filter",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   32,
							},
							File:   "endswith_strings_regexp_hasSuffix_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 30,
								Line:   32,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   32,
								},
								File:   "endswith_strings_regexp_hasSuffix_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 30,
									Line:   32,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   32,
							},
							File:   "endswith_strings_regexp_hasSuffix_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 36,
								Line:   32,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 150,
							Line:   41,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "_string_regexp_hasSuffix = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasSuffix})",
						Start: ast.Position{
							Column: 6,
							Line:   41,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   41,
							},
							File:   "endswith_strings_regexp_hasSuffix_test.flux",
							Source: "_string_regexp_hasSuffix",
							Start: ast.Position{
								Column: 6,
								Line:   41,
							},
						},
					},
					Name: "_string_regexp_hasSuffix",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 150,
								Line:   41,
							},
							File:   "endswith_strings_regexp_hasSuffix_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasSuffix})",
							Start: ast.Position{
								Column: 33,
								Line:   41,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 150,
									Line:   41,
								},
								File:   "endswith_strings_regexp_hasSuffix_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasSuffix})",
								Start: ast.Position{
									Column: 39,
									Line:   41,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 149,
										Line:   41,
									},
									File:   "endswith_strings_regexp_hasSuffix_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasSuffix}",
									Start: ast.Position{
										Column: 40,
										Line:   41,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   41,
										},
										File:   "endswith_strings_regexp_hasSuffix_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 41,
											Line:   41,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   41,
											},
											File:   "endswith_strings_regexp_hasSuffix_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 41,
												Line:   41,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   41,
												},
												File:   "endswith_strings_regexp_hasSuffix_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 68,
													Line:   41,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   41,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 68,
														Line:   41,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   41,
														},
														File:   "endswith_strings_regexp_hasSuffix_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 68,
															Line:   41,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   41,
														},
														File:   "endswith_strings_regexp_hasSuffix_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 73,
															Line:   41,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   41,
											},
											File:   "endswith_strings_regexp_hasSuffix_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 48,
												Line:   41,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   41,
												},
												File:   "endswith_strings_regexp_hasSuffix_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 48,
													Line:   41,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 55,
														Line:   41,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 48,
														Line:   41,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 67,
														Line:   41,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 56,
														Line:   41,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 117,
											Line:   41,
										},
										File:   "endswith_strings_regexp_hasSuffix_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 82,
											Line:   41,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 86,
												Line:   41,
											},
											File:   "endswith_strings_regexp_hasSuffix_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 82,
												Line:   41,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 116,
													Line:   41,
												},
												File:   "endswith_strings_regexp_hasSuffix_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 104,
													Line:   41,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 116,
														Line:   41,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 104,
														Line:   41,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 107,
															Line:   41,
														},
														File:   "endswith_strings_regexp_hasSuffix_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 104,
															Line:   41,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 116,
															Line:   41,
														},
														File:   "endswith_strings_regexp_hasSuffix_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 109,
															Line:   41,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 117,
												Line:   41,
											},
											File:   "endswith_strings_regexp_hasSuffix_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 88,
												Line:   41,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 103,
													Line:   41,
												},
												File:   "endswith_strings_regexp_hasSuffix_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 88,
													Line:   41,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 95,
														Line:   41,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 88,
														Line:   41,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 103,
														Line:   41,
													},
													File:   "endswith_strings_regexp_hasSuffix_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 96,
														Line:   41,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 148,
											Line:   41,
										},
										File:   "endswith_strings_regexp_hasSuffix_test.flux",
										Source: "fn: t_string_regexp_hasSuffix",
										Start: ast.Position{
											Column: 119,
											Line:   41,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 121,
												Line:   41,
											},
											File:   "endswith_strings_regexp_hasSuffix_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 119,
												Line:   41,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 148,
												Line:   41,
											},
											File:   "endswith_strings_regexp_hasSuffix_test.flux",
											Source: "t_string_regexp_hasSuffix",
											Start: ast.Position{
												Column: 123,
												Line:   41,
											},
										},
									},
									Name: "t_string_regexp_hasSuffix",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 150,
						Line:   41,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "test _string_regexp_hasSuffix = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasSuffix})",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   6,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "import \"regexp\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   6,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "\"regexp\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "regexp",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "endswith_strings_regexp_hasSuffix_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "endswith_strings_regexp_hasSuffix_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "endswith_strings_regexp_hasSuffix_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 132,
					Line:   39,
				},
				File:   "extract_regexp_findStringIndex_test.flux",
				Source: "package pandas_test\n\n\nimport \"testing\"\nimport \"strings\"\nimport \"regexp\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,long\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,extract0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,2\n\"\nre = regexp.compile(v: \"[[:alpha:]]{1}\")\nt_string_extract = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]}))\n\ntest _string_extract = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   8,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   8,
							},
							File:   "extract_regexp_findStringIndex_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   8,
							},
							File:   "extract_regexp_findStringIndex_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   8,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   8,
								},
								File:   "extract_regexp_findStringIndex_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   8,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   8,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   21,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   10,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   10,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   21,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   10,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   33,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,long\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,extract0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   22,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   22,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   33,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,long\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,extract0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,2\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   22,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,long\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,extract0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,1\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,0\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 41,
						Line:   34,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "re = regexp.compile(v: \"[[:alpha:]]{1}\")",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   34,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "re",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "re",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   34,
							},
							File:   "extract_regexp_findStringIndex_test.flux",
							Source: "v: \"[[:alpha:]]{1}\"",
							Start: ast.Position{
								Column: 21,
								Line:   34,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   34,
								},
								File:   "extract_regexp_findStringIndex_test.flux",
								Source: "v: \"[[:alpha:]]{1}\"",
								Start: ast.Position{
									Column: 21,
									Line:   34,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   34,
									},
									File:   "extract_regexp_findStringIndex_test.flux",
									Source: "v",
									Start: ast.Position{
										Column: 21,
										Line:   34,
									},
								},
							},
							Name: "v",
						},
						Separator: nil,
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   34,
									},
									File:   "extract_regexp_findStringIndex_test.flux",
									Source: "\"[[:alpha:]]{1}\"",
									Start: ast.Position{
										Column: 24,
										Line:   34,
									},
								},
							},
							Value: "[[:alpha:]]{1}",
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 41,
							Line:   34,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "regexp.compile(v: \"[[:alpha:]]{1}\")",
						Start: ast.Position{
							Column: 6,
							Line:   34,
						},
					},
				},
				Callee: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   34,
							},
							File:   "extract_regexp_findStringIndex_test.flux",
							Source: "regexp.compile",
							Start: ast.Position{
								Column: 6,
								Line:   34,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   34,
								},
								File:   "extract_regexp_findStringIndex_test.flux",
								Source: "regexp",
								Start: ast.Position{
									Column: 6,
									Line:   34,
								},
							},
						},
						Name: "regexp",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   34,
								},
								File:   "extract_regexp_findStringIndex_test.flux",
								Source: "compile",
								Start: ast.Position{
									Column: 13,
									Line:   34,
								},
							},
						},
						Name: "compile",
					},
					Rbrack: nil,
				},
				Lparen: nil,
				Rparen: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 90,
						Line:   37,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "t_string_extract = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]}))",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   35,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "t_string_extract",
						Start: ast.Position{
							Column: 1,
							Line:   35,
						},
					},
				},
				Name: "t_string_extract",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 90,
							Line:   37,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]}))",
						Start: ast.Position{
							Column: 20,
							Line:   35,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   35,
									},
									File:   "extract_regexp_findStringIndex_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 34,
										Line:   35,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   36,
								},
								File:   "extract_regexp_findStringIndex_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)",
								Start: ast.Position{
									Column: 34,
									Line:   35,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   36,
										},
										File:   "extract_regexp_findStringIndex_test.flux",
										Source: "start: 2018-05-22T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   36,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   36,
											},
											File:   "extract_regexp_findStringIndex_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   36,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   36,
												},
												File:   "extract_regexp_findStringIndex_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   36,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   36,
												},
												File:   "extract_regexp_findStringIndex_test.flux",
												Source: "2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   36,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   36,
									},
									File:   "extract_regexp_findStringIndex_test.flux",
									Source: "range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   36,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   36,
										},
										File:   "extract_regexp_findStringIndex_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   36,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 90,
								Line:   37,
							},
							File:   "extract_regexp_findStringIndex_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]}))",
							Start: ast.Position{
								Column: 34,
								Line:   35,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 89,
										Line:   37,
									},
									File:   "extract_regexp_findStringIndex_test.flux",
									Source: "fn: (r) => ({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]})",
									Start: ast.Position{
										Column: 12,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 89,
											Line:   37,
										},
										File:   "extract_regexp_findStringIndex_test.flux",
										Source: "fn: (r) => ({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]})",
										Start: ast.Position{
											Column: 12,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   37,
											},
											File:   "extract_regexp_findStringIndex_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 89,
												Line:   37,
											},
											File:   "extract_regexp_findStringIndex_test.flux",
											Source: "(r) => ({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]})",
											Start: ast.Position{
												Column: 16,
												Line:   37,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 89,
													Line:   37,
												},
												File:   "extract_regexp_findStringIndex_test.flux",
												Source: "({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]})",
												Start: ast.Position{
													Column: 23,
													Line:   37,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 88,
														Line:   37,
													},
													File:   "extract_regexp_findStringIndex_test.flux",
													Source: "{r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]}",
													Start: ast.Position{
														Column: 24,
														Line:   37,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 87,
															Line:   37,
														},
														File:   "extract_regexp_findStringIndex_test.flux",
														Source: "extract0: regexp.findStringIndex(r: re, v: r._value)[0]",
														Start: ast.Position{
															Column: 32,
															Line:   37,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   37,
															},
															File:   "extract_regexp_findStringIndex_test.flux",
															Source: "extract0",
															Start: ast.Position{
																Column: 32,
																Line:   37,
															},
														},
													},
													Name: "extract0",
												},
												Separator: nil,
												Value: &ast.IndexExpression{
													Array: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 83,
																		Line:   37,
																	},
																	File:   "extract_regexp_findStringIndex_test.flux",
																	Source: "r: re, v: r._value",
																	Start: ast.Position{
																		Column: 65,
																		Line:   37,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 70,
																			Line:   37,
																		},
																		File:   "extract_regexp_findStringIndex_test.flux",
																		Source: "r: re",
																		Start: ast.Position{
																			Column: 65,
																			Line:   37,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 66,
																				Line:   37,
																			},
																			File:   "extract_regexp_findStringIndex_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 65,
																				Line:   37,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 70,
																				Line:   37,
																			},
																			File:   "extract_regexp_findStringIndex_test.flux",
																			Source: "re",
																			Start: ast.Position{
																				Column: 68,
																				Line:   37,
																			},
																		},
																	},
																	Name: "re",
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 83,
																			Line:   37,
																		},
																		File:   "extract_regexp_findStringIndex_test.flux",
																		Source: "v: r._value",
																		Start: ast.Position{
																			Column: 72,
																			Line:   37,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 73,
																				Line:   37,
																			},
																			File:   "extract_regexp_findStringIndex_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 72,
																				Line:   37,
																			},
																		},
																	},
																	Name: "v",
																},
																Separator: nil,
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 83,
																				Line:   37,
																			},
																			File:   "extract_regexp_findStringIndex_test.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 75,
																				Line:   37,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 76,
																					Line:   37,
																				},
																				File:   "extract_regexp_findStringIndex_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 75,
																					Line:   37,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 83,
																					Line:   37,
																				},
																				File:   "extract_regexp_findStringIndex_test.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 77,
																					Line:   37,
																				},
																			},
																		},
																		Name: "_value",
																	},
																	Rbrack: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 84,
																	Line:   37,
																},
																File:   "extract_regexp_findStringIndex_test.flux",
																Source: "regexp.findStringIndex(r: re, v: r._value)",
																Start: ast.Position{
																	Column: 42,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 64,
																		Line:   37,
																	},
																	File:   "extract_regexp_findStringIndex_test.flux",
																	Source: "regexp.findStringIndex",
																	Start: ast.Position{
																		Column: 42,
																		Line:   37,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 48,
																			Line:   37,
																		},
																		File:   "extract_regexp_findStringIndex_test.flux",
																		Source: "regexp",
																		Start: ast.Position{
																			Column: 42,
																			Line:   37,
																		},
																	},
																},
																Name: "regexp",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 64,
																			Line:   37,
																		},
																		File:   "extract_regexp_findStringIndex_test.flux",
																		Source: "findStringIndex",
																		Start: ast.Position{
																			Column: 49,
																			Line:   37,
																		},
																	},
																},
																Name: "findStringIndex",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 87,
																Line:   37,
															},
															File:   "extract_regexp_findStringIndex_test.flux",
															Source: "regexp.findStringIndex(r: re, v: r._value)[0]",
															Start: ast.Position{
																Column: 42,
																Line:   37,
															},
														},
													},
													Index: &ast.IntegerLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 86,
																	Line:   37,
																},
																File:   "extract_regexp_findStringIndex_test.flux",
																Source: "0",
																Start: ast.Position{
																	Column: 85,
																	Line:   37,
																},
															},
														},
														Value: int64(0),
													},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   37,
														},
														File:   "extract_regexp_findStringIndex_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   37,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   37,
												},
												File:   "extract_regexp_findStringIndex_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   37,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   37,
													},
													File:   "extract_regexp_findStringIndex_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   37,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   37,
								},
								File:   "extract_regexp_findStringIndex_test.flux",
								Source: "map(fn: (r) => ({r with extract0: regexp.findStringIndex(r: re, v: r._value)[0]}))",
								Start: ast.Position{
									Column: 8,
									Line:   37,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   37,
									},
									File:   "extract_regexp_findStringIndex_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   37,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   35,
							},
							File:   "extract_regexp_findStringIndex_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   35,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   35,
								},
								File:   "extract_regexp_findStringIndex_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   35,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   35,
							},
							File:   "extract_regexp_findStringIndex_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   35,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 132,
							Line:   39,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "_string_extract = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   39,
							},
							File:   "extract_regexp_findStringIndex_test.flux",
							Source: "_string_extract",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_string_extract",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 132,
								Line:   39,
							},
							File:   "extract_regexp_findStringIndex_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
							Start: ast.Position{
								Column: 24,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 132,
									Line:   39,
								},
								File:   "extract_regexp_findStringIndex_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
								Start: ast.Position{
									Column: 30,
									Line:   39,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 131,
										Line:   39,
									},
									File:   "extract_regexp_findStringIndex_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract}",
									Start: ast.Position{
										Column: 31,
										Line:   39,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   39,
										},
										File:   "extract_regexp_findStringIndex_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 32,
											Line:   39,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   39,
											},
											File:   "extract_regexp_findStringIndex_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 32,
												Line:   39,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   39,
												},
												File:   "extract_regexp_findStringIndex_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 59,
													Line:   39,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   39,
													},
													File:   "extract_regexp_findStringIndex_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 59,
														Line:   39,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   39,
														},
														File:   "extract_regexp_findStringIndex_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 59,
															Line:   39,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   39,
														},
														File:   "extract_regexp_findStringIndex_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 64,
															Line:   39,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   39,
											},
											File:   "extract_regexp_findStringIndex_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 39,
												Line:   39,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   39,
												},
												File:   "extract_regexp_findStringIndex_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 39,
													Line:   39,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   39,
													},
													File:   "extract_regexp_findStringIndex_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 39,
														Line:   39,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   39,
													},
													File:   "extract_regexp_findStringIndex_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 47,
														Line:   39,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 108,
											Line:   39,
										},
										File:   "extract_regexp_findStringIndex_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 73,
											Line:   39,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   39,
											},
											File:   "extract_regexp_findStringIndex_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 73,
												Line:   39,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 107,
													Line:   39,
												},
												File:   "extract_regexp_findStringIndex_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 95,
													Line:   39,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 107,
														Line:   39,
													},
													File:   "extract_regexp_findStringIndex_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 95,
														Line:   39,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 98,
															Line:   39,
														},
														File:   "extract_regexp_findStringIndex_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 95,
															Line:   39,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 107,
															Line:   39,
														},
														File:   "extract_regexp_findStringIndex_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 100,
															Line:   39,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 108,
												Line:   39,
											},
											File:   "extract_regexp_findStringIndex_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 79,
												Line:   39,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 94,
													Line:   39,
												},
												File:   "extract_regexp_findStringIndex_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 79,
													Line:   39,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 86,
														Line:   39,
													},
													File:   "extract_regexp_findStringIndex_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 79,
														Line:   39,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 94,
														Line:   39,
													},
													File:   "extract_regexp_findStringIndex_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 87,
														Line:   39,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 130,
											Line:   39,
										},
										File:   "extract_regexp_findStringIndex_test.flux",
										Source: "fn: t_string_extract",
										Start: ast.Position{
											Column: 110,
											Line:   39,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 112,
												Line:   39,
											},
											File:   "extract_regexp_findStringIndex_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 110,
												Line:   39,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 130,
												Line:   39,
											},
											File:   "extract_regexp_findStringIndex_test.flux",
											Source: "t_string_extract",
											Start: ast.Position{
												Column: 114,
												Line:   39,
											},
										},
									},
									Name: "t_string_extract",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 132,
						Line:   39,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "test _string_extract = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   6,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "import \"regexp\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   6,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "\"regexp\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "regexp",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "extract_regexp_findStringIndex_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "extract_regexp_findStringIndex_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "extract_regexp_findStringIndex_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 132,
					Line:   39,
				},
				File:   "extract_regexp_findString_test.flux",
				Source: "package pandas_test\n\n\nimport \"testing\"\nimport \"strings\"\nimport \"regexp\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,extract\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,a\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,k\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,b\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,C\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,c\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,F\n\"\nre = regexp.compile(v: \"[[:alpha:]]{1}\")\nt_string_extract = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with extract: regexp.findString(r: re, v: r._value)}))\n\ntest _string_extract = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   8,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   8,
							},
							File:   "extract_regexp_findString_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   8,
							},
							File:   "extract_regexp_findString_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   8,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   8,
								},
								File:   "extract_regexp_findString_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   8,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   8,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   21,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   10,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   10,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   21,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   10,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   33,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,extract\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,a\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,k\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,b\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,C\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,c\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,F\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   22,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   22,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   33,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,extract\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,a\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,k\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,b\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,C\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,c\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,F\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   22,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true,false\n#default,_result,,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path,extract\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/,a\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/,k\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/,b\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/,C\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/,c\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/,F\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 41,
						Line:   34,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "re = regexp.compile(v: \"[[:alpha:]]{1}\")",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   34,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "re",
						Start: ast.Position{
							Column: 1,
							Line:   34,
						},
					},
				},
				Name: "re",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   34,
							},
							File:   "extract_regexp_findString_test.flux",
							Source: "v: \"[[:alpha:]]{1}\"",
							Start: ast.Position{
								Column: 21,
								Line:   34,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   34,
								},
								File:   "extract_regexp_findString_test.flux",
								Source: "v: \"[[:alpha:]]{1}\"",
								Start: ast.Position{
									Column: 21,
									Line:   34,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   34,
									},
									File:   "extract_regexp_findString_test.flux",
									Source: "v",
									Start: ast.Position{
										Column: 21,
										Line:   34,
									},
								},
							},
							Name: "v",
						},
						Separator: nil,
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   34,
									},
									File:   "extract_regexp_findString_test.flux",
									Source: "\"[[:alpha:]]{1}\"",
									Start: ast.Position{
										Column: 24,
										Line:   34,
									},
								},
							},
							Value: "[[:alpha:]]{1}",
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 41,
							Line:   34,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "regexp.compile(v: \"[[:alpha:]]{1}\")",
						Start: ast.Position{
							Column: 6,
							Line:   34,
						},
					},
				},
				Callee: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   34,
							},
							File:   "extract_regexp_findString_test.flux",
							Source: "regexp.compile",
							Start: ast.Position{
								Column: 6,
								Line:   34,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   34,
								},
								File:   "extract_regexp_findString_test.flux",
								Source: "regexp",
								Start: ast.Position{
									Column: 6,
									Line:   34,
								},
							},
						},
						Name: "regexp",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   34,
								},
								File:   "extract_regexp_findString_test.flux",
								Source: "compile",
								Start: ast.Position{
									Column: 13,
									Line:   34,
								},
							},
						},
						Name: "compile",
					},
					Rbrack: nil,
				},
				Lparen: nil,
				Rparen: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 81,
						Line:   37,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "t_string_extract = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with extract: regexp.findString(r: re, v: r._value)}))",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   35,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "t_string_extract",
						Start: ast.Position{
							Column: 1,
							Line:   35,
						},
					},
				},
				Name: "t_string_extract",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 81,
							Line:   37,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with extract: regexp.findString(r: re, v: r._value)}))",
						Start: ast.Position{
							Column: 20,
							Line:   35,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   35,
									},
									File:   "extract_regexp_findString_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 34,
										Line:   35,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   36,
								},
								File:   "extract_regexp_findString_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)",
								Start: ast.Position{
									Column: 34,
									Line:   35,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   36,
										},
										File:   "extract_regexp_findString_test.flux",
										Source: "start: 2018-05-22T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   36,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   36,
											},
											File:   "extract_regexp_findString_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   36,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   36,
												},
												File:   "extract_regexp_findString_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   36,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   36,
												},
												File:   "extract_regexp_findString_test.flux",
												Source: "2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   36,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   36,
									},
									File:   "extract_regexp_findString_test.flux",
									Source: "range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   36,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   36,
										},
										File:   "extract_regexp_findString_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   36,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   37,
							},
							File:   "extract_regexp_findString_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with extract: regexp.findString(r: re, v: r._value)}))",
							Start: ast.Position{
								Column: 34,
								Line:   35,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 80,
										Line:   37,
									},
									File:   "extract_regexp_findString_test.flux",
									Source: "fn: (r) => ({r with extract: regexp.findString(r: re, v: r._value)})",
									Start: ast.Position{
										Column: 12,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   37,
										},
										File:   "extract_regexp_findString_test.flux",
										Source: "fn: (r) => ({r with extract: regexp.findString(r: re, v: r._value)})",
										Start: ast.Position{
											Column: 12,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   37,
											},
											File:   "extract_regexp_findString_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   37,
											},
											File:   "extract_regexp_findString_test.flux",
											Source: "(r) => ({r with extract: regexp.findString(r: re, v: r._value)})",
											Start: ast.Position{
												Column: 16,
												Line:   37,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   37,
												},
												File:   "extract_regexp_findString_test.flux",
												Source: "({r with extract: regexp.findString(r: re, v: r._value)})",
												Start: ast.Position{
													Column: 23,
													Line:   37,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   37,
													},
													File:   "extract_regexp_findString_test.flux",
													Source: "{r with extract: regexp.findString(r: re, v: r._value)}",
													Start: ast.Position{
														Column: 24,
														Line:   37,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   37,
														},
														File:   "extract_regexp_findString_test.flux",
														Source: "extract: regexp.findString(r: re, v: r._value)",
														Start: ast.Position{
															Column: 32,
															Line:   37,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 39,
																Line:   37,
															},
															File:   "extract_regexp_findString_test.flux",
															Source: "extract",
															Start: ast.Position{
																Column: 32,
																Line:   37,
															},
														},
													},
													Name: "extract",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 77,
																	Line:   37,
																},
																File:   "extract_regexp_findString_test.flux",
																Source: "r: re, v: r._value",
																Start: ast.Position{
																	Column: 59,
																	Line:   37,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 64,
																		Line:   37,
																	},
																	File:   "extract_regexp_findString_test.flux",
																	Source: "r: re",
																	Start: ast.Position{
																		Column: 59,
																		Line:   37,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 60,
																			Line:   37,
																		},
																		File:   "extract_regexp_findString_test.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 59,
																			Line:   37,
																		},
																	},
																},
																Name: "r",
															},
															Separator: nil,
															Value: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 64,
																			Line:   37,
																		},
																		File:   "extract_regexp_findString_test.flux",
																		Source: "re",
																		Start: ast.Position{
																			Column: 62,
																			Line:   37,
																		},
																	},
																},
																Name: "re",
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 77,
																		Line:   37,
																	},
																	File:   "extract_regexp_findString_test.flux",
																	Source: "v: r._value",
																	Start: ast.Position{
																		Column: 66,
																		Line:   37,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 67,
																			Line:   37,
																		},
																		File:   "extract_regexp_findString_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 66,
																			Line:   37,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 77,
																			Line:   37,
																		},
																		File:   "extract_regexp_findString_test.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 69,
																			Line:   37,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 70,
																				Line:   37,
																			},
																			File:   "extract_regexp_findString_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 69,
																				Line:   37,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 77,
																				Line:   37,
																			},
																			File:   "extract_regexp_findString_test.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 71,
																				Line:   37,
																			},
																		},
																	},
																	Name: "_value",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 78,
																Line:   37,
															},
															File:   "extract_regexp_findString_test.flux",
															Source: "regexp.findString(r: re, v: r._value)",
															Start: ast.Position{
																Column: 41,
																Line:   37,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 58,
																	Line:   37,
																},
																File:   "extract_regexp_findString_test.flux",
																Source: "regexp.findString",
																Start: ast.Position{
																	Column: 41,
																	Line:   37,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   37,
																	},
																	File:   "extract_regexp_findString_test.flux",
																	Source: "regexp",
																	Start: ast.Position{
																		Column: 41,
																		Line:   37,
																	},
																},
															},
															Name: "regexp",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 58,
																		Line:   37,
																	},
																	File:   "extract_regexp_findString_test.flux",
																	Source: "findString",
																	Start: ast.Position{
																		Column: 48,
																		Line:   37,
																	},
																},
															},
															Name: "findString",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   37,
														},
														File:   "extract_regexp_findString_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   37,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   37,
												},
												File:   "extract_regexp_findString_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   37,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   37,
													},
													File:   "extract_regexp_findString_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   37,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   37,
								},
								File:   "extract_regexp_findString_test.flux",
								Source: "map(fn: (r) => ({r with extract: regexp.findString(r: re, v: r._value)}))",
								Start: ast.Position{
									Column: 8,
									Line:   37,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   37,
									},
									File:   "extract_regexp_findString_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   37,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   35,
							},
							File:   "extract_regexp_findString_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   35,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   35,
								},
								File:   "extract_regexp_findString_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   35,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   35,
							},
							File:   "extract_regexp_findString_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   35,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 132,
							Line:   39,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "_string_extract = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
						Start: ast.Position{
							Column: 6,
							Line:   39,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   39,
							},
							File:   "extract_regexp_findString_test.flux",
							Source: "_string_extract",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Name: "_string_extract",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 132,
								Line:   39,
							},
							File:   "extract_regexp_findString_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
							Start: ast.Position{
								Column: 24,
								Line:   39,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 132,
									Line:   39,
								},
								File:   "extract_regexp_findString_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
								Start: ast.Position{
									Column: 30,
									Line:   39,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 131,
										Line:   39,
									},
									File:   "extract_regexp_findString_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract}",
									Start: ast.Position{
										Column: 31,
										Line:   39,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   39,
										},
										File:   "extract_regexp_findString_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 32,
											Line:   39,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   39,
											},
											File:   "extract_regexp_findString_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 32,
												Line:   39,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   39,
												},
												File:   "extract_regexp_findString_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 59,
													Line:   39,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   39,
													},
													File:   "extract_regexp_findString_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 59,
														Line:   39,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   39,
														},
														File:   "extract_regexp_findString_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 59,
															Line:   39,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   39,
														},
														File:   "extract_regexp_findString_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 64,
															Line:   39,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   39,
											},
											File:   "extract_regexp_findString_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 39,
												Line:   39,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   39,
												},
												File:   "extract_regexp_findString_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 39,
													Line:   39,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   39,
													},
													File:   "extract_regexp_findString_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 39,
														Line:   39,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   39,
													},
													File:   "extract_regexp_findString_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 47,
														Line:   39,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 108,
											Line:   39,
										},
										File:   "extract_regexp_findString_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 73,
											Line:   39,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   39,
											},
											File:   "extract_regexp_findString_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 73,
												Line:   39,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 107,
													Line:   39,
												},
												File:   "extract_regexp_findString_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 95,
													Line:   39,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 107,
														Line:   39,
													},
													File:   "extract_regexp_findString_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 95,
														Line:   39,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 98,
															Line:   39,
														},
														File:   "extract_regexp_findString_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 95,
															Line:   39,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 107,
															Line:   39,
														},
														File:   "extract_regexp_findString_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 100,
															Line:   39,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 108,
												Line:   39,
											},
											File:   "extract_regexp_findString_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 79,
												Line:   39,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 94,
													Line:   39,
												},
												File:   "extract_regexp_findString_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 79,
													Line:   39,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 86,
														Line:   39,
													},
													File:   "extract_regexp_findString_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 79,
														Line:   39,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 94,
														Line:   39,
													},
													File:   "extract_regexp_findString_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 87,
														Line:   39,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 130,
											Line:   39,
										},
										File:   "extract_regexp_findString_test.flux",
										Source: "fn: t_string_extract",
										Start: ast.Position{
											Column: 110,
											Line:   39,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 112,
												Line:   39,
											},
											File:   "extract_regexp_findString_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 110,
												Line:   39,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 130,
												Line:   39,
											},
											File:   "extract_regexp_findString_test.flux",
											Source: "t_string_extract",
											Start: ast.Position{
												Column: 114,
												Line:   39,
											},
										},
									},
									Name: "t_string_extract",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 132,
						Line:   39,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "test _string_extract = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_extract})",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   6,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "import \"regexp\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   6,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "\"regexp\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "regexp",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "extract_regexp_findString_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "extract_regexp_findString_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "extract_regexp_findString_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 130,
					Line:   37,
				},
				File:   "get_strings_substring_test.flux",
				Source: "package pandas_test\n\n\nimport \"testing\"\nimport \"strings\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,c,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,1,used_percent,disk,disk1,apfs,host.local,/\n\"\nt_string_subset = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.substring(v: r._value, start: 0, end: 1)}))\n\ntest _string_subset = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_subset})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "get_strings_substring_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "get_strings_substring_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "get_strings_substring_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "get_strings_substring_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "get_strings_substring_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "get_strings_substring_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "get_strings_substring_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "get_strings_substring_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "get_strings_substring_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,c,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,1,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "get_strings_substring_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "get_strings_substring_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,c,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,1,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,c,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,1,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 91,
						Line:   35,
					},
					File:   "get_strings_substring_test.flux",
					Source: "t_string_subset = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.substring(v: r._value, start: 0, end: 1)}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   33,
						},
						File:   "get_strings_substring_test.flux",
						Source: "t_string_subset",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_subset",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 91,
							Line:   35,
						},
						File:   "get_strings_substring_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.substring(v: r._value, start: 0, end: 1)}))",
						Start: ast.Position{
							Column: 19,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   33,
									},
									File:   "get_strings_substring_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 33,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "get_strings_substring_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)",
								Start: ast.Position{
									Column: 33,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "get_strings_substring_test.flux",
										Source: "start: 2018-05-22T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "get_strings_substring_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "get_strings_substring_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "get_strings_substring_test.flux",
												Source: "2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "get_strings_substring_test.flux",
									Source: "range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "get_strings_substring_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 91,
								Line:   35,
							},
							File:   "get_strings_substring_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.substring(v: r._value, start: 0, end: 1)}))",
							Start: ast.Position{
								Column: 33,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 90,
										Line:   35,
									},
									File:   "get_strings_substring_test.flux",
									Source: "fn: (r) => ({r with _value: strings.substring(v: r._value, start: 0, end: 1)})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 90,
											Line:   35,
										},
										File:   "get_strings_substring_test.flux",
										Source: "fn: (r) => ({r with _value: strings.substring(v: r._value, start: 0, end: 1)})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "get_strings_substring_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 90,
												Line:   35,
											},
											File:   "get_strings_substring_test.flux",
											Source: "(r) => ({r with _value: strings.substring(v: r._value, start: 0, end: 1)})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 90,
													Line:   35,
												},
												File:   "get_strings_substring_test.flux",
												Source: "({r with _value: strings.substring(v: r._value, start: 0, end: 1)})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 89,
														Line:   35,
													},
													File:   "get_strings_substring_test.flux",
													Source: "{r with _value: strings.substring(v: r._value, start: 0, end: 1)}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 88,
															Line:   35,
														},
														File:   "get_strings_substring_test.flux",
														Source: "_value: strings.substring(v: r._value, start: 0, end: 1)",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "get_strings_substring_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 87,
																	Line:   35,
																},
																File:   "get_strings_substring_test.flux",
																Source: "v: r._value, start: 0, end: 1",
																Start: ast.Position{
																	Column: 58,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 69,
																		Line:   35,
																	},
																	File:   "get_strings_substring_test.flux",
																	Source: "v: r._value",
																	Start: ast.Position{
																		Column: 58,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 59,
																			Line:   35,
																		},
																		File:   "get_strings_substring_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 58,
																			Line:   35,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 69,
																			Line:   35,
																		},
																		File:   "get_strings_substring_test.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 61,
																			Line:   35,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 62,
																				Line:   35,
																			},
																			File:   "get_strings_substring_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 61,
																				Line:   35,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 69,
																				Line:   35,
																			},
																			File:   "get_strings_substring_test.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 63,
																				Line:   35,
																			},
																		},
																	},
																	Name: "_value",
																},
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 79,
																		Line:   35,
																	},
																	File:   "get_strings_substring_test.flux",
																	Source: "start: 0",
																	Start: ast.Position{
																		Column: 71,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 76,
																			Line:   35,
																		},
																		File:   "get_strings_substring_test.flux",
																		Source: "start",
																		Start: ast.Position{
																			Column: 71,
																			Line:   35,
																		},
																	},
																},
																Name: "start",
															},
															Separator: nil,
															Value: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 79,
																			Line:   35,
																		},
																		File:   "get_strings_substring_test.flux",
																		Source: "0",
																		Start: ast.Position{
																			Column: 78,
																			Line:   35,
																		},
																	},
																},
																Value: int64(0),
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 87,
																		Line:   35,
																	},
																	File:   "get_strings_substring_test.flux",
																	Source: "end: 1",
																	Start: ast.Position{
																		Column: 81,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 84,
																			Line:   35,
																		},
																		File:   "get_strings_substring_test.flux",
																		Source: "end",
																		Start: ast.Position{
																			Column: 81,
																			Line:   35,
																		},
																	},
																},
																Name: "end",
															},
															Separator: nil,
															Value: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 87,
																			Line:   35,
																		},
																		File:   "get_strings_substring_test.flux",
																		Source: "1",
																		Start: ast.Position{
																			Column: 86,
																			Line:   35,
																		},
																	},
																},
																Value: int64(1),
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 88,
																Line:   35,
															},
															File:   "get_strings_substring_test.flux",
															Source: "strings.substring(v: r._value, start: 0, end: 1)",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 57,
																	Line:   35,
																},
																File:   "get_strings_substring_test.flux",
																Source: "strings.substring",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   35,
																	},
																	File:   "get_strings_substring_test.flux",
																	Source: "strings",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "strings",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 57,
																		Line:   35,
																	},
																	File:   "get_strings_substring_test.flux",
																	Source: "substring",
																	Start: ast.Position{
																		Column: 48,
																		Line:   35,
																	},
																},
															},
															Name: "substring",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "get_strings_substring_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "get_strings_substring_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "get_strings_substring_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   35,
								},
								File:   "get_strings_substring_test.flux",
								Source: "map(fn: (r) => ({r with _value: strings.substring(v: r._value, start: 0, end: 1)}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "get_strings_substring_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   33,
							},
							File:   "get_strings_substring_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 20,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   33,
								},
								File:   "get_strings_substring_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 20,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   33,
							},
							File:   "get_strings_substring_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 26,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 130,
							Line:   37,
						},
						File:   "get_strings_substring_test.flux",
						Source: "_string_subset = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_subset})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   37,
							},
							File:   "get_strings_substring_test.flux",
							Source: "_string_subset",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_string_subset",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 130,
								Line:   37,
							},
							File:   "get_strings_substring_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_subset})",
							Start: ast.Position{
								Column: 23,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 130,
									Line:   37,
								},
								File:   "get_strings_substring_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_subset})",
								Start: ast.Position{
									Column: 29,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 129,
										Line:   37,
									},
									File:   "get_strings_substring_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_subset}",
									Start: ast.Position{
										Column: 30,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   37,
										},
										File:   "get_strings_substring_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 31,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   37,
											},
											File:   "get_strings_substring_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 31,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   37,
												},
												File:   "get_strings_substring_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 58,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   37,
													},
													File:   "get_strings_substring_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 58,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   37,
														},
														File:   "get_strings_substring_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 58,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   37,
														},
														File:   "get_strings_substring_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 63,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   37,
											},
											File:   "get_strings_substring_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 38,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   37,
												},
												File:   "get_strings_substring_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 38,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   37,
													},
													File:   "get_strings_substring_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 38,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   37,
													},
													File:   "get_strings_substring_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 46,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 107,
											Line:   37,
										},
										File:   "get_strings_substring_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 72,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   37,
											},
											File:   "get_strings_substring_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 72,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 106,
													Line:   37,
												},
												File:   "get_strings_substring_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 94,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 106,
														Line:   37,
													},
													File:   "get_strings_substring_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 94,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 97,
															Line:   37,
														},
														File:   "get_strings_substring_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 94,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 106,
															Line:   37,
														},
														File:   "get_strings_substring_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 99,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 107,
												Line:   37,
											},
											File:   "get_strings_substring_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 78,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 93,
													Line:   37,
												},
												File:   "get_strings_substring_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 78,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 85,
														Line:   37,
													},
													File:   "get_strings_substring_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 78,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 93,
														Line:   37,
													},
													File:   "get_strings_substring_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 86,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 128,
											Line:   37,
										},
										File:   "get_strings_substring_test.flux",
										Source: "fn: t_string_subset",
										Start: ast.Position{
											Column: 109,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 111,
												Line:   37,
											},
											File:   "get_strings_substring_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 109,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 128,
												Line:   37,
											},
											File:   "get_strings_substring_test.flux",
											Source: "t_string_subset",
											Start: ast.Position{
												Column: 113,
												Line:   37,
											},
										},
									},
									Name: "t_string_subset",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 130,
						Line:   37,
					},
					File:   "get_strings_substring_test.flux",
					Source: "test _string_subset = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_subset})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "get_strings_substring_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "get_strings_substring_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "get_strings_substring_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "get_strings_substring_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "get_strings_substring_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "get_strings_substring_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "get_strings_substring_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 128,
					Line:   37,
				},
				File:   "ljust_string_joinStr_test.flux",
				Source: "package pandas_test\n\n\nimport \"testing\"\nimport \"strings\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z, a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z, k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z, b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z, 2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z, cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z, 13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\nt_string_ljust = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")}))\n\ntest _string_ljust = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_ljust})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "ljust_string_joinStr_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "ljust_string_joinStr_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "ljust_string_joinStr_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "ljust_string_joinStr_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "ljust_string_joinStr_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "ljust_string_joinStr_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z, a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z, k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z, b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z, 2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z, cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z, 13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z, a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z, k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z, b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z, 2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z, cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z, 13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z, a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z, k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z, b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z, 2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z, cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z, 13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 87,
						Line:   35,
					},
					File:   "ljust_string_joinStr_test.flux",
					Source: "t_string_ljust = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   33,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "t_string_ljust",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_ljust",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 87,
							Line:   35,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")}))",
						Start: ast.Position{
							Column: 18,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   33,
									},
									File:   "ljust_string_joinStr_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 32,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "ljust_string_joinStr_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)",
								Start: ast.Position{
									Column: 32,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "ljust_string_joinStr_test.flux",
										Source: "start: 2018-05-22T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "ljust_string_joinStr_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "ljust_string_joinStr_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "ljust_string_joinStr_test.flux",
												Source: "2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "ljust_string_joinStr_test.flux",
									Source: "range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "ljust_string_joinStr_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 87,
								Line:   35,
							},
							File:   "ljust_string_joinStr_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")}))",
							Start: ast.Position{
								Column: 32,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 86,
										Line:   35,
									},
									File:   "ljust_string_joinStr_test.flux",
									Source: "fn: (r) => ({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 86,
											Line:   35,
										},
										File:   "ljust_string_joinStr_test.flux",
										Source: "fn: (r) => ({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "ljust_string_joinStr_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 86,
												Line:   35,
											},
											File:   "ljust_string_joinStr_test.flux",
											Source: "(r) => ({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 86,
													Line:   35,
												},
												File:   "ljust_string_joinStr_test.flux",
												Source: "({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 85,
														Line:   35,
													},
													File:   "ljust_string_joinStr_test.flux",
													Source: "{r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 84,
															Line:   35,
														},
														File:   "ljust_string_joinStr_test.flux",
														Source: "_value: strings.joinStr(arr: [\" \", r._value], v: \"\")",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "ljust_string_joinStr_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 83,
																	Line:   35,
																},
																File:   "ljust_string_joinStr_test.flux",
																Source: "arr: [\" \", r._value], v: \"\"",
																Start: ast.Position{
																	Column: 56,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 76,
																		Line:   35,
																	},
																	File:   "ljust_string_joinStr_test.flux",
																	Source: "arr: [\" \", r._value]",
																	Start: ast.Position{
																		Column: 56,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 59,
																			Line:   35,
																		},
																		File:   "ljust_string_joinStr_test.flux",
																		Source: "arr",
																		Start: ast.Position{
																			Column: 56,
																			Line:   35,
																		},
																	},
																},
																Name: "arr",
															},
															Separator: nil,
															Value: &ast.ArrayExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 76,
																			Line:   35,
																		},
																		File:   "ljust_string_joinStr_test.flux",
																		Source: "[\" \", r._value]",
																		Start: ast.Position{
																			Column: 61,
																			Line:   35,
																		},
																	},
																},
																Elements: []ast.Expression{&ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 65,
																				Line:   35,
																			},
																			File:   "ljust_string_joinStr_test.flux",
																			Source: "\" \"",
																			Start: ast.Position{
																				Column: 62,
																				Line:   35,
																			},
																		},
																	},
																	Value: " ",
																}, &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 75,
																				Line:   35,
																			},
																			File:   "ljust_string_joinStr_test.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 67,
																				Line:   35,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 68,
																					Line:   35,
																				},
																				File:   "ljust_string_joinStr_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 67,
																					Line:   35,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 75,
																					Line:   35,
																				},
																				File:   "ljust_string_joinStr_test.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 69,
																					Line:   35,
																				},
																			},
																		},
																		Name: "_value",
																	},
																	Rbrack: nil,
																}},
																Lbrack: nil,
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 83,
																		Line:   35,
																	},
																	File:   "ljust_string_joinStr_test.flux",
																	Source: "v: \"\"",
																	Start: ast.Position{
																		Column: 78,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 79,
																			Line:   35,
																		},
																		File:   "ljust_string_joinStr_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 78,
																			Line:   35,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 83,
																			Line:   35,
																		},
																		File:   "ljust_string_joinStr_test.flux",
																		Source: "\"\"",
																		Start: ast.Position{
																			Column: 81,
																			Line:   35,
																		},
																	},
																},
																Value: "",
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 84,
																Line:   35,
															},
															File:   "ljust_string_joinStr_test.flux",
															Source: "strings.joinStr(arr: [\" \", r._value], v: \"\")",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   35,
																},
																File:   "ljust_string_joinStr_test.flux",
																Source: "strings.joinStr",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   35,
																	},
																	File:   "ljust_string_joinStr_test.flux",
																	Source: "strings",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "strings",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   35,
																	},
																	File:   "ljust_string_joinStr_test.flux",
																	Source: "joinStr",
																	Start: ast.Position{
																		Column: 48,
																		Line:   35,
																	},
																},
															},
															Name: "joinStr",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "ljust_string_joinStr_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "ljust_string_joinStr_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "ljust_string_joinStr_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 87,
									Line:   35,
								},
								File:   "ljust_string_joinStr_test.flux",
								Source: "map(fn: (r) => ({r with _value: strings.joinStr(arr: [\" \", r._value], v: \"\")}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "ljust_string_joinStr_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   33,
							},
							File:   "ljust_string_joinStr_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 19,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   33,
								},
								File:   "ljust_string_joinStr_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 19,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   33,
							},
							File:   "ljust_string_joinStr_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 25,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 128,
							Line:   37,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "_string_ljust = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_ljust})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   37,
							},
							File:   "ljust_string_joinStr_test.flux",
							Source: "_string_ljust",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_string_ljust",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 128,
								Line:   37,
							},
							File:   "ljust_string_joinStr_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_ljust})",
							Start: ast.Position{
								Column: 22,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 128,
									Line:   37,
								},
								File:   "ljust_string_joinStr_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_ljust})",
								Start: ast.Position{
									Column: 28,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 127,
										Line:   37,
									},
									File:   "ljust_string_joinStr_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_ljust}",
									Start: ast.Position{
										Column: 29,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   37,
										},
										File:   "ljust_string_joinStr_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 30,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   37,
											},
											File:   "ljust_string_joinStr_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 30,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   37,
												},
												File:   "ljust_string_joinStr_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 57,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   37,
													},
													File:   "ljust_string_joinStr_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 57,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   37,
														},
														File:   "ljust_string_joinStr_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 57,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 68,
															Line:   37,
														},
														File:   "ljust_string_joinStr_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 62,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   37,
											},
											File:   "ljust_string_joinStr_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 37,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   37,
												},
												File:   "ljust_string_joinStr_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 37,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   37,
													},
													File:   "ljust_string_joinStr_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 37,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   37,
													},
													File:   "ljust_string_joinStr_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 45,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 106,
											Line:   37,
										},
										File:   "ljust_string_joinStr_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 71,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 75,
												Line:   37,
											},
											File:   "ljust_string_joinStr_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 71,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 105,
													Line:   37,
												},
												File:   "ljust_string_joinStr_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 93,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 105,
														Line:   37,
													},
													File:   "ljust_string_joinStr_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 93,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 96,
															Line:   37,
														},
														File:   "ljust_string_joinStr_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 93,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 105,
															Line:   37,
														},
														File:   "ljust_string_joinStr_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 98,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 106,
												Line:   37,
											},
											File:   "ljust_string_joinStr_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 77,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 92,
													Line:   37,
												},
												File:   "ljust_string_joinStr_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 77,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 84,
														Line:   37,
													},
													File:   "ljust_string_joinStr_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 77,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 92,
														Line:   37,
													},
													File:   "ljust_string_joinStr_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 85,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 126,
											Line:   37,
										},
										File:   "ljust_string_joinStr_test.flux",
										Source: "fn: t_string_ljust",
										Start: ast.Position{
											Column: 108,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 110,
												Line:   37,
											},
											File:   "ljust_string_joinStr_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 108,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 126,
												Line:   37,
											},
											File:   "ljust_string_joinStr_test.flux",
											Source: "t_string_ljust",
											Start: ast.Position{
												Column: 112,
												Line:   37,
											},
										},
									},
									Name: "t_string_ljust",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 128,
						Line:   37,
					},
					File:   "ljust_string_joinStr_test.flux",
					Source: "test _string_ljust = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_ljust})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "ljust_string_joinStr_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "ljust_string_joinStr_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "ljust_string_joinStr_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "ljust_string_joinStr_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "ljust_string_joinStr_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 132,
					Line:   37,
				},
				File:   "lower_strings_toLower_test.flux",
				Source: "package pandas_test\n\n\nimport \"testing\"\nimport \"strings\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2cotde,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,clnsknmi  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13f2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\nt_string_toLower = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.toLower(v: r._value)}))\n\ntest _string_toLower = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toLower})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "lower_strings_toLower_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "lower_strings_toLower_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "lower_strings_toLower_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "lower_strings_toLower_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "lower_strings_toLower_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "lower_strings_toLower_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2cotde,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,clnsknmi  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13f2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2cotde,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,clnsknmi  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13f2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2cotde,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,clnsknmi  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13f2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 71,
						Line:   35,
					},
					File:   "lower_strings_toLower_test.flux",
					Source: "t_string_toLower = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.toLower(v: r._value)}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   33,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "t_string_toLower",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_toLower",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 71,
							Line:   35,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.toLower(v: r._value)}))",
						Start: ast.Position{
							Column: 20,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   33,
									},
									File:   "lower_strings_toLower_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 34,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "lower_strings_toLower_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)",
								Start: ast.Position{
									Column: 34,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "lower_strings_toLower_test.flux",
										Source: "start: 2018-05-22T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "lower_strings_toLower_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "lower_strings_toLower_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "lower_strings_toLower_test.flux",
												Source: "2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "lower_strings_toLower_test.flux",
									Source: "range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "lower_strings_toLower_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   35,
							},
							File:   "lower_strings_toLower_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.toLower(v: r._value)}))",
							Start: ast.Position{
								Column: 34,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   35,
									},
									File:   "lower_strings_toLower_test.flux",
									Source: "fn: (r) => ({r with _value: strings.toLower(v: r._value)})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   35,
										},
										File:   "lower_strings_toLower_test.flux",
										Source: "fn: (r) => ({r with _value: strings.toLower(v: r._value)})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "lower_strings_toLower_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   35,
											},
											File:   "lower_strings_toLower_test.flux",
											Source: "(r) => ({r with _value: strings.toLower(v: r._value)})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   35,
												},
												File:   "lower_strings_toLower_test.flux",
												Source: "({r with _value: strings.toLower(v: r._value)})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   35,
													},
													File:   "lower_strings_toLower_test.flux",
													Source: "{r with _value: strings.toLower(v: r._value)}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 68,
															Line:   35,
														},
														File:   "lower_strings_toLower_test.flux",
														Source: "_value: strings.toLower(v: r._value)",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "lower_strings_toLower_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 67,
																	Line:   35,
																},
																File:   "lower_strings_toLower_test.flux",
																Source: "v: r._value",
																Start: ast.Position{
																	Column: 56,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 67,
																		Line:   35,
																	},
																	File:   "lower_strings_toLower_test.flux",
																	Source: "v: r._value",
																	Start: ast.Position{
																		Column: 56,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 57,
																			Line:   35,
																		},
																		File:   "lower_strings_toLower_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 56,
																			Line:   35,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 67,
																			Line:   35,
																		},
																		File:   "lower_strings_toLower_test.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 59,
																			Line:   35,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 60,
																				Line:   35,
																			},
																			File:   "lower_strings_toLower_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 59,
																				Line:   35,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 67,
																				Line:   35,
																			},
																			File:   "lower_strings_toLower_test.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 61,
																				Line:   35,
																			},
																		},
																	},
																	Name: "_value",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   35,
															},
															File:   "lower_strings_toLower_test.flux",
															Source: "strings.toLower(v: r._value)",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   35,
																},
																File:   "lower_strings_toLower_test.flux",
																Source: "strings.toLower",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   35,
																	},
																	File:   "lower_strings_toLower_test.flux",
																	Source: "strings",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "strings",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   35,
																	},
																	File:   "lower_strings_toLower_test.flux",
																	Source: "toLower",
																	Start: ast.Position{
																		Column: 48,
																		Line:   35,
																	},
																},
															},
															Name: "toLower",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "lower_strings_toLower_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "lower_strings_toLower_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "lower_strings_toLower_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   35,
								},
								File:   "lower_strings_toLower_test.flux",
								Source: "map(fn: (r) => ({r with _value: strings.toLower(v: r._value)}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "lower_strings_toLower_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "lower_strings_toLower_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   33,
								},
								File:   "lower_strings_toLower_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "lower_strings_toLower_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 132,
							Line:   37,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "_string_toLower = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toLower})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   37,
							},
							File:   "lower_strings_toLower_test.flux",
							Source: "_string_toLower",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_string_toLower",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 132,
								Line:   37,
							},
							File:   "lower_strings_toLower_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toLower})",
							Start: ast.Position{
								Column: 24,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 132,
									Line:   37,
								},
								File:   "lower_strings_toLower_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toLower})",
								Start: ast.Position{
									Column: 30,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 131,
										Line:   37,
									},
									File:   "lower_strings_toLower_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toLower}",
									Start: ast.Position{
										Column: 31,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   37,
										},
										File:   "lower_strings_toLower_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 32,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   37,
											},
											File:   "lower_strings_toLower_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 32,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   37,
												},
												File:   "lower_strings_toLower_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 59,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   37,
													},
													File:   "lower_strings_toLower_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 59,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   37,
														},
														File:   "lower_strings_toLower_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 59,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   37,
														},
														File:   "lower_strings_toLower_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 64,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   37,
											},
											File:   "lower_strings_toLower_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 39,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   37,
												},
												File:   "lower_strings_toLower_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 39,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   37,
													},
													File:   "lower_strings_toLower_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 39,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   37,
													},
													File:   "lower_strings_toLower_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 47,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 108,
											Line:   37,
										},
										File:   "lower_strings_toLower_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 73,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   37,
											},
											File:   "lower_strings_toLower_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 73,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 107,
													Line:   37,
												},
												File:   "lower_strings_toLower_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 95,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 107,
														Line:   37,
													},
													File:   "lower_strings_toLower_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 95,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 98,
															Line:   37,
														},
														File:   "lower_strings_toLower_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 95,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 107,
															Line:   37,
														},
														File:   "lower_strings_toLower_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 100,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 108,
												Line:   37,
											},
											File:   "lower_strings_toLower_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 79,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 94,
													Line:   37,
												},
												File:   "lower_strings_toLower_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 79,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 86,
														Line:   37,
													},
													File:   "lower_strings_toLower_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 79,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 94,
														Line:   37,
													},
													File:   "lower_strings_toLower_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 87,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 130,
											Line:   37,
										},
										File:   "lower_strings_toLower_test.flux",
										Source: "fn: t_string_toLower",
										Start: ast.Position{
											Column: 110,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 112,
												Line:   37,
											},
											File:   "lower_strings_toLower_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 110,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 130,
												Line:   37,
											},
											File:   "lower_strings_toLower_test.flux",
											Source: "t_string_toLower",
											Start: ast.Position{
												Column: 114,
												Line:   37,
											},
										},
									},
									Name: "t_string_toLower",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 132,
						Line:   37,
					},
					File:   "lower_strings_toLower_test.flux",
					Source: "test _string_toLower = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_toLower})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "lower_strings_toLower_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "lower_strings_toLower_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "lower_strings_toLower_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "lower_strings_toLower_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "lower_strings_toLower_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 134,
					Line:   37,
				},
				File:   "lstrip_string_trimLeft_test.flux",
				Source: "package pandas_test\n\n\nimport \"testing\"\nimport \"strings\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,  cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\nt_string_trimLeft = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.trimLeft(v: r._value, cutset: \" \")}))\n\ntest _string_trimLeft = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimLeft})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "lstrip_string_trimLeft_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "lstrip_string_trimLeft_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "lstrip_string_trimLeft_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "lstrip_string_trimLeft_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "lstrip_string_trimLeft_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,  cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,  cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,  cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "lstrip_string_trimLeft_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 85,
						Line:   35,
					},
					File:   "lstrip_string_trimLeft_test.flux",
					Source: "t_string_trimLeft = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.trimLeft(v: r._value, cutset: \" \")}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   33,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "t_string_trimLeft",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_trimLeft",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 85,
							Line:   35,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.trimLeft(v: r._value, cutset: \" \")}))",
						Start: ast.Position{
							Column: 21,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   33,
									},
									File:   "lstrip_string_trimLeft_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 35,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "lstrip_string_trimLeft_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)",
								Start: ast.Position{
									Column: 35,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "lstrip_string_trimLeft_test.flux",
										Source: "start: 2018-05-22T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "lstrip_string_trimLeft_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "lstrip_string_trimLeft_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "lstrip_string_trimLeft_test.flux",
												Source: "2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "lstrip_string_trimLeft_test.flux",
									Source: "range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "lstrip_string_trimLeft_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 85,
								Line:   35,
							},
							File:   "lstrip_string_trimLeft_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.trimLeft(v: r._value, cutset: \" \")}))",
							Start: ast.Position{
								Column: 35,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   35,
									},
									File:   "lstrip_string_trimLeft_test.flux",
									Source: "fn: (r) => ({r with _value: strings.trimLeft(v: r._value, cutset: \" \")})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 84,
											Line:   35,
										},
										File:   "lstrip_string_trimLeft_test.flux",
										Source: "fn: (r) => ({r with _value: strings.trimLeft(v: r._value, cutset: \" \")})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "lstrip_string_trimLeft_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   35,
											},
											File:   "lstrip_string_trimLeft_test.flux",
											Source: "(r) => ({r with _value: strings.trimLeft(v: r._value, cutset: \" \")})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 84,
													Line:   35,
												},
												File:   "lstrip_string_trimLeft_test.flux",
												Source: "({r with _value: strings.trimLeft(v: r._value, cutset: \" \")})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 83,
														Line:   35,
													},
													File:   "lstrip_string_trimLeft_test.flux",
													Source: "{r with _value: strings.trimLeft(v: r._value, cutset: \" \")}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   35,
														},
														File:   "lstrip_string_trimLeft_test.flux",
														Source: "_value: strings.trimLeft(v: r._value, cutset: \" \")",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "lstrip_string_trimLeft_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 81,
																	Line:   35,
																},
																File:   "lstrip_string_trimLeft_test.flux",
																Source: "v: r._value, cutset: \" \"",
																Start: ast.Position{
																	Column: 57,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 68,
																		Line:   35,
																	},
																	File:   "lstrip_string_trimLeft_test.flux",
																	Source: "v: r._value",
																	Start: ast.Position{
																		Column: 57,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 58,
																			Line:   35,
																		},
																		File:   "lstrip_string_trimLeft_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 57,
																			Line:   35,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 68,
																			Line:   35,
																		},
																		File:   "lstrip_string_trimLeft_test.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 60,
																			Line:   35,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 61,
																				Line:   35,
																			},
																			File:   "lstrip_string_trimLeft_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 60,
																				Line:   35,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 68,
																				Line:   35,
																			},
																			File:   "lstrip_string_trimLeft_test.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 62,
																				Line:   35,
																			},
																		},
																	},
																	Name: "_value",
																},
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 81,
																		Line:   35,
																	},
																	File:   "lstrip_string_trimLeft_test.flux",
																	Source: "cutset: \" \"",
																	Start: ast.Position{
																		Column: 70,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 76,
																			Line:   35,
																		},
																		File:   "lstrip_string_trimLeft_test.flux",
																		Source: "cutset",
																		Start: ast.Position{
																			Column: 70,
																			Line:   35,
																		},
																	},
																},
																Name: "cutset",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 81,
																			Line:   35,
																		},
																		File:   "lstrip_string_trimLeft_test.flux",
																		Source: "\" \"",
																		Start: ast.Position{
																			Column: 78,
																			Line:   35,
																		},
																	},
																},
																Value: " ",
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 82,
																Line:   35,
															},
															File:   "lstrip_string_trimLeft_test.flux",
															Source: "strings.trimLeft(v: r._value, cutset: \" \")",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   35,
																},
																File:   "lstrip_string_trimLeft_test.flux",
																Source: "strings.trimLeft",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   35,
																	},
																	File:   "lstrip_string_trimLeft_test.flux",
																	Source: "strings",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "strings",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   35,
																	},
																	File:   "lstrip_string_trimLeft_test.flux",
																	Source: "trimLeft",
																	Start: ast.Position{
																		Column: 48,
																		Line:   35,
																	},
																},
															},
															Name: "trimLeft",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "lstrip_string_trimLeft_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "lstrip_string_trimLeft_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "lstrip_string_trimLeft_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   35,
								},
								File:   "lstrip_string_trimLeft_test.flux",
								Source: "map(fn: (r) => ({r with _value: strings.trimLeft(v: r._value, cutset: \" \")}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "lstrip_string_trimLeft_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   33,
							},
							File:   "lstrip_string_trimLeft_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 22,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   33,
								},
								File:   "lstrip_string_trimLeft_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 22,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   33,
							},
							File:   "lstrip_string_trimLeft_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 134,
							Line:   37,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "_string_trimLeft = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimLeft})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   37,
							},
							File:   "lstrip_string_trimLeft_test.flux",
							Source: "_string_trimLeft",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_string_trimLeft",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 134,
								Line:   37,
							},
							File:   "lstrip_string_trimLeft_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimLeft})",
							Start: ast.Position{
								Column: 25,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 134,
									Line:   37,
								},
								File:   "lstrip_string_trimLeft_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimLeft})",
								Start: ast.Position{
									Column: 31,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 133,
										Line:   37,
									},
									File:   "lstrip_string_trimLeft_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimLeft}",
									Start: ast.Position{
										Column: 32,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   37,
										},
										File:   "lstrip_string_trimLeft_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 33,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   37,
											},
											File:   "lstrip_string_trimLeft_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 33,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   37,
												},
												File:   "lstrip_string_trimLeft_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 60,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 71,
														Line:   37,
													},
													File:   "lstrip_string_trimLeft_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 60,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   37,
														},
														File:   "lstrip_string_trimLeft_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 60,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   37,
														},
														File:   "lstrip_string_trimLeft_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 65,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   37,
											},
											File:   "lstrip_string_trimLeft_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 40,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   37,
												},
												File:   "lstrip_string_trimLeft_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 40,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   37,
													},
													File:   "lstrip_string_trimLeft_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 40,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   37,
													},
													File:   "lstrip_string_trimLeft_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 48,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 109,
											Line:   37,
										},
										File:   "lstrip_string_trimLeft_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 74,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   37,
											},
											File:   "lstrip_string_trimLeft_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 74,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 108,
													Line:   37,
												},
												File:   "lstrip_string_trimLeft_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 96,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 108,
														Line:   37,
													},
													File:   "lstrip_string_trimLeft_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 96,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 99,
															Line:   37,
														},
														File:   "lstrip_string_trimLeft_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 96,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 108,
															Line:   37,
														},
														File:   "lstrip_string_trimLeft_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 101,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 109,
												Line:   37,
											},
											File:   "lstrip_string_trimLeft_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 80,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 95,
													Line:   37,
												},
												File:   "lstrip_string_trimLeft_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 80,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   37,
													},
													File:   "lstrip_string_trimLeft_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 80,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 95,
														Line:   37,
													},
													File:   "lstrip_string_trimLeft_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 88,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 132,
											Line:   37,
										},
										File:   "lstrip_string_trimLeft_test.flux",
										Source: "fn: t_string_trimLeft",
										Start: ast.Position{
											Column: 111,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 113,
												Line:   37,
											},
											File:   "lstrip_string_trimLeft_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 111,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 132,
												Line:   37,
											},
											File:   "lstrip_string_trimLeft_test.flux",
											Source: "t_string_trimLeft",
											Start: ast.Position{
												Column: 115,
												Line:   37,
											},
										},
									},
									Name: "t_string_trimLeft",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 134,
						Line:   37,
					},
					File:   "lstrip_string_trimLeft_test.flux",
					Source: "test _string_trimLeft = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimLeft})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "lstrip_string_trimLeft_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "lstrip_string_trimLeft_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "lstrip_string_trimLeft_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "lstrip_string_trimLeft_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "lstrip_string_trimLeft_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 136,
					Line:   37,
				},
				File:   "partition_strings_splitN_test.flux",
				Source: "package pandas_test\n\n\nimport \"testing\"\nimport \"strings\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\nt_string_partition = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]}))\n\ntest _string_partition = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "partition_strings_splitN_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "partition_strings_splitN_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "partition_strings_splitN_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "partition_strings_splitN_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "partition_strings_splitN_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "partition_strings_splitN_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 87,
						Line:   35,
					},
					File:   "partition_strings_splitN_test.flux",
					Source: "t_string_partition = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   33,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "t_string_partition",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_partition",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 87,
							Line:   35,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]}))",
						Start: ast.Position{
							Column: 22,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   33,
									},
									File:   "partition_strings_splitN_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 36,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "partition_strings_splitN_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)",
								Start: ast.Position{
									Column: 36,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "partition_strings_splitN_test.flux",
										Source: "start: 2018-05-22T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "partition_strings_splitN_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "partition_strings_splitN_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "partition_strings_splitN_test.flux",
												Source: "2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "partition_strings_splitN_test.flux",
									Source: "range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "partition_strings_splitN_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 87,
								Line:   35,
							},
							File:   "partition_strings_splitN_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]}))",
							Start: ast.Position{
								Column: 36,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 86,
										Line:   35,
									},
									File:   "partition_strings_splitN_test.flux",
									Source: "fn: (r) => ({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 86,
											Line:   35,
										},
										File:   "partition_strings_splitN_test.flux",
										Source: "fn: (r) => ({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "partition_strings_splitN_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 86,
												Line:   35,
											},
											File:   "partition_strings_splitN_test.flux",
											Source: "(r) => ({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 86,
													Line:   35,
												},
												File:   "partition_strings_splitN_test.flux",
												Source: "({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 85,
														Line:   35,
													},
													File:   "partition_strings_splitN_test.flux",
													Source: "{r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 84,
															Line:   35,
														},
														File:   "partition_strings_splitN_test.flux",
														Source: "_value: strings.splitN(v: r._value, t: \" \", i: 2)[0]",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "partition_strings_splitN_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.IndexExpression{
													Array: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 80,
																		Line:   35,
																	},
																	File:   "partition_strings_splitN_test.flux",
																	Source: "v: r._value, t: \" \", i: 2",
																	Start: ast.Position{
																		Column: 55,
																		Line:   35,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 66,
																			Line:   35,
																		},
																		File:   "partition_strings_splitN_test.flux",
																		Source: "v: r._value",
																		Start: ast.Position{
																			Column: 55,
																			Line:   35,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 56,
																				Line:   35,
																			},
																			File:   "partition_strings_splitN_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 55,
																				Line:   35,
																			},
																		},
																	},
																	Name: "v",
																},
																Separator: nil,
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 66,
																				Line:   35,
																			},
																			File:   "partition_strings_splitN_test.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 58,
																				Line:   35,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 59,
																					Line:   35,
																				},
																				File:   "partition_strings_splitN_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 58,
																					Line:   35,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 66,
																					Line:   35,
																				},
																				File:   "partition_strings_splitN_test.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 60,
																					Line:   35,
																				},
																			},
																		},
																		Name: "_value",
																	},
																	Rbrack: nil,
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 74,
																			Line:   35,
																		},
																		File:   "partition_strings_splitN_test.flux",
																		Source: "t: \" \"",
																		Start: ast.Position{
																			Column: 68,
																			Line:   35,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 69,
																				Line:   35,
																			},
																			File:   "partition_strings_splitN_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 68,
																				Line:   35,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 74,
																				Line:   35,
																			},
																			File:   "partition_strings_splitN_test.flux",
																			Source: "\" \"",
																			Start: ast.Position{
																				Column: 71,
																				Line:   35,
																			},
																		},
																	},
																	Value: " ",
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 80,
																			Line:   35,
																		},
																		File:   "partition_strings_splitN_test.flux",
																		Source: "i: 2",
																		Start: ast.Position{
																			Column: 76,
																			Line:   35,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 77,
																				Line:   35,
																			},
																			File:   "partition_strings_splitN_test.flux",
																			Source: "i",
																			Start: ast.Position{
																				Column: 76,
																				Line:   35,
																			},
																		},
																	},
																	Name: "i",
																},
																Separator: nil,
																Value: &ast.IntegerLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 80,
																				Line:   35,
																			},
																			File:   "partition_strings_splitN_test.flux",
																			Source: "2",
																			Start: ast.Position{
																				Column: 79,
																				Line:   35,
																			},
																		},
																	},
																	Value: int64(2),
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 81,
																	Line:   35,
																},
																File:   "partition_strings_splitN_test.flux",
																Source: "strings.splitN(v: r._value, t: \" \", i: 2)",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 54,
																		Line:   35,
																	},
																	File:   "partition_strings_splitN_test.flux",
																	Source: "strings.splitN",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 47,
																			Line:   35,
																		},
																		File:   "partition_strings_splitN_test.flux",
																		Source: "strings",
																		Start: ast.Position{
																			Column: 40,
																			Line:   35,
																		},
																	},
																},
																Name: "strings",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 54,
																			Line:   35,
																		},
																		File:   "partition_strings_splitN_test.flux",
																		Source: "splitN",
																		Start: ast.Position{
																			Column: 48,
																			Line:   35,
																		},
																	},
																},
																Name: "splitN",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 84,
																Line:   35,
															},
															File:   "partition_strings_splitN_test.flux",
															Source: "strings.splitN(v: r._value, t: \" \", i: 2)[0]",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Index: &ast.IntegerLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 83,
																	Line:   35,
																},
																File:   "partition_strings_splitN_test.flux",
																Source: "0",
																Start: ast.Position{
																	Column: 82,
																	Line:   35,
																},
															},
														},
														Value: int64(0),
													},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "partition_strings_splitN_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "partition_strings_splitN_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "partition_strings_splitN_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 87,
									Line:   35,
								},
								File:   "partition_strings_splitN_test.flux",
								Source: "map(fn: (r) => ({r with _value: strings.splitN(v: r._value, t: \" \", i: 2)[0]}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "partition_strings_splitN_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   33,
							},
							File:   "partition_strings_splitN_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 23,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   33,
								},
								File:   "partition_strings_splitN_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 23,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   33,
							},
							File:   "partition_strings_splitN_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 29,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 136,
							Line:   37,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "_string_partition = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   37,
							},
							File:   "partition_strings_splitN_test.flux",
							Source: "_string_partition",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_string_partition",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 136,
								Line:   37,
							},
							File:   "partition_strings_splitN_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
							Start: ast.Position{
								Column: 26,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 136,
									Line:   37,
								},
								File:   "partition_strings_splitN_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
								Start: ast.Position{
									Column: 32,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 135,
										Line:   37,
									},
									File:   "partition_strings_splitN_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition}",
									Start: ast.Position{
										Column: 33,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 73,
											Line:   37,
										},
										File:   "partition_strings_splitN_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 34,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   37,
											},
											File:   "partition_strings_splitN_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 34,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 72,
													Line:   37,
												},
												File:   "partition_strings_splitN_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 61,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 72,
														Line:   37,
													},
													File:   "partition_strings_splitN_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 61,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   37,
														},
														File:   "partition_strings_splitN_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 61,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   37,
														},
														File:   "partition_strings_splitN_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 66,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   37,
											},
											File:   "partition_strings_splitN_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 41,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   37,
												},
												File:   "partition_strings_splitN_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 41,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   37,
													},
													File:   "partition_strings_splitN_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 41,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   37,
													},
													File:   "partition_strings_splitN_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 49,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 110,
											Line:   37,
										},
										File:   "partition_strings_splitN_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 75,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 79,
												Line:   37,
											},
											File:   "partition_strings_splitN_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 75,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 109,
													Line:   37,
												},
												File:   "partition_strings_splitN_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 97,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 109,
														Line:   37,
													},
													File:   "partition_strings_splitN_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 97,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 100,
															Line:   37,
														},
														File:   "partition_strings_splitN_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 97,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 109,
															Line:   37,
														},
														File:   "partition_strings_splitN_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 102,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 110,
												Line:   37,
											},
											File:   "partition_strings_splitN_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 81,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 96,
													Line:   37,
												},
												File:   "partition_strings_splitN_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 81,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 88,
														Line:   37,
													},
													File:   "partition_strings_splitN_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 81,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 96,
														Line:   37,
													},
													File:   "partition_strings_splitN_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 89,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 134,
											Line:   37,
										},
										File:   "partition_strings_splitN_test.flux",
										Source: "fn: t_string_partition",
										Start: ast.Position{
											Column: 112,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 114,
												Line:   37,
											},
											File:   "partition_strings_splitN_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 112,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 134,
												Line:   37,
											},
											File:   "partition_strings_splitN_test.flux",
											Source: "t_string_partition",
											Start: ast.Position{
												Column: 116,
												Line:   37,
											},
										},
									},
									Name: "t_string_partition",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 136,
						Line:   37,
					},
					File:   "partition_strings_splitN_test.flux",
					Source: "test _string_partition = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "partition_strings_splitN_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "partition_strings_splitN_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "partition_strings_splitN_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "partition_strings_splitN_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "partition_strings_splitN_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 136,
					Line:   37,
				},
				File:   "repeat_strings_repeat_test.flux",
				Source: "package pandas_test\n\n\nimport \"testing\"\nimport \"strings\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,aa,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe   2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F213F2,used_percent,disk,disk1,apfs,host.local,/\n\"\nt_string_partition = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.repeat(v: r._value, i: 2)}))\n\ntest _string_partition = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "repeat_strings_repeat_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "repeat_strings_repeat_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "repeat_strings_repeat_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "repeat_strings_repeat_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "repeat_strings_repeat_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "repeat_strings_repeat_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,aa,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe   2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F213F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,aa,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe   2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F213F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,aa,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe   2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F213F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 76,
						Line:   35,
					},
					File:   "repeat_strings_repeat_test.flux",
					Source: "t_string_partition = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.repeat(v: r._value, i: 2)}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   33,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "t_string_partition",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_partition",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 76,
							Line:   35,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.repeat(v: r._value, i: 2)}))",
						Start: ast.Position{
							Column: 22,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   33,
									},
									File:   "repeat_strings_repeat_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 36,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "repeat_strings_repeat_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)",
								Start: ast.Position{
									Column: 36,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "repeat_strings_repeat_test.flux",
										Source: "start: 2018-05-22T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "repeat_strings_repeat_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "repeat_strings_repeat_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "repeat_strings_repeat_test.flux",
												Source: "2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "repeat_strings_repeat_test.flux",
									Source: "range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "repeat_strings_repeat_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 76,
								Line:   35,
							},
							File:   "repeat_strings_repeat_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.repeat(v: r._value, i: 2)}))",
							Start: ast.Position{
								Column: 36,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   35,
									},
									File:   "repeat_strings_repeat_test.flux",
									Source: "fn: (r) => ({r with _value: strings.repeat(v: r._value, i: 2)})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   35,
										},
										File:   "repeat_strings_repeat_test.flux",
										Source: "fn: (r) => ({r with _value: strings.repeat(v: r._value, i: 2)})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "repeat_strings_repeat_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 75,
												Line:   35,
											},
											File:   "repeat_strings_repeat_test.flux",
											Source: "(r) => ({r with _value: strings.repeat(v: r._value, i: 2)})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 75,
													Line:   35,
												},
												File:   "repeat_strings_repeat_test.flux",
												Source: "({r with _value: strings.repeat(v: r._value, i: 2)})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   35,
													},
													File:   "repeat_strings_repeat_test.flux",
													Source: "{r with _value: strings.repeat(v: r._value, i: 2)}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   35,
														},
														File:   "repeat_strings_repeat_test.flux",
														Source: "_value: strings.repeat(v: r._value, i: 2)",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "repeat_strings_repeat_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 72,
																	Line:   35,
																},
																File:   "repeat_strings_repeat_test.flux",
																Source: "v: r._value, i: 2",
																Start: ast.Position{
																	Column: 55,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 66,
																		Line:   35,
																	},
																	File:   "repeat_strings_repeat_test.flux",
																	Source: "v: r._value",
																	Start: ast.Position{
																		Column: 55,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 56,
																			Line:   35,
																		},
																		File:   "repeat_strings_repeat_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 55,
																			Line:   35,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 66,
																			Line:   35,
																		},
																		File:   "repeat_strings_repeat_test.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 58,
																			Line:   35,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 59,
																				Line:   35,
																			},
																			File:   "repeat_strings_repeat_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 58,
																				Line:   35,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 66,
																				Line:   35,
																			},
																			File:   "repeat_strings_repeat_test.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 60,
																				Line:   35,
																			},
																		},
																	},
																	Name: "_value",
																},
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 72,
																		Line:   35,
																	},
																	File:   "repeat_strings_repeat_test.flux",
																	Source: "i: 2",
																	Start: ast.Position{
																		Column: 68,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 69,
																			Line:   35,
																		},
																		File:   "repeat_strings_repeat_test.flux",
																		Source: "i",
																		Start: ast.Position{
																			Column: 68,
																			Line:   35,
																		},
																	},
																},
																Name: "i",
															},
															Separator: nil,
															Value: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 72,
																			Line:   35,
																		},
																		File:   "repeat_strings_repeat_test.flux",
																		Source: "2",
																		Start: ast.Position{
																			Column: 71,
																			Line:   35,
																		},
																	},
																},
																Value: int64(2),
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 73,
																Line:   35,
															},
															File:   "repeat_strings_repeat_test.flux",
															Source: "strings.repeat(v: r._value, i: 2)",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 54,
																	Line:   35,
																},
																File:   "repeat_strings_repeat_test.flux",
																Source: "strings.repeat",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   35,
																	},
																	File:   "repeat_strings_repeat_test.flux",
																	Source: "strings",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "strings",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 54,
																		Line:   35,
																	},
																	File:   "repeat_strings_repeat_test.flux",
																	Source: "repeat",
																	Start: ast.Position{
																		Column: 48,
																		Line:   35,
																	},
																},
															},
															Name: "repeat",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "repeat_strings_repeat_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "repeat_strings_repeat_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "repeat_strings_repeat_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   35,
								},
								File:   "repeat_strings_repeat_test.flux",
								Source: "map(fn: (r) => ({r with _value: strings.repeat(v: r._value, i: 2)}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "repeat_strings_repeat_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   33,
							},
							File:   "repeat_strings_repeat_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 23,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   33,
								},
								File:   "repeat_strings_repeat_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 23,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   33,
							},
							File:   "repeat_strings_repeat_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 29,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 136,
							Line:   37,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "_string_partition = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   37,
							},
							File:   "repeat_strings_repeat_test.flux",
							Source: "_string_partition",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_string_partition",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 136,
								Line:   37,
							},
							File:   "repeat_strings_repeat_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
							Start: ast.Position{
								Column: 26,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 136,
									Line:   37,
								},
								File:   "repeat_strings_repeat_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
								Start: ast.Position{
									Column: 32,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 135,
										Line:   37,
									},
									File:   "repeat_strings_repeat_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition}",
									Start: ast.Position{
										Column: 33,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 73,
											Line:   37,
										},
										File:   "repeat_strings_repeat_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 34,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   37,
											},
											File:   "repeat_strings_repeat_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 34,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 72,
													Line:   37,
												},
												File:   "repeat_strings_repeat_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 61,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 72,
														Line:   37,
													},
													File:   "repeat_strings_repeat_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 61,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   37,
														},
														File:   "repeat_strings_repeat_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 61,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   37,
														},
														File:   "repeat_strings_repeat_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 66,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   37,
											},
											File:   "repeat_strings_repeat_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 41,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   37,
												},
												File:   "repeat_strings_repeat_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 41,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   37,
													},
													File:   "repeat_strings_repeat_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 41,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   37,
													},
													File:   "repeat_strings_repeat_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 49,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 110,
											Line:   37,
										},
										File:   "repeat_strings_repeat_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 75,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 79,
												Line:   37,
											},
											File:   "repeat_strings_repeat_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 75,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 109,
													Line:   37,
												},
												File:   "repeat_strings_repeat_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 97,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 109,
														Line:   37,
													},
													File:   "repeat_strings_repeat_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 97,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 100,
															Line:   37,
														},
														File:   "repeat_strings_repeat_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 97,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 109,
															Line:   37,
														},
														File:   "repeat_strings_repeat_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 102,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 110,
												Line:   37,
											},
											File:   "repeat_strings_repeat_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 81,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 96,
													Line:   37,
												},
												File:   "repeat_strings_repeat_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 81,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 88,
														Line:   37,
													},
													File:   "repeat_strings_repeat_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 81,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 96,
														Line:   37,
													},
													File:   "repeat_strings_repeat_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 89,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 134,
											Line:   37,
										},
										File:   "repeat_strings_repeat_test.flux",
										Source: "fn: t_string_partition",
										Start: ast.Position{
											Column: 112,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 114,
												Line:   37,
											},
											File:   "repeat_strings_repeat_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 112,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 134,
												Line:   37,
											},
											File:   "repeat_strings_repeat_test.flux",
											Source: "t_string_partition",
											Start: ast.Position{
												Column: 116,
												Line:   37,
											},
										},
									},
									Name: "t_string_partition",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 136,
						Line:   37,
					},
					File:   "repeat_strings_repeat_test.flux",
					Source: "test _string_partition = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_partition})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "repeat_strings_repeat_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "repeat_strings_repeat_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "repeat_strings_repeat_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "repeat_strings_repeat_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "repeat_strings_repeat_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 132,
					Line:   37,
				},
				File:   "replace_strings_replace_test.flux",
				Source: "package pandas_test\n\n\nimport \"testing\"\nimport \"strings\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,c NMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\nt_string_replace = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)}))\n\ntest _string_replace = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_replace})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "replace_strings_replace_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "replace_strings_replace_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "replace_strings_replace_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "replace_strings_replace_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "replace_strings_replace_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "replace_strings_replace_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,c NMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,c NMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,c NMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 96,
						Line:   35,
					},
					File:   "replace_strings_replace_test.flux",
					Source: "t_string_replace = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   33,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "t_string_replace",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_replace",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 96,
							Line:   35,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)}))",
						Start: ast.Position{
							Column: 20,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   33,
									},
									File:   "replace_strings_replace_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 34,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "replace_strings_replace_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)",
								Start: ast.Position{
									Column: 34,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "replace_strings_replace_test.flux",
										Source: "start: 2018-05-22T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "replace_strings_replace_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "replace_strings_replace_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "replace_strings_replace_test.flux",
												Source: "2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "replace_strings_replace_test.flux",
									Source: "range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "replace_strings_replace_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 96,
								Line:   35,
							},
							File:   "replace_strings_replace_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)}))",
							Start: ast.Position{
								Column: 34,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 95,
										Line:   35,
									},
									File:   "replace_strings_replace_test.flux",
									Source: "fn: (r) => ({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 95,
											Line:   35,
										},
										File:   "replace_strings_replace_test.flux",
										Source: "fn: (r) => ({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "replace_strings_replace_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 95,
												Line:   35,
											},
											File:   "replace_strings_replace_test.flux",
											Source: "(r) => ({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 95,
													Line:   35,
												},
												File:   "replace_strings_replace_test.flux",
												Source: "({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 94,
														Line:   35,
													},
													File:   "replace_strings_replace_test.flux",
													Source: "{r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 93,
															Line:   35,
														},
														File:   "replace_strings_replace_test.flux",
														Source: "_value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "replace_strings_replace_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 92,
																	Line:   35,
																},
																File:   "replace_strings_replace_test.flux",
																Source: "v: r._value, t: \"LnSk\", u: \" \", i: 1",
																Start: ast.Position{
																	Column: 56,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 67,
																		Line:   35,
																	},
																	File:   "replace_strings_replace_test.flux",
																	Source: "v: r._value",
																	Start: ast.Position{
																		Column: 56,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 57,
																			Line:   35,
																		},
																		File:   "replace_strings_replace_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 56,
																			Line:   35,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 67,
																			Line:   35,
																		},
																		File:   "replace_strings_replace_test.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 59,
																			Line:   35,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 60,
																				Line:   35,
																			},
																			File:   "replace_strings_replace_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 59,
																				Line:   35,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 67,
																				Line:   35,
																			},
																			File:   "replace_strings_replace_test.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 61,
																				Line:   35,
																			},
																		},
																	},
																	Name: "_value",
																},
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 78,
																		Line:   35,
																	},
																	File:   "replace_strings_replace_test.flux",
																	Source: "t: \"LnSk\"",
																	Start: ast.Position{
																		Column: 69,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 70,
																			Line:   35,
																		},
																		File:   "replace_strings_replace_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 69,
																			Line:   35,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 78,
																			Line:   35,
																		},
																		File:   "replace_strings_replace_test.flux",
																		Source: "\"LnSk\"",
																		Start: ast.Position{
																			Column: 72,
																			Line:   35,
																		},
																	},
																},
																Value: "LnSk",
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 86,
																		Line:   35,
																	},
																	File:   "replace_strings_replace_test.flux",
																	Source: "u: \" \"",
																	Start: ast.Position{
																		Column: 80,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 81,
																			Line:   35,
																		},
																		File:   "replace_strings_replace_test.flux",
																		Source: "u",
																		Start: ast.Position{
																			Column: 80,
																			Line:   35,
																		},
																	},
																},
																Name: "u",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 86,
																			Line:   35,
																		},
																		File:   "replace_strings_replace_test.flux",
																		Source: "\" \"",
																		Start: ast.Position{
																			Column: 83,
																			Line:   35,
																		},
																	},
																},
																Value: " ",
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 92,
																		Line:   35,
																	},
																	File:   "replace_strings_replace_test.flux",
																	Source: "i: 1",
																	Start: ast.Position{
																		Column: 88,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 89,
																			Line:   35,
																		},
																		File:   "replace_strings_replace_test.flux",
																		Source: "i",
																		Start: ast.Position{
																			Column: 88,
																			Line:   35,
																		},
																	},
																},
																Name: "i",
															},
															Separator: nil,
															Value: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 92,
																			Line:   35,
																		},
																		File:   "replace_strings_replace_test.flux",
																		Source: "1",
																		Start: ast.Position{
																			Column: 91,
																			Line:   35,
																		},
																	},
																},
																Value: int64(1),
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 93,
																Line:   35,
															},
															File:   "replace_strings_replace_test.flux",
															Source: "strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   35,
																},
																File:   "replace_strings_replace_test.flux",
																Source: "strings.replace",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   35,
																	},
																	File:   "replace_strings_replace_test.flux",
																	Source: "strings",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "strings",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   35,
																	},
																	File:   "replace_strings_replace_test.flux",
																	Source: "replace",
																	Start: ast.Position{
																		Column: 48,
																		Line:   35,
																	},
																},
															},
															Name: "replace",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "replace_strings_replace_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "replace_strings_replace_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "replace_strings_replace_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 96,
									Line:   35,
								},
								File:   "replace_strings_replace_test.flux",
								Source: "map(fn: (r) => ({r with _value: strings.replace(v: r._value, t: \"LnSk\", u: \" \", i: 1)}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "replace_strings_replace_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "replace_strings_replace_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   33,
								},
								File:   "replace_strings_replace_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "replace_strings_replace_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 132,
							Line:   37,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "_string_replace = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_replace})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   37,
							},
							File:   "replace_strings_replace_test.flux",
							Source: "_string_replace",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_string_replace",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 132,
								Line:   37,
							},
							File:   "replace_strings_replace_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_replace})",
							Start: ast.Position{
								Column: 24,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 132,
									Line:   37,
								},
								File:   "replace_strings_replace_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_replace})",
								Start: ast.Position{
									Column: 30,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 131,
										Line:   37,
									},
									File:   "replace_strings_replace_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_replace}",
									Start: ast.Position{
										Column: 31,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   37,
										},
										File:   "replace_strings_replace_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 32,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   37,
											},
											File:   "replace_strings_replace_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 32,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   37,
												},
												File:   "replace_strings_replace_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 59,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   37,
													},
													File:   "replace_strings_replace_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 59,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   37,
														},
														File:   "replace_strings_replace_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 59,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   37,
														},
														File:   "replace_strings_replace_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 64,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   37,
											},
											File:   "replace_strings_replace_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 39,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   37,
												},
												File:   "replace_strings_replace_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 39,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   37,
													},
													File:   "replace_strings_replace_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 39,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   37,
													},
													File:   "replace_strings_replace_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 47,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 108,
											Line:   37,
										},
										File:   "replace_strings_replace_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 73,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   37,
											},
											File:   "replace_strings_replace_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 73,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 107,
													Line:   37,
												},
												File:   "replace_strings_replace_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 95,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 107,
														Line:   37,
													},
													File:   "replace_strings_replace_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 95,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 98,
															Line:   37,
														},
														File:   "replace_strings_replace_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 95,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 107,
															Line:   37,
														},
														File:   "replace_strings_replace_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 100,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 108,
												Line:   37,
											},
											File:   "replace_strings_replace_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 79,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 94,
													Line:   37,
												},
												File:   "replace_strings_replace_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 79,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 86,
														Line:   37,
													},
													File:   "replace_strings_replace_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 79,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 94,
														Line:   37,
													},
													File:   "replace_strings_replace_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 87,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 130,
											Line:   37,
										},
										File:   "replace_strings_replace_test.flux",
										Source: "fn: t_string_replace",
										Start: ast.Position{
											Column: 110,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 112,
												Line:   37,
											},
											File:   "replace_strings_replace_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 110,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 130,
												Line:   37,
											},
											File:   "replace_strings_replace_test.flux",
											Source: "t_string_replace",
											Start: ast.Position{
												Column: 114,
												Line:   37,
											},
										},
									},
									Name: "t_string_replace",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 132,
						Line:   37,
					},
					File:   "replace_strings_replace_test.flux",
					Source: "test _string_replace = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_replace})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "replace_strings_replace_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "replace_strings_replace_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "replace_strings_replace_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "replace_strings_replace_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "replace_strings_replace_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 136,
					Line:   37,
				},
				File:   "rstrip_string_trimRight_test.flux",
				Source: "package pandas_test\n\n\nimport \"testing\"\nimport \"strings\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,  cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,  cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\nt_string_trimRight = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.trimRight(v: r._value, cutset: \" \")}))\n\ntest _string_trimRight = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimRight})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "rstrip_string_trimRight_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "rstrip_string_trimRight_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "rstrip_string_trimRight_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "rstrip_string_trimRight_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "rstrip_string_trimRight_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,  cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,  cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,  cLnSkNMI  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2  ,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "rstrip_string_trimRight_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,  cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,  cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,      k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,  2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,  cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 86,
						Line:   35,
					},
					File:   "rstrip_string_trimRight_test.flux",
					Source: "t_string_trimRight = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.trimRight(v: r._value, cutset: \" \")}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   33,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "t_string_trimRight",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_trimRight",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 86,
							Line:   35,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.trimRight(v: r._value, cutset: \" \")}))",
						Start: ast.Position{
							Column: 22,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   33,
									},
									File:   "rstrip_string_trimRight_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 36,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "rstrip_string_trimRight_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)",
								Start: ast.Position{
									Column: 36,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "rstrip_string_trimRight_test.flux",
										Source: "start: 2018-05-22T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "rstrip_string_trimRight_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "rstrip_string_trimRight_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "rstrip_string_trimRight_test.flux",
												Source: "2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "rstrip_string_trimRight_test.flux",
									Source: "range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "rstrip_string_trimRight_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   35,
							},
							File:   "rstrip_string_trimRight_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.trimRight(v: r._value, cutset: \" \")}))",
							Start: ast.Position{
								Column: 36,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 85,
										Line:   35,
									},
									File:   "rstrip_string_trimRight_test.flux",
									Source: "fn: (r) => ({r with _value: strings.trimRight(v: r._value, cutset: \" \")})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   35,
										},
										File:   "rstrip_string_trimRight_test.flux",
										Source: "fn: (r) => ({r with _value: strings.trimRight(v: r._value, cutset: \" \")})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "rstrip_string_trimRight_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 85,
												Line:   35,
											},
											File:   "rstrip_string_trimRight_test.flux",
											Source: "(r) => ({r with _value: strings.trimRight(v: r._value, cutset: \" \")})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 85,
													Line:   35,
												},
												File:   "rstrip_string_trimRight_test.flux",
												Source: "({r with _value: strings.trimRight(v: r._value, cutset: \" \")})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 84,
														Line:   35,
													},
													File:   "rstrip_string_trimRight_test.flux",
													Source: "{r with _value: strings.trimRight(v: r._value, cutset: \" \")}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 83,
															Line:   35,
														},
														File:   "rstrip_string_trimRight_test.flux",
														Source: "_value: strings.trimRight(v: r._value, cutset: \" \")",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "rstrip_string_trimRight_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 82,
																	Line:   35,
																},
																File:   "rstrip_string_trimRight_test.flux",
																Source: "v: r._value, cutset: \" \"",
																Start: ast.Position{
																	Column: 58,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 69,
																		Line:   35,
																	},
																	File:   "rstrip_string_trimRight_test.flux",
																	Source: "v: r._value",
																	Start: ast.Position{
																		Column: 58,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 59,
																			Line:   35,
																		},
																		File:   "rstrip_string_trimRight_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 58,
																			Line:   35,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 69,
																			Line:   35,
																		},
																		File:   "rstrip_string_trimRight_test.flux",
																		Source: "r._value",
																		Start: ast.Position{
																			Column: 61,
																			Line:   35,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 62,
																				Line:   35,
																			},
																			File:   "rstrip_string_trimRight_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 61,
																				Line:   35,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 69,
																				Line:   35,
																			},
																			File:   "rstrip_string_trimRight_test.flux",
																			Source: "_value",
																			Start: ast.Position{
																				Column: 63,
																				Line:   35,
																			},
																		},
																	},
																	Name: "_value",
																},
																Rbrack: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 82,
																		Line:   35,
																	},
																	File:   "rstrip_string_trimRight_test.flux",
																	Source: "cutset: \" \"",
																	Start: ast.Position{
																		Column: 71,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 77,
																			Line:   35,
																		},
																		File:   "rstrip_string_trimRight_test.flux",
																		Source: "cutset",
																		Start: ast.Position{
																			Column: 71,
																			Line:   35,
																		},
																	},
																},
																Name: "cutset",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 82,
																			Line:   35,
																		},
																		File:   "rstrip_string_trimRight_test.flux",
																		Source: "\" \"",
																		Start: ast.Position{
																			Column: 79,
																			Line:   35,
																		},
																	},
																},
																Value: " ",
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 83,
																Line:   35,
															},
															File:   "rstrip_string_trimRight_test.flux",
															Source: "strings.trimRight(v: r._value, cutset: \" \")",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 57,
																	Line:   35,
																},
																File:   "rstrip_string_trimRight_test.flux",
																Source: "strings.trimRight",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   35,
																	},
																	File:   "rstrip_string_trimRight_test.flux",
																	Source: "strings",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "strings",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 57,
																		Line:   35,
																	},
																	File:   "rstrip_string_trimRight_test.flux",
																	Source: "trimRight",
																	Start: ast.Position{
																		Column: 48,
																		Line:   35,
																	},
																},
															},
															Name: "trimRight",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "rstrip_string_trimRight_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "rstrip_string_trimRight_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "rstrip_string_trimRight_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   35,
								},
								File:   "rstrip_string_trimRight_test.flux",
								Source: "map(fn: (r) => ({r with _value: strings.trimRight(v: r._value, cutset: \" \")}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "rstrip_string_trimRight_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   33,
							},
							File:   "rstrip_string_trimRight_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 23,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   33,
								},
								File:   "rstrip_string_trimRight_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 23,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   33,
							},
							File:   "rstrip_string_trimRight_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 29,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 136,
							Line:   37,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "_string_trimRight = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimRight})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   37,
							},
							File:   "rstrip_string_trimRight_test.flux",
							Source: "_string_trimRight",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_string_trimRight",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 136,
								Line:   37,
							},
							File:   "rstrip_string_trimRight_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimRight})",
							Start: ast.Position{
								Column: 26,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 136,
									Line:   37,
								},
								File:   "rstrip_string_trimRight_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimRight})",
								Start: ast.Position{
									Column: 32,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 135,
										Line:   37,
									},
									File:   "rstrip_string_trimRight_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimRight}",
									Start: ast.Position{
										Column: 33,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 73,
											Line:   37,
										},
										File:   "rstrip_string_trimRight_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 34,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   37,
											},
											File:   "rstrip_string_trimRight_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 34,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 72,
													Line:   37,
												},
												File:   "rstrip_string_trimRight_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 61,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 72,
														Line:   37,
													},
													File:   "rstrip_string_trimRight_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 61,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   37,
														},
														File:   "rstrip_string_trimRight_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 61,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   37,
														},
														File:   "rstrip_string_trimRight_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 66,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   37,
											},
											File:   "rstrip_string_trimRight_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 41,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   37,
												},
												File:   "rstrip_string_trimRight_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 41,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   37,
													},
													File:   "rstrip_string_trimRight_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 41,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   37,
													},
													File:   "rstrip_string_trimRight_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 49,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 110,
											Line:   37,
										},
										File:   "rstrip_string_trimRight_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 75,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 79,
												Line:   37,
											},
											File:   "rstrip_string_trimRight_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 75,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 109,
													Line:   37,
												},
												File:   "rstrip_string_trimRight_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 97,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 109,
														Line:   37,
													},
													File:   "rstrip_string_trimRight_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 97,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 100,
															Line:   37,
														},
														File:   "rstrip_string_trimRight_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 97,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 109,
															Line:   37,
														},
														File:   "rstrip_string_trimRight_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 102,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 110,
												Line:   37,
											},
											File:   "rstrip_string_trimRight_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 81,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 96,
													Line:   37,
												},
												File:   "rstrip_string_trimRight_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 81,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 88,
														Line:   37,
													},
													File:   "rstrip_string_trimRight_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 81,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 96,
														Line:   37,
													},
													File:   "rstrip_string_trimRight_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 89,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 134,
											Line:   37,
										},
										File:   "rstrip_string_trimRight_test.flux",
										Source: "fn: t_string_trimRight",
										Start: ast.Position{
											Column: 112,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 114,
												Line:   37,
											},
											File:   "rstrip_string_trimRight_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 112,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 134,
												Line:   37,
											},
											File:   "rstrip_string_trimRight_test.flux",
											Source: "t_string_trimRight",
											Start: ast.Position{
												Column: 116,
												Line:   37,
											},
										},
									},
									Name: "t_string_trimRight",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 136,
						Line:   37,
					},
					File:   "rstrip_string_trimRight_test.flux",
					Source: "test _string_trimRight = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_trimRight})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "rstrip_string_trimRight_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "rstrip_string_trimRight_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "rstrip_string_trimRight_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "rstrip_string_trimRight_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "rstrip_string_trimRight_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 150,
					Line:   37,
				},
				File:   "startswith_strings_regexp_hasPrefix_test.flux",
				Source: "package pandas_test\n\n\nimport \"testing\"\nimport \"strings\"\nimport \"regexp\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n\"\nre = regexp.compile(v: \"[[:alpha:]]{1}\")\nt_string_regexp_hasPrefix = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> filter(fn: (r) => regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0]))\n\ntest _string_regexp_hasPrefix = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasPrefix})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   8,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   8,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   8,
							},
							File:   "startswith_strings_regexp_hasPrefix_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   8,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   8,
							},
							File:   "startswith_strings_regexp_hasPrefix_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   8,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   8,
								},
								File:   "startswith_strings_regexp_hasPrefix_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   8,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   8,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   21,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   10,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   10,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   21,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   10,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   31,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   22,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   22,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   31,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   22,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9ngm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 41,
						Line:   32,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "re = regexp.compile(v: \"[[:alpha:]]{1}\")",
					Start: ast.Position{
						Column: 1,
						Line:   32,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   32,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "re",
						Start: ast.Position{
							Column: 1,
							Line:   32,
						},
					},
				},
				Name: "re",
			},
			Init: &ast.CallExpression{
				Arguments: []ast.Expression{&ast.ObjectExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   32,
							},
							File:   "startswith_strings_regexp_hasPrefix_test.flux",
							Source: "v: \"[[:alpha:]]{1}\"",
							Start: ast.Position{
								Column: 21,
								Line:   32,
							},
						},
					},
					Lbrace: nil,
					Properties: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   32,
								},
								File:   "startswith_strings_regexp_hasPrefix_test.flux",
								Source: "v: \"[[:alpha:]]{1}\"",
								Start: ast.Position{
									Column: 21,
									Line:   32,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   32,
									},
									File:   "startswith_strings_regexp_hasPrefix_test.flux",
									Source: "v",
									Start: ast.Position{
										Column: 21,
										Line:   32,
									},
								},
							},
							Name: "v",
						},
						Separator: nil,
						Value: &ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   32,
									},
									File:   "startswith_strings_regexp_hasPrefix_test.flux",
									Source: "\"[[:alpha:]]{1}\"",
									Start: ast.Position{
										Column: 24,
										Line:   32,
									},
								},
							},
							Value: "[[:alpha:]]{1}",
						},
					}},
					Rbrace: nil,
					With:   nil,
				}},
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 41,
							Line:   32,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "regexp.compile(v: \"[[:alpha:]]{1}\")",
						Start: ast.Position{
							Column: 6,
							Line:   32,
						},
					},
				},
				Callee: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   32,
							},
							File:   "startswith_strings_regexp_hasPrefix_test.flux",
							Source: "regexp.compile",
							Start: ast.Position{
								Column: 6,
								Line:   32,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   32,
								},
								File:   "startswith_strings_regexp_hasPrefix_test.flux",
								Source: "regexp",
								Start: ast.Position{
									Column: 6,
									Line:   32,
								},
							},
						},
						Name: "regexp",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   32,
								},
								File:   "startswith_strings_regexp_hasPrefix_test.flux",
								Source: "compile",
								Start: ast.Position{
									Column: 13,
									Line:   32,
								},
							},
						},
						Name: "compile",
					},
					Rbrack: nil,
				},
				Lparen: nil,
				Rparen: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 99,
						Line:   35,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "t_string_regexp_hasPrefix = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> filter(fn: (r) => regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0]))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   33,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "t_string_regexp_hasPrefix",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_regexp_hasPrefix",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 99,
							Line:   35,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> filter(fn: (r) => regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0]))",
						Start: ast.Position{
							Column: 29,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   33,
									},
									File:   "startswith_strings_regexp_hasPrefix_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 43,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "startswith_strings_regexp_hasPrefix_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)",
								Start: ast.Position{
									Column: 43,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "startswith_strings_regexp_hasPrefix_test.flux",
										Source: "start: 2018-05-22T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "startswith_strings_regexp_hasPrefix_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "startswith_strings_regexp_hasPrefix_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "startswith_strings_regexp_hasPrefix_test.flux",
												Source: "2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "startswith_strings_regexp_hasPrefix_test.flux",
									Source: "range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "startswith_strings_regexp_hasPrefix_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   35,
							},
							File:   "startswith_strings_regexp_hasPrefix_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> filter(fn: (r) => regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0]))",
							Start: ast.Position{
								Column: 43,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 98,
										Line:   35,
									},
									File:   "startswith_strings_regexp_hasPrefix_test.flux",
									Source: "fn: (r) => regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0])",
									Start: ast.Position{
										Column: 15,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   35,
										},
										File:   "startswith_strings_regexp_hasPrefix_test.flux",
										Source: "fn: (r) => regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0])",
										Start: ast.Position{
											Column: 15,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   35,
											},
											File:   "startswith_strings_regexp_hasPrefix_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 15,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   35,
											},
											File:   "startswith_strings_regexp_hasPrefix_test.flux",
											Source: "(r) => regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0])",
											Start: ast.Position{
												Column: 19,
												Line:   35,
											},
										},
									},
									Body: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 97,
														Line:   35,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "r: re, v: strings.split(v: r._value, t: \"\")[0]",
													Start: ast.Position{
														Column: 51,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 56,
															Line:   35,
														},
														File:   "startswith_strings_regexp_hasPrefix_test.flux",
														Source: "r: re",
														Start: ast.Position{
															Column: 51,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 52,
																Line:   35,
															},
															File:   "startswith_strings_regexp_hasPrefix_test.flux",
															Source: "r",
															Start: ast.Position{
																Column: 51,
																Line:   35,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   35,
															},
															File:   "startswith_strings_regexp_hasPrefix_test.flux",
															Source: "re",
															Start: ast.Position{
																Column: 54,
																Line:   35,
															},
														},
													},
													Name: "re",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 97,
															Line:   35,
														},
														File:   "startswith_strings_regexp_hasPrefix_test.flux",
														Source: "v: strings.split(v: r._value, t: \"\")[0]",
														Start: ast.Position{
															Column: 58,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 59,
																Line:   35,
															},
															File:   "startswith_strings_regexp_hasPrefix_test.flux",
															Source: "v",
															Start: ast.Position{
																Column: 58,
																Line:   35,
															},
														},
													},
													Name: "v",
												},
												Separator: nil,
												Value: &ast.IndexExpression{
													Array: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 93,
																		Line:   35,
																	},
																	File:   "startswith_strings_regexp_hasPrefix_test.flux",
																	Source: "v: r._value, t: \"\"",
																	Start: ast.Position{
																		Column: 75,
																		Line:   35,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 86,
																			Line:   35,
																		},
																		File:   "startswith_strings_regexp_hasPrefix_test.flux",
																		Source: "v: r._value",
																		Start: ast.Position{
																			Column: 75,
																			Line:   35,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 76,
																				Line:   35,
																			},
																			File:   "startswith_strings_regexp_hasPrefix_test.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 75,
																				Line:   35,
																			},
																		},
																	},
																	Name: "v",
																},
																Separator: nil,
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 86,
																				Line:   35,
																			},
																			File:   "startswith_strings_regexp_hasPrefix_test.flux",
																			Source: "r._value",
																			Start: ast.Position{
																				Column: 78,
																				Line:   35,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 79,
																					Line:   35,
																				},
																				File:   "startswith_strings_regexp_hasPrefix_test.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 78,
																					Line:   35,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 86,
																					Line:   35,
																				},
																				File:   "startswith_strings_regexp_hasPrefix_test.flux",
																				Source: "_value",
																				Start: ast.Position{
																					Column: 80,
																					Line:   35,
																				},
																			},
																		},
																		Name: "_value",
																	},
																	Rbrack: nil,
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 93,
																			Line:   35,
																		},
																		File:   "startswith_strings_regexp_hasPrefix_test.flux",
																		Source: "t: \"\"",
																		Start: ast.Position{
																			Column: 88,
																			Line:   35,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 89,
																				Line:   35,
																			},
																			File:   "startswith_strings_regexp_hasPrefix_test.flux",
																			Source: "t",
																			Start: ast.Position{
																				Column: 88,
																				Line:   35,
																			},
																		},
																	},
																	Name: "t",
																},
																Separator: nil,
																Value: &ast.StringLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 93,
																				Line:   35,
																			},
																			File:   "startswith_strings_regexp_hasPrefix_test.flux",
																			Source: "\"\"",
																			Start: ast.Position{
																				Column: 91,
																				Line:   35,
																			},
																		},
																	},
																	Value: "",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 94,
																	Line:   35,
																},
																File:   "startswith_strings_regexp_hasPrefix_test.flux",
																Source: "strings.split(v: r._value, t: \"\")",
																Start: ast.Position{
																	Column: 61,
																	Line:   35,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 74,
																		Line:   35,
																	},
																	File:   "startswith_strings_regexp_hasPrefix_test.flux",
																	Source: "strings.split",
																	Start: ast.Position{
																		Column: 61,
																		Line:   35,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 68,
																			Line:   35,
																		},
																		File:   "startswith_strings_regexp_hasPrefix_test.flux",
																		Source: "strings",
																		Start: ast.Position{
																			Column: 61,
																			Line:   35,
																		},
																	},
																},
																Name: "strings",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 74,
																			Line:   35,
																		},
																		File:   "startswith_strings_regexp_hasPrefix_test.flux",
																		Source: "split",
																		Start: ast.Position{
																			Column: 69,
																			Line:   35,
																		},
																	},
																},
																Name: "split",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 97,
																Line:   35,
															},
															File:   "startswith_strings_regexp_hasPrefix_test.flux",
															Source: "strings.split(v: r._value, t: \"\")[0]",
															Start: ast.Position{
																Column: 61,
																Line:   35,
															},
														},
													},
													Index: &ast.IntegerLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 96,
																	Line:   35,
																},
																File:   "startswith_strings_regexp_hasPrefix_test.flux",
																Source: "0",
																Start: ast.Position{
																	Column: 95,
																	Line:   35,
																},
															},
														},
														Value: int64(0),
													},
													Lbrack: nil,
													Rbrack: nil,
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 98,
													Line:   35,
												},
												File:   "startswith_strings_regexp_hasPrefix_test.flux",
												Source: "regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0])",
												Start: ast.Position{
													Column: 26,
													Line:   35,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   35,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "regexp.matchRegexpString",
													Start: ast.Position{
														Column: 26,
														Line:   35,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 32,
															Line:   35,
														},
														File:   "startswith_strings_regexp_hasPrefix_test.flux",
														Source: "regexp",
														Start: ast.Position{
															Column: 26,
															Line:   35,
														},
													},
												},
												Name: "regexp",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 50,
															Line:   35,
														},
														File:   "startswith_strings_regexp_hasPrefix_test.flux",
														Source: "matchRegexpString",
														Start: ast.Position{
															Column: 33,
															Line:   35,
														},
													},
												},
												Name: "matchRegexpString",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   35,
												},
												File:   "startswith_strings_regexp_hasPrefix_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 20,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   35,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 20,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   35,
								},
								File:   "startswith_strings_regexp_hasPrefix_test.flux",
								Source: "filter(fn: (r) => regexp.matchRegexpString(r: re, v: strings.split(v: r._value, t: \"\")[0]))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   35,
									},
									File:   "startswith_strings_regexp_hasPrefix_test.flux",
									Source: "filter",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "filter",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   33,
							},
							File:   "startswith_strings_regexp_hasPrefix_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 30,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   33,
								},
								File:   "startswith_strings_regexp_hasPrefix_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 30,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   33,
							},
							File:   "startswith_strings_regexp_hasPrefix_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 36,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 150,
							Line:   37,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "_string_regexp_hasPrefix = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasPrefix})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   37,
							},
							File:   "startswith_strings_regexp_hasPrefix_test.flux",
							Source: "_string_regexp_hasPrefix",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_string_regexp_hasPrefix",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 150,
								Line:   37,
							},
							File:   "startswith_strings_regexp_hasPrefix_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasPrefix})",
							Start: ast.Position{
								Column: 33,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 150,
									Line:   37,
								},
								File:   "startswith_strings_regexp_hasPrefix_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasPrefix})",
								Start: ast.Position{
									Column: 39,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 149,
										Line:   37,
									},
									File:   "startswith_strings_regexp_hasPrefix_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasPrefix}",
									Start: ast.Position{
										Column: 40,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   37,
										},
										File:   "startswith_strings_regexp_hasPrefix_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 41,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   37,
											},
											File:   "startswith_strings_regexp_hasPrefix_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 41,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   37,
												},
												File:   "startswith_strings_regexp_hasPrefix_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 68,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   37,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 68,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   37,
														},
														File:   "startswith_strings_regexp_hasPrefix_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 68,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   37,
														},
														File:   "startswith_strings_regexp_hasPrefix_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 73,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   37,
											},
											File:   "startswith_strings_regexp_hasPrefix_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 48,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   37,
												},
												File:   "startswith_strings_regexp_hasPrefix_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 48,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 55,
														Line:   37,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 48,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 67,
														Line:   37,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 56,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 117,
											Line:   37,
										},
										File:   "startswith_strings_regexp_hasPrefix_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 82,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 86,
												Line:   37,
											},
											File:   "startswith_strings_regexp_hasPrefix_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 82,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 116,
													Line:   37,
												},
												File:   "startswith_strings_regexp_hasPrefix_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 104,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 116,
														Line:   37,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 104,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 107,
															Line:   37,
														},
														File:   "startswith_strings_regexp_hasPrefix_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 104,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 116,
															Line:   37,
														},
														File:   "startswith_strings_regexp_hasPrefix_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 109,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 117,
												Line:   37,
											},
											File:   "startswith_strings_regexp_hasPrefix_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 88,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 103,
													Line:   37,
												},
												File:   "startswith_strings_regexp_hasPrefix_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 88,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 95,
														Line:   37,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 88,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 103,
														Line:   37,
													},
													File:   "startswith_strings_regexp_hasPrefix_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 96,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 148,
											Line:   37,
										},
										File:   "startswith_strings_regexp_hasPrefix_test.flux",
										Source: "fn: t_string_regexp_hasPrefix",
										Start: ast.Position{
											Column: 119,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 121,
												Line:   37,
											},
											File:   "startswith_strings_regexp_hasPrefix_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 119,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 148,
												Line:   37,
											},
											File:   "startswith_strings_regexp_hasPrefix_test.flux",
											Source: "t_string_regexp_hasPrefix",
											Start: ast.Position{
												Column: 123,
												Line:   37,
											},
										},
									},
									Name: "t_string_regexp_hasPrefix",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 150,
						Line:   37,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "test _string_regexp_hasPrefix = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_regexp_hasPrefix})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   5,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "import \"strings\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   5,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "\"strings\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "strings",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   6,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "import \"regexp\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   6,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "\"regexp\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "regexp",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "startswith_strings_regexp_hasPrefix_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   1,
					},
					File:   "startswith_strings_regexp_hasPrefix_test.flux",
					Source: "package pandas_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   1,
						},
						File:   "startswith_strings_regexp_hasPrefix_test.flux",
						Source: "pandas_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "pandas_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 130,
					Line:   37,
				},
				File:   "strip_strings_trimLeftRight_test.flux",
				Source: "package pandas_test\n\n\nimport \"testing\"\nimport \"strings\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z, a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,   k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,  b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z, cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,    13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\noutData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"\nt_string_lstrip = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")}))\n\ntest _string_lstrip = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_lstrip})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "strip_strings_trimLeftRight_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "strip_strings_trimLeftRight_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "strip_strings_trimLeftRight_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "strip_strings_trimLeftRight_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "strip_strings_trimLeftRight_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z, a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,   k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,  b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z, cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,    13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z, a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,   k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,  b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z, cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,    13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,\n,result,table,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z, a ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:36Z,   k9n  gm ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:46Z,  b  ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:56Z,2COTDe   ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:06Z, cLnSkNMI ,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:54:16Z,    13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "strip_strings_trimLeftRight_test.flux",
					Source: "outData = \"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string\n#group,false,false,true,true,false,false,true,true,true,true,true,true\n#default,_result,,,,,,,,,,,\n,result,table,_start,_stop,_time,_value,_field,_measurement,device,fstype,host,path\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:26Z,a,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:36Z,k9n  gm,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:46Z,b,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:53:56Z,2COTDe,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:06Z,cLnSkNMI,used_percent,disk,disk1,apfs,host.local,/\n,,0,2018-05-22T19:53:26Z,2030-01-01T00:00:00Z,2018-05-22T19:54:16Z,13F2,used_percent,disk,disk1,apfs,host.local,/\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 120,
						Line:   35,
					},
					File:   "strip_strings_trimLeftRight_test.flux",
					Source: "t_string_lstrip = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   33,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "t_string_lstrip",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_string_lstrip",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 120,
							Line:   35,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")}))",
						Start: ast.Position{
							Column: 19,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   33,
									},
									File:   "strip_strings_trimLeftRight_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 33,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "strip_strings_trimLeftRight_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)",
								Start: ast.Position{
									Column: 33,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "strip_strings_trimLeftRight_test.flux",
										Source: "start: 2018-05-22T19:53:26Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "strip_strings_trimLeftRight_test.flux",
											Source: "start: 2018-05-22T19:53:26Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "strip_strings_trimLeftRight_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "strip_strings_trimLeftRight_test.flux",
												Source: "2018-05-22T19:53:26Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-05-22T19:53:26Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "strip_strings_trimLeftRight_test.flux",
									Source: "range(start: 2018-05-22T19:53:26Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "strip_strings_trimLeftRight_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 120,
								Line:   35,
							},
							File:   "strip_strings_trimLeftRight_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:26Z)\n    |> map(fn: (r) => ({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")}))",
							Start: ast.Position{
								Column: 33,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 119,
										Line:   35,
									},
									File:   "strip_strings_trimLeftRight_test.flux",
									Source: "fn: (r) => ({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 119,
											Line:   35,
										},
										File:   "strip_strings_trimLeftRight_test.flux",
										Source: "fn: (r) => ({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "strip_strings_trimLeftRight_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 119,
												Line:   35,
											},
											File:   "strip_strings_trimLeftRight_test.flux",
											Source: "(r) => ({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 119,
													Line:   35,
												},
												File:   "strip_strings_trimLeftRight_test.flux",
												Source: "({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 118,
														Line:   35,
													},
													File:   "strip_strings_trimLeftRight_test.flux",
													Source: "{r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 117,
															Line:   35,
														},
														File:   "strip_strings_trimLeftRight_test.flux",
														Source: "_value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "strip_strings_trimLeftRight_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 116,
																	Line:   35,
																},
																File:   "strip_strings_trimLeftRight_test.flux",
																Source: "v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \"",
																Start: ast.Position{
																	Column: 58,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 103,
																		Line:   35,
																	},
																	File:   "strip_strings_trimLeftRight_test.flux",
																	Source: "v: strings.trimLeft(v: r._value, cutset: \" \")",
																	Start: ast.Position{
																		Column: 58,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 59,
																			Line:   35,
																		},
																		File:   "strip_strings_trimLeftRight_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 58,
																			Line:   35,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 102,
																				Line:   35,
																			},
																			File:   "strip_strings_trimLeftRight_test.flux",
																			Source: "v: r._value, cutset: \" \"",
																			Start: ast.Position{
																				Column: 78,
																				Line:   35,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 89,
																					Line:   35,
																				},
																				File:   "strip_strings_trimLeftRight_test.flux",
																				Source: "v: r._value",
																				Start: ast.Position{
																					Column: 78,
																					Line:   35,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 79,
																						Line:   35,
																					},
																					File:   "strip_strings_trimLeftRight_test.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 78,
																						Line:   35,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 89,
																						Line:   35,
																					},
																					File:   "strip_strings_trimLeftRight_test.flux",
																					Source: "r._value",
																					Start: ast.Position{
																						Column: 81,
																						Line:   35,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 82,
																							Line:   35,
																						},
																						File:   "strip_strings_trimLeftRight_test.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 81,
																							Line:   35,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 89,
																							Line:   35,
																						},
																						File:   "strip_strings_trimLeftRight_test.flux",
																						Source: "_value",
																						Start: ast.Position{
																							Column: 83,
																							Line:   35,
																						},
																					},
																				},
																				Name: "_value",
																			},
																			Rbrack: nil,
																		},
																	}, &ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 102,
																					Line:   35,
																				},
																				File:   "strip_strings_trimLeftRight_test.flux",
																				Source: "cutset: \" \"",
																				Start: ast.Position{
																					Column: 91,
																					Line:   35,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 97,
																						Line:   35,
																					},
																					File:   "strip_strings_trimLeftRight_test.flux",
																					Source: "cutset",
																					Start: ast.Position{
																						Column: 91,
																						Line:   35,
																					},
																				},
																			},
																			Name: "cutset",
																		},
																		Separator: nil,
																		Value: &ast.StringLiteral{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 102,
																						Line:   35,
																					},
																					File:   "strip_strings_trimLeftRight_test.flux",
																					Source: "\" \"",
																					Start: ast.Position{
																						Column: 99,
																						Line:   35,
																					},
																				},
																			},
																			Value: " ",
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 103,
																			Line:   35,
																		},
																		File:   "strip_strings_trimLeftRight_test.flux",
																		Source: "strings.trimLeft(v: r._value, cutset: \" \")",
																		Start: ast.Position{
																			Column: 61,
																			Line:   35,
																		},
																	},
																},
																Callee: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 77,
																				Line:   35,
																			},
																			File:   "strip_strings_trimLeftRight_test.flux",
																			Source: "strings.trimLeft",
																			Start: ast.Position{
																				Column: 61,
																				Line:   35,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 68,
																					Line:   35,
																				},
																				File:   "strip_strings_trimLeftRight_test.flux",
																				Source: "strings",
																				Start: ast.Position{
																					Column: 61,
																					Line:   35,
																				},
																			},
																		},
																		Name: "strings",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 77,
																					Line:   35,
																				},
																				File:   "strip_strings_trimLeftRight_test.flux",
																				Source: "trimLeft",
																				Start: ast.Position{
																					Column: 69,
																					Line:   35,
																				},
																			},
																		},
																		Name: "trimLeft",
																	},
																	Rbrack: nil,
																},
																Lparen: nil,
																Rparen: nil,
															},
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 116,
																		Line:   35,
																	},
																	File:   "strip_strings_trimLeftRight_test.flux",
																	Source: "cutset: \" \"",
																	Start: ast.Position{
																		Column: 105,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 111,
																			Line:   35,
																		},
																		File:   "strip_strings_trimLeftRight_test.flux",
																		Source: "cutset",
																		Start: ast.Position{
																			Column: 105,
																			Line:   35,
																		},
																	},
																},
																Name: "cutset",
															},
															Separator: nil,
															Value: &ast.StringLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 116,
																			Line:   35,
																		},
																		File:   "strip_strings_trimLeftRight_test.flux",
																		Source: "\" \"",
																		Start: ast.Position{
																			Column: 113,
																			Line:   35,
																		},
																	},
																},
																Value: " ",
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 117,
																Line:   35,
															},
															File:   "strip_strings_trimLeftRight_test.flux",
															Source: "strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 57,
																	Line:   35,
																},
																File:   "strip_strings_trimLeftRight_test.flux",
																Source: "strings.trimRight",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 47,
																		Line:   35,
																	},
																	File:   "strip_strings_trimLeftRight_test.flux",
																	Source: "strings",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "strings",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 57,
																		Line:   35,
																	},
																	File:   "strip_strings_trimLeftRight_test.flux",
																	Source: "trimRight",
																	Start: ast.Position{
																		Column: 48,
																		Line:   35,
																	},
																},
															},
															Name: "trimRight",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "strip_strings_trimLeftRight_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "strip_strings_trimLeftRight_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "strip_strings_trimLeftRight_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 120,
									Line:   35,
								},
								File:   "strip_strings_trimLeftRight_test.flux",
								Source: "map(fn: (r) => ({r with _value: strings.trimRight(v: strings.trimLeft(v: r._value, cutset: \" \"), cutset: \" \")}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "strip_strings_trimLeftRight_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   33,
							},
							File:   "strip_strings_trimLeftRight_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 20,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   33,
								},
								File:   "strip_strings_trimLeftRight_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 20,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   33,
							},
							File:   "strip_strings_trimLeftRight_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 26,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 130,
							Line:   37,
						},
						File:   "strip_strings_trimLeftRight_test.flux",
						Source: "_string_lstrip = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_lstrip})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   37,
							},
							File:   "strip_strings_trimLeftRight_test.flux",
							Source: "_string_lstrip",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_string_lstrip",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 130,
								Line:   37,
							},
							File:   "strip_strings_trimLeftRight_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_lstrip})",
							Start: ast.Position{
								Column: 23,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 130,
									Line:   37,
								},
								File:   "strip_strings_trimLeftRight_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_lstrip})",
								Start: ast.Position{
									Column: 29,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 129,
										Line:   37,
									},
									File:   "strip_strings_trimLeftRight_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_string_lstrip}",
									Start: ast.Position{
										Column: 30,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   37,
										},
										File:   "strip_strings_trimLeftRight_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 31,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   37,
											},
											File:   "strip_strings_trimLeftRight_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 31,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   37,
												},
												File:   "strip_strings_trimLeftRight_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 58,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   37,
													},
													File:   "strip_strings_trimLeftRight_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 58,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key