// DO NOT EDIT: This file is autogenerated via the builtin command.

package universe

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 48,
					Line:   418,
				},
				File:   "universe.flux",
				Source: "package universe\n\n\nimport \"system\"\nimport \"date\"\nimport \"math\"\nimport \"strings\"\nimport \"regexp\"\nimport \"experimental/table\"\n\n// now is a function option whose default behaviour is to return the current system time\noption now = system.time\n\n// Transformation functions\nbuiltin chandeMomentumOscillator : (<-tables: [A], n: int, ?columns: [string]) => [B] where A: Record, B: Record\nbuiltin columns : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin count : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin covariance : (<-tables: [A], ?pearsonr: bool, ?valueDst: string, columns: [string]) => [B] where A: Record, B: Record\nbuiltin cumulativeSum : (<-tables: [A], ?columns: [string]) => [B] where A: Record, B: Record\nbuiltin derivative : (\n    <-tables: [A],\n    ?unit: duration,\n    ?nonNegative: bool,\n    ?columns: [string],\n    ?timeColumn: string,\n) => [B] where\n    A: Record,\n    B: Record\n\nbuiltin die : (msg: string) => A\nbuiltin difference : (<-tables: [T], ?nonNegative: bool, ?columns: [string], ?keepFirst: bool) => [R] where T: Record, R: Record\nbuiltin distinct : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin drop : (<-tables: [A], ?fn: (column: string) => bool, ?columns: [string]) => [B] where A: Record, B: Record\nbuiltin duplicate : (<-tables: [A], column: string, as: string) => [B] where A: Record, B: Record\nbuiltin elapsed : (<-tables: [A], ?unit: duration, ?timeColumn: string, ?columnName: string) => [B] where A: Record, B: Record\nbuiltin exponentialMovingAverage : (<-tables: [{B with _value: A}], n: int) => [{B with _value: A}] where A: Numeric\nbuiltin fill : (<-tables: [A], ?column: string, ?value: B, ?usePrevious: bool) => [C] where A: Record, C: Record\nbuiltin filter : (<-tables: [A], fn: (r: A) => bool, ?onEmpty: string) => [A] where A: Record\nbuiltin first : (<-tables: [A], ?column: string) => [A] where A: Record\nbuiltin group : (<-tables: [A], ?mode: string, ?columns: [string]) => [A] where A: Record\nbuiltin histogram : (\n    <-tables: [A],\n    ?column: string,\n    ?upperBoundColumn: string,\n    ?countColumn: string,\n    bins: [float],\n    ?normalize: bool,\n) => [B] where\n    A: Record,\n    B: Record\n\nbuiltin histogramQuantile : (\n    <-tables: [A],\n    ?quantile: float,\n    ?countColumn: string,\n    ?upperBoundColumn: string,\n    ?valueColumn: string,\n    ?minValue: float,\n) => [B] where\n    A: Record,\n    B: Record\n\nbuiltin holtWinters : (\n    <-tables: [A],\n    n: int,\n    interval: duration,\n    ?withFit: bool,\n    ?column: string,\n    ?timeColumn: string,\n    ?seasonality: int,\n) => [B] where\n    A: Record,\n    B: Record\n\nbuiltin hourSelection : (<-tables: [A], start: int, stop: int, ?timeColumn: string) => [A] where A: Record\nbuiltin integral : (\n    <-tables: [A],\n    ?unit: duration,\n    ?timeColumn: string,\n    ?column: string,\n    ?interpolate: string,\n) => [B] where\n    A: Record,\n    B: Record\n\nbuiltin join : (<-tables: A, ?method: string, ?on: [string]) => [B] where A: Record, B: Record\nbuiltin kaufmansAMA : (<-tables: [A], n: int, ?column: string) => [B] where A: Record, B: Record\nbuiltin keep : (<-tables: [A], ?columns: [string], ?fn: (column: string) => bool) => [B] where A: Record, B: Record\nbuiltin keyValues : (<-tables: [A], ?keyColumns: [string]) => [{C with _key: string, _value: B}] where A: Record, C: Record\nbuiltin keys : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin last : (<-tables: [A], ?column: string) => [A] where A: Record\nbuiltin limit : (<-tables: [A], n: int, ?offset: int) => [A]\nbuiltin map : (<-tables: [A], fn: (r: A) => B, ?mergeKey: bool) => [B]\nbuiltin max : (<-tables: [A], ?column: string) => [A] where A: Record\nbuiltin mean : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin min : (<-tables: [A], ?column: string) => [A] where A: Record\nbuiltin mode : (<-tables: [A], ?column: string) => [{C with _value: B}] where A: Record, C: Record\nbuiltin movingAverage : (<-tables: [{B with _value: A}], n: int) => [{B with _value: float}] where A: Numeric\nbuiltin quantile : (\n    <-tables: [A],\n    ?column: string,\n    q: float,\n    ?compression: float,\n    ?method: string,\n) => [A] where\n    A: Record\n\nbuiltin pivot : (<-tables: [A], rowKey: [string], columnKey: [string], valueColumn: string) => [B] where A: Record, B: Record\nbuiltin range : (\n    <-tables: [{A with _time: time}],\n    start: B,\n    ?stop: C,\n) => [{A with\n    _time: time,\n    _start: time,\n    _stop: time,\n}]\n\nbuiltin reduce : (<-tables: [A], fn: (r: A, accumulator: B) => B, identity: B) => [C] where A: Record, B: Record, C: Record\nbuiltin relativeStrengthIndex : (<-tables: [A], n: int, ?columns: [string]) => [B] where A: Record, B: Record\nbuiltin rename : (<-tables: [A], ?fn: (column: string) => string, ?columns: B) => [C] where A: Record, B: Record, C: Record\nbuiltin sample : (<-tables: [A], n: int, ?pos: int, ?column: string) => [A] where A: Record\nbuiltin set : (<-tables: [A], key: string, value: string) => [A] where A: Record\nbuiltin tail : (<-tables: [A], n: int, ?offset: int) => [A]\nbuiltin timeShift : (<-tables: [A], duration: duration, ?columns: [string]) => [A]\nbuiltin skew : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin spread : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin sort : (<-tables: [A], ?columns: [string], ?desc: bool) => [A] where A: Record\nbuiltin stateTracking : (\n    <-tables: [A],\n    fn: (r: A) => bool,\n    ?countColumn: string,\n    ?durationColumn: string,\n    ?durationUnit: duration,\n    ?timeColumn: string,\n) => [B] where\n    A: Record,\n    B: Record\n\nbuiltin stddev : (<-tables: [A], ?column: string, ?mode: string) => [B] where A: Record, B: Record\nbuiltin sum : (<-tables: [A], ?column: string) => [B] where A: Record, B: Record\nbuiltin tripleExponentialDerivative : (<-tables: [{B with _value: A}], n: int) => [{B with _value: float}] where A: Numeric, B: Record\nbuiltin union : (tables: [[A]]) => [A] where A: Record\nbuiltin unique : (<-tables: [A], ?column: string) => [A] where A: Record\nbuiltin window : (\n    <-tables: [A],\n    ?every: duration,\n    ?period: duration,\n    ?offset: duration,\n    ?timeColumn: string,\n    ?startColumn: string,\n    ?stopColumn: string,\n    ?createEmpty: bool,\n) => [B] where\n    A: Record,\n    B: Record\n\nbuiltin yield : (<-tables: [A], ?name: string) => [A] where A: Record\n\n// stream/table index functions\nbuiltin tableFind : (<-tables: [A], fn: (key: B) => bool) => [A] where A: Record, B: Record\nbuiltin getColumn : (<-table: [A], column: string) => [B] where A: Record\nbuiltin getRecord : (<-table: [A], idx: int) => A where A: Record\nbuiltin findColumn : (<-tables: [A], fn: (key: B) => bool, column: string) => [C] where A: Record, B: Record\nbuiltin findRecord : (<-tables: [A], fn: (key: B) => bool, idx: int) => A where A: Record, B: Record\n\n// type conversion functions\nbuiltin bool : (v: A) => bool\nbuiltin bytes : (v: A) => bytes\nbuiltin duration : (v: A) => duration\nbuiltin float : (v: A) => float\nbuiltin int : (v: A) => int\nbuiltin string : (v: A) => string\nbuiltin time : (v: A) => time\nbuiltin uint : (v: A) => uint\n\n// contains function\nbuiltin contains : (value: A, set: [A]) => bool where A: Nullable\n\n// other builtins\nbuiltin inf : duration\nbuiltin length : (arr: [A]) => int\nbuiltin linearBins : (start: float, width: float, count: int, ?infinity: bool) => [float]\nbuiltin logarithmicBins : (start: float, factor: float, count: int, ?infinity: bool) => [float]\n\n// die returns a fatal error from within a flux script\nbuiltin die : (msg: string) => A\n\n// Time weighted average where values at the beginning and end of the range are linearly interpolated.\ntimeWeightedAvg = (tables=<-, unit) => tables\n    |> integral(unit: unit, interpolate: \"linear\")\n    |> map(fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))}))\n\n// covariance function with automatic join\ncov = (x, y, on, pearsonr=false) => join(\n    tables: {x: x, y: y},\n    on: on,\n)\n    |> covariance(pearsonr: pearsonr, columns: [\"_value_x\", \"_value_y\"])\npearsonr = (x, y, on) => cov(x: x, y: y, on: on, pearsonr: true)\n\n_fillEmpty = (tables=<-, createEmpty) => if createEmpty then\n    tables\n        |> table.fill()\nelse\n    tables\n\n// aggregateWindow applies an aggregate function to fixed windows of time.\n// The procedure is to window the data, perform an aggregate operation,\n// and then undo the windowing to produce an output table for every input table.\naggregateWindow = (\n        every,\n        fn,\n        offset=0s,\n        column=\"_value\",\n        timeSrc=\"_stop\",\n        timeDst=\"_time\",\n        createEmpty=true,\n        tables=<-,\n) => tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)\n    |> _fillEmpty(createEmpty: createEmpty)\n    |> duplicate(column: timeSrc, as: timeDst)\n    |> window(every: inf, timeColumn: timeDst)\n\n// Increase returns the total non-negative difference between values in a table.\n// A main usage case is tracking changes in counter values which may wrap over time when they hit\n// a threshold or are reset. In the case of a wrap/reset,\n// we can assume that the absolute delta between two points will be at least their non-negative difference.\nincrease = (tables=<-, columns=[\"_value\"]) => tables\n    |> difference(nonNegative: true, columns: columns)\n    |> cumulativeSum(columns: columns)\n\n// median returns the 50th percentile.\nmedian = (method=\"estimate_tdigest\", compression=0.0, column=\"_value\", tables=<-) => tables\n    |> quantile(q: 0.5, method: method, compression: compression, column: column)\n\n// stateCount computes the number of consecutive records in a given state.\n// The state is defined via the function fn. For each consecutive point for\n// which the expression evaluates as true, the state count will be incremented\n// When a point evaluates as false, the state count is reset.\n//\n// The state count will be added as an additional column to each record. If the\n// expression evaluates as false, the value will be -1. If the expression\n// generates an error during evaluation, the point is discarded, and does not\n// affect the state count.\nstateCount = (fn, column=\"stateCount\", tables=<-) => tables\n    |> stateTracking(countColumn: column, fn: fn)\n\n// stateDuration computes the duration of a given state.\n// The state is defined via the function fn. For each consecutive point for\n// which the expression evaluates as true, the state duration will be\n// incremented by the duration between points. When a point evaluates as false,\n// the state duration is reset.\n//\n// The state duration will be added as an additional column to each record. If the\n// expression evaluates as false, the value will be -1. If the expression\n// generates an error during evaluation, the point is discarded, and does not\n// affect the state duration.\n//\n// Note that as the first point in the given state has no previous point, its\n// state duration will be 0.\n//\n// The duration is represented as an integer in the units specified.\nstateDuration = (\n        fn,\n        column=\"stateDuration\",\n        timeColumn=\"_time\",\n        unit=1s,\n        tables=<-,\n) => tables\n    |> stateTracking(durationColumn: column, timeColumn: timeColumn, fn: fn, durationUnit: unit)\n\n// _sortLimit is a helper function, which sorts and limits a table.\n_sortLimit = (n, desc, columns=[\"_value\"], tables=<-) => tables\n    |> sort(columns: columns, desc: desc)\n    |> limit(n: n)\n\n// top sorts a table by columns and keeps only the top n records.\ntop = (n, columns=[\"_value\"], tables=<-) => tables\n    |> _sortLimit(n: n, columns: columns, desc: true)\n\n// top sorts a table by columns and keeps only the bottom n records.\nbottom = (n, columns=[\"_value\"], tables=<-) => tables\n    |> _sortLimit(n: n, columns: columns, desc: false)\n\n// _highestOrLowest is a helper function, which reduces all groups into a single group by specific tags and a reducer function,\n// then it selects the highest or lowest records based on the column and the _sortLimit function.\n// The default reducer assumes no reducing needs to be performed.\n_highestOrLowest = (\n        n,\n        _sortLimit,\n        reducer,\n        column=\"_value\",\n        groupColumns=[],\n        tables=<-,\n) => tables\n    |> group(columns: groupColumns)\n    |> reducer()\n    |> group(columns: [])\n    |> _sortLimit(n: n, columns: [column])\n\n// highestMax returns the top N records from all groups using the maximum of each group.\nhighestMax = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n        reducer: (tables=<-) => tables |> max(column: column),\n        _sortLimit: top,\n    )\n\n// highestAverage returns the top N records from all groups using the average of each group.\nhighestAverage = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        reducer: (tables=<-) => tables |> mean(column: column),\n        _sortLimit: top,\n    )\n\n// highestCurrent returns the top N records from all groups using the last value of each group.\nhighestCurrent = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        reducer: (tables=<-) => tables |> last(column: column),\n        _sortLimit: top,\n    )\n\n// lowestMin returns the bottom N records from all groups using the minimum of each group.\nlowestMin = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n        reducer: (tables=<-) => tables |> min(column: column),\n        _sortLimit: bottom,\n    )\n\n// lowestAverage returns the bottom N records from all groups using the average of each group.\nlowestAverage = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        reducer: (tables=<-) => tables |> mean(column: column),\n        _sortLimit: bottom,\n    )\n\n// lowestCurrent returns the bottom N records from all groups using the last value of each group.\nlowestCurrent = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        reducer: (tables=<-) => tables |> last(column: column),\n        _sortLimit: bottom,\n    )\n\n// timedMovingAverage constructs a simple moving average over windows of 'period' duration\n// eg: A 5 year moving average would be called as such:\n//    movingAverage(1y, 5y)\ntimedMovingAverage = (every, period, column=\"_value\", tables=<-) => tables\n    |> window(every: every, period: period)\n    |> mean(column: column)\n    |> duplicate(column: \"_stop\", as: \"_time\")\n    |> window(every: inf)\n\n// Double Exponential Moving Average computes the double exponential moving averages of the `_value` column.\n// eg: A 5 point double exponential moving average would be called as such:\n// from(bucket: \"telegraf/autogen\"):\n//    |> range(start: -7d)\n//    |> doubleEMA(n: 5)\ndoubleEMA = (n, tables=<-) => tables\n    |> exponentialMovingAverage(n: n)\n    |> duplicate(column: \"_value\", as: \"__ema\")\n    |> exponentialMovingAverage(n: n)\n    |> map(fn: (r) => ({r with _value: 2.0 * r.__ema - r._value}))\n    |> drop(columns: [\"__ema\"])\n\n// Triple Exponential Moving Average computes the triple exponential moving averages of the `_value` column.\n// eg: A 5 point triple exponential moving average would be called as such:\n// from(bucket: \"telegraf/autogen\"):\n//    |> range(start: -7d)\n//    |> tripleEMA(n: 5)\ntripleEMA = (n, tables=<-) => tables\n    |> exponentialMovingAverage(n: n)\n    |> duplicate(column: \"_value\", as: \"__ema1\")\n    |> exponentialMovingAverage(n: n)\n    |> duplicate(column: \"_value\", as: \"__ema2\")\n    |> exponentialMovingAverage(n: n)\n    |> map(fn: (r) => ({r with _value: 3.0 * r.__ema1 - 3.0 * r.__ema2 + r._value}))\n    |> drop(columns: [\"__ema1\", \"__ema2\"])\n\n// truncateTimeColumn takes in a time column t and a Duration unit and truncates each value of t to the given unit via map\n// Change from _time to timeColumn once Flux Issue 1122 is resolved\ntruncateTimeColumn = (timeColumn=\"_time\", unit, tables=<-) => tables\n    |> map(fn: (r) => ({r with _time: date.truncate(t: r._time, unit: unit)}))\n\n// kaufmansER computes Kaufman's Efficiency Ratios of the `_value` column\nkaufmansER = (n, tables=<-) => tables\n    |> chandeMomentumOscillator(n: n)\n    |> map(fn: (r) => ({r with _value: math.abs(x: r._value) / 100.0}))\ntoString = (tables=<-) => tables |> map(fn: (r) => ({r with _value: string(v: r._value)}))\ntoInt = (tables=<-) => tables |> map(fn: (r) => ({r with _value: int(v: r._value)}))\ntoUInt = (tables=<-) => tables |> map(fn: (r) => ({r with _value: uint(v: r._value)}))\ntoFloat = (tables=<-) => tables |> map(fn: (r) => ({r with _value: float(v: r._value)}))\ntoBool = (tables=<-) => tables |> map(fn: (r) => ({r with _value: bool(v: r._value)}))\ntoTime = (tables=<-) => tables |> map(fn: (r) => ({r with _value: time(v: r._value)}))\n\n// today returns the now() timestamp truncated to the day unit\ntoday = () => date.truncate(t: now(), unit: 1d)",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   12,
						},
						File:   "universe.flux",
						Source: "now = system.time",
						Start: ast.Position{
							Column: 8,
							Line:   12,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   12,
							},
							File:   "universe.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   12,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.MemberExpression{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   12,
							},
							File:   "universe.flux",
							Source: "system.time",
							Start: ast.Position{
								Column: 14,
								Line:   12,
							},
						},
					},
					Lbrack: nil,
					Object: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   12,
								},
								File:   "universe.flux",
								Source: "system",
								Start: ast.Position{
									Column: 14,
									Line:   12,
								},
							},
						},
						Name: "system",
					},
					Property: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   12,
								},
								File:   "universe.flux",
								Source: "time",
								Start: ast.Position{
									Column: 21,
									Line:   12,
								},
							},
						},
						Name: "time",
					},
					Rbrack: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// now is a function option whose default behaviour is to return the current system time\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   12,
					},
					File:   "universe.flux",
					Source: "option now = system.time",
					Start: ast.Position{
						Column: 1,
						Line:   12,
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Transformation functions\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 33,
						Line:   15,
					},
					File:   "universe.flux",
					Source: "builtin chandeMomentumOscillator",
					Start: ast.Position{
						Column: 1,
						Line:   15,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   15,
						},
						File:   "universe.flux",
						Source: "chandeMomentumOscillator",
						Start: ast.Position{
							Column: 9,
							Line:   15,
						},
					},
				},
				Name: "chandeMomentumOscillator",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 113,
							Line:   15,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], n: int, ?columns: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 36,
							Line:   15,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   15,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 93,
								Line:   15,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   15,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 96,
									Line:   15,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   15,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 93,
									Line:   15,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 113,
								Line:   15,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 104,
								Line:   15,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 113,
									Line:   15,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 107,
									Line:   15,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   15,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 104,
									Line:   15,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   15,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], n: int, ?columns: [string]) => [B]",
							Start: ast.Position{
								Column: 36,
								Line:   15,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   15,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 37,
									Line:   15,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   15,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 39,
										Line:   15,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   15,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 47,
										Line:   15,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   15,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 48,
											Line:   15,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   15,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 48,
												Line:   15,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   15,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 52,
									Line:   15,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   15,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 52,
										Line:   15,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   15,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 55,
										Line:   15,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   15,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 55,
											Line:   15,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   15,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 60,
									Line:   15,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   15,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 61,
										Line:   15,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   15,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 70,
										Line:   15,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   15,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 71,
											Line:   15,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   15,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 71,
												Line:   15,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   15,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 83,
									Line:   15,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 85,
										Line:   15,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 84,
										Line:   15,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   15,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 84,
											Line:   15,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   16,
					},
					File:   "universe.flux",
					Source: "builtin columns",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   16,
						},
						File:   "universe.flux",
						Source: "columns",
						Start: ast.Position{
							Column: 9,
							Line:   16,
						},
					},
				},
				Name: "columns",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 85,
							Line:   16,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 19,
							Line:   16,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 74,
								Line:   16,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 65,
								Line:   16,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   16,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 68,
									Line:   16,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   16,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 65,
									Line:   16,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 85,
								Line:   16,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 76,
								Line:   16,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   16,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 79,
									Line:   16,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 77,
									Line:   16,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 76,
									Line:   16,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   16,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 19,
								Line:   16,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   16,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 20,
									Line:   16,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   16,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 22,
										Line:   16,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   16,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 30,
										Line:   16,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   16,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 31,
											Line:   16,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   16,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 31,
												Line:   16,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   16,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 35,
									Line:   16,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   16,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 36,
										Line:   16,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   16,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 44,
										Line:   16,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   16,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 44,
											Line:   16,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   16,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 55,
									Line:   16,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   16,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 56,
										Line:   16,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   16,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 56,
											Line:   16,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   17,
					},
					File:   "universe.flux",
					Source: "builtin count",
					Start: ast.Position{
						Column: 1,
						Line:   17,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   17,
						},
						File:   "universe.flux",
						Source: "count",
						Start: ast.Position{
							Column: 9,
							Line:   17,
						},
					},
				},
				Name: "count",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 83,
							Line:   17,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 17,
							Line:   17,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   17,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 63,
								Line:   17,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   17,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 66,
									Line:   17,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   17,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 63,
									Line:   17,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 83,
								Line:   17,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 74,
								Line:   17,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   17,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 77,
									Line:   17,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   17,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 74,
									Line:   17,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   17,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 17,
								Line:   17,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   17,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   17,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   17,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   17,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   17,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   17,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   17,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   17,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   17,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   17,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   17,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 33,
									Line:   17,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   17,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 34,
										Line:   17,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   17,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 42,
										Line:   17,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   17,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 42,
											Line:   17,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   17,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 53,
									Line:   17,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   17,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 54,
										Line:   17,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   17,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 54,
											Line:   17,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   18,
					},
					File:   "universe.flux",
					Source: "builtin covariance",
					Start: ast.Position{
						Column: 1,
						Line:   18,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   18,
						},
						File:   "universe.flux",
						Source: "covariance",
						Start: ast.Position{
							Column: 9,
							Line:   18,
						},
					},
				},
				Name: "covariance",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 126,
							Line:   18,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?pearsonr: bool, ?valueDst: string, columns: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 22,
							Line:   18,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 115,
								Line:   18,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 106,
								Line:   18,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 115,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 109,
									Line:   18,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 107,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 106,
									Line:   18,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 126,
								Line:   18,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 117,
								Line:   18,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 126,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 120,
									Line:   18,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 118,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 117,
									Line:   18,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   18,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?pearsonr: bool, ?valueDst: string, columns: [string]) => [B]",
							Start: ast.Position{
								Column: 22,
								Line:   18,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 23,
									Line:   18,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   18,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 33,
										Line:   18,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   18,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 34,
											Line:   18,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   18,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 34,
												Line:   18,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "?pearsonr: bool",
								Start: ast.Position{
									Column: 38,
									Line:   18,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "pearsonr",
									Start: ast.Position{
										Column: 39,
										Line:   18,
									},
								},
							},
							Name: "pearsonr",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 49,
										Line:   18,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   18,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 49,
											Line:   18,
										},
									},
								},
								Name: "bool",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "?valueDst: string",
								Start: ast.Position{
									Column: 55,
									Line:   18,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "valueDst",
									Start: ast.Position{
										Column: 56,
										Line:   18,
									},
								},
							},
							Name: "valueDst",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 66,
										Line:   18,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   18,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 66,
											Line:   18,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "columns: [string]",
								Start: ast.Position{
									Column: 74,
									Line:   18,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 74,
										Line:   18,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 91,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 83,
										Line:   18,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 90,
											Line:   18,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 84,
											Line:   18,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 90,
												Line:   18,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 84,
												Line:   18,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   18,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 96,
									Line:   18,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 98,
										Line:   18,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 97,
										Line:   18,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   18,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 97,
											Line:   18,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   19,
					},
					File:   "universe.flux",
					Source: "builtin cumulativeSum",
					Start: ast.Position{
						Column: 1,
						Line:   19,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   19,
						},
						File:   "universe.flux",
						Source: "cumulativeSum",
						Start: ast.Position{
							Column: 9,
							Line:   19,
						},
					},
				},
				Name: "cumulativeSum",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 94,
							Line:   19,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?columns: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 25,
							Line:   19,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 83,
								Line:   19,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 74,
								Line:   19,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 77,
									Line:   19,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 74,
									Line:   19,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 94,
								Line:   19,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 85,
								Line:   19,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 88,
									Line:   19,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 85,
									Line:   19,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 67,
								Line:   19,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?columns: [string]) => [B]",
							Start: ast.Position{
								Column: 25,
								Line:   19,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 26,
									Line:   19,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   19,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 28,
										Line:   19,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   19,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 36,
										Line:   19,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   19,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 37,
											Line:   19,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   19,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 37,
												Line:   19,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 41,
									Line:   19,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   19,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 42,
										Line:   19,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   19,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 51,
										Line:   19,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   19,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 52,
											Line:   19,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   19,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 52,
												Line:   19,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   19,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 64,
									Line:   19,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   19,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 65,
										Line:   19,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   19,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 65,
											Line:   19,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   20,
					},
					File:   "universe.flux",
					Source: "builtin derivative",
					Start: ast.Position{
						Column: 1,
						Line:   20,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   20,
						},
						File:   "universe.flux",
						Source: "derivative",
						Start: ast.Position{
							Column: 9,
							Line:   20,
						},
					},
				},
				Name: "derivative",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   28,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    ?unit: duration,\n    ?nonNegative: bool,\n    ?columns: [string],\n    ?timeColumn: string,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 22,
							Line:   20,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   27,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   27,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   27,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   27,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   27,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   27,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   28,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   28,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   28,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   28,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   28,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   28,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   26,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    ?unit: duration,\n    ?nonNegative: bool,\n    ?columns: [string],\n    ?timeColumn: string,\n) => [B]",
							Start: ast.Position{
								Column: 22,
								Line:   20,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   21,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   21,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   21,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   21,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   21,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   21,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   21,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   21,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   21,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   22,
								},
								File:   "universe.flux",
								Source: "?unit: duration",
								Start: ast.Position{
									Column: 5,
									Line:   22,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   22,
									},
									File:   "universe.flux",
									Source: "unit",
									Start: ast.Position{
										Column: 6,
										Line:   22,
									},
								},
							},
							Name: "unit",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   22,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 12,
										Line:   22,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   22,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 12,
											Line:   22,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   23,
								},
								File:   "universe.flux",
								Source: "?nonNegative: bool",
								Start: ast.Position{
									Column: 5,
									Line:   23,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   23,
									},
									File:   "universe.flux",
									Source: "nonNegative",
									Start: ast.Position{
										Column: 6,
										Line:   23,
									},
								},
							},
							Name: "nonNegative",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   23,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 19,
										Line:   23,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   23,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 19,
											Line:   23,
										},
									},
								},
								Name: "bool",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   24,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 5,
									Line:   24,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   24,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 6,
										Line:   24,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   24,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 15,
										Line:   24,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   24,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 16,
											Line:   24,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   24,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 16,
												Line:   24,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   25,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   25,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   25,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 6,
										Line:   25,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   25,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   25,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   25,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   25,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   26,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   26,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   26,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   26,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   26,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   26,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   30,
					},
					File:   "universe.flux",
					Source: "builtin die",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   30,
						},
						File:   "universe.flux",
						Source: "die",
						Start: ast.Position{
							Column: 9,
							Line:   30,
						},
					},
				},
				Name: "die",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   30,
						},
						File:   "universe.flux",
						Source: "(msg: string) => A",
						Start: ast.Position{
							Column: 15,
							Line:   30,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   30,
							},
							File:   "universe.flux",
							Source: "(msg: string) => A",
							Start: ast.Position{
								Column: 15,
								Line:   30,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   30,
								},
								File:   "universe.flux",
								Source: "msg: string",
								Start: ast.Position{
									Column: 16,
									Line:   30,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   30,
									},
									File:   "universe.flux",
									Source: "msg",
									Start: ast.Position{
										Column: 16,
										Line:   30,
									},
								},
							},
							Name: "msg",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   30,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 21,
										Line:   30,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   30,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 21,
											Line:   30,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.TvarType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   30,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 32,
									Line:   30,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   30,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 32,
										Line:   30,
									},
								},
							},
							Name: "A",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   31,
					},
					File:   "universe.flux",
					Source: "builtin difference",
					Start: ast.Position{
						Column: 1,
						Line:   31,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   31,
						},
						File:   "universe.flux",
						Source: "difference",
						Start: ast.Position{
							Column: 9,
							Line:   31,
						},
					},
				},
				Name: "difference",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 129,
							Line:   31,
						},
						File:   "universe.flux",
						Source: "(<-tables: [T], ?nonNegative: bool, ?columns: [string], ?keepFirst: bool) => [R] where T: Record, R: Record",
						Start: ast.Position{
							Column: 22,
							Line:   31,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 118,
								Line:   31,
							},
							File:   "universe.flux",
							Source: "T: Record",
							Start: ast.Position{
								Column: 109,
								Line:   31,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 118,
									Line:   31,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 112,
									Line:   31,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 110,
									Line:   31,
								},
								File:   "universe.flux",
								Source: "T",
								Start: ast.Position{
									Column: 109,
									Line:   31,
								},
							},
						},
						Name: "T",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 129,
								Line:   31,
							},
							File:   "universe.flux",
							Source: "R: Record",
							Start: ast.Position{
								Column: 120,
								Line:   31,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 129,
									Line:   31,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 123,
									Line:   31,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 121,
									Line:   31,
								},
								File:   "universe.flux",
								Source: "R",
								Start: ast.Position{
									Column: 120,
									Line:   31,
								},
							},
						},
						Name: "R",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   31,
							},
							File:   "universe.flux",
							Source: "(<-tables: [T], ?nonNegative: bool, ?columns: [string], ?keepFirst: bool) => [R]",
							Start: ast.Position{
								Column: 22,
								Line:   31,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   31,
								},
								File:   "universe.flux",
								Source: "<-tables: [T]",
								Start: ast.Position{
									Column: 23,
									Line:   31,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   31,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   31,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   31,
									},
									File:   "universe.flux",
									Source: "[T]",
									Start: ast.Position{
										Column: 33,
										Line:   31,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   31,
										},
										File:   "universe.flux",
										Source: "T",
										Start: ast.Position{
											Column: 34,
											Line:   31,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   31,
											},
											File:   "universe.flux",
											Source: "T",
											Start: ast.Position{
												Column: 34,
												Line:   31,
											},
										},
									},
									Name: "T",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   31,
								},
								File:   "universe.flux",
								Source: "?nonNegative: bool",
								Start: ast.Position{
									Column: 38,
									Line:   31,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   31,
									},
									File:   "universe.flux",
									Source: "nonNegative",
									Start: ast.Position{
										Column: 39,
										Line:   31,
									},
								},
							},
							Name: "nonNegative",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   31,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 52,
										Line:   31,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 56,
											Line:   31,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 52,
											Line:   31,
										},
									},
								},
								Name: "bool",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   31,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 58,
									Line:   31,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   31,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 59,
										Line:   31,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 76,
										Line:   31,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 68,
										Line:   31,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   31,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 69,
											Line:   31,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 75,
												Line:   31,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 69,
												Line:   31,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   31,
								},
								File:   "universe.flux",
								Source: "?keepFirst: bool",
								Start: ast.Position{
									Column: 78,
									Line:   31,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   31,
									},
									File:   "universe.flux",
									Source: "keepFirst",
									Start: ast.Position{
										Column: 79,
										Line:   31,
									},
								},
							},
							Name: "keepFirst",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 94,
										Line:   31,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 90,
										Line:   31,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 94,
											Line:   31,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 90,
											Line:   31,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   31,
								},
								File:   "universe.flux",
								Source: "[R]",
								Start: ast.Position{
									Column: 99,
									Line:   31,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 101,
										Line:   31,
									},
									File:   "universe.flux",
									Source: "R",
									Start: ast.Position{
										Column: 100,
										Line:   31,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 101,
											Line:   31,
										},
										File:   "universe.flux",
										Source: "R",
										Start: ast.Position{
											Column: 100,
											Line:   31,
										},
									},
								},
								Name: "R",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   32,
					},
					File:   "universe.flux",
					Source: "builtin distinct",
					Start: ast.Position{
						Column: 1,
						Line:   32,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   32,
						},
						File:   "universe.flux",
						Source: "distinct",
						Start: ast.Position{
							Column: 9,
							Line:   32,
						},
					},
				},
				Name: "distinct",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 86,
							Line:   32,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 20,
							Line:   32,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 75,
								Line:   32,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 66,
								Line:   32,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   32,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 69,
									Line:   32,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   32,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 66,
									Line:   32,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   32,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 77,
								Line:   32,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   32,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 80,
									Line:   32,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   32,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 77,
									Line:   32,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   32,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 20,
								Line:   32,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   32,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 21,
									Line:   32,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   32,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 23,
										Line:   32,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   32,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 31,
										Line:   32,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   32,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 32,
											Line:   32,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   32,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 32,
												Line:   32,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   32,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 36,
									Line:   32,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   32,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 37,
										Line:   32,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   32,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 45,
										Line:   32,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   32,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 45,
											Line:   32,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   32,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 56,
									Line:   32,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   32,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 57,
										Line:   32,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   32,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 57,
											Line:   32,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   33,
					},
					File:   "universe.flux",
					Source: "builtin drop",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   33,
						},
						File:   "universe.flux",
						Source: "drop",
						Start: ast.Position{
							Column: 9,
							Line:   33,
						},
					},
				},
				Name: "drop",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 116,
							Line:   33,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?fn: (column: string) => bool, ?columns: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 16,
							Line:   33,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 105,
								Line:   33,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 96,
								Line:   33,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 99,
									Line:   33,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 96,
									Line:   33,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 116,
								Line:   33,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 107,
								Line:   33,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 116,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 110,
									Line:   33,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 108,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 107,
									Line:   33,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 89,
								Line:   33,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?fn: (column: string) => bool, ?columns: [string]) => [B]",
							Start: ast.Position{
								Column: 16,
								Line:   33,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   33,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   33,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   33,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   33,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   33,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   33,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   33,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "?fn: (column: string) => bool",
								Start: ast.Position{
									Column: 32,
									Line:   33,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 33,
										Line:   33,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 61,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "(column: string) => bool",
									Start: ast.Position{
										Column: 37,
										Line:   33,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   33,
										},
										File:   "universe.flux",
										Source: "column: string",
										Start: ast.Position{
											Column: 38,
											Line:   33,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   33,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 38,
												Line:   33,
											},
										},
									},
									Name: "column",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   33,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 46,
												Line:   33,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 52,
													Line:   33,
												},
												File:   "universe.flux",
												Source: "string",
												Start: ast.Position{
													Column: 46,
													Line:   33,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   33,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 57,
											Line:   33,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   33,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 57,
												Line:   33,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 63,
									Line:   33,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 64,
										Line:   33,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 73,
										Line:   33,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   33,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 74,
											Line:   33,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   33,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 74,
												Line:   33,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   33,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 86,
									Line:   33,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   33,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 87,
										Line:   33,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   33,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 87,
											Line:   33,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   34,
					},
					File:   "universe.flux",
					Source: "builtin duplicate",
					Start: ast.Position{
						Column: 1,
						Line:   34,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   34,
						},
						File:   "universe.flux",
						Source: "duplicate",
						Start: ast.Position{
							Column: 9,
							Line:   34,
						},
					},
				},
				Name: "duplicate",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 98,
							Line:   34,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], column: string, as: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 21,
							Line:   34,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 87,
								Line:   34,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 78,
								Line:   34,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 87,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 81,
									Line:   34,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 79,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 78,
									Line:   34,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 98,
								Line:   34,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 89,
								Line:   34,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 98,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 92,
									Line:   34,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 89,
									Line:   34,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   34,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], column: string, as: string) => [B]",
							Start: ast.Position{
								Column: 21,
								Line:   34,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 22,
									Line:   34,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 24,
										Line:   34,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 32,
										Line:   34,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   34,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 33,
											Line:   34,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   34,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 33,
												Line:   34,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "column: string",
								Start: ast.Position{
									Column: 37,
									Line:   34,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 37,
										Line:   34,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 45,
										Line:   34,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   34,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 45,
											Line:   34,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "as: string",
								Start: ast.Position{
									Column: 53,
									Line:   34,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "as",
									Start: ast.Position{
										Column: 53,
										Line:   34,
									},
								},
							},
							Name: "as",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 57,
										Line:   34,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   34,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 57,
											Line:   34,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   34,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 68,
									Line:   34,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   34,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 69,
										Line:   34,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   34,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 69,
											Line:   34,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   35,
					},
					File:   "universe.flux",
					Source: "builtin elapsed",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   35,
						},
						File:   "universe.flux",
						Source: "elapsed",
						Start: ast.Position{
							Column: 9,
							Line:   35,
						},
					},
				},
				Name: "elapsed",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 127,
							Line:   35,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?unit: duration, ?timeColumn: string, ?columnName: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 19,
							Line:   35,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 116,
								Line:   35,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 107,
								Line:   35,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 116,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 110,
									Line:   35,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 108,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 107,
									Line:   35,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 127,
								Line:   35,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 118,
								Line:   35,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 127,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 121,
									Line:   35,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 119,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 118,
									Line:   35,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 100,
								Line:   35,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?unit: duration, ?timeColumn: string, ?columnName: string) => [B]",
							Start: ast.Position{
								Column: 19,
								Line:   35,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 20,
									Line:   35,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 22,
										Line:   35,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 30,
										Line:   35,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   35,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 31,
											Line:   35,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   35,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 31,
												Line:   35,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "?unit: duration",
								Start: ast.Position{
									Column: 35,
									Line:   35,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "unit",
									Start: ast.Position{
										Column: 36,
										Line:   35,
									},
								},
							},
							Name: "unit",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 42,
										Line:   35,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   35,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 42,
											Line:   35,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 52,
									Line:   35,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 53,
										Line:   35,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 65,
										Line:   35,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   35,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 65,
											Line:   35,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 92,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "?columnName: string",
								Start: ast.Position{
									Column: 73,
									Line:   35,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "columnName",
									Start: ast.Position{
										Column: 74,
										Line:   35,
									},
								},
							},
							Name: "columnName",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 92,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 86,
										Line:   35,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 92,
											Line:   35,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 86,
											Line:   35,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   35,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 97,
									Line:   35,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   35,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 98,
										Line:   35,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 99,
											Line:   35,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 98,
											Line:   35,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 33,
						Line:   36,
					},
					File:   "universe.flux",
					Source: "builtin exponentialMovingAverage",
					Start: ast.Position{
						Column: 1,
						Line:   36,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   36,
						},
						File:   "universe.flux",
						Source: "exponentialMovingAverage",
						Start: ast.Position{
							Column: 9,
							Line:   36,
						},
					},
				},
				Name: "exponentialMovingAverage",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 117,
							Line:   36,
						},
						File:   "universe.flux",
						Source: "(<-tables: [{B with _value: A}], n: int) => [{B with _value: A}] where A: Numeric",
						Start: ast.Position{
							Column: 36,
							Line:   36,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 117,
								Line:   36,
							},
							File:   "universe.flux",
							Source: "A: Numeric",
							Start: ast.Position{
								Column: 107,
								Line:   36,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 117,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "Numeric",
								Start: ast.Position{
									Column: 110,
									Line:   36,
								},
							},
						},
						Name: "Numeric",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 108,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 107,
									Line:   36,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 100,
								Line:   36,
							},
							File:   "universe.flux",
							Source: "(<-tables: [{B with _value: A}], n: int) => [{B with _value: A}]",
							Start: ast.Position{
								Column: 36,
								Line:   36,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "<-tables: [{B with _value: A}]",
								Start: ast.Position{
									Column: 37,
									Line:   36,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 39,
										Line:   36,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "[{B with _value: A}]",
									Start: ast.Position{
										Column: 47,
										Line:   36,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   36,
										},
										File:   "universe.flux",
										Source: "{B with _value: A}",
										Start: ast.Position{
											Column: 48,
											Line:   36,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   36,
											},
											File:   "universe.flux",
											Source: "_value: A",
											Start: ast.Position{
												Column: 56,
												Line:   36,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 62,
													Line:   36,
												},
												File:   "universe.flux",
												Source: "_value",
												Start: ast.Position{
													Column: 56,
													Line:   36,
												},
											},
										},
										Name: "_value",
									},
									Ty: &ast.TvarType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   36,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 64,
													Line:   36,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 65,
														Line:   36,
													},
													File:   "universe.flux",
													Source: "A",
													Start: ast.Position{
														Column: 64,
														Line:   36,
													},
												},
											},
											Name: "A",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   36,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 49,
												Line:   36,
											},
										},
									},
									Name: "B",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 69,
									Line:   36,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 69,
										Line:   36,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 72,
										Line:   36,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   36,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 72,
											Line:   36,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   36,
								},
								File:   "universe.flux",
								Source: "[{B with _value: A}]",
								Start: ast.Position{
									Column: 80,
									Line:   36,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   36,
									},
									File:   "universe.flux",
									Source: "{B with _value: A}",
									Start: ast.Position{
										Column: 81,
										Line:   36,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   36,
										},
										File:   "universe.flux",
										Source: "_value: A",
										Start: ast.Position{
											Column: 89,
											Line:   36,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 95,
												Line:   36,
											},
											File:   "universe.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 89,
												Line:   36,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   36,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 97,
												Line:   36,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 98,
													Line:   36,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 97,
													Line:   36,
												},
											},
										},
										Name: "A",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 83,
											Line:   36,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 82,
											Line:   36,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   37,
					},
					File:   "universe.flux",
					Source: "builtin fill",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   37,
						},
						File:   "universe.flux",
						Source: "fill",
						Start: ast.Position{
							Column: 9,
							Line:   37,
						},
					},
				},
				Name: "fill",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 113,
							Line:   37,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string, ?value: B, ?usePrevious: bool) => [C] where A: Record, C: Record",
						Start: ast.Position{
							Column: 16,
							Line:   37,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   37,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 93,
								Line:   37,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 96,
									Line:   37,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 93,
									Line:   37,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 113,
								Line:   37,
							},
							File:   "universe.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 104,
								Line:   37,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 113,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 107,
									Line:   37,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "C",
								Start: ast.Position{
									Column: 104,
									Line:   37,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   37,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string, ?value: B, ?usePrevious: bool) => [C]",
							Start: ast.Position{
								Column: 16,
								Line:   37,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   37,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   37,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   37,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   37,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   37,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   37,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   37,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 32,
									Line:   37,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 33,
										Line:   37,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   37,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   37,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   37,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "?value: B",
								Start: ast.Position{
									Column: 49,
									Line:   37,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "value",
									Start: ast.Position{
										Column: 50,
										Line:   37,
									},
								},
							},
							Name: "value",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 57,
										Line:   37,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   37,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 57,
											Line:   37,
										},
									},
								},
								Name: "B",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "?usePrevious: bool",
								Start: ast.Position{
									Column: 60,
									Line:   37,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "usePrevious",
									Start: ast.Position{
										Column: 61,
										Line:   37,
									},
								},
							},
							Name: "usePrevious",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 74,
										Line:   37,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   37,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 74,
											Line:   37,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   37,
								},
								File:   "universe.flux",
								Source: "[C]",
								Start: ast.Position{
									Column: 83,
									Line:   37,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 85,
										Line:   37,
									},
									File:   "universe.flux",
									Source: "C",
									Start: ast.Position{
										Column: 84,
										Line:   37,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   37,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 84,
											Line:   37,
										},
									},
								},
								Name: "C",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   38,
					},
					File:   "universe.flux",
					Source: "builtin filter",
					Start: ast.Position{
						Column: 1,
						Line:   38,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   38,
						},
						File:   "universe.flux",
						Source: "filter",
						Start: ast.Position{
							Column: 9,
							Line:   38,
						},
					},
				},
				Name: "filter",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 94,
							Line:   38,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], fn: (r: A) => bool, ?onEmpty: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 18,
							Line:   38,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 94,
								Line:   38,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 85,
								Line:   38,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 88,
									Line:   38,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 85,
									Line:   38,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 78,
								Line:   38,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], fn: (r: A) => bool, ?onEmpty: string) => [A]",
							Start: ast.Position{
								Column: 18,
								Line:   38,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   38,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   38,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   38,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   38,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   38,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   38,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   38,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 52,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "fn: (r: A) => bool",
								Start: ast.Position{
									Column: 34,
									Line:   38,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 34,
										Line:   38,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 52,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "(r: A) => bool",
									Start: ast.Position{
										Column: 38,
										Line:   38,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   38,
										},
										File:   "universe.flux",
										Source: "r: A",
										Start: ast.Position{
											Column: 39,
											Line:   38,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   38,
											},
											File:   "universe.flux",
											Source: "r",
											Start: ast.Position{
												Column: 39,
												Line:   38,
											},
										},
									},
									Name: "r",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   38,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 42,
												Line:   38,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   38,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 42,
													Line:   38,
												},
											},
										},
										Name: "A",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   38,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 48,
											Line:   38,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   38,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 48,
												Line:   38,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "?onEmpty: string",
								Start: ast.Position{
									Column: 54,
									Line:   38,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "onEmpty",
									Start: ast.Position{
										Column: 55,
										Line:   38,
									},
								},
							},
							Name: "onEmpty",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 64,
										Line:   38,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   38,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 64,
											Line:   38,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   38,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 75,
									Line:   38,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 77,
										Line:   38,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 76,
										Line:   38,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   38,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 76,
											Line:   38,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   39,
					},
					File:   "universe.flux",
					Source: "builtin first",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   39,
						},
						File:   "universe.flux",
						Source: "first",
						Start: ast.Position{
							Column: 9,
							Line:   39,
						},
					},
				},
				Name: "first",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 72,
							Line:   39,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 17,
							Line:   39,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   39,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 63,
								Line:   39,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 66,
									Line:   39,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 63,
									Line:   39,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   39,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [A]",
							Start: ast.Position{
								Column: 17,
								Line:   39,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   39,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   39,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   39,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   39,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   39,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   39,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   39,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 33,
									Line:   39,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 34,
										Line:   39,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 42,
										Line:   39,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   39,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 42,
											Line:   39,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   39,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 53,
									Line:   39,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   39,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 54,
										Line:   39,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   39,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 54,
											Line:   39,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   40,
					},
					File:   "universe.flux",
					Source: "builtin group",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   40,
						},
						File:   "universe.flux",
						Source: "group",
						Start: ast.Position{
							Column: 9,
							Line:   40,
						},
					},
				},
				Name: "group",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 90,
							Line:   40,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?mode: string, ?columns: [string]) => [A] where A: Record",
						Start: ast.Position{
							Column: 17,
							Line:   40,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 90,
								Line:   40,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 81,
								Line:   40,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 84,
									Line:   40,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 81,
									Line:   40,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 74,
								Line:   40,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?mode: string, ?columns: [string]) => [A]",
							Start: ast.Position{
								Column: 17,
								Line:   40,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   40,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   40,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   40,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   40,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   40,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   40,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   40,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "?mode: string",
								Start: ast.Position{
									Column: 33,
									Line:   40,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "mode",
									Start: ast.Position{
										Column: 34,
										Line:   40,
									},
								},
							},
							Name: "mode",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 40,
										Line:   40,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   40,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 40,
											Line:   40,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 48,
									Line:   40,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 49,
										Line:   40,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 58,
										Line:   40,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   40,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 59,
											Line:   40,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   40,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 59,
												Line:   40,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   40,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 71,
									Line:   40,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 73,
										Line:   40,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 72,
										Line:   40,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 73,
											Line:   40,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 72,
											Line:   40,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   41,
					},
					File:   "universe.flux",
					Source: "builtin histogram",
					Start: ast.Position{
						Column: 1,
						Line:   41,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   41,
						},
						File:   "universe.flux",
						Source: "histogram",
						Start: ast.Position{
							Column: 9,
							Line:   41,
						},
					},
				},
				Name: "histogram",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   50,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    ?column: string,\n    ?upperBoundColumn: string,\n    ?countColumn: string,\n    bins: [float],\n    ?normalize: bool,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 21,
							Line:   41,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   49,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   49,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   49,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   49,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   49,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   49,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   50,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   50,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   50,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   50,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   50,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   50,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   48,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    ?column: string,\n    ?upperBoundColumn: string,\n    ?countColumn: string,\n    bins: [float],\n    ?normalize: bool,\n) => [B]",
							Start: ast.Position{
								Column: 21,
								Line:   41,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   42,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   42,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   42,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   42,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   42,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   42,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   42,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   42,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   42,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   42,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   43,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 5,
									Line:   43,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   43,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 6,
										Line:   43,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   43,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 14,
										Line:   43,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   43,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 14,
											Line:   43,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   44,
								},
								File:   "universe.flux",
								Source: "?upperBoundColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   44,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   44,
									},
									File:   "universe.flux",
									Source: "upperBoundColumn",
									Start: ast.Position{
										Column: 6,
										Line:   44,
									},
								},
							},
							Name: "upperBoundColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   44,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 24,
										Line:   44,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   44,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 24,
											Line:   44,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   45,
								},
								File:   "universe.flux",
								Source: "?countColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   45,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   45,
									},
									File:   "universe.flux",
									Source: "countColumn",
									Start: ast.Position{
										Column: 6,
										Line:   45,
									},
								},
							},
							Name: "countColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   45,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   45,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   45,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   45,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   46,
								},
								File:   "universe.flux",
								Source: "bins: [float]",
								Start: ast.Position{
									Column: 5,
									Line:   46,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   46,
									},
									File:   "universe.flux",
									Source: "bins",
									Start: ast.Position{
										Column: 5,
										Line:   46,
									},
								},
							},
							Name: "bins",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   46,
									},
									File:   "universe.flux",
									Source: "[float]",
									Start: ast.Position{
										Column: 11,
										Line:   46,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   46,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 12,
											Line:   46,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   46,
											},
											File:   "universe.flux",
											Source: "float",
											Start: ast.Position{
												Column: 12,
												Line:   46,
											},
										},
									},
									Name: "float",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   47,
								},
								File:   "universe.flux",
								Source: "?normalize: bool",
								Start: ast.Position{
									Column: 5,
									Line:   47,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 15,
										Line:   47,
									},
									File:   "universe.flux",
									Source: "normalize",
									Start: ast.Position{
										Column: 6,
										Line:   47,
									},
								},
							},
							Name: "normalize",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   47,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 17,
										Line:   47,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   47,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 17,
											Line:   47,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   48,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   48,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   48,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   48,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   48,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   48,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 26,
						Line:   52,
					},
					File:   "universe.flux",
					Source: "builtin histogramQuantile",
					Start: ast.Position{
						Column: 1,
						Line:   52,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   52,
						},
						File:   "universe.flux",
						Source: "histogramQuantile",
						Start: ast.Position{
							Column: 9,
							Line:   52,
						},
					},
				},
				Name: "histogramQuantile",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   61,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    ?quantile: float,\n    ?countColumn: string,\n    ?upperBoundColumn: string,\n    ?valueColumn: string,\n    ?minValue: float,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 29,
							Line:   52,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   60,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   60,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   60,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   60,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   60,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   60,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   61,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   61,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   61,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   61,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   61,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   61,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   59,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    ?quantile: float,\n    ?countColumn: string,\n    ?upperBoundColumn: string,\n    ?valueColumn: string,\n    ?minValue: float,\n) => [B]",
							Start: ast.Position{
								Column: 29,
								Line:   52,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   53,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   53,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   53,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   53,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   53,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   53,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   53,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   53,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   53,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   53,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   54,
								},
								File:   "universe.flux",
								Source: "?quantile: float",
								Start: ast.Position{
									Column: 5,
									Line:   54,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   54,
									},
									File:   "universe.flux",
									Source: "quantile",
									Start: ast.Position{
										Column: 6,
										Line:   54,
									},
								},
							},
							Name: "quantile",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   54,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 16,
										Line:   54,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   54,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 16,
											Line:   54,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   55,
								},
								File:   "universe.flux",
								Source: "?countColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   55,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   55,
									},
									File:   "universe.flux",
									Source: "countColumn",
									Start: ast.Position{
										Column: 6,
										Line:   55,
									},
								},
							},
							Name: "countColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   55,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   55,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   55,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   55,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   56,
								},
								File:   "universe.flux",
								Source: "?upperBoundColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   56,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   56,
									},
									File:   "universe.flux",
									Source: "upperBoundColumn",
									Start: ast.Position{
										Column: 6,
										Line:   56,
									},
								},
							},
							Name: "upperBoundColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   56,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 24,
										Line:   56,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   56,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 24,
											Line:   56,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   57,
								},
								File:   "universe.flux",
								Source: "?valueColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   57,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   57,
									},
									File:   "universe.flux",
									Source: "valueColumn",
									Start: ast.Position{
										Column: 6,
										Line:   57,
									},
								},
							},
							Name: "valueColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   57,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   57,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   57,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   57,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   58,
								},
								File:   "universe.flux",
								Source: "?minValue: float",
								Start: ast.Position{
									Column: 5,
									Line:   58,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   58,
									},
									File:   "universe.flux",
									Source: "minValue",
									Start: ast.Position{
										Column: 6,
										Line:   58,
									},
								},
							},
							Name: "minValue",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   58,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 16,
										Line:   58,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   58,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 16,
											Line:   58,
										},
									},
								},
								Name: "float",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   59,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   59,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   59,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   59,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   59,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   59,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   63,
					},
					File:   "universe.flux",
					Source: "builtin holtWinters",
					Start: ast.Position{
						Column: 1,
						Line:   63,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   63,
						},
						File:   "universe.flux",
						Source: "holtWinters",
						Start: ast.Position{
							Column: 9,
							Line:   63,
						},
					},
				},
				Name: "holtWinters",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   73,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    n: int,\n    interval: duration,\n    ?withFit: bool,\n    ?column: string,\n    ?timeColumn: string,\n    ?seasonality: int,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 23,
							Line:   63,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   72,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   72,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   72,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   72,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   72,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   72,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   73,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   73,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   73,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   73,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   73,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   73,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   71,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    n: int,\n    interval: duration,\n    ?withFit: bool,\n    ?column: string,\n    ?timeColumn: string,\n    ?seasonality: int,\n) => [B]",
							Start: ast.Position{
								Column: 23,
								Line:   63,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   64,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   64,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   64,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   64,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   64,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   64,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   64,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   64,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   64,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   64,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   65,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 5,
									Line:   65,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   65,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 5,
										Line:   65,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   65,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 8,
										Line:   65,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   65,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 8,
											Line:   65,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   66,
								},
								File:   "universe.flux",
								Source: "interval: duration",
								Start: ast.Position{
									Column: 5,
									Line:   66,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   66,
									},
									File:   "universe.flux",
									Source: "interval",
									Start: ast.Position{
										Column: 5,
										Line:   66,
									},
								},
							},
							Name: "interval",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   66,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 15,
										Line:   66,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   66,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 15,
											Line:   66,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   67,
								},
								File:   "universe.flux",
								Source: "?withFit: bool",
								Start: ast.Position{
									Column: 5,
									Line:   67,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   67,
									},
									File:   "universe.flux",
									Source: "withFit",
									Start: ast.Position{
										Column: 6,
										Line:   67,
									},
								},
							},
							Name: "withFit",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   67,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 15,
										Line:   67,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   67,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 15,
											Line:   67,
										},
									},
								},
								Name: "bool",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   68,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 5,
									Line:   68,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   68,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 6,
										Line:   68,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   68,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 14,
										Line:   68,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   68,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 14,
											Line:   68,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   69,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   69,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   69,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 6,
										Line:   69,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   69,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   69,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   69,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   69,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   70,
								},
								File:   "universe.flux",
								Source: "?seasonality: int",
								Start: ast.Position{
									Column: 5,
									Line:   70,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   70,
									},
									File:   "universe.flux",
									Source: "seasonality",
									Start: ast.Position{
										Column: 6,
										Line:   70,
									},
								},
							},
							Name: "seasonality",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   70,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 19,
										Line:   70,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   70,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 19,
											Line:   70,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   71,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   71,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   71,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   71,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   71,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   71,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   75,
					},
					File:   "universe.flux",
					Source: "builtin hourSelection",
					Start: ast.Position{
						Column: 1,
						Line:   75,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   75,
						},
						File:   "universe.flux",
						Source: "hourSelection",
						Start: ast.Position{
							Column: 9,
							Line:   75,
						},
					},
				},
				Name: "hourSelection",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 107,
							Line:   75,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], start: int, stop: int, ?timeColumn: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 25,
							Line:   75,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 107,
								Line:   75,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 98,
								Line:   75,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 107,
									Line:   75,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 101,
									Line:   75,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   75,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 98,
									Line:   75,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 91,
								Line:   75,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], start: int, stop: int, ?timeColumn: string) => [A]",
							Start: ast.Position{
								Column: 25,
								Line:   75,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   75,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 26,
									Line:   75,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   75,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 28,
										Line:   75,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   75,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 36,
										Line:   75,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   75,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 37,
											Line:   75,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   75,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 37,
												Line:   75,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   75,
								},
								File:   "universe.flux",
								Source: "start: int",
								Start: ast.Position{
									Column: 41,
									Line:   75,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   75,
									},
									File:   "universe.flux",
									Source: "start",
									Start: ast.Position{
										Column: 41,
										Line:   75,
									},
								},
							},
							Name: "start",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   75,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 48,
										Line:   75,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   75,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 48,
											Line:   75,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   75,
								},
								File:   "universe.flux",
								Source: "stop: int",
								Start: ast.Position{
									Column: 53,
									Line:   75,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   75,
									},
									File:   "universe.flux",
									Source: "stop",
									Start: ast.Position{
										Column: 53,
										Line:   75,
									},
								},
							},
							Name: "stop",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   75,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 59,
										Line:   75,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 62,
											Line:   75,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 59,
											Line:   75,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   75,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 64,
									Line:   75,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   75,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 65,
										Line:   75,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 83,
										Line:   75,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 77,
										Line:   75,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 83,
											Line:   75,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 77,
											Line:   75,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   75,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 88,
									Line:   75,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 90,
										Line:   75,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 89,
										Line:   75,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 90,
											Line:   75,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 89,
											Line:   75,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   76,
					},
					File:   "universe.flux",
					Source: "builtin integral",
					Start: ast.Position{
						Column: 1,
						Line:   76,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   76,
						},
						File:   "universe.flux",
						Source: "integral",
						Start: ast.Position{
							Column: 9,
							Line:   76,
						},
					},
				},
				Name: "integral",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   84,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    ?unit: duration,\n    ?timeColumn: string,\n    ?column: string,\n    ?interpolate: string,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 20,
							Line:   76,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   83,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   83,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   83,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   83,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   83,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   83,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   84,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   84,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   84,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   84,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   84,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   84,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   82,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    ?unit: duration,\n    ?timeColumn: string,\n    ?column: string,\n    ?interpolate: string,\n) => [B]",
							Start: ast.Position{
								Column: 20,
								Line:   76,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   77,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   77,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   77,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   77,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   77,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   77,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   77,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   77,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   77,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   77,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   78,
								},
								File:   "universe.flux",
								Source: "?unit: duration",
								Start: ast.Position{
									Column: 5,
									Line:   78,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   78,
									},
									File:   "universe.flux",
									Source: "unit",
									Start: ast.Position{
										Column: 6,
										Line:   78,
									},
								},
							},
							Name: "unit",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   78,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 12,
										Line:   78,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   78,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 12,
											Line:   78,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   79,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   79,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   79,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 6,
										Line:   79,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   79,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   79,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   79,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   79,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   80,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 5,
									Line:   80,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   80,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 6,
										Line:   80,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   80,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 14,
										Line:   80,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   80,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 14,
											Line:   80,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   81,
								},
								File:   "universe.flux",
								Source: "?interpolate: string",
								Start: ast.Position{
									Column: 5,
									Line:   81,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   81,
									},
									File:   "universe.flux",
									Source: "interpolate",
									Start: ast.Position{
										Column: 6,
										Line:   81,
									},
								},
							},
							Name: "interpolate",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   81,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   81,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   81,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   81,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   82,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   82,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   82,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   82,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   82,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   82,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   86,
					},
					File:   "universe.flux",
					Source: "builtin join",
					Start: ast.Position{
						Column: 1,
						Line:   86,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   86,
						},
						File:   "universe.flux",
						Source: "join",
						Start: ast.Position{
							Column: 9,
							Line:   86,
						},
					},
				},
				Name: "join",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 95,
							Line:   86,
						},
						File:   "universe.flux",
						Source: "(<-tables: A, ?method: string, ?on: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 16,
							Line:   86,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   86,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 75,
								Line:   86,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 78,
									Line:   86,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 75,
									Line:   86,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 95,
								Line:   86,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 86,
								Line:   86,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 95,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 89,
									Line:   86,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 87,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 86,
									Line:   86,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 68,
								Line:   86,
							},
							File:   "universe.flux",
							Source: "(<-tables: A, ?method: string, ?on: [string]) => [B]",
							Start: ast.Position{
								Column: 16,
								Line:   86,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "<-tables: A",
								Start: ast.Position{
									Column: 17,
									Line:   86,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   86,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   86,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   86,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 27,
										Line:   86,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   86,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 27,
											Line:   86,
										},
									},
								},
								Name: "A",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "?method: string",
								Start: ast.Position{
									Column: 30,
									Line:   86,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   86,
									},
									File:   "universe.flux",
									Source: "method",
									Start: ast.Position{
										Column: 31,
										Line:   86,
									},
								},
							},
							Name: "method",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   86,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 39,
										Line:   86,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   86,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 39,
											Line:   86,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "?on: [string]",
								Start: ast.Position{
									Column: 47,
									Line:   86,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   86,
									},
									File:   "universe.flux",
									Source: "on",
									Start: ast.Position{
										Column: 48,
										Line:   86,
									},
								},
							},
							Name: "on",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   86,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 52,
										Line:   86,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   86,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 53,
											Line:   86,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   86,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 53,
												Line:   86,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   86,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 65,
									Line:   86,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   86,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 66,
										Line:   86,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   86,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 66,
											Line:   86,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   87,
					},
					File:   "universe.flux",
					Source: "builtin kaufmansAMA",
					Start: ast.Position{
						Column: 1,
						Line:   87,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   87,
						},
						File:   "universe.flux",
						Source: "kaufmansAMA",
						Start: ast.Position{
							Column: 9,
							Line:   87,
						},
					},
				},
				Name: "kaufmansAMA",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 97,
							Line:   87,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], n: int, ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 23,
							Line:   87,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   87,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 77,
								Line:   87,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   87,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 80,
									Line:   87,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   87,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 77,
									Line:   87,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   87,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 88,
								Line:   87,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   87,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 91,
									Line:   87,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   87,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 88,
									Line:   87,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   87,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], n: int, ?column: string) => [B]",
							Start: ast.Position{
								Column: 23,
								Line:   87,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   87,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 24,
									Line:   87,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   87,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 26,
										Line:   87,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   87,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 34,
										Line:   87,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   87,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 35,
											Line:   87,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   87,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 35,
												Line:   87,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   87,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 39,
									Line:   87,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   87,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 39,
										Line:   87,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   87,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 42,
										Line:   87,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   87,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 42,
											Line:   87,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   87,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 47,
									Line:   87,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   87,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 48,
										Line:   87,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   87,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 56,
										Line:   87,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 62,
											Line:   87,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 56,
											Line:   87,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   87,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 67,
									Line:   87,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   87,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 68,
										Line:   87,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   87,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 68,
											Line:   87,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   88,
					},
					File:   "universe.flux",
					Source: "builtin keep",
					Start: ast.Position{
						Column: 1,
						Line:   88,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   88,
						},
						File:   "universe.flux",
						Source: "keep",
						Start: ast.Position{
							Column: 9,
							Line:   88,
						},
					},
				},
				Name: "keep",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 116,
							Line:   88,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?columns: [string], ?fn: (column: string) => bool) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 16,
							Line:   88,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 105,
								Line:   88,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 96,
								Line:   88,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 99,
									Line:   88,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 96,
									Line:   88,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 116,
								Line:   88,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 107,
								Line:   88,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 116,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 110,
									Line:   88,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 108,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 107,
									Line:   88,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 89,
								Line:   88,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?columns: [string], ?fn: (column: string) => bool) => [B]",
							Start: ast.Position{
								Column: 16,
								Line:   88,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   88,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   88,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   88,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   88,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   88,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   88,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   88,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   88,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   88,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 32,
									Line:   88,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   88,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 33,
										Line:   88,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   88,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 42,
										Line:   88,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   88,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   88,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   88,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 43,
												Line:   88,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "?fn: (column: string) => bool",
								Start: ast.Position{
									Column: 52,
									Line:   88,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   88,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 53,
										Line:   88,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   88,
									},
									File:   "universe.flux",
									Source: "(column: string) => bool",
									Start: ast.Position{
										Column: 57,
										Line:   88,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   88,
										},
										File:   "universe.flux",
										Source: "column: string",
										Start: ast.Position{
											Column: 58,
											Line:   88,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 64,
												Line:   88,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 58,
												Line:   88,
											},
										},
									},
									Name: "column",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   88,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 66,
												Line:   88,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 72,
													Line:   88,
												},
												File:   "universe.flux",
												Source: "string",
												Start: ast.Position{
													Column: 66,
													Line:   88,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   88,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 77,
											Line:   88,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   88,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 77,
												Line:   88,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 89,
									Line:   88,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 86,
									Line:   88,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 88,
										Line:   88,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 87,
										Line:   88,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   88,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 87,
											Line:   88,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   89,
					},
					File:   "universe.flux",
					Source: "builtin keyValues",
					Start: ast.Position{
						Column: 1,
						Line:   89,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   89,
						},
						File:   "universe.flux",
						Source: "keyValues",
						Start: ast.Position{
							Column: 9,
							Line:   89,
						},
					},
				},
				Name: "keyValues",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 124,
							Line:   89,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?keyColumns: [string]) => [{C with _key: string, _value: B}] where A: Record, C: Record",
						Start: ast.Position{
							Column: 21,
							Line:   89,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 113,
								Line:   89,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 104,
								Line:   89,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 113,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 107,
									Line:   89,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 104,
									Line:   89,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 124,
								Line:   89,
							},
							File:   "universe.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 115,
								Line:   89,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 118,
									Line:   89,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 116,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "C",
								Start: ast.Position{
									Column: 115,
									Line:   89,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   89,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?keyColumns: [string]) => [{C with _key: string, _value: B}]",
							Start: ast.Position{
								Column: 21,
								Line:   89,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 22,
									Line:   89,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   89,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 24,
										Line:   89,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   89,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 32,
										Line:   89,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   89,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 33,
											Line:   89,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   89,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 33,
												Line:   89,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "?keyColumns: [string]",
								Start: ast.Position{
									Column: 37,
									Line:   89,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   89,
									},
									File:   "universe.flux",
									Source: "keyColumns",
									Start: ast.Position{
										Column: 38,
										Line:   89,
									},
								},
							},
							Name: "keyColumns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   89,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 50,
										Line:   89,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   89,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 51,
											Line:   89,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   89,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 51,
												Line:   89,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   89,
								},
								File:   "universe.flux",
								Source: "[{C with _key: string, _value: B}]",
								Start: ast.Position{
									Column: 63,
									Line:   89,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 96,
										Line:   89,
									},
									File:   "universe.flux",
									Source: "{C with _key: string, _value: B}",
									Start: ast.Position{
										Column: 64,
										Line:   89,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 84,
											Line:   89,
										},
										File:   "universe.flux",
										Source: "_key: string",
										Start: ast.Position{
											Column: 72,
											Line:   89,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   89,
											},
											File:   "universe.flux",
											Source: "_key",
											Start: ast.Position{
												Column: 72,
												Line:   89,
											},
										},
									},
									Name: "_key",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   89,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 78,
												Line:   89,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 84,
													Line:   89,
												},
												File:   "universe.flux",
												Source: "string",
												Start: ast.Position{
													Column: 78,
													Line:   89,
												},
											},
										},
										Name: "string",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 95,
											Line:   89,
										},
										File:   "universe.flux",
										Source: "_value: B",
										Start: ast.Position{
											Column: 86,
											Line:   89,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 92,
												Line:   89,
											},
											File:   "universe.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 86,
												Line:   89,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 95,
												Line:   89,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 94,
												Line:   89,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 95,
													Line:   89,
												},
												File:   "universe.flux",
												Source: "B",
												Start: ast.Position{
													Column: 94,
													Line:   89,
												},
											},
										},
										Name: "B",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   89,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 65,
											Line:   89,
										},
									},
								},
								Name: "C",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   90,
					},
					File:   "universe.flux",
					Source: "builtin keys",
					Start: ast.Position{
						Column: 1,
						Line:   90,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   90,
						},
						File:   "universe.flux",
						Source: "keys",
						Start: ast.Position{
							Column: 9,
							Line:   90,
						},
					},
				},
				Name: "keys",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 82,
							Line:   90,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 16,
							Line:   90,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   90,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 62,
								Line:   90,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 65,
									Line:   90,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 62,
									Line:   90,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   90,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 73,
								Line:   90,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 76,
									Line:   90,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 73,
									Line:   90,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   90,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 16,
								Line:   90,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   90,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   90,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   90,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   90,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   90,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   90,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   90,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 32,
									Line:   90,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 33,
										Line:   90,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   90,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   90,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   90,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   90,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 52,
									Line:   90,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   90,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 53,
										Line:   90,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   90,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 53,
											Line:   90,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   91,
					},
					File:   "universe.flux",
					Source: "builtin last",
					Start: ast.Position{
						Column: 1,
						Line:   91,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   91,
						},
						File:   "universe.flux",
						Source: "last",
						Start: ast.Position{
							Column: 9,
							Line:   91,
						},
					},
				},
				Name: "last",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 71,
							Line:   91,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 16,
							Line:   91,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   91,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 62,
								Line:   91,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   91,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 65,
									Line:   91,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   91,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 62,
									Line:   91,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   91,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [A]",
							Start: ast.Position{
								Column: 16,
								Line:   91,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   91,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   91,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   91,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   91,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   91,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   91,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   91,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   91,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   91,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 32,
									Line:   91,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 33,
										Line:   91,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   91,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   91,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   91,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   91,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 52,
									Line:   91,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   91,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 53,
										Line:   91,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   91,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 53,
											Line:   91,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   92,
					},
					File:   "universe.flux",
					Source: "builtin limit",
					Start: ast.Position{
						Column: 1,
						Line:   92,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   92,
						},
						File:   "universe.flux",
						Source: "limit",
						Start: ast.Position{
							Column: 9,
							Line:   92,
						},
					},
				},
				Name: "limit",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 61,
							Line:   92,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], n: int, ?offset: int) => [A]",
						Start: ast.Position{
							Column: 17,
							Line:   92,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   92,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], n: int, ?offset: int) => [A]",
							Start: ast.Position{
								Column: 17,
								Line:   92,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   92,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   92,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   92,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   92,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   92,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   92,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   92,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   92,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   92,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   92,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   92,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 33,
									Line:   92,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   92,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 33,
										Line:   92,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   92,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 36,
										Line:   92,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   92,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 36,
											Line:   92,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   92,
								},
								File:   "universe.flux",
								Source: "?offset: int",
								Start: ast.Position{
									Column: 41,
									Line:   92,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   92,
									},
									File:   "universe.flux",
									Source: "offset",
									Start: ast.Position{
										Column: 42,
										Line:   92,
									},
								},
							},
							Name: "offset",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   92,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 50,
										Line:   92,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   92,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 50,
											Line:   92,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   92,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 58,
									Line:   92,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   92,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 59,
										Line:   92,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 60,
											Line:   92,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 59,
											Line:   92,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   93,
					},
					File:   "universe.flux",
					Source: "builtin map",
					Start: ast.Position{
						Column: 1,
						Line:   93,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   93,
						},
						File:   "universe.flux",
						Source: "map",
						Start: ast.Position{
							Column: 9,
							Line:   93,
						},
					},
				},
				Name: "map",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 71,
							Line:   93,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], fn: (r: A) => B, ?mergeKey: bool) => [B]",
						Start: ast.Position{
							Column: 15,
							Line:   93,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   93,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], fn: (r: A) => B, ?mergeKey: bool) => [B]",
							Start: ast.Position{
								Column: 15,
								Line:   93,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 16,
									Line:   93,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   93,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 18,
										Line:   93,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   93,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 26,
										Line:   93,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   93,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 27,
											Line:   93,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   93,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 27,
												Line:   93,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "fn: (r: A) => B",
								Start: ast.Position{
									Column: 31,
									Line:   93,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   93,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 31,
										Line:   93,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   93,
									},
									File:   "universe.flux",
									Source: "(r: A) => B",
									Start: ast.Position{
										Column: 35,
										Line:   93,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   93,
										},
										File:   "universe.flux",
										Source: "r: A",
										Start: ast.Position{
											Column: 36,
											Line:   93,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   93,
											},
											File:   "universe.flux",
											Source: "r",
											Start: ast.Position{
												Column: 36,
												Line:   93,
											},
										},
									},
									Name: "r",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   93,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 39,
												Line:   93,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   93,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 39,
													Line:   93,
												},
											},
										},
										Name: "A",
									},
								},
							}},
							Return: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   93,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 45,
											Line:   93,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   93,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 45,
												Line:   93,
											},
										},
									},
									Name: "B",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "?mergeKey: bool",
								Start: ast.Position{
									Column: 48,
									Line:   93,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   93,
									},
									File:   "universe.flux",
									Source: "mergeKey",
									Start: ast.Position{
										Column: 49,
										Line:   93,
									},
								},
							},
							Name: "mergeKey",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   93,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 59,
										Line:   93,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   93,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 59,
											Line:   93,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   93,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 68,
									Line:   93,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   93,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 69,
										Line:   93,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   93,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 69,
											Line:   93,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   94,
					},
					File:   "universe.flux",
					Source: "builtin max",
					Start: ast.Position{
						Column: 1,
						Line:   94,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   94,
						},
						File:   "universe.flux",
						Source: "max",
						Start: ast.Position{
							Column: 9,
							Line:   94,
						},
					},
				},
				Name: "max",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   94,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 15,
							Line:   94,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   94,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 61,
								Line:   94,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   94,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 64,
									Line:   94,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   94,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 61,
									Line:   94,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   94,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [A]",
							Start: ast.Position{
								Column: 15,
								Line:   94,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   94,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 16,
									Line:   94,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   94,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 18,
										Line:   94,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   94,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 26,
										Line:   94,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   94,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 27,
											Line:   94,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   94,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 27,
												Line:   94,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   94,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 31,
									Line:   94,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   94,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 32,
										Line:   94,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   94,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 40,
										Line:   94,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   94,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 40,
											Line:   94,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   94,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 51,
									Line:   94,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   94,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 52,
										Line:   94,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   94,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 52,
											Line:   94,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   95,
					},
					File:   "universe.flux",
					Source: "builtin mean",
					Start: ast.Position{
						Column: 1,
						Line:   95,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   95,
						},
						File:   "universe.flux",
						Source: "mean",
						Start: ast.Position{
							Column: 9,
							Line:   95,
						},
					},
				},
				Name: "mean",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 82,
							Line:   95,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 16,
							Line:   95,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   95,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 62,
								Line:   95,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   95,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 65,
									Line:   95,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   95,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 62,
									Line:   95,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   95,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 73,
								Line:   95,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   95,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 76,
									Line:   95,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   95,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 73,
									Line:   95,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   95,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 16,
								Line:   95,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   95,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   95,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   95,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   95,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   95,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   95,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   95,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   95,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   95,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   95,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   95,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 32,
									Line:   95,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   95,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 33,
										Line:   95,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   95,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   95,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   95,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   95,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   95,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 52,
									Line:   95,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   95,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 53,
										Line:   95,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   95,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 53,
											Line:   95,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   96,
					},
					File:   "universe.flux",
					Source: "builtin min",
					Start: ast.Position{
						Column: 1,
						Line:   96,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   96,
						},
						File:   "universe.flux",
						Source: "min",
						Start: ast.Position{
							Column: 9,
							Line:   96,
						},
					},
				},
				Name: "min",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   96,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 15,
							Line:   96,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   96,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 61,
								Line:   96,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   96,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 64,
									Line:   96,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   96,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 61,
									Line:   96,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   96,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [A]",
							Start: ast.Position{
								Column: 15,
								Line:   96,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   96,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 16,
									Line:   96,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   96,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 18,
										Line:   96,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   96,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 26,
										Line:   96,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   96,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 27,
											Line:   96,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   96,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 27,
												Line:   96,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   96,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 31,
									Line:   96,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   96,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 32,
										Line:   96,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   96,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 40,
										Line:   96,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   96,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 40,
											Line:   96,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   96,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 51,
									Line:   96,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   96,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 52,
										Line:   96,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   96,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 52,
											Line:   96,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   97,
					},
					File:   "universe.flux",
					Source: "builtin mode",
					Start: ast.Position{
						Column: 1,
						Line:   97,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   97,
						},
						File:   "universe.flux",
						Source: "mode",
						Start: ast.Position{
							Column: 9,
							Line:   97,
						},
					},
				},
				Name: "mode",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 99,
							Line:   97,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [{C with _value: B}] where A: Record, C: Record",
						Start: ast.Position{
							Column: 16,
							Line:   97,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 88,
								Line:   97,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 79,
								Line:   97,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 88,
									Line:   97,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 82,
									Line:   97,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 80,
									Line:   97,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 79,
									Line:   97,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   97,
							},
							File:   "universe.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 90,
								Line:   97,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   97,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 93,
									Line:   97,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   97,
								},
								File:   "universe.flux",
								Source: "C",
								Start: ast.Position{
									Column: 90,
									Line:   97,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   97,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [{C with _value: B}]",
							Start: ast.Position{
								Column: 16,
								Line:   97,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   97,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   97,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   97,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   97,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   97,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   97,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   97,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   97,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   97,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   97,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   97,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 32,
									Line:   97,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   97,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 33,
										Line:   97,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   97,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   97,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   97,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   97,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   97,
								},
								File:   "universe.flux",
								Source: "[{C with _value: B}]",
								Start: ast.Position{
									Column: 52,
									Line:   97,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   97,
									},
									File:   "universe.flux",
									Source: "{C with _value: B}",
									Start: ast.Position{
										Column: 53,
										Line:   97,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   97,
										},
										File:   "universe.flux",
										Source: "_value: B",
										Start: ast.Position{
											Column: 61,
											Line:   97,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   97,
											},
											File:   "universe.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 61,
												Line:   97,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   97,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 69,
												Line:   97,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   97,
												},
												File:   "universe.flux",
												Source: "B",
												Start: ast.Position{
													Column: 69,
													Line:   97,
												},
											},
										},
										Name: "B",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   97,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 54,
											Line:   97,
										},
									},
								},
								Name: "C",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   98,
					},
					File:   "universe.flux",
					Source: "builtin movingAverage",
					Start: ast.Position{
						Column: 1,
						Line:   98,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   98,
						},
						File:   "universe.flux",
						Source: "movingAverage",
						Start: ast.Position{
							Column: 9,
							Line:   98,
						},
					},
				},
				Name: "movingAverage",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 110,
							Line:   98,
						},
						File:   "universe.flux",
						Source: "(<-tables: [{B with _value: A}], n: int) => [{B with _value: float}] where A: Numeric",
						Start: ast.Position{
							Column: 25,
							Line:   98,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 110,
								Line:   98,
							},
							File:   "universe.flux",
							Source: "A: Numeric",
							Start: ast.Position{
								Column: 100,
								Line:   98,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 110,
									Line:   98,
								},
								File:   "universe.flux",
								Source: "Numeric",
								Start: ast.Position{
									Column: 103,
									Line:   98,
								},
							},
						},
						Name: "Numeric",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   98,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 100,
									Line:   98,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 93,
								Line:   98,
							},
							File:   "universe.flux",
							Source: "(<-tables: [{B with _value: A}], n: int) => [{B with _value: float}]",
							Start: ast.Position{
								Column: 25,
								Line:   98,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   98,
								},
								File:   "universe.flux",
								Source: "<-tables: [{B with _value: A}]",
								Start: ast.Position{
									Column: 26,
									Line:   98,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   98,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 28,
										Line:   98,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   98,
									},
									File:   "universe.flux",
									Source: "[{B with _value: A}]",
									Start: ast.Position{
										Column: 36,
										Line:   98,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   98,
										},
										File:   "universe.flux",
										Source: "{B with _value: A}",
										Start: ast.Position{
											Column: 37,
											Line:   98,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   98,
											},
											File:   "universe.flux",
											Source: "_value: A",
											Start: ast.Position{
												Column: 45,
												Line:   98,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   98,
												},
												File:   "universe.flux",
												Source: "_value",
												Start: ast.Position{
													Column: 45,
													Line:   98,
												},
											},
										},
										Name: "_value",
									},
									Ty: &ast.TvarType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   98,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 53,
													Line:   98,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   98,
													},
													File:   "universe.flux",
													Source: "A",
													Start: ast.Position{
														Column: 53,
														Line:   98,
													},
												},
											},
											Name: "A",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   98,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 38,
												Line:   98,
											},
										},
									},
									Name: "B",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   98,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 58,
									Line:   98,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   98,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 58,
										Line:   98,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   98,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 61,
										Line:   98,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   98,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 61,
											Line:   98,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 93,
									Line:   98,
								},
								File:   "universe.flux",
								Source: "[{B with _value: float}]",
								Start: ast.Position{
									Column: 69,
									Line:   98,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 92,
										Line:   98,
									},
									File:   "universe.flux",
									Source: "{B with _value: float}",
									Start: ast.Position{
										Column: 70,
										Line:   98,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 91,
											Line:   98,
										},
										File:   "universe.flux",
										Source: "_value: float",
										Start: ast.Position{
											Column: 78,
											Line:   98,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   98,
											},
											File:   "universe.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 78,
												Line:   98,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 91,
												Line:   98,
											},
											File:   "universe.flux",
											Source: "float",
											Start: ast.Position{
												Column: 86,
												Line:   98,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 91,
													Line:   98,
												},
												File:   "universe.flux",
												Source: "float",
												Start: ast.Position{
													Column: 86,
													Line:   98,
												},
											},
										},
										Name: "float",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   98,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 71,
											Line:   98,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   99,
					},
					File:   "universe.flux",
					Source: "builtin quantile",
					Start: ast.Position{
						Column: 1,
						Line:   99,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   99,
						},
						File:   "universe.flux",
						Source: "quantile",
						Start: ast.Position{
							Column: 9,
							Line:   99,
						},
					},
				},
				Name: "quantile",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   106,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    ?column: string,\n    q: float,\n    ?compression: float,\n    ?method: string,\n) => [A] where\n    A: Record",
						Start: ast.Position{
							Column: 20,
							Line:   99,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   106,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   106,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   106,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   106,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   106,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   106,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   105,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    ?column: string,\n    q: float,\n    ?compression: float,\n    ?method: string,\n) => [A]",
							Start: ast.Position{
								Column: 20,
								Line:   99,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   100,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   100,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   100,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   100,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   100,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   100,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   100,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   100,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   100,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   100,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   101,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 5,
									Line:   101,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   101,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 6,
										Line:   101,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   101,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 14,
										Line:   101,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   101,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 14,
											Line:   101,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   102,
								},
								File:   "universe.flux",
								Source: "q: float",
								Start: ast.Position{
									Column: 5,
									Line:   102,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   102,
									},
									File:   "universe.flux",
									Source: "q",
									Start: ast.Position{
										Column: 5,
										Line:   102,
									},
								},
							},
							Name: "q",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   102,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 8,
										Line:   102,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   102,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 8,
											Line:   102,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   103,
								},
								File:   "universe.flux",
								Source: "?compression: float",
								Start: ast.Position{
									Column: 5,
									Line:   103,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   103,
									},
									File:   "universe.flux",
									Source: "compression",
									Start: ast.Position{
										Column: 6,
										Line:   103,
									},
								},
							},
							Name: "compression",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   103,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 19,
										Line:   103,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   103,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 19,
											Line:   103,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   104,
								},
								File:   "universe.flux",
								Source: "?method: string",
								Start: ast.Position{
									Column: 5,
									Line:   104,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   104,
									},
									File:   "universe.flux",
									Source: "method",
									Start: ast.Position{
										Column: 6,
										Line:   104,
									},
								},
							},
							Name: "method",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   104,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 14,
										Line:   104,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   104,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 14,
											Line:   104,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   105,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 6,
									Line:   105,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   105,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 7,
										Line:   105,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   105,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 7,
											Line:   105,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   108,
					},
					File:   "universe.flux",
					Source: "builtin pivot",
					Start: ast.Position{
						Column: 1,
						Line:   108,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   108,
						},
						File:   "universe.flux",
						Source: "pivot",
						Start: ast.Position{
							Column: 9,
							Line:   108,
						},
					},
				},
				Name: "pivot",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 126,
							Line:   108,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], rowKey: [string], columnKey: [string], valueColumn: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 17,
							Line:   108,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 115,
								Line:   108,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 106,
								Line:   108,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 115,
									Line:   108,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 109,
									Line:   108,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 107,
									Line:   108,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 106,
									Line:   108,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 126,
								Line:   108,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 117,
								Line:   108,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 126,
									Line:   108,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 120,
									Line:   108,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 118,
									Line:   108,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 117,
									Line:   108,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   108,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], rowKey: [string], columnKey: [string], valueColumn: string) => [B]",
							Start: ast.Position{
								Column: 17,
								Line:   108,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   108,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   108,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   108,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   108,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   108,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   108,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   108,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   108,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   108,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   108,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   108,
								},
								File:   "universe.flux",
								Source: "rowKey: [string]",
								Start: ast.Position{
									Column: 33,
									Line:   108,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   108,
									},
									File:   "universe.flux",
									Source: "rowKey",
									Start: ast.Position{
										Column: 33,
										Line:   108,
									},
								},
							},
							Name: "rowKey",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   108,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 41,
										Line:   108,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   108,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 42,
											Line:   108,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   108,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 42,
												Line:   108,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   108,
								},
								File:   "universe.flux",
								Source: "columnKey: [string]",
								Start: ast.Position{
									Column: 51,
									Line:   108,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   108,
									},
									File:   "universe.flux",
									Source: "columnKey",
									Start: ast.Position{
										Column: 51,
										Line:   108,
									},
								},
							},
							Name: "columnKey",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   108,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 62,
										Line:   108,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   108,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 63,
											Line:   108,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   108,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 63,
												Line:   108,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   108,
								},
								File:   "universe.flux",
								Source: "valueColumn: string",
								Start: ast.Position{
									Column: 72,
									Line:   108,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 83,
										Line:   108,
									},
									File:   "universe.flux",
									Source: "valueColumn",
									Start: ast.Position{
										Column: 72,
										Line:   108,
									},
								},
							},
							Name: "valueColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 91,
										Line:   108,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 85,
										Line:   108,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 91,
											Line:   108,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 85,
											Line:   108,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   108,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 96,
									Line:   108,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 98,
										Line:   108,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 97,
										Line:   108,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 98,
											Line:   108,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 97,
											Line:   108,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   109,
					},
					File:   "universe.flux",
					Source: "builtin range",
					Start: ast.Position{
						Column: 1,
						Line:   109,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   109,
						},
						File:   "universe.flux",
						Source: "range",
						Start: ast.Position{
							Column: 9,
							Line:   109,
						},
					},
				},
				Name: "range",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 3,
							Line:   117,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [{A with _time: time}],\n    start: B,\n    ?stop: C,\n) => [{A with\n    _time: time,\n    _start: time,\n    _stop: time,\n}]",
						Start: ast.Position{
							Column: 17,
							Line:   109,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 3,
								Line:   117,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [{A with _time: time}],\n    start: B,\n    ?stop: C,\n) => [{A with\n    _time: time,\n    _start: time,\n    _stop: time,\n}]",
							Start: ast.Position{
								Column: 17,
								Line:   109,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   110,
								},
								File:   "universe.flux",
								Source: "<-tables: [{A with _time: time}]",
								Start: ast.Position{
									Column: 5,
									Line:   110,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   110,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   110,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   110,
									},
									File:   "universe.flux",
									Source: "[{A with _time: time}]",
									Start: ast.Position{
										Column: 15,
										Line:   110,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   110,
										},
										File:   "universe.flux",
										Source: "{A with _time: time}",
										Start: ast.Position{
											Column: 16,
											Line:   110,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   110,
											},
											File:   "universe.flux",
											Source: "_time: time",
											Start: ast.Position{
												Column: 24,
												Line:   110,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   110,
												},
												File:   "universe.flux",
												Source: "_time",
												Start: ast.Position{
													Column: 24,
													Line:   110,
												},
											},
										},
										Name: "_time",
									},
									Ty: &ast.NamedType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   110,
												},
												File:   "universe.flux",
												Source: "time",
												Start: ast.Position{
													Column: 31,
													Line:   110,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   110,
													},
													File:   "universe.flux",
													Source: "time",
													Start: ast.Position{
														Column: 31,
														Line:   110,
													},
												},
											},
											Name: "time",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   110,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 17,
												Line:   110,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   111,
								},
								File:   "universe.flux",
								Source: "start: B",
								Start: ast.Position{
									Column: 5,
									Line:   111,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   111,
									},
									File:   "universe.flux",
									Source: "start",
									Start: ast.Position{
										Column: 5,
										Line:   111,
									},
								},
							},
							Name: "start",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   111,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 12,
										Line:   111,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   111,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 12,
											Line:   111,
										},
									},
								},
								Name: "B",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   112,
								},
								File:   "universe.flux",
								Source: "?stop: C",
								Start: ast.Position{
									Column: 5,
									Line:   112,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   112,
									},
									File:   "universe.flux",
									Source: "stop",
									Start: ast.Position{
										Column: 6,
										Line:   112,
									},
								},
							},
							Name: "stop",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   112,
									},
									File:   "universe.flux",
									Source: "C",
									Start: ast.Position{
										Column: 12,
										Line:   112,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   112,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 12,
											Line:   112,
										},
									},
								},
								Name: "C",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 3,
									Line:   117,
								},
								File:   "universe.flux",
								Source: "[{A with\n    _time: time,\n    _start: time,\n    _stop: time,\n}]",
								Start: ast.Position{
									Column: 6,
									Line:   113,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 2,
										Line:   117,
									},
									File:   "universe.flux",
									Source: "{A with\n    _time: time,\n    _start: time,\n    _stop: time,\n}",
									Start: ast.Position{
										Column: 7,
										Line:   113,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   114,
										},
										File:   "universe.flux",
										Source: "_time: time",
										Start: ast.Position{
											Column: 5,
											Line:   114,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   114,
											},
											File:   "universe.flux",
											Source: "_time",
											Start: ast.Position{
												Column: 5,
												Line:   114,
											},
										},
									},
									Name: "_time",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   114,
											},
											File:   "universe.flux",
											Source: "time",
											Start: ast.Position{
												Column: 12,
												Line:   114,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   114,
												},
												File:   "universe.flux",
												Source: "time",
												Start: ast.Position{
													Column: 12,
													Line:   114,
												},
											},
										},
										Name: "time",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   115,
										},
										File:   "universe.flux",
										Source: "_start: time",
										Start: ast.Position{
											Column: 5,
											Line:   115,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   115,
											},
											File:   "universe.flux",
											Source: "_start",
											Start: ast.Position{
												Column: 5,
												Line:   115,
											},
										},
									},
									Name: "_start",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   115,
											},
											File:   "universe.flux",
											Source: "time",
											Start: ast.Position{
												Column: 13,
												Line:   115,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   115,
												},
												File:   "universe.flux",
												Source: "time",
												Start: ast.Position{
													Column: 13,
													Line:   115,
												},
											},
										},
										Name: "time",
									},
								},
							}, &ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   116,
										},
										File:   "universe.flux",
										Source: "_stop: time",
										Start: ast.Position{
											Column: 5,
											Line:   116,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   116,
											},
											File:   "universe.flux",
											Source: "_stop",
											Start: ast.Position{
												Column: 5,
												Line:   116,
											},
										},
									},
									Name: "_stop",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   116,
											},
											File:   "universe.flux",
											Source: "time",
											Start: ast.Position{
												Column: 12,
												Line:   116,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 16,
													Line:   116,
												},
												File:   "universe.flux",
												Source: "time",
												Start: ast.Position{
													Column: 12,
													Line:   116,
												},
											},
										},
										Name: "time",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 9,
											Line:   113,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 8,
											Line:   113,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   119,
					},
					File:   "universe.flux",
					Source: "builtin reduce",
					Start: ast.Position{
						Column: 1,
						Line:   119,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   119,
						},
						File:   "universe.flux",
						Source: "reduce",
						Start: ast.Position{
							Column: 9,
							Line:   119,
						},
					},
				},
				Name: "reduce",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 124,
							Line:   119,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], fn: (r: A, accumulator: B) => B, identity: B) => [C] where A: Record, B: Record, C: Record",
						Start: ast.Position{
							Column: 18,
							Line:   119,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   119,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 93,
								Line:   119,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   119,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 96,
									Line:   119,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   119,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 93,
									Line:   119,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 113,
								Line:   119,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 104,
								Line:   119,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 113,
									Line:   119,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 107,
									Line:   119,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   119,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 104,
									Line:   119,
								},
							},
						},
						Name: "B",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 124,
								Line:   119,
							},
							File:   "universe.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 115,
								Line:   119,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   119,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 118,
									Line:   119,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 116,
									Line:   119,
								},
								File:   "universe.flux",
								Source: "C",
								Start: ast.Position{
									Column: 115,
									Line:   119,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   119,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], fn: (r: A, accumulator: B) => B, identity: B) => [C]",
							Start: ast.Position{
								Column: 18,
								Line:   119,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   119,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   119,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   119,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   119,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   119,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   119,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   119,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   119,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   119,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   119,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   119,
								},
								File:   "universe.flux",
								Source: "fn: (r: A, accumulator: B) => B",
								Start: ast.Position{
									Column: 34,
									Line:   119,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   119,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 34,
										Line:   119,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   119,
									},
									File:   "universe.flux",
									Source: "(r: A, accumulator: B) => B",
									Start: ast.Position{
										Column: 38,
										Line:   119,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   119,
										},
										File:   "universe.flux",
										Source: "r: A",
										Start: ast.Position{
											Column: 39,
											Line:   119,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   119,
											},
											File:   "universe.flux",
											Source: "r",
											Start: ast.Position{
												Column: 39,
												Line:   119,
											},
										},
									},
									Name: "r",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   119,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 42,
												Line:   119,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   119,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 42,
													Line:   119,
												},
											},
										},
										Name: "A",
									},
								},
							}, &ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   119,
										},
										File:   "universe.flux",
										Source: "accumulator: B",
										Start: ast.Position{
											Column: 45,
											Line:   119,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   119,
											},
											File:   "universe.flux",
											Source: "accumulator",
											Start: ast.Position{
												Column: 45,
												Line:   119,
											},
										},
									},
									Name: "accumulator",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   119,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 58,
												Line:   119,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   119,
												},
												File:   "universe.flux",
												Source: "B",
												Start: ast.Position{
													Column: 58,
													Line:   119,
												},
											},
										},
										Name: "B",
									},
								},
							}},
							Return: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   119,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 64,
											Line:   119,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   119,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 64,
												Line:   119,
											},
										},
									},
									Name: "B",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   119,
								},
								File:   "universe.flux",
								Source: "identity: B",
								Start: ast.Position{
									Column: 67,
									Line:   119,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   119,
									},
									File:   "universe.flux",
									Source: "identity",
									Start: ast.Position{
										Column: 67,
										Line:   119,
									},
								},
							},
							Name: "identity",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   119,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 77,
										Line:   119,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   119,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 77,
											Line:   119,
										},
									},
								},
								Name: "B",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   119,
								},
								File:   "universe.flux",
								Source: "[C]",
								Start: ast.Position{
									Column: 83,
									Line:   119,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 85,
										Line:   119,
									},
									File:   "universe.flux",
									Source: "C",
									Start: ast.Position{
										Column: 84,
										Line:   119,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   119,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 84,
											Line:   119,
										},
									},
								},
								Name: "C",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 30,
						Line:   120,
					},
					File:   "universe.flux",
					Source: "builtin relativeStrengthIndex",
					Start: ast.Position{
						Column: 1,
						Line:   120,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   120,
						},
						File:   "universe.flux",
						Source: "relativeStrengthIndex",
						Start: ast.Position{
							Column: 9,
							Line:   120,
						},
					},
				},
				Name: "relativeStrengthIndex",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 110,
							Line:   120,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], n: int, ?columns: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 33,
							Line:   120,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   120,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 90,
								Line:   120,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   120,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 93,
									Line:   120,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   120,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 90,
									Line:   120,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 110,
								Line:   120,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 101,
								Line:   120,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 110,
									Line:   120,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 104,
									Line:   120,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   120,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 101,
									Line:   120,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 83,
								Line:   120,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], n: int, ?columns: [string]) => [B]",
							Start: ast.Position{
								Column: 33,
								Line:   120,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   120,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 34,
									Line:   120,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   120,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 36,
										Line:   120,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   120,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 44,
										Line:   120,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   120,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 45,
											Line:   120,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   120,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 45,
												Line:   120,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   120,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 49,
									Line:   120,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   120,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 49,
										Line:   120,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   120,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 52,
										Line:   120,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   120,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 52,
											Line:   120,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   120,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 57,
									Line:   120,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   120,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 58,
										Line:   120,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   120,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 67,
										Line:   120,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   120,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 68,
											Line:   120,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   120,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 68,
												Line:   120,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   120,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 80,
									Line:   120,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 82,
										Line:   120,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 81,
										Line:   120,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 82,
											Line:   120,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 81,
											Line:   120,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   121,
					},
					File:   "universe.flux",
					Source: "builtin rename",
					Start: ast.Position{
						Column: 1,
						Line:   121,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   121,
						},
						File:   "universe.flux",
						Source: "rename",
						Start: ast.Position{
							Column: 9,
							Line:   121,
						},
					},
				},
				Name: "rename",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 124,
							Line:   121,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?fn: (column: string) => string, ?columns: B) => [C] where A: Record, B: Record, C: Record",
						Start: ast.Position{
							Column: 18,
							Line:   121,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 102,
								Line:   121,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 93,
								Line:   121,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 102,
									Line:   121,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 96,
									Line:   121,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 94,
									Line:   121,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 93,
									Line:   121,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 113,
								Line:   121,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 104,
								Line:   121,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 113,
									Line:   121,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 107,
									Line:   121,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 105,
									Line:   121,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 104,
									Line:   121,
								},
							},
						},
						Name: "B",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 124,
								Line:   121,
							},
							File:   "universe.flux",
							Source: "C: Record",
							Start: ast.Position{
								Column: 115,
								Line:   121,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   121,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 118,
									Line:   121,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 116,
									Line:   121,
								},
								File:   "universe.flux",
								Source: "C",
								Start: ast.Position{
									Column: 115,
									Line:   121,
								},
							},
						},
						Name: "C",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 86,
								Line:   121,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?fn: (column: string) => string, ?columns: B) => [C]",
							Start: ast.Position{
								Column: 18,
								Line:   121,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   121,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   121,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   121,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   121,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   121,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   121,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   121,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   121,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   121,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   121,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   121,
								},
								File:   "universe.flux",
								Source: "?fn: (column: string) => string",
								Start: ast.Position{
									Column: 34,
									Line:   121,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   121,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 35,
										Line:   121,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   121,
									},
									File:   "universe.flux",
									Source: "(column: string) => string",
									Start: ast.Position{
										Column: 39,
										Line:   121,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   121,
										},
										File:   "universe.flux",
										Source: "column: string",
										Start: ast.Position{
											Column: 40,
											Line:   121,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   121,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 40,
												Line:   121,
											},
										},
									},
									Name: "column",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   121,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 48,
												Line:   121,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   121,
												},
												File:   "universe.flux",
												Source: "string",
												Start: ast.Position{
													Column: 48,
													Line:   121,
												},
											},
										},
										Name: "string",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   121,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 59,
											Line:   121,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   121,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 59,
												Line:   121,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   121,
								},
								File:   "universe.flux",
								Source: "?columns: B",
								Start: ast.Position{
									Column: 67,
									Line:   121,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   121,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 68,
										Line:   121,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   121,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 77,
										Line:   121,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   121,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 77,
											Line:   121,
										},
									},
								},
								Name: "B",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 86,
									Line:   121,
								},
								File:   "universe.flux",
								Source: "[C]",
								Start: ast.Position{
									Column: 83,
									Line:   121,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 85,
										Line:   121,
									},
									File:   "universe.flux",
									Source: "C",
									Start: ast.Position{
										Column: 84,
										Line:   121,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 85,
											Line:   121,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 84,
											Line:   121,
										},
									},
								},
								Name: "C",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   122,
					},
					File:   "universe.flux",
					Source: "builtin sample",
					Start: ast.Position{
						Column: 1,
						Line:   122,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   122,
						},
						File:   "universe.flux",
						Source: "sample",
						Start: ast.Position{
							Column: 9,
							Line:   122,
						},
					},
				},
				Name: "sample",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 92,
							Line:   122,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], n: int, ?pos: int, ?column: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 18,
							Line:   122,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 92,
								Line:   122,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 83,
								Line:   122,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 92,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 86,
									Line:   122,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 83,
									Line:   122,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 76,
								Line:   122,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], n: int, ?pos: int, ?column: string) => [A]",
							Start: ast.Position{
								Column: 18,
								Line:   122,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   122,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   122,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   122,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   122,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   122,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   122,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   122,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 34,
									Line:   122,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 34,
										Line:   122,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 37,
										Line:   122,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   122,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 37,
											Line:   122,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "?pos: int",
								Start: ast.Position{
									Column: 42,
									Line:   122,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "pos",
									Start: ast.Position{
										Column: 43,
										Line:   122,
									},
								},
							},
							Name: "pos",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 48,
										Line:   122,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 51,
											Line:   122,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 48,
											Line:   122,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 53,
									Line:   122,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 54,
										Line:   122,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 62,
										Line:   122,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   122,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 62,
											Line:   122,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   122,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 73,
									Line:   122,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   122,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 74,
										Line:   122,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   122,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 74,
											Line:   122,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   123,
					},
					File:   "universe.flux",
					Source: "builtin set",
					Start: ast.Position{
						Column: 1,
						Line:   123,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   123,
						},
						File:   "universe.flux",
						Source: "set",
						Start: ast.Position{
							Column: 9,
							Line:   123,
						},
					},
				},
				Name: "set",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 81,
							Line:   123,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], key: string, value: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 15,
							Line:   123,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   123,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 72,
								Line:   123,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 75,
									Line:   123,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 72,
									Line:   123,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   123,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], key: string, value: string) => [A]",
							Start: ast.Position{
								Column: 15,
								Line:   123,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 16,
									Line:   123,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 18,
										Line:   123,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 26,
										Line:   123,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   123,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 27,
											Line:   123,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   123,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 27,
												Line:   123,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "key: string",
								Start: ast.Position{
									Column: 31,
									Line:   123,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "key",
									Start: ast.Position{
										Column: 31,
										Line:   123,
									},
								},
							},
							Name: "key",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 36,
										Line:   123,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   123,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 36,
											Line:   123,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "value: string",
								Start: ast.Position{
									Column: 44,
									Line:   123,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "value",
									Start: ast.Position{
										Column: 44,
										Line:   123,
									},
								},
							},
							Name: "value",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 51,
										Line:   123,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   123,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 51,
											Line:   123,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   123,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 62,
									Line:   123,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   123,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 63,
										Line:   123,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   123,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 63,
											Line:   123,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   124,
					},
					File:   "universe.flux",
					Source: "builtin tail",
					Start: ast.Position{
						Column: 1,
						Line:   124,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   124,
						},
						File:   "universe.flux",
						Source: "tail",
						Start: ast.Position{
							Column: 9,
							Line:   124,
						},
					},
				},
				Name: "tail",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 60,
							Line:   124,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], n: int, ?offset: int) => [A]",
						Start: ast.Position{
							Column: 16,
							Line:   124,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 60,
								Line:   124,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], n: int, ?offset: int) => [A]",
							Start: ast.Position{
								Column: 16,
								Line:   124,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   124,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   124,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   124,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   124,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   124,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   124,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   124,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 32,
									Line:   124,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 32,
										Line:   124,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 35,
										Line:   124,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   124,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 35,
											Line:   124,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 52,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "?offset: int",
								Start: ast.Position{
									Column: 40,
									Line:   124,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "offset",
									Start: ast.Position{
										Column: 41,
										Line:   124,
									},
								},
							},
							Name: "offset",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 52,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 49,
										Line:   124,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   124,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 49,
											Line:   124,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   124,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 57,
									Line:   124,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   124,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 58,
										Line:   124,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   124,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 58,
											Line:   124,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   125,
					},
					File:   "universe.flux",
					Source: "builtin timeShift",
					Start: ast.Position{
						Column: 1,
						Line:   125,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   125,
						},
						File:   "universe.flux",
						Source: "timeShift",
						Start: ast.Position{
							Column: 9,
							Line:   125,
						},
					},
				},
				Name: "timeShift",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 83,
							Line:   125,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], duration: duration, ?columns: [string]) => [A]",
						Start: ast.Position{
							Column: 21,
							Line:   125,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 83,
								Line:   125,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], duration: duration, ?columns: [string]) => [A]",
							Start: ast.Position{
								Column: 21,
								Line:   125,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   125,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 22,
									Line:   125,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 24,
										Line:   125,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 32,
										Line:   125,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   125,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 33,
											Line:   125,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   125,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 33,
												Line:   125,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   125,
								},
								File:   "universe.flux",
								Source: "duration: duration",
								Start: ast.Position{
									Column: 37,
									Line:   125,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 37,
										Line:   125,
									},
								},
							},
							Name: "duration",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 47,
										Line:   125,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   125,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 47,
											Line:   125,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 75,
									Line:   125,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 57,
									Line:   125,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 58,
										Line:   125,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 75,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 67,
										Line:   125,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   125,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 68,
											Line:   125,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   125,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 68,
												Line:   125,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 83,
									Line:   125,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 80,
									Line:   125,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 82,
										Line:   125,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 81,
										Line:   125,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 82,
											Line:   125,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 81,
											Line:   125,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   126,
					},
					File:   "universe.flux",
					Source: "builtin skew",
					Start: ast.Position{
						Column: 1,
						Line:   126,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   126,
						},
						File:   "universe.flux",
						Source: "skew",
						Start: ast.Position{
							Column: 9,
							Line:   126,
						},
					},
				},
				Name: "skew",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 82,
							Line:   126,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 16,
							Line:   126,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   126,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 62,
								Line:   126,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   126,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 65,
									Line:   126,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   126,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 62,
									Line:   126,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   126,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 73,
								Line:   126,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   126,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 76,
									Line:   126,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   126,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 73,
									Line:   126,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   126,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 16,
								Line:   126,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   126,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   126,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   126,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   126,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   126,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   126,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   126,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   126,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   126,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   126,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   126,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 32,
									Line:   126,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   126,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 33,
										Line:   126,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   126,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 41,
										Line:   126,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   126,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 41,
											Line:   126,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   126,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 52,
									Line:   126,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   126,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 53,
										Line:   126,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   126,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 53,
											Line:   126,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   127,
					},
					File:   "universe.flux",
					Source: "builtin spread",
					Start: ast.Position{
						Column: 1,
						Line:   127,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   127,
						},
						File:   "universe.flux",
						Source: "spread",
						Start: ast.Position{
							Column: 9,
							Line:   127,
						},
					},
				},
				Name: "spread",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 84,
							Line:   127,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 18,
							Line:   127,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 73,
								Line:   127,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 64,
								Line:   127,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   127,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 67,
									Line:   127,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   127,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 64,
									Line:   127,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   127,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 75,
								Line:   127,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   127,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 78,
									Line:   127,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 76,
									Line:   127,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 75,
									Line:   127,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 57,
								Line:   127,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 18,
								Line:   127,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   127,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   127,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   127,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   127,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   127,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   127,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   127,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   127,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   127,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   127,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   127,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 34,
									Line:   127,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   127,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 35,
										Line:   127,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   127,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 43,
										Line:   127,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   127,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   127,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   127,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 54,
									Line:   127,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   127,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 55,
										Line:   127,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 56,
											Line:   127,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 55,
											Line:   127,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   128,
					},
					File:   "universe.flux",
					Source: "builtin sort",
					Start: ast.Position{
						Column: 1,
						Line:   128,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   128,
						},
						File:   "universe.flux",
						Source: "sort",
						Start: ast.Position{
							Column: 9,
							Line:   128,
						},
					},
				},
				Name: "sort",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 87,
							Line:   128,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?columns: [string], ?desc: bool) => [A] where A: Record",
						Start: ast.Position{
							Column: 16,
							Line:   128,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 87,
								Line:   128,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 78,
								Line:   128,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 87,
									Line:   128,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 81,
									Line:   128,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 79,
									Line:   128,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 78,
									Line:   128,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   128,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?columns: [string], ?desc: bool) => [A]",
							Start: ast.Position{
								Column: 16,
								Line:   128,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   128,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 17,
									Line:   128,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   128,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 19,
										Line:   128,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   128,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 27,
										Line:   128,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   128,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   128,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   128,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   128,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   128,
								},
								File:   "universe.flux",
								Source: "?columns: [string]",
								Start: ast.Position{
									Column: 32,
									Line:   128,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   128,
									},
									File:   "universe.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 33,
										Line:   128,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   128,
									},
									File:   "universe.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 42,
										Line:   128,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   128,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   128,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   128,
											},
											File:   "universe.flux",
											Source: "string",
											Start: ast.Position{
												Column: 43,
												Line:   128,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   128,
								},
								File:   "universe.flux",
								Source: "?desc: bool",
								Start: ast.Position{
									Column: 52,
									Line:   128,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   128,
									},
									File:   "universe.flux",
									Source: "desc",
									Start: ast.Position{
										Column: 53,
										Line:   128,
									},
								},
							},
							Name: "desc",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   128,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 59,
										Line:   128,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   128,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 59,
											Line:   128,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   128,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 68,
									Line:   128,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   128,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 69,
										Line:   128,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   128,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 69,
											Line:   128,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   129,
					},
					File:   "universe.flux",
					Source: "builtin stateTracking",
					Start: ast.Position{
						Column: 1,
						Line:   129,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   129,
						},
						File:   "universe.flux",
						Source: "stateTracking",
						Start: ast.Position{
							Column: 9,
							Line:   129,
						},
					},
				},
				Name: "stateTracking",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   138,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    fn: (r: A) => bool,\n    ?countColumn: string,\n    ?durationColumn: string,\n    ?durationUnit: duration,\n    ?timeColumn: string,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 25,
							Line:   129,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   137,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   137,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   137,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   137,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   137,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   137,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   138,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   138,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   138,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   138,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   138,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   138,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   136,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    fn: (r: A) => bool,\n    ?countColumn: string,\n    ?durationColumn: string,\n    ?durationUnit: duration,\n    ?timeColumn: string,\n) => [B]",
							Start: ast.Position{
								Column: 25,
								Line:   129,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   130,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   130,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   130,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   130,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   130,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   130,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   130,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   130,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   130,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   130,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   131,
								},
								File:   "universe.flux",
								Source: "fn: (r: A) => bool",
								Start: ast.Position{
									Column: 5,
									Line:   131,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   131,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 5,
										Line:   131,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   131,
									},
									File:   "universe.flux",
									Source: "(r: A) => bool",
									Start: ast.Position{
										Column: 9,
										Line:   131,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 14,
											Line:   131,
										},
										File:   "universe.flux",
										Source: "r: A",
										Start: ast.Position{
											Column: 10,
											Line:   131,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   131,
											},
											File:   "universe.flux",
											Source: "r",
											Start: ast.Position{
												Column: 10,
												Line:   131,
											},
										},
									},
									Name: "r",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   131,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 13,
												Line:   131,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   131,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 13,
													Line:   131,
												},
											},
										},
										Name: "A",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   131,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 19,
											Line:   131,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   131,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 19,
												Line:   131,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   132,
								},
								File:   "universe.flux",
								Source: "?countColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   132,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   132,
									},
									File:   "universe.flux",
									Source: "countColumn",
									Start: ast.Position{
										Column: 6,
										Line:   132,
									},
								},
							},
							Name: "countColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   132,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   132,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   132,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   132,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   133,
								},
								File:   "universe.flux",
								Source: "?durationColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   133,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   133,
									},
									File:   "universe.flux",
									Source: "durationColumn",
									Start: ast.Position{
										Column: 6,
										Line:   133,
									},
								},
							},
							Name: "durationColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   133,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 22,
										Line:   133,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   133,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 22,
											Line:   133,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   134,
								},
								File:   "universe.flux",
								Source: "?durationUnit: duration",
								Start: ast.Position{
									Column: 5,
									Line:   134,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   134,
									},
									File:   "universe.flux",
									Source: "durationUnit",
									Start: ast.Position{
										Column: 6,
										Line:   134,
									},
								},
							},
							Name: "durationUnit",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   134,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 20,
										Line:   134,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   134,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 20,
											Line:   134,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   135,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   135,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   135,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 6,
										Line:   135,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   135,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   135,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   135,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   135,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   136,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   136,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   136,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   136,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   136,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   136,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   140,
					},
					File:   "universe.flux",
					Source: "builtin stddev",
					Start: ast.Position{
						Column: 1,
						Line:   140,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   140,
						},
						File:   "universe.flux",
						Source: "stddev",
						Start: ast.Position{
							Column: 9,
							Line:   140,
						},
					},
				},
				Name: "stddev",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 99,
							Line:   140,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string, ?mode: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 18,
							Line:   140,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 88,
								Line:   140,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 79,
								Line:   140,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 88,
									Line:   140,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 82,
									Line:   140,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 80,
									Line:   140,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 79,
									Line:   140,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 99,
								Line:   140,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 90,
								Line:   140,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 99,
									Line:   140,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 93,
									Line:   140,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 91,
									Line:   140,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 90,
									Line:   140,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 72,
								Line:   140,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string, ?mode: string) => [B]",
							Start: ast.Position{
								Column: 18,
								Line:   140,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   140,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   140,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   140,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   140,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   140,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   140,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   140,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   140,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   140,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   140,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   140,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 34,
									Line:   140,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   140,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 35,
										Line:   140,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   140,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 43,
										Line:   140,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   140,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   140,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   140,
								},
								File:   "universe.flux",
								Source: "?mode: string",
								Start: ast.Position{
									Column: 51,
									Line:   140,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   140,
									},
									File:   "universe.flux",
									Source: "mode",
									Start: ast.Position{
										Column: 52,
										Line:   140,
									},
								},
							},
							Name: "mode",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   140,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 58,
										Line:   140,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   140,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 58,
											Line:   140,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 72,
									Line:   140,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 69,
									Line:   140,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   140,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 70,
										Line:   140,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   140,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 70,
											Line:   140,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   141,
					},
					File:   "universe.flux",
					Source: "builtin sum",
					Start: ast.Position{
						Column: 1,
						Line:   141,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   141,
						},
						File:   "universe.flux",
						Source: "sum",
						Start: ast.Position{
							Column: 9,
							Line:   141,
						},
					},
				},
				Name: "sum",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 81,
							Line:   141,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 15,
							Line:   141,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   141,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 61,
								Line:   141,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   141,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 64,
									Line:   141,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   141,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 61,
									Line:   141,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   141,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 72,
								Line:   141,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   141,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 75,
									Line:   141,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   141,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 72,
									Line:   141,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   141,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [B]",
							Start: ast.Position{
								Column: 15,
								Line:   141,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   141,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 16,
									Line:   141,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   141,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 18,
										Line:   141,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   141,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 26,
										Line:   141,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   141,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 27,
											Line:   141,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   141,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 27,
												Line:   141,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   141,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 31,
									Line:   141,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   141,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 32,
										Line:   141,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   141,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 40,
										Line:   141,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   141,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 40,
											Line:   141,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   141,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 51,
									Line:   141,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   141,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 52,
										Line:   141,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   141,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 52,
											Line:   141,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 36,
						Line:   142,
					},
					File:   "universe.flux",
					Source: "builtin tripleExponentialDerivative",
					Start: ast.Position{
						Column: 1,
						Line:   142,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 36,
							Line:   142,
						},
						File:   "universe.flux",
						Source: "tripleExponentialDerivative",
						Start: ast.Position{
							Column: 9,
							Line:   142,
						},
					},
				},
				Name: "tripleExponentialDerivative",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 135,
							Line:   142,
						},
						File:   "universe.flux",
						Source: "(<-tables: [{B with _value: A}], n: int) => [{B with _value: float}] where A: Numeric, B: Record",
						Start: ast.Position{
							Column: 39,
							Line:   142,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 124,
								Line:   142,
							},
							File:   "universe.flux",
							Source: "A: Numeric",
							Start: ast.Position{
								Column: 114,
								Line:   142,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   142,
								},
								File:   "universe.flux",
								Source: "Numeric",
								Start: ast.Position{
									Column: 117,
									Line:   142,
								},
							},
						},
						Name: "Numeric",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 115,
									Line:   142,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 114,
									Line:   142,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 135,
								Line:   142,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 126,
								Line:   142,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 135,
									Line:   142,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 129,
									Line:   142,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 127,
									Line:   142,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 126,
									Line:   142,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 107,
								Line:   142,
							},
							File:   "universe.flux",
							Source: "(<-tables: [{B with _value: A}], n: int) => [{B with _value: float}]",
							Start: ast.Position{
								Column: 39,
								Line:   142,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   142,
								},
								File:   "universe.flux",
								Source: "<-tables: [{B with _value: A}]",
								Start: ast.Position{
									Column: 40,
									Line:   142,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   142,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 42,
										Line:   142,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   142,
									},
									File:   "universe.flux",
									Source: "[{B with _value: A}]",
									Start: ast.Position{
										Column: 50,
										Line:   142,
									},
								},
							},
							ElementType: &ast.RecordType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   142,
										},
										File:   "universe.flux",
										Source: "{B with _value: A}",
										Start: ast.Position{
											Column: 51,
											Line:   142,
										},
									},
								},
								Properties: []*ast.PropertyType{&ast.PropertyType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   142,
											},
											File:   "universe.flux",
											Source: "_value: A",
											Start: ast.Position{
												Column: 59,
												Line:   142,
											},
										},
									},
									Name: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   142,
												},
												File:   "universe.flux",
												Source: "_value",
												Start: ast.Position{
													Column: 59,
													Line:   142,
												},
											},
										},
										Name: "_value",
									},
									Ty: &ast.TvarType{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   142,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 67,
													Line:   142,
												},
											},
										},
										ID: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   142,
													},
													File:   "universe.flux",
													Source: "A",
													Start: ast.Position{
														Column: 67,
														Line:   142,
													},
												},
											},
											Name: "A",
										},
									},
								}},
								Tvar: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   142,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 52,
												Line:   142,
											},
										},
									},
									Name: "B",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   142,
								},
								File:   "universe.flux",
								Source: "n: int",
								Start: ast.Position{
									Column: 72,
									Line:   142,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 73,
										Line:   142,
									},
									File:   "universe.flux",
									Source: "n",
									Start: ast.Position{
										Column: 72,
										Line:   142,
									},
								},
							},
							Name: "n",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   142,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 75,
										Line:   142,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   142,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 75,
											Line:   142,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 107,
									Line:   142,
								},
								File:   "universe.flux",
								Source: "[{B with _value: float}]",
								Start: ast.Position{
									Column: 83,
									Line:   142,
								},
							},
						},
						ElementType: &ast.RecordType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 106,
										Line:   142,
									},
									File:   "universe.flux",
									Source: "{B with _value: float}",
									Start: ast.Position{
										Column: 84,
										Line:   142,
									},
								},
							},
							Properties: []*ast.PropertyType{&ast.PropertyType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 105,
											Line:   142,
										},
										File:   "universe.flux",
										Source: "_value: float",
										Start: ast.Position{
											Column: 92,
											Line:   142,
										},
									},
								},
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 98,
												Line:   142,
											},
											File:   "universe.flux",
											Source: "_value",
											Start: ast.Position{
												Column: 92,
												Line:   142,
											},
										},
									},
									Name: "_value",
								},
								Ty: &ast.NamedType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 105,
												Line:   142,
											},
											File:   "universe.flux",
											Source: "float",
											Start: ast.Position{
												Column: 100,
												Line:   142,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 105,
													Line:   142,
												},
												File:   "universe.flux",
												Source: "float",
												Start: ast.Position{
													Column: 100,
													Line:   142,
												},
											},
										},
										Name: "float",
									},
								},
							}},
							Tvar: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 86,
											Line:   142,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 85,
											Line:   142,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   143,
					},
					File:   "universe.flux",
					Source: "builtin union",
					Start: ast.Position{
						Column: 1,
						Line:   143,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   143,
						},
						File:   "universe.flux",
						Source: "union",
						Start: ast.Position{
							Column: 9,
							Line:   143,
						},
					},
				},
				Name: "union",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 55,
							Line:   143,
						},
						File:   "universe.flux",
						Source: "(tables: [[A]]) => [A] where A: Record",
						Start: ast.Position{
							Column: 17,
							Line:   143,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   143,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 46,
								Line:   143,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   143,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 49,
									Line:   143,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   143,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 46,
									Line:   143,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 39,
								Line:   143,
							},
							File:   "universe.flux",
							Source: "(tables: [[A]]) => [A]",
							Start: ast.Position{
								Column: 17,
								Line:   143,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   143,
								},
								File:   "universe.flux",
								Source: "tables: [[A]]",
								Start: ast.Position{
									Column: 18,
									Line:   143,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   143,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 18,
										Line:   143,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   143,
									},
									File:   "universe.flux",
									Source: "[[A]]",
									Start: ast.Position{
										Column: 26,
										Line:   143,
									},
								},
							},
							ElementType: &ast.ArrayType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   143,
										},
										File:   "universe.flux",
										Source: "[A]",
										Start: ast.Position{
											Column: 27,
											Line:   143,
										},
									},
								},
								ElementType: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   143,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 28,
												Line:   143,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   143,
												},
												File:   "universe.flux",
												Source: "A",
												Start: ast.Position{
													Column: 28,
													Line:   143,
												},
											},
										},
										Name: "A",
									},
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   143,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 36,
									Line:   143,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   143,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 37,
										Line:   143,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   143,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 37,
											Line:   143,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   144,
					},
					File:   "universe.flux",
					Source: "builtin unique",
					Start: ast.Position{
						Column: 1,
						Line:   144,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   144,
						},
						File:   "universe.flux",
						Source: "unique",
						Start: ast.Position{
							Column: 9,
							Line:   144,
						},
					},
				},
				Name: "unique",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 73,
							Line:   144,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?column: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 18,
							Line:   144,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 73,
								Line:   144,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 64,
								Line:   144,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   144,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 67,
									Line:   144,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   144,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 64,
									Line:   144,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 57,
								Line:   144,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?column: string) => [A]",
							Start: ast.Position{
								Column: 18,
								Line:   144,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   144,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   144,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   144,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 21,
										Line:   144,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   144,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 29,
										Line:   144,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   144,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 30,
											Line:   144,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   144,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 30,
												Line:   144,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   144,
								},
								File:   "universe.flux",
								Source: "?column: string",
								Start: ast.Position{
									Column: 34,
									Line:   144,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   144,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 35,
										Line:   144,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   144,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 43,
										Line:   144,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   144,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   144,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   144,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 54,
									Line:   144,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   144,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 55,
										Line:   144,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 56,
											Line:   144,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 55,
											Line:   144,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   145,
					},
					File:   "universe.flux",
					Source: "builtin window",
					Start: ast.Position{
						Column: 1,
						Line:   145,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   145,
						},
						File:   "universe.flux",
						Source: "window",
						Start: ast.Position{
							Column: 9,
							Line:   145,
						},
					},
				},
				Name: "window",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   156,
						},
						File:   "universe.flux",
						Source: "(\n    <-tables: [A],\n    ?every: duration,\n    ?period: duration,\n    ?offset: duration,\n    ?timeColumn: string,\n    ?startColumn: string,\n    ?stopColumn: string,\n    ?createEmpty: bool,\n) => [B] where\n    A: Record,\n    B: Record",
						Start: ast.Position{
							Column: 18,
							Line:   145,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   155,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 5,
								Line:   155,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   155,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   155,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   155,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 5,
									Line:   155,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   156,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 5,
								Line:   156,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   156,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 8,
									Line:   156,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   156,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 5,
									Line:   156,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   154,
							},
							File:   "universe.flux",
							Source: "(\n    <-tables: [A],\n    ?every: duration,\n    ?period: duration,\n    ?offset: duration,\n    ?timeColumn: string,\n    ?startColumn: string,\n    ?stopColumn: string,\n    ?createEmpty: bool,\n) => [B]",
							Start: ast.Position{
								Column: 18,
								Line:   145,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   146,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 5,
									Line:   146,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   146,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 7,
										Line:   146,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   146,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 15,
										Line:   146,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   146,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 16,
											Line:   146,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   146,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 16,
												Line:   146,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   147,
								},
								File:   "universe.flux",
								Source: "?every: duration",
								Start: ast.Position{
									Column: 5,
									Line:   147,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   147,
									},
									File:   "universe.flux",
									Source: "every",
									Start: ast.Position{
										Column: 6,
										Line:   147,
									},
								},
							},
							Name: "every",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   147,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 13,
										Line:   147,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   147,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 13,
											Line:   147,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   148,
								},
								File:   "universe.flux",
								Source: "?period: duration",
								Start: ast.Position{
									Column: 5,
									Line:   148,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   148,
									},
									File:   "universe.flux",
									Source: "period",
									Start: ast.Position{
										Column: 6,
										Line:   148,
									},
								},
							},
							Name: "period",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   148,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 14,
										Line:   148,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   148,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 14,
											Line:   148,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   149,
								},
								File:   "universe.flux",
								Source: "?offset: duration",
								Start: ast.Position{
									Column: 5,
									Line:   149,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   149,
									},
									File:   "universe.flux",
									Source: "offset",
									Start: ast.Position{
										Column: 6,
										Line:   149,
									},
								},
							},
							Name: "offset",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   149,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 14,
										Line:   149,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   149,
										},
										File:   "universe.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 14,
											Line:   149,
										},
									},
								},
								Name: "duration",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   150,
								},
								File:   "universe.flux",
								Source: "?timeColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   150,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   150,
									},
									File:   "universe.flux",
									Source: "timeColumn",
									Start: ast.Position{
										Column: 6,
										Line:   150,
									},
								},
							},
							Name: "timeColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   150,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   150,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   150,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   150,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   151,
								},
								File:   "universe.flux",
								Source: "?startColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   151,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   151,
									},
									File:   "universe.flux",
									Source: "startColumn",
									Start: ast.Position{
										Column: 6,
										Line:   151,
									},
								},
							},
							Name: "startColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   151,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 19,
										Line:   151,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   151,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 19,
											Line:   151,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   152,
								},
								File:   "universe.flux",
								Source: "?stopColumn: string",
								Start: ast.Position{
									Column: 5,
									Line:   152,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   152,
									},
									File:   "universe.flux",
									Source: "stopColumn",
									Start: ast.Position{
										Column: 6,
										Line:   152,
									},
								},
							},
							Name: "stopColumn",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   152,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 18,
										Line:   152,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   152,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 18,
											Line:   152,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   153,
								},
								File:   "universe.flux",
								Source: "?createEmpty: bool",
								Start: ast.Position{
									Column: 5,
									Line:   153,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   153,
									},
									File:   "universe.flux",
									Source: "createEmpty",
									Start: ast.Position{
										Column: 6,
										Line:   153,
									},
								},
							},
							Name: "createEmpty",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   153,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 19,
										Line:   153,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   153,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 19,
											Line:   153,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   154,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 6,
									Line:   154,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   154,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 7,
										Line:   154,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 8,
											Line:   154,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 7,
											Line:   154,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   158,
					},
					File:   "universe.flux",
					Source: "builtin yield",
					Start: ast.Position{
						Column: 1,
						Line:   158,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   158,
						},
						File:   "universe.flux",
						Source: "yield",
						Start: ast.Position{
							Column: 9,
							Line:   158,
						},
					},
				},
				Name: "yield",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   158,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], ?name: string) => [A] where A: Record",
						Start: ast.Position{
							Column: 17,
							Line:   158,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   158,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 61,
								Line:   158,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 64,
									Line:   158,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 61,
									Line:   158,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   158,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], ?name: string) => [A]",
							Start: ast.Position{
								Column: 17,
								Line:   158,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   158,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   158,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   158,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   158,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   158,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   158,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   158,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   158,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   158,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "?name: string",
								Start: ast.Position{
									Column: 33,
									Line:   158,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   158,
									},
									File:   "universe.flux",
									Source: "name",
									Start: ast.Position{
										Column: 34,
										Line:   158,
									},
								},
							},
							Name: "name",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   158,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 40,
										Line:   158,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   158,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 40,
											Line:   158,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   158,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 51,
									Line:   158,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   158,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 52,
										Line:   158,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   158,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 52,
											Line:   158,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// stream/table index functions\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   161,
					},
					File:   "universe.flux",
					Source: "builtin tableFind",
					Start: ast.Position{
						Column: 1,
						Line:   161,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   161,
						},
						File:   "universe.flux",
						Source: "tableFind",
						Start: ast.Position{
							Column: 9,
							Line:   161,
						},
					},
				},
				Name: "tableFind",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 92,
							Line:   161,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], fn: (key: B) => bool) => [A] where A: Record, B: Record",
						Start: ast.Position{
							Column: 21,
							Line:   161,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   161,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 72,
								Line:   161,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   161,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 75,
									Line:   161,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   161,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 72,
									Line:   161,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 92,
								Line:   161,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 83,
								Line:   161,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 92,
									Line:   161,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 86,
									Line:   161,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   161,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 83,
									Line:   161,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   161,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], fn: (key: B) => bool) => [A]",
							Start: ast.Position{
								Column: 21,
								Line:   161,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   161,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 22,
									Line:   161,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   161,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 24,
										Line:   161,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   161,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 32,
										Line:   161,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   161,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 33,
											Line:   161,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   161,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 33,
												Line:   161,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 57,
									Line:   161,
								},
								File:   "universe.flux",
								Source: "fn: (key: B) => bool",
								Start: ast.Position{
									Column: 37,
									Line:   161,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   161,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 37,
										Line:   161,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   161,
									},
									File:   "universe.flux",
									Source: "(key: B) => bool",
									Start: ast.Position{
										Column: 41,
										Line:   161,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   161,
										},
										File:   "universe.flux",
										Source: "key: B",
										Start: ast.Position{
											Column: 42,
											Line:   161,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   161,
											},
											File:   "universe.flux",
											Source: "key",
											Start: ast.Position{
												Column: 42,
												Line:   161,
											},
										},
									},
									Name: "key",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   161,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 47,
												Line:   161,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   161,
												},
												File:   "universe.flux",
												Source: "B",
												Start: ast.Position{
													Column: 47,
													Line:   161,
												},
											},
										},
										Name: "B",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   161,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 53,
											Line:   161,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   161,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 53,
												Line:   161,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   161,
								},
								File:   "universe.flux",
								Source: "[A]",
								Start: ast.Position{
									Column: 62,
									Line:   161,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   161,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 63,
										Line:   161,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   161,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 63,
											Line:   161,
										},
									},
								},
								Name: "A",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   162,
					},
					File:   "universe.flux",
					Source: "builtin getColumn",
					Start: ast.Position{
						Column: 1,
						Line:   162,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   162,
						},
						File:   "universe.flux",
						Source: "getColumn",
						Start: ast.Position{
							Column: 9,
							Line:   162,
						},
					},
				},
				Name: "getColumn",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 74,
							Line:   162,
						},
						File:   "universe.flux",
						Source: "(<-table: [A], column: string) => [B] where A: Record",
						Start: ast.Position{
							Column: 21,
							Line:   162,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 74,
								Line:   162,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 65,
								Line:   162,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   162,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 68,
									Line:   162,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   162,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 65,
									Line:   162,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   162,
							},
							File:   "universe.flux",
							Source: "(<-table: [A], column: string) => [B]",
							Start: ast.Position{
								Column: 21,
								Line:   162,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   162,
								},
								File:   "universe.flux",
								Source: "<-table: [A]",
								Start: ast.Position{
									Column: 22,
									Line:   162,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   162,
									},
									File:   "universe.flux",
									Source: "table",
									Start: ast.Position{
										Column: 24,
										Line:   162,
									},
								},
							},
							Name: "table",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   162,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 31,
										Line:   162,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   162,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 32,
											Line:   162,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   162,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 32,
												Line:   162,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   162,
								},
								File:   "universe.flux",
								Source: "column: string",
								Start: ast.Position{
									Column: 36,
									Line:   162,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   162,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 36,
										Line:   162,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   162,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 44,
										Line:   162,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   162,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 44,
											Line:   162,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   162,
								},
								File:   "universe.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 55,
									Line:   162,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   162,
									},
									File:   "universe.flux",
									Source: "B",
									Start: ast.Position{
										Column: 56,
										Line:   162,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   162,
										},
										File:   "universe.flux",
										Source: "B",
										Start: ast.Position{
											Column: 56,
											Line:   162,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   163,
					},
					File:   "universe.flux",
					Source: "builtin getRecord",
					Start: ast.Position{
						Column: 1,
						Line:   163,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   163,
						},
						File:   "universe.flux",
						Source: "getRecord",
						Start: ast.Position{
							Column: 9,
							Line:   163,
						},
					},
				},
				Name: "getRecord",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 66,
							Line:   163,
						},
						File:   "universe.flux",
						Source: "(<-table: [A], idx: int) => A where A: Record",
						Start: ast.Position{
							Column: 21,
							Line:   163,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   163,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 57,
								Line:   163,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   163,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 60,
									Line:   163,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   163,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 57,
									Line:   163,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   163,
							},
							File:   "universe.flux",
							Source: "(<-table: [A], idx: int) => A",
							Start: ast.Position{
								Column: 21,
								Line:   163,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   163,
								},
								File:   "universe.flux",
								Source: "<-table: [A]",
								Start: ast.Position{
									Column: 22,
									Line:   163,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   163,
									},
									File:   "universe.flux",
									Source: "table",
									Start: ast.Position{
										Column: 24,
										Line:   163,
									},
								},
							},
							Name: "table",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   163,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 31,
										Line:   163,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   163,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 32,
											Line:   163,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   163,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 32,
												Line:   163,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   163,
								},
								File:   "universe.flux",
								Source: "idx: int",
								Start: ast.Position{
									Column: 36,
									Line:   163,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   163,
									},
									File:   "universe.flux",
									Source: "idx",
									Start: ast.Position{
										Column: 36,
										Line:   163,
									},
								},
							},
							Name: "idx",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   163,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 41,
										Line:   163,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   163,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 41,
											Line:   163,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.TvarType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   163,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 49,
									Line:   163,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   163,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 49,
										Line:   163,
									},
								},
							},
							Name: "A",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   164,
					},
					File:   "universe.flux",
					Source: "builtin findColumn",
					Start: ast.Position{
						Column: 1,
						Line:   164,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   164,
						},
						File:   "universe.flux",
						Source: "findColumn",
						Start: ast.Position{
							Column: 9,
							Line:   164,
						},
					},
				},
				Name: "findColumn",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 109,
							Line:   164,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], fn: (key: B) => bool, column: string) => [C] where A: Record, B: Record",
						Start: ast.Position{
							Column: 22,
							Line:   164,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 98,
								Line:   164,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 89,
								Line:   164,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 98,
									Line:   164,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 92,
									Line:   164,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   164,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 89,
									Line:   164,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 109,
								Line:   164,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 100,
								Line:   164,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 109,
									Line:   164,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 103,
									Line:   164,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   164,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 100,
									Line:   164,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   164,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], fn: (key: B) => bool, column: string) => [C]",
							Start: ast.Position{
								Column: 22,
								Line:   164,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   164,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 23,
									Line:   164,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   164,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   164,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   164,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 33,
										Line:   164,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   164,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 34,
											Line:   164,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   164,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 34,
												Line:   164,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   164,
								},
								File:   "universe.flux",
								Source: "fn: (key: B) => bool",
								Start: ast.Position{
									Column: 38,
									Line:   164,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   164,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 38,
										Line:   164,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   164,
									},
									File:   "universe.flux",
									Source: "(key: B) => bool",
									Start: ast.Position{
										Column: 42,
										Line:   164,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   164,
										},
										File:   "universe.flux",
										Source: "key: B",
										Start: ast.Position{
											Column: 43,
											Line:   164,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   164,
											},
											File:   "universe.flux",
											Source: "key",
											Start: ast.Position{
												Column: 43,
												Line:   164,
											},
										},
									},
									Name: "key",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   164,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 48,
												Line:   164,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   164,
												},
												File:   "universe.flux",
												Source: "B",
												Start: ast.Position{
													Column: 48,
													Line:   164,
												},
											},
										},
										Name: "B",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   164,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 54,
											Line:   164,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   164,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 54,
												Line:   164,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   164,
								},
								File:   "universe.flux",
								Source: "column: string",
								Start: ast.Position{
									Column: 60,
									Line:   164,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   164,
									},
									File:   "universe.flux",
									Source: "column",
									Start: ast.Position{
										Column: 60,
										Line:   164,
									},
								},
							},
							Name: "column",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 74,
										Line:   164,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 68,
										Line:   164,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   164,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 68,
											Line:   164,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   164,
								},
								File:   "universe.flux",
								Source: "[C]",
								Start: ast.Position{
									Column: 79,
									Line:   164,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   164,
									},
									File:   "universe.flux",
									Source: "C",
									Start: ast.Position{
										Column: 80,
										Line:   164,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   164,
										},
										File:   "universe.flux",
										Source: "C",
										Start: ast.Position{
											Column: 80,
											Line:   164,
										},
									},
								},
								Name: "C",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   165,
					},
					File:   "universe.flux",
					Source: "builtin findRecord",
					Start: ast.Position{
						Column: 1,
						Line:   165,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   165,
						},
						File:   "universe.flux",
						Source: "findRecord",
						Start: ast.Position{
							Column: 9,
							Line:   165,
						},
					},
				},
				Name: "findRecord",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 101,
							Line:   165,
						},
						File:   "universe.flux",
						Source: "(<-tables: [A], fn: (key: B) => bool, idx: int) => A where A: Record, B: Record",
						Start: ast.Position{
							Column: 22,
							Line:   165,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 90,
								Line:   165,
							},
							File:   "universe.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 81,
								Line:   165,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 84,
									Line:   165,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 81,
									Line:   165,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 101,
								Line:   165,
							},
							File:   "universe.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 92,
								Line:   165,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 101,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 95,
									Line:   165,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 93,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "B",
								Start: ast.Position{
									Column: 92,
									Line:   165,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 74,
								Line:   165,
							},
							File:   "universe.flux",
							Source: "(<-tables: [A], fn: (key: B) => bool, idx: int) => A",
							Start: ast.Position{
								Column: 22,
								Line:   165,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 23,
									Line:   165,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   165,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 25,
										Line:   165,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   165,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 33,
										Line:   165,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   165,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 34,
											Line:   165,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   165,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 34,
												Line:   165,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "fn: (key: B) => bool",
								Start: ast.Position{
									Column: 38,
									Line:   165,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   165,
									},
									File:   "universe.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 38,
										Line:   165,
									},
								},
							},
							Name: "fn",
						},
						Ty: &ast.FunctionType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 58,
										Line:   165,
									},
									File:   "universe.flux",
									Source: "(key: B) => bool",
									Start: ast.Position{
										Column: 42,
										Line:   165,
									},
								},
							},
							Parameters: []*ast.ParameterType{&ast.ParameterType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   165,
										},
										File:   "universe.flux",
										Source: "key: B",
										Start: ast.Position{
											Column: 43,
											Line:   165,
										},
									},
								},
								Kind: "Required",
								Name: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   165,
											},
											File:   "universe.flux",
											Source: "key",
											Start: ast.Position{
												Column: 43,
												Line:   165,
											},
										},
									},
									Name: "key",
								},
								Ty: &ast.TvarType{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   165,
											},
											File:   "universe.flux",
											Source: "B",
											Start: ast.Position{
												Column: 48,
												Line:   165,
											},
										},
									},
									ID: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   165,
												},
												File:   "universe.flux",
												Source: "B",
												Start: ast.Position{
													Column: 48,
													Line:   165,
												},
											},
										},
										Name: "B",
									},
								},
							}},
							Return: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   165,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 54,
											Line:   165,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 58,
												Line:   165,
											},
											File:   "universe.flux",
											Source: "bool",
											Start: ast.Position{
												Column: 54,
												Line:   165,
											},
										},
									},
									Name: "bool",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "idx: int",
								Start: ast.Position{
									Column: 60,
									Line:   165,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   165,
									},
									File:   "universe.flux",
									Source: "idx",
									Start: ast.Position{
										Column: 60,
										Line:   165,
									},
								},
							},
							Name: "idx",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 68,
										Line:   165,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 65,
										Line:   165,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   165,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 65,
											Line:   165,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.TvarType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   165,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 73,
									Line:   165,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 74,
										Line:   165,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 73,
										Line:   165,
									},
								},
							},
							Name: "A",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// type conversion functions\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   168,
					},
					File:   "universe.flux",
					Source: "builtin bool",
					Start: ast.Position{
						Column: 1,
						Line:   168,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   168,
						},
						File:   "universe.flux",
						Source: "bool",
						Start: ast.Position{
							Column: 9,
							Line:   168,
						},
					},
				},
				Name: "bool",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   168,
						},
						File:   "universe.flux",
						Source: "(v: A) => bool",
						Start: ast.Position{
							Column: 16,
							Line:   168,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   168,
							},
							File:   "universe.flux",
							Source: "(v: A) => bool",
							Start: ast.Position{
								Column: 16,
								Line:   168,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   168,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 17,
									Line:   168,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   168,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 17,
										Line:   168,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   168,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 20,
										Line:   168,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   168,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 20,
											Line:   168,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   168,
								},
								File:   "universe.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 26,
									Line:   168,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   168,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 26,
										Line:   168,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   169,
					},
					File:   "universe.flux",
					Source: "builtin bytes",
					Start: ast.Position{
						Column: 1,
						Line:   169,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   169,
						},
						File:   "universe.flux",
						Source: "bytes",
						Start: ast.Position{
							Column: 9,
							Line:   169,
						},
					},
				},
				Name: "bytes",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   169,
						},
						File:   "universe.flux",
						Source: "(v: A) => bytes",
						Start: ast.Position{
							Column: 17,
							Line:   169,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   169,
							},
							File:   "universe.flux",
							Source: "(v: A) => bytes",
							Start: ast.Position{
								Column: 17,
								Line:   169,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   169,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 18,
									Line:   169,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   169,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 18,
										Line:   169,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   169,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 21,
										Line:   169,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   169,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 21,
											Line:   169,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   169,
								},
								File:   "universe.flux",
								Source: "bytes",
								Start: ast.Position{
									Column: 27,
									Line:   169,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   169,
									},
									File:   "universe.flux",
									Source: "bytes",
									Start: ast.Position{
										Column: 27,
										Line:   169,
									},
								},
							},
							Name: "bytes",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   170,
					},
					File:   "universe.flux",
					Source: "builtin duration",
					Start: ast.Position{
						Column: 1,
						Line:   170,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   170,
						},
						File:   "universe.flux",
						Source: "duration",
						Start: ast.Position{
							Column: 9,
							Line:   170,
						},
					},
				},
				Name: "duration",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 38,
							Line:   170,
						},
						File:   "universe.flux",
						Source: "(v: A) => duration",
						Start: ast.Position{
							Column: 20,
							Line:   170,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   170,
							},
							File:   "universe.flux",
							Source: "(v: A) => duration",
							Start: ast.Position{
								Column: 20,
								Line:   170,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   170,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 21,
									Line:   170,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   170,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 21,
										Line:   170,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   170,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 24,
										Line:   170,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   170,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 24,
											Line:   170,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   170,
								},
								File:   "universe.flux",
								Source: "duration",
								Start: ast.Position{
									Column: 30,
									Line:   170,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   170,
									},
									File:   "universe.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 30,
										Line:   170,
									},
								},
							},
							Name: "duration",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   171,
					},
					File:   "universe.flux",
					Source: "builtin float",
					Start: ast.Position{
						Column: 1,
						Line:   171,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   171,
						},
						File:   "universe.flux",
						Source: "float",
						Start: ast.Position{
							Column: 9,
							Line:   171,
						},
					},
				},
				Name: "float",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   171,
						},
						File:   "universe.flux",
						Source: "(v: A) => float",
						Start: ast.Position{
							Column: 17,
							Line:   171,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   171,
							},
							File:   "universe.flux",
							Source: "(v: A) => float",
							Start: ast.Position{
								Column: 17,
								Line:   171,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   171,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 18,
									Line:   171,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   171,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 18,
										Line:   171,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   171,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 21,
										Line:   171,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   171,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 21,
											Line:   171,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   171,
								},
								File:   "universe.flux",
								Source: "float",
								Start: ast.Position{
									Column: 27,
									Line:   171,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   171,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 27,
										Line:   171,
									},
								},
							},
							Name: "float",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   172,
					},
					File:   "universe.flux",
					Source: "builtin int",
					Start: ast.Position{
						Column: 1,
						Line:   172,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   172,
						},
						File:   "universe.flux",
						Source: "int",
						Start: ast.Position{
							Column: 9,
							Line:   172,
						},
					},
				},
				Name: "int",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 28,
							Line:   172,
						},
						File:   "universe.flux",
						Source: "(v: A) => int",
						Start: ast.Position{
							Column: 15,
							Line:   172,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   172,
							},
							File:   "universe.flux",
							Source: "(v: A) => int",
							Start: ast.Position{
								Column: 15,
								Line:   172,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   172,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 16,
									Line:   172,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   172,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 16,
										Line:   172,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   172,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 19,
										Line:   172,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   172,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 19,
											Line:   172,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   172,
								},
								File:   "universe.flux",
								Source: "int",
								Start: ast.Position{
									Column: 25,
									Line:   172,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   172,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 25,
										Line:   172,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   173,
					},
					File:   "universe.flux",
					Source: "builtin string",
					Start: ast.Position{
						Column: 1,
						Line:   173,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   173,
						},
						File:   "universe.flux",
						Source: "string",
						Start: ast.Position{
							Column: 9,
							Line:   173,
						},
					},
				},
				Name: "string",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 34,
							Line:   173,
						},
						File:   "universe.flux",
						Source: "(v: A) => string",
						Start: ast.Position{
							Column: 18,
							Line:   173,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 34,
								Line:   173,
							},
							File:   "universe.flux",
							Source: "(v: A) => string",
							Start: ast.Position{
								Column: 18,
								Line:   173,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   173,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 19,
									Line:   173,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   173,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 19,
										Line:   173,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   173,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 22,
										Line:   173,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   173,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 22,
											Line:   173,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   173,
								},
								File:   "universe.flux",
								Source: "string",
								Start: ast.Position{
									Column: 28,
									Line:   173,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   173,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 28,
										Line:   173,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   174,
					},
					File:   "universe.flux",
					Source: "builtin time",
					Start: ast.Position{
						Column: 1,
						Line:   174,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   174,
						},
						File:   "universe.flux",
						Source: "time",
						Start: ast.Position{
							Column: 9,
							Line:   174,
						},
					},
				},
				Name: "time",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   174,
						},
						File:   "universe.flux",
						Source: "(v: A) => time",
						Start: ast.Position{
							Column: 16,
							Line:   174,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   174,
							},
							File:   "universe.flux",
							Source: "(v: A) => time",
							Start: ast.Position{
								Column: 16,
								Line:   174,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   174,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 17,
									Line:   174,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   174,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 17,
										Line:   174,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   174,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 20,
										Line:   174,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   174,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 20,
											Line:   174,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   174,
								},
								File:   "universe.flux",
								Source: "time",
								Start: ast.Position{
									Column: 26,
									Line:   174,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   174,
									},
									File:   "universe.flux",
									Source: "time",
									Start: ast.Position{
										Column: 26,
										Line:   174,
									},
								},
							},
							Name: "time",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   175,
					},
					File:   "universe.flux",
					Source: "builtin uint",
					Start: ast.Position{
						Column: 1,
						Line:   175,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   175,
						},
						File:   "universe.flux",
						Source: "uint",
						Start: ast.Position{
							Column: 9,
							Line:   175,
						},
					},
				},
				Name: "uint",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 30,
							Line:   175,
						},
						File:   "universe.flux",
						Source: "(v: A) => uint",
						Start: ast.Position{
							Column: 16,
							Line:   175,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   175,
							},
							File:   "universe.flux",
							Source: "(v: A) => uint",
							Start: ast.Position{
								Column: 16,
								Line:   175,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   175,
								},
								File:   "universe.flux",
								Source: "v: A",
								Start: ast.Position{
									Column: 17,
									Line:   175,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   175,
									},
									File:   "universe.flux",
									Source: "v",
									Start: ast.Position{
										Column: 17,
										Line:   175,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   175,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 20,
										Line:   175,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   175,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 20,
											Line:   175,
										},
									},
								},
								Name: "A",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   175,
								},
								File:   "universe.flux",
								Source: "uint",
								Start: ast.Position{
									Column: 26,
									Line:   175,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   175,
									},
									File:   "universe.flux",
									Source: "uint",
									Start: ast.Position{
										Column: 26,
										Line:   175,
									},
								},
							},
							Name: "uint",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// contains function\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   178,
					},
					File:   "universe.flux",
					Source: "builtin contains",
					Start: ast.Position{
						Column: 1,
						Line:   178,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   178,
						},
						File:   "universe.flux",
						Source: "contains",
						Start: ast.Position{
							Column: 9,
							Line:   178,
						},
					},
				},
				Name: "contains",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 66,
							Line:   178,
						},
						File:   "universe.flux",
						Source: "(value: A, set: [A]) => bool where A: Nullable",
						Start: ast.Position{
							Column: 20,
							Line:   178,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   178,
							},
							File:   "universe.flux",
							Source: "A: Nullable",
							Start: ast.Position{
								Column: 55,
								Line:   178,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   178,
								},
								File:   "universe.flux",
								Source: "Nullable",
								Start: ast.Position{
									Column: 58,
									Line:   178,
								},
							},
						},
						Name: "Nullable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   178,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 55,
									Line:   178,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   178,
							},
							File:   "universe.flux",
							Source: "(value: A, set: [A]) => bool",
							Start: ast.Position{
								Column: 20,
								Line:   178,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   178,
								},
								File:   "universe.flux",
								Source: "value: A",
								Start: ast.Position{
									Column: 21,
									Line:   178,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "value",
									Start: ast.Position{
										Column: 21,
										Line:   178,
									},
								},
							},
							Name: "value",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 28,
										Line:   178,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   178,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 28,
											Line:   178,
										},
									},
								},
								Name: "A",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   178,
								},
								File:   "universe.flux",
								Source: "set: [A]",
								Start: ast.Position{
									Column: 31,
									Line:   178,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "set",
									Start: ast.Position{
										Column: 31,
										Line:   178,
									},
								},
							},
							Name: "set",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 36,
										Line:   178,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   178,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 37,
											Line:   178,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   178,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 37,
												Line:   178,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   178,
								},
								File:   "universe.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 44,
									Line:   178,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   178,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 44,
										Line:   178,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// other builtins\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   181,
					},
					File:   "universe.flux",
					Source: "builtin inf",
					Start: ast.Position{
						Column: 1,
						Line:   181,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   181,
						},
						File:   "universe.flux",
						Source: "inf",
						Start: ast.Position{
							Column: 9,
							Line:   181,
						},
					},
				},
				Name: "inf",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 23,
							Line:   181,
						},
						File:   "universe.flux",
						Source: "duration",
						Start: ast.Position{
							Column: 15,
							Line:   181,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.NamedType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   181,
							},
							File:   "universe.flux",
							Source: "duration",
							Start: ast.Position{
								Column: 15,
								Line:   181,
							},
						},
					},
					ID: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   181,
								},
								File:   "universe.flux",
								Source: "duration",
								Start: ast.Position{
									Column: 15,
									Line:   181,
								},
							},
						},
						Name: "duration",
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   182,
					},
					File:   "universe.flux",
					Source: "builtin length",
					Start: ast.Position{
						Column: 1,
						Line:   182,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   182,
						},
						File:   "universe.flux",
						Source: "length",
						Start: ast.Position{
							Column: 9,
							Line:   182,
						},
					},
				},
				Name: "length",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 35,
							Line:   182,
						},
						File:   "universe.flux",
						Source: "(arr: [A]) => int",
						Start: ast.Position{
							Column: 18,
							Line:   182,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   182,
							},
							File:   "universe.flux",
							Source: "(arr: [A]) => int",
							Start: ast.Position{
								Column: 18,
								Line:   182,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   182,
								},
								File:   "universe.flux",
								Source: "arr: [A]",
								Start: ast.Position{
									Column: 19,
									Line:   182,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   182,
									},
									File:   "universe.flux",
									Source: "arr",
									Start: ast.Position{
										Column: 19,
										Line:   182,
									},
								},
							},
							Name: "arr",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   182,
									},
									File:   "universe.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 24,
										Line:   182,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   182,
										},
										File:   "universe.flux",
										Source: "A",
										Start: ast.Position{
											Column: 25,
											Line:   182,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   182,
											},
											File:   "universe.flux",
											Source: "A",
											Start: ast.Position{
												Column: 25,
												Line:   182,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   182,
								},
								File:   "universe.flux",
								Source: "int",
								Start: ast.Position{
									Column: 32,
									Line:   182,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   182,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 32,
										Line:   182,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   183,
					},
					File:   "universe.flux",
					Source: "builtin linearBins",
					Start: ast.Position{
						Column: 1,
						Line:   183,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   183,
						},
						File:   "universe.flux",
						Source: "linearBins",
						Start: ast.Position{
							Column: 9,
							Line:   183,
						},
					},
				},
				Name: "linearBins",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 90,
							Line:   183,
						},
						File:   "universe.flux",
						Source: "(start: float, width: float, count: int, ?infinity: bool) => [float]",
						Start: ast.Position{
							Column: 22,
							Line:   183,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 90,
								Line:   183,
							},
							File:   "universe.flux",
							Source: "(start: float, width: float, count: int, ?infinity: bool) => [float]",
							Start: ast.Position{
								Column: 22,
								Line:   183,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   183,
								},
								File:   "universe.flux",
								Source: "start: float",
								Start: ast.Position{
									Column: 23,
									Line:   183,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   183,
									},
									File:   "universe.flux",
									Source: "start",
									Start: ast.Position{
										Column: 23,
										Line:   183,
									},
								},
							},
							Name: "start",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   183,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 30,
										Line:   183,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 35,
											Line:   183,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 30,
											Line:   183,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   183,
								},
								File:   "universe.flux",
								Source: "width: float",
								Start: ast.Position{
									Column: 37,
									Line:   183,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   183,
									},
									File:   "universe.flux",
									Source: "width",
									Start: ast.Position{
										Column: 37,
										Line:   183,
									},
								},
							},
							Name: "width",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   183,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 44,
										Line:   183,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   183,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 44,
											Line:   183,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   183,
								},
								File:   "universe.flux",
								Source: "count: int",
								Start: ast.Position{
									Column: 51,
									Line:   183,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   183,
									},
									File:   "universe.flux",
									Source: "count",
									Start: ast.Position{
										Column: 51,
										Line:   183,
									},
								},
							},
							Name: "count",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 61,
										Line:   183,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 58,
										Line:   183,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 61,
											Line:   183,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 58,
											Line:   183,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   183,
								},
								File:   "universe.flux",
								Source: "?infinity: bool",
								Start: ast.Position{
									Column: 63,
									Line:   183,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   183,
									},
									File:   "universe.flux",
									Source: "infinity",
									Start: ast.Position{
										Column: 64,
										Line:   183,
									},
								},
							},
							Name: "infinity",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   183,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 74,
										Line:   183,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   183,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 74,
											Line:   183,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 90,
									Line:   183,
								},
								File:   "universe.flux",
								Source: "[float]",
								Start: ast.Position{
									Column: 83,
									Line:   183,
								},
							},
						},
						ElementType: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 89,
										Line:   183,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 84,
										Line:   183,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 89,
											Line:   183,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 84,
											Line:   183,
										},
									},
								},
								Name: "float",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   184,
					},
					File:   "universe.flux",
					Source: "builtin logarithmicBins",
					Start: ast.Position{
						Column: 1,
						Line:   184,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   184,
						},
						File:   "universe.flux",
						Source: "logarithmicBins",
						Start: ast.Position{
							Column: 9,
							Line:   184,
						},
					},
				},
				Name: "logarithmicBins",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 96,
							Line:   184,
						},
						File:   "universe.flux",
						Source: "(start: float, factor: float, count: int, ?infinity: bool) => [float]",
						Start: ast.Position{
							Column: 27,
							Line:   184,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 96,
								Line:   184,
							},
							File:   "universe.flux",
							Source: "(start: float, factor: float, count: int, ?infinity: bool) => [float]",
							Start: ast.Position{
								Column: 27,
								Line:   184,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   184,
								},
								File:   "universe.flux",
								Source: "start: float",
								Start: ast.Position{
									Column: 28,
									Line:   184,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   184,
									},
									File:   "universe.flux",
									Source: "start",
									Start: ast.Position{
										Column: 28,
										Line:   184,
									},
								},
							},
							Name: "start",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   184,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 35,
										Line:   184,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   184,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 35,
											Line:   184,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   184,
								},
								File:   "universe.flux",
								Source: "factor: float",
								Start: ast.Position{
									Column: 42,
									Line:   184,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   184,
									},
									File:   "universe.flux",
									Source: "factor",
									Start: ast.Position{
										Column: 42,
										Line:   184,
									},
								},
							},
							Name: "factor",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   184,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 50,
										Line:   184,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   184,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 50,
											Line:   184,
										},
									},
								},
								Name: "float",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   184,
								},
								File:   "universe.flux",
								Source: "count: int",
								Start: ast.Position{
									Column: 57,
									Line:   184,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   184,
									},
									File:   "universe.flux",
									Source: "count",
									Start: ast.Position{
										Column: 57,
										Line:   184,
									},
								},
							},
							Name: "count",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   184,
									},
									File:   "universe.flux",
									Source: "int",
									Start: ast.Position{
										Column: 64,
										Line:   184,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   184,
										},
										File:   "universe.flux",
										Source: "int",
										Start: ast.Position{
											Column: 64,
											Line:   184,
										},
									},
								},
								Name: "int",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   184,
								},
								File:   "universe.flux",
								Source: "?infinity: bool",
								Start: ast.Position{
									Column: 69,
									Line:   184,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   184,
									},
									File:   "universe.flux",
									Source: "infinity",
									Start: ast.Position{
										Column: 70,
										Line:   184,
									},
								},
							},
							Name: "infinity",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   184,
									},
									File:   "universe.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 80,
										Line:   184,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 84,
											Line:   184,
										},
										File:   "universe.flux",
										Source: "bool",
										Start: ast.Position{
											Column: 80,
											Line:   184,
										},
									},
								},
								Name: "bool",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 96,
									Line:   184,
								},
								File:   "universe.flux",
								Source: "[float]",
								Start: ast.Position{
									Column: 89,
									Line:   184,
								},
							},
						},
						ElementType: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 95,
										Line:   184,
									},
									File:   "universe.flux",
									Source: "float",
									Start: ast.Position{
										Column: 90,
										Line:   184,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 95,
											Line:   184,
										},
										File:   "universe.flux",
										Source: "float",
										Start: ast.Position{
											Column: 90,
											Line:   184,
										},
									},
								},
								Name: "float",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// die returns a fatal error from within a flux script\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   187,
					},
					File:   "universe.flux",
					Source: "builtin die",
					Start: ast.Position{
						Column: 1,
						Line:   187,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   187,
						},
						File:   "universe.flux",
						Source: "die",
						Start: ast.Position{
							Column: 9,
							Line:   187,
						},
					},
				},
				Name: "die",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 33,
							Line:   187,
						},
						File:   "universe.flux",
						Source: "(msg: string) => A",
						Start: ast.Position{
							Column: 15,
							Line:   187,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   187,
							},
							File:   "universe.flux",
							Source: "(msg: string) => A",
							Start: ast.Position{
								Column: 15,
								Line:   187,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   187,
								},
								File:   "universe.flux",
								Source: "msg: string",
								Start: ast.Position{
									Column: 16,
									Line:   187,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   187,
									},
									File:   "universe.flux",
									Source: "msg",
									Start: ast.Position{
										Column: 16,
										Line:   187,
									},
								},
							},
							Name: "msg",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   187,
									},
									File:   "universe.flux",
									Source: "string",
									Start: ast.Position{
										Column: 21,
										Line:   187,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   187,
										},
										File:   "universe.flux",
										Source: "string",
										Start: ast.Position{
											Column: 21,
											Line:   187,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.TvarType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   187,
								},
								File:   "universe.flux",
								Source: "A",
								Start: ast.Position{
									Column: 32,
									Line:   187,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   187,
									},
									File:   "universe.flux",
									Source: "A",
									Start: ast.Position{
										Column: 32,
										Line:   187,
									},
								},
							},
							Name: "A",
						},
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 124,
						Line:   192,
					},
					File:   "universe.flux",
					Source: "timeWeightedAvg = (tables=<-, unit) => tables\n    |> integral(unit: unit, interpolate: \"linear\")\n    |> map(fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))}))",
					Start: ast.Position{
						Column: 1,
						Line:   190,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Time weighted average where values at the beginning and end of the range are linearly interpolated.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   190,
						},
						File:   "universe.flux",
						Source: "timeWeightedAvg",
						Start: ast.Position{
							Column: 1,
							Line:   190,
						},
					},
				},
				Name: "timeWeightedAvg",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 124,
							Line:   192,
						},
						File:   "universe.flux",
						Source: "(tables=<-, unit) => tables\n    |> integral(unit: unit, interpolate: \"linear\")\n    |> map(fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))}))",
						Start: ast.Position{
							Column: 19,
							Line:   190,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   190,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 40,
										Line:   190,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   191,
								},
								File:   "universe.flux",
								Source: "tables\n    |> integral(unit: unit, interpolate: \"linear\")",
								Start: ast.Position{
									Column: 40,
									Line:   190,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   191,
										},
										File:   "universe.flux",
										Source: "unit: unit, interpolate: \"linear\"",
										Start: ast.Position{
											Column: 17,
											Line:   191,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   191,
											},
											File:   "universe.flux",
											Source: "unit: unit",
											Start: ast.Position{
												Column: 17,
												Line:   191,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   191,
												},
												File:   "universe.flux",
												Source: "unit",
												Start: ast.Position{
													Column: 17,
													Line:   191,
												},
											},
										},
										Name: "unit",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   191,
												},
												File:   "universe.flux",
												Source: "unit",
												Start: ast.Position{
													Column: 23,
													Line:   191,
												},
											},
										},
										Name: "unit",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   191,
											},
											File:   "universe.flux",
											Source: "interpolate: \"linear\"",
											Start: ast.Position{
												Column: 29,
												Line:   191,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   191,
												},
												File:   "universe.flux",
												Source: "interpolate",
												Start: ast.Position{
													Column: 29,
													Line:   191,
												},
											},
										},
										Name: "interpolate",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 50,
													Line:   191,
												},
												File:   "universe.flux",
												Source: "\"linear\"",
												Start: ast.Position{
													Column: 42,
													Line:   191,
												},
											},
										},
										Value: "linear",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 51,
										Line:   191,
									},
									File:   "universe.flux",
									Source: "integral(unit: unit, interpolate: \"linear\")",
									Start: ast.Position{
										Column: 8,
										Line:   191,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 16,
											Line:   191,
										},
										File:   "universe.flux",
										Source: "integral",
										Start: ast.Position{
											Column: 8,
											Line:   191,
										},
									},
								},
								Name: "integral",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 124,
								Line:   192,
							},
							File:   "universe.flux",
							Source: "tables\n    |> integral(unit: unit, interpolate: \"linear\")\n    |> map(fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))}))",
							Start: ast.Position{
								Column: 40,
								Line:   190,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 123,
										Line:   192,
									},
									File:   "universe.flux",
									Source: "fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))})",
									Start: ast.Position{
										Column: 12,
										Line:   192,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 123,
											Line:   192,
										},
										File:   "universe.flux",
										Source: "fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))})",
										Start: ast.Position{
											Column: 12,
											Line:   192,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   192,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   192,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 123,
												Line:   192,
											},
											File:   "universe.flux",
											Source: "(r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))})",
											Start: ast.Position{
												Column: 16,
												Line:   192,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 123,
													Line:   192,
												},
												File:   "universe.flux",
												Source: "({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))})",
												Start: ast.Position{
													Column: 23,
													Line:   192,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 122,
														Line:   192,
													},
													File:   "universe.flux",
													Source: "{r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))}",
													Start: ast.Position{
														Column: 24,
														Line:   192,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 121,
															Line:   192,
														},
														File:   "universe.flux",
														Source: "_value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))",
														Start: ast.Position{
															Column: 32,
															Line:   192,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   192,
															},
															File:   "universe.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   192,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 121,
																Line:   192,
															},
															File:   "universe.flux",
															Source: "r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))",
															Start: ast.Position{
																Column: 40,
																Line:   192,
															},
														},
													},
													Left: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 74,
																	Line:   192,
																},
																File:   "universe.flux",
																Source: "r._value * float(v: uint(v: unit))",
																Start: ast.Position{
																	Column: 40,
																	Line:   192,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 48,
																		Line:   192,
																	},
																	File:   "universe.flux",
																	Source: "r._value",
																	Start: ast.Position{
																		Column: 40,
																		Line:   192,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 41,
																			Line:   192,
																		},
																		File:   "universe.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 40,
																			Line:   192,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 48,
																			Line:   192,
																		},
																		File:   "universe.flux",
																		Source: "_value",
																		Start: ast.Position{
																			Column: 42,
																			Line:   192,
																		},
																	},
																},
																Name: "_value",
															},
															Rbrack: nil,
														},
														Operator: 1,
														Right: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 73,
																			Line:   192,
																		},
																		File:   "universe.flux",
																		Source: "v: uint(v: unit)",
																		Start: ast.Position{
																			Column: 57,
																			Line:   192,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 73,
																				Line:   192,
																			},
																			File:   "universe.flux",
																			Source: "v: uint(v: unit)",
																			Start: ast.Position{
																				Column: 57,
																				Line:   192,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 58,
																					Line:   192,
																				},
																				File:   "universe.flux",
																				Source: "v",
																				Start: ast.Position{
																					Column: 57,
																					Line:   192,
																				},
																			},
																		},
																		Name: "v",
																	},
																	Separator: nil,
																	Value: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 72,
																						Line:   192,
																					},
																					File:   "universe.flux",
																					Source: "v: unit",
																					Start: ast.Position{
																						Column: 65,
																						Line:   192,
																					},
																				},
																			},
																			Lbrace: nil,
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 72,
																							Line:   192,
																						},
																						File:   "universe.flux",
																						Source: "v: unit",
																						Start: ast.Position{
																							Column: 65,
																							Line:   192,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 66,
																								Line:   192,
																							},
																							File:   "universe.flux",
																							Source: "v",
																							Start: ast.Position{
																								Column: 65,
																								Line:   192,
																							},
																						},
																					},
																					Name: "v",
																				},
																				Separator: nil,
																				Value: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 72,
																								Line:   192,
																							},
																							File:   "universe.flux",
																							Source: "unit",
																							Start: ast.Position{
																								Column: 68,
																								Line:   192,
																							},
																						},
																					},
																					Name: "unit",
																				},
																			}},
																			Rbrace: nil,
																			With:   nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 73,
																					Line:   192,
																				},
																				File:   "universe.flux",
																				Source: "uint(v: unit)",
																				Start: ast.Position{
																					Column: 60,
																					Line:   192,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 64,
																						Line:   192,
																					},
																					File:   "universe.flux",
																					Source: "uint",
																					Start: ast.Position{
																						Column: 60,
																						Line:   192,
																					},
																				},
																			},
																			Name: "uint",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																}},
																Rbrace: nil,
																With:   nil,
															}},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 74,
																		Line:   192,
																	},
																	File:   "universe.flux",
																	Source: "float(v: uint(v: unit))",
																	Start: ast.Position{
																		Column: 51,
																		Line:   192,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 56,
																			Line:   192,
																		},
																		File:   "universe.flux",
																		Source: "float",
																		Start: ast.Position{
																			Column: 51,
																			Line:   192,
																		},
																	},
																},
																Name: "float",
															},
															Lparen: nil,
															Rparen: nil,
														},
													},
													Operator: 2,
													Right: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 120,
																		Line:   192,
																	},
																	File:   "universe.flux",
																	Source: "v: int(v: r._stop) - int(v: r._start)",
																	Start: ast.Position{
																		Column: 83,
																		Line:   192,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 120,
																			Line:   192,
																		},
																		File:   "universe.flux",
																		Source: "v: int(v: r._stop) - int(v: r._start)",
																		Start: ast.Position{
																			Column: 83,
																			Line:   192,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 84,
																				Line:   192,
																			},
																			File:   "universe.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 83,
																				Line:   192,
																			},
																		},
																	},
																	Name: "v",
																},
																Separator: nil,
																Value: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 120,
																				Line:   192,
																			},
																			File:   "universe.flux",
																			Source: "int(v: r._stop) - int(v: r._start)",
																			Start: ast.Position{
																				Column: 86,
																				Line:   192,
																			},
																		},
																	},
																	Left: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 100,
																						Line:   192,
																					},
																					File:   "universe.flux",
																					Source: "v: r._stop",
																					Start: ast.Position{
																						Column: 90,
																						Line:   192,
																					},
																				},
																			},
																			Lbrace: nil,
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 100,
																							Line:   192,
																						},
																						File:   "universe.flux",
																						Source: "v: r._stop",
																						Start: ast.Position{
																							Column: 90,
																							Line:   192,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 91,
																								Line:   192,
																							},
																							File:   "universe.flux",
																							Source: "v",
																							Start: ast.Position{
																								Column: 90,
																								Line:   192,
																							},
																						},
																					},
																					Name: "v",
																				},
																				Separator: nil,
																				Value: &ast.MemberExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 100,
																								Line:   192,
																							},
																							File:   "universe.flux",
																							Source: "r._stop",
																							Start: ast.Position{
																								Column: 93,
																								Line:   192,
																							},
																						},
																					},
																					Lbrack: nil,
																					Object: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 94,
																									Line:   192,
																								},
																								File:   "universe.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 93,
																									Line:   192,
																								},
																							},
																						},
																						Name: "r",
																					},
																					Property: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 100,
																									Line:   192,
																								},
																								File:   "universe.flux",
																								Source: "_stop",
																								Start: ast.Position{
																									Column: 95,
																									Line:   192,
																								},
																							},
																						},
																						Name: "_stop",
																					},
																					Rbrack: nil,
																				},
																			}},
																			Rbrace: nil,
																			With:   nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 101,
																					Line:   192,
																				},
																				File:   "universe.flux",
																				Source: "int(v: r._stop)",
																				Start: ast.Position{
																					Column: 86,
																					Line:   192,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 89,
																						Line:   192,
																					},
																					File:   "universe.flux",
																					Source: "int",
																					Start: ast.Position{
																						Column: 86,
																						Line:   192,
																					},
																				},
																			},
																			Name: "int",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																	Operator: 6,
																	Right: &ast.CallExpression{
																		Arguments: []ast.Expression{&ast.ObjectExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 119,
																						Line:   192,
																					},
																					File:   "universe.flux",
																					Source: "v: r._start",
																					Start: ast.Position{
																						Column: 108,
																						Line:   192,
																					},
																				},
																			},
																			Lbrace: nil,
																			Properties: []*ast.Property{&ast.Property{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 119,
																							Line:   192,
																						},
																						File:   "universe.flux",
																						Source: "v: r._start",
																						Start: ast.Position{
																							Column: 108,
																							Line:   192,
																						},
																					},
																				},
																				Comma: nil,
																				Key: &ast.Identifier{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 109,
																								Line:   192,
																							},
																							File:   "universe.flux",
																							Source: "v",
																							Start: ast.Position{
																								Column: 108,
																								Line:   192,
																							},
																						},
																					},
																					Name: "v",
																				},
																				Separator: nil,
																				Value: &ast.MemberExpression{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 119,
																								Line:   192,
																							},
																							File:   "universe.flux",
																							Source: "r._start",
																							Start: ast.Position{
																								Column: 111,
																								Line:   192,
																							},
																						},
																					},
																					Lbrack: nil,
																					Object: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 112,
																									Line:   192,
																								},
																								File:   "universe.flux",
																								Source: "r",
																								Start: ast.Position{
																									Column: 111,
																									Line:   192,
																								},
																							},
																						},
																						Name: "r",
																					},
																					Property: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 119,
																									Line:   192,
																								},
																								File:   "universe.flux",
																								Source: "_start",
																								Start: ast.Position{
																									Column: 113,
																									Line:   192,
																								},
																							},
																						},
																						Name: "_start",
																					},
																					Rbrack: nil,
																				},
																			}},
																			Rbrace: nil,
																			With:   nil,
																		}},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 120,
																					Line:   192,
																				},
																				File:   "universe.flux",
																				Source: "int(v: r._start)",
																				Start: ast.Position{
																					Column: 104,
																					Line:   192,
																				},
																			},
																		},
																		Callee: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 107,
																						Line:   192,
																					},
																					File:   "universe.flux",
																					Source: "int",
																					Start: ast.Position{
																						Column: 104,
																						Line:   192,
																					},
																				},
																			},
																			Name: "int",
																		},
																		Lparen: nil,
																		Rparen: nil,
																	},
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 121,
																	Line:   192,
																},
																File:   "universe.flux",
																Source: "float(v: int(v: r._stop) - int(v: r._start))",
																Start: ast.Position{
																	Column: 77,
																	Line:   192,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 82,
																		Line:   192,
																	},
																	File:   "universe.flux",
																	Source: "float",
																	Start: ast.Position{
																		Column: 77,
																		Line:   192,
																	},
																},
															},
															Name: "float",
														},
														Lparen: nil,
														Rparen: nil,
													},
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   192,
														},
														File:   "universe.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   192,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   192,
												},
												File:   "universe.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   192,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   192,
													},
													File:   "universe.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   192,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   192,
								},
								File:   "universe.flux",
								Source: "map(fn: (r) => ({r with _value: r._value * float(v: uint(v: unit)) / float(v: int(v: r._stop) - int(v: r._start))}))",
								Start: ast.Position{
									Column: 8,
									Line:   192,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   192,
									},
									File:   "universe.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   192,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   190,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 20,
								Line:   190,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   190,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 20,
									Line:   190,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   190,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   190,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   190,
							},
							File:   "universe.flux",
							Source: "unit",
							Start: ast.Position{
								Column: 31,
								Line:   190,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   190,
								},
								File:   "universe.flux",
								Source: "unit",
								Start: ast.Position{
									Column: 31,
									Line:   190,
								},
							},
						},
						Name: "unit",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 73,
						Line:   199,
					},
					File:   "universe.flux",
					Source: "cov = (x, y, on, pearsonr=false) => join(\n    tables: {x: x, y: y},\n    on: on,\n)\n    |> covariance(pearsonr: pearsonr, columns: [\"_value_x\", \"_value_y\"])",
					Start: ast.Position{
						Column: 1,
						Line:   195,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// covariance function with automatic join\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   195,
						},
						File:   "universe.flux",
						Source: "cov",
						Start: ast.Position{
							Column: 1,
							Line:   195,
						},
					},
				},
				Name: "cov",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 73,
							Line:   199,
						},
						File:   "universe.flux",
						Source: "(x, y, on, pearsonr=false) => join(\n    tables: {x: x, y: y},\n    on: on,\n)\n    |> covariance(pearsonr: pearsonr, columns: [\"_value_x\", \"_value_y\"])",
						Start: ast.Position{
							Column: 7,
							Line:   195,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   197,
									},
									File:   "universe.flux",
									Source: "tables: {x: x, y: y},\n    on: on",
									Start: ast.Position{
										Column: 5,
										Line:   196,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   196,
										},
										File:   "universe.flux",
										Source: "tables: {x: x, y: y}",
										Start: ast.Position{
											Column: 5,
											Line:   196,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   196,
											},
											File:   "universe.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 5,
												Line:   196,
											},
										},
									},
									Name: "tables",
								},
								Separator: nil,
								Value: &ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   196,
											},
											File:   "universe.flux",
											Source: "{x: x, y: y}",
											Start: ast.Position{
												Column: 13,
												Line:   196,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   196,
												},
												File:   "universe.flux",
												Source: "x: x",
												Start: ast.Position{
													Column: 14,
													Line:   196,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   196,
													},
													File:   "universe.flux",
													Source: "x",
													Start: ast.Position{
														Column: 14,
														Line:   196,
													},
												},
											},
											Name: "x",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   196,
													},
													File:   "universe.flux",
													Source: "x",
													Start: ast.Position{
														Column: 17,
														Line:   196,
													},
												},
											},
											Name: "x",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   196,
												},
												File:   "universe.flux",
												Source: "y: y",
												Start: ast.Position{
													Column: 20,
													Line:   196,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   196,
													},
													File:   "universe.flux",
													Source: "y",
													Start: ast.Position{
														Column: 20,
														Line:   196,
													},
												},
											},
											Name: "y",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   196,
													},
													File:   "universe.flux",
													Source: "y",
													Start: ast.Position{
														Column: 23,
														Line:   196,
													},
												},
											},
											Name: "y",
										},
									}},
									Rbrace: nil,
									With:   nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 11,
											Line:   197,
										},
										File:   "universe.flux",
										Source: "on: on",
										Start: ast.Position{
											Column: 5,
											Line:   197,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 7,
												Line:   197,
											},
											File:   "universe.flux",
											Source: "on",
											Start: ast.Position{
												Column: 5,
												Line:   197,
											},
										},
									},
									Name: "on",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   197,
											},
											File:   "universe.flux",
											Source: "on",
											Start: ast.Position{
												Column: 9,
												Line:   197,
											},
										},
									},
									Name: "on",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 2,
									Line:   198,
								},
								File:   "universe.flux",
								Source: "join(\n    tables: {x: x, y: y},\n    on: on,\n)",
								Start: ast.Position{
									Column: 37,
									Line:   195,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   195,
									},
									File:   "universe.flux",
									Source: "join",
									Start: ast.Position{
										Column: 37,
										Line:   195,
									},
								},
							},
							Name: "join",
						},
						Lparen: nil,
						Rparen: nil,
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 73,
								Line:   199,
							},
							File:   "universe.flux",
							Source: "join(\n    tables: {x: x, y: y},\n    on: on,\n)\n    |> covariance(pearsonr: pearsonr, columns: [\"_value_x\", \"_value_y\"])",
							Start: ast.Position{
								Column: 37,
								Line:   195,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 72,
										Line:   199,
									},
									File:   "universe.flux",
									Source: "pearsonr: pearsonr, columns: [\"_value_x\", \"_value_y\"]",
									Start: ast.Position{
										Column: 19,
										Line:   199,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   199,
										},
										File:   "universe.flux",
										Source: "pearsonr: pearsonr",
										Start: ast.Position{
											Column: 19,
											Line:   199,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   199,
											},
											File:   "universe.flux",
											Source: "pearsonr",
											Start: ast.Position{
												Column: 19,
												Line:   199,
											},
										},
									},
									Name: "pearsonr",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   199,
											},
											File:   "universe.flux",
											Source: "pearsonr",
											Start: ast.Position{
												Column: 29,
												Line:   199,
											},
										},
									},
									Name: "pearsonr",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   199,
										},
										File:   "universe.flux",
										Source: "columns: [\"_value_x\", \"_value_y\"]",
										Start: ast.Position{
											Column: 39,
											Line:   199,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   199,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 39,
												Line:   199,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   199,
											},
											File:   "universe.flux",
											Source: "[\"_value_x\", \"_value_y\"]",
											Start: ast.Position{
												Column: 48,
												Line:   199,
											},
										},
									},
									Elements: []ast.Expression{&ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   199,
												},
												File:   "universe.flux",
												Source: "\"_value_x\"",
												Start: ast.Position{
													Column: 49,
													Line:   199,
												},
											},
										},
										Value: "_value_x",
									}, &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   199,
												},
												File:   "universe.flux",
												Source: "\"_value_y\"",
												Start: ast.Position{
													Column: 61,
													Line:   199,
												},
											},
										},
										Value: "_value_y",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 73,
									Line:   199,
								},
								File:   "universe.flux",
								Source: "covariance(pearsonr: pearsonr, columns: [\"_value_x\", \"_value_y\"])",
								Start: ast.Position{
									Column: 8,
									Line:   199,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   199,
									},
									File:   "universe.flux",
									Source: "covariance",
									Start: ast.Position{
										Column: 8,
										Line:   199,
									},
								},
							},
							Name: "covariance",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   195,
							},
							File:   "universe.flux",
							Source: "x",
							Start: ast.Position{
								Column: 8,
								Line:   195,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   195,
								},
								File:   "universe.flux",
								Source: "x",
								Start: ast.Position{
									Column: 8,
									Line:   195,
								},
							},
						},
						Name: "x",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   195,
							},
							File:   "universe.flux",
							Source: "y",
							Start: ast.Position{
								Column: 11,
								Line:   195,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   195,
								},
								File:   "universe.flux",
								Source: "y",
								Start: ast.Position{
									Column: 11,
									Line:   195,
								},
							},
						},
						Name: "y",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   195,
							},
							File:   "universe.flux",
							Source: "on",
							Start: ast.Position{
								Column: 14,
								Line:   195,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   195,
								},
								File:   "universe.flux",
								Source: "on",
								Start: ast.Position{
									Column: 14,
									Line:   195,
								},
							},
						},
						Name: "on",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   195,
							},
							File:   "universe.flux",
							Source: "pearsonr=false",
							Start: ast.Position{
								Column: 18,
								Line:   195,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   195,
								},
								File:   "universe.flux",
								Source: "pearsonr",
								Start: ast.Position{
									Column: 18,
									Line:   195,
								},
							},
						},
						Name: "pearsonr",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   195,
								},
								File:   "universe.flux",
								Source: "false",
								Start: ast.Position{
									Column: 27,
									Line:   195,
								},
							},
						},
						Name: "false",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 65,
						Line:   200,
					},
					File:   "universe.flux",
					Source: "pearsonr = (x, y, on) => cov(x: x, y: y, on: on, pearsonr: true)",
					Start: ast.Position{
						Column: 1,
						Line:   200,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   200,
						},
						File:   "universe.flux",
						Source: "pearsonr",
						Start: ast.Position{
							Column: 1,
							Line:   200,
						},
					},
				},
				Name: "pearsonr",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 65,
							Line:   200,
						},
						File:   "universe.flux",
						Source: "(x, y, on) => cov(x: x, y: y, on: on, pearsonr: true)",
						Start: ast.Position{
							Column: 12,
							Line:   200,
						},
					},
				},
				Body: &ast.CallExpression{
					Arguments: []ast.Expression{&ast.ObjectExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   200,
								},
								File:   "universe.flux",
								Source: "x: x, y: y, on: on, pearsonr: true",
								Start: ast.Position{
									Column: 30,
									Line:   200,
								},
							},
						},
						Lbrace: nil,
						Properties: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   200,
									},
									File:   "universe.flux",
									Source: "x: x",
									Start: ast.Position{
										Column: 30,
										Line:   200,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   200,
										},
										File:   "universe.flux",
										Source: "x",
										Start: ast.Position{
											Column: 30,
											Line:   200,
										},
									},
								},
								Name: "x",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   200,
										},
										File:   "universe.flux",
										Source: "x",
										Start: ast.Position{
											Column: 33,
											Line:   200,
										},
									},
								},
								Name: "x",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   200,
									},
									File:   "universe.flux",
									Source: "y: y",
									Start: ast.Position{
										Column: 36,
										Line:   200,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   200,
										},
										File:   "universe.flux",
										Source: "y",
										Start: ast.Position{
											Column: 36,
											Line:   200,
										},
									},
								},
								Name: "y",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   200,
										},
										File:   "universe.flux",
										Source: "y",
										Start: ast.Position{
											Column: 39,
											Line:   200,
										},
									},
								},
								Name: "y",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   200,
									},
									File:   "universe.flux",
									Source: "on: on",
									Start: ast.Position{
										Column: 42,
										Line:   200,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   200,
										},
										File:   "universe.flux",
										Source: "on",
										Start: ast.Position{
											Column: 42,
											Line:   200,
										},
									},
								},
								Name: "on",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   200,
										},
										File:   "universe.flux",
										Source: "on",
										Start: ast.Position{
											Column: 46,
											Line:   200,
										},
									},
								},
								Name: "on",
							},
						}, &ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   200,
									},
									File:   "universe.flux",
									Source: "pearsonr: true",
									Start: ast.Position{
										Column: 50,
										Line:   200,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 58,
											Line:   200,
										},
										File:   "universe.flux",
										Source: "pearsonr",
										Start: ast.Position{
											Column: 50,
											Line:   200,
										},
									},
								},
								Name: "pearsonr",
							},
							Separator: nil,
							Value: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   200,
										},
										File:   "universe.flux",
										Source: "true",
										Start: ast.Position{
											Column: 60,
											Line:   200,
										},
									},
								},
								Name: "true",
							},
						}},
						Rbrace: nil,
						With:   nil,
					}},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   200,
							},
							File:   "universe.flux",
							Source: "cov(x: x, y: y, on: on, pearsonr: true)",
							Start: ast.Position{
								Column: 26,
								Line:   200,
							},
						},
					},
					Callee: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   200,
								},
								File:   "universe.flux",
								Source: "cov",
								Start: ast.Position{
									Column: 26,
									Line:   200,
								},
							},
						},
						Name: "cov",
					},
					Lparen: nil,
					Rparen: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   200,
							},
							File:   "universe.flux",
							Source: "x",
							Start: ast.Position{
								Column: 13,
								Line:   200,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   200,
								},
								File:   "universe.flux",
								Source: "x",
								Start: ast.Position{
									Column: 13,
									Line:   200,
								},
							},
						},
						Name: "x",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   200,
							},
							File:   "universe.flux",
							Source: "y",
							Start: ast.Position{
								Column: 16,
								Line:   200,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   200,
								},
								File:   "universe.flux",
								Source: "y",
								Start: ast.Position{
									Column: 16,
									Line:   200,
								},
							},
						},
						Name: "y",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   200,
							},
							File:   "universe.flux",
							Source: "on",
							Start: ast.Position{
								Column: 19,
								Line:   200,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   200,
								},
								File:   "universe.flux",
								Source: "on",
								Start: ast.Position{
									Column: 19,
									Line:   200,
								},
							},
						},
						Name: "on",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 11,
						Line:   206,
					},
					File:   "universe.flux",
					Source: "_fillEmpty = (tables=<-, createEmpty) => if createEmpty then\n    tables\n        |> table.fill()\nelse\n    tables",
					Start: ast.Position{
						Column: 1,
						Line:   202,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   202,
						},
						File:   "universe.flux",
						Source: "_fillEmpty",
						Start: ast.Position{
							Column: 1,
							Line:   202,
						},
					},
				},
				Name: "_fillEmpty",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   206,
						},
						File:   "universe.flux",
						Source: "(tables=<-, createEmpty) => if createEmpty then\n    tables\n        |> table.fill()\nelse\n    tables",
						Start: ast.Position{
							Column: 14,
							Line:   202,
						},
					},
				},
				Body: &ast.ConditionalExpression{
					Alternate: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   206,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 5,
									Line:   206,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   206,
							},
							File:   "universe.flux",
							Source: "if createEmpty then\n    tables\n        |> table.fill()\nelse\n    tables",
							Start: ast.Position{
								Column: 42,
								Line:   202,
							},
						},
					},
					Consequent: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   203,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 5,
										Line:   203,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   204,
								},
								File:   "universe.flux",
								Source: "tables\n        |> table.fill()",
								Start: ast.Position{
									Column: 5,
									Line:   203,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: nil,
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   204,
									},
									File:   "universe.flux",
									Source: "table.fill()",
									Start: ast.Position{
										Column: 12,
										Line:   204,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   204,
										},
										File:   "universe.flux",
										Source: "table.fill",
										Start: ast.Position{
											Column: 12,
											Line:   204,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   204,
											},
											File:   "universe.flux",
											Source: "table",
											Start: ast.Position{
												Column: 12,
												Line:   204,
											},
										},
									},
									Name: "table",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   204,
											},
											File:   "universe.flux",
											Source: "fill",
											Start: ast.Position{
												Column: 18,
												Line:   204,
											},
										},
									},
									Name: "fill",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					Test: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   202,
								},
								File:   "universe.flux",
								Source: "createEmpty",
								Start: ast.Position{
									Column: 45,
									Line:   202,
								},
							},
						},
						Name: "createEmpty",
					},
					Tk_else: nil,
					Tk_if:   nil,
					Tk_then: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   202,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 15,
								Line:   202,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   202,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 15,
									Line:   202,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   202,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   202,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   202,
							},
							File:   "universe.flux",
							Source: "createEmpty",
							Start: ast.Position{
								Column: 26,
								Line:   202,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   202,
								},
								File:   "universe.flux",
								Source: "createEmpty",
								Start: ast.Position{
									Column: 26,
									Line:   202,
								},
							},
						},
						Name: "createEmpty",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 47,
						Line:   225,
					},
					File:   "universe.flux",
					Source: "aggregateWindow = (\n        every,\n        fn,\n        offset=0s,\n        column=\"_value\",\n        timeSrc=\"_stop\",\n        timeDst=\"_time\",\n        createEmpty=true,\n        tables=<-,\n) => tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)\n    |> _fillEmpty(createEmpty: createEmpty)\n    |> duplicate(column: timeSrc, as: timeDst)\n    |> window(every: inf, timeColumn: timeDst)",
					Start: ast.Position{
						Column: 1,
						Line:   211,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// aggregateWindow applies an aggregate function to fixed windows of time.\n"}, ast.Comment{Text: "// The procedure is to window the data, perform an aggregate operation,\n"}, ast.Comment{Text: "// and then undo the windowing to produce an output table for every input table.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   211,
						},
						File:   "universe.flux",
						Source: "aggregateWindow",
						Start: ast.Position{
							Column: 1,
							Line:   211,
						},
					},
				},
				Name: "aggregateWindow",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 47,
							Line:   225,
						},
						File:   "universe.flux",
						Source: "(\n        every,\n        fn,\n        offset=0s,\n        column=\"_value\",\n        timeSrc=\"_stop\",\n        timeDst=\"_time\",\n        createEmpty=true,\n        tables=<-,\n) => tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)\n    |> _fillEmpty(createEmpty: createEmpty)\n    |> duplicate(column: timeSrc, as: timeDst)\n    |> window(every: inf, timeColumn: timeDst)",
						Start: ast.Position{
							Column: 19,
							Line:   211,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   220,
												},
												File:   "universe.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 6,
													Line:   220,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   221,
											},
											File:   "universe.flux",
											Source: "tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)",
											Start: ast.Position{
												Column: 6,
												Line:   220,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   221,
													},
													File:   "universe.flux",
													Source: "every: every, offset: offset, createEmpty: createEmpty",
													Start: ast.Position{
														Column: 15,
														Line:   221,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 27,
															Line:   221,
														},
														File:   "universe.flux",
														Source: "every: every",
														Start: ast.Position{
															Column: 15,
															Line:   221,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 20,
																Line:   221,
															},
															File:   "universe.flux",
															Source: "every",
															Start: ast.Position{
																Column: 15,
																Line:   221,
															},
														},
													},
													Name: "every",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   221,
															},
															File:   "universe.flux",
															Source: "every",
															Start: ast.Position{
																Column: 22,
																Line:   221,
															},
														},
													},
													Name: "every",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 43,
															Line:   221,
														},
														File:   "universe.flux",
														Source: "offset: offset",
														Start: ast.Position{
															Column: 29,
															Line:   221,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   221,
															},
															File:   "universe.flux",
															Source: "offset",
															Start: ast.Position{
																Column: 29,
																Line:   221,
															},
														},
													},
													Name: "offset",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 43,
																Line:   221,
															},
															File:   "universe.flux",
															Source: "offset",
															Start: ast.Position{
																Column: 37,
																Line:   221,
															},
														},
													},
													Name: "offset",
												},
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   221,
														},
														File:   "universe.flux",
														Source: "createEmpty: createEmpty",
														Start: ast.Position{
															Column: 45,
															Line:   221,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 56,
																Line:   221,
															},
															File:   "universe.flux",
															Source: "createEmpty",
															Start: ast.Position{
																Column: 45,
																Line:   221,
															},
														},
													},
													Name: "createEmpty",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 69,
																Line:   221,
															},
															File:   "universe.flux",
															Source: "createEmpty",
															Start: ast.Position{
																Column: 58,
																Line:   221,
															},
														},
													},
													Name: "createEmpty",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   221,
												},
												File:   "universe.flux",
												Source: "window(every: every, offset: offset, createEmpty: createEmpty)",
												Start: ast.Position{
													Column: 8,
													Line:   221,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   221,
													},
													File:   "universe.flux",
													Source: "window",
													Start: ast.Position{
														Column: 8,
														Line:   221,
													},
												},
											},
											Name: "window",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 26,
											Line:   222,
										},
										File:   "universe.flux",
										Source: "tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)",
										Start: ast.Position{
											Column: 6,
											Line:   220,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   222,
												},
												File:   "universe.flux",
												Source: "column: column",
												Start: ast.Position{
													Column: 11,
													Line:   222,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   222,
													},
													File:   "universe.flux",
													Source: "column: column",
													Start: ast.Position{
														Column: 11,
														Line:   222,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   222,
														},
														File:   "universe.flux",
														Source: "column",
														Start: ast.Position{
															Column: 11,
															Line:   222,
														},
													},
												},
												Name: "column",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   222,
														},
														File:   "universe.flux",
														Source: "column",
														Start: ast.Position{
															Column: 19,
															Line:   222,
														},
													},
												},
												Name: "column",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   222,
											},
											File:   "universe.flux",
											Source: "fn(column: column)",
											Start: ast.Position{
												Column: 8,
												Line:   222,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   222,
												},
												File:   "universe.flux",
												Source: "fn",
												Start: ast.Position{
													Column: 8,
													Line:   222,
												},
											},
										},
										Name: "fn",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   223,
									},
									File:   "universe.flux",
									Source: "tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)\n    |> _fillEmpty(createEmpty: createEmpty)",
									Start: ast.Position{
										Column: 6,
										Line:   220,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   223,
											},
											File:   "universe.flux",
											Source: "createEmpty: createEmpty",
											Start: ast.Position{
												Column: 19,
												Line:   223,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   223,
												},
												File:   "universe.flux",
												Source: "createEmpty: createEmpty",
												Start: ast.Position{
													Column: 19,
													Line:   223,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   223,
													},
													File:   "universe.flux",
													Source: "createEmpty",
													Start: ast.Position{
														Column: 19,
														Line:   223,
													},
												},
											},
											Name: "createEmpty",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   223,
													},
													File:   "universe.flux",
													Source: "createEmpty",
													Start: ast.Position{
														Column: 32,
														Line:   223,
													},
												},
											},
											Name: "createEmpty",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   223,
										},
										File:   "universe.flux",
										Source: "_fillEmpty(createEmpty: createEmpty)",
										Start: ast.Position{
											Column: 8,
											Line:   223,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   223,
											},
											File:   "universe.flux",
											Source: "_fillEmpty",
											Start: ast.Position{
												Column: 8,
												Line:   223,
											},
										},
									},
									Name: "_fillEmpty",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   224,
								},
								File:   "universe.flux",
								Source: "tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)\n    |> _fillEmpty(createEmpty: createEmpty)\n    |> duplicate(column: timeSrc, as: timeDst)",
								Start: ast.Position{
									Column: 6,
									Line:   220,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   224,
										},
										File:   "universe.flux",
										Source: "column: timeSrc, as: timeDst",
										Start: ast.Position{
											Column: 18,
											Line:   224,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   224,
											},
											File:   "universe.flux",
											Source: "column: timeSrc",
											Start: ast.Position{
												Column: 18,
												Line:   224,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   224,
												},
												File:   "universe.flux",
												Source: "column",
												Start: ast.Position{
													Column: 18,
													Line:   224,
												},
											},
										},
										Name: "column",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   224,
												},
												File:   "universe.flux",
												Source: "timeSrc",
												Start: ast.Position{
													Column: 26,
													Line:   224,
												},
											},
										},
										Name: "timeSrc",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   224,
											},
											File:   "universe.flux",
											Source: "as: timeDst",
											Start: ast.Position{
												Column: 35,
												Line:   224,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   224,
												},
												File:   "universe.flux",
												Source: "as",
												Start: ast.Position{
													Column: 35,
													Line:   224,
												},
											},
										},
										Name: "as",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   224,
												},
												File:   "universe.flux",
												Source: "timeDst",
												Start: ast.Position{
													Column: 39,
													Line:   224,
												},
											},
										},
										Name: "timeDst",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   224,
									},
									File:   "universe.flux",
									Source: "duplicate(column: timeSrc, as: timeDst)",
									Start: ast.Position{
										Column: 8,
										Line:   224,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   224,
										},
										File:   "universe.flux",
										Source: "duplicate",
										Start: ast.Position{
											Column: 8,
											Line:   224,
										},
									},
								},
								Name: "duplicate",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 47,
								Line:   225,
							},
							File:   "universe.flux",
							Source: "tables\n    |> window(every: every, offset: offset, createEmpty: createEmpty)\n    |> fn(column: column)\n    |> _fillEmpty(createEmpty: createEmpty)\n    |> duplicate(column: timeSrc, as: timeDst)\n    |> window(every: inf, timeColumn: timeDst)",
							Start: ast.Position{
								Column: 6,
								Line:   220,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 46,
										Line:   225,
									},
									File:   "universe.flux",
									Source: "every: inf, timeColumn: timeDst",
									Start: ast.Position{
										Column: 15,
										Line:   225,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   225,
										},
										File:   "universe.flux",
										Source: "every: inf",
										Start: ast.Position{
											Column: 15,
											Line:   225,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   225,
											},
											File:   "universe.flux",
											Source: "every",
											Start: ast.Position{
												Column: 15,
												Line:   225,
											},
										},
									},
									Name: "every",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   225,
											},
											File:   "universe.flux",
											Source: "inf",
											Start: ast.Position{
												Column: 22,
												Line:   225,
											},
										},
									},
									Name: "inf",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 46,
											Line:   225,
										},
										File:   "universe.flux",
										Source: "timeColumn: timeDst",
										Start: ast.Position{
											Column: 27,
											Line:   225,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   225,
											},
											File:   "universe.flux",
											Source: "timeColumn",
											Start: ast.Position{
												Column: 27,
												Line:   225,
											},
										},
									},
									Name: "timeColumn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   225,
											},
											File:   "universe.flux",
											Source: "timeDst",
											Start: ast.Position{
												Column: 39,
												Line:   225,
											},
										},
									},
									Name: "timeDst",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   225,
								},
								File:   "universe.flux",
								Source: "window(every: inf, timeColumn: timeDst)",
								Start: ast.Position{
									Column: 8,
									Line:   225,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 14,
										Line:   225,
									},
									File:   "universe.flux",
									Source: "window",
									Start: ast.Position{
										Column: 8,
										Line:   225,
									},
								},
							},
							Name: "window",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   212,
							},
							File:   "universe.flux",
							Source: "every",
							Start: ast.Position{
								Column: 9,
								Line:   212,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   212,
								},
								File:   "universe.flux",
								Source: "every",
								Start: ast.Position{
									Column: 9,
									Line:   212,
								},
							},
						},
						Name: "every",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   213,
							},
							File:   "universe.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 9,
								Line:   213,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   213,
								},
								File:   "universe.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 9,
									Line:   213,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   214,
							},
							File:   "universe.flux",
							Source: "offset=0s",
							Start: ast.Position{
								Column: 9,
								Line:   214,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   214,
								},
								File:   "universe.flux",
								Source: "offset",
								Start: ast.Position{
									Column: 9,
									Line:   214,
								},
							},
						},
						Name: "offset",
					},
					Separator: nil,
					Value: &ast.DurationLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   214,
								},
								File:   "universe.flux",
								Source: "0s",
								Start: ast.Position{
									Column: 16,
									Line:   214,
								},
							},
						},
						Values: []ast.Duration{ast.Duration{
							Magnitude: int64(0),
							Unit:      "s",
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   215,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 9,
								Line:   215,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   215,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 9,
									Line:   215,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   215,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 16,
									Line:   215,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   216,
							},
							File:   "universe.flux",
							Source: "timeSrc=\"_stop\"",
							Start: ast.Position{
								Column: 9,
								Line:   216,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   216,
								},
								File:   "universe.flux",
								Source: "timeSrc",
								Start: ast.Position{
									Column: 9,
									Line:   216,
								},
							},
						},
						Name: "timeSrc",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   216,
								},
								File:   "universe.flux",
								Source: "\"_stop\"",
								Start: ast.Position{
									Column: 17,
									Line:   216,
								},
							},
						},
						Value: "_stop",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   217,
							},
							File:   "universe.flux",
							Source: "timeDst=\"_time\"",
							Start: ast.Position{
								Column: 9,
								Line:   217,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   217,
								},
								File:   "universe.flux",
								Source: "timeDst",
								Start: ast.Position{
									Column: 9,
									Line:   217,
								},
							},
						},
						Name: "timeDst",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   217,
								},
								File:   "universe.flux",
								Source: "\"_time\"",
								Start: ast.Position{
									Column: 17,
									Line:   217,
								},
							},
						},
						Value: "_time",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   218,
							},
							File:   "universe.flux",
							Source: "createEmpty=true",
							Start: ast.Position{
								Column: 9,
								Line:   218,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 20,
									Line:   218,
								},
								File:   "universe.flux",
								Source: "createEmpty",
								Start: ast.Position{
									Column: 9,
									Line:   218,
								},
							},
						},
						Name: "createEmpty",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   218,
								},
								File:   "universe.flux",
								Source: "true",
								Start: ast.Position{
									Column: 21,
									Line:   218,
								},
							},
						},
						Name: "true",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   219,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 9,
								Line:   219,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   219,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 9,
									Line:   219,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   219,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   219,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 39,
						Line:   233,
					},
					File:   "universe.flux",
					Source: "increase = (tables=<-, columns=[\"_value\"]) => tables\n    |> difference(nonNegative: true, columns: columns)\n    |> cumulativeSum(columns: columns)",
					Start: ast.Position{
						Column: 1,
						Line:   231,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Increase returns the total non-negative difference between values in a table.\n"}, ast.Comment{Text: "// A main usage case is tracking changes in counter values which may wrap over time when they hit\n"}, ast.Comment{Text: "// a threshold or are reset. In the case of a wrap/reset,\n"}, ast.Comment{Text: "// we can assume that the absolute delta between two points will be at least their non-negative difference.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   231,
						},
						File:   "universe.flux",
						Source: "increase",
						Start: ast.Position{
							Column: 1,
							Line:   231,
						},
					},
				},
				Name: "increase",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 39,
							Line:   233,
						},
						File:   "universe.flux",
						Source: "(tables=<-, columns=[\"_value\"]) => tables\n    |> difference(nonNegative: true, columns: columns)\n    |> cumulativeSum(columns: columns)",
						Start: ast.Position{
							Column: 12,
							Line:   231,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   231,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 47,
										Line:   231,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   232,
								},
								File:   "universe.flux",
								Source: "tables\n    |> difference(nonNegative: true, columns: columns)",
								Start: ast.Position{
									Column: 47,
									Line:   231,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   232,
										},
										File:   "universe.flux",
										Source: "nonNegative: true, columns: columns",
										Start: ast.Position{
											Column: 19,
											Line:   232,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   232,
											},
											File:   "universe.flux",
											Source: "nonNegative: true",
											Start: ast.Position{
												Column: 19,
												Line:   232,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   232,
												},
												File:   "universe.flux",
												Source: "nonNegative",
												Start: ast.Position{
													Column: 19,
													Line:   232,
												},
											},
										},
										Name: "nonNegative",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 36,
													Line:   232,
												},
												File:   "universe.flux",
												Source: "true",
												Start: ast.Position{
													Column: 32,
													Line:   232,
												},
											},
										},
										Name: "true",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   232,
											},
											File:   "universe.flux",
											Source: "columns: columns",
											Start: ast.Position{
												Column: 38,
												Line:   232,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 45,
													Line:   232,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 38,
													Line:   232,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   232,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 47,
													Line:   232,
												},
											},
										},
										Name: "columns",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   232,
									},
									File:   "universe.flux",
									Source: "difference(nonNegative: true, columns: columns)",
									Start: ast.Position{
										Column: 8,
										Line:   232,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   232,
										},
										File:   "universe.flux",
										Source: "difference",
										Start: ast.Position{
											Column: 8,
											Line:   232,
										},
									},
								},
								Name: "difference",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 39,
								Line:   233,
							},
							File:   "universe.flux",
							Source: "tables\n    |> difference(nonNegative: true, columns: columns)\n    |> cumulativeSum(columns: columns)",
							Start: ast.Position{
								Column: 47,
								Line:   231,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   233,
									},
									File:   "universe.flux",
									Source: "columns: columns",
									Start: ast.Position{
										Column: 22,
										Line:   233,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   233,
										},
										File:   "universe.flux",
										Source: "columns: columns",
										Start: ast.Position{
											Column: 22,
											Line:   233,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   233,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 22,
												Line:   233,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   233,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 31,
												Line:   233,
											},
										},
									},
									Name: "columns",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   233,
								},
								File:   "universe.flux",
								Source: "cumulativeSum(columns: columns)",
								Start: ast.Position{
									Column: 8,
									Line:   233,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   233,
									},
									File:   "universe.flux",
									Source: "cumulativeSum",
									Start: ast.Position{
										Column: 8,
										Line:   233,
									},
								},
							},
							Name: "cumulativeSum",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   231,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 13,
								Line:   231,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   231,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 13,
									Line:   231,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   231,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 20,
								Line:   231,
							},
						},
					}},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   231,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 24,
								Line:   231,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   231,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 24,
									Line:   231,
								},
							},
						},
						Name: "columns",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   231,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 32,
									Line:   231,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   231,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 33,
										Line:   231,
									},
								},
							},
							Value: "_value",
						}},
						Lbrack: nil,
						Rbrack: nil,
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 82,
						Line:   237,
					},
					File:   "universe.flux",
					Source: "median = (method=\"estimate_tdigest\", compression=0.0, column=\"_value\", tables=<-) => tables\n    |> quantile(q: 0.5, method: method, compression: compression, column: column)",
					Start: ast.Position{
						Column: 1,
						Line:   236,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// median returns the 50th percentile.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   236,
						},
						File:   "universe.flux",
						Source: "median",
						Start: ast.Position{
							Column: 1,
							Line:   236,
						},
					},
				},
				Name: "median",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 82,
							Line:   237,
						},
						File:   "universe.flux",
						Source: "(method=\"estimate_tdigest\", compression=0.0, column=\"_value\", tables=<-) => tables\n    |> quantile(q: 0.5, method: method, compression: compression, column: column)",
						Start: ast.Position{
							Column: 10,
							Line:   236,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 92,
									Line:   236,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 86,
									Line:   236,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   237,
							},
							File:   "universe.flux",
							Source: "tables\n    |> quantile(q: 0.5, method: method, compression: compression, column: column)",
							Start: ast.Position{
								Column: 86,
								Line:   236,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   237,
									},
									File:   "universe.flux",
									Source: "q: 0.5, method: method, compression: compression, column: column",
									Start: ast.Position{
										Column: 17,
										Line:   237,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   237,
										},
										File:   "universe.flux",
										Source: "q: 0.5",
										Start: ast.Position{
											Column: 17,
											Line:   237,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   237,
											},
											File:   "universe.flux",
											Source: "q",
											Start: ast.Position{
												Column: 17,
												Line:   237,
											},
										},
									},
									Name: "q",
								},
								Separator: nil,
								Value: &ast.FloatLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   237,
											},
											File:   "universe.flux",
											Source: "0.5",
											Start: ast.Position{
												Column: 20,
												Line:   237,
											},
										},
									},
									Value: 0.5,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   237,
										},
										File:   "universe.flux",
										Source: "method: method",
										Start: ast.Position{
											Column: 25,
											Line:   237,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 31,
												Line:   237,
											},
											File:   "universe.flux",
											Source: "method",
											Start: ast.Position{
												Column: 25,
												Line:   237,
											},
										},
									},
									Name: "method",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   237,
											},
											File:   "universe.flux",
											Source: "method",
											Start: ast.Position{
												Column: 33,
												Line:   237,
											},
										},
									},
									Name: "method",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   237,
										},
										File:   "universe.flux",
										Source: "compression: compression",
										Start: ast.Position{
											Column: 41,
											Line:   237,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 52,
												Line:   237,
											},
											File:   "universe.flux",
											Source: "compression",
											Start: ast.Position{
												Column: 41,
												Line:   237,
											},
										},
									},
									Name: "compression",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   237,
											},
											File:   "universe.flux",
											Source: "compression",
											Start: ast.Position{
												Column: 54,
												Line:   237,
											},
										},
									},
									Name: "compression",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   237,
										},
										File:   "universe.flux",
										Source: "column: column",
										Start: ast.Position{
											Column: 67,
											Line:   237,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   237,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 67,
												Line:   237,
											},
										},
									},
									Name: "column",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   237,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 75,
												Line:   237,
											},
										},
									},
									Name: "column",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   237,
								},
								File:   "universe.flux",
								Source: "quantile(q: 0.5, method: method, compression: compression, column: column)",
								Start: ast.Position{
									Column: 8,
									Line:   237,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   237,
									},
									File:   "universe.flux",
									Source: "quantile",
									Start: ast.Position{
										Column: 8,
										Line:   237,
									},
								},
							},
							Name: "quantile",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   236,
							},
							File:   "universe.flux",
							Source: "method=\"estimate_tdigest\"",
							Start: ast.Position{
								Column: 11,
								Line:   236,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   236,
								},
								File:   "universe.flux",
								Source: "method",
								Start: ast.Position{
									Column: 11,
									Line:   236,
								},
							},
						},
						Name: "method",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   236,
								},
								File:   "universe.flux",
								Source: "\"estimate_tdigest\"",
								Start: ast.Position{
									Column: 18,
									Line:   236,
								},
							},
						},
						Value: "estimate_tdigest",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   236,
							},
							File:   "universe.flux",
							Source: "compression=0.0",
							Start: ast.Position{
								Column: 38,
								Line:   236,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   236,
								},
								File:   "universe.flux",
								Source: "compression",
								Start: ast.Position{
									Column: 38,
									Line:   236,
								},
							},
						},
						Name: "compression",
					},
					Separator: nil,
					Value: &ast.FloatLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   236,
								},
								File:   "universe.flux",
								Source: "0.0",
								Start: ast.Position{
									Column: 50,
									Line:   236,
								},
							},
						},
						Value: 0.0,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   236,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 55,
								Line:   236,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   236,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 55,
									Line:   236,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   236,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 62,
									Line:   236,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   236,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 72,
								Line:   236,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   236,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 72,
									Line:   236,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   236,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 79,
								Line:   236,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 50,
						Line:   249,
					},
					File:   "universe.flux",
					Source: "stateCount = (fn, column=\"stateCount\", tables=<-) => tables\n    |> stateTracking(countColumn: column, fn: fn)",
					Start: ast.Position{
						Column: 1,
						Line:   248,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// stateCount computes the number of consecutive records in a given state.\n"}, ast.Comment{Text: "// The state is defined via the function fn. For each consecutive point for\n"}, ast.Comment{Text: "// which the expression evaluates as true, the state count will be incremented\n"}, ast.Comment{Text: "// When a point evaluates as false, the state count is reset.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// The state count will be added as an additional column to each record. If the\n"}, ast.Comment{Text: "// expression evaluates as false, the value will be -1. If the expression\n"}, ast.Comment{Text: "// generates an error during evaluation, the point is discarded, and does not\n"}, ast.Comment{Text: "// affect the state count.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   248,
						},
						File:   "universe.flux",
						Source: "stateCount",
						Start: ast.Position{
							Column: 1,
							Line:   248,
						},
					},
				},
				Name: "stateCount",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 50,
							Line:   249,
						},
						File:   "universe.flux",
						Source: "(fn, column=\"stateCount\", tables=<-) => tables\n    |> stateTracking(countColumn: column, fn: fn)",
						Start: ast.Position{
							Column: 14,
							Line:   248,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   248,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 54,
									Line:   248,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   249,
							},
							File:   "universe.flux",
							Source: "tables\n    |> stateTracking(countColumn: column, fn: fn)",
							Start: ast.Position{
								Column: 54,
								Line:   248,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   249,
									},
									File:   "universe.flux",
									Source: "countColumn: column, fn: fn",
									Start: ast.Position{
										Column: 22,
										Line:   249,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   249,
										},
										File:   "universe.flux",
										Source: "countColumn: column",
										Start: ast.Position{
											Column: 22,
											Line:   249,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   249,
											},
											File:   "universe.flux",
											Source: "countColumn",
											Start: ast.Position{
												Column: 22,
												Line:   249,
											},
										},
									},
									Name: "countColumn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   249,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 35,
												Line:   249,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   249,
										},
										File:   "universe.flux",
										Source: "fn: fn",
										Start: ast.Position{
											Column: 43,
											Line:   249,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 45,
												Line:   249,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 43,
												Line:   249,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   249,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 47,
												Line:   249,
											},
										},
									},
									Name: "fn",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   249,
								},
								File:   "universe.flux",
								Source: "stateTracking(countColumn: column, fn: fn)",
								Start: ast.Position{
									Column: 8,
									Line:   249,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   249,
									},
									File:   "universe.flux",
									Source: "stateTracking",
									Start: ast.Position{
										Column: 8,
										Line:   249,
									},
								},
							},
							Name: "stateTracking",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   248,
							},
							File:   "universe.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 15,
								Line:   248,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   248,
								},
								File:   "universe.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 15,
									Line:   248,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   248,
							},
							File:   "universe.flux",
							Source: "column=\"stateCount\"",
							Start: ast.Position{
								Column: 19,
								Line:   248,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   248,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 19,
									Line:   248,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   248,
								},
								File:   "universe.flux",
								Source: "\"stateCount\"",
								Start: ast.Position{
									Column: 26,
									Line:   248,
								},
							},
						},
						Value: "stateCount",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   248,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 40,
								Line:   248,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 46,
									Line:   248,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 40,
									Line:   248,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   248,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 47,
								Line:   248,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 97,
						Line:   273,
					},
					File:   "universe.flux",
					Source: "stateDuration = (\n        fn,\n        column=\"stateDuration\",\n        timeColumn=\"_time\",\n        unit=1s,\n        tables=<-,\n) => tables\n    |> stateTracking(durationColumn: column, timeColumn: timeColumn, fn: fn, durationUnit: unit)",
					Start: ast.Position{
						Column: 1,
						Line:   266,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// stateDuration computes the duration of a given state.\n"}, ast.Comment{Text: "// The state is defined via the function fn. For each consecutive point for\n"}, ast.Comment{Text: "// which the expression evaluates as true, the state duration will be\n"}, ast.Comment{Text: "// incremented by the duration between points. When a point evaluates as false,\n"}, ast.Comment{Text: "// the state duration is reset.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// The state duration will be added as an additional column to each record. If the\n"}, ast.Comment{Text: "// expression evaluates as false, the value will be -1. If the expression\n"}, ast.Comment{Text: "// generates an error during evaluation, the point is discarded, and does not\n"}, ast.Comment{Text: "// affect the state duration.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// Note that as the first point in the given state has no previous point, its\n"}, ast.Comment{Text: "// state duration will be 0.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// The duration is represented as an integer in the units specified.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   266,
						},
						File:   "universe.flux",
						Source: "stateDuration",
						Start: ast.Position{
							Column: 1,
							Line:   266,
						},
					},
				},
				Name: "stateDuration",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 97,
							Line:   273,
						},
						File:   "universe.flux",
						Source: "(\n        fn,\n        column=\"stateDuration\",\n        timeColumn=\"_time\",\n        unit=1s,\n        tables=<-,\n) => tables\n    |> stateTracking(durationColumn: column, timeColumn: timeColumn, fn: fn, durationUnit: unit)",
						Start: ast.Position{
							Column: 17,
							Line:   266,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   272,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 6,
									Line:   272,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 97,
								Line:   273,
							},
							File:   "universe.flux",
							Source: "tables\n    |> stateTracking(durationColumn: column, timeColumn: timeColumn, fn: fn, durationUnit: unit)",
							Start: ast.Position{
								Column: 6,
								Line:   272,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 96,
										Line:   273,
									},
									File:   "universe.flux",
									Source: "durationColumn: column, timeColumn: timeColumn, fn: fn, durationUnit: unit",
									Start: ast.Position{
										Column: 22,
										Line:   273,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   273,
										},
										File:   "universe.flux",
										Source: "durationColumn: column",
										Start: ast.Position{
											Column: 22,
											Line:   273,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   273,
											},
											File:   "universe.flux",
											Source: "durationColumn",
											Start: ast.Position{
												Column: 22,
												Line:   273,
											},
										},
									},
									Name: "durationColumn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 44,
												Line:   273,
											},
											File:   "universe.flux",
											Source: "column",
											Start: ast.Position{
												Column: 38,
												Line:   273,
											},
										},
									},
									Name: "column",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   273,
										},
										File:   "universe.flux",
										Source: "timeColumn: timeColumn",
										Start: ast.Position{
											Column: 46,
											Line:   273,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 56,
												Line:   273,
											},
											File:   "universe.flux",
											Source: "timeColumn",
											Start: ast.Position{
												Column: 46,
												Line:   273,
											},
										},
									},
									Name: "timeColumn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   273,
											},
											File:   "universe.flux",
											Source: "timeColumn",
											Start: ast.Position{
												Column: 58,
												Line:   273,
											},
										},
									},
									Name: "timeColumn",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 76,
											Line:   273,
										},
										File:   "universe.flux",
										Source: "fn: fn",
										Start: ast.Position{
											Column: 70,
											Line:   273,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   273,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 70,
												Line:   273,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   273,
											},
											File:   "universe.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 74,
												Line:   273,
											},
										},
									},
									Name: "fn",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 96,
											Line:   273,
										},
										File:   "universe.flux",
										Source: "durationUnit: unit",
										Start: ast.Position{
											Column: 78,
											Line:   273,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 90,
												Line:   273,
											},
											File:   "universe.flux",
											Source: "durationUnit",
											Start: ast.Position{
												Column: 78,
												Line:   273,
											},
										},
									},
									Name: "durationUnit",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 96,
												Line:   273,
											},
											File:   "universe.flux",
											Source: "unit",
											Start: ast.Position{
												Column: 92,
												Line:   273,
											},
										},
									},
									Name: "unit",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 97,
									Line:   273,
								},
								File:   "universe.flux",
								Source: "stateTracking(durationColumn: column, timeColumn: timeColumn, fn: fn, durationUnit: unit)",
								Start: ast.Position{
									Column: 8,
									Line:   273,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   273,
									},
									File:   "universe.flux",
									Source: "stateTracking",
									Start: ast.Position{
										Column: 8,
										Line:   273,
									},
								},
							},
							Name: "stateTracking",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   267,
							},
							File:   "universe.flux",
							Source: "fn",
							Start: ast.Position{
								Column: 9,
								Line:   267,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 11,
									Line:   267,
								},
								File:   "universe.flux",
								Source: "fn",
								Start: ast.Position{
									Column: 9,
									Line:   267,
								},
							},
						},
						Name: "fn",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   268,
							},
							File:   "universe.flux",
							Source: "column=\"stateDuration\"",
							Start: ast.Position{
								Column: 9,
								Line:   268,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   268,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 9,
									Line:   268,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   268,
								},
								File:   "universe.flux",
								Source: "\"stateDuration\"",
								Start: ast.Position{
									Column: 16,
									Line:   268,
								},
							},
						},
						Value: "stateDuration",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   269,
							},
							File:   "universe.flux",
							Source: "timeColumn=\"_time\"",
							Start: ast.Position{
								Column: 9,
								Line:   269,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   269,
								},
								File:   "universe.flux",
								Source: "timeColumn",
								Start: ast.Position{
									Column: 9,
									Line:   269,
								},
							},
						},
						Name: "timeColumn",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   269,
								},
								File:   "universe.flux",
								Source: "\"_time\"",
								Start: ast.Position{
									Column: 20,
									Line:   269,
								},
							},
						},
						Value: "_time",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   270,
							},
							File:   "universe.flux",
							Source: "unit=1s",
							Start: ast.Position{
								Column: 9,
								Line:   270,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   270,
								},
								File:   "universe.flux",
								Source: "unit",
								Start: ast.Position{
									Column: 9,
									Line:   270,
								},
							},
						},
						Name: "unit",
					},
					Separator: nil,
					Value: &ast.DurationLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   270,
								},
								File:   "universe.flux",
								Source: "1s",
								Start: ast.Position{
									Column: 14,
									Line:   270,
								},
							},
						},
						Values: []ast.Duration{ast.Duration{
							Magnitude: int64(1),
							Unit:      "s",
						}},
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   271,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 9,
								Line:   271,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   271,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 9,
									Line:   271,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   271,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   271,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   278,
					},
					File:   "universe.flux",
					Source: "_sortLimit = (n, desc, columns=[\"_value\"], tables=<-) => tables\n    |> sort(columns: columns, desc: desc)\n    |> limit(n: n)",
					Start: ast.Position{
						Column: 1,
						Line:   276,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// _sortLimit is a helper function, which sorts and limits a table.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   276,
						},
						File:   "universe.flux",
						Source: "_sortLimit",
						Start: ast.Position{
							Column: 1,
							Line:   276,
						},
					},
				},
				Name: "_sortLimit",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   278,
						},
						File:   "universe.flux",
						Source: "(n, desc, columns=[\"_value\"], tables=<-) => tables\n    |> sort(columns: columns, desc: desc)\n    |> limit(n: n)",
						Start: ast.Position{
							Column: 14,
							Line:   276,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   276,
									},
									File:   "universe.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 58,
										Line:   276,
									},
								},
							},
							Name: "tables",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   277,
								},
								File:   "universe.flux",
								Source: "tables\n    |> sort(columns: columns, desc: desc)",
								Start: ast.Position{
									Column: 58,
									Line:   276,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   277,
										},
										File:   "universe.flux",
										Source: "columns: columns, desc: desc",
										Start: ast.Position{
											Column: 13,
											Line:   277,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   277,
											},
											File:   "universe.flux",
											Source: "columns: columns",
											Start: ast.Position{
												Column: 13,
												Line:   277,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   277,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 13,
													Line:   277,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   277,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 22,
													Line:   277,
												},
											},
										},
										Name: "columns",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   277,
											},
											File:   "universe.flux",
											Source: "desc: desc",
											Start: ast.Position{
												Column: 31,
												Line:   277,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   277,
												},
												File:   "universe.flux",
												Source: "desc",
												Start: ast.Position{
													Column: 31,
													Line:   277,
												},
											},
										},
										Name: "desc",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   277,
												},
												File:   "universe.flux",
												Source: "desc",
												Start: ast.Position{
													Column: 37,
													Line:   277,
												},
											},
										},
										Name: "desc",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   277,
									},
									File:   "universe.flux",
									Source: "sort(columns: columns, desc: desc)",
									Start: ast.Position{
										Column: 8,
										Line:   277,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   277,
										},
										File:   "universe.flux",
										Source: "sort",
										Start: ast.Position{
											Column: 8,
											Line:   277,
										},
									},
								},
								Name: "sort",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   278,
							},
							File:   "universe.flux",
							Source: "tables\n    |> sort(columns: columns, desc: desc)\n    |> limit(n: n)",
							Start: ast.Position{
								Column: 58,
								Line:   276,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   278,
									},
									File:   "universe.flux",
									Source: "n: n",
									Start: ast.Position{
										Column: 14,
										Line:   278,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   278,
										},
										File:   "universe.flux",
										Source: "n: n",
										Start: ast.Position{
											Column: 14,
											Line:   278,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   278,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 14,
												Line:   278,
											},
										},
									},
									Name: "n",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   278,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 17,
												Line:   278,
											},
										},
									},
									Name: "n",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   278,
								},
								File:   "universe.flux",
								Source: "limit(n: n)",
								Start: ast.Position{
									Column: 8,
									Line:   278,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   278,
									},
									File:   "universe.flux",
									Source: "limit",
									Start: ast.Position{
										Column: 8,
										Line:   278,
									},
								},
							},
							Name: "limit",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   276,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 15,
								Line:   276,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   276,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 15,
									Line:   276,
								},
							},
						},
						Name: "n",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   276,
							},
							File:   "universe.flux",
							Source: "desc",
							Start: ast.Position{
								Column: 18,
								Line:   276,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   276,
								},
								File:   "universe.flux",
								Source: "desc",
								Start: ast.Position{
									Column: 18,
									Line:   276,
								},
							},
						},
						Name: "desc",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   276,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 24,
								Line:   276,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   276,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 24,
									Line:   276,
								},
							},
						},
						Name: "columns",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   276,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 32,
									Line:   276,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   276,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 33,
										Line:   276,
									},
								},
							},
							Value: "_value",
						}},
						Lbrack: nil,
						Rbrack: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   276,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 44,
								Line:   276,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   276,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 44,
									Line:   276,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   276,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 51,
								Line:   276,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 54,
						Line:   282,
					},
					File:   "universe.flux",
					Source: "top = (n, columns=[\"_value\"], tables=<-) => tables\n    |> _sortLimit(n: n, columns: columns, desc: true)",
					Start: ast.Position{
						Column: 1,
						Line:   281,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// top sorts a table by columns and keeps only the top n records.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   281,
						},
						File:   "universe.flux",
						Source: "top",
						Start: ast.Position{
							Column: 1,
							Line:   281,
						},
					},
				},
				Name: "top",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 54,
							Line:   282,
						},
						File:   "universe.flux",
						Source: "(n, columns=[\"_value\"], tables=<-) => tables\n    |> _sortLimit(n: n, columns: columns, desc: true)",
						Start: ast.Position{
							Column: 7,
							Line:   281,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   281,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 45,
									Line:   281,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   282,
							},
							File:   "universe.flux",
							Source: "tables\n    |> _sortLimit(n: n, columns: columns, desc: true)",
							Start: ast.Position{
								Column: 45,
								Line:   281,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   282,
									},
									File:   "universe.flux",
									Source: "n: n, columns: columns, desc: true",
									Start: ast.Position{
										Column: 19,
										Line:   282,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   282,
										},
										File:   "universe.flux",
										Source: "n: n",
										Start: ast.Position{
											Column: 19,
											Line:   282,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   282,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   282,
											},
										},
									},
									Name: "n",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   282,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 22,
												Line:   282,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   282,
										},
										File:   "universe.flux",
										Source: "columns: columns",
										Start: ast.Position{
											Column: 25,
											Line:   282,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   282,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 25,
												Line:   282,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   282,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 34,
												Line:   282,
											},
										},
									},
									Name: "columns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 53,
											Line:   282,
										},
										File:   "universe.flux",
										Source: "desc: true",
										Start: ast.Position{
											Column: 43,
											Line:   282,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   282,
											},
											File:   "universe.flux",
											Source: "desc",
											Start: ast.Position{
												Column: 43,
												Line:   282,
											},
										},
									},
									Name: "desc",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   282,
											},
											File:   "universe.flux",
											Source: "true",
											Start: ast.Position{
												Column: 49,
												Line:   282,
											},
										},
									},
									Name: "true",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   282,
								},
								File:   "universe.flux",
								Source: "_sortLimit(n: n, columns: columns, desc: true)",
								Start: ast.Position{
									Column: 8,
									Line:   282,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   282,
									},
									File:   "universe.flux",
									Source: "_sortLimit",
									Start: ast.Position{
										Column: 8,
										Line:   282,
									},
								},
							},
							Name: "_sortLimit",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 9,
								Line:   281,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 8,
								Line:   281,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 9,
									Line:   281,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 8,
									Line:   281,
								},
							},
						},
						Name: "n",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   281,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 11,
								Line:   281,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   281,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 11,
									Line:   281,
								},
							},
						},
						Name: "columns",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   281,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 19,
									Line:   281,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   281,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 20,
										Line:   281,
									},
								},
							},
							Value: "_value",
						}},
						Lbrack: nil,
						Rbrack: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   281,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 31,
								Line:   281,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   281,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 31,
									Line:   281,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   281,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 38,
								Line:   281,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 55,
						Line:   286,
					},
					File:   "universe.flux",
					Source: "bottom = (n, columns=[\"_value\"], tables=<-) => tables\n    |> _sortLimit(n: n, columns: columns, desc: false)",
					Start: ast.Position{
						Column: 1,
						Line:   285,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// top sorts a table by columns and keeps only the bottom n records.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   285,
						},
						File:   "universe.flux",
						Source: "bottom",
						Start: ast.Position{
							Column: 1,
							Line:   285,
						},
					},
				},
				Name: "bottom",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 55,
							Line:   286,
						},
						File:   "universe.flux",
						Source: "(n, columns=[\"_value\"], tables=<-) => tables\n    |> _sortLimit(n: n, columns: columns, desc: false)",
						Start: ast.Position{
							Column: 10,
							Line:   285,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   285,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 48,
									Line:   285,
								},
							},
						},
						Name: "tables",
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 55,
								Line:   286,
							},
							File:   "universe.flux",
							Source: "tables\n    |> _sortLimit(n: n, columns: columns, desc: false)",
							Start: ast.Position{
								Column: 48,
								Line:   285,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   286,
									},
									File:   "universe.flux",
									Source: "n: n, columns: columns, desc: false",
									Start: ast.Position{
										Column: 19,
										Line:   286,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   286,
										},
										File:   "universe.flux",
										Source: "n: n",
										Start: ast.Position{
											Column: 19,
											Line:   286,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   286,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   286,
											},
										},
									},
									Name: "n",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   286,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 22,
												Line:   286,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   286,
										},
										File:   "universe.flux",
										Source: "columns: columns",
										Start: ast.Position{
											Column: 25,
											Line:   286,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   286,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 25,
												Line:   286,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   286,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 34,
												Line:   286,
											},
										},
									},
									Name: "columns",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   286,
										},
										File:   "universe.flux",
										Source: "desc: false",
										Start: ast.Position{
											Column: 43,
											Line:   286,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   286,
											},
											File:   "universe.flux",
											Source: "desc",
											Start: ast.Position{
												Column: 43,
												Line:   286,
											},
										},
									},
									Name: "desc",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   286,
											},
											File:   "universe.flux",
											Source: "false",
											Start: ast.Position{
												Column: 49,
												Line:   286,
											},
										},
									},
									Name: "false",
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   286,
								},
								File:   "universe.flux",
								Source: "_sortLimit(n: n, columns: columns, desc: false)",
								Start: ast.Position{
									Column: 8,
									Line:   286,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   286,
									},
									File:   "universe.flux",
									Source: "_sortLimit",
									Start: ast.Position{
										Column: 8,
										Line:   286,
									},
								},
							},
							Name: "_sortLimit",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   285,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 11,
								Line:   285,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   285,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 11,
									Line:   285,
								},
							},
						},
						Name: "n",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   285,
							},
							File:   "universe.flux",
							Source: "columns=[\"_value\"]",
							Start: ast.Position{
								Column: 14,
								Line:   285,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   285,
								},
								File:   "universe.flux",
								Source: "columns",
								Start: ast.Position{
									Column: 14,
									Line:   285,
								},
							},
						},
						Name: "columns",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   285,
								},
								File:   "universe.flux",
								Source: "[\"_value\"]",
								Start: ast.Position{
									Column: 22,
									Line:   285,
								},
							},
						},
						Elements: []ast.Expression{&ast.StringLiteral{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   285,
									},
									File:   "universe.flux",
									Source: "\"_value\"",
									Start: ast.Position{
										Column: 23,
										Line:   285,
									},
								},
							},
							Value: "_value",
						}},
						Lbrack: nil,
						Rbrack: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   285,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 34,
								Line:   285,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   285,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 34,
									Line:   285,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   285,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 41,
								Line:   285,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 43,
						Line:   302,
					},
					File:   "universe.flux",
					Source: "_highestOrLowest = (\n        n,\n        _sortLimit,\n        reducer,\n        column=\"_value\",\n        groupColumns=[],\n        tables=<-,\n) => tables\n    |> group(columns: groupColumns)\n    |> reducer()\n    |> group(columns: [])\n    |> _sortLimit(n: n, columns: [column])",
					Start: ast.Position{
						Column: 1,
						Line:   291,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// _highestOrLowest is a helper function, which reduces all groups into a single group by specific tags and a reducer function,\n"}, ast.Comment{Text: "// then it selects the highest or lowest records based on the column and the _sortLimit function.\n"}, ast.Comment{Text: "// The default reducer assumes no reducing needs to be performed.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   291,
						},
						File:   "universe.flux",
						Source: "_highestOrLowest",
						Start: ast.Position{
							Column: 1,
							Line:   291,
						},
					},
				},
				Name: "_highestOrLowest",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 43,
							Line:   302,
						},
						File:   "universe.flux",
						Source: "(\n        n,\n        _sortLimit,\n        reducer,\n        column=\"_value\",\n        groupColumns=[],\n        tables=<-,\n) => tables\n    |> group(columns: groupColumns)\n    |> reducer()\n    |> group(columns: [])\n    |> _sortLimit(n: n, columns: [column])",
						Start: ast.Position{
							Column: 20,
							Line:   291,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   298,
											},
											File:   "universe.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 6,
												Line:   298,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 36,
											Line:   299,
										},
										File:   "universe.flux",
										Source: "tables\n    |> group(columns: groupColumns)",
										Start: ast.Position{
											Column: 6,
											Line:   298,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   299,
												},
												File:   "universe.flux",
												Source: "columns: groupColumns",
												Start: ast.Position{
													Column: 14,
													Line:   299,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   299,
													},
													File:   "universe.flux",
													Source: "columns: groupColumns",
													Start: ast.Position{
														Column: 14,
														Line:   299,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   299,
														},
														File:   "universe.flux",
														Source: "columns",
														Start: ast.Position{
															Column: 14,
															Line:   299,
														},
													},
												},
												Name: "columns",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   299,
														},
														File:   "universe.flux",
														Source: "groupColumns",
														Start: ast.Position{
															Column: 23,
															Line:   299,
														},
													},
												},
												Name: "groupColumns",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   299,
											},
											File:   "universe.flux",
											Source: "group(columns: groupColumns)",
											Start: ast.Position{
												Column: 8,
												Line:   299,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   299,
												},
												File:   "universe.flux",
												Source: "group",
												Start: ast.Position{
													Column: 8,
													Line:   299,
												},
											},
										},
										Name: "group",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   300,
									},
									File:   "universe.flux",
									Source: "tables\n    |> group(columns: groupColumns)\n    |> reducer()",
									Start: ast.Position{
										Column: 6,
										Line:   298,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   300,
										},
										File:   "universe.flux",
										Source: "reducer()",
										Start: ast.Position{
											Column: 8,
											Line:   300,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   300,
											},
											File:   "universe.flux",
											Source: "reducer",
											Start: ast.Position{
												Column: 8,
												Line:   300,
											},
										},
									},
									Name: "reducer",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   301,
								},
								File:   "universe.flux",
								Source: "tables\n    |> group(columns: groupColumns)\n    |> reducer()\n    |> group(columns: [])",
								Start: ast.Position{
									Column: 6,
									Line:   298,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   301,
										},
										File:   "universe.flux",
										Source: "columns: []",
										Start: ast.Position{
											Column: 14,
											Line:   301,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   301,
											},
											File:   "universe.flux",
											Source: "columns: []",
											Start: ast.Position{
												Column: 14,
												Line:   301,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   301,
												},
												File:   "universe.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 14,
													Line:   301,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   301,
												},
												File:   "universe.flux",
												Source: "[]",
												Start: ast.Position{
													Column: 23,
													Line:   301,
												},
											},
										},
										Elements: []ast.Expression{},
										Lbrack:   nil,
										Rbrack:   nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   301,
									},
									File:   "universe.flux",
									Source: "group(columns: [])",
									Start: ast.Position{
										Column: 8,
										Line:   301,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   301,
										},
										File:   "universe.flux",
										Source: "group",
										Start: ast.Position{
											Column: 8,
											Line:   301,
										},
									},
								},
								Name: "group",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 43,
								Line:   302,
							},
							File:   "universe.flux",
							Source: "tables\n    |> group(columns: groupColumns)\n    |> reducer()\n    |> group(columns: [])\n    |> _sortLimit(n: n, columns: [column])",
							Start: ast.Position{
								Column: 6,
								Line:   298,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   302,
									},
									File:   "universe.flux",
									Source: "n: n, columns: [column]",
									Start: ast.Position{
										Column: 19,
										Line:   302,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   302,
										},
										File:   "universe.flux",
										Source: "n: n",
										Start: ast.Position{
											Column: 19,
											Line:   302,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   302,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 19,
												Line:   302,
											},
										},
									},
									Name: "n",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   302,
											},
											File:   "universe.flux",
											Source: "n",
											Start: ast.Position{
												Column: 22,
												Line:   302,
											},
										},
									},
									Name: "n",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   302,
										},
										File:   "universe.flux",
										Source: "columns: [column]",
										Start: ast.Position{
											Column: 25,
											Line:   302,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   302,
											},
											File:   "universe.flux",
											Source: "columns",
											Start: ast.Position{
												Column: 25,
												Line:   302,
											},
										},
									},
									Name: "columns",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   302,
											},
											File:   "universe.flux",
											Source: "[column]",
											Start: ast.Position{
												Column: 34,
												Line:   302,
											},
										},
									},
									Elements: []ast.Expression{&ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   302,
												},
												File:   "universe.flux",
												Source: "column",
												Start: ast.Position{
													Column: 35,
													Line:   302,
												},
											},
										},
										Name: "column",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   302,
								},
								File:   "universe.flux",
								Source: "_sortLimit(n: n, columns: [column])",
								Start: ast.Position{
									Column: 8,
									Line:   302,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   302,
									},
									File:   "universe.flux",
									Source: "_sortLimit",
									Start: ast.Position{
										Column: 8,
										Line:   302,
									},
								},
							},
							Name: "_sortLimit",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   292,
							},
							File:   "universe.flux",
							Source: "n",
							Start: ast.Position{
								Column: 9,
								Line:   292,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   292,
								},
								File:   "universe.flux",
								Source: "n",
								Start: ast.Position{
									Column: 9,
									Line:   292,
								},
							},
						},
						Name: "n",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   293,
							},
							File:   "universe.flux",
							Source: "_sortLimit",
							Start: ast.Position{
								Column: 9,
								Line:   293,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   293,
								},
								File:   "universe.flux",
								Source: "_sortLimit",
								Start: ast.Position{
									Column: 9,
									Line:   293,
								},
							},
						},
						Name: "_sortLimit",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   294,
							},
							File:   "universe.flux",
							Source: "reducer",
							Start: ast.Position{
								Column: 9,
								Line:   294,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   294,
								},
								File:   "universe.flux",
								Source: "reducer",
								Start: ast.Position{
									Column: 9,
									Line:   294,
								},
							},
						},
						Name: "reducer",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   295,
							},
							File:   "universe.flux",
							Source: "column=\"_value\"",
							Start: ast.Position{
								Column: 9,
								Line:   295,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   295,
								},
								File:   "universe.flux",
								Source: "column",
								Start: ast.Position{
									Column: 9,
									Line:   295,
								},
							},
						},
						Name: "column",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   295,
								},
								File:   "universe.flux",
								Source: "\"_value\"",
								Start: ast.Position{
									Column: 16,
									Line:   295,
								},
							},
						},
						Value: "_value",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   296,
							},
							File:   "universe.flux",
							Source: "groupColumns=[]",
							Start: ast.Position{
								Column: 9,
								Line:   296,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   296,
								},
								File:   "universe.flux",
								Source: "groupColumns",
								Start: ast.Position{
									Column: 9,
									Line:   296,
								},
							},
						},
						Name: "groupColumns",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   296,
								},
								File:   "universe.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 22,
									Line:   296,
								},
							},
						},
						Elements: []ast.Expression{},
						Lbrack:   nil,
						Rbrack:   nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   297,
							},
							File:   "universe.flux",
							Source: "tables=<-",
							Start: ast.Position{
								Column: 9,
								Line:   297,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   297,
								},
								File:   "universe.flux",
								Source: "tables",
								Start: ast.Position{
									Column: 9,
									Line:   297,
								},
							},
						},
						Name: "tables",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   297,
							},
							File:   "universe.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 16,
								Line:   297,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   313,
					},
					File:   "universe.flux",
					Source: "highestMax = (n, column=\"_value\", groupColumns=[], tables=<-) => tables\n    |> _highestOrLowest(\n        n: n,\n        column: column,\n        groupColumns: groupColumns,\n        // TODO(nathanielc): Once max/min support selecting based on multiple columns change this to pass all columns.\n        reducer: (tables=<-) => tables |> max(column: column),\n        _sortLimit: top,\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   305,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// highestMax returns the top N records from all groups using the maximum of each group.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   305,
						},
						File:   "universe.flux",
						Source: "highestMax",
						Start: ast.Position{
							Column: 1,
							Line:   305,
						},
					},
				},
				Name: "highestMax",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   313,
						},
						File:   "universe.flux",
						Source: "(n, column=\"_value\", groupColumns=[], tables=<-) => tables\n  