// Code generated by tmpl; DO NOT EDIT.
// https://github.com/benbjohnson/tmpl
//
// Source: binary.gen.go.tmpl

package values

import (
	"github.com/apache/arrow/go/v7/arrow/memory"
	fluxarray "github.com/influxdata/flux/array"
	"github.com/influxdata/flux/codes"
	"github.com/influxdata/flux/internal/errors"
	"github.com/influxdata/flux/semantic"
)

func vectorAdd(l, r Vector, mem memory.Allocator) (Value, error) {
	switch l.ElementType().Nature() {

	case semantic.Int:

		x, err := fluxarray.IntAdd(l.Arr().(*fluxarray.Int), r.Arr().(*fluxarray.Int), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicInt), nil

	case semantic.UInt:

		x, err := fluxarray.UintAdd(l.Arr().(*fluxarray.Uint), r.Arr().(*fluxarray.Uint), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicUint), nil

	case semantic.Float:

		x, err := fluxarray.FloatAdd(l.Arr().(*fluxarray.Float), r.Arr().(*fluxarray.Float), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicFloat), nil

	case semantic.String:

		x, err := fluxarray.StringAdd(l.Arr().(*fluxarray.String), r.Arr().(*fluxarray.String), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicString), nil

	default:
		return nil, errors.Newf(codes.Invalid, "unsupported type for vector Add: %v", l.ElementType())
	}
}

func vectorSub(l, r Vector, mem memory.Allocator) (Value, error) {
	switch l.ElementType().Nature() {

	case semantic.Int:

		x, err := fluxarray.IntSub(l.Arr().(*fluxarray.Int), r.Arr().(*fluxarray.Int), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicInt), nil

	case semantic.UInt:

		x, err := fluxarray.UintSub(l.Arr().(*fluxarray.Uint), r.Arr().(*fluxarray.Uint), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicUint), nil

	case semantic.Float:

		x, err := fluxarray.FloatSub(l.Arr().(*fluxarray.Float), r.Arr().(*fluxarray.Float), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicFloat), nil

	default:
		return nil, errors.Newf(codes.Invalid, "unsupported type for vector Sub: %v", l.ElementType())
	}
}

func vectorMul(l, r Vector, mem memory.Allocator) (Value, error) {
	switch l.ElementType().Nature() {

	case semantic.Int:

		x, err := fluxarray.IntMul(l.Arr().(*fluxarray.Int), r.Arr().(*fluxarray.Int), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicInt), nil

	case semantic.UInt:

		x, err := fluxarray.UintMul(l.Arr().(*fluxarray.Uint), r.Arr().(*fluxarray.Uint), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicUint), nil

	case semantic.Float:

		x, err := fluxarray.FloatMul(l.Arr().(*fluxarray.Float), r.Arr().(*fluxarray.Float), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicFloat), nil

	default:
		return nil, errors.Newf(codes.Invalid, "unsupported type for vector Mul: %v", l.ElementType())
	}
}

func vectorDiv(l, r Vector, mem memory.Allocator) (Value, error) {
	switch l.ElementType().Nature() {

	case semantic.Int:

		x, err := fluxarray.IntDiv(l.Arr().(*fluxarray.Int), r.Arr().(*fluxarray.Int), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicInt), nil

	case semantic.UInt:

		x, err := fluxarray.UintDiv(l.Arr().(*fluxarray.Uint), r.Arr().(*fluxarray.Uint), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicUint), nil

	case semantic.Float:

		x, err := fluxarray.FloatDiv(l.Arr().(*fluxarray.Float), r.Arr().(*fluxarray.Float), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicFloat), nil

	default:
		return nil, errors.Newf(codes.Invalid, "unsupported type for vector Div: %v", l.ElementType())
	}
}

func vectorMod(l, r Vector, mem memory.Allocator) (Value, error) {
	switch l.ElementType().Nature() {

	case semantic.Int:

		x, err := fluxarray.IntMod(l.Arr().(*fluxarray.Int), r.Arr().(*fluxarray.Int), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicInt), nil

	case semantic.UInt:

		x, err := fluxarray.UintMod(l.Arr().(*fluxarray.Uint), r.Arr().(*fluxarray.Uint), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicUint), nil

	case semantic.Float:

		x, err := fluxarray.FloatMod(l.Arr().(*fluxarray.Float), r.Arr().(*fluxarray.Float), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicFloat), nil

	default:
		return nil, errors.Newf(codes.Invalid, "unsupported type for vector Mod: %v", l.ElementType())
	}
}

func vectorPow(l, r Vector, mem memory.Allocator) (Value, error) {
	switch l.ElementType().Nature() {

	case semantic.Int:

		x, err := fluxarray.IntPow(l.Arr().(*fluxarray.Int), r.Arr().(*fluxarray.Int), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicFloat), nil

	case semantic.UInt:

		x, err := fluxarray.UintPow(l.Arr().(*fluxarray.Uint), r.Arr().(*fluxarray.Uint), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicFloat), nil

	case semantic.Float:

		x, err := fluxarray.FloatPow(l.Arr().(*fluxarray.Float), r.Arr().(*fluxarray.Float), mem)
		if err != nil {
			return nil, err
		}

		return NewVectorValue(x, semantic.BasicFloat), nil

	default:
		return nil, errors.Newf(codes.Invalid, "unsupported type for vector Pow: %v", l.ElementType())
	}
}
