#[macro_use]
extern crate criterion;
extern crate flux;

use std::path::Path;

use criterion::{black_box, Criterion};
use flux::{parser::parse_string, semantic::bootstrap};

// everything.flux was generated by running the following
// command from this directory. This file is trimmed to 5000
// lines, as the 52k lines pre-trim would cause the benchmark
// test to take a very long time (almost three hours).
// for file in `find ../../../../stdlib -name "*.flux"`; do
// cat $file | grep -v "^package" | grep -v "^import" | grep -v "^$" >> everything.flux
// done
fn everything(c: &mut Criterion) {
    let flux = include_str!("./everything.flux");
    let mut group = c.benchmark_group("parse");
    group.bench_function("everything.flux", |b| {
        b.iter(black_box(|| {
            parse_string("".to_string(), flux);
        }));
    });
    group.finish();

    let mut group = c.benchmark_group("infer");
    group.sample_size(10).bench_function("bootstrap", |b| {
        b.iter(black_box(|| {
            let (prelude, _, _) =
                bootstrap::infer_stdlib_dir(Path::new("../../stdlib"), Default::default()).unwrap();
            assert!(!prelude.is_empty());
        }));
    });
    group.finish();
}

criterion_group!(basic, everything,);
criterion_main!(basic);
