package universe_test


import "testing"
import "csv"

option now = () => 2030-01-01T00:00:00Z

testcase cumulative_sum {
    inData =
        "
#datatype,string,long,dateTime:RFC3339,string,long,long,long,string
#group,false,false,false,true,false,false,false,true
#default,_result,,,,,,,
,result,table,_time,_measurement,v0,v1,v2,_field
,,0,2018-05-22T19:53:30Z,_m0,1,10,100,f0
,,0,2018-05-22T19:53:40Z,_m0,1,10,100,f0
,,0,2018-05-22T19:53:50Z,_m0,1,10,100,f0
,,0,2018-05-22T19:53:00Z,_m0,1,10,100,f0
,,0,2018-05-22T19:53:10Z,_m0,1,10,100,f0
,,0,2018-05-22T19:53:20Z,_m0,1,10,100,f0
,,1,2018-05-22T19:53:30Z,_m1,1,10,100,f1
,,1,2018-05-22T19:53:40Z,_m1,1,10,100,f1
,,1,2018-05-22T19:53:50Z,_m1,1,10,100,f1
,,1,2018-05-22T19:54:00Z,_m1,1,10,100,f1
,,1,2018-05-22T19:54:10Z,_m1,1,10,100,f1
,,1,2018-05-22T19:54:30Z,_m1,1,10,100,f1
,,1,2018-05-22T19:54:40Z,_m1,1,10,100,f1
,,1,2018-05-22T19:53:50Z,_m1,1,10,100,f1
,,1,2018-05-22T19:54:00Z,_m1,1,10,100,f1
,,2,2018-05-22T19:53:10Z,_m2,1,10,100,f2
,,2,2018-05-22T19:53:30Z,_m2,1,10,100,f2
,,2,2018-05-22T19:54:40Z,_m2,1,10,100,f2
,,2,2018-05-22T19:53:50Z,_m2,1,10,100,f2
,,3,2018-05-22T19:54:00Z,_m3,1,10,100,f3
,,3,2018-05-22T19:54:10Z,_m3,1,10,100,f3
,,3,2018-05-22T19:54:20Z,_m3,1,10,100,f3
"
    outData =
        "
#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,long,long,long,string
#group,false,false,true,true,false,true,false,false,false,true
#default,_result,,,,,,,,,
,result,table,_start,_stop,_time,_measurement,v0,v1,v2,_field
,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m0,1,10,100,f0
,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m0,2,20,100,f0
,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m0,3,30,100,f0
,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:00Z,_m0,4,40,100,f0
,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m0,5,50,100,f0
,,0,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:20Z,_m0,6,60,100,f0
,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m1,1,10,100,f1
,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m1,2,20,100,f1
,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m1,3,30,100,f1
,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m1,4,40,100,f1
,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m1,5,50,100,f1
,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:30Z,_m1,6,60,100,f1
,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m1,7,70,100,f1
,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m1,8,80,100,f1
,,1,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m1,9,90,100,f1
,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m2,1,10,100,f2
,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m2,2,20,100,f2
,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m2,3,30,100,f2
,,2,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m2,4,40,100,f2
,,3,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m3,1,10,100,f3
,,3,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m3,2,20,100,f3
,,3,2018-05-20T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:20Z,_m3,3,30,100,f3
"

    got =
        csv.from(csv: inData)
            |> range(start: 2018-05-20T00:00:00Z)
            |> cumulativeSum(columns: ["v0", "v1"])
    want = csv.from(csv: outData)

    testing.diff(got, want)
}

testcase cumulative_sum_noop {
    inData =
        "
#datatype,string,long,dateTime:RFC3339,string,long,string
#group,false,false,false,true,false,true
#default,_result,,,,,
,result,table,_time,_measurement,values,_field
,,0,2018-05-22T19:53:30Z,_m,1,f0
,,0,2018-05-22T19:53:40Z,_m,1,f0
,,0,2018-05-22T19:53:50Z,_m,1,f0
,,0,2018-05-22T19:53:00Z,_m,1,f0
,,0,2018-05-22T19:53:10Z,_m,1,f0
,,0,2018-05-22T19:53:20Z,_m,1,f0
,,0,2018-05-22T19:53:30Z,_m,1,f0
,,0,2018-05-22T19:53:40Z,_m,1,f0
,,0,2018-05-22T19:53:50Z,_m,1,f0
,,0,2018-05-22T19:54:00Z,_m,1,f0
,,0,2018-05-22T19:54:10Z,_m,1,f0
,,0,2018-05-22T19:54:30Z,_m,1,f0
,,0,2018-05-22T19:54:40Z,_m,1,f0
,,0,2018-05-22T19:53:50Z,_m,1,f0
,,0,2018-05-22T19:54:00Z,_m,1,f0
,,0,2018-05-22T19:53:10Z,_m,1,f0
,,0,2018-05-22T19:53:30Z,_m,1,f0
,,0,2018-05-22T19:54:40Z,_m,1,f0
,,0,2018-05-22T19:53:50Z,_m,1,f0
,,0,2018-05-22T19:54:00Z,_m,1,f0
,,0,2018-05-22T19:54:10Z,_m,1,f0
,,0,2018-05-22T19:54:20Z,_m,1,f0
"
    outData =
        "
#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,long,string
#group,false,false,true,true,false,true,false,true
#default,_result,,,,,,,
,result,table,_start,_stop,_time,_measurement,values,_field
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:00Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:20Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:30Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,1,f0
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:20Z,_m,1,f0
"

    got =
        csv.from(csv: inData)
            |> range(start: 2018-05-15T00:00:00Z)
            |> cumulativeSum()
    want = csv.from(csv: outData)

    testing.diff(got, want)
}

testcase cumulative_sum_default {
    inData =
        "
#datatype,string,long,dateTime:RFC3339,string,string,long
#group,false,false,false,true,true,false
#default,_result,,,,,
,result,table,_time,_measurement,_field,_value
,,0,2018-05-22T19:53:30Z,_m,FF,1
,,0,2018-05-22T19:53:40Z,_m,FF,1
,,0,2018-05-22T19:53:50Z,_m,FF,1
,,0,2018-05-22T19:53:00Z,_m,FF,1
,,0,2018-05-22T19:53:10Z,_m,FF,1
,,0,2018-05-22T19:53:20Z,_m,FF,1
,,1,2018-05-22T19:53:30Z,_m,QQ,1
,,1,2018-05-22T19:53:40Z,_m,QQ,1
,,1,2018-05-22T19:53:50Z,_m,QQ,1
,,1,2018-05-22T19:54:00Z,_m,QQ,1
,,1,2018-05-22T19:54:10Z,_m,QQ,1
,,1,2018-05-22T19:54:30Z,_m,QQ,1
,,1,2018-05-22T19:54:40Z,_m,QQ,1
,,1,2018-05-22T19:53:50Z,_m,QQ,1
,,1,2018-05-22T19:54:00Z,_m,QQ,1
,,2,2018-05-22T19:53:10Z,_m,RR,1
,,2,2018-05-22T19:53:30Z,_m,RR,1
,,2,2018-05-22T19:54:40Z,_m,RR,1
,,2,2018-05-22T19:53:50Z,_m,RR,1
,,3,2018-05-22T19:54:00Z,_m,SR,1
,,3,2018-05-22T19:54:10Z,_m,SR,1
,,3,2018-05-22T19:54:20Z,_m,SR,1
"
    outData =
        "
#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,long
#group,false,false,true,true,false,true,true,false
#default,_result,,,,,,,
,result,table,_start,_stop,_time,_measurement,_field,_value
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,FF,1
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,FF,2
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,FF,3
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:00Z,_m,FF,4
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,FF,5
,,0,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:20Z,_m,FF,6
,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,QQ,1
,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:40Z,_m,QQ,2
,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,QQ,3
,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,QQ,4
,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,QQ,5
,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:30Z,_m,QQ,6
,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,QQ,7
,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,QQ,8
,,1,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,QQ,9
,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:10Z,_m,RR,1
,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:30Z,_m,RR,2
,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:40Z,_m,RR,3
,,2,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:53:50Z,_m,RR,4
,,3,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:00Z,_m,SR,1
,,3,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:10Z,_m,SR,2
,,3,2018-05-15T00:00:00Z,2030-01-01T00:00:00Z,2018-05-22T19:54:20Z,_m,SR,3
"

    got =
        csv.from(csv: inData)
            |> range(start: 2018-05-15T00:00:00Z)
            |> cumulativeSum()
    want = csv.from(csv: outData)

    testing.diff(got, want)
}
