/*
Package exampleoc is a generated package which contains definitions
of structs which generate gNMI paths for a YANG schema. The generated paths are
based on a compressed form of the schema.

This package was generated by /usr/local/google/home/wenbli/gocode/src/github.com/openconfig/ygot/genutil/names.go
using the following YANG input files:
  - public/release/models/network-instance/openconfig-network-instance.yang
  - public/release/models/optical-transport/openconfig-optical-amplifier.yang
  - public/release/models/optical-transport/openconfig-terminal-device.yang
  - public/release/models/optical-transport/openconfig-transport-line-protection.yang
  - public/release/models/platform/openconfig-platform.yang
  - public/release/models/bgp/openconfig-bgp-policy.yang
  - public/release/models/policy/openconfig-routing-policy.yang
  - public/release/models/lacp/openconfig-lacp.yang
  - public/release/models/system/openconfig-system.yang
  - public/release/models/stp/openconfig-spanning-tree.yang
  - public/release/models/interfaces/openconfig-interfaces.yang
  - public/release/models/interfaces/openconfig-if-ip.yang
  - public/release/models/interfaces/openconfig-if-aggregate.yang
  - public/release/models/interfaces/openconfig-if-ethernet.yang
  - public/release/models/interfaces/openconfig-if-ip-ext.yang
  - public/release/models/relay-agent/openconfig-relay-agent.yang
  - public/release/models/aft/openconfig-aft-network-instance.yang
  - public/release/models/lldp/openconfig-lldp.yang

Imported modules were sourced from:
  - public/...
  - deps/...
*/
package exampleoc

import (
	"github.com/openconfig/ygot/ygot"
)

// AclPath represents the /openconfig-acl/acl YANG schema element.
type AclPath struct {
	*ygot.NodePath
}

// AclPathAny represents the wildcard version of the /openconfig-acl/acl YANG schema element.
type AclPathAny struct {
	*ygot.NodePath
}

// Acl_CounterCapabilityPath represents the /openconfig-acl/acl/state/counter-capability YANG schema element.
type Acl_CounterCapabilityPath struct {
	*ygot.NodePath
}

// Acl_CounterCapabilityPathAny represents the wildcard version of the /openconfig-acl/acl/state/counter-capability YANG schema element.
type Acl_CounterCapabilityPathAny struct {
	*ygot.NodePath
}

// AclSetAny (list): List of ACL sets, each comprising of a list of ACL
// entries
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-sets/acl-set"
// Path from root: "/acl/acl-sets/acl-set"
// Name (wildcarded): string
// Type (wildcarded): E_Acl_ACL_TYPE
func (n *AclPath) AclSetAny() *Acl_AclSetPathAny {
	return &Acl_AclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"acl-sets", "acl-set"},
			map[string]interface{}{"name": "*", "type": "*"},
			n,
		),
	}
}

// AclSetAny (list): List of ACL sets, each comprising of a list of ACL
// entries
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-sets/acl-set"
// Path from root: "/acl/acl-sets/acl-set"
// Name (wildcarded): string
// Type (wildcarded): E_Acl_ACL_TYPE
func (n *AclPathAny) AclSetAny() *Acl_AclSetPathAny {
	return &Acl_AclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"acl-sets", "acl-set"},
			map[string]interface{}{"name": "*", "type": "*"},
			n,
		),
	}
}

// AclSetAnyType (list): List of ACL sets, each comprising of a list of ACL
// entries
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-sets/acl-set"
// Path from root: "/acl/acl-sets/acl-set"
// Name: string
// Type (wildcarded): E_Acl_ACL_TYPE
func (n *AclPath) AclSetAnyType(Name string) *Acl_AclSetPathAny {
	return &Acl_AclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"acl-sets", "acl-set"},
			map[string]interface{}{"name": Name, "type": "*"},
			n,
		),
	}
}

// AclSetAnyType (list): List of ACL sets, each comprising of a list of ACL
// entries
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-sets/acl-set"
// Path from root: "/acl/acl-sets/acl-set"
// Name: string
// Type (wildcarded): E_Acl_ACL_TYPE
func (n *AclPathAny) AclSetAnyType(Name string) *Acl_AclSetPathAny {
	return &Acl_AclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"acl-sets", "acl-set"},
			map[string]interface{}{"name": Name, "type": "*"},
			n,
		),
	}
}

// AclSetAnyName (list): List of ACL sets, each comprising of a list of ACL
// entries
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-sets/acl-set"
// Path from root: "/acl/acl-sets/acl-set"
// Name (wildcarded): string
// Type: E_Acl_ACL_TYPE
func (n *AclPath) AclSetAnyName(Type E_Acl_ACL_TYPE) *Acl_AclSetPathAny {
	return &Acl_AclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"acl-sets", "acl-set"},
			map[string]interface{}{"name": "*", "type": Type},
			n,
		),
	}
}

// AclSetAnyName (list): List of ACL sets, each comprising of a list of ACL
// entries
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-sets/acl-set"
// Path from root: "/acl/acl-sets/acl-set"
// Name (wildcarded): string
// Type: E_Acl_ACL_TYPE
func (n *AclPathAny) AclSetAnyName(Type E_Acl_ACL_TYPE) *Acl_AclSetPathAny {
	return &Acl_AclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"acl-sets", "acl-set"},
			map[string]interface{}{"name": "*", "type": Type},
			n,
		),
	}
}

// AclSet (list): List of ACL sets, each comprising of a list of ACL
// entries
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-sets/acl-set"
// Path from root: "/acl/acl-sets/acl-set"
// Name: string
// Type: E_Acl_ACL_TYPE
func (n *AclPath) AclSet(Name string, Type E_Acl_ACL_TYPE) *Acl_AclSetPath {
	return &Acl_AclSetPath{
		NodePath: ygot.NewNodePath(
			[]string{"acl-sets", "acl-set"},
			map[string]interface{}{"name": Name, "type": Type},
			n,
		),
	}
}

// AclSet (list): List of ACL sets, each comprising of a list of ACL
// entries
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-sets/acl-set"
// Path from root: "/acl/acl-sets/acl-set"
// Name: string
// Type: E_Acl_ACL_TYPE
func (n *AclPathAny) AclSet(Name string, Type E_Acl_ACL_TYPE) *Acl_AclSetPathAny {
	return &Acl_AclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"acl-sets", "acl-set"},
			map[string]interface{}{"name": Name, "type": Type},
			n,
		),
	}
}

// CounterCapability (leaf): System reported indication of how ACL counters are reported
// by the target
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "state/counter-capability"
// Path from root: "/acl/state/counter-capability"
func (n *AclPath) CounterCapability() *Acl_CounterCapabilityPath {
	return &Acl_CounterCapabilityPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "counter-capability"},
			map[string]interface{}{},
			n,
		),
	}
}

// CounterCapability (leaf): System reported indication of how ACL counters are reported
// by the target
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "state/counter-capability"
// Path from root: "/acl/state/counter-capability"
func (n *AclPathAny) CounterCapability() *Acl_CounterCapabilityPathAny {
	return &Acl_CounterCapabilityPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "counter-capability"},
			map[string]interface{}{},
			n,
		),
	}
}

// InterfaceAny (list): List of interfaces on which ACLs are set. The interface is resolved
// based on the interface and subinterface leaves of the interface-ref
// container, which are references to entries in the /interfaces
// list. The key of the list is an arbitrary value that the
// implementation should not use to resolve an interface name.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "interfaces/interface"
// Path from root: "/acl/interfaces/interface"
// Id (wildcarded): string
func (n *AclPath) InterfaceAny() *Acl_InterfacePathAny {
	return &Acl_InterfacePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interfaces", "interface"},
			map[string]interface{}{"id": "*"},
			n,
		),
	}
}

// InterfaceAny (list): List of interfaces on which ACLs are set. The interface is resolved
// based on the interface and subinterface leaves of the interface-ref
// container, which are references to entries in the /interfaces
// list. The key of the list is an arbitrary value that the
// implementation should not use to resolve an interface name.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "interfaces/interface"
// Path from root: "/acl/interfaces/interface"
// Id (wildcarded): string
func (n *AclPathAny) InterfaceAny() *Acl_InterfacePathAny {
	return &Acl_InterfacePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interfaces", "interface"},
			map[string]interface{}{"id": "*"},
			n,
		),
	}
}

// Interface (list): List of interfaces on which ACLs are set. The interface is resolved
// based on the interface and subinterface leaves of the interface-ref
// container, which are references to entries in the /interfaces
// list. The key of the list is an arbitrary value that the
// implementation should not use to resolve an interface name.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "interfaces/interface"
// Path from root: "/acl/interfaces/interface"
// Id: string
func (n *AclPath) Interface(Id string) *Acl_InterfacePath {
	return &Acl_InterfacePath{
		NodePath: ygot.NewNodePath(
			[]string{"interfaces", "interface"},
			map[string]interface{}{"id": Id},
			n,
		),
	}
}

// Interface (list): List of interfaces on which ACLs are set. The interface is resolved
// based on the interface and subinterface leaves of the interface-ref
// container, which are references to entries in the /interfaces
// list. The key of the list is an arbitrary value that the
// implementation should not use to resolve an interface name.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "interfaces/interface"
// Path from root: "/acl/interfaces/interface"
// Id: string
func (n *AclPathAny) Interface(Id string) *Acl_InterfacePathAny {
	return &Acl_InterfacePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interfaces", "interface"},
			map[string]interface{}{"id": Id},
			n,
		),
	}
}

// Acl_AclSetPath represents the /openconfig-acl/acl/acl-sets/acl-set YANG schema element.
type Acl_AclSetPath struct {
	*ygot.NodePath
}

// Acl_AclSetPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set YANG schema element.
type Acl_AclSetPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_DescriptionPath represents the /openconfig-acl/acl/acl-sets/acl-set/config/description YANG schema element.
type Acl_AclSet_DescriptionPath struct {
	*ygot.NodePath
}

// Acl_AclSet_DescriptionPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/config/description YANG schema element.
type Acl_AclSet_DescriptionPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_NamePath represents the /openconfig-acl/acl/acl-sets/acl-set/config/name YANG schema element.
type Acl_AclSet_NamePath struct {
	*ygot.NodePath
}

// Acl_AclSet_NamePathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/config/name YANG schema element.
type Acl_AclSet_NamePathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_TypePath represents the /openconfig-acl/acl/acl-sets/acl-set/config/type YANG schema element.
type Acl_AclSet_TypePath struct {
	*ygot.NodePath
}

// Acl_AclSet_TypePathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/config/type YANG schema element.
type Acl_AclSet_TypePathAny struct {
	*ygot.NodePath
}

// AclEntryAny (list): List of ACL entries comprising an ACL set
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-entries/acl-entry"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry"
// SequenceId (wildcarded): uint32
func (n *Acl_AclSetPath) AclEntryAny() *Acl_AclSet_AclEntryPathAny {
	return &Acl_AclSet_AclEntryPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"acl-entries", "acl-entry"},
			map[string]interface{}{"sequence-id": "*"},
			n,
		),
	}
}

// AclEntryAny (list): List of ACL entries comprising an ACL set
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-entries/acl-entry"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry"
// SequenceId (wildcarded): uint32
func (n *Acl_AclSetPathAny) AclEntryAny() *Acl_AclSet_AclEntryPathAny {
	return &Acl_AclSet_AclEntryPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"acl-entries", "acl-entry"},
			map[string]interface{}{"sequence-id": "*"},
			n,
		),
	}
}

// AclEntry (list): List of ACL entries comprising an ACL set
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-entries/acl-entry"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry"
// SequenceId: uint32
func (n *Acl_AclSetPath) AclEntry(SequenceId uint32) *Acl_AclSet_AclEntryPath {
	return &Acl_AclSet_AclEntryPath{
		NodePath: ygot.NewNodePath(
			[]string{"acl-entries", "acl-entry"},
			map[string]interface{}{"sequence-id": SequenceId},
			n,
		),
	}
}

// AclEntry (list): List of ACL entries comprising an ACL set
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-entries/acl-entry"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry"
// SequenceId: uint32
func (n *Acl_AclSetPathAny) AclEntry(SequenceId uint32) *Acl_AclSet_AclEntryPathAny {
	return &Acl_AclSet_AclEntryPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"acl-entries", "acl-entry"},
			map[string]interface{}{"sequence-id": SequenceId},
			n,
		),
	}
}

// Description (leaf): Description, or comment, for the ACL set
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/description"
// Path from root: "/acl/acl-sets/acl-set/config/description"
func (n *Acl_AclSetPath) Description() *Acl_AclSet_DescriptionPath {
	return &Acl_AclSet_DescriptionPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "description"},
			map[string]interface{}{},
			n,
		),
	}
}

// Description (leaf): Description, or comment, for the ACL set
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/description"
// Path from root: "/acl/acl-sets/acl-set/config/description"
func (n *Acl_AclSetPathAny) Description() *Acl_AclSet_DescriptionPathAny {
	return &Acl_AclSet_DescriptionPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "description"},
			map[string]interface{}{},
			n,
		),
	}
}

// Name (leaf): The name of the access-list set
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/name"
// Path from root: "/acl/acl-sets/acl-set/config/name"
func (n *Acl_AclSetPath) Name() *Acl_AclSet_NamePath {
	return &Acl_AclSet_NamePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "name"},
			map[string]interface{}{},
			n,
		),
	}
}

// Name (leaf): The name of the access-list set
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/name"
// Path from root: "/acl/acl-sets/acl-set/config/name"
func (n *Acl_AclSetPathAny) Name() *Acl_AclSet_NamePathAny {
	return &Acl_AclSet_NamePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "name"},
			map[string]interface{}{},
			n,
		),
	}
}

// Type (leaf): The type determines the fields allowed in the ACL entries
// belonging to the ACL set (e.g., IPv4, IPv6, etc.)
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/type"
// Path from root: "/acl/acl-sets/acl-set/config/type"
func (n *Acl_AclSetPath) Type() *Acl_AclSet_TypePath {
	return &Acl_AclSet_TypePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "type"},
			map[string]interface{}{},
			n,
		),
	}
}

// Type (leaf): The type determines the fields allowed in the ACL entries
// belonging to the ACL set (e.g., IPv4, IPv6, etc.)
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/type"
// Path from root: "/acl/acl-sets/acl-set/config/type"
func (n *Acl_AclSetPathAny) Type() *Acl_AclSet_TypePathAny {
	return &Acl_AclSet_TypePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "type"},
			map[string]interface{}{},
			n,
		),
	}
}

// Acl_AclSet_AclEntryPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry YANG schema element.
type Acl_AclSet_AclEntryPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntryPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry YANG schema element.
type Acl_AclSet_AclEntryPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_DescriptionPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/config/description YANG schema element.
type Acl_AclSet_AclEntry_DescriptionPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_DescriptionPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/config/description YANG schema element.
type Acl_AclSet_AclEntry_DescriptionPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_MatchedOctetsPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/state/matched-octets YANG schema element.
type Acl_AclSet_AclEntry_MatchedOctetsPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_MatchedOctetsPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/state/matched-octets YANG schema element.
type Acl_AclSet_AclEntry_MatchedOctetsPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_MatchedPacketsPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/state/matched-packets YANG schema element.
type Acl_AclSet_AclEntry_MatchedPacketsPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_MatchedPacketsPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/state/matched-packets YANG schema element.
type Acl_AclSet_AclEntry_MatchedPacketsPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_SequenceIdPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/config/sequence-id YANG schema element.
type Acl_AclSet_AclEntry_SequenceIdPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_SequenceIdPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/config/sequence-id YANG schema element.
type Acl_AclSet_AclEntry_SequenceIdPathAny struct {
	*ygot.NodePath
}

// Actions (container): Enclosing container for list of ACL actions associated
// with an entry
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "actions"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/actions"
func (n *Acl_AclSet_AclEntryPath) Actions() *Acl_AclSet_AclEntry_ActionsPath {
	return &Acl_AclSet_AclEntry_ActionsPath{
		NodePath: ygot.NewNodePath(
			[]string{"actions"},
			map[string]interface{}{},
			n,
		),
	}
}

// Actions (container): Enclosing container for list of ACL actions associated
// with an entry
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "actions"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/actions"
func (n *Acl_AclSet_AclEntryPathAny) Actions() *Acl_AclSet_AclEntry_ActionsPathAny {
	return &Acl_AclSet_AclEntry_ActionsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"actions"},
			map[string]interface{}{},
			n,
		),
	}
}

// Description (leaf): A user-defined description, or comment, for this Access List
// Entry.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/description"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/config/description"
func (n *Acl_AclSet_AclEntryPath) Description() *Acl_AclSet_AclEntry_DescriptionPath {
	return &Acl_AclSet_AclEntry_DescriptionPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "description"},
			map[string]interface{}{},
			n,
		),
	}
}

// Description (leaf): A user-defined description, or comment, for this Access List
// Entry.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/description"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/config/description"
func (n *Acl_AclSet_AclEntryPathAny) Description() *Acl_AclSet_AclEntry_DescriptionPathAny {
	return &Acl_AclSet_AclEntry_DescriptionPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "description"},
			map[string]interface{}{},
			n,
		),
	}
}

// InputInterface (container): Input interface container. The interface is resolved based
// on the interface and subinterface leaves of the interface-ref
// container, which are references to entries in the /interfaces
// list.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "input-interface"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface"
func (n *Acl_AclSet_AclEntryPath) InputInterface() *Acl_AclSet_AclEntry_InputInterfacePath {
	return &Acl_AclSet_AclEntry_InputInterfacePath{
		NodePath: ygot.NewNodePath(
			[]string{"input-interface"},
			map[string]interface{}{},
			n,
		),
	}
}

// InputInterface (container): Input interface container. The interface is resolved based
// on the interface and subinterface leaves of the interface-ref
// container, which are references to entries in the /interfaces
// list.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "input-interface"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface"
func (n *Acl_AclSet_AclEntryPathAny) InputInterface() *Acl_AclSet_AclEntry_InputInterfacePathAny {
	return &Acl_AclSet_AclEntry_InputInterfacePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"input-interface"},
			map[string]interface{}{},
			n,
		),
	}
}

// Ipv4 (container): Top level container for IPv4 match field data
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "ipv4"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4"
func (n *Acl_AclSet_AclEntryPath) Ipv4() *Acl_AclSet_AclEntry_Ipv4Path {
	return &Acl_AclSet_AclEntry_Ipv4Path{
		NodePath: ygot.NewNodePath(
			[]string{"ipv4"},
			map[string]interface{}{},
			n,
		),
	}
}

// Ipv4 (container): Top level container for IPv4 match field data
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "ipv4"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4"
func (n *Acl_AclSet_AclEntryPathAny) Ipv4() *Acl_AclSet_AclEntry_Ipv4PathAny {
	return &Acl_AclSet_AclEntry_Ipv4PathAny{
		NodePath: ygot.NewNodePath(
			[]string{"ipv4"},
			map[string]interface{}{},
			n,
		),
	}
}

// Ipv6 (container): Top-level container for IPv6 match field data
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "ipv6"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6"
func (n *Acl_AclSet_AclEntryPath) Ipv6() *Acl_AclSet_AclEntry_Ipv6Path {
	return &Acl_AclSet_AclEntry_Ipv6Path{
		NodePath: ygot.NewNodePath(
			[]string{"ipv6"},
			map[string]interface{}{},
			n,
		),
	}
}

// Ipv6 (container): Top-level container for IPv6 match field data
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "ipv6"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6"
func (n *Acl_AclSet_AclEntryPathAny) Ipv6() *Acl_AclSet_AclEntry_Ipv6PathAny {
	return &Acl_AclSet_AclEntry_Ipv6PathAny{
		NodePath: ygot.NewNodePath(
			[]string{"ipv6"},
			map[string]interface{}{},
			n,
		),
	}
}

// L2 (container): Ethernet header fields
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "l2"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/l2"
func (n *Acl_AclSet_AclEntryPath) L2() *Acl_AclSet_AclEntry_L2Path {
	return &Acl_AclSet_AclEntry_L2Path{
		NodePath: ygot.NewNodePath(
			[]string{"l2"},
			map[string]interface{}{},
			n,
		),
	}
}

// L2 (container): Ethernet header fields
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "l2"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/l2"
func (n *Acl_AclSet_AclEntryPathAny) L2() *Acl_AclSet_AclEntry_L2PathAny {
	return &Acl_AclSet_AclEntry_L2PathAny{
		NodePath: ygot.NewNodePath(
			[]string{"l2"},
			map[string]interface{}{},
			n,
		),
	}
}

// MatchedOctets (leaf): Count of the number of octets (bytes) matching the current
// ACL entry.
//
// An implementation should provide this counter on a
// per-interface per-ACL-entry if possible.
//
// If an implementation only supports ACL counters per entry
// (i.e., not broken out per interface), then the value
// should be equal to the aggregate count across all interfaces.
//
// An implementation that provides counters per entry per
// interface is not required to also provide an aggregate count,
// e.g., per entry -- the user is expected to be able implement
// the required aggregation if such a count is needed.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "state/matched-octets"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/state/matched-octets"
func (n *Acl_AclSet_AclEntryPath) MatchedOctets() *Acl_AclSet_AclEntry_MatchedOctetsPath {
	return &Acl_AclSet_AclEntry_MatchedOctetsPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "matched-octets"},
			map[string]interface{}{},
			n,
		),
	}
}

// MatchedOctets (leaf): Count of the number of octets (bytes) matching the current
// ACL entry.
//
// An implementation should provide this counter on a
// per-interface per-ACL-entry if possible.
//
// If an implementation only supports ACL counters per entry
// (i.e., not broken out per interface), then the value
// should be equal to the aggregate count across all interfaces.
//
// An implementation that provides counters per entry per
// interface is not required to also provide an aggregate count,
// e.g., per entry -- the user is expected to be able implement
// the required aggregation if such a count is needed.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "state/matched-octets"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/state/matched-octets"
func (n *Acl_AclSet_AclEntryPathAny) MatchedOctets() *Acl_AclSet_AclEntry_MatchedOctetsPathAny {
	return &Acl_AclSet_AclEntry_MatchedOctetsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "matched-octets"},
			map[string]interface{}{},
			n,
		),
	}
}

// MatchedPackets (leaf): Count of the number of packets matching the current ACL
// entry.
//
// An implementation should provide this counter on a
// per-interface per-ACL-entry if possible.
//
// If an implementation only supports ACL counters per entry
// (i.e., not broken out per interface), then the value
// should be equal to the aggregate count across all interfaces.
//
// An implementation that provides counters per entry per
// interface is not required to also provide an aggregate count,
// e.g., per entry -- the user is expected to be able implement
// the required aggregation if such a count is needed.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "state/matched-packets"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/state/matched-packets"
func (n *Acl_AclSet_AclEntryPath) MatchedPackets() *Acl_AclSet_AclEntry_MatchedPacketsPath {
	return &Acl_AclSet_AclEntry_MatchedPacketsPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "matched-packets"},
			map[string]interface{}{},
			n,
		),
	}
}

// MatchedPackets (leaf): Count of the number of packets matching the current ACL
// entry.
//
// An implementation should provide this counter on a
// per-interface per-ACL-entry if possible.
//
// If an implementation only supports ACL counters per entry
// (i.e., not broken out per interface), then the value
// should be equal to the aggregate count across all interfaces.
//
// An implementation that provides counters per entry per
// interface is not required to also provide an aggregate count,
// e.g., per entry -- the user is expected to be able implement
// the required aggregation if such a count is needed.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "state/matched-packets"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/state/matched-packets"
func (n *Acl_AclSet_AclEntryPathAny) MatchedPackets() *Acl_AclSet_AclEntry_MatchedPacketsPathAny {
	return &Acl_AclSet_AclEntry_MatchedPacketsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "matched-packets"},
			map[string]interface{}{},
			n,
		),
	}
}

// Mpls (container): MPLS header fields
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "mpls"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls"
func (n *Acl_AclSet_AclEntryPath) Mpls() *Acl_AclSet_AclEntry_MplsPath {
	return &Acl_AclSet_AclEntry_MplsPath{
		NodePath: ygot.NewNodePath(
			[]string{"mpls"},
			map[string]interface{}{},
			n,
		),
	}
}

// Mpls (container): MPLS header fields
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "mpls"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls"
func (n *Acl_AclSet_AclEntryPathAny) Mpls() *Acl_AclSet_AclEntry_MplsPathAny {
	return &Acl_AclSet_AclEntry_MplsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"mpls"},
			map[string]interface{}{},
			n,
		),
	}
}

// SequenceId (leaf): The sequence id determines the order in which ACL entries
// are applied.  The sequence id must be unique for each entry
// in an ACL set.  Target devices should apply the ACL entry
// rules in ascending order determined by sequence id (low to
// high), rather than the relying only on order in the list.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/sequence-id"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/config/sequence-id"
func (n *Acl_AclSet_AclEntryPath) SequenceId() *Acl_AclSet_AclEntry_SequenceIdPath {
	return &Acl_AclSet_AclEntry_SequenceIdPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "sequence-id"},
			map[string]interface{}{},
			n,
		),
	}
}

// SequenceId (leaf): The sequence id determines the order in which ACL entries
// are applied.  The sequence id must be unique for each entry
// in an ACL set.  Target devices should apply the ACL entry
// rules in ascending order determined by sequence id (low to
// high), rather than the relying only on order in the list.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/sequence-id"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/config/sequence-id"
func (n *Acl_AclSet_AclEntryPathAny) SequenceId() *Acl_AclSet_AclEntry_SequenceIdPathAny {
	return &Acl_AclSet_AclEntry_SequenceIdPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "sequence-id"},
			map[string]interface{}{},
			n,
		),
	}
}

// Transport (container): Transport fields container
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "transport"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/transport"
func (n *Acl_AclSet_AclEntryPath) Transport() *Acl_AclSet_AclEntry_TransportPath {
	return &Acl_AclSet_AclEntry_TransportPath{
		NodePath: ygot.NewNodePath(
			[]string{"transport"},
			map[string]interface{}{},
			n,
		),
	}
}

// Transport (container): Transport fields container
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "transport"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/transport"
func (n *Acl_AclSet_AclEntryPathAny) Transport() *Acl_AclSet_AclEntry_TransportPathAny {
	return &Acl_AclSet_AclEntry_TransportPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"transport"},
			map[string]interface{}{},
			n,
		),
	}
}

// Acl_AclSet_AclEntry_ActionsPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions YANG schema element.
type Acl_AclSet_AclEntry_ActionsPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_ActionsPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions YANG schema element.
type Acl_AclSet_AclEntry_ActionsPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Actions_ForwardingActionPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions/config/forwarding-action YANG schema element.
type Acl_AclSet_AclEntry_Actions_ForwardingActionPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Actions_ForwardingActionPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions/config/forwarding-action YANG schema element.
type Acl_AclSet_AclEntry_Actions_ForwardingActionPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Actions_LogActionPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions/config/log-action YANG schema element.
type Acl_AclSet_AclEntry_Actions_LogActionPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Actions_LogActionPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/actions/config/log-action YANG schema element.
type Acl_AclSet_AclEntry_Actions_LogActionPathAny struct {
	*ygot.NodePath
}

// ForwardingAction (leaf): Specifies the forwarding action.  One forwarding action
// must be specified for each ACL entry
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/forwarding-action"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/actions/config/forwarding-action"
func (n *Acl_AclSet_AclEntry_ActionsPath) ForwardingAction() *Acl_AclSet_AclEntry_Actions_ForwardingActionPath {
	return &Acl_AclSet_AclEntry_Actions_ForwardingActionPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "forwarding-action"},
			map[string]interface{}{},
			n,
		),
	}
}

// ForwardingAction (leaf): Specifies the forwarding action.  One forwarding action
// must be specified for each ACL entry
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/forwarding-action"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/actions/config/forwarding-action"
func (n *Acl_AclSet_AclEntry_ActionsPathAny) ForwardingAction() *Acl_AclSet_AclEntry_Actions_ForwardingActionPathAny {
	return &Acl_AclSet_AclEntry_Actions_ForwardingActionPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "forwarding-action"},
			map[string]interface{}{},
			n,
		),
	}
}

// LogAction (leaf): Specifies the log action and destination for
// matched packets.  The default is not to log the
// packet.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/log-action"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/actions/config/log-action"
func (n *Acl_AclSet_AclEntry_ActionsPath) LogAction() *Acl_AclSet_AclEntry_Actions_LogActionPath {
	return &Acl_AclSet_AclEntry_Actions_LogActionPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "log-action"},
			map[string]interface{}{},
			n,
		),
	}
}

// LogAction (leaf): Specifies the log action and destination for
// matched packets.  The default is not to log the
// packet.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/log-action"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/actions/config/log-action"
func (n *Acl_AclSet_AclEntry_ActionsPathAny) LogAction() *Acl_AclSet_AclEntry_Actions_LogActionPathAny {
	return &Acl_AclSet_AclEntry_Actions_LogActionPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "log-action"},
			map[string]interface{}{},
			n,
		),
	}
}

// Acl_AclSet_AclEntry_InputInterfacePath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface YANG schema element.
type Acl_AclSet_AclEntry_InputInterfacePath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_InputInterfacePathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface YANG schema element.
type Acl_AclSet_AclEntry_InputInterfacePathAny struct {
	*ygot.NodePath
}

// InterfaceRef (container): Reference to an interface or subinterface. The interface
// that is being referenced is uniquely referenced based on
// the specified interface and subinterface leaves. In contexts
// where a Layer 3 interface is to be referenced, both the
// interface and subinterface leaves must be populated, as
// Layer 3 configuration within the OpenConfig models is
// associated with a subinterface. In the case where a
// Layer 2 interface is to be referenced, only the
// interface is specified.
//
// The interface/subinterface leaf tuple must be used as
// the means by which the interface is specified, regardless
// of any other context information (e.g., key in a list).
// ----------------------------------------
// Defining module: "openconfig-interfaces"
// Instantiating module: "openconfig-acl"
// Path from parent: "interface-ref"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref"
func (n *Acl_AclSet_AclEntry_InputInterfacePath) InterfaceRef() *Acl_AclSet_AclEntry_InputInterface_InterfaceRefPath {
	return &Acl_AclSet_AclEntry_InputInterface_InterfaceRefPath{
		NodePath: ygot.NewNodePath(
			[]string{"interface-ref"},
			map[string]interface{}{},
			n,
		),
	}
}

// InterfaceRef (container): Reference to an interface or subinterface. The interface
// that is being referenced is uniquely referenced based on
// the specified interface and subinterface leaves. In contexts
// where a Layer 3 interface is to be referenced, both the
// interface and subinterface leaves must be populated, as
// Layer 3 configuration within the OpenConfig models is
// associated with a subinterface. In the case where a
// Layer 2 interface is to be referenced, only the
// interface is specified.
//
// The interface/subinterface leaf tuple must be used as
// the means by which the interface is specified, regardless
// of any other context information (e.g., key in a list).
// ----------------------------------------
// Defining module: "openconfig-interfaces"
// Instantiating module: "openconfig-acl"
// Path from parent: "interface-ref"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref"
func (n *Acl_AclSet_AclEntry_InputInterfacePathAny) InterfaceRef() *Acl_AclSet_AclEntry_InputInterface_InterfaceRefPathAny {
	return &Acl_AclSet_AclEntry_InputInterface_InterfaceRefPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interface-ref"},
			map[string]interface{}{},
			n,
		),
	}
}

// Acl_AclSet_AclEntry_InputInterface_InterfaceRefPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref YANG schema element.
type Acl_AclSet_AclEntry_InputInterface_InterfaceRefPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_InputInterface_InterfaceRefPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref YANG schema element.
type Acl_AclSet_AclEntry_InputInterface_InterfaceRefPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_InputInterface_InterfaceRef_InterfacePath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/config/interface YANG schema element.
type Acl_AclSet_AclEntry_InputInterface_InterfaceRef_InterfacePath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_InputInterface_InterfaceRef_InterfacePathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/config/interface YANG schema element.
type Acl_AclSet_AclEntry_InputInterface_InterfaceRef_InterfacePathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_InputInterface_InterfaceRef_SubinterfacePath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/config/subinterface YANG schema element.
type Acl_AclSet_AclEntry_InputInterface_InterfaceRef_SubinterfacePath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_InputInterface_InterfaceRef_SubinterfacePathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/config/subinterface YANG schema element.
type Acl_AclSet_AclEntry_InputInterface_InterfaceRef_SubinterfacePathAny struct {
	*ygot.NodePath
}

// Interface (leaf): Reference to a base interface.  If a reference to a
// subinterface is required, this leaf must be specified
// to indicate the base interface.
// ----------------------------------------
// Defining module: "openconfig-interfaces"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/interface"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/config/interface"
func (n *Acl_AclSet_AclEntry_InputInterface_InterfaceRefPath) Interface() *Acl_AclSet_AclEntry_InputInterface_InterfaceRef_InterfacePath {
	return &Acl_AclSet_AclEntry_InputInterface_InterfaceRef_InterfacePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "interface"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interface (leaf): Reference to a base interface.  If a reference to a
// subinterface is required, this leaf must be specified
// to indicate the base interface.
// ----------------------------------------
// Defining module: "openconfig-interfaces"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/interface"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/config/interface"
func (n *Acl_AclSet_AclEntry_InputInterface_InterfaceRefPathAny) Interface() *Acl_AclSet_AclEntry_InputInterface_InterfaceRef_InterfacePathAny {
	return &Acl_AclSet_AclEntry_InputInterface_InterfaceRef_InterfacePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "interface"},
			map[string]interface{}{},
			n,
		),
	}
}

// Subinterface (leaf): Reference to a subinterface -- this requires the base
// interface to be specified using the interface leaf in
// this container.  If only a reference to a base interface
// is requuired, this leaf should not be set.
// ----------------------------------------
// Defining module: "openconfig-interfaces"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/subinterface"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/config/subinterface"
func (n *Acl_AclSet_AclEntry_InputInterface_InterfaceRefPath) Subinterface() *Acl_AclSet_AclEntry_InputInterface_InterfaceRef_SubinterfacePath {
	return &Acl_AclSet_AclEntry_InputInterface_InterfaceRef_SubinterfacePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "subinterface"},
			map[string]interface{}{},
			n,
		),
	}
}

// Subinterface (leaf): Reference to a subinterface -- this requires the base
// interface to be specified using the interface leaf in
// this container.  If only a reference to a base interface
// is requuired, this leaf should not be set.
// ----------------------------------------
// Defining module: "openconfig-interfaces"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/subinterface"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/config/subinterface"
func (n *Acl_AclSet_AclEntry_InputInterface_InterfaceRefPathAny) Subinterface() *Acl_AclSet_AclEntry_InputInterface_InterfaceRef_SubinterfacePathAny {
	return &Acl_AclSet_AclEntry_InputInterface_InterfaceRef_SubinterfacePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "subinterface"},
			map[string]interface{}{},
			n,
		),
	}
}

// Acl_AclSet_AclEntry_Ipv4Path represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4 YANG schema element.
type Acl_AclSet_AclEntry_Ipv4Path struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4PathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4 YANG schema element.
type Acl_AclSet_AclEntry_Ipv4PathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_DestinationAddressPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/destination-address YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_DestinationAddressPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_DestinationAddressPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/destination-address YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_DestinationAddressPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_DestinationAddressPrefixSetPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/destination-address-prefix-set YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_DestinationAddressPrefixSetPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_DestinationAddressPrefixSetPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/destination-address-prefix-set YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_DestinationAddressPrefixSetPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_DscpPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/dscp YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_DscpPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_DscpPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/dscp YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_DscpPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_DscpSetPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/dscp-set YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_DscpSetPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_DscpSetPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/dscp-set YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_DscpSetPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_HopLimitPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/hop-limit YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_HopLimitPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_HopLimitPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/hop-limit YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_HopLimitPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_LengthPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/length YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_LengthPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_LengthPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/length YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_LengthPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_ProtocolPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/protocol YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_ProtocolPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_ProtocolPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/protocol YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_ProtocolPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_SourceAddressPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/source-address YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_SourceAddressPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_SourceAddressPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/source-address YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_SourceAddressPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_SourceAddressPrefixSetPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/source-address-prefix-set YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_SourceAddressPrefixSetPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_SourceAddressPrefixSetPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/source-address-prefix-set YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_SourceAddressPrefixSetPathAny struct {
	*ygot.NodePath
}

// DestinationAddress (leaf): Destination IPv4 address prefix.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/destination-address"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/destination-address"
func (n *Acl_AclSet_AclEntry_Ipv4Path) DestinationAddress() *Acl_AclSet_AclEntry_Ipv4_DestinationAddressPath {
	return &Acl_AclSet_AclEntry_Ipv4_DestinationAddressPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "destination-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// DestinationAddress (leaf): Destination IPv4 address prefix.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/destination-address"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/destination-address"
func (n *Acl_AclSet_AclEntry_Ipv4PathAny) DestinationAddress() *Acl_AclSet_AclEntry_Ipv4_DestinationAddressPathAny {
	return &Acl_AclSet_AclEntry_Ipv4_DestinationAddressPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "destination-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// DestinationAddressPrefixSet (leaf): Reference to a IPv4 address prefix set
// to match the destination address
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/destination-address-prefix-set"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/destination-address-prefix-set"
func (n *Acl_AclSet_AclEntry_Ipv4Path) DestinationAddressPrefixSet() *Acl_AclSet_AclEntry_Ipv4_DestinationAddressPrefixSetPath {
	return &Acl_AclSet_AclEntry_Ipv4_DestinationAddressPrefixSetPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "destination-address-prefix-set"},
			map[string]interface{}{},
			n,
		),
	}
}

// DestinationAddressPrefixSet (leaf): Reference to a IPv4 address prefix set
// to match the destination address
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/destination-address-prefix-set"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/destination-address-prefix-set"
func (n *Acl_AclSet_AclEntry_Ipv4PathAny) DestinationAddressPrefixSet() *Acl_AclSet_AclEntry_Ipv4_DestinationAddressPrefixSetPathAny {
	return &Acl_AclSet_AclEntry_Ipv4_DestinationAddressPrefixSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "destination-address-prefix-set"},
			map[string]interface{}{},
			n,
		),
	}
}

// Dscp (leaf): Value of diffserv codepoint.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/dscp"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/dscp"
func (n *Acl_AclSet_AclEntry_Ipv4Path) Dscp() *Acl_AclSet_AclEntry_Ipv4_DscpPath {
	return &Acl_AclSet_AclEntry_Ipv4_DscpPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "dscp"},
			map[string]interface{}{},
			n,
		),
	}
}

// Dscp (leaf): Value of diffserv codepoint.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/dscp"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/dscp"
func (n *Acl_AclSet_AclEntry_Ipv4PathAny) Dscp() *Acl_AclSet_AclEntry_Ipv4_DscpPathAny {
	return &Acl_AclSet_AclEntry_Ipv4_DscpPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "dscp"},
			map[string]interface{}{},
			n,
		),
	}
}

// DscpSet (leaf-list): A list of DSCP values to be matched for incoming packets. AN OR match should
// be performed, such that a packet must match one of the values defined in this
// list. If the field is left empty then any DSCP value matches unless the 'dscp'
// leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/dscp-set"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/dscp-set"
func (n *Acl_AclSet_AclEntry_Ipv4Path) DscpSet() *Acl_AclSet_AclEntry_Ipv4_DscpSetPath {
	return &Acl_AclSet_AclEntry_Ipv4_DscpSetPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "dscp-set"},
			map[string]interface{}{},
			n,
		),
	}
}

// DscpSet (leaf-list): A list of DSCP values to be matched for incoming packets. AN OR match should
// be performed, such that a packet must match one of the values defined in this
// list. If the field is left empty then any DSCP value matches unless the 'dscp'
// leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/dscp-set"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/dscp-set"
func (n *Acl_AclSet_AclEntry_Ipv4PathAny) DscpSet() *Acl_AclSet_AclEntry_Ipv4_DscpSetPathAny {
	return &Acl_AclSet_AclEntry_Ipv4_DscpSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "dscp-set"},
			map[string]interface{}{},
			n,
		),
	}
}

// HopLimit (leaf): The IP packet's hop limit -- known as TTL (in hops) in
// IPv4 packets, and hop limit in IPv6
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/hop-limit"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/hop-limit"
func (n *Acl_AclSet_AclEntry_Ipv4Path) HopLimit() *Acl_AclSet_AclEntry_Ipv4_HopLimitPath {
	return &Acl_AclSet_AclEntry_Ipv4_HopLimitPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "hop-limit"},
			map[string]interface{}{},
			n,
		),
	}
}

// HopLimit (leaf): The IP packet's hop limit -- known as TTL (in hops) in
// IPv4 packets, and hop limit in IPv6
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/hop-limit"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/hop-limit"
func (n *Acl_AclSet_AclEntry_Ipv4PathAny) HopLimit() *Acl_AclSet_AclEntry_Ipv4_HopLimitPathAny {
	return &Acl_AclSet_AclEntry_Ipv4_HopLimitPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "hop-limit"},
			map[string]interface{}{},
			n,
		),
	}
}

// Icmpv4 (container): Top container for ICMPv4 filtering
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "icmpv4"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/icmpv4"
func (n *Acl_AclSet_AclEntry_Ipv4Path) Icmpv4() *Acl_AclSet_AclEntry_Ipv4_Icmpv4Path {
	return &Acl_AclSet_AclEntry_Ipv4_Icmpv4Path{
		NodePath: ygot.NewNodePath(
			[]string{"icmpv4"},
			map[string]interface{}{},
			n,
		),
	}
}

// Icmpv4 (container): Top container for ICMPv4 filtering
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "icmpv4"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/icmpv4"
func (n *Acl_AclSet_AclEntry_Ipv4PathAny) Icmpv4() *Acl_AclSet_AclEntry_Ipv4_Icmpv4PathAny {
	return &Acl_AclSet_AclEntry_Ipv4_Icmpv4PathAny{
		NodePath: ygot.NewNodePath(
			[]string{"icmpv4"},
			map[string]interface{}{},
			n,
		),
	}
}

// Length (leaf): In the IPv4 header field, this field is known as the Total
// Length.  Total Length is the length of the datagram, measured
// in octets, including internet header and data.
// In the IPv6 header field, this field is known as the Payload
// Length, which is the length of the IPv6 payload, i.e., the rest
// of the packet following the IPv6 header, in octets.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/length"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/length"
func (n *Acl_AclSet_AclEntry_Ipv4Path) Length() *Acl_AclSet_AclEntry_Ipv4_LengthPath {
	return &Acl_AclSet_AclEntry_Ipv4_LengthPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "length"},
			map[string]interface{}{},
			n,
		),
	}
}

// Length (leaf): In the IPv4 header field, this field is known as the Total
// Length.  Total Length is the length of the datagram, measured
// in octets, including internet header and data.
// In the IPv6 header field, this field is known as the Payload
// Length, which is the length of the IPv6 payload, i.e., the rest
// of the packet following the IPv6 header, in octets.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/length"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/length"
func (n *Acl_AclSet_AclEntry_Ipv4PathAny) Length() *Acl_AclSet_AclEntry_Ipv4_LengthPathAny {
	return &Acl_AclSet_AclEntry_Ipv4_LengthPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "length"},
			map[string]interface{}{},
			n,
		),
	}
}

// Protocol (leaf): The protocol carried in the IP packet, expressed either
// as its IP protocol number, or by a defined identity.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/protocol"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/protocol"
func (n *Acl_AclSet_AclEntry_Ipv4Path) Protocol() *Acl_AclSet_AclEntry_Ipv4_ProtocolPath {
	return &Acl_AclSet_AclEntry_Ipv4_ProtocolPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "protocol"},
			map[string]interface{}{},
			n,
		),
	}
}

// Protocol (leaf): The protocol carried in the IP packet, expressed either
// as its IP protocol number, or by a defined identity.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/protocol"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/protocol"
func (n *Acl_AclSet_AclEntry_Ipv4PathAny) Protocol() *Acl_AclSet_AclEntry_Ipv4_ProtocolPathAny {
	return &Acl_AclSet_AclEntry_Ipv4_ProtocolPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "protocol"},
			map[string]interface{}{},
			n,
		),
	}
}

// SourceAddress (leaf): Source IPv4 address prefix.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/source-address"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/source-address"
func (n *Acl_AclSet_AclEntry_Ipv4Path) SourceAddress() *Acl_AclSet_AclEntry_Ipv4_SourceAddressPath {
	return &Acl_AclSet_AclEntry_Ipv4_SourceAddressPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "source-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// SourceAddress (leaf): Source IPv4 address prefix.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/source-address"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/source-address"
func (n *Acl_AclSet_AclEntry_Ipv4PathAny) SourceAddress() *Acl_AclSet_AclEntry_Ipv4_SourceAddressPathAny {
	return &Acl_AclSet_AclEntry_Ipv4_SourceAddressPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "source-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// SourceAddressPrefixSet (leaf): Reference to a IPv4 address prefix Set
// to match the source address
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/source-address-prefix-set"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/source-address-prefix-set"
func (n *Acl_AclSet_AclEntry_Ipv4Path) SourceAddressPrefixSet() *Acl_AclSet_AclEntry_Ipv4_SourceAddressPrefixSetPath {
	return &Acl_AclSet_AclEntry_Ipv4_SourceAddressPrefixSetPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "source-address-prefix-set"},
			map[string]interface{}{},
			n,
		),
	}
}

// SourceAddressPrefixSet (leaf): Reference to a IPv4 address prefix Set
// to match the source address
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/source-address-prefix-set"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config/source-address-prefix-set"
func (n *Acl_AclSet_AclEntry_Ipv4PathAny) SourceAddressPrefixSet() *Acl_AclSet_AclEntry_Ipv4_SourceAddressPrefixSetPathAny {
	return &Acl_AclSet_AclEntry_Ipv4_SourceAddressPrefixSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "source-address-prefix-set"},
			map[string]interface{}{},
			n,
		),
	}
}

// Acl_AclSet_AclEntry_Ipv4_Icmpv4Path represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/icmpv4 YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_Icmpv4Path struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_Icmpv4PathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/icmpv4 YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_Icmpv4PathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_Icmpv4_CodePath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/icmpv4/config/code YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_Icmpv4_CodePath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_Icmpv4_CodePathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/icmpv4/config/code YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_Icmpv4_CodePathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_Icmpv4_TypePath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/icmpv4/config/type YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_Icmpv4_TypePath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv4_Icmpv4_TypePathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/icmpv4/config/type YANG schema element.
type Acl_AclSet_AclEntry_Ipv4_Icmpv4_TypePathAny struct {
	*ygot.NodePath
}

// Code (leaf): ICMPv4 code to be matched.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/code"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/icmpv4/config/code"
func (n *Acl_AclSet_AclEntry_Ipv4_Icmpv4Path) Code() *Acl_AclSet_AclEntry_Ipv4_Icmpv4_CodePath {
	return &Acl_AclSet_AclEntry_Ipv4_Icmpv4_CodePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "code"},
			map[string]interface{}{},
			n,
		),
	}
}

// Code (leaf): ICMPv4 code to be matched.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/code"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/icmpv4/config/code"
func (n *Acl_AclSet_AclEntry_Ipv4_Icmpv4PathAny) Code() *Acl_AclSet_AclEntry_Ipv4_Icmpv4_CodePathAny {
	return &Acl_AclSet_AclEntry_Ipv4_Icmpv4_CodePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "code"},
			map[string]interface{}{},
			n,
		),
	}
}

// Type (leaf): ICMPv4 type to be matched.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/type"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/icmpv4/config/type"
func (n *Acl_AclSet_AclEntry_Ipv4_Icmpv4Path) Type() *Acl_AclSet_AclEntry_Ipv4_Icmpv4_TypePath {
	return &Acl_AclSet_AclEntry_Ipv4_Icmpv4_TypePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "type"},
			map[string]interface{}{},
			n,
		),
	}
}

// Type (leaf): ICMPv4 type to be matched.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/type"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/icmpv4/config/type"
func (n *Acl_AclSet_AclEntry_Ipv4_Icmpv4PathAny) Type() *Acl_AclSet_AclEntry_Ipv4_Icmpv4_TypePathAny {
	return &Acl_AclSet_AclEntry_Ipv4_Icmpv4_TypePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "type"},
			map[string]interface{}{},
			n,
		),
	}
}

// Acl_AclSet_AclEntry_Ipv6Path represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6 YANG schema element.
type Acl_AclSet_AclEntry_Ipv6Path struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6PathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6 YANG schema element.
type Acl_AclSet_AclEntry_Ipv6PathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_DestinationAddressPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/destination-address YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_DestinationAddressPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_DestinationAddressPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/destination-address YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_DestinationAddressPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_DestinationAddressPrefixSetPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/destination-address-prefix-set YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_DestinationAddressPrefixSetPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_DestinationAddressPrefixSetPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/destination-address-prefix-set YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_DestinationAddressPrefixSetPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_DestinationFlowLabelPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/destination-flow-label YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_DestinationFlowLabelPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_DestinationFlowLabelPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/destination-flow-label YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_DestinationFlowLabelPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_DscpPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/dscp YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_DscpPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_DscpPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/dscp YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_DscpPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_DscpSetPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/dscp-set YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_DscpSetPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_DscpSetPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/dscp-set YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_DscpSetPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_HopLimitPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/hop-limit YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_HopLimitPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_HopLimitPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/hop-limit YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_HopLimitPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_LengthPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/length YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_LengthPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_LengthPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/length YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_LengthPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_ProtocolPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/protocol YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_ProtocolPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_ProtocolPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/protocol YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_ProtocolPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_SourceAddressPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/source-address YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_SourceAddressPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_SourceAddressPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/source-address YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_SourceAddressPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_SourceAddressPrefixSetPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/source-address-prefix-set YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_SourceAddressPrefixSetPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_SourceAddressPrefixSetPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/source-address-prefix-set YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_SourceAddressPrefixSetPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_SourceFlowLabelPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/source-flow-label YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_SourceFlowLabelPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_SourceFlowLabelPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/source-flow-label YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_SourceFlowLabelPathAny struct {
	*ygot.NodePath
}

// DestinationAddress (leaf): Destination IPv6 address prefix.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/destination-address"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/destination-address"
func (n *Acl_AclSet_AclEntry_Ipv6Path) DestinationAddress() *Acl_AclSet_AclEntry_Ipv6_DestinationAddressPath {
	return &Acl_AclSet_AclEntry_Ipv6_DestinationAddressPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "destination-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// DestinationAddress (leaf): Destination IPv6 address prefix.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/destination-address"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/destination-address"
func (n *Acl_AclSet_AclEntry_Ipv6PathAny) DestinationAddress() *Acl_AclSet_AclEntry_Ipv6_DestinationAddressPathAny {
	return &Acl_AclSet_AclEntry_Ipv6_DestinationAddressPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "destination-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// DestinationAddressPrefixSet (leaf): Reference to a IPv6 address prefix set
// to match the destination address
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/destination-address-prefix-set"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/destination-address-prefix-set"
func (n *Acl_AclSet_AclEntry_Ipv6Path) DestinationAddressPrefixSet() *Acl_AclSet_AclEntry_Ipv6_DestinationAddressPrefixSetPath {
	return &Acl_AclSet_AclEntry_Ipv6_DestinationAddressPrefixSetPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "destination-address-prefix-set"},
			map[string]interface{}{},
			n,
		),
	}
}

// DestinationAddressPrefixSet (leaf): Reference to a IPv6 address prefix set
// to match the destination address
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/destination-address-prefix-set"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/destination-address-prefix-set"
func (n *Acl_AclSet_AclEntry_Ipv6PathAny) DestinationAddressPrefixSet() *Acl_AclSet_AclEntry_Ipv6_DestinationAddressPrefixSetPathAny {
	return &Acl_AclSet_AclEntry_Ipv6_DestinationAddressPrefixSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "destination-address-prefix-set"},
			map[string]interface{}{},
			n,
		),
	}
}

// DestinationFlowLabel (leaf): Destination IPv6 Flow label.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/destination-flow-label"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/destination-flow-label"
func (n *Acl_AclSet_AclEntry_Ipv6Path) DestinationFlowLabel() *Acl_AclSet_AclEntry_Ipv6_DestinationFlowLabelPath {
	return &Acl_AclSet_AclEntry_Ipv6_DestinationFlowLabelPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "destination-flow-label"},
			map[string]interface{}{},
			n,
		),
	}
}

// DestinationFlowLabel (leaf): Destination IPv6 Flow label.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/destination-flow-label"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/destination-flow-label"
func (n *Acl_AclSet_AclEntry_Ipv6PathAny) DestinationFlowLabel() *Acl_AclSet_AclEntry_Ipv6_DestinationFlowLabelPathAny {
	return &Acl_AclSet_AclEntry_Ipv6_DestinationFlowLabelPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "destination-flow-label"},
			map[string]interface{}{},
			n,
		),
	}
}

// Dscp (leaf): Value of diffserv codepoint.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/dscp"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/dscp"
func (n *Acl_AclSet_AclEntry_Ipv6Path) Dscp() *Acl_AclSet_AclEntry_Ipv6_DscpPath {
	return &Acl_AclSet_AclEntry_Ipv6_DscpPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "dscp"},
			map[string]interface{}{},
			n,
		),
	}
}

// Dscp (leaf): Value of diffserv codepoint.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/dscp"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/dscp"
func (n *Acl_AclSet_AclEntry_Ipv6PathAny) Dscp() *Acl_AclSet_AclEntry_Ipv6_DscpPathAny {
	return &Acl_AclSet_AclEntry_Ipv6_DscpPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "dscp"},
			map[string]interface{}{},
			n,
		),
	}
}

// DscpSet (leaf-list): A list of DSCP values to be matched for incoming packets. AN OR match should
// be performed, such that a packet must match one of the values defined in this
// list. If the field is left empty then any DSCP value matches unless the 'dscp'
// leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/dscp-set"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/dscp-set"
func (n *Acl_AclSet_AclEntry_Ipv6Path) DscpSet() *Acl_AclSet_AclEntry_Ipv6_DscpSetPath {
	return &Acl_AclSet_AclEntry_Ipv6_DscpSetPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "dscp-set"},
			map[string]interface{}{},
			n,
		),
	}
}

// DscpSet (leaf-list): A list of DSCP values to be matched for incoming packets. AN OR match should
// be performed, such that a packet must match one of the values defined in this
// list. If the field is left empty then any DSCP value matches unless the 'dscp'
// leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/dscp-set"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/dscp-set"
func (n *Acl_AclSet_AclEntry_Ipv6PathAny) DscpSet() *Acl_AclSet_AclEntry_Ipv6_DscpSetPathAny {
	return &Acl_AclSet_AclEntry_Ipv6_DscpSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "dscp-set"},
			map[string]interface{}{},
			n,
		),
	}
}

// HopLimit (leaf): The IP packet's hop limit -- known as TTL (in hops) in
// IPv4 packets, and hop limit in IPv6
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/hop-limit"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/hop-limit"
func (n *Acl_AclSet_AclEntry_Ipv6Path) HopLimit() *Acl_AclSet_AclEntry_Ipv6_HopLimitPath {
	return &Acl_AclSet_AclEntry_Ipv6_HopLimitPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "hop-limit"},
			map[string]interface{}{},
			n,
		),
	}
}

// HopLimit (leaf): The IP packet's hop limit -- known as TTL (in hops) in
// IPv4 packets, and hop limit in IPv6
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/hop-limit"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/hop-limit"
func (n *Acl_AclSet_AclEntry_Ipv6PathAny) HopLimit() *Acl_AclSet_AclEntry_Ipv6_HopLimitPathAny {
	return &Acl_AclSet_AclEntry_Ipv6_HopLimitPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "hop-limit"},
			map[string]interface{}{},
			n,
		),
	}
}

// Icmpv6 (container): Top container for ICMPv6 filtering
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "icmpv6"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/icmpv6"
func (n *Acl_AclSet_AclEntry_Ipv6Path) Icmpv6() *Acl_AclSet_AclEntry_Ipv6_Icmpv6Path {
	return &Acl_AclSet_AclEntry_Ipv6_Icmpv6Path{
		NodePath: ygot.NewNodePath(
			[]string{"icmpv6"},
			map[string]interface{}{},
			n,
		),
	}
}

// Icmpv6 (container): Top container for ICMPv6 filtering
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "icmpv6"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/icmpv6"
func (n *Acl_AclSet_AclEntry_Ipv6PathAny) Icmpv6() *Acl_AclSet_AclEntry_Ipv6_Icmpv6PathAny {
	return &Acl_AclSet_AclEntry_Ipv6_Icmpv6PathAny{
		NodePath: ygot.NewNodePath(
			[]string{"icmpv6"},
			map[string]interface{}{},
			n,
		),
	}
}

// Length (leaf): In the IPv4 header field, this field is known as the Total
// Length.  Total Length is the length of the datagram, measured
// in octets, including internet header and data.
// In the IPv6 header field, this field is known as the Payload
// Length, which is the length of the IPv6 payload, i.e., the rest
// of the packet following the IPv6 header, in octets.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/length"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/length"
func (n *Acl_AclSet_AclEntry_Ipv6Path) Length() *Acl_AclSet_AclEntry_Ipv6_LengthPath {
	return &Acl_AclSet_AclEntry_Ipv6_LengthPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "length"},
			map[string]interface{}{},
			n,
		),
	}
}

// Length (leaf): In the IPv4 header field, this field is known as the Total
// Length.  Total Length is the length of the datagram, measured
// in octets, including internet header and data.
// In the IPv6 header field, this field is known as the Payload
// Length, which is the length of the IPv6 payload, i.e., the rest
// of the packet following the IPv6 header, in octets.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/length"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/length"
func (n *Acl_AclSet_AclEntry_Ipv6PathAny) Length() *Acl_AclSet_AclEntry_Ipv6_LengthPathAny {
	return &Acl_AclSet_AclEntry_Ipv6_LengthPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "length"},
			map[string]interface{}{},
			n,
		),
	}
}

// Protocol (leaf): The protocol carried in the IP packet, expressed either
// as its IP protocol number, or by a defined identity.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/protocol"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/protocol"
func (n *Acl_AclSet_AclEntry_Ipv6Path) Protocol() *Acl_AclSet_AclEntry_Ipv6_ProtocolPath {
	return &Acl_AclSet_AclEntry_Ipv6_ProtocolPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "protocol"},
			map[string]interface{}{},
			n,
		),
	}
}

// Protocol (leaf): The protocol carried in the IP packet, expressed either
// as its IP protocol number, or by a defined identity.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/protocol"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/protocol"
func (n *Acl_AclSet_AclEntry_Ipv6PathAny) Protocol() *Acl_AclSet_AclEntry_Ipv6_ProtocolPathAny {
	return &Acl_AclSet_AclEntry_Ipv6_ProtocolPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "protocol"},
			map[string]interface{}{},
			n,
		),
	}
}

// SourceAddress (leaf): Source IPv6 address prefix.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/source-address"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/source-address"
func (n *Acl_AclSet_AclEntry_Ipv6Path) SourceAddress() *Acl_AclSet_AclEntry_Ipv6_SourceAddressPath {
	return &Acl_AclSet_AclEntry_Ipv6_SourceAddressPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "source-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// SourceAddress (leaf): Source IPv6 address prefix.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/source-address"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/source-address"
func (n *Acl_AclSet_AclEntry_Ipv6PathAny) SourceAddress() *Acl_AclSet_AclEntry_Ipv6_SourceAddressPathAny {
	return &Acl_AclSet_AclEntry_Ipv6_SourceAddressPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "source-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// SourceAddressPrefixSet (leaf): Reference to a IPv6 address prefix set
// to match the source address
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/source-address-prefix-set"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/source-address-prefix-set"
func (n *Acl_AclSet_AclEntry_Ipv6Path) SourceAddressPrefixSet() *Acl_AclSet_AclEntry_Ipv6_SourceAddressPrefixSetPath {
	return &Acl_AclSet_AclEntry_Ipv6_SourceAddressPrefixSetPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "source-address-prefix-set"},
			map[string]interface{}{},
			n,
		),
	}
}

// SourceAddressPrefixSet (leaf): Reference to a IPv6 address prefix set
// to match the source address
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/source-address-prefix-set"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/source-address-prefix-set"
func (n *Acl_AclSet_AclEntry_Ipv6PathAny) SourceAddressPrefixSet() *Acl_AclSet_AclEntry_Ipv6_SourceAddressPrefixSetPathAny {
	return &Acl_AclSet_AclEntry_Ipv6_SourceAddressPrefixSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "source-address-prefix-set"},
			map[string]interface{}{},
			n,
		),
	}
}

// SourceFlowLabel (leaf): Source IPv6 Flow label.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/source-flow-label"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/source-flow-label"
func (n *Acl_AclSet_AclEntry_Ipv6Path) SourceFlowLabel() *Acl_AclSet_AclEntry_Ipv6_SourceFlowLabelPath {
	return &Acl_AclSet_AclEntry_Ipv6_SourceFlowLabelPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "source-flow-label"},
			map[string]interface{}{},
			n,
		),
	}
}

// SourceFlowLabel (leaf): Source IPv6 Flow label.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/source-flow-label"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config/source-flow-label"
func (n *Acl_AclSet_AclEntry_Ipv6PathAny) SourceFlowLabel() *Acl_AclSet_AclEntry_Ipv6_SourceFlowLabelPathAny {
	return &Acl_AclSet_AclEntry_Ipv6_SourceFlowLabelPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "source-flow-label"},
			map[string]interface{}{},
			n,
		),
	}
}

// Acl_AclSet_AclEntry_Ipv6_Icmpv6Path represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/icmpv6 YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_Icmpv6Path struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_Icmpv6PathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/icmpv6 YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_Icmpv6PathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_Icmpv6_CodePath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/icmpv6/config/code YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_Icmpv6_CodePath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_Icmpv6_CodePathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/icmpv6/config/code YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_Icmpv6_CodePathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_Icmpv6_TypePath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/icmpv6/config/type YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_Icmpv6_TypePath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Ipv6_Icmpv6_TypePathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/icmpv6/config/type YANG schema element.
type Acl_AclSet_AclEntry_Ipv6_Icmpv6_TypePathAny struct {
	*ygot.NodePath
}

// Code (leaf): ICMP code to be matched.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/code"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/icmpv6/config/code"
func (n *Acl_AclSet_AclEntry_Ipv6_Icmpv6Path) Code() *Acl_AclSet_AclEntry_Ipv6_Icmpv6_CodePath {
	return &Acl_AclSet_AclEntry_Ipv6_Icmpv6_CodePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "code"},
			map[string]interface{}{},
			n,
		),
	}
}

// Code (leaf): ICMP code to be matched.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/code"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/icmpv6/config/code"
func (n *Acl_AclSet_AclEntry_Ipv6_Icmpv6PathAny) Code() *Acl_AclSet_AclEntry_Ipv6_Icmpv6_CodePathAny {
	return &Acl_AclSet_AclEntry_Ipv6_Icmpv6_CodePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "code"},
			map[string]interface{}{},
			n,
		),
	}
}

// Type (leaf): ICMPv6 type to be matched.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/type"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/icmpv6/config/type"
func (n *Acl_AclSet_AclEntry_Ipv6_Icmpv6Path) Type() *Acl_AclSet_AclEntry_Ipv6_Icmpv6_TypePath {
	return &Acl_AclSet_AclEntry_Ipv6_Icmpv6_TypePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "type"},
			map[string]interface{}{},
			n,
		),
	}
}

// Type (leaf): ICMPv6 type to be matched.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/type"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/icmpv6/config/type"
func (n *Acl_AclSet_AclEntry_Ipv6_Icmpv6PathAny) Type() *Acl_AclSet_AclEntry_Ipv6_Icmpv6_TypePathAny {
	return &Acl_AclSet_AclEntry_Ipv6_Icmpv6_TypePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "type"},
			map[string]interface{}{},
			n,
		),
	}
}

// Acl_AclSet_AclEntry_L2Path represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2 YANG schema element.
type Acl_AclSet_AclEntry_L2Path struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_L2PathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2 YANG schema element.
type Acl_AclSet_AclEntry_L2PathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_L2_DestinationMacPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/destination-mac YANG schema element.
type Acl_AclSet_AclEntry_L2_DestinationMacPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_L2_DestinationMacPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/destination-mac YANG schema element.
type Acl_AclSet_AclEntry_L2_DestinationMacPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_L2_DestinationMacMaskPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/destination-mac-mask YANG schema element.
type Acl_AclSet_AclEntry_L2_DestinationMacMaskPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_L2_DestinationMacMaskPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/destination-mac-mask YANG schema element.
type Acl_AclSet_AclEntry_L2_DestinationMacMaskPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_L2_EthertypePath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/ethertype YANG schema element.
type Acl_AclSet_AclEntry_L2_EthertypePath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_L2_EthertypePathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/ethertype YANG schema element.
type Acl_AclSet_AclEntry_L2_EthertypePathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_L2_SourceMacPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/source-mac YANG schema element.
type Acl_AclSet_AclEntry_L2_SourceMacPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_L2_SourceMacPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/source-mac YANG schema element.
type Acl_AclSet_AclEntry_L2_SourceMacPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_L2_SourceMacMaskPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/source-mac-mask YANG schema element.
type Acl_AclSet_AclEntry_L2_SourceMacMaskPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_L2_SourceMacMaskPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/source-mac-mask YANG schema element.
type Acl_AclSet_AclEntry_L2_SourceMacMaskPathAny struct {
	*ygot.NodePath
}

// DestinationMac (leaf): Destination IEEE 802 MAC address.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/destination-mac"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/destination-mac"
func (n *Acl_AclSet_AclEntry_L2Path) DestinationMac() *Acl_AclSet_AclEntry_L2_DestinationMacPath {
	return &Acl_AclSet_AclEntry_L2_DestinationMacPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "destination-mac"},
			map[string]interface{}{},
			n,
		),
	}
}

// DestinationMac (leaf): Destination IEEE 802 MAC address.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/destination-mac"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/destination-mac"
func (n *Acl_AclSet_AclEntry_L2PathAny) DestinationMac() *Acl_AclSet_AclEntry_L2_DestinationMacPathAny {
	return &Acl_AclSet_AclEntry_L2_DestinationMacPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "destination-mac"},
			map[string]interface{}{},
			n,
		),
	}
}

// DestinationMacMask (leaf): Destination IEEE 802 MAC address mask.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/destination-mac-mask"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/destination-mac-mask"
func (n *Acl_AclSet_AclEntry_L2Path) DestinationMacMask() *Acl_AclSet_AclEntry_L2_DestinationMacMaskPath {
	return &Acl_AclSet_AclEntry_L2_DestinationMacMaskPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "destination-mac-mask"},
			map[string]interface{}{},
			n,
		),
	}
}

// DestinationMacMask (leaf): Destination IEEE 802 MAC address mask.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/destination-mac-mask"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/destination-mac-mask"
func (n *Acl_AclSet_AclEntry_L2PathAny) DestinationMacMask() *Acl_AclSet_AclEntry_L2_DestinationMacMaskPathAny {
	return &Acl_AclSet_AclEntry_L2_DestinationMacMaskPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "destination-mac-mask"},
			map[string]interface{}{},
			n,
		),
	}
}

// Ethertype (leaf): Ethertype field to match in Ethernet packets
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/ethertype"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/ethertype"
func (n *Acl_AclSet_AclEntry_L2Path) Ethertype() *Acl_AclSet_AclEntry_L2_EthertypePath {
	return &Acl_AclSet_AclEntry_L2_EthertypePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "ethertype"},
			map[string]interface{}{},
			n,
		),
	}
}

// Ethertype (leaf): Ethertype field to match in Ethernet packets
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/ethertype"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/ethertype"
func (n *Acl_AclSet_AclEntry_L2PathAny) Ethertype() *Acl_AclSet_AclEntry_L2_EthertypePathAny {
	return &Acl_AclSet_AclEntry_L2_EthertypePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "ethertype"},
			map[string]interface{}{},
			n,
		),
	}
}

// SourceMac (leaf): Source IEEE 802 MAC address.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/source-mac"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/source-mac"
func (n *Acl_AclSet_AclEntry_L2Path) SourceMac() *Acl_AclSet_AclEntry_L2_SourceMacPath {
	return &Acl_AclSet_AclEntry_L2_SourceMacPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "source-mac"},
			map[string]interface{}{},
			n,
		),
	}
}

// SourceMac (leaf): Source IEEE 802 MAC address.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/source-mac"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/source-mac"
func (n *Acl_AclSet_AclEntry_L2PathAny) SourceMac() *Acl_AclSet_AclEntry_L2_SourceMacPathAny {
	return &Acl_AclSet_AclEntry_L2_SourceMacPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "source-mac"},
			map[string]interface{}{},
			n,
		),
	}
}

// SourceMacMask (leaf): Source IEEE 802 MAC address mask.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/source-mac-mask"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/source-mac-mask"
func (n *Acl_AclSet_AclEntry_L2Path) SourceMacMask() *Acl_AclSet_AclEntry_L2_SourceMacMaskPath {
	return &Acl_AclSet_AclEntry_L2_SourceMacMaskPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "source-mac-mask"},
			map[string]interface{}{},
			n,
		),
	}
}

// SourceMacMask (leaf): Source IEEE 802 MAC address mask.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/source-mac-mask"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config/source-mac-mask"
func (n *Acl_AclSet_AclEntry_L2PathAny) SourceMacMask() *Acl_AclSet_AclEntry_L2_SourceMacMaskPathAny {
	return &Acl_AclSet_AclEntry_L2_SourceMacMaskPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "source-mac-mask"},
			map[string]interface{}{},
			n,
		),
	}
}

// Acl_AclSet_AclEntry_MplsPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls YANG schema element.
type Acl_AclSet_AclEntry_MplsPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_MplsPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls YANG schema element.
type Acl_AclSet_AclEntry_MplsPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Mpls_EndLabelValuePath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/end-label-value YANG schema element.
type Acl_AclSet_AclEntry_Mpls_EndLabelValuePath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Mpls_EndLabelValuePathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/end-label-value YANG schema element.
type Acl_AclSet_AclEntry_Mpls_EndLabelValuePathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Mpls_StartLabelValuePath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/start-label-value YANG schema element.
type Acl_AclSet_AclEntry_Mpls_StartLabelValuePath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Mpls_StartLabelValuePathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/start-label-value YANG schema element.
type Acl_AclSet_AclEntry_Mpls_StartLabelValuePathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Mpls_TrafficClassPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/traffic-class YANG schema element.
type Acl_AclSet_AclEntry_Mpls_TrafficClassPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Mpls_TrafficClassPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/traffic-class YANG schema element.
type Acl_AclSet_AclEntry_Mpls_TrafficClassPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Mpls_TtlValuePath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/ttl-value YANG schema element.
type Acl_AclSet_AclEntry_Mpls_TtlValuePath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Mpls_TtlValuePathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/ttl-value YANG schema element.
type Acl_AclSet_AclEntry_Mpls_TtlValuePathAny struct {
	*ygot.NodePath
}

// EndLabelValue (leaf): Match MPLS label value on the MPLS header.
// The usage of this field indicated the upper
// range value in the top of the stack.
// The range that is used is inclusive. The match that
// is done for a particular received pkt_label is:
// start-label-value <= pkt_label <= end-label-value.
// The 20-bit label value in an MPLS label
// stack as specified in RFC 3032.
// This label value does not include the
// encodings of Traffic Class and TTL.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/end-label-value"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/end-label-value"
func (n *Acl_AclSet_AclEntry_MplsPath) EndLabelValue() *Acl_AclSet_AclEntry_Mpls_EndLabelValuePath {
	return &Acl_AclSet_AclEntry_Mpls_EndLabelValuePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "end-label-value"},
			map[string]interface{}{},
			n,
		),
	}
}

// EndLabelValue (leaf): Match MPLS label value on the MPLS header.
// The usage of this field indicated the upper
// range value in the top of the stack.
// The range that is used is inclusive. The match that
// is done for a particular received pkt_label is:
// start-label-value <= pkt_label <= end-label-value.
// The 20-bit label value in an MPLS label
// stack as specified in RFC 3032.
// This label value does not include the
// encodings of Traffic Class and TTL.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/end-label-value"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/end-label-value"
func (n *Acl_AclSet_AclEntry_MplsPathAny) EndLabelValue() *Acl_AclSet_AclEntry_Mpls_EndLabelValuePathAny {
	return &Acl_AclSet_AclEntry_Mpls_EndLabelValuePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "end-label-value"},
			map[string]interface{}{},
			n,
		),
	}
}

// StartLabelValue (leaf): Match MPLS label value on the MPLS header.
// The usage of this field indicated the upper
// range value in the top of the stack.
// The range that is used is inclusive. The match that
// is done for a particular received pkt_label is:
// start-label-value <= pkt_label <= end-label-value.
// The 20-bit label value in an MPLS label
// stack as specified in RFC 3032.
// This label value does not include the
// encodings of Traffic Class and TTL.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/start-label-value"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/start-label-value"
func (n *Acl_AclSet_AclEntry_MplsPath) StartLabelValue() *Acl_AclSet_AclEntry_Mpls_StartLabelValuePath {
	return &Acl_AclSet_AclEntry_Mpls_StartLabelValuePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "start-label-value"},
			map[string]interface{}{},
			n,
		),
	}
}

// StartLabelValue (leaf): Match MPLS label value on the MPLS header.
// The usage of this field indicated the upper
// range value in the top of the stack.
// The range that is used is inclusive. The match that
// is done for a particular received pkt_label is:
// start-label-value <= pkt_label <= end-label-value.
// The 20-bit label value in an MPLS label
// stack as specified in RFC 3032.
// This label value does not include the
// encodings of Traffic Class and TTL.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/start-label-value"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/start-label-value"
func (n *Acl_AclSet_AclEntry_MplsPathAny) StartLabelValue() *Acl_AclSet_AclEntry_Mpls_StartLabelValuePathAny {
	return &Acl_AclSet_AclEntry_Mpls_StartLabelValuePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "start-label-value"},
			map[string]interface{}{},
			n,
		),
	}
}

// TrafficClass (leaf): The value of the MPLS traffic class (TC) bits,
// formerly known as the EXP bits.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/traffic-class"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/traffic-class"
func (n *Acl_AclSet_AclEntry_MplsPath) TrafficClass() *Acl_AclSet_AclEntry_Mpls_TrafficClassPath {
	return &Acl_AclSet_AclEntry_Mpls_TrafficClassPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "traffic-class"},
			map[string]interface{}{},
			n,
		),
	}
}

// TrafficClass (leaf): The value of the MPLS traffic class (TC) bits,
// formerly known as the EXP bits.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/traffic-class"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/traffic-class"
func (n *Acl_AclSet_AclEntry_MplsPathAny) TrafficClass() *Acl_AclSet_AclEntry_Mpls_TrafficClassPathAny {
	return &Acl_AclSet_AclEntry_Mpls_TrafficClassPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "traffic-class"},
			map[string]interface{}{},
			n,
		),
	}
}

// TtlValue (leaf): Time-to-live MPLS packet value match.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/ttl-value"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/ttl-value"
func (n *Acl_AclSet_AclEntry_MplsPath) TtlValue() *Acl_AclSet_AclEntry_Mpls_TtlValuePath {
	return &Acl_AclSet_AclEntry_Mpls_TtlValuePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "ttl-value"},
			map[string]interface{}{},
			n,
		),
	}
}

// TtlValue (leaf): Time-to-live MPLS packet value match.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/ttl-value"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config/ttl-value"
func (n *Acl_AclSet_AclEntry_MplsPathAny) TtlValue() *Acl_AclSet_AclEntry_Mpls_TtlValuePathAny {
	return &Acl_AclSet_AclEntry_Mpls_TtlValuePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "ttl-value"},
			map[string]interface{}{},
			n,
		),
	}
}

// Acl_AclSet_AclEntry_TransportPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport YANG schema element.
type Acl_AclSet_AclEntry_TransportPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_TransportPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport YANG schema element.
type Acl_AclSet_AclEntry_TransportPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Transport_BuiltinDetailPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/builtin-detail YANG schema element.
type Acl_AclSet_AclEntry_Transport_BuiltinDetailPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Transport_BuiltinDetailPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/builtin-detail YANG schema element.
type Acl_AclSet_AclEntry_Transport_BuiltinDetailPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Transport_DestinationPortPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port YANG schema element.
type Acl_AclSet_AclEntry_Transport_DestinationPortPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Transport_DestinationPortPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port YANG schema element.
type Acl_AclSet_AclEntry_Transport_DestinationPortPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Transport_DestinationPortSetPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port-set YANG schema element.
type Acl_AclSet_AclEntry_Transport_DestinationPortSetPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Transport_DestinationPortSetPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port-set YANG schema element.
type Acl_AclSet_AclEntry_Transport_DestinationPortSetPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Transport_DetailModePath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/detail-mode YANG schema element.
type Acl_AclSet_AclEntry_Transport_DetailModePath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Transport_DetailModePathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/detail-mode YANG schema element.
type Acl_AclSet_AclEntry_Transport_DetailModePathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Transport_ExplicitDetailMatchModePath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/explicit-detail-match-mode YANG schema element.
type Acl_AclSet_AclEntry_Transport_ExplicitDetailMatchModePath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Transport_ExplicitDetailMatchModePathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/explicit-detail-match-mode YANG schema element.
type Acl_AclSet_AclEntry_Transport_ExplicitDetailMatchModePathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Transport_ExplicitTcpFlagsPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/explicit-tcp-flags YANG schema element.
type Acl_AclSet_AclEntry_Transport_ExplicitTcpFlagsPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Transport_ExplicitTcpFlagsPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/explicit-tcp-flags YANG schema element.
type Acl_AclSet_AclEntry_Transport_ExplicitTcpFlagsPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Transport_SourcePortPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port YANG schema element.
type Acl_AclSet_AclEntry_Transport_SourcePortPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Transport_SourcePortPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port YANG schema element.
type Acl_AclSet_AclEntry_Transport_SourcePortPathAny struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Transport_SourcePortSetPath represents the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port-set YANG schema element.
type Acl_AclSet_AclEntry_Transport_SourcePortSetPath struct {
	*ygot.NodePath
}

// Acl_AclSet_AclEntry_Transport_SourcePortSetPathAny represents the wildcard version of the /openconfig-acl/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port-set YANG schema element.
type Acl_AclSet_AclEntry_Transport_SourcePortSetPathAny struct {
	*ygot.NodePath
}

// BuiltinDetail (leaf): Specifies a built-in (alias) for a match condition that matches
// multiple flags, or specifies particular logic as to the flag matches
// to be implemented. This leaf is only valid when the detail-match-mode
// leaf is BUILTIN.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/builtin-detail"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/builtin-detail"
func (n *Acl_AclSet_AclEntry_TransportPath) BuiltinDetail() *Acl_AclSet_AclEntry_Transport_BuiltinDetailPath {
	return &Acl_AclSet_AclEntry_Transport_BuiltinDetailPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "builtin-detail"},
			map[string]interface{}{},
			n,
		),
	}
}

// BuiltinDetail (leaf): Specifies a built-in (alias) for a match condition that matches
// multiple flags, or specifies particular logic as to the flag matches
// to be implemented. This leaf is only valid when the detail-match-mode
// leaf is BUILTIN.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/builtin-detail"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/builtin-detail"
func (n *Acl_AclSet_AclEntry_TransportPathAny) BuiltinDetail() *Acl_AclSet_AclEntry_Transport_BuiltinDetailPathAny {
	return &Acl_AclSet_AclEntry_Transport_BuiltinDetailPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "builtin-detail"},
			map[string]interface{}{},
			n,
		),
	}
}

// DestinationPort (leaf): Destination port or range
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/destination-port"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port"
func (n *Acl_AclSet_AclEntry_TransportPath) DestinationPort() *Acl_AclSet_AclEntry_Transport_DestinationPortPath {
	return &Acl_AclSet_AclEntry_Transport_DestinationPortPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "destination-port"},
			map[string]interface{}{},
			n,
		),
	}
}

// DestinationPort (leaf): Destination port or range
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/destination-port"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port"
func (n *Acl_AclSet_AclEntry_TransportPathAny) DestinationPort() *Acl_AclSet_AclEntry_Transport_DestinationPortPathAny {
	return &Acl_AclSet_AclEntry_Transport_DestinationPortPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "destination-port"},
			map[string]interface{}{},
			n,
		),
	}
}

// DestinationPortSet (leaf): Reference to a port set
// to match the destination port
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/destination-port-set"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port-set"
func (n *Acl_AclSet_AclEntry_TransportPath) DestinationPortSet() *Acl_AclSet_AclEntry_Transport_DestinationPortSetPath {
	return &Acl_AclSet_AclEntry_Transport_DestinationPortSetPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "destination-port-set"},
			map[string]interface{}{},
			n,
		),
	}
}

// DestinationPortSet (leaf): Reference to a port set
// to match the destination port
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/destination-port-set"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/destination-port-set"
func (n *Acl_AclSet_AclEntry_TransportPathAny) DestinationPortSet() *Acl_AclSet_AclEntry_Transport_DestinationPortSetPathAny {
	return &Acl_AclSet_AclEntry_Transport_DestinationPortSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "destination-port-set"},
			map[string]interface{}{},
			n,
		),
	}
}

// DetailMode (leaf): Mode that is used for matching detailed fields at the transport
// layer. When EXPLICIT is specified, the implementation should
// match based on the explicit flags that are specified in the
// corresponding leaf. When BUILTIN is specified, the implementation
// must expand the contents of the corresponding leaf to the flags
// and/or fields that match the pre-defined built-in values.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/detail-mode"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/detail-mode"
func (n *Acl_AclSet_AclEntry_TransportPath) DetailMode() *Acl_AclSet_AclEntry_Transport_DetailModePath {
	return &Acl_AclSet_AclEntry_Transport_DetailModePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "detail-mode"},
			map[string]interface{}{},
			n,
		),
	}
}

// DetailMode (leaf): Mode that is used for matching detailed fields at the transport
// layer. When EXPLICIT is specified, the implementation should
// match based on the explicit flags that are specified in the
// corresponding leaf. When BUILTIN is specified, the implementation
// must expand the contents of the corresponding leaf to the flags
// and/or fields that match the pre-defined built-in values.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/detail-mode"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/detail-mode"
func (n *Acl_AclSet_AclEntry_TransportPathAny) DetailMode() *Acl_AclSet_AclEntry_Transport_DetailModePathAny {
	return &Acl_AclSet_AclEntry_Transport_DetailModePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "detail-mode"},
			map[string]interface{}{},
			n,
		),
	}
}

// ExplicitDetailMatchMode (leaf): Specifies how the contents of the explicit-details-flags list
// are to be treated. ANY implies that any of the flags may match,
// where ALL indicates that all the flags must be matched.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/explicit-detail-match-mode"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/explicit-detail-match-mode"
func (n *Acl_AclSet_AclEntry_TransportPath) ExplicitDetailMatchMode() *Acl_AclSet_AclEntry_Transport_ExplicitDetailMatchModePath {
	return &Acl_AclSet_AclEntry_Transport_ExplicitDetailMatchModePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "explicit-detail-match-mode"},
			map[string]interface{}{},
			n,
		),
	}
}

// ExplicitDetailMatchMode (leaf): Specifies how the contents of the explicit-details-flags list
// are to be treated. ANY implies that any of the flags may match,
// where ALL indicates that all the flags must be matched.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/explicit-detail-match-mode"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/explicit-detail-match-mode"
func (n *Acl_AclSet_AclEntry_TransportPathAny) ExplicitDetailMatchMode() *Acl_AclSet_AclEntry_Transport_ExplicitDetailMatchModePathAny {
	return &Acl_AclSet_AclEntry_Transport_ExplicitDetailMatchModePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "explicit-detail-match-mode"},
			map[string]interface{}{},
			n,
		),
	}
}

// ExplicitTcpFlags (leaf-list): An explicit list of the TCP flags that are to be matched. The
// mechanism for the match is specified by the explicit-detail-match-mode
// leaf.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/explicit-tcp-flags"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/explicit-tcp-flags"
func (n *Acl_AclSet_AclEntry_TransportPath) ExplicitTcpFlags() *Acl_AclSet_AclEntry_Transport_ExplicitTcpFlagsPath {
	return &Acl_AclSet_AclEntry_Transport_ExplicitTcpFlagsPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "explicit-tcp-flags"},
			map[string]interface{}{},
			n,
		),
	}
}

// ExplicitTcpFlags (leaf-list): An explicit list of the TCP flags that are to be matched. The
// mechanism for the match is specified by the explicit-detail-match-mode
// leaf.
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/explicit-tcp-flags"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/explicit-tcp-flags"
func (n *Acl_AclSet_AclEntry_TransportPathAny) ExplicitTcpFlags() *Acl_AclSet_AclEntry_Transport_ExplicitTcpFlagsPathAny {
	return &Acl_AclSet_AclEntry_Transport_ExplicitTcpFlagsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "explicit-tcp-flags"},
			map[string]interface{}{},
			n,
		),
	}
}

// SourcePort (leaf): Source port or range
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/source-port"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port"
func (n *Acl_AclSet_AclEntry_TransportPath) SourcePort() *Acl_AclSet_AclEntry_Transport_SourcePortPath {
	return &Acl_AclSet_AclEntry_Transport_SourcePortPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "source-port"},
			map[string]interface{}{},
			n,
		),
	}
}

// SourcePort (leaf): Source port or range
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/source-port"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port"
func (n *Acl_AclSet_AclEntry_TransportPathAny) SourcePort() *Acl_AclSet_AclEntry_Transport_SourcePortPathAny {
	return &Acl_AclSet_AclEntry_Transport_SourcePortPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "source-port"},
			map[string]interface{}{},
			n,
		),
	}
}

// SourcePortSet (leaf): Reference to a port set
// to match the source port
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/source-port-set"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port-set"
func (n *Acl_AclSet_AclEntry_TransportPath) SourcePortSet() *Acl_AclSet_AclEntry_Transport_SourcePortSetPath {
	return &Acl_AclSet_AclEntry_Transport_SourcePortSetPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "source-port-set"},
			map[string]interface{}{},
			n,
		),
	}
}

// SourcePortSet (leaf): Reference to a port set
// to match the source port
// ----------------------------------------
// Defining module: "openconfig-packet-match"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/source-port-set"
// Path from root: "/acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config/source-port-set"
func (n *Acl_AclSet_AclEntry_TransportPathAny) SourcePortSet() *Acl_AclSet_AclEntry_Transport_SourcePortSetPathAny {
	return &Acl_AclSet_AclEntry_Transport_SourcePortSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "source-port-set"},
			map[string]interface{}{},
			n,
		),
	}
}

// Acl_InterfacePath represents the /openconfig-acl/acl/interfaces/interface YANG schema element.
type Acl_InterfacePath struct {
	*ygot.NodePath
}

// Acl_InterfacePathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface YANG schema element.
type Acl_InterfacePathAny struct {
	*ygot.NodePath
}

// Acl_Interface_IdPath represents the /openconfig-acl/acl/interfaces/interface/config/id YANG schema element.
type Acl_Interface_IdPath struct {
	*ygot.NodePath
}

// Acl_Interface_IdPathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface/config/id YANG schema element.
type Acl_Interface_IdPathAny struct {
	*ygot.NodePath
}

// EgressAclSetAny (list): List of egress ACLs on the interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "egress-acl-sets/egress-acl-set"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set"
// SetName (wildcarded): string
// Type (wildcarded): E_Acl_ACL_TYPE
func (n *Acl_InterfacePath) EgressAclSetAny() *Acl_Interface_EgressAclSetPathAny {
	return &Acl_Interface_EgressAclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"egress-acl-sets", "egress-acl-set"},
			map[string]interface{}{"set-name": "*", "type": "*"},
			n,
		),
	}
}

// EgressAclSetAny (list): List of egress ACLs on the interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "egress-acl-sets/egress-acl-set"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set"
// SetName (wildcarded): string
// Type (wildcarded): E_Acl_ACL_TYPE
func (n *Acl_InterfacePathAny) EgressAclSetAny() *Acl_Interface_EgressAclSetPathAny {
	return &Acl_Interface_EgressAclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"egress-acl-sets", "egress-acl-set"},
			map[string]interface{}{"set-name": "*", "type": "*"},
			n,
		),
	}
}

// EgressAclSetAnyType (list): List of egress ACLs on the interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "egress-acl-sets/egress-acl-set"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set"
// SetName: string
// Type (wildcarded): E_Acl_ACL_TYPE
func (n *Acl_InterfacePath) EgressAclSetAnyType(SetName string) *Acl_Interface_EgressAclSetPathAny {
	return &Acl_Interface_EgressAclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"egress-acl-sets", "egress-acl-set"},
			map[string]interface{}{"set-name": SetName, "type": "*"},
			n,
		),
	}
}

// EgressAclSetAnyType (list): List of egress ACLs on the interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "egress-acl-sets/egress-acl-set"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set"
// SetName: string
// Type (wildcarded): E_Acl_ACL_TYPE
func (n *Acl_InterfacePathAny) EgressAclSetAnyType(SetName string) *Acl_Interface_EgressAclSetPathAny {
	return &Acl_Interface_EgressAclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"egress-acl-sets", "egress-acl-set"},
			map[string]interface{}{"set-name": SetName, "type": "*"},
			n,
		),
	}
}

// EgressAclSetAnySetName (list): List of egress ACLs on the interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "egress-acl-sets/egress-acl-set"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set"
// SetName (wildcarded): string
// Type: E_Acl_ACL_TYPE
func (n *Acl_InterfacePath) EgressAclSetAnySetName(Type E_Acl_ACL_TYPE) *Acl_Interface_EgressAclSetPathAny {
	return &Acl_Interface_EgressAclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"egress-acl-sets", "egress-acl-set"},
			map[string]interface{}{"set-name": "*", "type": Type},
			n,
		),
	}
}

// EgressAclSetAnySetName (list): List of egress ACLs on the interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "egress-acl-sets/egress-acl-set"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set"
// SetName (wildcarded): string
// Type: E_Acl_ACL_TYPE
func (n *Acl_InterfacePathAny) EgressAclSetAnySetName(Type E_Acl_ACL_TYPE) *Acl_Interface_EgressAclSetPathAny {
	return &Acl_Interface_EgressAclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"egress-acl-sets", "egress-acl-set"},
			map[string]interface{}{"set-name": "*", "type": Type},
			n,
		),
	}
}

// EgressAclSet (list): List of egress ACLs on the interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "egress-acl-sets/egress-acl-set"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set"
// SetName: string
// Type: E_Acl_ACL_TYPE
func (n *Acl_InterfacePath) EgressAclSet(SetName string, Type E_Acl_ACL_TYPE) *Acl_Interface_EgressAclSetPath {
	return &Acl_Interface_EgressAclSetPath{
		NodePath: ygot.NewNodePath(
			[]string{"egress-acl-sets", "egress-acl-set"},
			map[string]interface{}{"set-name": SetName, "type": Type},
			n,
		),
	}
}

// EgressAclSet (list): List of egress ACLs on the interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "egress-acl-sets/egress-acl-set"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set"
// SetName: string
// Type: E_Acl_ACL_TYPE
func (n *Acl_InterfacePathAny) EgressAclSet(SetName string, Type E_Acl_ACL_TYPE) *Acl_Interface_EgressAclSetPathAny {
	return &Acl_Interface_EgressAclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"egress-acl-sets", "egress-acl-set"},
			map[string]interface{}{"set-name": SetName, "type": Type},
			n,
		),
	}
}

// Id (leaf): User-defined identifier for the interface -- a common
// convention could be '<if name>.<subif index>'
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/id"
// Path from root: "/acl/interfaces/interface/config/id"
func (n *Acl_InterfacePath) Id() *Acl_Interface_IdPath {
	return &Acl_Interface_IdPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "id"},
			map[string]interface{}{},
			n,
		),
	}
}

// Id (leaf): User-defined identifier for the interface -- a common
// convention could be '<if name>.<subif index>'
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/id"
// Path from root: "/acl/interfaces/interface/config/id"
func (n *Acl_InterfacePathAny) Id() *Acl_Interface_IdPathAny {
	return &Acl_Interface_IdPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "id"},
			map[string]interface{}{},
			n,
		),
	}
}

// IngressAclSetAny (list): List of ingress ACLs on the interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "ingress-acl-sets/ingress-acl-set"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set"
// SetName (wildcarded): string
// Type (wildcarded): E_Acl_ACL_TYPE
func (n *Acl_InterfacePath) IngressAclSetAny() *Acl_Interface_IngressAclSetPathAny {
	return &Acl_Interface_IngressAclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"ingress-acl-sets", "ingress-acl-set"},
			map[string]interface{}{"set-name": "*", "type": "*"},
			n,
		),
	}
}

// IngressAclSetAny (list): List of ingress ACLs on the interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "ingress-acl-sets/ingress-acl-set"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set"
// SetName (wildcarded): string
// Type (wildcarded): E_Acl_ACL_TYPE
func (n *Acl_InterfacePathAny) IngressAclSetAny() *Acl_Interface_IngressAclSetPathAny {
	return &Acl_Interface_IngressAclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"ingress-acl-sets", "ingress-acl-set"},
			map[string]interface{}{"set-name": "*", "type": "*"},
			n,
		),
	}
}

// IngressAclSetAnyType (list): List of ingress ACLs on the interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "ingress-acl-sets/ingress-acl-set"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set"
// SetName: string
// Type (wildcarded): E_Acl_ACL_TYPE
func (n *Acl_InterfacePath) IngressAclSetAnyType(SetName string) *Acl_Interface_IngressAclSetPathAny {
	return &Acl_Interface_IngressAclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"ingress-acl-sets", "ingress-acl-set"},
			map[string]interface{}{"set-name": SetName, "type": "*"},
			n,
		),
	}
}

// IngressAclSetAnyType (list): List of ingress ACLs on the interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "ingress-acl-sets/ingress-acl-set"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set"
// SetName: string
// Type (wildcarded): E_Acl_ACL_TYPE
func (n *Acl_InterfacePathAny) IngressAclSetAnyType(SetName string) *Acl_Interface_IngressAclSetPathAny {
	return &Acl_Interface_IngressAclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"ingress-acl-sets", "ingress-acl-set"},
			map[string]interface{}{"set-name": SetName, "type": "*"},
			n,
		),
	}
}

// IngressAclSetAnySetName (list): List of ingress ACLs on the interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "ingress-acl-sets/ingress-acl-set"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set"
// SetName (wildcarded): string
// Type: E_Acl_ACL_TYPE
func (n *Acl_InterfacePath) IngressAclSetAnySetName(Type E_Acl_ACL_TYPE) *Acl_Interface_IngressAclSetPathAny {
	return &Acl_Interface_IngressAclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"ingress-acl-sets", "ingress-acl-set"},
			map[string]interface{}{"set-name": "*", "type": Type},
			n,
		),
	}
}

// IngressAclSetAnySetName (list): List of ingress ACLs on the interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "ingress-acl-sets/ingress-acl-set"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set"
// SetName (wildcarded): string
// Type: E_Acl_ACL_TYPE
func (n *Acl_InterfacePathAny) IngressAclSetAnySetName(Type E_Acl_ACL_TYPE) *Acl_Interface_IngressAclSetPathAny {
	return &Acl_Interface_IngressAclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"ingress-acl-sets", "ingress-acl-set"},
			map[string]interface{}{"set-name": "*", "type": Type},
			n,
		),
	}
}

// IngressAclSet (list): List of ingress ACLs on the interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "ingress-acl-sets/ingress-acl-set"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set"
// SetName: string
// Type: E_Acl_ACL_TYPE
func (n *Acl_InterfacePath) IngressAclSet(SetName string, Type E_Acl_ACL_TYPE) *Acl_Interface_IngressAclSetPath {
	return &Acl_Interface_IngressAclSetPath{
		NodePath: ygot.NewNodePath(
			[]string{"ingress-acl-sets", "ingress-acl-set"},
			map[string]interface{}{"set-name": SetName, "type": Type},
			n,
		),
	}
}

// IngressAclSet (list): List of ingress ACLs on the interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "ingress-acl-sets/ingress-acl-set"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set"
// SetName: string
// Type: E_Acl_ACL_TYPE
func (n *Acl_InterfacePathAny) IngressAclSet(SetName string, Type E_Acl_ACL_TYPE) *Acl_Interface_IngressAclSetPathAny {
	return &Acl_Interface_IngressAclSetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"ingress-acl-sets", "ingress-acl-set"},
			map[string]interface{}{"set-name": SetName, "type": Type},
			n,
		),
	}
}

// InterfaceRef (container): Reference to an interface or subinterface. The interface
// that is being referenced is uniquely referenced based on
// the specified interface and subinterface leaves. In contexts
// where a Layer 3 interface is to be referenced, both the
// interface and subinterface leaves must be populated, as
// Layer 3 configuration within the OpenConfig models is
// associated with a subinterface. In the case where a
// Layer 2 interface is to be referenced, only the
// interface is specified.
//
// The interface/subinterface leaf tuple must be used as
// the means by which the interface is specified, regardless
// of any other context information (e.g., key in a list).
// ----------------------------------------
// Defining module: "openconfig-interfaces"
// Instantiating module: "openconfig-acl"
// Path from parent: "interface-ref"
// Path from root: "/acl/interfaces/interface/interface-ref"
func (n *Acl_InterfacePath) InterfaceRef() *Acl_Interface_InterfaceRefPath {
	return &Acl_Interface_InterfaceRefPath{
		NodePath: ygot.NewNodePath(
			[]string{"interface-ref"},
			map[string]interface{}{},
			n,
		),
	}
}

// InterfaceRef (container): Reference to an interface or subinterface. The interface
// that is being referenced is uniquely referenced based on
// the specified interface and subinterface leaves. In contexts
// where a Layer 3 interface is to be referenced, both the
// interface and subinterface leaves must be populated, as
// Layer 3 configuration within the OpenConfig models is
// associated with a subinterface. In the case where a
// Layer 2 interface is to be referenced, only the
// interface is specified.
//
// The interface/subinterface leaf tuple must be used as
// the means by which the interface is specified, regardless
// of any other context information (e.g., key in a list).
// ----------------------------------------
// Defining module: "openconfig-interfaces"
// Instantiating module: "openconfig-acl"
// Path from parent: "interface-ref"
// Path from root: "/acl/interfaces/interface/interface-ref"
func (n *Acl_InterfacePathAny) InterfaceRef() *Acl_Interface_InterfaceRefPathAny {
	return &Acl_Interface_InterfaceRefPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interface-ref"},
			map[string]interface{}{},
			n,
		),
	}
}

// Acl_Interface_EgressAclSetPath represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set YANG schema element.
type Acl_Interface_EgressAclSetPath struct {
	*ygot.NodePath
}

// Acl_Interface_EgressAclSetPathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set YANG schema element.
type Acl_Interface_EgressAclSetPathAny struct {
	*ygot.NodePath
}

// Acl_Interface_EgressAclSet_SetNamePath represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/config/set-name YANG schema element.
type Acl_Interface_EgressAclSet_SetNamePath struct {
	*ygot.NodePath
}

// Acl_Interface_EgressAclSet_SetNamePathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/config/set-name YANG schema element.
type Acl_Interface_EgressAclSet_SetNamePathAny struct {
	*ygot.NodePath
}

// Acl_Interface_EgressAclSet_TypePath represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/config/type YANG schema element.
type Acl_Interface_EgressAclSet_TypePath struct {
	*ygot.NodePath
}

// Acl_Interface_EgressAclSet_TypePathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/config/type YANG schema element.
type Acl_Interface_EgressAclSet_TypePathAny struct {
	*ygot.NodePath
}

// AclEntryAny (list): List of ACL entries assigned to an interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-entries/acl-entry"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry"
// SequenceId (wildcarded): uint32
func (n *Acl_Interface_EgressAclSetPath) AclEntryAny() *Acl_Interface_EgressAclSet_AclEntryPathAny {
	return &Acl_Interface_EgressAclSet_AclEntryPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"acl-entries", "acl-entry"},
			map[string]interface{}{"sequence-id": "*"},
			n,
		),
	}
}

// AclEntryAny (list): List of ACL entries assigned to an interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-entries/acl-entry"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry"
// SequenceId (wildcarded): uint32
func (n *Acl_Interface_EgressAclSetPathAny) AclEntryAny() *Acl_Interface_EgressAclSet_AclEntryPathAny {
	return &Acl_Interface_EgressAclSet_AclEntryPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"acl-entries", "acl-entry"},
			map[string]interface{}{"sequence-id": "*"},
			n,
		),
	}
}

// AclEntry (list): List of ACL entries assigned to an interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-entries/acl-entry"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry"
// SequenceId: uint32
func (n *Acl_Interface_EgressAclSetPath) AclEntry(SequenceId uint32) *Acl_Interface_EgressAclSet_AclEntryPath {
	return &Acl_Interface_EgressAclSet_AclEntryPath{
		NodePath: ygot.NewNodePath(
			[]string{"acl-entries", "acl-entry"},
			map[string]interface{}{"sequence-id": SequenceId},
			n,
		),
	}
}

// AclEntry (list): List of ACL entries assigned to an interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-entries/acl-entry"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry"
// SequenceId: uint32
func (n *Acl_Interface_EgressAclSetPathAny) AclEntry(SequenceId uint32) *Acl_Interface_EgressAclSet_AclEntryPathAny {
	return &Acl_Interface_EgressAclSet_AclEntryPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"acl-entries", "acl-entry"},
			map[string]interface{}{"sequence-id": SequenceId},
			n,
		),
	}
}

// SetName (leaf): Reference to the ACL set name applied on egress
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/set-name"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set/config/set-name"
func (n *Acl_Interface_EgressAclSetPath) SetName() *Acl_Interface_EgressAclSet_SetNamePath {
	return &Acl_Interface_EgressAclSet_SetNamePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "set-name"},
			map[string]interface{}{},
			n,
		),
	}
}

// SetName (leaf): Reference to the ACL set name applied on egress
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/set-name"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set/config/set-name"
func (n *Acl_Interface_EgressAclSetPathAny) SetName() *Acl_Interface_EgressAclSet_SetNamePathAny {
	return &Acl_Interface_EgressAclSet_SetNamePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "set-name"},
			map[string]interface{}{},
			n,
		),
	}
}

// Type (leaf): Reference to the ACL set type applied on egress.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/type"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set/config/type"
func (n *Acl_Interface_EgressAclSetPath) Type() *Acl_Interface_EgressAclSet_TypePath {
	return &Acl_Interface_EgressAclSet_TypePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "type"},
			map[string]interface{}{},
			n,
		),
	}
}

// Type (leaf): Reference to the ACL set type applied on egress.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/type"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set/config/type"
func (n *Acl_Interface_EgressAclSetPathAny) Type() *Acl_Interface_EgressAclSet_TypePathAny {
	return &Acl_Interface_EgressAclSet_TypePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "type"},
			map[string]interface{}{},
			n,
		),
	}
}

// Acl_Interface_EgressAclSet_AclEntryPath represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry YANG schema element.
type Acl_Interface_EgressAclSet_AclEntryPath struct {
	*ygot.NodePath
}

// Acl_Interface_EgressAclSet_AclEntryPathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry YANG schema element.
type Acl_Interface_EgressAclSet_AclEntryPathAny struct {
	*ygot.NodePath
}

// Acl_Interface_EgressAclSet_AclEntry_MatchedOctetsPath represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry/state/matched-octets YANG schema element.
type Acl_Interface_EgressAclSet_AclEntry_MatchedOctetsPath struct {
	*ygot.NodePath
}

// Acl_Interface_EgressAclSet_AclEntry_MatchedOctetsPathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry/state/matched-octets YANG schema element.
type Acl_Interface_EgressAclSet_AclEntry_MatchedOctetsPathAny struct {
	*ygot.NodePath
}

// Acl_Interface_EgressAclSet_AclEntry_MatchedPacketsPath represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry/state/matched-packets YANG schema element.
type Acl_Interface_EgressAclSet_AclEntry_MatchedPacketsPath struct {
	*ygot.NodePath
}

// Acl_Interface_EgressAclSet_AclEntry_MatchedPacketsPathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry/state/matched-packets YANG schema element.
type Acl_Interface_EgressAclSet_AclEntry_MatchedPacketsPathAny struct {
	*ygot.NodePath
}

// Acl_Interface_EgressAclSet_AclEntry_SequenceIdPath represents the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry/state/sequence-id YANG schema element.
type Acl_Interface_EgressAclSet_AclEntry_SequenceIdPath struct {
	*ygot.NodePath
}

// Acl_Interface_EgressAclSet_AclEntry_SequenceIdPathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry/state/sequence-id YANG schema element.
type Acl_Interface_EgressAclSet_AclEntry_SequenceIdPathAny struct {
	*ygot.NodePath
}

// MatchedOctets (leaf): Count of the number of octets (bytes) matching the current
// ACL entry.
//
// An implementation should provide this counter on a
// per-interface per-ACL-entry if possible.
//
// If an implementation only supports ACL counters per entry
// (i.e., not broken out per interface), then the value
// should be equal to the aggregate count across all interfaces.
//
// An implementation that provides counters per entry per
// interface is not required to also provide an aggregate count,
// e.g., per entry -- the user is expected to be able implement
// the required aggregation if such a count is needed.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "state/matched-octets"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry/state/matched-octets"
func (n *Acl_Interface_EgressAclSet_AclEntryPath) MatchedOctets() *Acl_Interface_EgressAclSet_AclEntry_MatchedOctetsPath {
	return &Acl_Interface_EgressAclSet_AclEntry_MatchedOctetsPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "matched-octets"},
			map[string]interface{}{},
			n,
		),
	}
}

// MatchedOctets (leaf): Count of the number of octets (bytes) matching the current
// ACL entry.
//
// An implementation should provide this counter on a
// per-interface per-ACL-entry if possible.
//
// If an implementation only supports ACL counters per entry
// (i.e., not broken out per interface), then the value
// should be equal to the aggregate count across all interfaces.
//
// An implementation that provides counters per entry per
// interface is not required to also provide an aggregate count,
// e.g., per entry -- the user is expected to be able implement
// the required aggregation if such a count is needed.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "state/matched-octets"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry/state/matched-octets"
func (n *Acl_Interface_EgressAclSet_AclEntryPathAny) MatchedOctets() *Acl_Interface_EgressAclSet_AclEntry_MatchedOctetsPathAny {
	return &Acl_Interface_EgressAclSet_AclEntry_MatchedOctetsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "matched-octets"},
			map[string]interface{}{},
			n,
		),
	}
}

// MatchedPackets (leaf): Count of the number of packets matching the current ACL
// entry.
//
// An implementation should provide this counter on a
// per-interface per-ACL-entry if possible.
//
// If an implementation only supports ACL counters per entry
// (i.e., not broken out per interface), then the value
// should be equal to the aggregate count across all interfaces.
//
// An implementation that provides counters per entry per
// interface is not required to also provide an aggregate count,
// e.g., per entry -- the user is expected to be able implement
// the required aggregation if such a count is needed.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "state/matched-packets"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry/state/matched-packets"
func (n *Acl_Interface_EgressAclSet_AclEntryPath) MatchedPackets() *Acl_Interface_EgressAclSet_AclEntry_MatchedPacketsPath {
	return &Acl_Interface_EgressAclSet_AclEntry_MatchedPacketsPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "matched-packets"},
			map[string]interface{}{},
			n,
		),
	}
}

// MatchedPackets (leaf): Count of the number of packets matching the current ACL
// entry.
//
// An implementation should provide this counter on a
// per-interface per-ACL-entry if possible.
//
// If an implementation only supports ACL counters per entry
// (i.e., not broken out per interface), then the value
// should be equal to the aggregate count across all interfaces.
//
// An implementation that provides counters per entry per
// interface is not required to also provide an aggregate count,
// e.g., per entry -- the user is expected to be able implement
// the required aggregation if such a count is needed.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "state/matched-packets"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry/state/matched-packets"
func (n *Acl_Interface_EgressAclSet_AclEntryPathAny) MatchedPackets() *Acl_Interface_EgressAclSet_AclEntry_MatchedPacketsPathAny {
	return &Acl_Interface_EgressAclSet_AclEntry_MatchedPacketsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "matched-packets"},
			map[string]interface{}{},
			n,
		),
	}
}

// SequenceId (leaf): Reference to an entry in the ACL set applied to an
// interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "state/sequence-id"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry/state/sequence-id"
func (n *Acl_Interface_EgressAclSet_AclEntryPath) SequenceId() *Acl_Interface_EgressAclSet_AclEntry_SequenceIdPath {
	return &Acl_Interface_EgressAclSet_AclEntry_SequenceIdPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "sequence-id"},
			map[string]interface{}{},
			n,
		),
	}
}

// SequenceId (leaf): Reference to an entry in the ACL set applied to an
// interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "state/sequence-id"
// Path from root: "/acl/interfaces/interface/egress-acl-sets/egress-acl-set/acl-entries/acl-entry/state/sequence-id"
func (n *Acl_Interface_EgressAclSet_AclEntryPathAny) SequenceId() *Acl_Interface_EgressAclSet_AclEntry_SequenceIdPathAny {
	return &Acl_Interface_EgressAclSet_AclEntry_SequenceIdPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "sequence-id"},
			map[string]interface{}{},
			n,
		),
	}
}

// Acl_Interface_IngressAclSetPath represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set YANG schema element.
type Acl_Interface_IngressAclSetPath struct {
	*ygot.NodePath
}

// Acl_Interface_IngressAclSetPathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set YANG schema element.
type Acl_Interface_IngressAclSetPathAny struct {
	*ygot.NodePath
}

// Acl_Interface_IngressAclSet_SetNamePath represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/config/set-name YANG schema element.
type Acl_Interface_IngressAclSet_SetNamePath struct {
	*ygot.NodePath
}

// Acl_Interface_IngressAclSet_SetNamePathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/config/set-name YANG schema element.
type Acl_Interface_IngressAclSet_SetNamePathAny struct {
	*ygot.NodePath
}

// Acl_Interface_IngressAclSet_TypePath represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/config/type YANG schema element.
type Acl_Interface_IngressAclSet_TypePath struct {
	*ygot.NodePath
}

// Acl_Interface_IngressAclSet_TypePathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/config/type YANG schema element.
type Acl_Interface_IngressAclSet_TypePathAny struct {
	*ygot.NodePath
}

// AclEntryAny (list): List of ACL entries assigned to an interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-entries/acl-entry"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry"
// SequenceId (wildcarded): uint32
func (n *Acl_Interface_IngressAclSetPath) AclEntryAny() *Acl_Interface_IngressAclSet_AclEntryPathAny {
	return &Acl_Interface_IngressAclSet_AclEntryPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"acl-entries", "acl-entry"},
			map[string]interface{}{"sequence-id": "*"},
			n,
		),
	}
}

// AclEntryAny (list): List of ACL entries assigned to an interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-entries/acl-entry"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry"
// SequenceId (wildcarded): uint32
func (n *Acl_Interface_IngressAclSetPathAny) AclEntryAny() *Acl_Interface_IngressAclSet_AclEntryPathAny {
	return &Acl_Interface_IngressAclSet_AclEntryPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"acl-entries", "acl-entry"},
			map[string]interface{}{"sequence-id": "*"},
			n,
		),
	}
}

// AclEntry (list): List of ACL entries assigned to an interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-entries/acl-entry"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry"
// SequenceId: uint32
func (n *Acl_Interface_IngressAclSetPath) AclEntry(SequenceId uint32) *Acl_Interface_IngressAclSet_AclEntryPath {
	return &Acl_Interface_IngressAclSet_AclEntryPath{
		NodePath: ygot.NewNodePath(
			[]string{"acl-entries", "acl-entry"},
			map[string]interface{}{"sequence-id": SequenceId},
			n,
		),
	}
}

// AclEntry (list): List of ACL entries assigned to an interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "acl-entries/acl-entry"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry"
// SequenceId: uint32
func (n *Acl_Interface_IngressAclSetPathAny) AclEntry(SequenceId uint32) *Acl_Interface_IngressAclSet_AclEntryPathAny {
	return &Acl_Interface_IngressAclSet_AclEntryPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"acl-entries", "acl-entry"},
			map[string]interface{}{"sequence-id": SequenceId},
			n,
		),
	}
}

// SetName (leaf): Reference to the ACL set name applied on ingress
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/set-name"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/config/set-name"
func (n *Acl_Interface_IngressAclSetPath) SetName() *Acl_Interface_IngressAclSet_SetNamePath {
	return &Acl_Interface_IngressAclSet_SetNamePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "set-name"},
			map[string]interface{}{},
			n,
		),
	}
}

// SetName (leaf): Reference to the ACL set name applied on ingress
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/set-name"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/config/set-name"
func (n *Acl_Interface_IngressAclSetPathAny) SetName() *Acl_Interface_IngressAclSet_SetNamePathAny {
	return &Acl_Interface_IngressAclSet_SetNamePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "set-name"},
			map[string]interface{}{},
			n,
		),
	}
}

// Type (leaf): Reference to the ACL set type applied on ingress
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/type"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/config/type"
func (n *Acl_Interface_IngressAclSetPath) Type() *Acl_Interface_IngressAclSet_TypePath {
	return &Acl_Interface_IngressAclSet_TypePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "type"},
			map[string]interface{}{},
			n,
		),
	}
}

// Type (leaf): Reference to the ACL set type applied on ingress
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/type"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/config/type"
func (n *Acl_Interface_IngressAclSetPathAny) Type() *Acl_Interface_IngressAclSet_TypePathAny {
	return &Acl_Interface_IngressAclSet_TypePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "type"},
			map[string]interface{}{},
			n,
		),
	}
}

// Acl_Interface_IngressAclSet_AclEntryPath represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry YANG schema element.
type Acl_Interface_IngressAclSet_AclEntryPath struct {
	*ygot.NodePath
}

// Acl_Interface_IngressAclSet_AclEntryPathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry YANG schema element.
type Acl_Interface_IngressAclSet_AclEntryPathAny struct {
	*ygot.NodePath
}

// Acl_Interface_IngressAclSet_AclEntry_MatchedOctetsPath represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry/state/matched-octets YANG schema element.
type Acl_Interface_IngressAclSet_AclEntry_MatchedOctetsPath struct {
	*ygot.NodePath
}

// Acl_Interface_IngressAclSet_AclEntry_MatchedOctetsPathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry/state/matched-octets YANG schema element.
type Acl_Interface_IngressAclSet_AclEntry_MatchedOctetsPathAny struct {
	*ygot.NodePath
}

// Acl_Interface_IngressAclSet_AclEntry_MatchedPacketsPath represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry/state/matched-packets YANG schema element.
type Acl_Interface_IngressAclSet_AclEntry_MatchedPacketsPath struct {
	*ygot.NodePath
}

// Acl_Interface_IngressAclSet_AclEntry_MatchedPacketsPathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry/state/matched-packets YANG schema element.
type Acl_Interface_IngressAclSet_AclEntry_MatchedPacketsPathAny struct {
	*ygot.NodePath
}

// Acl_Interface_IngressAclSet_AclEntry_SequenceIdPath represents the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry/state/sequence-id YANG schema element.
type Acl_Interface_IngressAclSet_AclEntry_SequenceIdPath struct {
	*ygot.NodePath
}

// Acl_Interface_IngressAclSet_AclEntry_SequenceIdPathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry/state/sequence-id YANG schema element.
type Acl_Interface_IngressAclSet_AclEntry_SequenceIdPathAny struct {
	*ygot.NodePath
}

// MatchedOctets (leaf): Count of the number of octets (bytes) matching the current
// ACL entry.
//
// An implementation should provide this counter on a
// per-interface per-ACL-entry if possible.
//
// If an implementation only supports ACL counters per entry
// (i.e., not broken out per interface), then the value
// should be equal to the aggregate count across all interfaces.
//
// An implementation that provides counters per entry per
// interface is not required to also provide an aggregate count,
// e.g., per entry -- the user is expected to be able implement
// the required aggregation if such a count is needed.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "state/matched-octets"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry/state/matched-octets"
func (n *Acl_Interface_IngressAclSet_AclEntryPath) MatchedOctets() *Acl_Interface_IngressAclSet_AclEntry_MatchedOctetsPath {
	return &Acl_Interface_IngressAclSet_AclEntry_MatchedOctetsPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "matched-octets"},
			map[string]interface{}{},
			n,
		),
	}
}

// MatchedOctets (leaf): Count of the number of octets (bytes) matching the current
// ACL entry.
//
// An implementation should provide this counter on a
// per-interface per-ACL-entry if possible.
//
// If an implementation only supports ACL counters per entry
// (i.e., not broken out per interface), then the value
// should be equal to the aggregate count across all interfaces.
//
// An implementation that provides counters per entry per
// interface is not required to also provide an aggregate count,
// e.g., per entry -- the user is expected to be able implement
// the required aggregation if such a count is needed.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "state/matched-octets"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry/state/matched-octets"
func (n *Acl_Interface_IngressAclSet_AclEntryPathAny) MatchedOctets() *Acl_Interface_IngressAclSet_AclEntry_MatchedOctetsPathAny {
	return &Acl_Interface_IngressAclSet_AclEntry_MatchedOctetsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "matched-octets"},
			map[string]interface{}{},
			n,
		),
	}
}

// MatchedPackets (leaf): Count of the number of packets matching the current ACL
// entry.
//
// An implementation should provide this counter on a
// per-interface per-ACL-entry if possible.
//
// If an implementation only supports ACL counters per entry
// (i.e., not broken out per interface), then the value
// should be equal to the aggregate count across all interfaces.
//
// An implementation that provides counters per entry per
// interface is not required to also provide an aggregate count,
// e.g., per entry -- the user is expected to be able implement
// the required aggregation if such a count is needed.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "state/matched-packets"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry/state/matched-packets"
func (n *Acl_Interface_IngressAclSet_AclEntryPath) MatchedPackets() *Acl_Interface_IngressAclSet_AclEntry_MatchedPacketsPath {
	return &Acl_Interface_IngressAclSet_AclEntry_MatchedPacketsPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "matched-packets"},
			map[string]interface{}{},
			n,
		),
	}
}

// MatchedPackets (leaf): Count of the number of packets matching the current ACL
// entry.
//
// An implementation should provide this counter on a
// per-interface per-ACL-entry if possible.
//
// If an implementation only supports ACL counters per entry
// (i.e., not broken out per interface), then the value
// should be equal to the aggregate count across all interfaces.
//
// An implementation that provides counters per entry per
// interface is not required to also provide an aggregate count,
// e.g., per entry -- the user is expected to be able implement
// the required aggregation if such a count is needed.
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "state/matched-packets"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry/state/matched-packets"
func (n *Acl_Interface_IngressAclSet_AclEntryPathAny) MatchedPackets() *Acl_Interface_IngressAclSet_AclEntry_MatchedPacketsPathAny {
	return &Acl_Interface_IngressAclSet_AclEntry_MatchedPacketsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "matched-packets"},
			map[string]interface{}{},
			n,
		),
	}
}

// SequenceId (leaf): Reference to an entry in the ACL set applied to an
// interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "state/sequence-id"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry/state/sequence-id"
func (n *Acl_Interface_IngressAclSet_AclEntryPath) SequenceId() *Acl_Interface_IngressAclSet_AclEntry_SequenceIdPath {
	return &Acl_Interface_IngressAclSet_AclEntry_SequenceIdPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "sequence-id"},
			map[string]interface{}{},
			n,
		),
	}
}

// SequenceId (leaf): Reference to an entry in the ACL set applied to an
// interface
// ----------------------------------------
// Defining module: "openconfig-acl"
// Instantiating module: "openconfig-acl"
// Path from parent: "state/sequence-id"
// Path from root: "/acl/interfaces/interface/ingress-acl-sets/ingress-acl-set/acl-entries/acl-entry/state/sequence-id"
func (n *Acl_Interface_IngressAclSet_AclEntryPathAny) SequenceId() *Acl_Interface_IngressAclSet_AclEntry_SequenceIdPathAny {
	return &Acl_Interface_IngressAclSet_AclEntry_SequenceIdPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "sequence-id"},
			map[string]interface{}{},
			n,
		),
	}
}

// Acl_Interface_InterfaceRefPath represents the /openconfig-acl/acl/interfaces/interface/interface-ref YANG schema element.
type Acl_Interface_InterfaceRefPath struct {
	*ygot.NodePath
}

// Acl_Interface_InterfaceRefPathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface/interface-ref YANG schema element.
type Acl_Interface_InterfaceRefPathAny struct {
	*ygot.NodePath
}

// Acl_Interface_InterfaceRef_InterfacePath represents the /openconfig-acl/acl/interfaces/interface/interface-ref/config/interface YANG schema element.
type Acl_Interface_InterfaceRef_InterfacePath struct {
	*ygot.NodePath
}

// Acl_Interface_InterfaceRef_InterfacePathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface/interface-ref/config/interface YANG schema element.
type Acl_Interface_InterfaceRef_InterfacePathAny struct {
	*ygot.NodePath
}

// Acl_Interface_InterfaceRef_SubinterfacePath represents the /openconfig-acl/acl/interfaces/interface/interface-ref/config/subinterface YANG schema element.
type Acl_Interface_InterfaceRef_SubinterfacePath struct {
	*ygot.NodePath
}

// Acl_Interface_InterfaceRef_SubinterfacePathAny represents the wildcard version of the /openconfig-acl/acl/interfaces/interface/interface-ref/config/subinterface YANG schema element.
type Acl_Interface_InterfaceRef_SubinterfacePathAny struct {
	*ygot.NodePath
}

// Interface (leaf): Reference to a base interface.  If a reference to a
// subinterface is required, this leaf must be specified
// to indicate the base interface.
// ----------------------------------------
// Defining module: "openconfig-interfaces"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/interface"
// Path from root: "/acl/interfaces/interface/interface-ref/config/interface"
func (n *Acl_Interface_InterfaceRefPath) Interface() *Acl_Interface_InterfaceRef_InterfacePath {
	return &Acl_Interface_InterfaceRef_InterfacePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "interface"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interface (leaf): Reference to a base interface.  If a reference to a
// subinterface is required, this leaf must be specified
// to indicate the base interface.
// ----------------------------------------
// Defining module: "openconfig-interfaces"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/interface"
// Path from root: "/acl/interfaces/interface/interface-ref/config/interface"
func (n *Acl_Interface_InterfaceRefPathAny) Interface() *Acl_Interface_InterfaceRef_InterfacePathAny {
	return &Acl_Interface_InterfaceRef_InterfacePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "interface"},
			map[string]interface{}{},
			n,
		),
	}
}

// Subinterface (leaf): Reference to a subinterface -- this requires the base
// interface to be specified using the interface leaf in
// this container.  If only a reference to a base interface
// is requuired, this leaf should not be set.
// ----------------------------------------
// Defining module: "openconfig-interfaces"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/subinterface"
// Path from root: "/acl/interfaces/interface/interface-ref/config/subinterface"
func (n *Acl_Interface_InterfaceRefPath) Subinterface() *Acl_Interface_InterfaceRef_SubinterfacePath {
	return &Acl_Interface_InterfaceRef_SubinterfacePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "subinterface"},
			map[string]interface{}{},
			n,
		),
	}
}

// Subinterface (leaf): Reference to a subinterface -- this requires the base
// interface to be specified using the interface leaf in
// this container.  If only a reference to a base interface
// is requuired, this leaf should not be set.
// ----------------------------------------
// Defining module: "openconfig-interfaces"
// Instantiating module: "openconfig-acl"
// Path from parent: "config/subinterface"
// Path from root: "/acl/interfaces/interface/interface-ref/config/subinterface"
func (n *Acl_Interface_InterfaceRefPathAny) Subinterface() *Acl_Interface_InterfaceRef_SubinterfacePathAny {
	return &Acl_Interface_InterfaceRef_SubinterfacePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "subinterface"},
			map[string]interface{}{},
			n,
		),
	}
}

// ApsPath represents the /openconfig-transport-line-protection/aps YANG schema element.
type ApsPath struct {
	*ygot.NodePath
}

// ApsPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps YANG schema element.
type ApsPathAny struct {
	*ygot.NodePath
}

// ApsModuleAny (list): List of automatic protection switch modules present
// in the device
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "aps-modules/aps-module"
// Path from root: "/aps/aps-modules/aps-module"
// Name (wildcarded): string
func (n *ApsPath) ApsModuleAny() *Aps_ApsModulePathAny {
	return &Aps_ApsModulePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"aps-modules", "aps-module"},
			map[string]interface{}{"name": "*"},
			n,
		),
	}
}

// ApsModuleAny (list): List of automatic protection switch modules present
// in the device
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "aps-modules/aps-module"
// Path from root: "/aps/aps-modules/aps-module"
// Name (wildcarded): string
func (n *ApsPathAny) ApsModuleAny() *Aps_ApsModulePathAny {
	return &Aps_ApsModulePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"aps-modules", "aps-module"},
			map[string]interface{}{"name": "*"},
			n,
		),
	}
}

// ApsModule (list): List of automatic protection switch modules present
// in the device
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "aps-modules/aps-module"
// Path from root: "/aps/aps-modules/aps-module"
// Name: string
func (n *ApsPath) ApsModule(Name string) *Aps_ApsModulePath {
	return &Aps_ApsModulePath{
		NodePath: ygot.NewNodePath(
			[]string{"aps-modules", "aps-module"},
			map[string]interface{}{"name": Name},
			n,
		),
	}
}

// ApsModule (list): List of automatic protection switch modules present
// in the device
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "aps-modules/aps-module"
// Path from root: "/aps/aps-modules/aps-module"
// Name: string
func (n *ApsPathAny) ApsModule(Name string) *Aps_ApsModulePathAny {
	return &Aps_ApsModulePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"aps-modules", "aps-module"},
			map[string]interface{}{"name": Name},
			n,
		),
	}
}

// Aps_ApsModulePath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module YANG schema element.
type Aps_ApsModulePath struct {
	*ygot.NodePath
}

// Aps_ApsModulePathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module YANG schema element.
type Aps_ApsModulePathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_ActivePathPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/state/active-path YANG schema element.
type Aps_ApsModule_ActivePathPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_ActivePathPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/state/active-path YANG schema element.
type Aps_ApsModule_ActivePathPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_ForceToPortPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/force-to-port YANG schema element.
type Aps_ApsModule_ForceToPortPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_ForceToPortPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/force-to-port YANG schema element.
type Aps_ApsModule_ForceToPortPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_HoldOffTimePath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/hold-off-time YANG schema element.
type Aps_ApsModule_HoldOffTimePath struct {
	*ygot.NodePath
}

// Aps_ApsModule_HoldOffTimePathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/hold-off-time YANG schema element.
type Aps_ApsModule_HoldOffTimePathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_NamePath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/name YANG schema element.
type Aps_ApsModule_NamePath struct {
	*ygot.NodePath
}

// Aps_ApsModule_NamePathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/name YANG schema element.
type Aps_ApsModule_NamePathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_PrimarySwitchHysteresisPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/primary-switch-hysteresis YANG schema element.
type Aps_ApsModule_PrimarySwitchHysteresisPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_PrimarySwitchHysteresisPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/primary-switch-hysteresis YANG schema element.
type Aps_ApsModule_PrimarySwitchHysteresisPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_PrimarySwitchThresholdPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/primary-switch-threshold YANG schema element.
type Aps_ApsModule_PrimarySwitchThresholdPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_PrimarySwitchThresholdPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/primary-switch-threshold YANG schema element.
type Aps_ApsModule_PrimarySwitchThresholdPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_RelativeSwitchThresholdPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/relative-switch-threshold YANG schema element.
type Aps_ApsModule_RelativeSwitchThresholdPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_RelativeSwitchThresholdPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/relative-switch-threshold YANG schema element.
type Aps_ApsModule_RelativeSwitchThresholdPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_RelativeSwitchThresholdOffsetPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/relative-switch-threshold-offset YANG schema element.
type Aps_ApsModule_RelativeSwitchThresholdOffsetPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_RelativeSwitchThresholdOffsetPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/relative-switch-threshold-offset YANG schema element.
type Aps_ApsModule_RelativeSwitchThresholdOffsetPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_RevertivePath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/revertive YANG schema element.
type Aps_ApsModule_RevertivePath struct {
	*ygot.NodePath
}

// Aps_ApsModule_RevertivePathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/revertive YANG schema element.
type Aps_ApsModule_RevertivePathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_SecondarySwitchThresholdPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/secondary-switch-threshold YANG schema element.
type Aps_ApsModule_SecondarySwitchThresholdPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_SecondarySwitchThresholdPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/secondary-switch-threshold YANG schema element.
type Aps_ApsModule_SecondarySwitchThresholdPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_WaitToRestoreTimePath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/wait-to-restore-time YANG schema element.
type Aps_ApsModule_WaitToRestoreTimePath struct {
	*ygot.NodePath
}

// Aps_ApsModule_WaitToRestoreTimePathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/config/wait-to-restore-time YANG schema element.
type Aps_ApsModule_WaitToRestoreTimePathAny struct {
	*ygot.NodePath
}

// ActivePath (leaf): Indicates which line path on the protection switch is
// currently the active path connected to the common port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/active-path"
// Path from root: "/aps/aps-modules/aps-module/state/active-path"
func (n *Aps_ApsModulePath) ActivePath() *Aps_ApsModule_ActivePathPath {
	return &Aps_ApsModule_ActivePathPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "active-path"},
			map[string]interface{}{},
			n,
		),
	}
}

// ActivePath (leaf): Indicates which line path on the protection switch is
// currently the active path connected to the common port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/active-path"
// Path from root: "/aps/aps-modules/aps-module/state/active-path"
func (n *Aps_ApsModulePathAny) ActivePath() *Aps_ApsModule_ActivePathPathAny {
	return &Aps_ApsModule_ActivePathPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "active-path"},
			map[string]interface{}{},
			n,
		),
	}
}

// ForceToPort (leaf): Explicitly set the switch to stay on a port regardless of
// its operational condition
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/force-to-port"
// Path from root: "/aps/aps-modules/aps-module/config/force-to-port"
func (n *Aps_ApsModulePath) ForceToPort() *Aps_ApsModule_ForceToPortPath {
	return &Aps_ApsModule_ForceToPortPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "force-to-port"},
			map[string]interface{}{},
			n,
		),
	}
}

// ForceToPort (leaf): Explicitly set the switch to stay on a port regardless of
// its operational condition
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/force-to-port"
// Path from root: "/aps/aps-modules/aps-module/config/force-to-port"
func (n *Aps_ApsModulePathAny) ForceToPort() *Aps_ApsModule_ForceToPortPathAny {
	return &Aps_ApsModule_ForceToPortPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "force-to-port"},
			map[string]interface{}{},
			n,
		),
	}
}

// HoldOffTime (leaf): The time delay between the declaration of an SF or SD
// condition and the initiation of the protection switching
// algorithm
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/hold-off-time"
// Path from root: "/aps/aps-modules/aps-module/config/hold-off-time"
func (n *Aps_ApsModulePath) HoldOffTime() *Aps_ApsModule_HoldOffTimePath {
	return &Aps_ApsModule_HoldOffTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "hold-off-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// HoldOffTime (leaf): The time delay between the declaration of an SF or SD
// condition and the initiation of the protection switching
// algorithm
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/hold-off-time"
// Path from root: "/aps/aps-modules/aps-module/config/hold-off-time"
func (n *Aps_ApsModulePathAny) HoldOffTime() *Aps_ApsModule_HoldOffTimePathAny {
	return &Aps_ApsModule_HoldOffTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "hold-off-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Name (leaf): Reference to the component name (in the platform model)
// corresponding to this automatic protection switch module
// in the device
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/name"
// Path from root: "/aps/aps-modules/aps-module/config/name"
func (n *Aps_ApsModulePath) Name() *Aps_ApsModule_NamePath {
	return &Aps_ApsModule_NamePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "name"},
			map[string]interface{}{},
			n,
		),
	}
}

// Name (leaf): Reference to the component name (in the platform model)
// corresponding to this automatic protection switch module
// in the device
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/name"
// Path from root: "/aps/aps-modules/aps-module/config/name"
func (n *Aps_ApsModulePathAny) Name() *Aps_ApsModule_NamePathAny {
	return &Aps_ApsModule_NamePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "name"},
			map[string]interface{}{},
			n,
		),
	}
}

// Ports (container): Top level grouping for automatic protection switch ports
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "ports"
// Path from root: "/aps/aps-modules/aps-module/ports"
func (n *Aps_ApsModulePath) Ports() *Aps_ApsModule_PortsPath {
	return &Aps_ApsModule_PortsPath{
		NodePath: ygot.NewNodePath(
			[]string{"ports"},
			map[string]interface{}{},
			n,
		),
	}
}

// Ports (container): Top level grouping for automatic protection switch ports
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "ports"
// Path from root: "/aps/aps-modules/aps-module/ports"
func (n *Aps_ApsModulePathAny) Ports() *Aps_ApsModule_PortsPathAny {
	return &Aps_ApsModule_PortsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"ports"},
			map[string]interface{}{},
			n,
		),
	}
}

// PrimarySwitchHysteresis (leaf): The delta in dB between the primary-switch-threshold
// and the signal received on the primary APS_PATH before
// initiating a switch from the secondary APS_PATH to the
// primary APS_PATH, in order to prevent toggling between ports
// when an input signal is very close to the threshold. A zero
// value means the switch hysteresis is disabled.
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/primary-switch-hysteresis"
// Path from root: "/aps/aps-modules/aps-module/config/primary-switch-hysteresis"
func (n *Aps_ApsModulePath) PrimarySwitchHysteresis() *Aps_ApsModule_PrimarySwitchHysteresisPath {
	return &Aps_ApsModule_PrimarySwitchHysteresisPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "primary-switch-hysteresis"},
			map[string]interface{}{},
			n,
		),
	}
}

// PrimarySwitchHysteresis (leaf): The delta in dB between the primary-switch-threshold
// and the signal received on the primary APS_PATH before
// initiating a switch from the secondary APS_PATH to the
// primary APS_PATH, in order to prevent toggling between ports
// when an input signal is very close to the threshold. A zero
// value means the switch hysteresis is disabled.
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/primary-switch-hysteresis"
// Path from root: "/aps/aps-modules/aps-module/config/primary-switch-hysteresis"
func (n *Aps_ApsModulePathAny) PrimarySwitchHysteresis() *Aps_ApsModule_PrimarySwitchHysteresisPathAny {
	return &Aps_ApsModule_PrimarySwitchHysteresisPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "primary-switch-hysteresis"},
			map[string]interface{}{},
			n,
		),
	}
}

// PrimarySwitchThreshold (leaf): The threshold at which the primary line port will switch to
// the opposite line port in increments of 0.01 dBm. If the
// hardware supports only one switch threshold for primary and
// and secondary ports then it is recommended to set both
// primary-switch-threshold and secondary-switch-threshold to
// the same value to be explicit. When the relative switch
// threshold is enabled, i.e. set to a non-zero value, the
// primary switch threshold will be overridden
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/primary-switch-threshold"
// Path from root: "/aps/aps-modules/aps-module/config/primary-switch-threshold"
func (n *Aps_ApsModulePath) PrimarySwitchThreshold() *Aps_ApsModule_PrimarySwitchThresholdPath {
	return &Aps_ApsModule_PrimarySwitchThresholdPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "primary-switch-threshold"},
			map[string]interface{}{},
			n,
		),
	}
}

// PrimarySwitchThreshold (leaf): The threshold at which the primary line port will switch to
// the opposite line port in increments of 0.01 dBm. If the
// hardware supports only one switch threshold for primary and
// and secondary ports then it is recommended to set both
// primary-switch-threshold and secondary-switch-threshold to
// the same value to be explicit. When the relative switch
// threshold is enabled, i.e. set to a non-zero value, the
// primary switch threshold will be overridden
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/primary-switch-threshold"
// Path from root: "/aps/aps-modules/aps-module/config/primary-switch-threshold"
func (n *Aps_ApsModulePathAny) PrimarySwitchThreshold() *Aps_ApsModule_PrimarySwitchThresholdPathAny {
	return &Aps_ApsModule_PrimarySwitchThresholdPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "primary-switch-threshold"},
			map[string]interface{}{},
			n,
		),
	}
}

// RelativeSwitchThreshold (leaf): The delta threshold in dB at which the current line port
// will switch to the opposite line port. It can be set to
// the value of 0dB. When set to 0dB, the threshold is ignored
// and the system automatically applies the primary and
// secondary switch thresholds. When set to a non-zero value,
// it overrides the primary and secondary switch thresholds
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/relative-switch-threshold"
// Path from root: "/aps/aps-modules/aps-module/config/relative-switch-threshold"
func (n *Aps_ApsModulePath) RelativeSwitchThreshold() *Aps_ApsModule_RelativeSwitchThresholdPath {
	return &Aps_ApsModule_RelativeSwitchThresholdPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "relative-switch-threshold"},
			map[string]interface{}{},
			n,
		),
	}
}

// RelativeSwitchThreshold (leaf): The delta threshold in dB at which the current line port
// will switch to the opposite line port. It can be set to
// the value of 0dB. When set to 0dB, the threshold is ignored
// and the system automatically applies the primary and
// secondary switch thresholds. When set to a non-zero value,
// it overrides the primary and secondary switch thresholds
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/relative-switch-threshold"
// Path from root: "/aps/aps-modules/aps-module/config/relative-switch-threshold"
func (n *Aps_ApsModulePathAny) RelativeSwitchThreshold() *Aps_ApsModule_RelativeSwitchThresholdPathAny {
	return &Aps_ApsModule_RelativeSwitchThresholdPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "relative-switch-threshold"},
			map[string]interface{}{},
			n,
		),
	}
}

// RelativeSwitchThresholdOffset (leaf): The offset of the relative switch threshold that compensates
// the normal difference of receiving power between the primary
// and secondary line ports. A negative offset corresponds to
// the situation where the secondary line port receives a higher
// power than the primary line port in normal condition， and a
// positive offset means the opposite. The offset will only work
// when the relative switch threshold is set to a non-zero
// value
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/relative-switch-threshold-offset"
// Path from root: "/aps/aps-modules/aps-module/config/relative-switch-threshold-offset"
func (n *Aps_ApsModulePath) RelativeSwitchThresholdOffset() *Aps_ApsModule_RelativeSwitchThresholdOffsetPath {
	return &Aps_ApsModule_RelativeSwitchThresholdOffsetPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "relative-switch-threshold-offset"},
			map[string]interface{}{},
			n,
		),
	}
}

// RelativeSwitchThresholdOffset (leaf): The offset of the relative switch threshold that compensates
// the normal difference of receiving power between the primary
// and secondary line ports. A negative offset corresponds to
// the situation where the secondary line port receives a higher
// power than the primary line port in normal condition， and a
// positive offset means the opposite. The offset will only work
// when the relative switch threshold is set to a non-zero
// value
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/relative-switch-threshold-offset"
// Path from root: "/aps/aps-modules/aps-module/config/relative-switch-threshold-offset"
func (n *Aps_ApsModulePathAny) RelativeSwitchThresholdOffset() *Aps_ApsModule_RelativeSwitchThresholdOffsetPathAny {
	return &Aps_ApsModule_RelativeSwitchThresholdOffsetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "relative-switch-threshold-offset"},
			map[string]interface{}{},
			n,
		),
	}
}

// Revertive (leaf): Revertive behavior of the module. If True, then
// automatically revert after protection switch once the
// fault is restored. This leaf is not valid when the
// relative-switch-threshold is in effect
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/revertive"
// Path from root: "/aps/aps-modules/aps-module/config/revertive"
func (n *Aps_ApsModulePath) Revertive() *Aps_ApsModule_RevertivePath {
	return &Aps_ApsModule_RevertivePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "revertive"},
			map[string]interface{}{},
			n,
		),
	}
}

// Revertive (leaf): Revertive behavior of the module. If True, then
// automatically revert after protection switch once the
// fault is restored. This leaf is not valid when the
// relative-switch-threshold is in effect
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/revertive"
// Path from root: "/aps/aps-modules/aps-module/config/revertive"
func (n *Aps_ApsModulePathAny) Revertive() *Aps_ApsModule_RevertivePathAny {
	return &Aps_ApsModule_RevertivePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "revertive"},
			map[string]interface{}{},
			n,
		),
	}
}

// SecondarySwitchThreshold (leaf): The threshold at which the secondary line port will switch to
// the opposite line port in increments of 0.01 dBm. If the
// hardware supports only one switch threshold for primary and
// and secondary ports then it is recommended to set both
// primary-switch-threshold and secondary-switch-threshold to
// the same value to be explicit. When the relative switch
// threshold is enabled, i.e. set to a non-zero value, the
// secondary switch threshold will be overridden
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/secondary-switch-threshold"
// Path from root: "/aps/aps-modules/aps-module/config/secondary-switch-threshold"
func (n *Aps_ApsModulePath) SecondarySwitchThreshold() *Aps_ApsModule_SecondarySwitchThresholdPath {
	return &Aps_ApsModule_SecondarySwitchThresholdPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "secondary-switch-threshold"},
			map[string]interface{}{},
			n,
		),
	}
}

// SecondarySwitchThreshold (leaf): The threshold at which the secondary line port will switch to
// the opposite line port in increments of 0.01 dBm. If the
// hardware supports only one switch threshold for primary and
// and secondary ports then it is recommended to set both
// primary-switch-threshold and secondary-switch-threshold to
// the same value to be explicit. When the relative switch
// threshold is enabled, i.e. set to a non-zero value, the
// secondary switch threshold will be overridden
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/secondary-switch-threshold"
// Path from root: "/aps/aps-modules/aps-module/config/secondary-switch-threshold"
func (n *Aps_ApsModulePathAny) SecondarySwitchThreshold() *Aps_ApsModule_SecondarySwitchThresholdPathAny {
	return &Aps_ApsModule_SecondarySwitchThresholdPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "secondary-switch-threshold"},
			map[string]interface{}{},
			n,
		),
	}
}

// WaitToRestoreTime (leaf): The time that must elapse before an APS path
// that has recovered from an signal failure (SF) or signal
// degradation (SD) condition can be used again to transport
// the normal traffic signal. During this time period, an SF or
// SD condition shall override the wait-to-restore time period.
// This leaf can only take effect when the revertive leaf
// equals true
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/wait-to-restore-time"
// Path from root: "/aps/aps-modules/aps-module/config/wait-to-restore-time"
func (n *Aps_ApsModulePath) WaitToRestoreTime() *Aps_ApsModule_WaitToRestoreTimePath {
	return &Aps_ApsModule_WaitToRestoreTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "wait-to-restore-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// WaitToRestoreTime (leaf): The time that must elapse before an APS path
// that has recovered from an signal failure (SF) or signal
// degradation (SD) condition can be used again to transport
// the normal traffic signal. During this time period, an SF or
// SD condition shall override the wait-to-restore time period.
// This leaf can only take effect when the revertive leaf
// equals true
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/wait-to-restore-time"
// Path from root: "/aps/aps-modules/aps-module/config/wait-to-restore-time"
func (n *Aps_ApsModulePathAny) WaitToRestoreTime() *Aps_ApsModule_WaitToRestoreTimePathAny {
	return &Aps_ApsModule_WaitToRestoreTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "wait-to-restore-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Aps_ApsModule_PortsPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports YANG schema element.
type Aps_ApsModule_PortsPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_PortsPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports YANG schema element.
type Aps_ApsModule_PortsPathAny struct {
	*ygot.NodePath
}

// CommonIn (container): Container for information related to the line common
// input port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "common-in"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in"
func (n *Aps_ApsModule_PortsPath) CommonIn() *Aps_ApsModule_Ports_CommonInPath {
	return &Aps_ApsModule_Ports_CommonInPath{
		NodePath: ygot.NewNodePath(
			[]string{"common-in"},
			map[string]interface{}{},
			n,
		),
	}
}

// CommonIn (container): Container for information related to the line common
// input port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "common-in"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in"
func (n *Aps_ApsModule_PortsPathAny) CommonIn() *Aps_ApsModule_Ports_CommonInPathAny {
	return &Aps_ApsModule_Ports_CommonInPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"common-in"},
			map[string]interface{}{},
			n,
		),
	}
}

// CommonOutput (container): Container for information related to the line common
// output port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "common-output"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output"
func (n *Aps_ApsModule_PortsPath) CommonOutput() *Aps_ApsModule_Ports_CommonOutputPath {
	return &Aps_ApsModule_Ports_CommonOutputPath{
		NodePath: ygot.NewNodePath(
			[]string{"common-output"},
			map[string]interface{}{},
			n,
		),
	}
}

// CommonOutput (container): Container for information related to the line common
// output port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "common-output"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output"
func (n *Aps_ApsModule_PortsPathAny) CommonOutput() *Aps_ApsModule_Ports_CommonOutputPathAny {
	return &Aps_ApsModule_Ports_CommonOutputPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"common-output"},
			map[string]interface{}{},
			n,
		),
	}
}

// LinePrimaryIn (container): Container for information related to the line primary
// input port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "line-primary-in"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in"
func (n *Aps_ApsModule_PortsPath) LinePrimaryIn() *Aps_ApsModule_Ports_LinePrimaryInPath {
	return &Aps_ApsModule_Ports_LinePrimaryInPath{
		NodePath: ygot.NewNodePath(
			[]string{"line-primary-in"},
			map[string]interface{}{},
			n,
		),
	}
}

// LinePrimaryIn (container): Container for information related to the line primary
// input port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "line-primary-in"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in"
func (n *Aps_ApsModule_PortsPathAny) LinePrimaryIn() *Aps_ApsModule_Ports_LinePrimaryInPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryInPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"line-primary-in"},
			map[string]interface{}{},
			n,
		),
	}
}

// LinePrimaryOut (container): Container for information related to the line primary
// output port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "line-primary-out"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out"
func (n *Aps_ApsModule_PortsPath) LinePrimaryOut() *Aps_ApsModule_Ports_LinePrimaryOutPath {
	return &Aps_ApsModule_Ports_LinePrimaryOutPath{
		NodePath: ygot.NewNodePath(
			[]string{"line-primary-out"},
			map[string]interface{}{},
			n,
		),
	}
}

// LinePrimaryOut (container): Container for information related to the line primary
// output port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "line-primary-out"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out"
func (n *Aps_ApsModule_PortsPathAny) LinePrimaryOut() *Aps_ApsModule_Ports_LinePrimaryOutPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryOutPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"line-primary-out"},
			map[string]interface{}{},
			n,
		),
	}
}

// LineSecondaryIn (container): Container for information related to the line secondary
// input port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "line-secondary-in"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in"
func (n *Aps_ApsModule_PortsPath) LineSecondaryIn() *Aps_ApsModule_Ports_LineSecondaryInPath {
	return &Aps_ApsModule_Ports_LineSecondaryInPath{
		NodePath: ygot.NewNodePath(
			[]string{"line-secondary-in"},
			map[string]interface{}{},
			n,
		),
	}
}

// LineSecondaryIn (container): Container for information related to the line secondary
// input port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "line-secondary-in"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in"
func (n *Aps_ApsModule_PortsPathAny) LineSecondaryIn() *Aps_ApsModule_Ports_LineSecondaryInPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryInPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"line-secondary-in"},
			map[string]interface{}{},
			n,
		),
	}
}

// LineSecondaryOut (container): Container for information related to the line secondary
// output port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "line-secondary-out"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out"
func (n *Aps_ApsModule_PortsPath) LineSecondaryOut() *Aps_ApsModule_Ports_LineSecondaryOutPath {
	return &Aps_ApsModule_Ports_LineSecondaryOutPath{
		NodePath: ygot.NewNodePath(
			[]string{"line-secondary-out"},
			map[string]interface{}{},
			n,
		),
	}
}

// LineSecondaryOut (container): Container for information related to the line secondary
// output port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "line-secondary-out"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out"
func (n *Aps_ApsModule_PortsPathAny) LineSecondaryOut() *Aps_ApsModule_Ports_LineSecondaryOutPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryOutPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"line-secondary-out"},
			map[string]interface{}{},
			n,
		),
	}
}

// Aps_ApsModule_Ports_CommonInPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in YANG schema element.
type Aps_ApsModule_Ports_CommonInPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonInPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in YANG schema element.
type Aps_ApsModule_Ports_CommonInPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_AttenuationPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/attenuation YANG schema element.
type Aps_ApsModule_Ports_CommonIn_AttenuationPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_AttenuationPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/attenuation YANG schema element.
type Aps_ApsModule_Ports_CommonIn_AttenuationPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_EnabledPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/config/enabled YANG schema element.
type Aps_ApsModule_Ports_CommonIn_EnabledPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_EnabledPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/config/enabled YANG schema element.
type Aps_ApsModule_Ports_CommonIn_EnabledPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_TargetAttenuationPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/config/target-attenuation YANG schema element.
type Aps_ApsModule_Ports_CommonIn_TargetAttenuationPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_TargetAttenuationPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/config/target-attenuation YANG schema element.
type Aps_ApsModule_Ports_CommonIn_TargetAttenuationPathAny struct {
	*ygot.NodePath
}

// Attenuation (leaf): The attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB.
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/state/attenuation"
func (n *Aps_ApsModule_Ports_CommonInPath) Attenuation() *Aps_ApsModule_Ports_CommonIn_AttenuationPath {
	return &Aps_ApsModule_Ports_CommonIn_AttenuationPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// Attenuation (leaf): The attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB.
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/state/attenuation"
func (n *Aps_ApsModule_Ports_CommonInPathAny) Attenuation() *Aps_ApsModule_Ports_CommonIn_AttenuationPathAny {
	return &Aps_ApsModule_Ports_CommonIn_AttenuationPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// Enabled (leaf): This leaf contains the configured, desired state of the
// port. Disabling the port turns off alarm reporting for
// the port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/enabled"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/config/enabled"
func (n *Aps_ApsModule_Ports_CommonInPath) Enabled() *Aps_ApsModule_Ports_CommonIn_EnabledPath {
	return &Aps_ApsModule_Ports_CommonIn_EnabledPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "enabled"},
			map[string]interface{}{},
			n,
		),
	}
}

// Enabled (leaf): This leaf contains the configured, desired state of the
// port. Disabling the port turns off alarm reporting for
// the port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/enabled"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/config/enabled"
func (n *Aps_ApsModule_Ports_CommonInPathAny) Enabled() *Aps_ApsModule_Ports_CommonIn_EnabledPathAny {
	return &Aps_ApsModule_Ports_CommonIn_EnabledPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "enabled"},
			map[string]interface{}{},
			n,
		),
	}
}

// OpticalPower (container): The optical input power of this port in units of
// 0.01dBm. Optical input power represents the signal
// traversing from an external destination into the module.
// The power is measured before any attenuation. If avg/min/max
// statistics are not supported, the target is expected to
// just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/optical-power"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/state/optical-power"
func (n *Aps_ApsModule_Ports_CommonInPath) OpticalPower() *Aps_ApsModule_Ports_CommonIn_OpticalPowerPath {
	return &Aps_ApsModule_Ports_CommonIn_OpticalPowerPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "optical-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// OpticalPower (container): The optical input power of this port in units of
// 0.01dBm. Optical input power represents the signal
// traversing from an external destination into the module.
// The power is measured before any attenuation. If avg/min/max
// statistics are not supported, the target is expected to
// just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/optical-power"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/state/optical-power"
func (n *Aps_ApsModule_Ports_CommonInPathAny) OpticalPower() *Aps_ApsModule_Ports_CommonIn_OpticalPowerPathAny {
	return &Aps_ApsModule_Ports_CommonIn_OpticalPowerPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "optical-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// TargetAttenuation (leaf): Target attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB.
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/target-attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/config/target-attenuation"
func (n *Aps_ApsModule_Ports_CommonInPath) TargetAttenuation() *Aps_ApsModule_Ports_CommonIn_TargetAttenuationPath {
	return &Aps_ApsModule_Ports_CommonIn_TargetAttenuationPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "target-attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// TargetAttenuation (leaf): Target attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB.
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/target-attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/config/target-attenuation"
func (n *Aps_ApsModule_Ports_CommonInPathAny) TargetAttenuation() *Aps_ApsModule_Ports_CommonIn_TargetAttenuationPathAny {
	return &Aps_ApsModule_Ports_CommonIn_TargetAttenuationPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "target-attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// Aps_ApsModule_Ports_CommonIn_OpticalPowerPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/optical-power YANG schema element.
type Aps_ApsModule_Ports_CommonIn_OpticalPowerPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_OpticalPowerPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/optical-power YANG schema element.
type Aps_ApsModule_Ports_CommonIn_OpticalPowerPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_OpticalPower_AvgPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/optical-power/avg YANG schema element.
type Aps_ApsModule_Ports_CommonIn_OpticalPower_AvgPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_OpticalPower_AvgPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/optical-power/avg YANG schema element.
type Aps_ApsModule_Ports_CommonIn_OpticalPower_AvgPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_OpticalPower_InstantPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/optical-power/instant YANG schema element.
type Aps_ApsModule_Ports_CommonIn_OpticalPower_InstantPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_OpticalPower_InstantPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/optical-power/instant YANG schema element.
type Aps_ApsModule_Ports_CommonIn_OpticalPower_InstantPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_OpticalPower_IntervalPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/optical-power/interval YANG schema element.
type Aps_ApsModule_Ports_CommonIn_OpticalPower_IntervalPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_OpticalPower_IntervalPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/optical-power/interval YANG schema element.
type Aps_ApsModule_Ports_CommonIn_OpticalPower_IntervalPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_OpticalPower_MaxPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/optical-power/max YANG schema element.
type Aps_ApsModule_Ports_CommonIn_OpticalPower_MaxPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_OpticalPower_MaxPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/optical-power/max YANG schema element.
type Aps_ApsModule_Ports_CommonIn_OpticalPower_MaxPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_OpticalPower_MaxTimePath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/optical-power/max-time YANG schema element.
type Aps_ApsModule_Ports_CommonIn_OpticalPower_MaxTimePath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_OpticalPower_MaxTimePathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/optical-power/max-time YANG schema element.
type Aps_ApsModule_Ports_CommonIn_OpticalPower_MaxTimePathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_OpticalPower_MinPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/optical-power/min YANG schema element.
type Aps_ApsModule_Ports_CommonIn_OpticalPower_MinPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_OpticalPower_MinPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/optical-power/min YANG schema element.
type Aps_ApsModule_Ports_CommonIn_OpticalPower_MinPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_OpticalPower_MinTimePath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/optical-power/min-time YANG schema element.
type Aps_ApsModule_Ports_CommonIn_OpticalPower_MinTimePath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonIn_OpticalPower_MinTimePathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-in/state/optical-power/min-time YANG schema element.
type Aps_ApsModule_Ports_CommonIn_OpticalPower_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "avg"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/state/optical-power/avg"
func (n *Aps_ApsModule_Ports_CommonIn_OpticalPowerPath) Avg() *Aps_ApsModule_Ports_CommonIn_OpticalPower_AvgPath {
	return &Aps_ApsModule_Ports_CommonIn_OpticalPower_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "avg"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/state/optical-power/avg"
func (n *Aps_ApsModule_Ports_CommonIn_OpticalPowerPathAny) Avg() *Aps_ApsModule_Ports_CommonIn_OpticalPower_AvgPathAny {
	return &Aps_ApsModule_Ports_CommonIn_OpticalPower_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "instant"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/state/optical-power/instant"
func (n *Aps_ApsModule_Ports_CommonIn_OpticalPowerPath) Instant() *Aps_ApsModule_Ports_CommonIn_OpticalPower_InstantPath {
	return &Aps_ApsModule_Ports_CommonIn_OpticalPower_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "instant"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/state/optical-power/instant"
func (n *Aps_ApsModule_Ports_CommonIn_OpticalPowerPathAny) Instant() *Aps_ApsModule_Ports_CommonIn_OpticalPower_InstantPathAny {
	return &Aps_ApsModule_Ports_CommonIn_OpticalPower_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "interval"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/state/optical-power/interval"
func (n *Aps_ApsModule_Ports_CommonIn_OpticalPowerPath) Interval() *Aps_ApsModule_Ports_CommonIn_OpticalPower_IntervalPath {
	return &Aps_ApsModule_Ports_CommonIn_OpticalPower_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "interval"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/state/optical-power/interval"
func (n *Aps_ApsModule_Ports_CommonIn_OpticalPowerPathAny) Interval() *Aps_ApsModule_Ports_CommonIn_OpticalPower_IntervalPathAny {
	return &Aps_ApsModule_Ports_CommonIn_OpticalPower_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/state/optical-power/max"
func (n *Aps_ApsModule_Ports_CommonIn_OpticalPowerPath) Max() *Aps_ApsModule_Ports_CommonIn_OpticalPower_MaxPath {
	return &Aps_ApsModule_Ports_CommonIn_OpticalPower_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/state/optical-power/max"
func (n *Aps_ApsModule_Ports_CommonIn_OpticalPowerPathAny) Max() *Aps_ApsModule_Ports_CommonIn_OpticalPower_MaxPathAny {
	return &Aps_ApsModule_Ports_CommonIn_OpticalPower_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max-time"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/state/optical-power/max-time"
func (n *Aps_ApsModule_Ports_CommonIn_OpticalPowerPath) MaxTime() *Aps_ApsModule_Ports_CommonIn_OpticalPower_MaxTimePath {
	return &Aps_ApsModule_Ports_CommonIn_OpticalPower_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max-time"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/state/optical-power/max-time"
func (n *Aps_ApsModule_Ports_CommonIn_OpticalPowerPathAny) MaxTime() *Aps_ApsModule_Ports_CommonIn_OpticalPower_MaxTimePathAny {
	return &Aps_ApsModule_Ports_CommonIn_OpticalPower_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/state/optical-power/min"
func (n *Aps_ApsModule_Ports_CommonIn_OpticalPowerPath) Min() *Aps_ApsModule_Ports_CommonIn_OpticalPower_MinPath {
	return &Aps_ApsModule_Ports_CommonIn_OpticalPower_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/state/optical-power/min"
func (n *Aps_ApsModule_Ports_CommonIn_OpticalPowerPathAny) Min() *Aps_ApsModule_Ports_CommonIn_OpticalPower_MinPathAny {
	return &Aps_ApsModule_Ports_CommonIn_OpticalPower_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min-time"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/state/optical-power/min-time"
func (n *Aps_ApsModule_Ports_CommonIn_OpticalPowerPath) MinTime() *Aps_ApsModule_Ports_CommonIn_OpticalPower_MinTimePath {
	return &Aps_ApsModule_Ports_CommonIn_OpticalPower_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min-time"
// Path from root: "/aps/aps-modules/aps-module/ports/common-in/state/optical-power/min-time"
func (n *Aps_ApsModule_Ports_CommonIn_OpticalPowerPathAny) MinTime() *Aps_ApsModule_Ports_CommonIn_OpticalPower_MinTimePathAny {
	return &Aps_ApsModule_Ports_CommonIn_OpticalPower_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Aps_ApsModule_Ports_CommonOutputPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output YANG schema element.
type Aps_ApsModule_Ports_CommonOutputPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutputPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output YANG schema element.
type Aps_ApsModule_Ports_CommonOutputPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_AttenuationPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/attenuation YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_AttenuationPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_AttenuationPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/attenuation YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_AttenuationPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_TargetAttenuationPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/config/target-attenuation YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_TargetAttenuationPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_TargetAttenuationPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/config/target-attenuation YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_TargetAttenuationPathAny struct {
	*ygot.NodePath
}

// Attenuation (leaf): The attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/state/attenuation"
func (n *Aps_ApsModule_Ports_CommonOutputPath) Attenuation() *Aps_ApsModule_Ports_CommonOutput_AttenuationPath {
	return &Aps_ApsModule_Ports_CommonOutput_AttenuationPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// Attenuation (leaf): The attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/state/attenuation"
func (n *Aps_ApsModule_Ports_CommonOutputPathAny) Attenuation() *Aps_ApsModule_Ports_CommonOutput_AttenuationPathAny {
	return &Aps_ApsModule_Ports_CommonOutput_AttenuationPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// OpticalPower (container): The optical output power of this port in units of
// 0.01dBm. Optical output power represents the signal
// traversing from the module to an external destination. The
// power is measured after any attenuation. If avg/min/max
// statistics are not supported, the target is expected to
// just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/optical-power"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/state/optical-power"
func (n *Aps_ApsModule_Ports_CommonOutputPath) OpticalPower() *Aps_ApsModule_Ports_CommonOutput_OpticalPowerPath {
	return &Aps_ApsModule_Ports_CommonOutput_OpticalPowerPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "optical-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// OpticalPower (container): The optical output power of this port in units of
// 0.01dBm. Optical output power represents the signal
// traversing from the module to an external destination. The
// power is measured after any attenuation. If avg/min/max
// statistics are not supported, the target is expected to
// just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/optical-power"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/state/optical-power"
func (n *Aps_ApsModule_Ports_CommonOutputPathAny) OpticalPower() *Aps_ApsModule_Ports_CommonOutput_OpticalPowerPathAny {
	return &Aps_ApsModule_Ports_CommonOutput_OpticalPowerPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "optical-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// TargetAttenuation (leaf): Target attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/target-attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/config/target-attenuation"
func (n *Aps_ApsModule_Ports_CommonOutputPath) TargetAttenuation() *Aps_ApsModule_Ports_CommonOutput_TargetAttenuationPath {
	return &Aps_ApsModule_Ports_CommonOutput_TargetAttenuationPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "target-attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// TargetAttenuation (leaf): Target attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/target-attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/config/target-attenuation"
func (n *Aps_ApsModule_Ports_CommonOutputPathAny) TargetAttenuation() *Aps_ApsModule_Ports_CommonOutput_TargetAttenuationPathAny {
	return &Aps_ApsModule_Ports_CommonOutput_TargetAttenuationPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "target-attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// Aps_ApsModule_Ports_CommonOutput_OpticalPowerPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/optical-power YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_OpticalPowerPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_OpticalPowerPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/optical-power YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_OpticalPowerPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_OpticalPower_AvgPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/optical-power/avg YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_OpticalPower_AvgPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_OpticalPower_AvgPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/optical-power/avg YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_OpticalPower_AvgPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_OpticalPower_InstantPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/optical-power/instant YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_OpticalPower_InstantPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_OpticalPower_InstantPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/optical-power/instant YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_OpticalPower_InstantPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_OpticalPower_IntervalPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/optical-power/interval YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_OpticalPower_IntervalPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_OpticalPower_IntervalPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/optical-power/interval YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_OpticalPower_IntervalPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_OpticalPower_MaxPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/optical-power/max YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_OpticalPower_MaxPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_OpticalPower_MaxPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/optical-power/max YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_OpticalPower_MaxPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_OpticalPower_MaxTimePath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/optical-power/max-time YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_OpticalPower_MaxTimePath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_OpticalPower_MaxTimePathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/optical-power/max-time YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_OpticalPower_MaxTimePathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_OpticalPower_MinPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/optical-power/min YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_OpticalPower_MinPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_OpticalPower_MinPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/optical-power/min YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_OpticalPower_MinPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_OpticalPower_MinTimePath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/optical-power/min-time YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_OpticalPower_MinTimePath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_CommonOutput_OpticalPower_MinTimePathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/common-output/state/optical-power/min-time YANG schema element.
type Aps_ApsModule_Ports_CommonOutput_OpticalPower_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "avg"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/state/optical-power/avg"
func (n *Aps_ApsModule_Ports_CommonOutput_OpticalPowerPath) Avg() *Aps_ApsModule_Ports_CommonOutput_OpticalPower_AvgPath {
	return &Aps_ApsModule_Ports_CommonOutput_OpticalPower_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "avg"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/state/optical-power/avg"
func (n *Aps_ApsModule_Ports_CommonOutput_OpticalPowerPathAny) Avg() *Aps_ApsModule_Ports_CommonOutput_OpticalPower_AvgPathAny {
	return &Aps_ApsModule_Ports_CommonOutput_OpticalPower_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "instant"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/state/optical-power/instant"
func (n *Aps_ApsModule_Ports_CommonOutput_OpticalPowerPath) Instant() *Aps_ApsModule_Ports_CommonOutput_OpticalPower_InstantPath {
	return &Aps_ApsModule_Ports_CommonOutput_OpticalPower_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "instant"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/state/optical-power/instant"
func (n *Aps_ApsModule_Ports_CommonOutput_OpticalPowerPathAny) Instant() *Aps_ApsModule_Ports_CommonOutput_OpticalPower_InstantPathAny {
	return &Aps_ApsModule_Ports_CommonOutput_OpticalPower_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "interval"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/state/optical-power/interval"
func (n *Aps_ApsModule_Ports_CommonOutput_OpticalPowerPath) Interval() *Aps_ApsModule_Ports_CommonOutput_OpticalPower_IntervalPath {
	return &Aps_ApsModule_Ports_CommonOutput_OpticalPower_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "interval"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/state/optical-power/interval"
func (n *Aps_ApsModule_Ports_CommonOutput_OpticalPowerPathAny) Interval() *Aps_ApsModule_Ports_CommonOutput_OpticalPower_IntervalPathAny {
	return &Aps_ApsModule_Ports_CommonOutput_OpticalPower_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/state/optical-power/max"
func (n *Aps_ApsModule_Ports_CommonOutput_OpticalPowerPath) Max() *Aps_ApsModule_Ports_CommonOutput_OpticalPower_MaxPath {
	return &Aps_ApsModule_Ports_CommonOutput_OpticalPower_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/state/optical-power/max"
func (n *Aps_ApsModule_Ports_CommonOutput_OpticalPowerPathAny) Max() *Aps_ApsModule_Ports_CommonOutput_OpticalPower_MaxPathAny {
	return &Aps_ApsModule_Ports_CommonOutput_OpticalPower_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max-time"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/state/optical-power/max-time"
func (n *Aps_ApsModule_Ports_CommonOutput_OpticalPowerPath) MaxTime() *Aps_ApsModule_Ports_CommonOutput_OpticalPower_MaxTimePath {
	return &Aps_ApsModule_Ports_CommonOutput_OpticalPower_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max-time"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/state/optical-power/max-time"
func (n *Aps_ApsModule_Ports_CommonOutput_OpticalPowerPathAny) MaxTime() *Aps_ApsModule_Ports_CommonOutput_OpticalPower_MaxTimePathAny {
	return &Aps_ApsModule_Ports_CommonOutput_OpticalPower_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/state/optical-power/min"
func (n *Aps_ApsModule_Ports_CommonOutput_OpticalPowerPath) Min() *Aps_ApsModule_Ports_CommonOutput_OpticalPower_MinPath {
	return &Aps_ApsModule_Ports_CommonOutput_OpticalPower_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/state/optical-power/min"
func (n *Aps_ApsModule_Ports_CommonOutput_OpticalPowerPathAny) Min() *Aps_ApsModule_Ports_CommonOutput_OpticalPower_MinPathAny {
	return &Aps_ApsModule_Ports_CommonOutput_OpticalPower_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min-time"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/state/optical-power/min-time"
func (n *Aps_ApsModule_Ports_CommonOutput_OpticalPowerPath) MinTime() *Aps_ApsModule_Ports_CommonOutput_OpticalPower_MinTimePath {
	return &Aps_ApsModule_Ports_CommonOutput_OpticalPower_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min-time"
// Path from root: "/aps/aps-modules/aps-module/ports/common-output/state/optical-power/min-time"
func (n *Aps_ApsModule_Ports_CommonOutput_OpticalPowerPathAny) MinTime() *Aps_ApsModule_Ports_CommonOutput_OpticalPower_MinTimePathAny {
	return &Aps_ApsModule_Ports_CommonOutput_OpticalPower_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Aps_ApsModule_Ports_LinePrimaryInPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryInPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryInPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryInPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_AttenuationPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/attenuation YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_AttenuationPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_AttenuationPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/attenuation YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_AttenuationPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_EnabledPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/config/enabled YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_EnabledPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_EnabledPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/config/enabled YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_EnabledPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_TargetAttenuationPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/config/target-attenuation YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_TargetAttenuationPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_TargetAttenuationPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/config/target-attenuation YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_TargetAttenuationPathAny struct {
	*ygot.NodePath
}

// Attenuation (leaf): The attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB.
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/state/attenuation"
func (n *Aps_ApsModule_Ports_LinePrimaryInPath) Attenuation() *Aps_ApsModule_Ports_LinePrimaryIn_AttenuationPath {
	return &Aps_ApsModule_Ports_LinePrimaryIn_AttenuationPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// Attenuation (leaf): The attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB.
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/state/attenuation"
func (n *Aps_ApsModule_Ports_LinePrimaryInPathAny) Attenuation() *Aps_ApsModule_Ports_LinePrimaryIn_AttenuationPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryIn_AttenuationPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// Enabled (leaf): This leaf contains the configured, desired state of the
// port. Disabling the port turns off alarm reporting for
// the port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/enabled"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/config/enabled"
func (n *Aps_ApsModule_Ports_LinePrimaryInPath) Enabled() *Aps_ApsModule_Ports_LinePrimaryIn_EnabledPath {
	return &Aps_ApsModule_Ports_LinePrimaryIn_EnabledPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "enabled"},
			map[string]interface{}{},
			n,
		),
	}
}

// Enabled (leaf): This leaf contains the configured, desired state of the
// port. Disabling the port turns off alarm reporting for
// the port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/enabled"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/config/enabled"
func (n *Aps_ApsModule_Ports_LinePrimaryInPathAny) Enabled() *Aps_ApsModule_Ports_LinePrimaryIn_EnabledPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryIn_EnabledPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "enabled"},
			map[string]interface{}{},
			n,
		),
	}
}

// OpticalPower (container): The optical input power of this port in units of
// 0.01dBm. Optical input power represents the signal
// traversing from an external destination into the module.
// The power is measured before any attenuation. If avg/min/max
// statistics are not supported, the target is expected to
// just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/optical-power"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power"
func (n *Aps_ApsModule_Ports_LinePrimaryInPath) OpticalPower() *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPath {
	return &Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "optical-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// OpticalPower (container): The optical input power of this port in units of
// 0.01dBm. Optical input power represents the signal
// traversing from an external destination into the module.
// The power is measured before any attenuation. If avg/min/max
// statistics are not supported, the target is expected to
// just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/optical-power"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power"
func (n *Aps_ApsModule_Ports_LinePrimaryInPathAny) OpticalPower() *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "optical-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// TargetAttenuation (leaf): Target attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB.
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/target-attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/config/target-attenuation"
func (n *Aps_ApsModule_Ports_LinePrimaryInPath) TargetAttenuation() *Aps_ApsModule_Ports_LinePrimaryIn_TargetAttenuationPath {
	return &Aps_ApsModule_Ports_LinePrimaryIn_TargetAttenuationPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "target-attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// TargetAttenuation (leaf): Target attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB.
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/target-attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/config/target-attenuation"
func (n *Aps_ApsModule_Ports_LinePrimaryInPathAny) TargetAttenuation() *Aps_ApsModule_Ports_LinePrimaryIn_TargetAttenuationPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryIn_TargetAttenuationPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "target-attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_AvgPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/avg YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_AvgPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_AvgPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/avg YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_AvgPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_InstantPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/instant YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_InstantPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_InstantPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/instant YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_InstantPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_IntervalPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/interval YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_IntervalPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_IntervalPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/interval YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_IntervalPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MaxPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/max YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MaxPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MaxPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/max YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MaxPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MaxTimePath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/max-time YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MaxTimePath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MaxTimePathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/max-time YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MaxTimePathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MinPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/min YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MinPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MinPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/min YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MinPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MinTimePath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/min-time YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MinTimePath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MinTimePathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/min-time YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "avg"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/avg"
func (n *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPath) Avg() *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_AvgPath {
	return &Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "avg"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/avg"
func (n *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPathAny) Avg() *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_AvgPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "instant"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/instant"
func (n *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPath) Instant() *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_InstantPath {
	return &Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "instant"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/instant"
func (n *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPathAny) Instant() *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_InstantPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "interval"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/interval"
func (n *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPath) Interval() *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_IntervalPath {
	return &Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "interval"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/interval"
func (n *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPathAny) Interval() *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_IntervalPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/max"
func (n *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPath) Max() *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MaxPath {
	return &Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/max"
func (n *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPathAny) Max() *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MaxPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max-time"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/max-time"
func (n *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPath) MaxTime() *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MaxTimePath {
	return &Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max-time"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/max-time"
func (n *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPathAny) MaxTime() *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MaxTimePathAny {
	return &Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/min"
func (n *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPath) Min() *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MinPath {
	return &Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/min"
func (n *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPathAny) Min() *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MinPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min-time"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/min-time"
func (n *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPath) MinTime() *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MinTimePath {
	return &Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min-time"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-in/state/optical-power/min-time"
func (n *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPowerPathAny) MinTime() *Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MinTimePathAny {
	return &Aps_ApsModule_Ports_LinePrimaryIn_OpticalPower_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Aps_ApsModule_Ports_LinePrimaryOutPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOutPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOutPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOutPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_AttenuationPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/attenuation YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_AttenuationPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_AttenuationPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/attenuation YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_AttenuationPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_TargetAttenuationPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/config/target-attenuation YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_TargetAttenuationPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_TargetAttenuationPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/config/target-attenuation YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_TargetAttenuationPathAny struct {
	*ygot.NodePath
}

// Attenuation (leaf): The attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/state/attenuation"
func (n *Aps_ApsModule_Ports_LinePrimaryOutPath) Attenuation() *Aps_ApsModule_Ports_LinePrimaryOut_AttenuationPath {
	return &Aps_ApsModule_Ports_LinePrimaryOut_AttenuationPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// Attenuation (leaf): The attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/state/attenuation"
func (n *Aps_ApsModule_Ports_LinePrimaryOutPathAny) Attenuation() *Aps_ApsModule_Ports_LinePrimaryOut_AttenuationPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryOut_AttenuationPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// OpticalPower (container): The optical output power of this port in units of
// 0.01dBm. Optical output power represents the signal
// traversing from the module to an external destination. The
// power is measured after any attenuation. If avg/min/max
// statistics are not supported, the target is expected to
// just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/optical-power"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power"
func (n *Aps_ApsModule_Ports_LinePrimaryOutPath) OpticalPower() *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPath {
	return &Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "optical-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// OpticalPower (container): The optical output power of this port in units of
// 0.01dBm. Optical output power represents the signal
// traversing from the module to an external destination. The
// power is measured after any attenuation. If avg/min/max
// statistics are not supported, the target is expected to
// just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/optical-power"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power"
func (n *Aps_ApsModule_Ports_LinePrimaryOutPathAny) OpticalPower() *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "optical-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// TargetAttenuation (leaf): Target attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/target-attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/config/target-attenuation"
func (n *Aps_ApsModule_Ports_LinePrimaryOutPath) TargetAttenuation() *Aps_ApsModule_Ports_LinePrimaryOut_TargetAttenuationPath {
	return &Aps_ApsModule_Ports_LinePrimaryOut_TargetAttenuationPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "target-attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// TargetAttenuation (leaf): Target attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/target-attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/config/target-attenuation"
func (n *Aps_ApsModule_Ports_LinePrimaryOutPathAny) TargetAttenuation() *Aps_ApsModule_Ports_LinePrimaryOut_TargetAttenuationPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryOut_TargetAttenuationPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "target-attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_AvgPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/avg YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_AvgPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_AvgPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/avg YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_AvgPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_InstantPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/instant YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_InstantPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_InstantPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/instant YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_InstantPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_IntervalPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/interval YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_IntervalPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_IntervalPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/interval YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_IntervalPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MaxPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/max YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MaxPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MaxPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/max YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MaxPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MaxTimePath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/max-time YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MaxTimePath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MaxTimePathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/max-time YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MaxTimePathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MinPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/min YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MinPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MinPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/min YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MinPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MinTimePath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/min-time YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MinTimePath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MinTimePathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/min-time YANG schema element.
type Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "avg"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/avg"
func (n *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPath) Avg() *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_AvgPath {
	return &Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "avg"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/avg"
func (n *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPathAny) Avg() *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_AvgPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "instant"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/instant"
func (n *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPath) Instant() *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_InstantPath {
	return &Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "instant"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/instant"
func (n *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPathAny) Instant() *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_InstantPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "interval"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/interval"
func (n *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPath) Interval() *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_IntervalPath {
	return &Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "interval"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/interval"
func (n *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPathAny) Interval() *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_IntervalPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/max"
func (n *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPath) Max() *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MaxPath {
	return &Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/max"
func (n *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPathAny) Max() *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MaxPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max-time"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/max-time"
func (n *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPath) MaxTime() *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MaxTimePath {
	return &Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max-time"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/max-time"
func (n *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPathAny) MaxTime() *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MaxTimePathAny {
	return &Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/min"
func (n *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPath) Min() *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MinPath {
	return &Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/min"
func (n *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPathAny) Min() *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MinPathAny {
	return &Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min-time"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/min-time"
func (n *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPath) MinTime() *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MinTimePath {
	return &Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min-time"
// Path from root: "/aps/aps-modules/aps-module/ports/line-primary-out/state/optical-power/min-time"
func (n *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPowerPathAny) MinTime() *Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MinTimePathAny {
	return &Aps_ApsModule_Ports_LinePrimaryOut_OpticalPower_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Aps_ApsModule_Ports_LineSecondaryInPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryInPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryInPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryInPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_AttenuationPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/attenuation YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_AttenuationPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_AttenuationPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/attenuation YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_AttenuationPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_EnabledPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/config/enabled YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_EnabledPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_EnabledPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/config/enabled YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_EnabledPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_TargetAttenuationPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/config/target-attenuation YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_TargetAttenuationPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_TargetAttenuationPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/config/target-attenuation YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_TargetAttenuationPathAny struct {
	*ygot.NodePath
}

// Attenuation (leaf): The attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB.
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/state/attenuation"
func (n *Aps_ApsModule_Ports_LineSecondaryInPath) Attenuation() *Aps_ApsModule_Ports_LineSecondaryIn_AttenuationPath {
	return &Aps_ApsModule_Ports_LineSecondaryIn_AttenuationPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// Attenuation (leaf): The attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB.
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/state/attenuation"
func (n *Aps_ApsModule_Ports_LineSecondaryInPathAny) Attenuation() *Aps_ApsModule_Ports_LineSecondaryIn_AttenuationPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryIn_AttenuationPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// Enabled (leaf): This leaf contains the configured, desired state of the
// port. Disabling the port turns off alarm reporting for
// the port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/enabled"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/config/enabled"
func (n *Aps_ApsModule_Ports_LineSecondaryInPath) Enabled() *Aps_ApsModule_Ports_LineSecondaryIn_EnabledPath {
	return &Aps_ApsModule_Ports_LineSecondaryIn_EnabledPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "enabled"},
			map[string]interface{}{},
			n,
		),
	}
}

// Enabled (leaf): This leaf contains the configured, desired state of the
// port. Disabling the port turns off alarm reporting for
// the port
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/enabled"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/config/enabled"
func (n *Aps_ApsModule_Ports_LineSecondaryInPathAny) Enabled() *Aps_ApsModule_Ports_LineSecondaryIn_EnabledPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryIn_EnabledPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "enabled"},
			map[string]interface{}{},
			n,
		),
	}
}

// OpticalPower (container): The optical input power of this port in units of
// 0.01dBm. Optical input power represents the signal
// traversing from an external destination into the module.
// The power is measured before any attenuation. If avg/min/max
// statistics are not supported, the target is expected to
// just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/optical-power"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power"
func (n *Aps_ApsModule_Ports_LineSecondaryInPath) OpticalPower() *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPath {
	return &Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "optical-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// OpticalPower (container): The optical input power of this port in units of
// 0.01dBm. Optical input power represents the signal
// traversing from an external destination into the module.
// The power is measured before any attenuation. If avg/min/max
// statistics are not supported, the target is expected to
// just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/optical-power"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power"
func (n *Aps_ApsModule_Ports_LineSecondaryInPathAny) OpticalPower() *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "optical-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// TargetAttenuation (leaf): Target attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB.
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/target-attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/config/target-attenuation"
func (n *Aps_ApsModule_Ports_LineSecondaryInPath) TargetAttenuation() *Aps_ApsModule_Ports_LineSecondaryIn_TargetAttenuationPath {
	return &Aps_ApsModule_Ports_LineSecondaryIn_TargetAttenuationPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "target-attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// TargetAttenuation (leaf): Target attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB.
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/target-attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/config/target-attenuation"
func (n *Aps_ApsModule_Ports_LineSecondaryInPathAny) TargetAttenuation() *Aps_ApsModule_Ports_LineSecondaryIn_TargetAttenuationPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryIn_TargetAttenuationPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "target-attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_AvgPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/avg YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_AvgPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_AvgPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/avg YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_AvgPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_InstantPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/instant YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_InstantPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_InstantPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/instant YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_InstantPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_IntervalPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/interval YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_IntervalPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_IntervalPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/interval YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_IntervalPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MaxPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/max YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MaxPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MaxPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/max YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MaxPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MaxTimePath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/max-time YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MaxTimePath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MaxTimePathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/max-time YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MaxTimePathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MinPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/min YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MinPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MinPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/min YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MinPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MinTimePath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/min-time YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MinTimePath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MinTimePathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/min-time YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "avg"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/avg"
func (n *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPath) Avg() *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_AvgPath {
	return &Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "avg"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/avg"
func (n *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPathAny) Avg() *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_AvgPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "instant"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/instant"
func (n *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPath) Instant() *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_InstantPath {
	return &Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "instant"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/instant"
func (n *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPathAny) Instant() *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_InstantPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "interval"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/interval"
func (n *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPath) Interval() *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_IntervalPath {
	return &Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "interval"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/interval"
func (n *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPathAny) Interval() *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_IntervalPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/max"
func (n *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPath) Max() *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MaxPath {
	return &Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/max"
func (n *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPathAny) Max() *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MaxPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max-time"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/max-time"
func (n *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPath) MaxTime() *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MaxTimePath {
	return &Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max-time"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/max-time"
func (n *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPathAny) MaxTime() *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MaxTimePathAny {
	return &Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/min"
func (n *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPath) Min() *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MinPath {
	return &Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/min"
func (n *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPathAny) Min() *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MinPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min-time"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/min-time"
func (n *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPath) MinTime() *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MinTimePath {
	return &Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min-time"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-in/state/optical-power/min-time"
func (n *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPowerPathAny) MinTime() *Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MinTimePathAny {
	return &Aps_ApsModule_Ports_LineSecondaryIn_OpticalPower_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Aps_ApsModule_Ports_LineSecondaryOutPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOutPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOutPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOutPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_AttenuationPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/attenuation YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_AttenuationPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_AttenuationPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/attenuation YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_AttenuationPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_TargetAttenuationPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/config/target-attenuation YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_TargetAttenuationPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_TargetAttenuationPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/config/target-attenuation YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_TargetAttenuationPathAny struct {
	*ygot.NodePath
}

// Attenuation (leaf): The attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/state/attenuation"
func (n *Aps_ApsModule_Ports_LineSecondaryOutPath) Attenuation() *Aps_ApsModule_Ports_LineSecondaryOut_AttenuationPath {
	return &Aps_ApsModule_Ports_LineSecondaryOut_AttenuationPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// Attenuation (leaf): The attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/state/attenuation"
func (n *Aps_ApsModule_Ports_LineSecondaryOutPathAny) Attenuation() *Aps_ApsModule_Ports_LineSecondaryOut_AttenuationPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryOut_AttenuationPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// OpticalPower (container): The optical output power of this port in units of
// 0.01dBm. Optical output power represents the signal
// traversing from the module to an external destination. The
// power is measured after any attenuation. If avg/min/max
// statistics are not supported, the target is expected to
// just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/optical-power"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power"
func (n *Aps_ApsModule_Ports_LineSecondaryOutPath) OpticalPower() *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPath {
	return &Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "optical-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// OpticalPower (container): The optical output power of this port in units of
// 0.01dBm. Optical output power represents the signal
// traversing from the module to an external destination. The
// power is measured after any attenuation. If avg/min/max
// statistics are not supported, the target is expected to
// just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "state/optical-power"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power"
func (n *Aps_ApsModule_Ports_LineSecondaryOutPathAny) OpticalPower() *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "optical-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// TargetAttenuation (leaf): Target attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/target-attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/config/target-attenuation"
func (n *Aps_ApsModule_Ports_LineSecondaryOutPath) TargetAttenuation() *Aps_ApsModule_Ports_LineSecondaryOut_TargetAttenuationPath {
	return &Aps_ApsModule_Ports_LineSecondaryOut_TargetAttenuationPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "target-attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// TargetAttenuation (leaf): Target attenuation of the variable optical attenuator
// associated with the port in increments of 0.01 dB
// ----------------------------------------
// Defining module: "openconfig-transport-line-protection"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "config/target-attenuation"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/config/target-attenuation"
func (n *Aps_ApsModule_Ports_LineSecondaryOutPathAny) TargetAttenuation() *Aps_ApsModule_Ports_LineSecondaryOut_TargetAttenuationPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryOut_TargetAttenuationPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "target-attenuation"},
			map[string]interface{}{},
			n,
		),
	}
}

// Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_AvgPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/avg YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_AvgPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_AvgPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/avg YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_AvgPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_InstantPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/instant YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_InstantPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_InstantPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/instant YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_InstantPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_IntervalPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/interval YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_IntervalPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_IntervalPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/interval YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_IntervalPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MaxPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/max YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MaxPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MaxPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/max YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MaxPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MaxTimePath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/max-time YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MaxTimePath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MaxTimePathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/max-time YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MaxTimePathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MinPath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/min YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MinPath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MinPathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/min YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MinPathAny struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MinTimePath represents the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/min-time YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MinTimePath struct {
	*ygot.NodePath
}

// Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MinTimePathAny represents the wildcard version of the /openconfig-transport-line-protection/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/min-time YANG schema element.
type Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "avg"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/avg"
func (n *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPath) Avg() *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_AvgPath {
	return &Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "avg"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/avg"
func (n *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPathAny) Avg() *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_AvgPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "instant"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/instant"
func (n *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPath) Instant() *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_InstantPath {
	return &Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "instant"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/instant"
func (n *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPathAny) Instant() *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_InstantPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "interval"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/interval"
func (n *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPath) Interval() *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_IntervalPath {
	return &Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "interval"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/interval"
func (n *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPathAny) Interval() *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_IntervalPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/max"
func (n *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPath) Max() *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MaxPath {
	return &Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/max"
func (n *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPathAny) Max() *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MaxPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max-time"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/max-time"
func (n *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPath) MaxTime() *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MaxTimePath {
	return &Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "max-time"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/max-time"
func (n *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPathAny) MaxTime() *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MaxTimePathAny {
	return &Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/min"
func (n *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPath) Min() *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MinPath {
	return &Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/min"
func (n *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPathAny) Min() *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MinPathAny {
	return &Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min-time"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/min-time"
func (n *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPath) MinTime() *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MinTimePath {
	return &Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-transport-line-protection"
// Path from parent: "min-time"
// Path from root: "/aps/aps-modules/aps-module/ports/line-secondary-out/state/optical-power/min-time"
func (n *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPowerPathAny) MinTime() *Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MinTimePathAny {
	return &Aps_ApsModule_Ports_LineSecondaryOut_OpticalPower_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// BfdPath represents the /openconfig-bfd/bfd YANG schema element.
type BfdPath struct {
	*ygot.NodePath
}

// BfdPathAny represents the wildcard version of the /openconfig-bfd/bfd YANG schema element.
type BfdPathAny struct {
	*ygot.NodePath
}

// InterfaceAny (list): Per-interface configuration and state parameters for BFD.
// The interface referenced is based on the interface and
// subinterface leaves within the interface-ref container -
// which reference an entry in the /interfaces/interface list -
// and should not rely on the value of the list key.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "interfaces/interface"
// Path from root: "/bfd/interfaces/interface"
// Id (wildcarded): string
func (n *BfdPath) InterfaceAny() *Bfd_InterfacePathAny {
	return &Bfd_InterfacePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interfaces", "interface"},
			map[string]interface{}{"id": "*"},
			n,
		),
	}
}

// InterfaceAny (list): Per-interface configuration and state parameters for BFD.
// The interface referenced is based on the interface and
// subinterface leaves within the interface-ref container -
// which reference an entry in the /interfaces/interface list -
// and should not rely on the value of the list key.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "interfaces/interface"
// Path from root: "/bfd/interfaces/interface"
// Id (wildcarded): string
func (n *BfdPathAny) InterfaceAny() *Bfd_InterfacePathAny {
	return &Bfd_InterfacePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interfaces", "interface"},
			map[string]interface{}{"id": "*"},
			n,
		),
	}
}

// Interface (list): Per-interface configuration and state parameters for BFD.
// The interface referenced is based on the interface and
// subinterface leaves within the interface-ref container -
// which reference an entry in the /interfaces/interface list -
// and should not rely on the value of the list key.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "interfaces/interface"
// Path from root: "/bfd/interfaces/interface"
// Id: string
func (n *BfdPath) Interface(Id string) *Bfd_InterfacePath {
	return &Bfd_InterfacePath{
		NodePath: ygot.NewNodePath(
			[]string{"interfaces", "interface"},
			map[string]interface{}{"id": Id},
			n,
		),
	}
}

// Interface (list): Per-interface configuration and state parameters for BFD.
// The interface referenced is based on the interface and
// subinterface leaves within the interface-ref container -
// which reference an entry in the /interfaces/interface list -
// and should not rely on the value of the list key.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "interfaces/interface"
// Path from root: "/bfd/interfaces/interface"
// Id: string
func (n *BfdPathAny) Interface(Id string) *Bfd_InterfacePathAny {
	return &Bfd_InterfacePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interfaces", "interface"},
			map[string]interface{}{"id": Id},
			n,
		),
	}
}

// Bfd_InterfacePath represents the /openconfig-bfd/bfd/interfaces/interface YANG schema element.
type Bfd_InterfacePath struct {
	*ygot.NodePath
}

// Bfd_InterfacePathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface YANG schema element.
type Bfd_InterfacePathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_DesiredMinimumTxIntervalPath represents the /openconfig-bfd/bfd/interfaces/interface/config/desired-minimum-tx-interval YANG schema element.
type Bfd_Interface_DesiredMinimumTxIntervalPath struct {
	*ygot.NodePath
}

// Bfd_Interface_DesiredMinimumTxIntervalPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/config/desired-minimum-tx-interval YANG schema element.
type Bfd_Interface_DesiredMinimumTxIntervalPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_DetectionMultiplierPath represents the /openconfig-bfd/bfd/interfaces/interface/config/detection-multiplier YANG schema element.
type Bfd_Interface_DetectionMultiplierPath struct {
	*ygot.NodePath
}

// Bfd_Interface_DetectionMultiplierPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/config/detection-multiplier YANG schema element.
type Bfd_Interface_DetectionMultiplierPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_EnablePerMemberLinkPath represents the /openconfig-bfd/bfd/interfaces/interface/config/enable-per-member-link YANG schema element.
type Bfd_Interface_EnablePerMemberLinkPath struct {
	*ygot.NodePath
}

// Bfd_Interface_EnablePerMemberLinkPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/config/enable-per-member-link YANG schema element.
type Bfd_Interface_EnablePerMemberLinkPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_EnabledPath represents the /openconfig-bfd/bfd/interfaces/interface/config/enabled YANG schema element.
type Bfd_Interface_EnabledPath struct {
	*ygot.NodePath
}

// Bfd_Interface_EnabledPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/config/enabled YANG schema element.
type Bfd_Interface_EnabledPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_IdPath represents the /openconfig-bfd/bfd/interfaces/interface/config/id YANG schema element.
type Bfd_Interface_IdPath struct {
	*ygot.NodePath
}

// Bfd_Interface_IdPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/config/id YANG schema element.
type Bfd_Interface_IdPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_LocalAddressPath represents the /openconfig-bfd/bfd/interfaces/interface/config/local-address YANG schema element.
type Bfd_Interface_LocalAddressPath struct {
	*ygot.NodePath
}

// Bfd_Interface_LocalAddressPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/config/local-address YANG schema element.
type Bfd_Interface_LocalAddressPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_RequiredMinimumReceivePath represents the /openconfig-bfd/bfd/interfaces/interface/config/required-minimum-receive YANG schema element.
type Bfd_Interface_RequiredMinimumReceivePath struct {
	*ygot.NodePath
}

// Bfd_Interface_RequiredMinimumReceivePathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/config/required-minimum-receive YANG schema element.
type Bfd_Interface_RequiredMinimumReceivePathAny struct {
	*ygot.NodePath
}

// DesiredMinimumTxInterval (leaf): The minimum interval between transmission of BFD control
// packets that the operator desires. This value is advertised to
// the peer, however the actual interval used is specified by
// taking the maximum of desired-minimum-tx-interval and the
// value of the remote required-minimum-receive interval value.
//
// This value is specified as an integer number of microseconds.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/desired-minimum-tx-interval"
// Path from root: "/bfd/interfaces/interface/config/desired-minimum-tx-interval"
func (n *Bfd_InterfacePath) DesiredMinimumTxInterval() *Bfd_Interface_DesiredMinimumTxIntervalPath {
	return &Bfd_Interface_DesiredMinimumTxIntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "desired-minimum-tx-interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// DesiredMinimumTxInterval (leaf): The minimum interval between transmission of BFD control
// packets that the operator desires. This value is advertised to
// the peer, however the actual interval used is specified by
// taking the maximum of desired-minimum-tx-interval and the
// value of the remote required-minimum-receive interval value.
//
// This value is specified as an integer number of microseconds.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/desired-minimum-tx-interval"
// Path from root: "/bfd/interfaces/interface/config/desired-minimum-tx-interval"
func (n *Bfd_InterfacePathAny) DesiredMinimumTxInterval() *Bfd_Interface_DesiredMinimumTxIntervalPathAny {
	return &Bfd_Interface_DesiredMinimumTxIntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "desired-minimum-tx-interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// DetectionMultiplier (leaf): The number of packets that must be missed to declare this
// session as down. The detection interval for the BFD session
// is calculated by multiplying the value of the negotiated
// transmission interval by this value.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/detection-multiplier"
// Path from root: "/bfd/interfaces/interface/config/detection-multiplier"
func (n *Bfd_InterfacePath) DetectionMultiplier() *Bfd_Interface_DetectionMultiplierPath {
	return &Bfd_Interface_DetectionMultiplierPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "detection-multiplier"},
			map[string]interface{}{},
			n,
		),
	}
}

// DetectionMultiplier (leaf): The number of packets that must be missed to declare this
// session as down. The detection interval for the BFD session
// is calculated by multiplying the value of the negotiated
// transmission interval by this value.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/detection-multiplier"
// Path from root: "/bfd/interfaces/interface/config/detection-multiplier"
func (n *Bfd_InterfacePathAny) DetectionMultiplier() *Bfd_Interface_DetectionMultiplierPathAny {
	return &Bfd_Interface_DetectionMultiplierPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "detection-multiplier"},
			map[string]interface{}{},
			n,
		),
	}
}

// EnablePerMemberLink (leaf): When this leaf is set to true - BFD will be enabled on
// each member interface of the aggregated Ethernet bundle.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/enable-per-member-link"
// Path from root: "/bfd/interfaces/interface/config/enable-per-member-link"
func (n *Bfd_InterfacePath) EnablePerMemberLink() *Bfd_Interface_EnablePerMemberLinkPath {
	return &Bfd_Interface_EnablePerMemberLinkPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "enable-per-member-link"},
			map[string]interface{}{},
			n,
		),
	}
}

// EnablePerMemberLink (leaf): When this leaf is set to true - BFD will be enabled on
// each member interface of the aggregated Ethernet bundle.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/enable-per-member-link"
// Path from root: "/bfd/interfaces/interface/config/enable-per-member-link"
func (n *Bfd_InterfacePathAny) EnablePerMemberLink() *Bfd_Interface_EnablePerMemberLinkPathAny {
	return &Bfd_Interface_EnablePerMemberLinkPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "enable-per-member-link"},
			map[string]interface{}{},
			n,
		),
	}
}

// Enabled (leaf): When this leaf is set to true then the BFD session is enabled
// on the specified interface - if it is set to false, it is
// administratively disabled.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/enabled"
// Path from root: "/bfd/interfaces/interface/config/enabled"
func (n *Bfd_InterfacePath) Enabled() *Bfd_Interface_EnabledPath {
	return &Bfd_Interface_EnabledPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "enabled"},
			map[string]interface{}{},
			n,
		),
	}
}

// Enabled (leaf): When this leaf is set to true then the BFD session is enabled
// on the specified interface - if it is set to false, it is
// administratively disabled.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/enabled"
// Path from root: "/bfd/interfaces/interface/config/enabled"
func (n *Bfd_InterfacePathAny) Enabled() *Bfd_Interface_EnabledPathAny {
	return &Bfd_Interface_EnabledPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "enabled"},
			map[string]interface{}{},
			n,
		),
	}
}

// Id (leaf): A unique identifier for the interface.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/id"
// Path from root: "/bfd/interfaces/interface/config/id"
func (n *Bfd_InterfacePath) Id() *Bfd_Interface_IdPath {
	return &Bfd_Interface_IdPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "id"},
			map[string]interface{}{},
			n,
		),
	}
}

// Id (leaf): A unique identifier for the interface.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/id"
// Path from root: "/bfd/interfaces/interface/config/id"
func (n *Bfd_InterfacePathAny) Id() *Bfd_Interface_IdPathAny {
	return &Bfd_Interface_IdPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "id"},
			map[string]interface{}{},
			n,
		),
	}
}

// InterfaceRef (container): Reference to an interface or subinterface. The interface
// that is being referenced is uniquely referenced based on
// the specified interface and subinterface leaves. In contexts
// where a Layer 3 interface is to be referenced, both the
// interface and subinterface leaves must be populated, as
// Layer 3 configuration within the OpenConfig models is
// associated with a subinterface. In the case where a
// Layer 2 interface is to be referenced, only the
// interface is specified.
//
// The interface/subinterface leaf tuple must be used as
// the means by which the interface is specified, regardless
// of any other context information (e.g., key in a list).
// ----------------------------------------
// Defining module: "openconfig-interfaces"
// Instantiating module: "openconfig-bfd"
// Path from parent: "interface-ref"
// Path from root: "/bfd/interfaces/interface/interface-ref"
func (n *Bfd_InterfacePath) InterfaceRef() *Bfd_Interface_InterfaceRefPath {
	return &Bfd_Interface_InterfaceRefPath{
		NodePath: ygot.NewNodePath(
			[]string{"interface-ref"},
			map[string]interface{}{},
			n,
		),
	}
}

// InterfaceRef (container): Reference to an interface or subinterface. The interface
// that is being referenced is uniquely referenced based on
// the specified interface and subinterface leaves. In contexts
// where a Layer 3 interface is to be referenced, both the
// interface and subinterface leaves must be populated, as
// Layer 3 configuration within the OpenConfig models is
// associated with a subinterface. In the case where a
// Layer 2 interface is to be referenced, only the
// interface is specified.
//
// The interface/subinterface leaf tuple must be used as
// the means by which the interface is specified, regardless
// of any other context information (e.g., key in a list).
// ----------------------------------------
// Defining module: "openconfig-interfaces"
// Instantiating module: "openconfig-bfd"
// Path from parent: "interface-ref"
// Path from root: "/bfd/interfaces/interface/interface-ref"
func (n *Bfd_InterfacePathAny) InterfaceRef() *Bfd_Interface_InterfaceRefPathAny {
	return &Bfd_Interface_InterfaceRefPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interface-ref"},
			map[string]interface{}{},
			n,
		),
	}
}

// LocalAddress (leaf): The source IP address to be used for BFD sessions over this
// interface.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/local-address"
// Path from root: "/bfd/interfaces/interface/config/local-address"
func (n *Bfd_InterfacePath) LocalAddress() *Bfd_Interface_LocalAddressPath {
	return &Bfd_Interface_LocalAddressPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "local-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// LocalAddress (leaf): The source IP address to be used for BFD sessions over this
// interface.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/local-address"
// Path from root: "/bfd/interfaces/interface/config/local-address"
func (n *Bfd_InterfacePathAny) LocalAddress() *Bfd_Interface_LocalAddressPathAny {
	return &Bfd_Interface_LocalAddressPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "local-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// MicroBfdSessionAny (list): This list contains configuration and state parameters
// relating to micro-BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "micro-bfd-sessions/micro-bfd-session"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session"
// MemberInterface (wildcarded): string
func (n *Bfd_InterfacePath) MicroBfdSessionAny() *Bfd_Interface_MicroBfdSessionPathAny {
	return &Bfd_Interface_MicroBfdSessionPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"micro-bfd-sessions", "micro-bfd-session"},
			map[string]interface{}{"member-interface": "*"},
			n,
		),
	}
}

// MicroBfdSessionAny (list): This list contains configuration and state parameters
// relating to micro-BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "micro-bfd-sessions/micro-bfd-session"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session"
// MemberInterface (wildcarded): string
func (n *Bfd_InterfacePathAny) MicroBfdSessionAny() *Bfd_Interface_MicroBfdSessionPathAny {
	return &Bfd_Interface_MicroBfdSessionPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"micro-bfd-sessions", "micro-bfd-session"},
			map[string]interface{}{"member-interface": "*"},
			n,
		),
	}
}

// MicroBfdSession (list): This list contains configuration and state parameters
// relating to micro-BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "micro-bfd-sessions/micro-bfd-session"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session"
// MemberInterface: string
func (n *Bfd_InterfacePath) MicroBfdSession(MemberInterface string) *Bfd_Interface_MicroBfdSessionPath {
	return &Bfd_Interface_MicroBfdSessionPath{
		NodePath: ygot.NewNodePath(
			[]string{"micro-bfd-sessions", "micro-bfd-session"},
			map[string]interface{}{"member-interface": MemberInterface},
			n,
		),
	}
}

// MicroBfdSession (list): This list contains configuration and state parameters
// relating to micro-BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "micro-bfd-sessions/micro-bfd-session"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session"
// MemberInterface: string
func (n *Bfd_InterfacePathAny) MicroBfdSession(MemberInterface string) *Bfd_Interface_MicroBfdSessionPathAny {
	return &Bfd_Interface_MicroBfdSessionPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"micro-bfd-sessions", "micro-bfd-session"},
			map[string]interface{}{"member-interface": MemberInterface},
			n,
		),
	}
}

// PeerAny (list): Parameters relating to the BFD peer specified by the
// remote address.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "peers/peer"
// Path from root: "/bfd/interfaces/interface/peers/peer"
// LocalDiscriminator (wildcarded): string
func (n *Bfd_InterfacePath) PeerAny() *Bfd_Interface_PeerPathAny {
	return &Bfd_Interface_PeerPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"peers", "peer"},
			map[string]interface{}{"local-discriminator": "*"},
			n,
		),
	}
}

// PeerAny (list): Parameters relating to the BFD peer specified by the
// remote address.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "peers/peer"
// Path from root: "/bfd/interfaces/interface/peers/peer"
// LocalDiscriminator (wildcarded): string
func (n *Bfd_InterfacePathAny) PeerAny() *Bfd_Interface_PeerPathAny {
	return &Bfd_Interface_PeerPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"peers", "peer"},
			map[string]interface{}{"local-discriminator": "*"},
			n,
		),
	}
}

// Peer (list): Parameters relating to the BFD peer specified by the
// remote address.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "peers/peer"
// Path from root: "/bfd/interfaces/interface/peers/peer"
// LocalDiscriminator: string
func (n *Bfd_InterfacePath) Peer(LocalDiscriminator string) *Bfd_Interface_PeerPath {
	return &Bfd_Interface_PeerPath{
		NodePath: ygot.NewNodePath(
			[]string{"peers", "peer"},
			map[string]interface{}{"local-discriminator": LocalDiscriminator},
			n,
		),
	}
}

// Peer (list): Parameters relating to the BFD peer specified by the
// remote address.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "peers/peer"
// Path from root: "/bfd/interfaces/interface/peers/peer"
// LocalDiscriminator: string
func (n *Bfd_InterfacePathAny) Peer(LocalDiscriminator string) *Bfd_Interface_PeerPathAny {
	return &Bfd_Interface_PeerPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"peers", "peer"},
			map[string]interface{}{"local-discriminator": LocalDiscriminator},
			n,
		),
	}
}

// RequiredMinimumReceive (leaf): The minimum interval between received BFD control packets that
// this system should support. This value is advertised to the
// remote peer to indicate the maximum frequency (i.e., minimum
// inter-packet interval) between BFD control packets that is
// acceptable to the local system.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/required-minimum-receive"
// Path from root: "/bfd/interfaces/interface/config/required-minimum-receive"
func (n *Bfd_InterfacePath) RequiredMinimumReceive() *Bfd_Interface_RequiredMinimumReceivePath {
	return &Bfd_Interface_RequiredMinimumReceivePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "required-minimum-receive"},
			map[string]interface{}{},
			n,
		),
	}
}

// RequiredMinimumReceive (leaf): The minimum interval between received BFD control packets that
// this system should support. This value is advertised to the
// remote peer to indicate the maximum frequency (i.e., minimum
// inter-packet interval) between BFD control packets that is
// acceptable to the local system.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/required-minimum-receive"
// Path from root: "/bfd/interfaces/interface/config/required-minimum-receive"
func (n *Bfd_InterfacePathAny) RequiredMinimumReceive() *Bfd_Interface_RequiredMinimumReceivePathAny {
	return &Bfd_Interface_RequiredMinimumReceivePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "required-minimum-receive"},
			map[string]interface{}{},
			n,
		),
	}
}

// Bfd_Interface_InterfaceRefPath represents the /openconfig-bfd/bfd/interfaces/interface/interface-ref YANG schema element.
type Bfd_Interface_InterfaceRefPath struct {
	*ygot.NodePath
}

// Bfd_Interface_InterfaceRefPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/interface-ref YANG schema element.
type Bfd_Interface_InterfaceRefPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_InterfaceRef_InterfacePath represents the /openconfig-bfd/bfd/interfaces/interface/interface-ref/config/interface YANG schema element.
type Bfd_Interface_InterfaceRef_InterfacePath struct {
	*ygot.NodePath
}

// Bfd_Interface_InterfaceRef_InterfacePathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/interface-ref/config/interface YANG schema element.
type Bfd_Interface_InterfaceRef_InterfacePathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_InterfaceRef_SubinterfacePath represents the /openconfig-bfd/bfd/interfaces/interface/interface-ref/config/subinterface YANG schema element.
type Bfd_Interface_InterfaceRef_SubinterfacePath struct {
	*ygot.NodePath
}

// Bfd_Interface_InterfaceRef_SubinterfacePathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/interface-ref/config/subinterface YANG schema element.
type Bfd_Interface_InterfaceRef_SubinterfacePathAny struct {
	*ygot.NodePath
}

// Interface (leaf): Reference to a base interface.  If a reference to a
// subinterface is required, this leaf must be specified
// to indicate the base interface.
// ----------------------------------------
// Defining module: "openconfig-interfaces"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/interface"
// Path from root: "/bfd/interfaces/interface/interface-ref/config/interface"
func (n *Bfd_Interface_InterfaceRefPath) Interface() *Bfd_Interface_InterfaceRef_InterfacePath {
	return &Bfd_Interface_InterfaceRef_InterfacePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "interface"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interface (leaf): Reference to a base interface.  If a reference to a
// subinterface is required, this leaf must be specified
// to indicate the base interface.
// ----------------------------------------
// Defining module: "openconfig-interfaces"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/interface"
// Path from root: "/bfd/interfaces/interface/interface-ref/config/interface"
func (n *Bfd_Interface_InterfaceRefPathAny) Interface() *Bfd_Interface_InterfaceRef_InterfacePathAny {
	return &Bfd_Interface_InterfaceRef_InterfacePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "interface"},
			map[string]interface{}{},
			n,
		),
	}
}

// Subinterface (leaf): Reference to a subinterface -- this requires the base
// interface to be specified using the interface leaf in
// this container.  If only a reference to a base interface
// is requuired, this leaf should not be set.
// ----------------------------------------
// Defining module: "openconfig-interfaces"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/subinterface"
// Path from root: "/bfd/interfaces/interface/interface-ref/config/subinterface"
func (n *Bfd_Interface_InterfaceRefPath) Subinterface() *Bfd_Interface_InterfaceRef_SubinterfacePath {
	return &Bfd_Interface_InterfaceRef_SubinterfacePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "subinterface"},
			map[string]interface{}{},
			n,
		),
	}
}

// Subinterface (leaf): Reference to a subinterface -- this requires the base
// interface to be specified using the interface leaf in
// this container.  If only a reference to a base interface
// is requuired, this leaf should not be set.
// ----------------------------------------
// Defining module: "openconfig-interfaces"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/subinterface"
// Path from root: "/bfd/interfaces/interface/interface-ref/config/subinterface"
func (n *Bfd_Interface_InterfaceRefPathAny) Subinterface() *Bfd_Interface_InterfaceRef_SubinterfacePathAny {
	return &Bfd_Interface_InterfaceRef_SubinterfacePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "subinterface"},
			map[string]interface{}{},
			n,
		),
	}
}

// Bfd_Interface_MicroBfdSessionPath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session YANG schema element.
type Bfd_Interface_MicroBfdSessionPath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSessionPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session YANG schema element.
type Bfd_Interface_MicroBfdSessionPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_DemandModeRequestedPath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/demand-mode-requested YANG schema element.
type Bfd_Interface_MicroBfdSession_DemandModeRequestedPath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_DemandModeRequestedPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/demand-mode-requested YANG schema element.
type Bfd_Interface_MicroBfdSession_DemandModeRequestedPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_FailureTransitionsPath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/failure-transitions YANG schema element.
type Bfd_Interface_MicroBfdSession_FailureTransitionsPath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_FailureTransitionsPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/failure-transitions YANG schema element.
type Bfd_Interface_MicroBfdSession_FailureTransitionsPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_LastFailureTimePath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/last-failure-time YANG schema element.
type Bfd_Interface_MicroBfdSession_LastFailureTimePath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_LastFailureTimePathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/last-failure-time YANG schema element.
type Bfd_Interface_MicroBfdSession_LastFailureTimePathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_LocalAddressPath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/config/local-address YANG schema element.
type Bfd_Interface_MicroBfdSession_LocalAddressPath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_LocalAddressPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/config/local-address YANG schema element.
type Bfd_Interface_MicroBfdSession_LocalAddressPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_LocalDiagnosticCodePath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/local-diagnostic-code YANG schema element.
type Bfd_Interface_MicroBfdSession_LocalDiagnosticCodePath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_LocalDiagnosticCodePathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/local-diagnostic-code YANG schema element.
type Bfd_Interface_MicroBfdSession_LocalDiagnosticCodePathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_LocalDiscriminatorPath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/local-discriminator YANG schema element.
type Bfd_Interface_MicroBfdSession_LocalDiscriminatorPath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_LocalDiscriminatorPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/local-discriminator YANG schema element.
type Bfd_Interface_MicroBfdSession_LocalDiscriminatorPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_MemberInterfacePath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/config/member-interface YANG schema element.
type Bfd_Interface_MicroBfdSession_MemberInterfacePath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_MemberInterfacePathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/config/member-interface YANG schema element.
type Bfd_Interface_MicroBfdSession_MemberInterfacePathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_RemoteAddressPath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/config/remote-address YANG schema element.
type Bfd_Interface_MicroBfdSession_RemoteAddressPath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_RemoteAddressPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/config/remote-address YANG schema element.
type Bfd_Interface_MicroBfdSession_RemoteAddressPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_RemoteAuthenticationEnabledPath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-authentication-enabled YANG schema element.
type Bfd_Interface_MicroBfdSession_RemoteAuthenticationEnabledPath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_RemoteAuthenticationEnabledPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-authentication-enabled YANG schema element.
type Bfd_Interface_MicroBfdSession_RemoteAuthenticationEnabledPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_RemoteControlPlaneIndependentPath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-control-plane-independent YANG schema element.
type Bfd_Interface_MicroBfdSession_RemoteControlPlaneIndependentPath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_RemoteControlPlaneIndependentPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-control-plane-independent YANG schema element.
type Bfd_Interface_MicroBfdSession_RemoteControlPlaneIndependentPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_RemoteDiagnosticCodePath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-diagnostic-code YANG schema element.
type Bfd_Interface_MicroBfdSession_RemoteDiagnosticCodePath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_RemoteDiagnosticCodePathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-diagnostic-code YANG schema element.
type Bfd_Interface_MicroBfdSession_RemoteDiagnosticCodePathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_RemoteDiscriminatorPath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-discriminator YANG schema element.
type Bfd_Interface_MicroBfdSession_RemoteDiscriminatorPath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_RemoteDiscriminatorPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-discriminator YANG schema element.
type Bfd_Interface_MicroBfdSession_RemoteDiscriminatorPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_RemoteMinimumReceiveIntervalPath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-minimum-receive-interval YANG schema element.
type Bfd_Interface_MicroBfdSession_RemoteMinimumReceiveIntervalPath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_RemoteMinimumReceiveIntervalPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-minimum-receive-interval YANG schema element.
type Bfd_Interface_MicroBfdSession_RemoteMinimumReceiveIntervalPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_RemoteSessionStatePath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-session-state YANG schema element.
type Bfd_Interface_MicroBfdSession_RemoteSessionStatePath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_RemoteSessionStatePathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-session-state YANG schema element.
type Bfd_Interface_MicroBfdSession_RemoteSessionStatePathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_SessionStatePath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/session-state YANG schema element.
type Bfd_Interface_MicroBfdSession_SessionStatePath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_SessionStatePathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/session-state YANG schema element.
type Bfd_Interface_MicroBfdSession_SessionStatePathAny struct {
	*ygot.NodePath
}

// Async (container): Operational state parameters specifically relating to
// asynchronous mode of BFD.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/async"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async"
func (n *Bfd_Interface_MicroBfdSessionPath) Async() *Bfd_Interface_MicroBfdSession_AsyncPath {
	return &Bfd_Interface_MicroBfdSession_AsyncPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "async"},
			map[string]interface{}{},
			n,
		),
	}
}

// Async (container): Operational state parameters specifically relating to
// asynchronous mode of BFD.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/async"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async"
func (n *Bfd_Interface_MicroBfdSessionPathAny) Async() *Bfd_Interface_MicroBfdSession_AsyncPathAny {
	return &Bfd_Interface_MicroBfdSession_AsyncPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "async"},
			map[string]interface{}{},
			n,
		),
	}
}

// DemandModeRequested (leaf): This leaf is set to true when the remote system has requested
// demand mode be run for this session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/demand-mode-requested"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/demand-mode-requested"
func (n *Bfd_Interface_MicroBfdSessionPath) DemandModeRequested() *Bfd_Interface_MicroBfdSession_DemandModeRequestedPath {
	return &Bfd_Interface_MicroBfdSession_DemandModeRequestedPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "demand-mode-requested"},
			map[string]interface{}{},
			n,
		),
	}
}

// DemandModeRequested (leaf): This leaf is set to true when the remote system has requested
// demand mode be run for this session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/demand-mode-requested"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/demand-mode-requested"
func (n *Bfd_Interface_MicroBfdSessionPathAny) DemandModeRequested() *Bfd_Interface_MicroBfdSession_DemandModeRequestedPathAny {
	return &Bfd_Interface_MicroBfdSession_DemandModeRequestedPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "demand-mode-requested"},
			map[string]interface{}{},
			n,
		),
	}
}

// FailureTransitions (leaf): The number of times that the BFD session has transitioned
// out of the UP state.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/failure-transitions"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/failure-transitions"
func (n *Bfd_Interface_MicroBfdSessionPath) FailureTransitions() *Bfd_Interface_MicroBfdSession_FailureTransitionsPath {
	return &Bfd_Interface_MicroBfdSession_FailureTransitionsPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "failure-transitions"},
			map[string]interface{}{},
			n,
		),
	}
}

// FailureTransitions (leaf): The number of times that the BFD session has transitioned
// out of the UP state.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/failure-transitions"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/failure-transitions"
func (n *Bfd_Interface_MicroBfdSessionPathAny) FailureTransitions() *Bfd_Interface_MicroBfdSession_FailureTransitionsPathAny {
	return &Bfd_Interface_MicroBfdSession_FailureTransitionsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "failure-transitions"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastFailureTime (leaf): The time of the last transition of the BFD session out of
// the UP state, expressed as the number of nanoseconds since
// the Unix epoch.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/last-failure-time"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/last-failure-time"
func (n *Bfd_Interface_MicroBfdSessionPath) LastFailureTime() *Bfd_Interface_MicroBfdSession_LastFailureTimePath {
	return &Bfd_Interface_MicroBfdSession_LastFailureTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "last-failure-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastFailureTime (leaf): The time of the last transition of the BFD session out of
// the UP state, expressed as the number of nanoseconds since
// the Unix epoch.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/last-failure-time"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/last-failure-time"
func (n *Bfd_Interface_MicroBfdSessionPathAny) LastFailureTime() *Bfd_Interface_MicroBfdSession_LastFailureTimePathAny {
	return &Bfd_Interface_MicroBfdSession_LastFailureTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "last-failure-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// LocalAddress (leaf): The local IP address used by the system for the micro-BFD session
// specified.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/local-address"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/config/local-address"
func (n *Bfd_Interface_MicroBfdSessionPath) LocalAddress() *Bfd_Interface_MicroBfdSession_LocalAddressPath {
	return &Bfd_Interface_MicroBfdSession_LocalAddressPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "local-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// LocalAddress (leaf): The local IP address used by the system for the micro-BFD session
// specified.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/local-address"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/config/local-address"
func (n *Bfd_Interface_MicroBfdSessionPathAny) LocalAddress() *Bfd_Interface_MicroBfdSession_LocalAddressPathAny {
	return &Bfd_Interface_MicroBfdSession_LocalAddressPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "local-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// LocalDiagnosticCode (leaf): The local BFD diagnostic code indicating the most recent
// reason for failure of this BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/local-diagnostic-code"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/local-diagnostic-code"
func (n *Bfd_Interface_MicroBfdSessionPath) LocalDiagnosticCode() *Bfd_Interface_MicroBfdSession_LocalDiagnosticCodePath {
	return &Bfd_Interface_MicroBfdSession_LocalDiagnosticCodePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "local-diagnostic-code"},
			map[string]interface{}{},
			n,
		),
	}
}

// LocalDiagnosticCode (leaf): The local BFD diagnostic code indicating the most recent
// reason for failure of this BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/local-diagnostic-code"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/local-diagnostic-code"
func (n *Bfd_Interface_MicroBfdSessionPathAny) LocalDiagnosticCode() *Bfd_Interface_MicroBfdSession_LocalDiagnosticCodePathAny {
	return &Bfd_Interface_MicroBfdSession_LocalDiagnosticCodePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "local-diagnostic-code"},
			map[string]interface{}{},
			n,
		),
	}
}

// LocalDiscriminator (leaf): A unique identifier used by the local system to identify this
// BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/local-discriminator"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/local-discriminator"
func (n *Bfd_Interface_MicroBfdSessionPath) LocalDiscriminator() *Bfd_Interface_MicroBfdSession_LocalDiscriminatorPath {
	return &Bfd_Interface_MicroBfdSession_LocalDiscriminatorPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "local-discriminator"},
			map[string]interface{}{},
			n,
		),
	}
}

// LocalDiscriminator (leaf): A unique identifier used by the local system to identify this
// BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/local-discriminator"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/local-discriminator"
func (n *Bfd_Interface_MicroBfdSessionPathAny) LocalDiscriminator() *Bfd_Interface_MicroBfdSession_LocalDiscriminatorPathAny {
	return &Bfd_Interface_MicroBfdSession_LocalDiscriminatorPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "local-discriminator"},
			map[string]interface{}{},
			n,
		),
	}
}

// MemberInterface (leaf): Reference to a member link of the aggregate interface being
// described.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/member-interface"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/config/member-interface"
func (n *Bfd_Interface_MicroBfdSessionPath) MemberInterface() *Bfd_Interface_MicroBfdSession_MemberInterfacePath {
	return &Bfd_Interface_MicroBfdSession_MemberInterfacePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "member-interface"},
			map[string]interface{}{},
			n,
		),
	}
}

// MemberInterface (leaf): Reference to a member link of the aggregate interface being
// described.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/member-interface"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/config/member-interface"
func (n *Bfd_Interface_MicroBfdSessionPathAny) MemberInterface() *Bfd_Interface_MicroBfdSession_MemberInterfacePathAny {
	return &Bfd_Interface_MicroBfdSession_MemberInterfacePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "member-interface"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteAddress (leaf): The remote IP destination that should be used by the system for
// the micro-BFD session specified.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/remote-address"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/config/remote-address"
func (n *Bfd_Interface_MicroBfdSessionPath) RemoteAddress() *Bfd_Interface_MicroBfdSession_RemoteAddressPath {
	return &Bfd_Interface_MicroBfdSession_RemoteAddressPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "remote-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteAddress (leaf): The remote IP destination that should be used by the system for
// the micro-BFD session specified.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "config/remote-address"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/config/remote-address"
func (n *Bfd_Interface_MicroBfdSessionPathAny) RemoteAddress() *Bfd_Interface_MicroBfdSession_RemoteAddressPathAny {
	return &Bfd_Interface_MicroBfdSession_RemoteAddressPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "remote-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteAuthenticationEnabled (leaf): This leaf is set to true when the remote system has specified
// that authentication is present for the BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-authentication-enabled"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-authentication-enabled"
func (n *Bfd_Interface_MicroBfdSessionPath) RemoteAuthenticationEnabled() *Bfd_Interface_MicroBfdSession_RemoteAuthenticationEnabledPath {
	return &Bfd_Interface_MicroBfdSession_RemoteAuthenticationEnabledPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-authentication-enabled"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteAuthenticationEnabled (leaf): This leaf is set to true when the remote system has specified
// that authentication is present for the BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-authentication-enabled"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-authentication-enabled"
func (n *Bfd_Interface_MicroBfdSessionPathAny) RemoteAuthenticationEnabled() *Bfd_Interface_MicroBfdSession_RemoteAuthenticationEnabledPathAny {
	return &Bfd_Interface_MicroBfdSession_RemoteAuthenticationEnabledPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-authentication-enabled"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteControlPlaneIndependent (leaf): This leaf is set to true when the remote system has specified
// that the hardware implementing this BFD session is independent
// of the control plane's liveliness.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-control-plane-independent"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-control-plane-independent"
func (n *Bfd_Interface_MicroBfdSessionPath) RemoteControlPlaneIndependent() *Bfd_Interface_MicroBfdSession_RemoteControlPlaneIndependentPath {
	return &Bfd_Interface_MicroBfdSession_RemoteControlPlaneIndependentPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-control-plane-independent"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteControlPlaneIndependent (leaf): This leaf is set to true when the remote system has specified
// that the hardware implementing this BFD session is independent
// of the control plane's liveliness.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-control-plane-independent"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-control-plane-independent"
func (n *Bfd_Interface_MicroBfdSessionPathAny) RemoteControlPlaneIndependent() *Bfd_Interface_MicroBfdSession_RemoteControlPlaneIndependentPathAny {
	return &Bfd_Interface_MicroBfdSession_RemoteControlPlaneIndependentPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-control-plane-independent"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteDiagnosticCode (leaf): The remote BFD diagnostic code indicating the remote system's
// reason for failure of the BFD session
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-diagnostic-code"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-diagnostic-code"
func (n *Bfd_Interface_MicroBfdSessionPath) RemoteDiagnosticCode() *Bfd_Interface_MicroBfdSession_RemoteDiagnosticCodePath {
	return &Bfd_Interface_MicroBfdSession_RemoteDiagnosticCodePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-diagnostic-code"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteDiagnosticCode (leaf): The remote BFD diagnostic code indicating the remote system's
// reason for failure of the BFD session
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-diagnostic-code"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-diagnostic-code"
func (n *Bfd_Interface_MicroBfdSessionPathAny) RemoteDiagnosticCode() *Bfd_Interface_MicroBfdSession_RemoteDiagnosticCodePathAny {
	return &Bfd_Interface_MicroBfdSession_RemoteDiagnosticCodePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-diagnostic-code"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteDiscriminator (leaf): A unique identified used by the remote system to identify this
// BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-discriminator"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-discriminator"
func (n *Bfd_Interface_MicroBfdSessionPath) RemoteDiscriminator() *Bfd_Interface_MicroBfdSession_RemoteDiscriminatorPath {
	return &Bfd_Interface_MicroBfdSession_RemoteDiscriminatorPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-discriminator"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteDiscriminator (leaf): A unique identified used by the remote system to identify this
// BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-discriminator"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-discriminator"
func (n *Bfd_Interface_MicroBfdSessionPathAny) RemoteDiscriminator() *Bfd_Interface_MicroBfdSession_RemoteDiscriminatorPathAny {
	return &Bfd_Interface_MicroBfdSession_RemoteDiscriminatorPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-discriminator"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteMinimumReceiveInterval (leaf): The value of the minimum receive interval that was specified
// in the most recent BFD control packet received from the peer.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-minimum-receive-interval"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-minimum-receive-interval"
func (n *Bfd_Interface_MicroBfdSessionPath) RemoteMinimumReceiveInterval() *Bfd_Interface_MicroBfdSession_RemoteMinimumReceiveIntervalPath {
	return &Bfd_Interface_MicroBfdSession_RemoteMinimumReceiveIntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-minimum-receive-interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteMinimumReceiveInterval (leaf): The value of the minimum receive interval that was specified
// in the most recent BFD control packet received from the peer.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-minimum-receive-interval"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-minimum-receive-interval"
func (n *Bfd_Interface_MicroBfdSessionPathAny) RemoteMinimumReceiveInterval() *Bfd_Interface_MicroBfdSession_RemoteMinimumReceiveIntervalPathAny {
	return &Bfd_Interface_MicroBfdSession_RemoteMinimumReceiveIntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-minimum-receive-interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteSessionState (leaf): The reported state of the BFD session according to the remote
// system. This state reflects the last state reported in a BFD
// control packet.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-session-state"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-session-state"
func (n *Bfd_Interface_MicroBfdSessionPath) RemoteSessionState() *Bfd_Interface_MicroBfdSession_RemoteSessionStatePath {
	return &Bfd_Interface_MicroBfdSession_RemoteSessionStatePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-session-state"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteSessionState (leaf): The reported state of the BFD session according to the remote
// system. This state reflects the last state reported in a BFD
// control packet.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-session-state"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/remote-session-state"
func (n *Bfd_Interface_MicroBfdSessionPathAny) RemoteSessionState() *Bfd_Interface_MicroBfdSession_RemoteSessionStatePathAny {
	return &Bfd_Interface_MicroBfdSession_RemoteSessionStatePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-session-state"},
			map[string]interface{}{},
			n,
		),
	}
}

// SessionState (leaf): The state of the BFD session perceived by the local system.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/session-state"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/session-state"
func (n *Bfd_Interface_MicroBfdSessionPath) SessionState() *Bfd_Interface_MicroBfdSession_SessionStatePath {
	return &Bfd_Interface_MicroBfdSession_SessionStatePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "session-state"},
			map[string]interface{}{},
			n,
		),
	}
}

// SessionState (leaf): The state of the BFD session perceived by the local system.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/session-state"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/session-state"
func (n *Bfd_Interface_MicroBfdSessionPathAny) SessionState() *Bfd_Interface_MicroBfdSession_SessionStatePathAny {
	return &Bfd_Interface_MicroBfdSession_SessionStatePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "session-state"},
			map[string]interface{}{},
			n,
		),
	}
}

// Bfd_Interface_MicroBfdSession_AsyncPath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async YANG schema element.
type Bfd_Interface_MicroBfdSession_AsyncPath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_AsyncPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async YANG schema element.
type Bfd_Interface_MicroBfdSession_AsyncPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_Async_LastPacketReceivedPath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/last-packet-received YANG schema element.
type Bfd_Interface_MicroBfdSession_Async_LastPacketReceivedPath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_Async_LastPacketReceivedPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/last-packet-received YANG schema element.
type Bfd_Interface_MicroBfdSession_Async_LastPacketReceivedPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_Async_LastPacketTransmittedPath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/last-packet-transmitted YANG schema element.
type Bfd_Interface_MicroBfdSession_Async_LastPacketTransmittedPath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_Async_LastPacketTransmittedPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/last-packet-transmitted YANG schema element.
type Bfd_Interface_MicroBfdSession_Async_LastPacketTransmittedPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_Async_ReceivedPacketsPath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/received-packets YANG schema element.
type Bfd_Interface_MicroBfdSession_Async_ReceivedPacketsPath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_Async_ReceivedPacketsPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/received-packets YANG schema element.
type Bfd_Interface_MicroBfdSession_Async_ReceivedPacketsPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_Async_TransmittedPacketsPath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/transmitted-packets YANG schema element.
type Bfd_Interface_MicroBfdSession_Async_TransmittedPacketsPath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_Async_TransmittedPacketsPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/transmitted-packets YANG schema element.
type Bfd_Interface_MicroBfdSession_Async_TransmittedPacketsPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_Async_UpTransitionsPath represents the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/up-transitions YANG schema element.
type Bfd_Interface_MicroBfdSession_Async_UpTransitionsPath struct {
	*ygot.NodePath
}

// Bfd_Interface_MicroBfdSession_Async_UpTransitionsPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/up-transitions YANG schema element.
type Bfd_Interface_MicroBfdSession_Async_UpTransitionsPathAny struct {
	*ygot.NodePath
}

// LastPacketReceived (leaf): The date and time at which the last BFD packet
// was received for this session, expressed as the number
// of nanoseconds since the Unix Epoch (January 1, 1970,
// 00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "last-packet-received"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/last-packet-received"
func (n *Bfd_Interface_MicroBfdSession_AsyncPath) LastPacketReceived() *Bfd_Interface_MicroBfdSession_Async_LastPacketReceivedPath {
	return &Bfd_Interface_MicroBfdSession_Async_LastPacketReceivedPath{
		NodePath: ygot.NewNodePath(
			[]string{"last-packet-received"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastPacketReceived (leaf): The date and time at which the last BFD packet
// was received for this session, expressed as the number
// of nanoseconds since the Unix Epoch (January 1, 1970,
// 00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "last-packet-received"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/last-packet-received"
func (n *Bfd_Interface_MicroBfdSession_AsyncPathAny) LastPacketReceived() *Bfd_Interface_MicroBfdSession_Async_LastPacketReceivedPathAny {
	return &Bfd_Interface_MicroBfdSession_Async_LastPacketReceivedPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"last-packet-received"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastPacketTransmitted (leaf): The date and time at which the last BFD packet
// was transmitted for this session, expressed as the number
// of nanoseconds since the Unix Epoch (January 1, 1970,
// 00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "last-packet-transmitted"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/last-packet-transmitted"
func (n *Bfd_Interface_MicroBfdSession_AsyncPath) LastPacketTransmitted() *Bfd_Interface_MicroBfdSession_Async_LastPacketTransmittedPath {
	return &Bfd_Interface_MicroBfdSession_Async_LastPacketTransmittedPath{
		NodePath: ygot.NewNodePath(
			[]string{"last-packet-transmitted"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastPacketTransmitted (leaf): The date and time at which the last BFD packet
// was transmitted for this session, expressed as the number
// of nanoseconds since the Unix Epoch (January 1, 1970,
// 00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "last-packet-transmitted"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/last-packet-transmitted"
func (n *Bfd_Interface_MicroBfdSession_AsyncPathAny) LastPacketTransmitted() *Bfd_Interface_MicroBfdSession_Async_LastPacketTransmittedPathAny {
	return &Bfd_Interface_MicroBfdSession_Async_LastPacketTransmittedPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"last-packet-transmitted"},
			map[string]interface{}{},
			n,
		),
	}
}

// ReceivedPackets (leaf): The number of packets that have been received by the
// local system from the remote neighbour.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "received-packets"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/received-packets"
func (n *Bfd_Interface_MicroBfdSession_AsyncPath) ReceivedPackets() *Bfd_Interface_MicroBfdSession_Async_ReceivedPacketsPath {
	return &Bfd_Interface_MicroBfdSession_Async_ReceivedPacketsPath{
		NodePath: ygot.NewNodePath(
			[]string{"received-packets"},
			map[string]interface{}{},
			n,
		),
	}
}

// ReceivedPackets (leaf): The number of packets that have been received by the
// local system from the remote neighbour.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "received-packets"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/received-packets"
func (n *Bfd_Interface_MicroBfdSession_AsyncPathAny) ReceivedPackets() *Bfd_Interface_MicroBfdSession_Async_ReceivedPacketsPathAny {
	return &Bfd_Interface_MicroBfdSession_Async_ReceivedPacketsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"received-packets"},
			map[string]interface{}{},
			n,
		),
	}
}

// TransmittedPackets (leaf): The number of packets that have been transmitted
// by the local system.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "transmitted-packets"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/transmitted-packets"
func (n *Bfd_Interface_MicroBfdSession_AsyncPath) TransmittedPackets() *Bfd_Interface_MicroBfdSession_Async_TransmittedPacketsPath {
	return &Bfd_Interface_MicroBfdSession_Async_TransmittedPacketsPath{
		NodePath: ygot.NewNodePath(
			[]string{"transmitted-packets"},
			map[string]interface{}{},
			n,
		),
	}
}

// TransmittedPackets (leaf): The number of packets that have been transmitted
// by the local system.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "transmitted-packets"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/transmitted-packets"
func (n *Bfd_Interface_MicroBfdSession_AsyncPathAny) TransmittedPackets() *Bfd_Interface_MicroBfdSession_Async_TransmittedPacketsPathAny {
	return &Bfd_Interface_MicroBfdSession_Async_TransmittedPacketsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"transmitted-packets"},
			map[string]interface{}{},
			n,
		),
	}
}

// UpTransitions (leaf): The number of times that the adjacency with the neighbor
// has transitioned into the up state.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "up-transitions"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/up-transitions"
func (n *Bfd_Interface_MicroBfdSession_AsyncPath) UpTransitions() *Bfd_Interface_MicroBfdSession_Async_UpTransitionsPath {
	return &Bfd_Interface_MicroBfdSession_Async_UpTransitionsPath{
		NodePath: ygot.NewNodePath(
			[]string{"up-transitions"},
			map[string]interface{}{},
			n,
		),
	}
}

// UpTransitions (leaf): The number of times that the adjacency with the neighbor
// has transitioned into the up state.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "up-transitions"
// Path from root: "/bfd/interfaces/interface/micro-bfd-sessions/micro-bfd-session/state/async/up-transitions"
func (n *Bfd_Interface_MicroBfdSession_AsyncPathAny) UpTransitions() *Bfd_Interface_MicroBfdSession_Async_UpTransitionsPathAny {
	return &Bfd_Interface_MicroBfdSession_Async_UpTransitionsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"up-transitions"},
			map[string]interface{}{},
			n,
		),
	}
}

// Bfd_Interface_PeerPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer YANG schema element.
type Bfd_Interface_PeerPath struct {
	*ygot.NodePath
}

// Bfd_Interface_PeerPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer YANG schema element.
type Bfd_Interface_PeerPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_DemandModeRequestedPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/demand-mode-requested YANG schema element.
type Bfd_Interface_Peer_DemandModeRequestedPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_DemandModeRequestedPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/demand-mode-requested YANG schema element.
type Bfd_Interface_Peer_DemandModeRequestedPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_FailureTransitionsPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/failure-transitions YANG schema element.
type Bfd_Interface_Peer_FailureTransitionsPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_FailureTransitionsPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/failure-transitions YANG schema element.
type Bfd_Interface_Peer_FailureTransitionsPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_LastFailureTimePath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/last-failure-time YANG schema element.
type Bfd_Interface_Peer_LastFailureTimePath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_LastFailureTimePathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/last-failure-time YANG schema element.
type Bfd_Interface_Peer_LastFailureTimePathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_LocalAddressPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/local-address YANG schema element.
type Bfd_Interface_Peer_LocalAddressPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_LocalAddressPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/local-address YANG schema element.
type Bfd_Interface_Peer_LocalAddressPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_LocalDiagnosticCodePath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/local-diagnostic-code YANG schema element.
type Bfd_Interface_Peer_LocalDiagnosticCodePath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_LocalDiagnosticCodePathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/local-diagnostic-code YANG schema element.
type Bfd_Interface_Peer_LocalDiagnosticCodePathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_LocalDiscriminatorPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/local-discriminator YANG schema element.
type Bfd_Interface_Peer_LocalDiscriminatorPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_LocalDiscriminatorPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/local-discriminator YANG schema element.
type Bfd_Interface_Peer_LocalDiscriminatorPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_RemoteAddressPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/remote-address YANG schema element.
type Bfd_Interface_Peer_RemoteAddressPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_RemoteAddressPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/remote-address YANG schema element.
type Bfd_Interface_Peer_RemoteAddressPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_RemoteAuthenticationEnabledPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/remote-authentication-enabled YANG schema element.
type Bfd_Interface_Peer_RemoteAuthenticationEnabledPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_RemoteAuthenticationEnabledPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/remote-authentication-enabled YANG schema element.
type Bfd_Interface_Peer_RemoteAuthenticationEnabledPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_RemoteControlPlaneIndependentPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/remote-control-plane-independent YANG schema element.
type Bfd_Interface_Peer_RemoteControlPlaneIndependentPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_RemoteControlPlaneIndependentPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/remote-control-plane-independent YANG schema element.
type Bfd_Interface_Peer_RemoteControlPlaneIndependentPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_RemoteDiagnosticCodePath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/remote-diagnostic-code YANG schema element.
type Bfd_Interface_Peer_RemoteDiagnosticCodePath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_RemoteDiagnosticCodePathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/remote-diagnostic-code YANG schema element.
type Bfd_Interface_Peer_RemoteDiagnosticCodePathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_RemoteDiscriminatorPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/remote-discriminator YANG schema element.
type Bfd_Interface_Peer_RemoteDiscriminatorPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_RemoteDiscriminatorPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/remote-discriminator YANG schema element.
type Bfd_Interface_Peer_RemoteDiscriminatorPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_RemoteMinimumReceiveIntervalPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/remote-minimum-receive-interval YANG schema element.
type Bfd_Interface_Peer_RemoteMinimumReceiveIntervalPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_RemoteMinimumReceiveIntervalPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/remote-minimum-receive-interval YANG schema element.
type Bfd_Interface_Peer_RemoteMinimumReceiveIntervalPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_RemoteSessionStatePath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/remote-session-state YANG schema element.
type Bfd_Interface_Peer_RemoteSessionStatePath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_RemoteSessionStatePathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/remote-session-state YANG schema element.
type Bfd_Interface_Peer_RemoteSessionStatePathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_SessionStatePath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/session-state YANG schema element.
type Bfd_Interface_Peer_SessionStatePath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_SessionStatePathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/session-state YANG schema element.
type Bfd_Interface_Peer_SessionStatePathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_SubscribedProtocolsPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/subscribed-protocols YANG schema element.
type Bfd_Interface_Peer_SubscribedProtocolsPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_SubscribedProtocolsPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/subscribed-protocols YANG schema element.
type Bfd_Interface_Peer_SubscribedProtocolsPathAny struct {
	*ygot.NodePath
}

// Async (container): Operational state parameters specifically relating to
// asynchronous mode of BFD.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/async"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/async"
func (n *Bfd_Interface_PeerPath) Async() *Bfd_Interface_Peer_AsyncPath {
	return &Bfd_Interface_Peer_AsyncPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "async"},
			map[string]interface{}{},
			n,
		),
	}
}

// Async (container): Operational state parameters specifically relating to
// asynchronous mode of BFD.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/async"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/async"
func (n *Bfd_Interface_PeerPathAny) Async() *Bfd_Interface_Peer_AsyncPathAny {
	return &Bfd_Interface_Peer_AsyncPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "async"},
			map[string]interface{}{},
			n,
		),
	}
}

// DemandModeRequested (leaf): This leaf is set to true when the remote system has requested
// demand mode be run for this session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/demand-mode-requested"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/demand-mode-requested"
func (n *Bfd_Interface_PeerPath) DemandModeRequested() *Bfd_Interface_Peer_DemandModeRequestedPath {
	return &Bfd_Interface_Peer_DemandModeRequestedPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "demand-mode-requested"},
			map[string]interface{}{},
			n,
		),
	}
}

// DemandModeRequested (leaf): This leaf is set to true when the remote system has requested
// demand mode be run for this session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/demand-mode-requested"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/demand-mode-requested"
func (n *Bfd_Interface_PeerPathAny) DemandModeRequested() *Bfd_Interface_Peer_DemandModeRequestedPathAny {
	return &Bfd_Interface_Peer_DemandModeRequestedPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "demand-mode-requested"},
			map[string]interface{}{},
			n,
		),
	}
}

// Echo (container): Operational state parameters specifically relating to the
// echo mode of BFD.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/echo"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/echo"
func (n *Bfd_Interface_PeerPath) Echo() *Bfd_Interface_Peer_EchoPath {
	return &Bfd_Interface_Peer_EchoPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "echo"},
			map[string]interface{}{},
			n,
		),
	}
}

// Echo (container): Operational state parameters specifically relating to the
// echo mode of BFD.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/echo"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/echo"
func (n *Bfd_Interface_PeerPathAny) Echo() *Bfd_Interface_Peer_EchoPathAny {
	return &Bfd_Interface_Peer_EchoPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "echo"},
			map[string]interface{}{},
			n,
		),
	}
}

// FailureTransitions (leaf): The number of times that the BFD session has transitioned
// out of the UP state.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/failure-transitions"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/failure-transitions"
func (n *Bfd_Interface_PeerPath) FailureTransitions() *Bfd_Interface_Peer_FailureTransitionsPath {
	return &Bfd_Interface_Peer_FailureTransitionsPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "failure-transitions"},
			map[string]interface{}{},
			n,
		),
	}
}

// FailureTransitions (leaf): The number of times that the BFD session has transitioned
// out of the UP state.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/failure-transitions"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/failure-transitions"
func (n *Bfd_Interface_PeerPathAny) FailureTransitions() *Bfd_Interface_Peer_FailureTransitionsPathAny {
	return &Bfd_Interface_Peer_FailureTransitionsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "failure-transitions"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastFailureTime (leaf): The time of the last transition of the BFD session out of
// the UP state, expressed as the number of nanoseconds since
// the Unix epoch.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/last-failure-time"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/last-failure-time"
func (n *Bfd_Interface_PeerPath) LastFailureTime() *Bfd_Interface_Peer_LastFailureTimePath {
	return &Bfd_Interface_Peer_LastFailureTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "last-failure-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastFailureTime (leaf): The time of the last transition of the BFD session out of
// the UP state, expressed as the number of nanoseconds since
// the Unix epoch.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/last-failure-time"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/last-failure-time"
func (n *Bfd_Interface_PeerPathAny) LastFailureTime() *Bfd_Interface_Peer_LastFailureTimePathAny {
	return &Bfd_Interface_Peer_LastFailureTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "last-failure-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// LocalAddress (leaf): The IP address used by the local system for this BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/local-address"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/local-address"
func (n *Bfd_Interface_PeerPath) LocalAddress() *Bfd_Interface_Peer_LocalAddressPath {
	return &Bfd_Interface_Peer_LocalAddressPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "local-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// LocalAddress (leaf): The IP address used by the local system for this BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/local-address"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/local-address"
func (n *Bfd_Interface_PeerPathAny) LocalAddress() *Bfd_Interface_Peer_LocalAddressPathAny {
	return &Bfd_Interface_Peer_LocalAddressPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "local-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// LocalDiagnosticCode (leaf): The local BFD diagnostic code indicating the most recent
// reason for failure of this BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/local-diagnostic-code"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/local-diagnostic-code"
func (n *Bfd_Interface_PeerPath) LocalDiagnosticCode() *Bfd_Interface_Peer_LocalDiagnosticCodePath {
	return &Bfd_Interface_Peer_LocalDiagnosticCodePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "local-diagnostic-code"},
			map[string]interface{}{},
			n,
		),
	}
}

// LocalDiagnosticCode (leaf): The local BFD diagnostic code indicating the most recent
// reason for failure of this BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/local-diagnostic-code"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/local-diagnostic-code"
func (n *Bfd_Interface_PeerPathAny) LocalDiagnosticCode() *Bfd_Interface_Peer_LocalDiagnosticCodePathAny {
	return &Bfd_Interface_Peer_LocalDiagnosticCodePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "local-diagnostic-code"},
			map[string]interface{}{},
			n,
		),
	}
}

// LocalDiscriminator (leaf): A unique identifier used by the local system to identify this
// BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/local-discriminator"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/local-discriminator"
func (n *Bfd_Interface_PeerPath) LocalDiscriminator() *Bfd_Interface_Peer_LocalDiscriminatorPath {
	return &Bfd_Interface_Peer_LocalDiscriminatorPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "local-discriminator"},
			map[string]interface{}{},
			n,
		),
	}
}

// LocalDiscriminator (leaf): A unique identifier used by the local system to identify this
// BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/local-discriminator"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/local-discriminator"
func (n *Bfd_Interface_PeerPathAny) LocalDiscriminator() *Bfd_Interface_Peer_LocalDiscriminatorPathAny {
	return &Bfd_Interface_Peer_LocalDiscriminatorPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "local-discriminator"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteAddress (leaf): The IP address used by the remote system for this BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-address"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/remote-address"
func (n *Bfd_Interface_PeerPath) RemoteAddress() *Bfd_Interface_Peer_RemoteAddressPath {
	return &Bfd_Interface_Peer_RemoteAddressPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteAddress (leaf): The IP address used by the remote system for this BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-address"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/remote-address"
func (n *Bfd_Interface_PeerPathAny) RemoteAddress() *Bfd_Interface_Peer_RemoteAddressPathAny {
	return &Bfd_Interface_Peer_RemoteAddressPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteAuthenticationEnabled (leaf): This leaf is set to true when the remote system has specified
// that authentication is present for the BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-authentication-enabled"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/remote-authentication-enabled"
func (n *Bfd_Interface_PeerPath) RemoteAuthenticationEnabled() *Bfd_Interface_Peer_RemoteAuthenticationEnabledPath {
	return &Bfd_Interface_Peer_RemoteAuthenticationEnabledPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-authentication-enabled"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteAuthenticationEnabled (leaf): This leaf is set to true when the remote system has specified
// that authentication is present for the BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-authentication-enabled"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/remote-authentication-enabled"
func (n *Bfd_Interface_PeerPathAny) RemoteAuthenticationEnabled() *Bfd_Interface_Peer_RemoteAuthenticationEnabledPathAny {
	return &Bfd_Interface_Peer_RemoteAuthenticationEnabledPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-authentication-enabled"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteControlPlaneIndependent (leaf): This leaf is set to true when the remote system has specified
// that the hardware implementing this BFD session is independent
// of the control plane's liveliness.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-control-plane-independent"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/remote-control-plane-independent"
func (n *Bfd_Interface_PeerPath) RemoteControlPlaneIndependent() *Bfd_Interface_Peer_RemoteControlPlaneIndependentPath {
	return &Bfd_Interface_Peer_RemoteControlPlaneIndependentPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-control-plane-independent"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteControlPlaneIndependent (leaf): This leaf is set to true when the remote system has specified
// that the hardware implementing this BFD session is independent
// of the control plane's liveliness.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-control-plane-independent"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/remote-control-plane-independent"
func (n *Bfd_Interface_PeerPathAny) RemoteControlPlaneIndependent() *Bfd_Interface_Peer_RemoteControlPlaneIndependentPathAny {
	return &Bfd_Interface_Peer_RemoteControlPlaneIndependentPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-control-plane-independent"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteDiagnosticCode (leaf): The remote BFD diagnostic code indicating the remote system's
// reason for failure of the BFD session
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-diagnostic-code"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/remote-diagnostic-code"
func (n *Bfd_Interface_PeerPath) RemoteDiagnosticCode() *Bfd_Interface_Peer_RemoteDiagnosticCodePath {
	return &Bfd_Interface_Peer_RemoteDiagnosticCodePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-diagnostic-code"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteDiagnosticCode (leaf): The remote BFD diagnostic code indicating the remote system's
// reason for failure of the BFD session
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-diagnostic-code"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/remote-diagnostic-code"
func (n *Bfd_Interface_PeerPathAny) RemoteDiagnosticCode() *Bfd_Interface_Peer_RemoteDiagnosticCodePathAny {
	return &Bfd_Interface_Peer_RemoteDiagnosticCodePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-diagnostic-code"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteDiscriminator (leaf): A unique identified used by the remote system to identify this
// BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-discriminator"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/remote-discriminator"
func (n *Bfd_Interface_PeerPath) RemoteDiscriminator() *Bfd_Interface_Peer_RemoteDiscriminatorPath {
	return &Bfd_Interface_Peer_RemoteDiscriminatorPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-discriminator"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteDiscriminator (leaf): A unique identified used by the remote system to identify this
// BFD session.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-discriminator"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/remote-discriminator"
func (n *Bfd_Interface_PeerPathAny) RemoteDiscriminator() *Bfd_Interface_Peer_RemoteDiscriminatorPathAny {
	return &Bfd_Interface_Peer_RemoteDiscriminatorPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-discriminator"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteMinimumReceiveInterval (leaf): The value of the minimum receive interval that was specified
// in the most recent BFD control packet received from the peer.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-minimum-receive-interval"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/remote-minimum-receive-interval"
func (n *Bfd_Interface_PeerPath) RemoteMinimumReceiveInterval() *Bfd_Interface_Peer_RemoteMinimumReceiveIntervalPath {
	return &Bfd_Interface_Peer_RemoteMinimumReceiveIntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-minimum-receive-interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteMinimumReceiveInterval (leaf): The value of the minimum receive interval that was specified
// in the most recent BFD control packet received from the peer.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-minimum-receive-interval"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/remote-minimum-receive-interval"
func (n *Bfd_Interface_PeerPathAny) RemoteMinimumReceiveInterval() *Bfd_Interface_Peer_RemoteMinimumReceiveIntervalPathAny {
	return &Bfd_Interface_Peer_RemoteMinimumReceiveIntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-minimum-receive-interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteSessionState (leaf): The reported state of the BFD session according to the remote
// system. This state reflects the last state reported in a BFD
// control packet.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-session-state"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/remote-session-state"
func (n *Bfd_Interface_PeerPath) RemoteSessionState() *Bfd_Interface_Peer_RemoteSessionStatePath {
	return &Bfd_Interface_Peer_RemoteSessionStatePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-session-state"},
			map[string]interface{}{},
			n,
		),
	}
}

// RemoteSessionState (leaf): The reported state of the BFD session according to the remote
// system. This state reflects the last state reported in a BFD
// control packet.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/remote-session-state"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/remote-session-state"
func (n *Bfd_Interface_PeerPathAny) RemoteSessionState() *Bfd_Interface_Peer_RemoteSessionStatePathAny {
	return &Bfd_Interface_Peer_RemoteSessionStatePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "remote-session-state"},
			map[string]interface{}{},
			n,
		),
	}
}

// SessionState (leaf): The state of the BFD session perceived by the local system.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/session-state"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/session-state"
func (n *Bfd_Interface_PeerPath) SessionState() *Bfd_Interface_Peer_SessionStatePath {
	return &Bfd_Interface_Peer_SessionStatePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "session-state"},
			map[string]interface{}{},
			n,
		),
	}
}

// SessionState (leaf): The state of the BFD session perceived by the local system.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/session-state"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/session-state"
func (n *Bfd_Interface_PeerPathAny) SessionState() *Bfd_Interface_Peer_SessionStatePathAny {
	return &Bfd_Interface_Peer_SessionStatePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "session-state"},
			map[string]interface{}{},
			n,
		),
	}
}

// SubscribedProtocols (leaf-list): Indicates the set of protocols that currently use
// this BFD session for liveliness detection.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/subscribed-protocols"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/subscribed-protocols"
func (n *Bfd_Interface_PeerPath) SubscribedProtocols() *Bfd_Interface_Peer_SubscribedProtocolsPath {
	return &Bfd_Interface_Peer_SubscribedProtocolsPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "subscribed-protocols"},
			map[string]interface{}{},
			n,
		),
	}
}

// SubscribedProtocols (leaf-list): Indicates the set of protocols that currently use
// this BFD session for liveliness detection.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "state/subscribed-protocols"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/subscribed-protocols"
func (n *Bfd_Interface_PeerPathAny) SubscribedProtocols() *Bfd_Interface_Peer_SubscribedProtocolsPathAny {
	return &Bfd_Interface_Peer_SubscribedProtocolsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "subscribed-protocols"},
			map[string]interface{}{},
			n,
		),
	}
}

// Bfd_Interface_Peer_AsyncPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/async YANG schema element.
type Bfd_Interface_Peer_AsyncPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_AsyncPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/async YANG schema element.
type Bfd_Interface_Peer_AsyncPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Async_LastPacketReceivedPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/async/last-packet-received YANG schema element.
type Bfd_Interface_Peer_Async_LastPacketReceivedPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Async_LastPacketReceivedPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/async/last-packet-received YANG schema element.
type Bfd_Interface_Peer_Async_LastPacketReceivedPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Async_LastPacketTransmittedPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/async/last-packet-transmitted YANG schema element.
type Bfd_Interface_Peer_Async_LastPacketTransmittedPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Async_LastPacketTransmittedPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/async/last-packet-transmitted YANG schema element.
type Bfd_Interface_Peer_Async_LastPacketTransmittedPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Async_ReceivedPacketsPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/async/received-packets YANG schema element.
type Bfd_Interface_Peer_Async_ReceivedPacketsPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Async_ReceivedPacketsPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/async/received-packets YANG schema element.
type Bfd_Interface_Peer_Async_ReceivedPacketsPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Async_TransmittedPacketsPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/async/transmitted-packets YANG schema element.
type Bfd_Interface_Peer_Async_TransmittedPacketsPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Async_TransmittedPacketsPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/async/transmitted-packets YANG schema element.
type Bfd_Interface_Peer_Async_TransmittedPacketsPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Async_UpTransitionsPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/async/up-transitions YANG schema element.
type Bfd_Interface_Peer_Async_UpTransitionsPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Async_UpTransitionsPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/async/up-transitions YANG schema element.
type Bfd_Interface_Peer_Async_UpTransitionsPathAny struct {
	*ygot.NodePath
}

// LastPacketReceived (leaf): The date and time at which the last BFD packet
// was received for this session, expressed as the number
// of nanoseconds since the Unix Epoch (January 1, 1970,
// 00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "last-packet-received"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/async/last-packet-received"
func (n *Bfd_Interface_Peer_AsyncPath) LastPacketReceived() *Bfd_Interface_Peer_Async_LastPacketReceivedPath {
	return &Bfd_Interface_Peer_Async_LastPacketReceivedPath{
		NodePath: ygot.NewNodePath(
			[]string{"last-packet-received"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastPacketReceived (leaf): The date and time at which the last BFD packet
// was received for this session, expressed as the number
// of nanoseconds since the Unix Epoch (January 1, 1970,
// 00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "last-packet-received"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/async/last-packet-received"
func (n *Bfd_Interface_Peer_AsyncPathAny) LastPacketReceived() *Bfd_Interface_Peer_Async_LastPacketReceivedPathAny {
	return &Bfd_Interface_Peer_Async_LastPacketReceivedPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"last-packet-received"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastPacketTransmitted (leaf): The date and time at which the last BFD packet
// was transmitted for this session, expressed as the number
// of nanoseconds since the Unix Epoch (January 1, 1970,
// 00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "last-packet-transmitted"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/async/last-packet-transmitted"
func (n *Bfd_Interface_Peer_AsyncPath) LastPacketTransmitted() *Bfd_Interface_Peer_Async_LastPacketTransmittedPath {
	return &Bfd_Interface_Peer_Async_LastPacketTransmittedPath{
		NodePath: ygot.NewNodePath(
			[]string{"last-packet-transmitted"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastPacketTransmitted (leaf): The date and time at which the last BFD packet
// was transmitted for this session, expressed as the number
// of nanoseconds since the Unix Epoch (January 1, 1970,
// 00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "last-packet-transmitted"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/async/last-packet-transmitted"
func (n *Bfd_Interface_Peer_AsyncPathAny) LastPacketTransmitted() *Bfd_Interface_Peer_Async_LastPacketTransmittedPathAny {
	return &Bfd_Interface_Peer_Async_LastPacketTransmittedPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"last-packet-transmitted"},
			map[string]interface{}{},
			n,
		),
	}
}

// ReceivedPackets (leaf): The number of packets that have been received by the
// local system from the remote neighbour.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "received-packets"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/async/received-packets"
func (n *Bfd_Interface_Peer_AsyncPath) ReceivedPackets() *Bfd_Interface_Peer_Async_ReceivedPacketsPath {
	return &Bfd_Interface_Peer_Async_ReceivedPacketsPath{
		NodePath: ygot.NewNodePath(
			[]string{"received-packets"},
			map[string]interface{}{},
			n,
		),
	}
}

// ReceivedPackets (leaf): The number of packets that have been received by the
// local system from the remote neighbour.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "received-packets"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/async/received-packets"
func (n *Bfd_Interface_Peer_AsyncPathAny) ReceivedPackets() *Bfd_Interface_Peer_Async_ReceivedPacketsPathAny {
	return &Bfd_Interface_Peer_Async_ReceivedPacketsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"received-packets"},
			map[string]interface{}{},
			n,
		),
	}
}

// TransmittedPackets (leaf): The number of packets that have been transmitted
// by the local system.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "transmitted-packets"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/async/transmitted-packets"
func (n *Bfd_Interface_Peer_AsyncPath) TransmittedPackets() *Bfd_Interface_Peer_Async_TransmittedPacketsPath {
	return &Bfd_Interface_Peer_Async_TransmittedPacketsPath{
		NodePath: ygot.NewNodePath(
			[]string{"transmitted-packets"},
			map[string]interface{}{},
			n,
		),
	}
}

// TransmittedPackets (leaf): The number of packets that have been transmitted
// by the local system.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "transmitted-packets"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/async/transmitted-packets"
func (n *Bfd_Interface_Peer_AsyncPathAny) TransmittedPackets() *Bfd_Interface_Peer_Async_TransmittedPacketsPathAny {
	return &Bfd_Interface_Peer_Async_TransmittedPacketsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"transmitted-packets"},
			map[string]interface{}{},
			n,
		),
	}
}

// UpTransitions (leaf): The number of times that the adjacency with the neighbor
// has transitioned into the up state.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "up-transitions"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/async/up-transitions"
func (n *Bfd_Interface_Peer_AsyncPath) UpTransitions() *Bfd_Interface_Peer_Async_UpTransitionsPath {
	return &Bfd_Interface_Peer_Async_UpTransitionsPath{
		NodePath: ygot.NewNodePath(
			[]string{"up-transitions"},
			map[string]interface{}{},
			n,
		),
	}
}

// UpTransitions (leaf): The number of times that the adjacency with the neighbor
// has transitioned into the up state.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "up-transitions"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/async/up-transitions"
func (n *Bfd_Interface_Peer_AsyncPathAny) UpTransitions() *Bfd_Interface_Peer_Async_UpTransitionsPathAny {
	return &Bfd_Interface_Peer_Async_UpTransitionsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"up-transitions"},
			map[string]interface{}{},
			n,
		),
	}
}

// Bfd_Interface_Peer_EchoPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo YANG schema element.
type Bfd_Interface_Peer_EchoPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_EchoPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo YANG schema element.
type Bfd_Interface_Peer_EchoPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Echo_ActivePath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo/active YANG schema element.
type Bfd_Interface_Peer_Echo_ActivePath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Echo_ActivePathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo/active YANG schema element.
type Bfd_Interface_Peer_Echo_ActivePathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Echo_LastPacketReceivedPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo/last-packet-received YANG schema element.
type Bfd_Interface_Peer_Echo_LastPacketReceivedPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Echo_LastPacketReceivedPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo/last-packet-received YANG schema element.
type Bfd_Interface_Peer_Echo_LastPacketReceivedPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Echo_LastPacketTransmittedPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo/last-packet-transmitted YANG schema element.
type Bfd_Interface_Peer_Echo_LastPacketTransmittedPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Echo_LastPacketTransmittedPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo/last-packet-transmitted YANG schema element.
type Bfd_Interface_Peer_Echo_LastPacketTransmittedPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Echo_ReceivedPacketsPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo/received-packets YANG schema element.
type Bfd_Interface_Peer_Echo_ReceivedPacketsPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Echo_ReceivedPacketsPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo/received-packets YANG schema element.
type Bfd_Interface_Peer_Echo_ReceivedPacketsPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Echo_TransmittedPacketsPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo/transmitted-packets YANG schema element.
type Bfd_Interface_Peer_Echo_TransmittedPacketsPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Echo_TransmittedPacketsPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo/transmitted-packets YANG schema element.
type Bfd_Interface_Peer_Echo_TransmittedPacketsPathAny struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Echo_UpTransitionsPath represents the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo/up-transitions YANG schema element.
type Bfd_Interface_Peer_Echo_UpTransitionsPath struct {
	*ygot.NodePath
}

// Bfd_Interface_Peer_Echo_UpTransitionsPathAny represents the wildcard version of the /openconfig-bfd/bfd/interfaces/interface/peers/peer/state/echo/up-transitions YANG schema element.
type Bfd_Interface_Peer_Echo_UpTransitionsPathAny struct {
	*ygot.NodePath
}

// Active (leaf): This leaf is set to true when echo mode is running between
// the local and remote system. When it is set to false, solely
// asynchronous mode is active.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "active"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/echo/active"
func (n *Bfd_Interface_Peer_EchoPath) Active() *Bfd_Interface_Peer_Echo_ActivePath {
	return &Bfd_Interface_Peer_Echo_ActivePath{
		NodePath: ygot.NewNodePath(
			[]string{"active"},
			map[string]interface{}{},
			n,
		),
	}
}

// Active (leaf): This leaf is set to true when echo mode is running between
// the local and remote system. When it is set to false, solely
// asynchronous mode is active.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "active"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/echo/active"
func (n *Bfd_Interface_Peer_EchoPathAny) Active() *Bfd_Interface_Peer_Echo_ActivePathAny {
	return &Bfd_Interface_Peer_Echo_ActivePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"active"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastPacketReceived (leaf): The date and time at which the last BFD packet
// was received for this session, expressed as the number
// of nanoseconds since the Unix Epoch (January 1, 1970,
// 00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "last-packet-received"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/echo/last-packet-received"
func (n *Bfd_Interface_Peer_EchoPath) LastPacketReceived() *Bfd_Interface_Peer_Echo_LastPacketReceivedPath {
	return &Bfd_Interface_Peer_Echo_LastPacketReceivedPath{
		NodePath: ygot.NewNodePath(
			[]string{"last-packet-received"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastPacketReceived (leaf): The date and time at which the last BFD packet
// was received for this session, expressed as the number
// of nanoseconds since the Unix Epoch (January 1, 1970,
// 00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "last-packet-received"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/echo/last-packet-received"
func (n *Bfd_Interface_Peer_EchoPathAny) LastPacketReceived() *Bfd_Interface_Peer_Echo_LastPacketReceivedPathAny {
	return &Bfd_Interface_Peer_Echo_LastPacketReceivedPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"last-packet-received"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastPacketTransmitted (leaf): The date and time at which the last BFD packet
// was transmitted for this session, expressed as the number
// of nanoseconds since the Unix Epoch (January 1, 1970,
// 00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "last-packet-transmitted"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/echo/last-packet-transmitted"
func (n *Bfd_Interface_Peer_EchoPath) LastPacketTransmitted() *Bfd_Interface_Peer_Echo_LastPacketTransmittedPath {
	return &Bfd_Interface_Peer_Echo_LastPacketTransmittedPath{
		NodePath: ygot.NewNodePath(
			[]string{"last-packet-transmitted"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastPacketTransmitted (leaf): The date and time at which the last BFD packet
// was transmitted for this session, expressed as the number
// of nanoseconds since the Unix Epoch (January 1, 1970,
// 00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "last-packet-transmitted"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/echo/last-packet-transmitted"
func (n *Bfd_Interface_Peer_EchoPathAny) LastPacketTransmitted() *Bfd_Interface_Peer_Echo_LastPacketTransmittedPathAny {
	return &Bfd_Interface_Peer_Echo_LastPacketTransmittedPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"last-packet-transmitted"},
			map[string]interface{}{},
			n,
		),
	}
}

// ReceivedPackets (leaf): The number of packets that have been received by the
// local system from the remote neighbour.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "received-packets"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/echo/received-packets"
func (n *Bfd_Interface_Peer_EchoPath) ReceivedPackets() *Bfd_Interface_Peer_Echo_ReceivedPacketsPath {
	return &Bfd_Interface_Peer_Echo_ReceivedPacketsPath{
		NodePath: ygot.NewNodePath(
			[]string{"received-packets"},
			map[string]interface{}{},
			n,
		),
	}
}

// ReceivedPackets (leaf): The number of packets that have been received by the
// local system from the remote neighbour.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "received-packets"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/echo/received-packets"
func (n *Bfd_Interface_Peer_EchoPathAny) ReceivedPackets() *Bfd_Interface_Peer_Echo_ReceivedPacketsPathAny {
	return &Bfd_Interface_Peer_Echo_ReceivedPacketsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"received-packets"},
			map[string]interface{}{},
			n,
		),
	}
}

// TransmittedPackets (leaf): The number of packets that have been transmitted
// by the local system.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "transmitted-packets"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/echo/transmitted-packets"
func (n *Bfd_Interface_Peer_EchoPath) TransmittedPackets() *Bfd_Interface_Peer_Echo_TransmittedPacketsPath {
	return &Bfd_Interface_Peer_Echo_TransmittedPacketsPath{
		NodePath: ygot.NewNodePath(
			[]string{"transmitted-packets"},
			map[string]interface{}{},
			n,
		),
	}
}

// TransmittedPackets (leaf): The number of packets that have been transmitted
// by the local system.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "transmitted-packets"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/echo/transmitted-packets"
func (n *Bfd_Interface_Peer_EchoPathAny) TransmittedPackets() *Bfd_Interface_Peer_Echo_TransmittedPacketsPathAny {
	return &Bfd_Interface_Peer_Echo_TransmittedPacketsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"transmitted-packets"},
			map[string]interface{}{},
			n,
		),
	}
}

// UpTransitions (leaf): The number of times that the adjacency with the neighbor
// has transitioned into the up state.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "up-transitions"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/echo/up-transitions"
func (n *Bfd_Interface_Peer_EchoPath) UpTransitions() *Bfd_Interface_Peer_Echo_UpTransitionsPath {
	return &Bfd_Interface_Peer_Echo_UpTransitionsPath{
		NodePath: ygot.NewNodePath(
			[]string{"up-transitions"},
			map[string]interface{}{},
			n,
		),
	}
}

// UpTransitions (leaf): The number of times that the adjacency with the neighbor
// has transitioned into the up state.
// ----------------------------------------
// Defining module: "openconfig-bfd"
// Instantiating module: "openconfig-bfd"
// Path from parent: "up-transitions"
// Path from root: "/bfd/interfaces/interface/peers/peer/state/echo/up-transitions"
func (n *Bfd_Interface_Peer_EchoPathAny) UpTransitions() *Bfd_Interface_Peer_Echo_UpTransitionsPathAny {
	return &Bfd_Interface_Peer_Echo_UpTransitionsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"up-transitions"},
			map[string]interface{}{},
			n,
		),
	}
}

// ComponentPath represents the /openconfig-platform/components/component YANG schema element.
type ComponentPath struct {
	*ygot.NodePath
}

// ComponentPathAny represents the wildcard version of the /openconfig-platform/components/component YANG schema element.
type ComponentPathAny struct {
	*ygot.NodePath
}

// Component_AllocatedPowerPath represents the /openconfig-platform/components/component/state/allocated-power YANG schema element.
type Component_AllocatedPowerPath struct {
	*ygot.NodePath
}

// Component_AllocatedPowerPathAny represents the wildcard version of the /openconfig-platform/components/component/state/allocated-power YANG schema element.
type Component_AllocatedPowerPathAny struct {
	*ygot.NodePath
}

// Component_BaseMacAddressPath represents the /openconfig-platform/components/component/state/base-mac-address YANG schema element.
type Component_BaseMacAddressPath struct {
	*ygot.NodePath
}

// Component_BaseMacAddressPathAny represents the wildcard version of the /openconfig-platform/components/component/state/base-mac-address YANG schema element.
type Component_BaseMacAddressPathAny struct {
	*ygot.NodePath
}

// Component_CleiCodePath represents the /openconfig-platform/components/component/state/clei-code YANG schema element.
type Component_CleiCodePath struct {
	*ygot.NodePath
}

// Component_CleiCodePathAny represents the wildcard version of the /openconfig-platform/components/component/state/clei-code YANG schema element.
type Component_CleiCodePathAny struct {
	*ygot.NodePath
}

// Component_DescriptionPath represents the /openconfig-platform/components/component/state/description YANG schema element.
type Component_DescriptionPath struct {
	*ygot.NodePath
}

// Component_DescriptionPathAny represents the wildcard version of the /openconfig-platform/components/component/state/description YANG schema element.
type Component_DescriptionPathAny struct {
	*ygot.NodePath
}

// Component_EmptyPath represents the /openconfig-platform/components/component/state/empty YANG schema element.
type Component_EmptyPath struct {
	*ygot.NodePath
}

// Component_EmptyPathAny represents the wildcard version of the /openconfig-platform/components/component/state/empty YANG schema element.
type Component_EmptyPathAny struct {
	*ygot.NodePath
}

// Component_EquipmentFailurePath represents the /openconfig-platform/components/component/state/equipment-failure YANG schema element.
type Component_EquipmentFailurePath struct {
	*ygot.NodePath
}

// Component_EquipmentFailurePathAny represents the wildcard version of the /openconfig-platform/components/component/state/equipment-failure YANG schema element.
type Component_EquipmentFailurePathAny struct {
	*ygot.NodePath
}

// Component_EquipmentMismatchPath represents the /openconfig-platform/components/component/state/equipment-mismatch YANG schema element.
type Component_EquipmentMismatchPath struct {
	*ygot.NodePath
}

// Component_EquipmentMismatchPathAny represents the wildcard version of the /openconfig-platform/components/component/state/equipment-mismatch YANG schema element.
type Component_EquipmentMismatchPathAny struct {
	*ygot.NodePath
}

// Component_FirmwareVersionPath represents the /openconfig-platform/components/component/state/firmware-version YANG schema element.
type Component_FirmwareVersionPath struct {
	*ygot.NodePath
}

// Component_FirmwareVersionPathAny represents the wildcard version of the /openconfig-platform/components/component/state/firmware-version YANG schema element.
type Component_FirmwareVersionPathAny struct {
	*ygot.NodePath
}

// Component_HardwareVersionPath represents the /openconfig-platform/components/component/state/hardware-version YANG schema element.
type Component_HardwareVersionPath struct {
	*ygot.NodePath
}

// Component_HardwareVersionPathAny represents the wildcard version of the /openconfig-platform/components/component/state/hardware-version YANG schema element.
type Component_HardwareVersionPathAny struct {
	*ygot.NodePath
}

// Component_IdPath represents the /openconfig-platform/components/component/state/id YANG schema element.
type Component_IdPath struct {
	*ygot.NodePath
}

// Component_IdPathAny represents the wildcard version of the /openconfig-platform/components/component/state/id YANG schema element.
type Component_IdPathAny struct {
	*ygot.NodePath
}

// Component_LastRebootReasonPath represents the /openconfig-platform/components/component/state/last-reboot-reason YANG schema element.
type Component_LastRebootReasonPath struct {
	*ygot.NodePath
}

// Component_LastRebootReasonPathAny represents the wildcard version of the /openconfig-platform/components/component/state/last-reboot-reason YANG schema element.
type Component_LastRebootReasonPathAny struct {
	*ygot.NodePath
}

// Component_LastRebootTimePath represents the /openconfig-platform/components/component/state/last-reboot-time YANG schema element.
type Component_LastRebootTimePath struct {
	*ygot.NodePath
}

// Component_LastRebootTimePathAny represents the wildcard version of the /openconfig-platform/components/component/state/last-reboot-time YANG schema element.
type Component_LastRebootTimePathAny struct {
	*ygot.NodePath
}

// Component_LastSwitchoverTimePath represents the /openconfig-platform/components/component/state/last-switchover-time YANG schema element.
type Component_LastSwitchoverTimePath struct {
	*ygot.NodePath
}

// Component_LastSwitchoverTimePathAny represents the wildcard version of the /openconfig-platform/components/component/state/last-switchover-time YANG schema element.
type Component_LastSwitchoverTimePathAny struct {
	*ygot.NodePath
}

// Component_LocationPath represents the /openconfig-platform/components/component/state/location YANG schema element.
type Component_LocationPath struct {
	*ygot.NodePath
}

// Component_LocationPathAny represents the wildcard version of the /openconfig-platform/components/component/state/location YANG schema element.
type Component_LocationPathAny struct {
	*ygot.NodePath
}

// Component_MfgDatePath represents the /openconfig-platform/components/component/state/mfg-date YANG schema element.
type Component_MfgDatePath struct {
	*ygot.NodePath
}

// Component_MfgDatePathAny represents the wildcard version of the /openconfig-platform/components/component/state/mfg-date YANG schema element.
type Component_MfgDatePathAny struct {
	*ygot.NodePath
}

// Component_MfgNamePath represents the /openconfig-platform/components/component/state/mfg-name YANG schema element.
type Component_MfgNamePath struct {
	*ygot.NodePath
}

// Component_MfgNamePathAny represents the wildcard version of the /openconfig-platform/components/component/state/mfg-name YANG schema element.
type Component_MfgNamePathAny struct {
	*ygot.NodePath
}

// Component_ModelNamePath represents the /openconfig-platform/components/component/state/model-name YANG schema element.
type Component_ModelNamePath struct {
	*ygot.NodePath
}

// Component_ModelNamePathAny represents the wildcard version of the /openconfig-platform/components/component/state/model-name YANG schema element.
type Component_ModelNamePathAny struct {
	*ygot.NodePath
}

// Component_NamePath represents the /openconfig-platform/components/component/config/name YANG schema element.
type Component_NamePath struct {
	*ygot.NodePath
}

// Component_NamePathAny represents the wildcard version of the /openconfig-platform/components/component/config/name YANG schema element.
type Component_NamePathAny struct {
	*ygot.NodePath
}

// Component_OperStatusPath represents the /openconfig-platform/components/component/state/oper-status YANG schema element.
type Component_OperStatusPath struct {
	*ygot.NodePath
}

// Component_OperStatusPathAny represents the wildcard version of the /openconfig-platform/components/component/state/oper-status YANG schema element.
type Component_OperStatusPathAny struct {
	*ygot.NodePath
}

// Component_ParentPath represents the /openconfig-platform/components/component/state/parent YANG schema element.
type Component_ParentPath struct {
	*ygot.NodePath
}

// Component_ParentPathAny represents the wildcard version of the /openconfig-platform/components/component/state/parent YANG schema element.
type Component_ParentPathAny struct {
	*ygot.NodePath
}

// Component_PartNoPath represents the /openconfig-platform/components/component/state/part-no YANG schema element.
type Component_PartNoPath struct {
	*ygot.NodePath
}

// Component_PartNoPathAny represents the wildcard version of the /openconfig-platform/components/component/state/part-no YANG schema element.
type Component_PartNoPathAny struct {
	*ygot.NodePath
}

// Component_RedundantRolePath represents the /openconfig-platform/components/component/state/redundant-role YANG schema element.
type Component_RedundantRolePath struct {
	*ygot.NodePath
}

// Component_RedundantRolePathAny represents the wildcard version of the /openconfig-platform/components/component/state/redundant-role YANG schema element.
type Component_RedundantRolePathAny struct {
	*ygot.NodePath
}

// Component_RemovablePath represents the /openconfig-platform/components/component/state/removable YANG schema element.
type Component_RemovablePath struct {
	*ygot.NodePath
}

// Component_RemovablePathAny represents the wildcard version of the /openconfig-platform/components/component/state/removable YANG schema element.
type Component_RemovablePathAny struct {
	*ygot.NodePath
}

// Component_SerialNoPath represents the /openconfig-platform/components/component/state/serial-no YANG schema element.
type Component_SerialNoPath struct {
	*ygot.NodePath
}

// Component_SerialNoPathAny represents the wildcard version of the /openconfig-platform/components/component/state/serial-no YANG schema element.
type Component_SerialNoPathAny struct {
	*ygot.NodePath
}

// Component_SoftwareVersionPath represents the /openconfig-platform/components/component/state/software-version YANG schema element.
type Component_SoftwareVersionPath struct {
	*ygot.NodePath
}

// Component_SoftwareVersionPathAny represents the wildcard version of the /openconfig-platform/components/component/state/software-version YANG schema element.
type Component_SoftwareVersionPathAny struct {
	*ygot.NodePath
}

// Component_SwitchoverReadyPath represents the /openconfig-platform/components/component/state/switchover-ready YANG schema element.
type Component_SwitchoverReadyPath struct {
	*ygot.NodePath
}

// Component_SwitchoverReadyPathAny represents the wildcard version of the /openconfig-platform/components/component/state/switchover-ready YANG schema element.
type Component_SwitchoverReadyPathAny struct {
	*ygot.NodePath
}

// Component_TypePath represents the /openconfig-platform/components/component/state/type YANG schema element.
type Component_TypePath struct {
	*ygot.NodePath
}

// Component_TypePathAny represents the wildcard version of the /openconfig-platform/components/component/state/type YANG schema element.
type Component_TypePathAny struct {
	*ygot.NodePath
}

// Component_UsedPowerPath represents the /openconfig-platform/components/component/state/used-power YANG schema element.
type Component_UsedPowerPath struct {
	*ygot.NodePath
}

// Component_UsedPowerPathAny represents the wildcard version of the /openconfig-platform/components/component/state/used-power YANG schema element.
type Component_UsedPowerPathAny struct {
	*ygot.NodePath
}

// AllocatedPower (leaf): Power allocated by the system for the component.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/allocated-power"
// Path from root: "/components/component/state/allocated-power"
func (n *ComponentPath) AllocatedPower() *Component_AllocatedPowerPath {
	return &Component_AllocatedPowerPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "allocated-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// AllocatedPower (leaf): Power allocated by the system for the component.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/allocated-power"
// Path from root: "/components/component/state/allocated-power"
func (n *ComponentPathAny) AllocatedPower() *Component_AllocatedPowerPathAny {
	return &Component_AllocatedPowerPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "allocated-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// Backplane (container): Data for backplane components
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "backplane"
// Path from root: "/components/component/backplane"
func (n *ComponentPath) Backplane() *Component_BackplanePath {
	return &Component_BackplanePath{
		NodePath: ygot.NewNodePath(
			[]string{"backplane"},
			map[string]interface{}{},
			n,
		),
	}
}

// Backplane (container): Data for backplane components
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "backplane"
// Path from root: "/components/component/backplane"
func (n *ComponentPathAny) Backplane() *Component_BackplanePathAny {
	return &Component_BackplanePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"backplane"},
			map[string]interface{}{},
			n,
		),
	}
}

// BaseMacAddress (leaf): This is a MAC address representing the root or primary MAC
// address for a component.  Components such as CHASSIS and
// CONTROLLER_CARD are expected to provide a base-mac-address.  The
// base mac-address for CHASSIS and a PRIMARY CONTROLLER_CARD may
// contain the same value.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/base-mac-address"
// Path from root: "/components/component/state/base-mac-address"
func (n *ComponentPath) BaseMacAddress() *Component_BaseMacAddressPath {
	return &Component_BaseMacAddressPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "base-mac-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// BaseMacAddress (leaf): This is a MAC address representing the root or primary MAC
// address for a component.  Components such as CHASSIS and
// CONTROLLER_CARD are expected to provide a base-mac-address.  The
// base mac-address for CHASSIS and a PRIMARY CONTROLLER_CARD may
// contain the same value.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/base-mac-address"
// Path from root: "/components/component/state/base-mac-address"
func (n *ComponentPathAny) BaseMacAddress() *Component_BaseMacAddressPathAny {
	return &Component_BaseMacAddressPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "base-mac-address"},
			map[string]interface{}{},
			n,
		),
	}
}

// Chassis (container): Data for chassis components
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "chassis"
// Path from root: "/components/component/chassis"
func (n *ComponentPath) Chassis() *Component_ChassisPath {
	return &Component_ChassisPath{
		NodePath: ygot.NewNodePath(
			[]string{"chassis"},
			map[string]interface{}{},
			n,
		),
	}
}

// Chassis (container): Data for chassis components
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "chassis"
// Path from root: "/components/component/chassis"
func (n *ComponentPathAny) Chassis() *Component_ChassisPathAny {
	return &Component_ChassisPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"chassis"},
			map[string]interface{}{},
			n,
		),
	}
}

// CleiCode (leaf): Common Language Equipment Identifier (CLEI) code of the
// component.  This should be present in particular if the
// component is also an FRU (field replaceable unit)
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/clei-code"
// Path from root: "/components/component/state/clei-code"
func (n *ComponentPath) CleiCode() *Component_CleiCodePath {
	return &Component_CleiCodePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "clei-code"},
			map[string]interface{}{},
			n,
		),
	}
}

// CleiCode (leaf): Common Language Equipment Identifier (CLEI) code of the
// component.  This should be present in particular if the
// component is also an FRU (field replaceable unit)
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/clei-code"
// Path from root: "/components/component/state/clei-code"
func (n *ComponentPathAny) CleiCode() *Component_CleiCodePathAny {
	return &Component_CleiCodePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "clei-code"},
			map[string]interface{}{},
			n,
		),
	}
}

// ControllerCard (container): Data for controller card components, i.e., for components
// with type=CONTROLLER_CARD
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "controller-card"
// Path from root: "/components/component/controller-card"
func (n *ComponentPath) ControllerCard() *Component_ControllerCardPath {
	return &Component_ControllerCardPath{
		NodePath: ygot.NewNodePath(
			[]string{"controller-card"},
			map[string]interface{}{},
			n,
		),
	}
}

// ControllerCard (container): Data for controller card components, i.e., for components
// with type=CONTROLLER_CARD
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "controller-card"
// Path from root: "/components/component/controller-card"
func (n *ComponentPathAny) ControllerCard() *Component_ControllerCardPathAny {
	return &Component_ControllerCardPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"controller-card"},
			map[string]interface{}{},
			n,
		),
	}
}

// Cpu (container): Data for cpu components
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "cpu"
// Path from root: "/components/component/cpu"
func (n *ComponentPath) Cpu() *Component_CpuPath {
	return &Component_CpuPath{
		NodePath: ygot.NewNodePath(
			[]string{"cpu"},
			map[string]interface{}{},
			n,
		),
	}
}

// Cpu (container): Data for cpu components
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "cpu"
// Path from root: "/components/component/cpu"
func (n *ComponentPathAny) Cpu() *Component_CpuPathAny {
	return &Component_CpuPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"cpu"},
			map[string]interface{}{},
			n,
		),
	}
}

// Description (leaf): System-supplied description of the component
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/description"
// Path from root: "/components/component/state/description"
func (n *ComponentPath) Description() *Component_DescriptionPath {
	return &Component_DescriptionPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "description"},
			map[string]interface{}{},
			n,
		),
	}
}

// Description (leaf): System-supplied description of the component
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/description"
// Path from root: "/components/component/state/description"
func (n *ComponentPathAny) Description() *Component_DescriptionPathAny {
	return &Component_DescriptionPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "description"},
			map[string]interface{}{},
			n,
		),
	}
}

// Empty (leaf): The empty leaf may be used by the device to indicate that a
// component position exists but is not populated.  Using this
// flag, it is possible for the management system to learn how
// many positions are available (e.g., occupied vs. empty
// linecard slots in a chassis).
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/empty"
// Path from root: "/components/component/state/empty"
func (n *ComponentPath) Empty() *Component_EmptyPath {
	return &Component_EmptyPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "empty"},
			map[string]interface{}{},
			n,
		),
	}
}

// Empty (leaf): The empty leaf may be used by the device to indicate that a
// component position exists but is not populated.  Using this
// flag, it is possible for the management system to learn how
// many positions are available (e.g., occupied vs. empty
// linecard slots in a chassis).
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/empty"
// Path from root: "/components/component/state/empty"
func (n *ComponentPathAny) Empty() *Component_EmptyPathAny {
	return &Component_EmptyPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "empty"},
			map[string]interface{}{},
			n,
		),
	}
}

// EquipmentFailure (leaf): If true, the hardware indicates that the component's physical equipment
// has failed
// ----------------------------------------
// Defining module: "openconfig-alarms"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/equipment-failure"
// Path from root: "/components/component/state/equipment-failure"
func (n *ComponentPath) EquipmentFailure() *Component_EquipmentFailurePath {
	return &Component_EquipmentFailurePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "equipment-failure"},
			map[string]interface{}{},
			n,
		),
	}
}

// EquipmentFailure (leaf): If true, the hardware indicates that the component's physical equipment
// has failed
// ----------------------------------------
// Defining module: "openconfig-alarms"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/equipment-failure"
// Path from root: "/components/component/state/equipment-failure"
func (n *ComponentPathAny) EquipmentFailure() *Component_EquipmentFailurePathAny {
	return &Component_EquipmentFailurePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "equipment-failure"},
			map[string]interface{}{},
			n,
		),
	}
}

// EquipmentMismatch (leaf): If true, the hardware indicates that the component inserted into the
// affected component's physical location is of a different type than what
// is configured
// ----------------------------------------
// Defining module: "openconfig-alarms"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/equipment-mismatch"
// Path from root: "/components/component/state/equipment-mismatch"
func (n *ComponentPath) EquipmentMismatch() *Component_EquipmentMismatchPath {
	return &Component_EquipmentMismatchPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "equipment-mismatch"},
			map[string]interface{}{},
			n,
		),
	}
}

// EquipmentMismatch (leaf): If true, the hardware indicates that the component inserted into the
// affected component's physical location is of a different type than what
// is configured
// ----------------------------------------
// Defining module: "openconfig-alarms"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/equipment-mismatch"
// Path from root: "/components/component/state/equipment-mismatch"
func (n *ComponentPathAny) EquipmentMismatch() *Component_EquipmentMismatchPathAny {
	return &Component_EquipmentMismatchPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "equipment-mismatch"},
			map[string]interface{}{},
			n,
		),
	}
}

// Fabric (container): Data for fabric components
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "fabric"
// Path from root: "/components/component/fabric"
func (n *ComponentPath) Fabric() *Component_FabricPath {
	return &Component_FabricPath{
		NodePath: ygot.NewNodePath(
			[]string{"fabric"},
			map[string]interface{}{},
			n,
		),
	}
}

// Fabric (container): Data for fabric components
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "fabric"
// Path from root: "/components/component/fabric"
func (n *ComponentPathAny) Fabric() *Component_FabricPathAny {
	return &Component_FabricPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"fabric"},
			map[string]interface{}{},
			n,
		),
	}
}

// Fan (container): Data for fan components
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "fan"
// Path from root: "/components/component/fan"
func (n *ComponentPath) Fan() *Component_FanPath {
	return &Component_FanPath{
		NodePath: ygot.NewNodePath(
			[]string{"fan"},
			map[string]interface{}{},
			n,
		),
	}
}

// Fan (container): Data for fan components
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "fan"
// Path from root: "/components/component/fan"
func (n *ComponentPathAny) Fan() *Component_FanPathAny {
	return &Component_FanPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"fan"},
			map[string]interface{}{},
			n,
		),
	}
}

// FirmwareVersion (leaf): For hardware components, this is the version of associated
// firmware that is running on the component, if applicable.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/firmware-version"
// Path from root: "/components/component/state/firmware-version"
func (n *ComponentPath) FirmwareVersion() *Component_FirmwareVersionPath {
	return &Component_FirmwareVersionPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "firmware-version"},
			map[string]interface{}{},
			n,
		),
	}
}

// FirmwareVersion (leaf): For hardware components, this is the version of associated
// firmware that is running on the component, if applicable.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/firmware-version"
// Path from root: "/components/component/state/firmware-version"
func (n *ComponentPathAny) FirmwareVersion() *Component_FirmwareVersionPathAny {
	return &Component_FirmwareVersionPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "firmware-version"},
			map[string]interface{}{},
			n,
		),
	}
}

// HardwareVersion (leaf): For hardware components, this is the hardware revision of
// the component.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/hardware-version"
// Path from root: "/components/component/state/hardware-version"
func (n *ComponentPath) HardwareVersion() *Component_HardwareVersionPath {
	return &Component_HardwareVersionPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "hardware-version"},
			map[string]interface{}{},
			n,
		),
	}
}

// HardwareVersion (leaf): For hardware components, this is the hardware revision of
// the component.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/hardware-version"
// Path from root: "/components/component/state/hardware-version"
func (n *ComponentPathAny) HardwareVersion() *Component_HardwareVersionPathAny {
	return &Component_HardwareVersionPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "hardware-version"},
			map[string]interface{}{},
			n,
		),
	}
}

// Id (leaf): Unique identifier assigned by the system for the
// component
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/id"
// Path from root: "/components/component/state/id"
func (n *ComponentPath) Id() *Component_IdPath {
	return &Component_IdPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "id"},
			map[string]interface{}{},
			n,
		),
	}
}

// Id (leaf): Unique identifier assigned by the system for the
// component
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/id"
// Path from root: "/components/component/state/id"
func (n *ComponentPathAny) Id() *Component_IdPathAny {
	return &Component_IdPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "id"},
			map[string]interface{}{},
			n,
		),
	}
}

// IntegratedCircuit (container): Data for chip components, such as ASIC, NPUs, etc.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "integrated-circuit"
// Path from root: "/components/component/integrated-circuit"
func (n *ComponentPath) IntegratedCircuit() *Component_IntegratedCircuitPath {
	return &Component_IntegratedCircuitPath{
		NodePath: ygot.NewNodePath(
			[]string{"integrated-circuit"},
			map[string]interface{}{},
			n,
		),
	}
}

// IntegratedCircuit (container): Data for chip components, such as ASIC, NPUs, etc.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "integrated-circuit"
// Path from root: "/components/component/integrated-circuit"
func (n *ComponentPathAny) IntegratedCircuit() *Component_IntegratedCircuitPathAny {
	return &Component_IntegratedCircuitPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"integrated-circuit"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastRebootReason (leaf): This reports the reason of the last reboot of the component.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/last-reboot-reason"
// Path from root: "/components/component/state/last-reboot-reason"
func (n *ComponentPath) LastRebootReason() *Component_LastRebootReasonPath {
	return &Component_LastRebootReasonPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "last-reboot-reason"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastRebootReason (leaf): This reports the reason of the last reboot of the component.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/last-reboot-reason"
// Path from root: "/components/component/state/last-reboot-reason"
func (n *ComponentPathAny) LastRebootReason() *Component_LastRebootReasonPathAny {
	return &Component_LastRebootReasonPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "last-reboot-reason"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastRebootTime (leaf): This reports the time of the last reboot of the component. The
// value is the timestamp in nanoseconds relative to the Unix Epoch
// (Jan 1, 1970 00:00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/last-reboot-time"
// Path from root: "/components/component/state/last-reboot-time"
func (n *ComponentPath) LastRebootTime() *Component_LastRebootTimePath {
	return &Component_LastRebootTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "last-reboot-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastRebootTime (leaf): This reports the time of the last reboot of the component. The
// value is the timestamp in nanoseconds relative to the Unix Epoch
// (Jan 1, 1970 00:00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/last-reboot-time"
// Path from root: "/components/component/state/last-reboot-time"
func (n *ComponentPathAny) LastRebootTime() *Component_LastRebootTimePathAny {
	return &Component_LastRebootTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "last-reboot-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastSwitchoverReason (container): For components that have redundant roles (e.g. two
// supervisors in a device, one as primary the other as secondary),
// this reports the reason of the last change of the
// component's role.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/last-switchover-reason"
// Path from root: "/components/component/state/last-switchover-reason"
func (n *ComponentPath) LastSwitchoverReason() *Component_LastSwitchoverReasonPath {
	return &Component_LastSwitchoverReasonPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "last-switchover-reason"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastSwitchoverReason (container): For components that have redundant roles (e.g. two
// supervisors in a device, one as primary the other as secondary),
// this reports the reason of the last change of the
// component's role.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/last-switchover-reason"
// Path from root: "/components/component/state/last-switchover-reason"
func (n *ComponentPathAny) LastSwitchoverReason() *Component_LastSwitchoverReasonPathAny {
	return &Component_LastSwitchoverReasonPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "last-switchover-reason"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastSwitchoverTime (leaf): For components that have redundant roles (e.g. two
// supervisors in a device, one as primary the other as
// secondary), this reports the time of the last change of
// the component's role. The value is the timestamp in
// nanoseconds relative to the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/last-switchover-time"
// Path from root: "/components/component/state/last-switchover-time"
func (n *ComponentPath) LastSwitchoverTime() *Component_LastSwitchoverTimePath {
	return &Component_LastSwitchoverTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "last-switchover-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastSwitchoverTime (leaf): For components that have redundant roles (e.g. two
// supervisors in a device, one as primary the other as
// secondary), this reports the time of the last change of
// the component's role. The value is the timestamp in
// nanoseconds relative to the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/last-switchover-time"
// Path from root: "/components/component/state/last-switchover-time"
func (n *ComponentPathAny) LastSwitchoverTime() *Component_LastSwitchoverTimePathAny {
	return &Component_LastSwitchoverTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "last-switchover-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Location (leaf): System-supplied description of the location of the
// component within the system. This could be a bay position,
// slot number, socket location, etc. For component types that
// have an explicit slot-id attribute, such as linecards, the
// system should populate the more specific slot-id.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/location"
// Path from root: "/components/component/state/location"
func (n *ComponentPath) Location() *Component_LocationPath {
	return &Component_LocationPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "location"},
			map[string]interface{}{},
			n,
		),
	}
}

// Location (leaf): System-supplied description of the location of the
// component within the system. This could be a bay position,
// slot number, socket location, etc. For component types that
// have an explicit slot-id attribute, such as linecards, the
// system should populate the more specific slot-id.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/location"
// Path from root: "/components/component/state/location"
func (n *ComponentPathAny) Location() *Component_LocationPathAny {
	return &Component_LocationPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "location"},
			map[string]interface{}{},
			n,
		),
	}
}

// Memory (container): For components that have associated memory, these values
// report information about available and utilized memory.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/memory"
// Path from root: "/components/component/state/memory"
func (n *ComponentPath) Memory() *Component_MemoryPath {
	return &Component_MemoryPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "memory"},
			map[string]interface{}{},
			n,
		),
	}
}

// Memory (container): For components that have associated memory, these values
// report information about available and utilized memory.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/memory"
// Path from root: "/components/component/state/memory"
func (n *ComponentPathAny) Memory() *Component_MemoryPathAny {
	return &Component_MemoryPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "memory"},
			map[string]interface{}{},
			n,
		),
	}
}

// MfgDate (leaf): System-supplied representation of the component's
// manufacturing date.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/mfg-date"
// Path from root: "/components/component/state/mfg-date"
func (n *ComponentPath) MfgDate() *Component_MfgDatePath {
	return &Component_MfgDatePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "mfg-date"},
			map[string]interface{}{},
			n,
		),
	}
}

// MfgDate (leaf): System-supplied representation of the component's
// manufacturing date.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/mfg-date"
// Path from root: "/components/component/state/mfg-date"
func (n *ComponentPathAny) MfgDate() *Component_MfgDatePathAny {
	return &Component_MfgDatePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "mfg-date"},
			map[string]interface{}{},
			n,
		),
	}
}

// MfgName (leaf): System-supplied identifier for the manufacturer of the
// component.  This data is particularly useful when a
// component manufacturer is different than the overall
// device vendor.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/mfg-name"
// Path from root: "/components/component/state/mfg-name"
func (n *ComponentPath) MfgName() *Component_MfgNamePath {
	return &Component_MfgNamePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "mfg-name"},
			map[string]interface{}{},
			n,
		),
	}
}

// MfgName (leaf): System-supplied identifier for the manufacturer of the
// component.  This data is particularly useful when a
// component manufacturer is different than the overall
// device vendor.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/mfg-name"
// Path from root: "/components/component/state/mfg-name"
func (n *ComponentPathAny) MfgName() *Component_MfgNamePathAny {
	return &Component_MfgNamePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "mfg-name"},
			map[string]interface{}{},
			n,
		),
	}
}

// ModelName (leaf): A human readable string describing the model of a component.
// This string is optional and should only be populated if part-no
// is also populated.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/model-name"
// Path from root: "/components/component/state/model-name"
func (n *ComponentPath) ModelName() *Component_ModelNamePath {
	return &Component_ModelNamePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "model-name"},
			map[string]interface{}{},
			n,
		),
	}
}

// ModelName (leaf): A human readable string describing the model of a component.
// This string is optional and should only be populated if part-no
// is also populated.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/model-name"
// Path from root: "/components/component/state/model-name"
func (n *ComponentPathAny) ModelName() *Component_ModelNamePathAny {
	return &Component_ModelNamePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "model-name"},
			map[string]interface{}{},
			n,
		),
	}
}

// Name (leaf): Device name for the component -- this may not be a
// configurable parameter on many implementations.  Where
// component preconfiguration is supported, for example,
// the component name may be configurable.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/name"
// Path from root: "/components/component/config/name"
func (n *ComponentPath) Name() *Component_NamePath {
	return &Component_NamePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "name"},
			map[string]interface{}{},
			n,
		),
	}
}

// Name (leaf): Device name for the component -- this may not be a
// configurable parameter on many implementations.  Where
// component preconfiguration is supported, for example,
// the component name may be configurable.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/name"
// Path from root: "/components/component/config/name"
func (n *ComponentPathAny) Name() *Component_NamePathAny {
	return &Component_NamePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "name"},
			map[string]interface{}{},
			n,
		),
	}
}

// OperStatus (leaf): If applicable, this reports the current operational status
// of the component.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/oper-status"
// Path from root: "/components/component/state/oper-status"
func (n *ComponentPath) OperStatus() *Component_OperStatusPath {
	return &Component_OperStatusPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "oper-status"},
			map[string]interface{}{},
			n,
		),
	}
}

// OperStatus (leaf): If applicable, this reports the current operational status
// of the component.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/oper-status"
// Path from root: "/components/component/state/oper-status"
func (n *ComponentPathAny) OperStatus() *Component_OperStatusPathAny {
	return &Component_OperStatusPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "oper-status"},
			map[string]interface{}{},
			n,
		),
	}
}

// OpticalChannel (container): Enclosing container for the list of optical channels
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "optical-channel"
// Path from root: "/components/component/optical-channel"
func (n *ComponentPath) OpticalChannel() *Component_OpticalChannelPath {
	return &Component_OpticalChannelPath{
		NodePath: ygot.NewNodePath(
			[]string{"optical-channel"},
			map[string]interface{}{},
			n,
		),
	}
}

// OpticalChannel (container): Enclosing container for the list of optical channels
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "optical-channel"
// Path from root: "/components/component/optical-channel"
func (n *ComponentPathAny) OpticalChannel() *Component_OpticalChannelPathAny {
	return &Component_OpticalChannelPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"optical-channel"},
			map[string]interface{}{},
			n,
		),
	}
}

// Parent (leaf): Reference to the name of the parent component.  Note that
// this reference must be kept synchronized with the
// corresponding subcomponent reference from the parent
// component.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/parent"
// Path from root: "/components/component/state/parent"
func (n *ComponentPath) Parent() *Component_ParentPath {
	return &Component_ParentPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "parent"},
			map[string]interface{}{},
			n,
		),
	}
}

// Parent (leaf): Reference to the name of the parent component.  Note that
// this reference must be kept synchronized with the
// corresponding subcomponent reference from the parent
// component.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/parent"
// Path from root: "/components/component/state/parent"
func (n *ComponentPathAny) Parent() *Component_ParentPathAny {
	return &Component_ParentPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "parent"},
			map[string]interface{}{},
			n,
		),
	}
}

// PartNo (leaf): System-assigned part number for the component.  This should
// be present in particular if the component is also an FRU
// (field replaceable unit)
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/part-no"
// Path from root: "/components/component/state/part-no"
func (n *ComponentPath) PartNo() *Component_PartNoPath {
	return &Component_PartNoPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "part-no"},
			map[string]interface{}{},
			n,
		),
	}
}

// PartNo (leaf): System-assigned part number for the component.  This should
// be present in particular if the component is also an FRU
// (field replaceable unit)
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/part-no"
// Path from root: "/components/component/state/part-no"
func (n *ComponentPathAny) PartNo() *Component_PartNoPathAny {
	return &Component_PartNoPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "part-no"},
			map[string]interface{}{},
			n,
		),
	}
}

// Pcie (container): Components that are connected to the system over the Peripheral
// Component Interconnect Express (PCIe), report the fatal, non-fatal
// and correctable PCIe error counts.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/pcie"
// Path from root: "/components/component/state/pcie"
func (n *ComponentPath) Pcie() *Component_PciePath {
	return &Component_PciePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "pcie"},
			map[string]interface{}{},
			n,
		),
	}
}

// Pcie (container): Components that are connected to the system over the Peripheral
// Component Interconnect Express (PCIe), report the fatal, non-fatal
// and correctable PCIe error counts.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/pcie"
// Path from root: "/components/component/state/pcie"
func (n *ComponentPathAny) Pcie() *Component_PciePathAny {
	return &Component_PciePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "pcie"},
			map[string]interface{}{},
			n,
		),
	}
}

// Port (container): Data for physical port components
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "port"
// Path from root: "/components/component/port"
func (n *ComponentPath) Port() *Component_PortPath {
	return &Component_PortPath{
		NodePath: ygot.NewNodePath(
			[]string{"port"},
			map[string]interface{}{},
			n,
		),
	}
}

// Port (container): Data for physical port components
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "port"
// Path from root: "/components/component/port"
func (n *ComponentPathAny) Port() *Component_PortPathAny {
	return &Component_PortPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"port"},
			map[string]interface{}{},
			n,
		),
	}
}

// PowerSupply (container): Data for power supply components
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "power-supply"
// Path from root: "/components/component/power-supply"
func (n *ComponentPath) PowerSupply() *Component_PowerSupplyPath {
	return &Component_PowerSupplyPath{
		NodePath: ygot.NewNodePath(
			[]string{"power-supply"},
			map[string]interface{}{},
			n,
		),
	}
}

// PowerSupply (container): Data for power supply components
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "power-supply"
// Path from root: "/components/component/power-supply"
func (n *ComponentPathAny) PowerSupply() *Component_PowerSupplyPathAny {
	return &Component_PowerSupplyPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"power-supply"},
			map[string]interface{}{},
			n,
		),
	}
}

// PropertyAny (list): List of system properties for the component
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "properties/property"
// Path from root: "/components/component/properties/property"
// Name (wildcarded): string
func (n *ComponentPath) PropertyAny() *Component_PropertyPathAny {
	return &Component_PropertyPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"properties", "property"},
			map[string]interface{}{"name": "*"},
			n,
		),
	}
}

// PropertyAny (list): List of system properties for the component
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "properties/property"
// Path from root: "/components/component/properties/property"
// Name (wildcarded): string
func (n *ComponentPathAny) PropertyAny() *Component_PropertyPathAny {
	return &Component_PropertyPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"properties", "property"},
			map[string]interface{}{"name": "*"},
			n,
		),
	}
}

// Property (list): List of system properties for the component
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "properties/property"
// Path from root: "/components/component/properties/property"
// Name: string
func (n *ComponentPath) Property(Name string) *Component_PropertyPath {
	return &Component_PropertyPath{
		NodePath: ygot.NewNodePath(
			[]string{"properties", "property"},
			map[string]interface{}{"name": Name},
			n,
		),
	}
}

// Property (list): List of system properties for the component
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "properties/property"
// Path from root: "/components/component/properties/property"
// Name: string
func (n *ComponentPathAny) Property(Name string) *Component_PropertyPathAny {
	return &Component_PropertyPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"properties", "property"},
			map[string]interface{}{"name": Name},
			n,
		),
	}
}

// RedundantRole (leaf): For components that have redundant roles (e.g. two
// supervisors in a device, one as primary the other as secondary),
// this reports the role of the component.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/redundant-role"
// Path from root: "/components/component/state/redundant-role"
func (n *ComponentPath) RedundantRole() *Component_RedundantRolePath {
	return &Component_RedundantRolePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "redundant-role"},
			map[string]interface{}{},
			n,
		),
	}
}

// RedundantRole (leaf): For components that have redundant roles (e.g. two
// supervisors in a device, one as primary the other as secondary),
// this reports the role of the component.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/redundant-role"
// Path from root: "/components/component/state/redundant-role"
func (n *ComponentPathAny) RedundantRole() *Component_RedundantRolePathAny {
	return &Component_RedundantRolePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "redundant-role"},
			map[string]interface{}{},
			n,
		),
	}
}

// Removable (leaf): If true, this component is removable or is a field
// replaceable unit
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/removable"
// Path from root: "/components/component/state/removable"
func (n *ComponentPath) Removable() *Component_RemovablePath {
	return &Component_RemovablePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "removable"},
			map[string]interface{}{},
			n,
		),
	}
}

// Removable (leaf): If true, this component is removable or is a field
// replaceable unit
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/removable"
// Path from root: "/components/component/state/removable"
func (n *ComponentPathAny) Removable() *Component_RemovablePathAny {
	return &Component_RemovablePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "removable"},
			map[string]interface{}{},
			n,
		),
	}
}

// SerialNo (leaf): System-assigned serial number of the component.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/serial-no"
// Path from root: "/components/component/state/serial-no"
func (n *ComponentPath) SerialNo() *Component_SerialNoPath {
	return &Component_SerialNoPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "serial-no"},
			map[string]interface{}{},
			n,
		),
	}
}

// SerialNo (leaf): System-assigned serial number of the component.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/serial-no"
// Path from root: "/components/component/state/serial-no"
func (n *ComponentPathAny) SerialNo() *Component_SerialNoPathAny {
	return &Component_SerialNoPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "serial-no"},
			map[string]interface{}{},
			n,
		),
	}
}

// SoftwareModule (container): Data for software module components, i.e., for components
// with type=SOFTWARE_MODULE
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "software-module"
// Path from root: "/components/component/software-module"
func (n *ComponentPath) SoftwareModule() *Component_SoftwareModulePath {
	return &Component_SoftwareModulePath{
		NodePath: ygot.NewNodePath(
			[]string{"software-module"},
			map[string]interface{}{},
			n,
		),
	}
}

// SoftwareModule (container): Data for software module components, i.e., for components
// with type=SOFTWARE_MODULE
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "software-module"
// Path from root: "/components/component/software-module"
func (n *ComponentPathAny) SoftwareModule() *Component_SoftwareModulePathAny {
	return &Component_SoftwareModulePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"software-module"},
			map[string]interface{}{},
			n,
		),
	}
}

// SoftwareVersion (leaf): For software components such as operating system or other
// software module, this is the version of the currently
// running software.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/software-version"
// Path from root: "/components/component/state/software-version"
func (n *ComponentPath) SoftwareVersion() *Component_SoftwareVersionPath {
	return &Component_SoftwareVersionPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "software-version"},
			map[string]interface{}{},
			n,
		),
	}
}

// SoftwareVersion (leaf): For software components such as operating system or other
// software module, this is the version of the currently
// running software.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/software-version"
// Path from root: "/components/component/state/software-version"
func (n *ComponentPathAny) SoftwareVersion() *Component_SoftwareVersionPathAny {
	return &Component_SoftwareVersionPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "software-version"},
			map[string]interface{}{},
			n,
		),
	}
}

// Storage (container): Data for storage components
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "storage"
// Path from root: "/components/component/storage"
func (n *ComponentPath) Storage() *Component_StoragePath {
	return &Component_StoragePath{
		NodePath: ygot.NewNodePath(
			[]string{"storage"},
			map[string]interface{}{},
			n,
		),
	}
}

// Storage (container): Data for storage components
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "storage"
// Path from root: "/components/component/storage"
func (n *ComponentPathAny) Storage() *Component_StoragePathAny {
	return &Component_StoragePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"storage"},
			map[string]interface{}{},
			n,
		),
	}
}

// SubcomponentAny (list): List of subcomponent references
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "subcomponents/subcomponent"
// Path from root: "/components/component/subcomponents/subcomponent"
// Name (wildcarded): string
func (n *ComponentPath) SubcomponentAny() *Component_SubcomponentPathAny {
	return &Component_SubcomponentPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"subcomponents", "subcomponent"},
			map[string]interface{}{"name": "*"},
			n,
		),
	}
}

// SubcomponentAny (list): List of subcomponent references
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "subcomponents/subcomponent"
// Path from root: "/components/component/subcomponents/subcomponent"
// Name (wildcarded): string
func (n *ComponentPathAny) SubcomponentAny() *Component_SubcomponentPathAny {
	return &Component_SubcomponentPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"subcomponents", "subcomponent"},
			map[string]interface{}{"name": "*"},
			n,
		),
	}
}

// Subcomponent (list): List of subcomponent references
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "subcomponents/subcomponent"
// Path from root: "/components/component/subcomponents/subcomponent"
// Name: string
func (n *ComponentPath) Subcomponent(Name string) *Component_SubcomponentPath {
	return &Component_SubcomponentPath{
		NodePath: ygot.NewNodePath(
			[]string{"subcomponents", "subcomponent"},
			map[string]interface{}{"name": Name},
			n,
		),
	}
}

// Subcomponent (list): List of subcomponent references
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "subcomponents/subcomponent"
// Path from root: "/components/component/subcomponents/subcomponent"
// Name: string
func (n *ComponentPathAny) Subcomponent(Name string) *Component_SubcomponentPathAny {
	return &Component_SubcomponentPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"subcomponents", "subcomponent"},
			map[string]interface{}{"name": Name},
			n,
		),
	}
}

// SwitchoverReady (leaf): For components that have redundant roles, this reports a value
// that indicates if the component is ready to support failover.
//
// The components with a redundant-role should reflect the overall
// system's switchover status.  For example, two supervisors in a
// device, one as primary and the other as secondary, should both
// report the same value.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/switchover-ready"
// Path from root: "/components/component/state/switchover-ready"
func (n *ComponentPath) SwitchoverReady() *Component_SwitchoverReadyPath {
	return &Component_SwitchoverReadyPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "switchover-ready"},
			map[string]interface{}{},
			n,
		),
	}
}

// SwitchoverReady (leaf): For components that have redundant roles, this reports a value
// that indicates if the component is ready to support failover.
//
// The components with a redundant-role should reflect the overall
// system's switchover status.  For example, two supervisors in a
// device, one as primary and the other as secondary, should both
// report the same value.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/switchover-ready"
// Path from root: "/components/component/state/switchover-ready"
func (n *ComponentPathAny) SwitchoverReady() *Component_SwitchoverReadyPathAny {
	return &Component_SwitchoverReadyPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "switchover-ready"},
			map[string]interface{}{},
			n,
		),
	}
}

// Temperature (container): Temperature in degrees Celsius of the component. Values include
// the instantaneous, average, minimum, and maximum statistics. If
// avg/min/max statistics are not supported, the target is expected
// to just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/temperature"
// Path from root: "/components/component/state/temperature"
func (n *ComponentPath) Temperature() *Component_TemperaturePath {
	return &Component_TemperaturePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "temperature"},
			map[string]interface{}{},
			n,
		),
	}
}

// Temperature (container): Temperature in degrees Celsius of the component. Values include
// the instantaneous, average, minimum, and maximum statistics. If
// avg/min/max statistics are not supported, the target is expected
// to just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/temperature"
// Path from root: "/components/component/state/temperature"
func (n *ComponentPathAny) Temperature() *Component_TemperaturePathAny {
	return &Component_TemperaturePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "temperature"},
			map[string]interface{}{},
			n,
		),
	}
}

// Transceiver (container): Top-level container for client port transceiver data
// ----------------------------------------
// Defining module: "openconfig-platform-transceiver"
// Instantiating module: "openconfig-platform"
// Path from parent: "transceiver"
// Path from root: "/components/component/transceiver"
func (n *ComponentPath) Transceiver() *Component_TransceiverPath {
	return &Component_TransceiverPath{
		NodePath: ygot.NewNodePath(
			[]string{"transceiver"},
			map[string]interface{}{},
			n,
		),
	}
}

// Transceiver (container): Top-level container for client port transceiver data
// ----------------------------------------
// Defining module: "openconfig-platform-transceiver"
// Instantiating module: "openconfig-platform"
// Path from parent: "transceiver"
// Path from root: "/components/component/transceiver"
func (n *ComponentPathAny) Transceiver() *Component_TransceiverPathAny {
	return &Component_TransceiverPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"transceiver"},
			map[string]interface{}{},
			n,
		),
	}
}

// Type (leaf): Type of component as identified by the system
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/type"
// Path from root: "/components/component/state/type"
func (n *ComponentPath) Type() *Component_TypePath {
	return &Component_TypePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "type"},
			map[string]interface{}{},
			n,
		),
	}
}

// Type (leaf): Type of component as identified by the system
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/type"
// Path from root: "/components/component/state/type"
func (n *ComponentPathAny) Type() *Component_TypePathAny {
	return &Component_TypePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "type"},
			map[string]interface{}{},
			n,
		),
	}
}

// UsedPower (leaf): Actual power used by the component.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/used-power"
// Path from root: "/components/component/state/used-power"
func (n *ComponentPath) UsedPower() *Component_UsedPowerPath {
	return &Component_UsedPowerPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "used-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// UsedPower (leaf): Actual power used by the component.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/used-power"
// Path from root: "/components/component/state/used-power"
func (n *ComponentPathAny) UsedPower() *Component_UsedPowerPathAny {
	return &Component_UsedPowerPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "used-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_BackplanePath represents the /openconfig-platform/components/component/backplane YANG schema element.
type Component_BackplanePath struct {
	*ygot.NodePath
}

// Component_BackplanePathAny represents the wildcard version of the /openconfig-platform/components/component/backplane YANG schema element.
type Component_BackplanePathAny struct {
	*ygot.NodePath
}

// Component_ChassisPath represents the /openconfig-platform/components/component/chassis YANG schema element.
type Component_ChassisPath struct {
	*ygot.NodePath
}

// Component_ChassisPathAny represents the wildcard version of the /openconfig-platform/components/component/chassis YANG schema element.
type Component_ChassisPathAny struct {
	*ygot.NodePath
}

// Utilization (container): Resource utilization of the component.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "utilization"
// Path from root: "/components/component/chassis/utilization"
func (n *Component_ChassisPath) Utilization() *Component_Chassis_UtilizationPath {
	return &Component_Chassis_UtilizationPath{
		NodePath: ygot.NewNodePath(
			[]string{"utilization"},
			map[string]interface{}{},
			n,
		),
	}
}

// Utilization (container): Resource utilization of the component.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "utilization"
// Path from root: "/components/component/chassis/utilization"
func (n *Component_ChassisPathAny) Utilization() *Component_Chassis_UtilizationPathAny {
	return &Component_Chassis_UtilizationPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"utilization"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_Chassis_UtilizationPath represents the /openconfig-platform/components/component/chassis/utilization YANG schema element.
type Component_Chassis_UtilizationPath struct {
	*ygot.NodePath
}

// Component_Chassis_UtilizationPathAny represents the wildcard version of the /openconfig-platform/components/component/chassis/utilization YANG schema element.
type Component_Chassis_UtilizationPathAny struct {
	*ygot.NodePath
}

// ResourceAny (list): List of resources, keyed by resource name.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "resources/resource"
// Path from root: "/components/component/chassis/utilization/resources/resource"
// Name (wildcarded): string
func (n *Component_Chassis_UtilizationPath) ResourceAny() *Component_Chassis_Utilization_ResourcePathAny {
	return &Component_Chassis_Utilization_ResourcePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"resources", "resource"},
			map[string]interface{}{"name": "*"},
			n,
		),
	}
}

// ResourceAny (list): List of resources, keyed by resource name.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "resources/resource"
// Path from root: "/components/component/chassis/utilization/resources/resource"
// Name (wildcarded): string
func (n *Component_Chassis_UtilizationPathAny) ResourceAny() *Component_Chassis_Utilization_ResourcePathAny {
	return &Component_Chassis_Utilization_ResourcePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"resources", "resource"},
			map[string]interface{}{"name": "*"},
			n,
		),
	}
}

// Resource (list): List of resources, keyed by resource name.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "resources/resource"
// Path from root: "/components/component/chassis/utilization/resources/resource"
// Name: string
func (n *Component_Chassis_UtilizationPath) Resource(Name string) *Component_Chassis_Utilization_ResourcePath {
	return &Component_Chassis_Utilization_ResourcePath{
		NodePath: ygot.NewNodePath(
			[]string{"resources", "resource"},
			map[string]interface{}{"name": Name},
			n,
		),
	}
}

// Resource (list): List of resources, keyed by resource name.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "resources/resource"
// Path from root: "/components/component/chassis/utilization/resources/resource"
// Name: string
func (n *Component_Chassis_UtilizationPathAny) Resource(Name string) *Component_Chassis_Utilization_ResourcePathAny {
	return &Component_Chassis_Utilization_ResourcePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"resources", "resource"},
			map[string]interface{}{"name": Name},
			n,
		),
	}
}

// Component_Chassis_Utilization_ResourcePath represents the /openconfig-platform/components/component/chassis/utilization/resources/resource YANG schema element.
type Component_Chassis_Utilization_ResourcePath struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_ResourcePathAny represents the wildcard version of the /openconfig-platform/components/component/chassis/utilization/resources/resource YANG schema element.
type Component_Chassis_Utilization_ResourcePathAny struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_CommittedPath represents the /openconfig-platform/components/component/chassis/utilization/resources/resource/state/committed YANG schema element.
type Component_Chassis_Utilization_Resource_CommittedPath struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_CommittedPathAny represents the wildcard version of the /openconfig-platform/components/component/chassis/utilization/resources/resource/state/committed YANG schema element.
type Component_Chassis_Utilization_Resource_CommittedPathAny struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_FreePath represents the /openconfig-platform/components/component/chassis/utilization/resources/resource/state/free YANG schema element.
type Component_Chassis_Utilization_Resource_FreePath struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_FreePathAny represents the wildcard version of the /openconfig-platform/components/component/chassis/utilization/resources/resource/state/free YANG schema element.
type Component_Chassis_Utilization_Resource_FreePathAny struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_HighWatermarkPath represents the /openconfig-platform/components/component/chassis/utilization/resources/resource/state/high-watermark YANG schema element.
type Component_Chassis_Utilization_Resource_HighWatermarkPath struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_HighWatermarkPathAny represents the wildcard version of the /openconfig-platform/components/component/chassis/utilization/resources/resource/state/high-watermark YANG schema element.
type Component_Chassis_Utilization_Resource_HighWatermarkPathAny struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_LastHighWatermarkPath represents the /openconfig-platform/components/component/chassis/utilization/resources/resource/state/last-high-watermark YANG schema element.
type Component_Chassis_Utilization_Resource_LastHighWatermarkPath struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_LastHighWatermarkPathAny represents the wildcard version of the /openconfig-platform/components/component/chassis/utilization/resources/resource/state/last-high-watermark YANG schema element.
type Component_Chassis_Utilization_Resource_LastHighWatermarkPathAny struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_MaxLimitPath represents the /openconfig-platform/components/component/chassis/utilization/resources/resource/state/max-limit YANG schema element.
type Component_Chassis_Utilization_Resource_MaxLimitPath struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_MaxLimitPathAny represents the wildcard version of the /openconfig-platform/components/component/chassis/utilization/resources/resource/state/max-limit YANG schema element.
type Component_Chassis_Utilization_Resource_MaxLimitPathAny struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_NamePath represents the /openconfig-platform/components/component/chassis/utilization/resources/resource/config/name YANG schema element.
type Component_Chassis_Utilization_Resource_NamePath struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_NamePathAny represents the wildcard version of the /openconfig-platform/components/component/chassis/utilization/resources/resource/config/name YANG schema element.
type Component_Chassis_Utilization_Resource_NamePathAny struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_UsedPath represents the /openconfig-platform/components/component/chassis/utilization/resources/resource/state/used YANG schema element.
type Component_Chassis_Utilization_Resource_UsedPath struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_UsedPathAny represents the wildcard version of the /openconfig-platform/components/component/chassis/utilization/resources/resource/state/used YANG schema element.
type Component_Chassis_Utilization_Resource_UsedPathAny struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_UsedThresholdUpperPath represents the /openconfig-platform/components/component/chassis/utilization/resources/resource/config/used-threshold-upper YANG schema element.
type Component_Chassis_Utilization_Resource_UsedThresholdUpperPath struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_UsedThresholdUpperPathAny represents the wildcard version of the /openconfig-platform/components/component/chassis/utilization/resources/resource/config/used-threshold-upper YANG schema element.
type Component_Chassis_Utilization_Resource_UsedThresholdUpperPathAny struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_UsedThresholdUpperClearPath represents the /openconfig-platform/components/component/chassis/utilization/resources/resource/config/used-threshold-upper-clear YANG schema element.
type Component_Chassis_Utilization_Resource_UsedThresholdUpperClearPath struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_UsedThresholdUpperClearPathAny represents the wildcard version of the /openconfig-platform/components/component/chassis/utilization/resources/resource/config/used-threshold-upper-clear YANG schema element.
type Component_Chassis_Utilization_Resource_UsedThresholdUpperClearPathAny struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_UsedThresholdUpperExceededPath represents the /openconfig-platform/components/component/chassis/utilization/resources/resource/state/used-threshold-upper-exceeded YANG schema element.
type Component_Chassis_Utilization_Resource_UsedThresholdUpperExceededPath struct {
	*ygot.NodePath
}

// Component_Chassis_Utilization_Resource_UsedThresholdUpperExceededPathAny represents the wildcard version of the /openconfig-platform/components/component/chassis/utilization/resources/resource/state/used-threshold-upper-exceeded YANG schema element.
type Component_Chassis_Utilization_Resource_UsedThresholdUpperExceededPathAny struct {
	*ygot.NodePath
}

// Committed (leaf): Number of entries currently reserved for this resource. This is only
// relevant to tables which allocate a block of resource for a given
// feature.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/committed"
// Path from root: "/components/component/chassis/utilization/resources/resource/state/committed"
func (n *Component_Chassis_Utilization_ResourcePath) Committed() *Component_Chassis_Utilization_Resource_CommittedPath {
	return &Component_Chassis_Utilization_Resource_CommittedPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "committed"},
			map[string]interface{}{},
			n,
		),
	}
}

// Committed (leaf): Number of entries currently reserved for this resource. This is only
// relevant to tables which allocate a block of resource for a given
// feature.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/committed"
// Path from root: "/components/component/chassis/utilization/resources/resource/state/committed"
func (n *Component_Chassis_Utilization_ResourcePathAny) Committed() *Component_Chassis_Utilization_Resource_CommittedPathAny {
	return &Component_Chassis_Utilization_Resource_CommittedPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "committed"},
			map[string]interface{}{},
			n,
		),
	}
}

// Free (leaf): Number of entries available to use.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/free"
// Path from root: "/components/component/chassis/utilization/resources/resource/state/free"
func (n *Component_Chassis_Utilization_ResourcePath) Free() *Component_Chassis_Utilization_Resource_FreePath {
	return &Component_Chassis_Utilization_Resource_FreePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "free"},
			map[string]interface{}{},
			n,
		),
	}
}

// Free (leaf): Number of entries available to use.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/free"
// Path from root: "/components/component/chassis/utilization/resources/resource/state/free"
func (n *Component_Chassis_Utilization_ResourcePathAny) Free() *Component_Chassis_Utilization_Resource_FreePathAny {
	return &Component_Chassis_Utilization_Resource_FreePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "free"},
			map[string]interface{}{},
			n,
		),
	}
}

// HighWatermark (leaf): A watermark of highest number of entries used for this resource.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/high-watermark"
// Path from root: "/components/component/chassis/utilization/resources/resource/state/high-watermark"
func (n *Component_Chassis_Utilization_ResourcePath) HighWatermark() *Component_Chassis_Utilization_Resource_HighWatermarkPath {
	return &Component_Chassis_Utilization_Resource_HighWatermarkPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "high-watermark"},
			map[string]interface{}{},
			n,
		),
	}
}

// HighWatermark (leaf): A watermark of highest number of entries used for this resource.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/high-watermark"
// Path from root: "/components/component/chassis/utilization/resources/resource/state/high-watermark"
func (n *Component_Chassis_Utilization_ResourcePathAny) HighWatermark() *Component_Chassis_Utilization_Resource_HighWatermarkPathAny {
	return &Component_Chassis_Utilization_Resource_HighWatermarkPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "high-watermark"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastHighWatermark (leaf): The timestamp when the high-watermark was last updated. The value
// is the timestamp in nanoseconds relative to the Unix Epoch
// (Jan 1, 1970 00:00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/last-high-watermark"
// Path from root: "/components/component/chassis/utilization/resources/resource/state/last-high-watermark"
func (n *Component_Chassis_Utilization_ResourcePath) LastHighWatermark() *Component_Chassis_Utilization_Resource_LastHighWatermarkPath {
	return &Component_Chassis_Utilization_Resource_LastHighWatermarkPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "last-high-watermark"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastHighWatermark (leaf): The timestamp when the high-watermark was last updated. The value
// is the timestamp in nanoseconds relative to the Unix Epoch
// (Jan 1, 1970 00:00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/last-high-watermark"
// Path from root: "/components/component/chassis/utilization/resources/resource/state/last-high-watermark"
func (n *Component_Chassis_Utilization_ResourcePathAny) LastHighWatermark() *Component_Chassis_Utilization_Resource_LastHighWatermarkPathAny {
	return &Component_Chassis_Utilization_Resource_LastHighWatermarkPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "last-high-watermark"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxLimit (leaf): Maximum number of entries available for the resource. The value
// is the theoretical maximum resource utilization possible.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/max-limit"
// Path from root: "/components/component/chassis/utilization/resources/resource/state/max-limit"
func (n *Component_Chassis_Utilization_ResourcePath) MaxLimit() *Component_Chassis_Utilization_Resource_MaxLimitPath {
	return &Component_Chassis_Utilization_Resource_MaxLimitPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "max-limit"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxLimit (leaf): Maximum number of entries available for the resource. The value
// is the theoretical maximum resource utilization possible.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/max-limit"
// Path from root: "/components/component/chassis/utilization/resources/resource/state/max-limit"
func (n *Component_Chassis_Utilization_ResourcePathAny) MaxLimit() *Component_Chassis_Utilization_Resource_MaxLimitPathAny {
	return &Component_Chassis_Utilization_Resource_MaxLimitPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "max-limit"},
			map[string]interface{}{},
			n,
		),
	}
}

// Name (leaf): Resource name within the component.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/name"
// Path from root: "/components/component/chassis/utilization/resources/resource/config/name"
func (n *Component_Chassis_Utilization_ResourcePath) Name() *Component_Chassis_Utilization_Resource_NamePath {
	return &Component_Chassis_Utilization_Resource_NamePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "name"},
			map[string]interface{}{},
			n,
		),
	}
}

// Name (leaf): Resource name within the component.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/name"
// Path from root: "/components/component/chassis/utilization/resources/resource/config/name"
func (n *Component_Chassis_Utilization_ResourcePathAny) Name() *Component_Chassis_Utilization_Resource_NamePathAny {
	return &Component_Chassis_Utilization_Resource_NamePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "name"},
			map[string]interface{}{},
			n,
		),
	}
}

// Used (leaf): Number of entries currently in use for the resource.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/used"
// Path from root: "/components/component/chassis/utilization/resources/resource/state/used"
func (n *Component_Chassis_Utilization_ResourcePath) Used() *Component_Chassis_Utilization_Resource_UsedPath {
	return &Component_Chassis_Utilization_Resource_UsedPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "used"},
			map[string]interface{}{},
			n,
		),
	}
}

// Used (leaf): Number of entries currently in use for the resource.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/used"
// Path from root: "/components/component/chassis/utilization/resources/resource/state/used"
func (n *Component_Chassis_Utilization_ResourcePathAny) Used() *Component_Chassis_Utilization_Resource_UsedPathAny {
	return &Component_Chassis_Utilization_Resource_UsedPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "used"},
			map[string]interface{}{},
			n,
		),
	}
}

// UsedThresholdUpper (leaf): The used percentage value (used / (used + free) * 100) that
// when crossed will set utilization-threshold-exceeded to 'true'.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/used-threshold-upper"
// Path from root: "/components/component/chassis/utilization/resources/resource/config/used-threshold-upper"
func (n *Component_Chassis_Utilization_ResourcePath) UsedThresholdUpper() *Component_Chassis_Utilization_Resource_UsedThresholdUpperPath {
	return &Component_Chassis_Utilization_Resource_UsedThresholdUpperPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "used-threshold-upper"},
			map[string]interface{}{},
			n,
		),
	}
}

// UsedThresholdUpper (leaf): The used percentage value (used / (used + free) * 100) that
// when crossed will set utilization-threshold-exceeded to 'true'.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/used-threshold-upper"
// Path from root: "/components/component/chassis/utilization/resources/resource/config/used-threshold-upper"
func (n *Component_Chassis_Utilization_ResourcePathAny) UsedThresholdUpper() *Component_Chassis_Utilization_Resource_UsedThresholdUpperPathAny {
	return &Component_Chassis_Utilization_Resource_UsedThresholdUpperPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "used-threshold-upper"},
			map[string]interface{}{},
			n,
		),
	}
}

// UsedThresholdUpperClear (leaf): The used percentage value (used / (used + free) * 100) that when
// crossed will set utilization-threshold-exceeded to 'false'.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/used-threshold-upper-clear"
// Path from root: "/components/component/chassis/utilization/resources/resource/config/used-threshold-upper-clear"
func (n *Component_Chassis_Utilization_ResourcePath) UsedThresholdUpperClear() *Component_Chassis_Utilization_Resource_UsedThresholdUpperClearPath {
	return &Component_Chassis_Utilization_Resource_UsedThresholdUpperClearPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "used-threshold-upper-clear"},
			map[string]interface{}{},
			n,
		),
	}
}

// UsedThresholdUpperClear (leaf): The used percentage value (used / (used + free) * 100) that when
// crossed will set utilization-threshold-exceeded to 'false'.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/used-threshold-upper-clear"
// Path from root: "/components/component/chassis/utilization/resources/resource/config/used-threshold-upper-clear"
func (n *Component_Chassis_Utilization_ResourcePathAny) UsedThresholdUpperClear() *Component_Chassis_Utilization_Resource_UsedThresholdUpperClearPathAny {
	return &Component_Chassis_Utilization_Resource_UsedThresholdUpperClearPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "used-threshold-upper-clear"},
			map[string]interface{}{},
			n,
		),
	}
}

// UsedThresholdUpperExceeded (leaf): This value is set to true when the used percentage value
// (used / (used + free) * 100) has crossed the used-threshold-upper for this
// resource and false when the used percentage value has crossed the configured
// used-threshold-upper-clear value for this resource.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/used-threshold-upper-exceeded"
// Path from root: "/components/component/chassis/utilization/resources/resource/state/used-threshold-upper-exceeded"
func (n *Component_Chassis_Utilization_ResourcePath) UsedThresholdUpperExceeded() *Component_Chassis_Utilization_Resource_UsedThresholdUpperExceededPath {
	return &Component_Chassis_Utilization_Resource_UsedThresholdUpperExceededPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "used-threshold-upper-exceeded"},
			map[string]interface{}{},
			n,
		),
	}
}

// UsedThresholdUpperExceeded (leaf): This value is set to true when the used percentage value
// (used / (used + free) * 100) has crossed the used-threshold-upper for this
// resource and false when the used percentage value has crossed the configured
// used-threshold-upper-clear value for this resource.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/used-threshold-upper-exceeded"
// Path from root: "/components/component/chassis/utilization/resources/resource/state/used-threshold-upper-exceeded"
func (n *Component_Chassis_Utilization_ResourcePathAny) UsedThresholdUpperExceeded() *Component_Chassis_Utilization_Resource_UsedThresholdUpperExceededPathAny {
	return &Component_Chassis_Utilization_Resource_UsedThresholdUpperExceededPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "used-threshold-upper-exceeded"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_ControllerCardPath represents the /openconfig-platform/components/component/controller-card YANG schema element.
type Component_ControllerCardPath struct {
	*ygot.NodePath
}

// Component_ControllerCardPathAny represents the wildcard version of the /openconfig-platform/components/component/controller-card YANG schema element.
type Component_ControllerCardPathAny struct {
	*ygot.NodePath
}

// Component_CpuPath represents the /openconfig-platform/components/component/cpu YANG schema element.
type Component_CpuPath struct {
	*ygot.NodePath
}

// Component_CpuPathAny represents the wildcard version of the /openconfig-platform/components/component/cpu YANG schema element.
type Component_CpuPathAny struct {
	*ygot.NodePath
}

// Component_FabricPath represents the /openconfig-platform/components/component/fabric YANG schema element.
type Component_FabricPath struct {
	*ygot.NodePath
}

// Component_FabricPathAny represents the wildcard version of the /openconfig-platform/components/component/fabric YANG schema element.
type Component_FabricPathAny struct {
	*ygot.NodePath
}

// Component_FanPath represents the /openconfig-platform/components/component/fan YANG schema element.
type Component_FanPath struct {
	*ygot.NodePath
}

// Component_FanPathAny represents the wildcard version of the /openconfig-platform/components/component/fan YANG schema element.
type Component_FanPathAny struct {
	*ygot.NodePath
}

// Component_IntegratedCircuitPath represents the /openconfig-platform/components/component/integrated-circuit YANG schema element.
type Component_IntegratedCircuitPath struct {
	*ygot.NodePath
}

// Component_IntegratedCircuitPathAny represents the wildcard version of the /openconfig-platform/components/component/integrated-circuit YANG schema element.
type Component_IntegratedCircuitPathAny struct {
	*ygot.NodePath
}

// Utilization (container): Resource utilization of the component.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "utilization"
// Path from root: "/components/component/integrated-circuit/utilization"
func (n *Component_IntegratedCircuitPath) Utilization() *Component_IntegratedCircuit_UtilizationPath {
	return &Component_IntegratedCircuit_UtilizationPath{
		NodePath: ygot.NewNodePath(
			[]string{"utilization"},
			map[string]interface{}{},
			n,
		),
	}
}

// Utilization (container): Resource utilization of the component.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "utilization"
// Path from root: "/components/component/integrated-circuit/utilization"
func (n *Component_IntegratedCircuitPathAny) Utilization() *Component_IntegratedCircuit_UtilizationPathAny {
	return &Component_IntegratedCircuit_UtilizationPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"utilization"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_IntegratedCircuit_UtilizationPath represents the /openconfig-platform/components/component/integrated-circuit/utilization YANG schema element.
type Component_IntegratedCircuit_UtilizationPath struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_UtilizationPathAny represents the wildcard version of the /openconfig-platform/components/component/integrated-circuit/utilization YANG schema element.
type Component_IntegratedCircuit_UtilizationPathAny struct {
	*ygot.NodePath
}

// ResourceAny (list): List of resources, keyed by resource name.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "resources/resource"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource"
// Name (wildcarded): string
func (n *Component_IntegratedCircuit_UtilizationPath) ResourceAny() *Component_IntegratedCircuit_Utilization_ResourcePathAny {
	return &Component_IntegratedCircuit_Utilization_ResourcePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"resources", "resource"},
			map[string]interface{}{"name": "*"},
			n,
		),
	}
}

// ResourceAny (list): List of resources, keyed by resource name.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "resources/resource"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource"
// Name (wildcarded): string
func (n *Component_IntegratedCircuit_UtilizationPathAny) ResourceAny() *Component_IntegratedCircuit_Utilization_ResourcePathAny {
	return &Component_IntegratedCircuit_Utilization_ResourcePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"resources", "resource"},
			map[string]interface{}{"name": "*"},
			n,
		),
	}
}

// Resource (list): List of resources, keyed by resource name.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "resources/resource"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource"
// Name: string
func (n *Component_IntegratedCircuit_UtilizationPath) Resource(Name string) *Component_IntegratedCircuit_Utilization_ResourcePath {
	return &Component_IntegratedCircuit_Utilization_ResourcePath{
		NodePath: ygot.NewNodePath(
			[]string{"resources", "resource"},
			map[string]interface{}{"name": Name},
			n,
		),
	}
}

// Resource (list): List of resources, keyed by resource name.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "resources/resource"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource"
// Name: string
func (n *Component_IntegratedCircuit_UtilizationPathAny) Resource(Name string) *Component_IntegratedCircuit_Utilization_ResourcePathAny {
	return &Component_IntegratedCircuit_Utilization_ResourcePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"resources", "resource"},
			map[string]interface{}{"name": Name},
			n,
		),
	}
}

// Component_IntegratedCircuit_Utilization_ResourcePath represents the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource YANG schema element.
type Component_IntegratedCircuit_Utilization_ResourcePath struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_ResourcePathAny represents the wildcard version of the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource YANG schema element.
type Component_IntegratedCircuit_Utilization_ResourcePathAny struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_CommittedPath represents the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/state/committed YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_CommittedPath struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_CommittedPathAny represents the wildcard version of the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/state/committed YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_CommittedPathAny struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_FreePath represents the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/state/free YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_FreePath struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_FreePathAny represents the wildcard version of the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/state/free YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_FreePathAny struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_HighWatermarkPath represents the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/state/high-watermark YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_HighWatermarkPath struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_HighWatermarkPathAny represents the wildcard version of the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/state/high-watermark YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_HighWatermarkPathAny struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_LastHighWatermarkPath represents the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/state/last-high-watermark YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_LastHighWatermarkPath struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_LastHighWatermarkPathAny represents the wildcard version of the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/state/last-high-watermark YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_LastHighWatermarkPathAny struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_MaxLimitPath represents the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/state/max-limit YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_MaxLimitPath struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_MaxLimitPathAny represents the wildcard version of the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/state/max-limit YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_MaxLimitPathAny struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_NamePath represents the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/config/name YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_NamePath struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_NamePathAny represents the wildcard version of the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/config/name YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_NamePathAny struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_UsedPath represents the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/state/used YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_UsedPath struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_UsedPathAny represents the wildcard version of the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/state/used YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_UsedPathAny struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperPath represents the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/config/used-threshold-upper YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperPath struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperPathAny represents the wildcard version of the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/config/used-threshold-upper YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperPathAny struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperClearPath represents the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/config/used-threshold-upper-clear YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperClearPath struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperClearPathAny represents the wildcard version of the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/config/used-threshold-upper-clear YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperClearPathAny struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperExceededPath represents the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/state/used-threshold-upper-exceeded YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperExceededPath struct {
	*ygot.NodePath
}

// Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperExceededPathAny represents the wildcard version of the /openconfig-platform/components/component/integrated-circuit/utilization/resources/resource/state/used-threshold-upper-exceeded YANG schema element.
type Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperExceededPathAny struct {
	*ygot.NodePath
}

// Committed (leaf): Number of entries currently reserved for this resource. This is only
// relevant to tables which allocate a block of resource for a given
// feature.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/committed"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/state/committed"
func (n *Component_IntegratedCircuit_Utilization_ResourcePath) Committed() *Component_IntegratedCircuit_Utilization_Resource_CommittedPath {
	return &Component_IntegratedCircuit_Utilization_Resource_CommittedPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "committed"},
			map[string]interface{}{},
			n,
		),
	}
}

// Committed (leaf): Number of entries currently reserved for this resource. This is only
// relevant to tables which allocate a block of resource for a given
// feature.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/committed"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/state/committed"
func (n *Component_IntegratedCircuit_Utilization_ResourcePathAny) Committed() *Component_IntegratedCircuit_Utilization_Resource_CommittedPathAny {
	return &Component_IntegratedCircuit_Utilization_Resource_CommittedPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "committed"},
			map[string]interface{}{},
			n,
		),
	}
}

// Free (leaf): Number of entries available to use.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/free"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/state/free"
func (n *Component_IntegratedCircuit_Utilization_ResourcePath) Free() *Component_IntegratedCircuit_Utilization_Resource_FreePath {
	return &Component_IntegratedCircuit_Utilization_Resource_FreePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "free"},
			map[string]interface{}{},
			n,
		),
	}
}

// Free (leaf): Number of entries available to use.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/free"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/state/free"
func (n *Component_IntegratedCircuit_Utilization_ResourcePathAny) Free() *Component_IntegratedCircuit_Utilization_Resource_FreePathAny {
	return &Component_IntegratedCircuit_Utilization_Resource_FreePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "free"},
			map[string]interface{}{},
			n,
		),
	}
}

// HighWatermark (leaf): A watermark of highest number of entries used for this resource.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/high-watermark"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/state/high-watermark"
func (n *Component_IntegratedCircuit_Utilization_ResourcePath) HighWatermark() *Component_IntegratedCircuit_Utilization_Resource_HighWatermarkPath {
	return &Component_IntegratedCircuit_Utilization_Resource_HighWatermarkPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "high-watermark"},
			map[string]interface{}{},
			n,
		),
	}
}

// HighWatermark (leaf): A watermark of highest number of entries used for this resource.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/high-watermark"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/state/high-watermark"
func (n *Component_IntegratedCircuit_Utilization_ResourcePathAny) HighWatermark() *Component_IntegratedCircuit_Utilization_Resource_HighWatermarkPathAny {
	return &Component_IntegratedCircuit_Utilization_Resource_HighWatermarkPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "high-watermark"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastHighWatermark (leaf): The timestamp when the high-watermark was last updated. The value
// is the timestamp in nanoseconds relative to the Unix Epoch
// (Jan 1, 1970 00:00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/last-high-watermark"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/state/last-high-watermark"
func (n *Component_IntegratedCircuit_Utilization_ResourcePath) LastHighWatermark() *Component_IntegratedCircuit_Utilization_Resource_LastHighWatermarkPath {
	return &Component_IntegratedCircuit_Utilization_Resource_LastHighWatermarkPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "last-high-watermark"},
			map[string]interface{}{},
			n,
		),
	}
}

// LastHighWatermark (leaf): The timestamp when the high-watermark was last updated. The value
// is the timestamp in nanoseconds relative to the Unix Epoch
// (Jan 1, 1970 00:00:00 UTC).
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/last-high-watermark"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/state/last-high-watermark"
func (n *Component_IntegratedCircuit_Utilization_ResourcePathAny) LastHighWatermark() *Component_IntegratedCircuit_Utilization_Resource_LastHighWatermarkPathAny {
	return &Component_IntegratedCircuit_Utilization_Resource_LastHighWatermarkPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "last-high-watermark"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxLimit (leaf): Maximum number of entries available for the resource. The value
// is the theoretical maximum resource utilization possible.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/max-limit"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/state/max-limit"
func (n *Component_IntegratedCircuit_Utilization_ResourcePath) MaxLimit() *Component_IntegratedCircuit_Utilization_Resource_MaxLimitPath {
	return &Component_IntegratedCircuit_Utilization_Resource_MaxLimitPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "max-limit"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxLimit (leaf): Maximum number of entries available for the resource. The value
// is the theoretical maximum resource utilization possible.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/max-limit"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/state/max-limit"
func (n *Component_IntegratedCircuit_Utilization_ResourcePathAny) MaxLimit() *Component_IntegratedCircuit_Utilization_Resource_MaxLimitPathAny {
	return &Component_IntegratedCircuit_Utilization_Resource_MaxLimitPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "max-limit"},
			map[string]interface{}{},
			n,
		),
	}
}

// Name (leaf): Resource name within the component.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/name"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/config/name"
func (n *Component_IntegratedCircuit_Utilization_ResourcePath) Name() *Component_IntegratedCircuit_Utilization_Resource_NamePath {
	return &Component_IntegratedCircuit_Utilization_Resource_NamePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "name"},
			map[string]interface{}{},
			n,
		),
	}
}

// Name (leaf): Resource name within the component.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/name"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/config/name"
func (n *Component_IntegratedCircuit_Utilization_ResourcePathAny) Name() *Component_IntegratedCircuit_Utilization_Resource_NamePathAny {
	return &Component_IntegratedCircuit_Utilization_Resource_NamePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "name"},
			map[string]interface{}{},
			n,
		),
	}
}

// Used (leaf): Number of entries currently in use for the resource.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/used"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/state/used"
func (n *Component_IntegratedCircuit_Utilization_ResourcePath) Used() *Component_IntegratedCircuit_Utilization_Resource_UsedPath {
	return &Component_IntegratedCircuit_Utilization_Resource_UsedPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "used"},
			map[string]interface{}{},
			n,
		),
	}
}

// Used (leaf): Number of entries currently in use for the resource.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/used"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/state/used"
func (n *Component_IntegratedCircuit_Utilization_ResourcePathAny) Used() *Component_IntegratedCircuit_Utilization_Resource_UsedPathAny {
	return &Component_IntegratedCircuit_Utilization_Resource_UsedPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "used"},
			map[string]interface{}{},
			n,
		),
	}
}

// UsedThresholdUpper (leaf): The used percentage value (used / (used + free) * 100) that
// when crossed will set utilization-threshold-exceeded to 'true'.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/used-threshold-upper"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/config/used-threshold-upper"
func (n *Component_IntegratedCircuit_Utilization_ResourcePath) UsedThresholdUpper() *Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperPath {
	return &Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "used-threshold-upper"},
			map[string]interface{}{},
			n,
		),
	}
}

// UsedThresholdUpper (leaf): The used percentage value (used / (used + free) * 100) that
// when crossed will set utilization-threshold-exceeded to 'true'.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/used-threshold-upper"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/config/used-threshold-upper"
func (n *Component_IntegratedCircuit_Utilization_ResourcePathAny) UsedThresholdUpper() *Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperPathAny {
	return &Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "used-threshold-upper"},
			map[string]interface{}{},
			n,
		),
	}
}

// UsedThresholdUpperClear (leaf): The used percentage value (used / (used + free) * 100) that when
// crossed will set utilization-threshold-exceeded to 'false'.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/used-threshold-upper-clear"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/config/used-threshold-upper-clear"
func (n *Component_IntegratedCircuit_Utilization_ResourcePath) UsedThresholdUpperClear() *Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperClearPath {
	return &Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperClearPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "used-threshold-upper-clear"},
			map[string]interface{}{},
			n,
		),
	}
}

// UsedThresholdUpperClear (leaf): The used percentage value (used / (used + free) * 100) that when
// crossed will set utilization-threshold-exceeded to 'false'.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/used-threshold-upper-clear"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/config/used-threshold-upper-clear"
func (n *Component_IntegratedCircuit_Utilization_ResourcePathAny) UsedThresholdUpperClear() *Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperClearPathAny {
	return &Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperClearPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "used-threshold-upper-clear"},
			map[string]interface{}{},
			n,
		),
	}
}

// UsedThresholdUpperExceeded (leaf): This value is set to true when the used percentage value
// (used / (used + free) * 100) has crossed the used-threshold-upper for this
// resource and false when the used percentage value has crossed the configured
// used-threshold-upper-clear value for this resource.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/used-threshold-upper-exceeded"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/state/used-threshold-upper-exceeded"
func (n *Component_IntegratedCircuit_Utilization_ResourcePath) UsedThresholdUpperExceeded() *Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperExceededPath {
	return &Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperExceededPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "used-threshold-upper-exceeded"},
			map[string]interface{}{},
			n,
		),
	}
}

// UsedThresholdUpperExceeded (leaf): This value is set to true when the used percentage value
// (used / (used + free) * 100) has crossed the used-threshold-upper for this
// resource and false when the used percentage value has crossed the configured
// used-threshold-upper-clear value for this resource.
// ----------------------------------------
// Defining module: "openconfig-platform-common"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/used-threshold-upper-exceeded"
// Path from root: "/components/component/integrated-circuit/utilization/resources/resource/state/used-threshold-upper-exceeded"
func (n *Component_IntegratedCircuit_Utilization_ResourcePathAny) UsedThresholdUpperExceeded() *Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperExceededPathAny {
	return &Component_IntegratedCircuit_Utilization_Resource_UsedThresholdUpperExceededPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "used-threshold-upper-exceeded"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_LastSwitchoverReasonPath represents the /openconfig-platform/components/component/state/last-switchover-reason YANG schema element.
type Component_LastSwitchoverReasonPath struct {
	*ygot.NodePath
}

// Component_LastSwitchoverReasonPathAny represents the wildcard version of the /openconfig-platform/components/component/state/last-switchover-reason YANG schema element.
type Component_LastSwitchoverReasonPathAny struct {
	*ygot.NodePath
}

// Component_LastSwitchoverReason_DetailsPath represents the /openconfig-platform/components/component/state/last-switchover-reason/details YANG schema element.
type Component_LastSwitchoverReason_DetailsPath struct {
	*ygot.NodePath
}

// Component_LastSwitchoverReason_DetailsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/last-switchover-reason/details YANG schema element.
type Component_LastSwitchoverReason_DetailsPathAny struct {
	*ygot.NodePath
}

// Component_LastSwitchoverReason_TriggerPath represents the /openconfig-platform/components/component/state/last-switchover-reason/trigger YANG schema element.
type Component_LastSwitchoverReason_TriggerPath struct {
	*ygot.NodePath
}

// Component_LastSwitchoverReason_TriggerPathAny represents the wildcard version of the /openconfig-platform/components/component/state/last-switchover-reason/trigger YANG schema element.
type Component_LastSwitchoverReason_TriggerPathAny struct {
	*ygot.NodePath
}

// Details (leaf): Records detailed description of why the switchover happens.
// For example, when system initiated the switchover, this leaf
// can be used to record the specific reason, e.g. due to critical
// errors of the routing daemon in the primary role.
// ----------------------------------------
// Defining module: "openconfig-platform-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "details"
// Path from root: "/components/component/state/last-switchover-reason/details"
func (n *Component_LastSwitchoverReasonPath) Details() *Component_LastSwitchoverReason_DetailsPath {
	return &Component_LastSwitchoverReason_DetailsPath{
		NodePath: ygot.NewNodePath(
			[]string{"details"},
			map[string]interface{}{},
			n,
		),
	}
}

// Details (leaf): Records detailed description of why the switchover happens.
// For example, when system initiated the switchover, this leaf
// can be used to record the specific reason, e.g. due to critical
// errors of the routing daemon in the primary role.
// ----------------------------------------
// Defining module: "openconfig-platform-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "details"
// Path from root: "/components/component/state/last-switchover-reason/details"
func (n *Component_LastSwitchoverReasonPathAny) Details() *Component_LastSwitchoverReason_DetailsPathAny {
	return &Component_LastSwitchoverReason_DetailsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"details"},
			map[string]interface{}{},
			n,
		),
	}
}

// Trigger (leaf): Records the generic triggers, e.g. user or system
// initiated the switchover.
// ----------------------------------------
// Defining module: "openconfig-platform-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "trigger"
// Path from root: "/components/component/state/last-switchover-reason/trigger"
func (n *Component_LastSwitchoverReasonPath) Trigger() *Component_LastSwitchoverReason_TriggerPath {
	return &Component_LastSwitchoverReason_TriggerPath{
		NodePath: ygot.NewNodePath(
			[]string{"trigger"},
			map[string]interface{}{},
			n,
		),
	}
}

// Trigger (leaf): Records the generic triggers, e.g. user or system
// initiated the switchover.
// ----------------------------------------
// Defining module: "openconfig-platform-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "trigger"
// Path from root: "/components/component/state/last-switchover-reason/trigger"
func (n *Component_LastSwitchoverReasonPathAny) Trigger() *Component_LastSwitchoverReason_TriggerPathAny {
	return &Component_LastSwitchoverReason_TriggerPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"trigger"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_MemoryPath represents the /openconfig-platform/components/component/state/memory YANG schema element.
type Component_MemoryPath struct {
	*ygot.NodePath
}

// Component_MemoryPathAny represents the wildcard version of the /openconfig-platform/components/component/state/memory YANG schema element.
type Component_MemoryPathAny struct {
	*ygot.NodePath
}

// Component_Memory_AvailablePath represents the /openconfig-platform/components/component/state/memory/available YANG schema element.
type Component_Memory_AvailablePath struct {
	*ygot.NodePath
}

// Component_Memory_AvailablePathAny represents the wildcard version of the /openconfig-platform/components/component/state/memory/available YANG schema element.
type Component_Memory_AvailablePathAny struct {
	*ygot.NodePath
}

// Component_Memory_UtilizedPath represents the /openconfig-platform/components/component/state/memory/utilized YANG schema element.
type Component_Memory_UtilizedPath struct {
	*ygot.NodePath
}

// Component_Memory_UtilizedPathAny represents the wildcard version of the /openconfig-platform/components/component/state/memory/utilized YANG schema element.
type Component_Memory_UtilizedPathAny struct {
	*ygot.NodePath
}

// Available (leaf): The available memory physically installed, or logically
// allocated to the component.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "available"
// Path from root: "/components/component/state/memory/available"
func (n *Component_MemoryPath) Available() *Component_Memory_AvailablePath {
	return &Component_Memory_AvailablePath{
		NodePath: ygot.NewNodePath(
			[]string{"available"},
			map[string]interface{}{},
			n,
		),
	}
}

// Available (leaf): The available memory physically installed, or logically
// allocated to the component.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "available"
// Path from root: "/components/component/state/memory/available"
func (n *Component_MemoryPathAny) Available() *Component_Memory_AvailablePathAny {
	return &Component_Memory_AvailablePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"available"},
			map[string]interface{}{},
			n,
		),
	}
}

// Utilized (leaf): The memory currently in use by processes running on
// the component, not considering reserved memory that is
// not available for use.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "utilized"
// Path from root: "/components/component/state/memory/utilized"
func (n *Component_MemoryPath) Utilized() *Component_Memory_UtilizedPath {
	return &Component_Memory_UtilizedPath{
		NodePath: ygot.NewNodePath(
			[]string{"utilized"},
			map[string]interface{}{},
			n,
		),
	}
}

// Utilized (leaf): The memory currently in use by processes running on
// the component, not considering reserved memory that is
// not available for use.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "utilized"
// Path from root: "/components/component/state/memory/utilized"
func (n *Component_MemoryPathAny) Utilized() *Component_Memory_UtilizedPathAny {
	return &Component_Memory_UtilizedPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"utilized"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannelPath represents the /openconfig-platform/components/component/optical-channel YANG schema element.
type Component_OpticalChannelPath struct {
	*ygot.NodePath
}

// Component_OpticalChannelPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel YANG schema element.
type Component_OpticalChannelPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_FecUncorrectableBlocksPath represents the /openconfig-platform/components/component/optical-channel/state/fec-uncorrectable-blocks YANG schema element.
type Component_OpticalChannel_FecUncorrectableBlocksPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_FecUncorrectableBlocksPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/fec-uncorrectable-blocks YANG schema element.
type Component_OpticalChannel_FecUncorrectableBlocksPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_FrequencyPath represents the /openconfig-platform/components/component/optical-channel/config/frequency YANG schema element.
type Component_OpticalChannel_FrequencyPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_FrequencyPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/config/frequency YANG schema element.
type Component_OpticalChannel_FrequencyPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_GroupIdPath represents the /openconfig-platform/components/component/optical-channel/state/group-id YANG schema element.
type Component_OpticalChannel_GroupIdPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_GroupIdPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/group-id YANG schema element.
type Component_OpticalChannel_GroupIdPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_LinePortPath represents the /openconfig-platform/components/component/optical-channel/config/line-port YANG schema element.
type Component_OpticalChannel_LinePortPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_LinePortPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/config/line-port YANG schema element.
type Component_OpticalChannel_LinePortPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_OperationalModePath represents the /openconfig-platform/components/component/optical-channel/config/operational-mode YANG schema element.
type Component_OpticalChannel_OperationalModePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_OperationalModePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/config/operational-mode YANG schema element.
type Component_OpticalChannel_OperationalModePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_TargetOutputPowerPath represents the /openconfig-platform/components/component/optical-channel/config/target-output-power YANG schema element.
type Component_OpticalChannel_TargetOutputPowerPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_TargetOutputPowerPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/config/target-output-power YANG schema element.
type Component_OpticalChannel_TargetOutputPowerPathAny struct {
	*ygot.NodePath
}

// CarrierFrequencyOffset (container): Carrier frequency offset in MHz with 1 decimal precision.
// Values include the instantaneous, average, minimum, and
// maximum statistics. If avg/min/max statistics are not supported,
// the target is expected to just supply the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/carrier-frequency-offset"
// Path from root: "/components/component/optical-channel/state/carrier-frequency-offset"
func (n *Component_OpticalChannelPath) CarrierFrequencyOffset() *Component_OpticalChannel_CarrierFrequencyOffsetPath {
	return &Component_OpticalChannel_CarrierFrequencyOffsetPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "carrier-frequency-offset"},
			map[string]interface{}{},
			n,
		),
	}
}

// CarrierFrequencyOffset (container): Carrier frequency offset in MHz with 1 decimal precision.
// Values include the instantaneous, average, minimum, and
// maximum statistics. If avg/min/max statistics are not supported,
// the target is expected to just supply the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/carrier-frequency-offset"
// Path from root: "/components/component/optical-channel/state/carrier-frequency-offset"
func (n *Component_OpticalChannelPathAny) CarrierFrequencyOffset() *Component_OpticalChannel_CarrierFrequencyOffsetPathAny {
	return &Component_OpticalChannel_CarrierFrequencyOffsetPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "carrier-frequency-offset"},
			map[string]interface{}{},
			n,
		),
	}
}

// ChromaticDispersion (container): Chromatic Dispersion of an optical channel in
// picoseconds / nanometer (ps/nm) as reported by receiver
// with two decimal precision. Values include the instantaneous,
// average, minimum, and maximum statistics. If avg/min/max
// statistics are not supported, the target is expected to just
// supply the instant value
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/chromatic-dispersion"
// Path from root: "/components/component/optical-channel/state/chromatic-dispersion"
func (n *Component_OpticalChannelPath) ChromaticDispersion() *Component_OpticalChannel_ChromaticDispersionPath {
	return &Component_OpticalChannel_ChromaticDispersionPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "chromatic-dispersion"},
			map[string]interface{}{},
			n,
		),
	}
}

// ChromaticDispersion (container): Chromatic Dispersion of an optical channel in
// picoseconds / nanometer (ps/nm) as reported by receiver
// with two decimal precision. Values include the instantaneous,
// average, minimum, and maximum statistics. If avg/min/max
// statistics are not supported, the target is expected to just
// supply the instant value
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/chromatic-dispersion"
// Path from root: "/components/component/optical-channel/state/chromatic-dispersion"
func (n *Component_OpticalChannelPathAny) ChromaticDispersion() *Component_OpticalChannel_ChromaticDispersionPathAny {
	return &Component_OpticalChannel_ChromaticDispersionPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "chromatic-dispersion"},
			map[string]interface{}{},
			n,
		),
	}
}

// Esnr (container): Electrical signal to noise ratio. Baud rate
// normalized signal to noise ratio based on
// error vector magnitude in dB with two decimal
// precision. Values include the instantaneous, average,
// minimum, and maximum statistics. If avg/min/max
// statistics are not supported, the target is expected
// to just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/esnr"
// Path from root: "/components/component/optical-channel/state/esnr"
func (n *Component_OpticalChannelPath) Esnr() *Component_OpticalChannel_EsnrPath {
	return &Component_OpticalChannel_EsnrPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "esnr"},
			map[string]interface{}{},
			n,
		),
	}
}

// Esnr (container): Electrical signal to noise ratio. Baud rate
// normalized signal to noise ratio based on
// error vector magnitude in dB with two decimal
// precision. Values include the instantaneous, average,
// minimum, and maximum statistics. If avg/min/max
// statistics are not supported, the target is expected
// to just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/esnr"
// Path from root: "/components/component/optical-channel/state/esnr"
func (n *Component_OpticalChannelPathAny) Esnr() *Component_OpticalChannel_EsnrPathAny {
	return &Component_OpticalChannel_EsnrPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "esnr"},
			map[string]interface{}{},
			n,
		),
	}
}

// FecUncorrectableBlocks (leaf): The number of blocks or frames that were uncorrectable by
// the FEC
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/fec-uncorrectable-blocks"
// Path from root: "/components/component/optical-channel/state/fec-uncorrectable-blocks"
func (n *Component_OpticalChannelPath) FecUncorrectableBlocks() *Component_OpticalChannel_FecUncorrectableBlocksPath {
	return &Component_OpticalChannel_FecUncorrectableBlocksPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "fec-uncorrectable-blocks"},
			map[string]interface{}{},
			n,
		),
	}
}

// FecUncorrectableBlocks (leaf): The number of blocks or frames that were uncorrectable by
// the FEC
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/fec-uncorrectable-blocks"
// Path from root: "/components/component/optical-channel/state/fec-uncorrectable-blocks"
func (n *Component_OpticalChannelPathAny) FecUncorrectableBlocks() *Component_OpticalChannel_FecUncorrectableBlocksPathAny {
	return &Component_OpticalChannel_FecUncorrectableBlocksPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "fec-uncorrectable-blocks"},
			map[string]interface{}{},
			n,
		),
	}
}

// Frequency (leaf): Frequency of the optical channel, expressed in MHz
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/frequency"
// Path from root: "/components/component/optical-channel/config/frequency"
func (n *Component_OpticalChannelPath) Frequency() *Component_OpticalChannel_FrequencyPath {
	return &Component_OpticalChannel_FrequencyPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "frequency"},
			map[string]interface{}{},
			n,
		),
	}
}

// Frequency (leaf): Frequency of the optical channel, expressed in MHz
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/frequency"
// Path from root: "/components/component/optical-channel/config/frequency"
func (n *Component_OpticalChannelPathAny) Frequency() *Component_OpticalChannel_FrequencyPathAny {
	return &Component_OpticalChannel_FrequencyPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "frequency"},
			map[string]interface{}{},
			n,
		),
	}
}

// GroupId (leaf): If the device places constraints on which optical
// channels must be managed together (e.g., transmitted on the
// same line port), it can indicate that by setting the group-id
// to the same value across related optical channels.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/group-id"
// Path from root: "/components/component/optical-channel/state/group-id"
func (n *Component_OpticalChannelPath) GroupId() *Component_OpticalChannel_GroupIdPath {
	return &Component_OpticalChannel_GroupIdPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "group-id"},
			map[string]interface{}{},
			n,
		),
	}
}

// GroupId (leaf): If the device places constraints on which optical
// channels must be managed together (e.g., transmitted on the
// same line port), it can indicate that by setting the group-id
// to the same value across related optical channels.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/group-id"
// Path from root: "/components/component/optical-channel/state/group-id"
func (n *Component_OpticalChannelPathAny) GroupId() *Component_OpticalChannel_GroupIdPathAny {
	return &Component_OpticalChannel_GroupIdPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "group-id"},
			map[string]interface{}{},
			n,
		),
	}
}

// InputPower (container): The input optical power of a physical channel in units
// of 0.01dBm, which may be associated with individual
// physical channels, or an aggregate of multiple physical
// channels (i.e., for the overall transceiver). For an
// aggregate, this may be a measurement from a photodetector
// or a a calculation performed on the device by summing up
// all of the related individual physical channels.
// Values include the instantaneous, average, minimum, and
// maximum statistics. If avg/min/max statistics are not
// supported, the target is expected to just supply the
// instant value
// ----------------------------------------
// Defining module: "openconfig-platform-transceiver"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/input-power"
// Path from root: "/components/component/optical-channel/state/input-power"
func (n *Component_OpticalChannelPath) InputPower() *Component_OpticalChannel_InputPowerPath {
	return &Component_OpticalChannel_InputPowerPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "input-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// InputPower (container): The input optical power of a physical channel in units
// of 0.01dBm, which may be associated with individual
// physical channels, or an aggregate of multiple physical
// channels (i.e., for the overall transceiver). For an
// aggregate, this may be a measurement from a photodetector
// or a a calculation performed on the device by summing up
// all of the related individual physical channels.
// Values include the instantaneous, average, minimum, and
// maximum statistics. If avg/min/max statistics are not
// supported, the target is expected to just supply the
// instant value
// ----------------------------------------
// Defining module: "openconfig-platform-transceiver"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/input-power"
// Path from root: "/components/component/optical-channel/state/input-power"
func (n *Component_OpticalChannelPathAny) InputPower() *Component_OpticalChannel_InputPowerPathAny {
	return &Component_OpticalChannel_InputPowerPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "input-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// LaserBiasCurrent (container): The current applied by the system to the transmit laser to
// achieve the output power. The current is expressed in mA
// with up to two decimal precision. Values include the
// instantaneous, average, minimum, and maximum statistics.
// If avg/min/max statistics are not supported, the target is
// expected to just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-platform-transceiver"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/laser-bias-current"
// Path from root: "/components/component/optical-channel/state/laser-bias-current"
func (n *Component_OpticalChannelPath) LaserBiasCurrent() *Component_OpticalChannel_LaserBiasCurrentPath {
	return &Component_OpticalChannel_LaserBiasCurrentPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "laser-bias-current"},
			map[string]interface{}{},
			n,
		),
	}
}

// LaserBiasCurrent (container): The current applied by the system to the transmit laser to
// achieve the output power. The current is expressed in mA
// with up to two decimal precision. Values include the
// instantaneous, average, minimum, and maximum statistics.
// If avg/min/max statistics are not supported, the target is
// expected to just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-platform-transceiver"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/laser-bias-current"
// Path from root: "/components/component/optical-channel/state/laser-bias-current"
func (n *Component_OpticalChannelPathAny) LaserBiasCurrent() *Component_OpticalChannel_LaserBiasCurrentPathAny {
	return &Component_OpticalChannel_LaserBiasCurrentPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "laser-bias-current"},
			map[string]interface{}{},
			n,
		),
	}
}

// LinePort (leaf): Reference to the line-side physical port that carries
// this optical channel.  The target port should be
// a component in the physical inventory data model.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/line-port"
// Path from root: "/components/component/optical-channel/config/line-port"
func (n *Component_OpticalChannelPath) LinePort() *Component_OpticalChannel_LinePortPath {
	return &Component_OpticalChannel_LinePortPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "line-port"},
			map[string]interface{}{},
			n,
		),
	}
}

// LinePort (leaf): Reference to the line-side physical port that carries
// this optical channel.  The target port should be
// a component in the physical inventory data model.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/line-port"
// Path from root: "/components/component/optical-channel/config/line-port"
func (n *Component_OpticalChannelPathAny) LinePort() *Component_OpticalChannel_LinePortPathAny {
	return &Component_OpticalChannel_LinePortPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "line-port"},
			map[string]interface{}{},
			n,
		),
	}
}

// ModulationErrorRatio (container): Modulation error ratio in dB with two decimal precision. Values
// include the instantaneous, average, minimum, and maximum statistics.
// If avg/min/max statistics are not supported, the target is
// expected to just supply the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/modulation-error-ratio"
// Path from root: "/components/component/optical-channel/state/modulation-error-ratio"
func (n *Component_OpticalChannelPath) ModulationErrorRatio() *Component_OpticalChannel_ModulationErrorRatioPath {
	return &Component_OpticalChannel_ModulationErrorRatioPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "modulation-error-ratio"},
			map[string]interface{}{},
			n,
		),
	}
}

// ModulationErrorRatio (container): Modulation error ratio in dB with two decimal precision. Values
// include the instantaneous, average, minimum, and maximum statistics.
// If avg/min/max statistics are not supported, the target is
// expected to just supply the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/modulation-error-ratio"
// Path from root: "/components/component/optical-channel/state/modulation-error-ratio"
func (n *Component_OpticalChannelPathAny) ModulationErrorRatio() *Component_OpticalChannel_ModulationErrorRatioPathAny {
	return &Component_OpticalChannel_ModulationErrorRatioPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "modulation-error-ratio"},
			map[string]interface{}{},
			n,
		),
	}
}

// ModulatorBiasXPhase (container): The X-Phase bias of the coherent modulator. This is
// represented as a percentage with 2 decimal precision. This
// term is defined by OIF Implementation Agreement for
// Coherent CMIS. Values include the instantaneous, average,
// minimum, and maximum statistics. If avg/min/max statistics
// are not supported, the target is expected to just supply
// the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/modulator-bias-x-phase"
// Path from root: "/components/component/optical-channel/state/modulator-bias-x-phase"
func (n *Component_OpticalChannelPath) ModulatorBiasXPhase() *Component_OpticalChannel_ModulatorBiasXPhasePath {
	return &Component_OpticalChannel_ModulatorBiasXPhasePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "modulator-bias-x-phase"},
			map[string]interface{}{},
			n,
		),
	}
}

// ModulatorBiasXPhase (container): The X-Phase bias of the coherent modulator. This is
// represented as a percentage with 2 decimal precision. This
// term is defined by OIF Implementation Agreement for
// Coherent CMIS. Values include the instantaneous, average,
// minimum, and maximum statistics. If avg/min/max statistics
// are not supported, the target is expected to just supply
// the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/modulator-bias-x-phase"
// Path from root: "/components/component/optical-channel/state/modulator-bias-x-phase"
func (n *Component_OpticalChannelPathAny) ModulatorBiasXPhase() *Component_OpticalChannel_ModulatorBiasXPhasePathAny {
	return &Component_OpticalChannel_ModulatorBiasXPhasePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "modulator-bias-x-phase"},
			map[string]interface{}{},
			n,
		),
	}
}

// ModulatorBiasXi (container): The bias on in-phase path and Polarization X of
// the coherent modulator. This is represented as a percentage
// with 2 decimal precision. This term is defined by OIF
// Implementation Agreement for Coherent CMIS. Values include
// the instantaneous, average, minimum, and maximum statistics.
// If avg/min/max statistics are not supported, the target is
// expected to just supply the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/modulator-bias-xi"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xi"
func (n *Component_OpticalChannelPath) ModulatorBiasXi() *Component_OpticalChannel_ModulatorBiasXiPath {
	return &Component_OpticalChannel_ModulatorBiasXiPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "modulator-bias-xi"},
			map[string]interface{}{},
			n,
		),
	}
}

// ModulatorBiasXi (container): The bias on in-phase path and Polarization X of
// the coherent modulator. This is represented as a percentage
// with 2 decimal precision. This term is defined by OIF
// Implementation Agreement for Coherent CMIS. Values include
// the instantaneous, average, minimum, and maximum statistics.
// If avg/min/max statistics are not supported, the target is
// expected to just supply the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/modulator-bias-xi"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xi"
func (n *Component_OpticalChannelPathAny) ModulatorBiasXi() *Component_OpticalChannel_ModulatorBiasXiPathAny {
	return &Component_OpticalChannel_ModulatorBiasXiPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "modulator-bias-xi"},
			map[string]interface{}{},
			n,
		),
	}
}

// ModulatorBiasXq (container): The bias on quadrature path and Polarization X of
// the coherent modulator. This is represented as a percentage
// with 2 decimal precision. This term is defined by OIF
// Implementation Agreement for Coherent CMIS. Values include
// the instantaneous, average, minimum, and maximum statistics.
// If avg/min/max statistics are not supported, the target is
// expected to just supply the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/modulator-bias-xq"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xq"
func (n *Component_OpticalChannelPath) ModulatorBiasXq() *Component_OpticalChannel_ModulatorBiasXqPath {
	return &Component_OpticalChannel_ModulatorBiasXqPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "modulator-bias-xq"},
			map[string]interface{}{},
			n,
		),
	}
}

// ModulatorBiasXq (container): The bias on quadrature path and Polarization X of
// the coherent modulator. This is represented as a percentage
// with 2 decimal precision. This term is defined by OIF
// Implementation Agreement for Coherent CMIS. Values include
// the instantaneous, average, minimum, and maximum statistics.
// If avg/min/max statistics are not supported, the target is
// expected to just supply the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/modulator-bias-xq"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xq"
func (n *Component_OpticalChannelPathAny) ModulatorBiasXq() *Component_OpticalChannel_ModulatorBiasXqPathAny {
	return &Component_OpticalChannel_ModulatorBiasXqPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "modulator-bias-xq"},
			map[string]interface{}{},
			n,
		),
	}
}

// ModulatorBiasYPhase (container): The Y-Phase bias of the coherent modulator. This is
// represented as a percentage with 2 decimal precision. This
// term is defined by OIF Implementation Agreement for
// Coherent CMIS. Values include the instantaneous, average,
// minimum, and maximum statistics. If avg/min/max statistics
// are not supported, the target is expected to just supply
// the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/modulator-bias-y-phase"
// Path from root: "/components/component/optical-channel/state/modulator-bias-y-phase"
func (n *Component_OpticalChannelPath) ModulatorBiasYPhase() *Component_OpticalChannel_ModulatorBiasYPhasePath {
	return &Component_OpticalChannel_ModulatorBiasYPhasePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "modulator-bias-y-phase"},
			map[string]interface{}{},
			n,
		),
	}
}

// ModulatorBiasYPhase (container): The Y-Phase bias of the coherent modulator. This is
// represented as a percentage with 2 decimal precision. This
// term is defined by OIF Implementation Agreement for
// Coherent CMIS. Values include the instantaneous, average,
// minimum, and maximum statistics. If avg/min/max statistics
// are not supported, the target is expected to just supply
// the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/modulator-bias-y-phase"
// Path from root: "/components/component/optical-channel/state/modulator-bias-y-phase"
func (n *Component_OpticalChannelPathAny) ModulatorBiasYPhase() *Component_OpticalChannel_ModulatorBiasYPhasePathAny {
	return &Component_OpticalChannel_ModulatorBiasYPhasePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "modulator-bias-y-phase"},
			map[string]interface{}{},
			n,
		),
	}
}

// ModulatorBiasYi (container): The bias on in-phase path and Polarization Y of
// the coherent modulator. This is represented as a percentage
// with 2 decimal precision. This term is defined by OIF
// Implementation Agreement for Coherent CMIS. Values include
// the instantaneous, average, minimum, and maximum statistics.
// If avg/min/max statistics are not supported, the target is
// expected to just supply the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/modulator-bias-yi"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yi"
func (n *Component_OpticalChannelPath) ModulatorBiasYi() *Component_OpticalChannel_ModulatorBiasYiPath {
	return &Component_OpticalChannel_ModulatorBiasYiPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "modulator-bias-yi"},
			map[string]interface{}{},
			n,
		),
	}
}

// ModulatorBiasYi (container): The bias on in-phase path and Polarization Y of
// the coherent modulator. This is represented as a percentage
// with 2 decimal precision. This term is defined by OIF
// Implementation Agreement for Coherent CMIS. Values include
// the instantaneous, average, minimum, and maximum statistics.
// If avg/min/max statistics are not supported, the target is
// expected to just supply the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/modulator-bias-yi"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yi"
func (n *Component_OpticalChannelPathAny) ModulatorBiasYi() *Component_OpticalChannel_ModulatorBiasYiPathAny {
	return &Component_OpticalChannel_ModulatorBiasYiPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "modulator-bias-yi"},
			map[string]interface{}{},
			n,
		),
	}
}

// ModulatorBiasYq (container): The bias on quadrature path and Polarization Y of
// the coherent modulator. This is represented as a percentage
// with 2 decimal precision. This term is defined by OIF
// Implementation Agreement for Coherent CMIS. Values include
// the instantaneous, average, minimum, and maximum statistics.
// If avg/min/max statistics are not supported, the target is
// expected to just supply the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/modulator-bias-yq"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yq"
func (n *Component_OpticalChannelPath) ModulatorBiasYq() *Component_OpticalChannel_ModulatorBiasYqPath {
	return &Component_OpticalChannel_ModulatorBiasYqPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "modulator-bias-yq"},
			map[string]interface{}{},
			n,
		),
	}
}

// ModulatorBiasYq (container): The bias on quadrature path and Polarization Y of
// the coherent modulator. This is represented as a percentage
// with 2 decimal precision. This term is defined by OIF
// Implementation Agreement for Coherent CMIS. Values include
// the instantaneous, average, minimum, and maximum statistics.
// If avg/min/max statistics are not supported, the target is
// expected to just supply the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/modulator-bias-yq"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yq"
func (n *Component_OpticalChannelPathAny) ModulatorBiasYq() *Component_OpticalChannel_ModulatorBiasYqPathAny {
	return &Component_OpticalChannel_ModulatorBiasYqPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "modulator-bias-yq"},
			map[string]interface{}{},
			n,
		),
	}
}

// OperationalMode (leaf): Vendor-specific mode identifier -- sets the operational
// mode for the channel.  The specified operational mode must
// exist in the list of supported operational modes supplied
// by the device
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/operational-mode"
// Path from root: "/components/component/optical-channel/config/operational-mode"
func (n *Component_OpticalChannelPath) OperationalMode() *Component_OpticalChannel_OperationalModePath {
	return &Component_OpticalChannel_OperationalModePath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "operational-mode"},
			map[string]interface{}{},
			n,
		),
	}
}

// OperationalMode (leaf): Vendor-specific mode identifier -- sets the operational
// mode for the channel.  The specified operational mode must
// exist in the list of supported operational modes supplied
// by the device
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/operational-mode"
// Path from root: "/components/component/optical-channel/config/operational-mode"
func (n *Component_OpticalChannelPathAny) OperationalMode() *Component_OpticalChannel_OperationalModePathAny {
	return &Component_OpticalChannel_OperationalModePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "operational-mode"},
			map[string]interface{}{},
			n,
		),
	}
}

// Osnr (container): Optical signal to noise ratio at 12.5GHz noise bandwidth
// in dB with two decimal precision. Values include the
// instantaneous, average, minimum, and maximum statistics.
// If avg/min/max statistics are not supported, the target
// is expected to just supply the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/osnr"
// Path from root: "/components/component/optical-channel/state/osnr"
func (n *Component_OpticalChannelPath) Osnr() *Component_OpticalChannel_OsnrPath {
	return &Component_OpticalChannel_OsnrPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "osnr"},
			map[string]interface{}{},
			n,
		),
	}
}

// Osnr (container): Optical signal to noise ratio at 12.5GHz noise bandwidth
// in dB with two decimal precision. Values include the
// instantaneous, average, minimum, and maximum statistics.
// If avg/min/max statistics are not supported, the target
// is expected to just supply the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/osnr"
// Path from root: "/components/component/optical-channel/state/osnr"
func (n *Component_OpticalChannelPathAny) Osnr() *Component_OpticalChannel_OsnrPathAny {
	return &Component_OpticalChannel_OsnrPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "osnr"},
			map[string]interface{}{},
			n,
		),
	}
}

// OutputPower (container): The output optical power of a physical channel in units
// of 0.01dBm, which may be associated with individual
// physical channels, or an aggregate of multiple physical
// channels (i.e., for the overall transceiver). For an
// aggregate, this may be a measurement from a photodetector
// or a a calculation performed on the device by summing up
// all of the related individual physical channels.
// Values include the instantaneous, average, minimum, and
// maximum statistics. If avg/min/max statistics are not
// supported, the target is expected to just supply the
// instant value
// ----------------------------------------
// Defining module: "openconfig-platform-transceiver"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/output-power"
// Path from root: "/components/component/optical-channel/state/output-power"
func (n *Component_OpticalChannelPath) OutputPower() *Component_OpticalChannel_OutputPowerPath {
	return &Component_OpticalChannel_OutputPowerPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "output-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// OutputPower (container): The output optical power of a physical channel in units
// of 0.01dBm, which may be associated with individual
// physical channels, or an aggregate of multiple physical
// channels (i.e., for the overall transceiver). For an
// aggregate, this may be a measurement from a photodetector
// or a a calculation performed on the device by summing up
// all of the related individual physical channels.
// Values include the instantaneous, average, minimum, and
// maximum statistics. If avg/min/max statistics are not
// supported, the target is expected to just supply the
// instant value
// ----------------------------------------
// Defining module: "openconfig-platform-transceiver"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/output-power"
// Path from root: "/components/component/optical-channel/state/output-power"
func (n *Component_OpticalChannelPathAny) OutputPower() *Component_OpticalChannel_OutputPowerPathAny {
	return &Component_OpticalChannel_OutputPowerPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "output-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// PolarizationDependentLoss (container): Polarization Dependent Loss of an optical channel
// in dB as reported by receiver with two decimal precision.
// Values include the instantaneous, average, minimum, and
// maximum statistics. If avg/min/max statistics are not
// supported, the target is expected to just supply the
// instant value
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/polarization-dependent-loss"
// Path from root: "/components/component/optical-channel/state/polarization-dependent-loss"
func (n *Component_OpticalChannelPath) PolarizationDependentLoss() *Component_OpticalChannel_PolarizationDependentLossPath {
	return &Component_OpticalChannel_PolarizationDependentLossPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "polarization-dependent-loss"},
			map[string]interface{}{},
			n,
		),
	}
}

// PolarizationDependentLoss (container): Polarization Dependent Loss of an optical channel
// in dB as reported by receiver with two decimal precision.
// Values include the instantaneous, average, minimum, and
// maximum statistics. If avg/min/max statistics are not
// supported, the target is expected to just supply the
// instant value
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/polarization-dependent-loss"
// Path from root: "/components/component/optical-channel/state/polarization-dependent-loss"
func (n *Component_OpticalChannelPathAny) PolarizationDependentLoss() *Component_OpticalChannel_PolarizationDependentLossPathAny {
	return &Component_OpticalChannel_PolarizationDependentLossPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "polarization-dependent-loss"},
			map[string]interface{}{},
			n,
		),
	}
}

// PolarizationModeDispersion (container): Polarization Mode Dispersion of an optical channel
// in picosends (ps) as reported by receiver with two decimal
// precision. Values include the instantaneous, average,
// minimum, and maximum statistics. If avg/min/max statistics
// are not supported, the target is expected to just supply the
// instant value
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/polarization-mode-dispersion"
// Path from root: "/components/component/optical-channel/state/polarization-mode-dispersion"
func (n *Component_OpticalChannelPath) PolarizationModeDispersion() *Component_OpticalChannel_PolarizationModeDispersionPath {
	return &Component_OpticalChannel_PolarizationModeDispersionPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "polarization-mode-dispersion"},
			map[string]interface{}{},
			n,
		),
	}
}

// PolarizationModeDispersion (container): Polarization Mode Dispersion of an optical channel
// in picosends (ps) as reported by receiver with two decimal
// precision. Values include the instantaneous, average,
// minimum, and maximum statistics. If avg/min/max statistics
// are not supported, the target is expected to just supply the
// instant value
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/polarization-mode-dispersion"
// Path from root: "/components/component/optical-channel/state/polarization-mode-dispersion"
func (n *Component_OpticalChannelPathAny) PolarizationModeDispersion() *Component_OpticalChannel_PolarizationModeDispersionPathAny {
	return &Component_OpticalChannel_PolarizationModeDispersionPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "polarization-mode-dispersion"},
			map[string]interface{}{},
			n,
		),
	}
}

// PostFecBer (container): Bit error rate after forward error correction -- computed
// value with 18 decimal precision. Note that decimal64
// supports values as small as i x 10^-18 where i is an
// integer. Values smaller than this should be reported as 0
// to inidicate error free or near error free performance.
// Values include the instantaneous, average, minimum, and
// maximum statistics. If avg/min/max statistics are not
// supported, the target is expected to just supply the
// instant value
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/post-fec-ber"
// Path from root: "/components/component/optical-channel/state/post-fec-ber"
func (n *Component_OpticalChannelPath) PostFecBer() *Component_OpticalChannel_PostFecBerPath {
	return &Component_OpticalChannel_PostFecBerPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "post-fec-ber"},
			map[string]interface{}{},
			n,
		),
	}
}

// PostFecBer (container): Bit error rate after forward error correction -- computed
// value with 18 decimal precision. Note that decimal64
// supports values as small as i x 10^-18 where i is an
// integer. Values smaller than this should be reported as 0
// to inidicate error free or near error free performance.
// Values include the instantaneous, average, minimum, and
// maximum statistics. If avg/min/max statistics are not
// supported, the target is expected to just supply the
// instant value
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/post-fec-ber"
// Path from root: "/components/component/optical-channel/state/post-fec-ber"
func (n *Component_OpticalChannelPathAny) PostFecBer() *Component_OpticalChannel_PostFecBerPathAny {
	return &Component_OpticalChannel_PostFecBerPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "post-fec-ber"},
			map[string]interface{}{},
			n,
		),
	}
}

// PreFecBer (container): Bit error rate before forward error correction -- computed
// value with 18 decimal precision. Note that decimal64
// supports values as small as i x 10^-18 where i is an
// integer. Values smaller than this should be reported as 0
// to inidicate error free or near error free performance.
// Values include the instantaneous, average, minimum, and
// maximum statistics. If avg/min/max statistics are not
// supported, the target is expected to just supply the
// instant value
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/pre-fec-ber"
// Path from root: "/components/component/optical-channel/state/pre-fec-ber"
func (n *Component_OpticalChannelPath) PreFecBer() *Component_OpticalChannel_PreFecBerPath {
	return &Component_OpticalChannel_PreFecBerPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "pre-fec-ber"},
			map[string]interface{}{},
			n,
		),
	}
}

// PreFecBer (container): Bit error rate before forward error correction -- computed
// value with 18 decimal precision. Note that decimal64
// supports values as small as i x 10^-18 where i is an
// integer. Values smaller than this should be reported as 0
// to inidicate error free or near error free performance.
// Values include the instantaneous, average, minimum, and
// maximum statistics. If avg/min/max statistics are not
// supported, the target is expected to just supply the
// instant value
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/pre-fec-ber"
// Path from root: "/components/component/optical-channel/state/pre-fec-ber"
func (n *Component_OpticalChannelPathAny) PreFecBer() *Component_OpticalChannel_PreFecBerPathAny {
	return &Component_OpticalChannel_PreFecBerPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "pre-fec-ber"},
			map[string]interface{}{},
			n,
		),
	}
}

// QValue (container): Quality value (factor) in dB of a channel with two
// decimal precision. Values include the instantaneous,
// average, minimum, and maximum statistics. If avg/min/max
// statistics are not supported, the target is expected
// to just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/q-value"
// Path from root: "/components/component/optical-channel/state/q-value"
func (n *Component_OpticalChannelPath) QValue() *Component_OpticalChannel_QValuePath {
	return &Component_OpticalChannel_QValuePath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "q-value"},
			map[string]interface{}{},
			n,
		),
	}
}

// QValue (container): Quality value (factor) in dB of a channel with two
// decimal precision. Values include the instantaneous,
// average, minimum, and maximum statistics. If avg/min/max
// statistics are not supported, the target is expected
// to just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/q-value"
// Path from root: "/components/component/optical-channel/state/q-value"
func (n *Component_OpticalChannelPathAny) QValue() *Component_OpticalChannel_QValuePathAny {
	return &Component_OpticalChannel_QValuePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "q-value"},
			map[string]interface{}{},
			n,
		),
	}
}

// SecondOrderPolarizationModeDispersion (container): Second Order Polarization Mode Dispersion of an optical
// channel in picoseconds squared (ps^2) as reported by
// receiver with two decimal precision. Values include the
// instantaneous, average, minimum, and maximum statistics.
// If avg/min/max statistics are not supported, the target
// is expected to just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/second-order-polarization-mode-dispersion"
// Path from root: "/components/component/optical-channel/state/second-order-polarization-mode-dispersion"
func (n *Component_OpticalChannelPath) SecondOrderPolarizationModeDispersion() *Component_OpticalChannel_SecondOrderPolarizationModeDispersionPath {
	return &Component_OpticalChannel_SecondOrderPolarizationModeDispersionPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "second-order-polarization-mode-dispersion"},
			map[string]interface{}{},
			n,
		),
	}
}

// SecondOrderPolarizationModeDispersion (container): Second Order Polarization Mode Dispersion of an optical
// channel in picoseconds squared (ps^2) as reported by
// receiver with two decimal precision. Values include the
// instantaneous, average, minimum, and maximum statistics.
// If avg/min/max statistics are not supported, the target
// is expected to just supply the instant value
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/second-order-polarization-mode-dispersion"
// Path from root: "/components/component/optical-channel/state/second-order-polarization-mode-dispersion"
func (n *Component_OpticalChannelPathAny) SecondOrderPolarizationModeDispersion() *Component_OpticalChannel_SecondOrderPolarizationModeDispersionPathAny {
	return &Component_OpticalChannel_SecondOrderPolarizationModeDispersionPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "second-order-polarization-mode-dispersion"},
			map[string]interface{}{},
			n,
		),
	}
}

// SopRoc (container): State-of-polarization rate-of-change (SOP-ROC) in krad/s with 1
// decimal precision. This term is defined by OIF Implementation
// Agreement for Coherent CMIS. Values include the instantaneous,
// average, minimum, and maximum statistics. If avg/min/max
// statistics are not supported, the target is expected to just
// supply the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/sop-roc"
// Path from root: "/components/component/optical-channel/state/sop-roc"
func (n *Component_OpticalChannelPath) SopRoc() *Component_OpticalChannel_SopRocPath {
	return &Component_OpticalChannel_SopRocPath{
		NodePath: ygot.NewNodePath(
			[]string{"state", "sop-roc"},
			map[string]interface{}{},
			n,
		),
	}
}

// SopRoc (container): State-of-polarization rate-of-change (SOP-ROC) in krad/s with 1
// decimal precision. This term is defined by OIF Implementation
// Agreement for Coherent CMIS. Values include the instantaneous,
// average, minimum, and maximum statistics. If avg/min/max
// statistics are not supported, the target is expected to just
// supply the instant value.
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "state/sop-roc"
// Path from root: "/components/component/optical-channel/state/sop-roc"
func (n *Component_OpticalChannelPathAny) SopRoc() *Component_OpticalChannel_SopRocPathAny {
	return &Component_OpticalChannel_SopRocPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"state", "sop-roc"},
			map[string]interface{}{},
			n,
		),
	}
}

// TargetOutputPower (leaf): Target output optical power level of the optical channel,
// expressed in increments of 0.01 dBm (decibel-milliwats)
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/target-output-power"
// Path from root: "/components/component/optical-channel/config/target-output-power"
func (n *Component_OpticalChannelPath) TargetOutputPower() *Component_OpticalChannel_TargetOutputPowerPath {
	return &Component_OpticalChannel_TargetOutputPowerPath{
		NodePath: ygot.NewNodePath(
			[]string{"config", "target-output-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// TargetOutputPower (leaf): Target output optical power level of the optical channel,
// expressed in increments of 0.01 dBm (decibel-milliwats)
// ----------------------------------------
// Defining module: "openconfig-terminal-device"
// Instantiating module: "openconfig-platform"
// Path from parent: "config/target-output-power"
// Path from root: "/components/component/optical-channel/config/target-output-power"
func (n *Component_OpticalChannelPathAny) TargetOutputPower() *Component_OpticalChannel_TargetOutputPowerPathAny {
	return &Component_OpticalChannel_TargetOutputPowerPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"config", "target-output-power"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_CarrierFrequencyOffsetPath represents the /openconfig-platform/components/component/optical-channel/state/carrier-frequency-offset YANG schema element.
type Component_OpticalChannel_CarrierFrequencyOffsetPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_CarrierFrequencyOffsetPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/carrier-frequency-offset YANG schema element.
type Component_OpticalChannel_CarrierFrequencyOffsetPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_CarrierFrequencyOffset_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/carrier-frequency-offset/avg YANG schema element.
type Component_OpticalChannel_CarrierFrequencyOffset_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_CarrierFrequencyOffset_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/carrier-frequency-offset/avg YANG schema element.
type Component_OpticalChannel_CarrierFrequencyOffset_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_CarrierFrequencyOffset_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/carrier-frequency-offset/instant YANG schema element.
type Component_OpticalChannel_CarrierFrequencyOffset_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_CarrierFrequencyOffset_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/carrier-frequency-offset/instant YANG schema element.
type Component_OpticalChannel_CarrierFrequencyOffset_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_CarrierFrequencyOffset_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/carrier-frequency-offset/interval YANG schema element.
type Component_OpticalChannel_CarrierFrequencyOffset_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_CarrierFrequencyOffset_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/carrier-frequency-offset/interval YANG schema element.
type Component_OpticalChannel_CarrierFrequencyOffset_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_CarrierFrequencyOffset_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/carrier-frequency-offset/max YANG schema element.
type Component_OpticalChannel_CarrierFrequencyOffset_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_CarrierFrequencyOffset_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/carrier-frequency-offset/max YANG schema element.
type Component_OpticalChannel_CarrierFrequencyOffset_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_CarrierFrequencyOffset_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/carrier-frequency-offset/max-time YANG schema element.
type Component_OpticalChannel_CarrierFrequencyOffset_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_CarrierFrequencyOffset_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/carrier-frequency-offset/max-time YANG schema element.
type Component_OpticalChannel_CarrierFrequencyOffset_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_CarrierFrequencyOffset_MinPath represents the /openconfig-platform/components/component/optical-channel/state/carrier-frequency-offset/min YANG schema element.
type Component_OpticalChannel_CarrierFrequencyOffset_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_CarrierFrequencyOffset_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/carrier-frequency-offset/min YANG schema element.
type Component_OpticalChannel_CarrierFrequencyOffset_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_CarrierFrequencyOffset_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/carrier-frequency-offset/min-time YANG schema element.
type Component_OpticalChannel_CarrierFrequencyOffset_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_CarrierFrequencyOffset_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/carrier-frequency-offset/min-time YANG schema element.
type Component_OpticalChannel_CarrierFrequencyOffset_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/carrier-frequency-offset/avg"
func (n *Component_OpticalChannel_CarrierFrequencyOffsetPath) Avg() *Component_OpticalChannel_CarrierFrequencyOffset_AvgPath {
	return &Component_OpticalChannel_CarrierFrequencyOffset_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/carrier-frequency-offset/avg"
func (n *Component_OpticalChannel_CarrierFrequencyOffsetPathAny) Avg() *Component_OpticalChannel_CarrierFrequencyOffset_AvgPathAny {
	return &Component_OpticalChannel_CarrierFrequencyOffset_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/carrier-frequency-offset/instant"
func (n *Component_OpticalChannel_CarrierFrequencyOffsetPath) Instant() *Component_OpticalChannel_CarrierFrequencyOffset_InstantPath {
	return &Component_OpticalChannel_CarrierFrequencyOffset_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/carrier-frequency-offset/instant"
func (n *Component_OpticalChannel_CarrierFrequencyOffsetPathAny) Instant() *Component_OpticalChannel_CarrierFrequencyOffset_InstantPathAny {
	return &Component_OpticalChannel_CarrierFrequencyOffset_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/carrier-frequency-offset/interval"
func (n *Component_OpticalChannel_CarrierFrequencyOffsetPath) Interval() *Component_OpticalChannel_CarrierFrequencyOffset_IntervalPath {
	return &Component_OpticalChannel_CarrierFrequencyOffset_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/carrier-frequency-offset/interval"
func (n *Component_OpticalChannel_CarrierFrequencyOffsetPathAny) Interval() *Component_OpticalChannel_CarrierFrequencyOffset_IntervalPathAny {
	return &Component_OpticalChannel_CarrierFrequencyOffset_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/carrier-frequency-offset/max"
func (n *Component_OpticalChannel_CarrierFrequencyOffsetPath) Max() *Component_OpticalChannel_CarrierFrequencyOffset_MaxPath {
	return &Component_OpticalChannel_CarrierFrequencyOffset_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/carrier-frequency-offset/max"
func (n *Component_OpticalChannel_CarrierFrequencyOffsetPathAny) Max() *Component_OpticalChannel_CarrierFrequencyOffset_MaxPathAny {
	return &Component_OpticalChannel_CarrierFrequencyOffset_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/carrier-frequency-offset/max-time"
func (n *Component_OpticalChannel_CarrierFrequencyOffsetPath) MaxTime() *Component_OpticalChannel_CarrierFrequencyOffset_MaxTimePath {
	return &Component_OpticalChannel_CarrierFrequencyOffset_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/carrier-frequency-offset/max-time"
func (n *Component_OpticalChannel_CarrierFrequencyOffsetPathAny) MaxTime() *Component_OpticalChannel_CarrierFrequencyOffset_MaxTimePathAny {
	return &Component_OpticalChannel_CarrierFrequencyOffset_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/carrier-frequency-offset/min"
func (n *Component_OpticalChannel_CarrierFrequencyOffsetPath) Min() *Component_OpticalChannel_CarrierFrequencyOffset_MinPath {
	return &Component_OpticalChannel_CarrierFrequencyOffset_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/carrier-frequency-offset/min"
func (n *Component_OpticalChannel_CarrierFrequencyOffsetPathAny) Min() *Component_OpticalChannel_CarrierFrequencyOffset_MinPathAny {
	return &Component_OpticalChannel_CarrierFrequencyOffset_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/carrier-frequency-offset/min-time"
func (n *Component_OpticalChannel_CarrierFrequencyOffsetPath) MinTime() *Component_OpticalChannel_CarrierFrequencyOffset_MinTimePath {
	return &Component_OpticalChannel_CarrierFrequencyOffset_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/carrier-frequency-offset/min-time"
func (n *Component_OpticalChannel_CarrierFrequencyOffsetPathAny) MinTime() *Component_OpticalChannel_CarrierFrequencyOffset_MinTimePathAny {
	return &Component_OpticalChannel_CarrierFrequencyOffset_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_ChromaticDispersionPath represents the /openconfig-platform/components/component/optical-channel/state/chromatic-dispersion YANG schema element.
type Component_OpticalChannel_ChromaticDispersionPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ChromaticDispersionPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/chromatic-dispersion YANG schema element.
type Component_OpticalChannel_ChromaticDispersionPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ChromaticDispersion_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/chromatic-dispersion/avg YANG schema element.
type Component_OpticalChannel_ChromaticDispersion_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ChromaticDispersion_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/chromatic-dispersion/avg YANG schema element.
type Component_OpticalChannel_ChromaticDispersion_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ChromaticDispersion_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/chromatic-dispersion/instant YANG schema element.
type Component_OpticalChannel_ChromaticDispersion_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ChromaticDispersion_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/chromatic-dispersion/instant YANG schema element.
type Component_OpticalChannel_ChromaticDispersion_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ChromaticDispersion_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/chromatic-dispersion/interval YANG schema element.
type Component_OpticalChannel_ChromaticDispersion_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ChromaticDispersion_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/chromatic-dispersion/interval YANG schema element.
type Component_OpticalChannel_ChromaticDispersion_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ChromaticDispersion_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/chromatic-dispersion/max YANG schema element.
type Component_OpticalChannel_ChromaticDispersion_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ChromaticDispersion_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/chromatic-dispersion/max YANG schema element.
type Component_OpticalChannel_ChromaticDispersion_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ChromaticDispersion_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/chromatic-dispersion/max-time YANG schema element.
type Component_OpticalChannel_ChromaticDispersion_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ChromaticDispersion_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/chromatic-dispersion/max-time YANG schema element.
type Component_OpticalChannel_ChromaticDispersion_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ChromaticDispersion_MinPath represents the /openconfig-platform/components/component/optical-channel/state/chromatic-dispersion/min YANG schema element.
type Component_OpticalChannel_ChromaticDispersion_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ChromaticDispersion_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/chromatic-dispersion/min YANG schema element.
type Component_OpticalChannel_ChromaticDispersion_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ChromaticDispersion_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/chromatic-dispersion/min-time YANG schema element.
type Component_OpticalChannel_ChromaticDispersion_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ChromaticDispersion_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/chromatic-dispersion/min-time YANG schema element.
type Component_OpticalChannel_ChromaticDispersion_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/chromatic-dispersion/avg"
func (n *Component_OpticalChannel_ChromaticDispersionPath) Avg() *Component_OpticalChannel_ChromaticDispersion_AvgPath {
	return &Component_OpticalChannel_ChromaticDispersion_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/chromatic-dispersion/avg"
func (n *Component_OpticalChannel_ChromaticDispersionPathAny) Avg() *Component_OpticalChannel_ChromaticDispersion_AvgPathAny {
	return &Component_OpticalChannel_ChromaticDispersion_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/chromatic-dispersion/instant"
func (n *Component_OpticalChannel_ChromaticDispersionPath) Instant() *Component_OpticalChannel_ChromaticDispersion_InstantPath {
	return &Component_OpticalChannel_ChromaticDispersion_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/chromatic-dispersion/instant"
func (n *Component_OpticalChannel_ChromaticDispersionPathAny) Instant() *Component_OpticalChannel_ChromaticDispersion_InstantPathAny {
	return &Component_OpticalChannel_ChromaticDispersion_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/chromatic-dispersion/interval"
func (n *Component_OpticalChannel_ChromaticDispersionPath) Interval() *Component_OpticalChannel_ChromaticDispersion_IntervalPath {
	return &Component_OpticalChannel_ChromaticDispersion_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/chromatic-dispersion/interval"
func (n *Component_OpticalChannel_ChromaticDispersionPathAny) Interval() *Component_OpticalChannel_ChromaticDispersion_IntervalPathAny {
	return &Component_OpticalChannel_ChromaticDispersion_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/chromatic-dispersion/max"
func (n *Component_OpticalChannel_ChromaticDispersionPath) Max() *Component_OpticalChannel_ChromaticDispersion_MaxPath {
	return &Component_OpticalChannel_ChromaticDispersion_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/chromatic-dispersion/max"
func (n *Component_OpticalChannel_ChromaticDispersionPathAny) Max() *Component_OpticalChannel_ChromaticDispersion_MaxPathAny {
	return &Component_OpticalChannel_ChromaticDispersion_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/chromatic-dispersion/max-time"
func (n *Component_OpticalChannel_ChromaticDispersionPath) MaxTime() *Component_OpticalChannel_ChromaticDispersion_MaxTimePath {
	return &Component_OpticalChannel_ChromaticDispersion_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/chromatic-dispersion/max-time"
func (n *Component_OpticalChannel_ChromaticDispersionPathAny) MaxTime() *Component_OpticalChannel_ChromaticDispersion_MaxTimePathAny {
	return &Component_OpticalChannel_ChromaticDispersion_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/chromatic-dispersion/min"
func (n *Component_OpticalChannel_ChromaticDispersionPath) Min() *Component_OpticalChannel_ChromaticDispersion_MinPath {
	return &Component_OpticalChannel_ChromaticDispersion_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/chromatic-dispersion/min"
func (n *Component_OpticalChannel_ChromaticDispersionPathAny) Min() *Component_OpticalChannel_ChromaticDispersion_MinPathAny {
	return &Component_OpticalChannel_ChromaticDispersion_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/chromatic-dispersion/min-time"
func (n *Component_OpticalChannel_ChromaticDispersionPath) MinTime() *Component_OpticalChannel_ChromaticDispersion_MinTimePath {
	return &Component_OpticalChannel_ChromaticDispersion_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/chromatic-dispersion/min-time"
func (n *Component_OpticalChannel_ChromaticDispersionPathAny) MinTime() *Component_OpticalChannel_ChromaticDispersion_MinTimePathAny {
	return &Component_OpticalChannel_ChromaticDispersion_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_EsnrPath represents the /openconfig-platform/components/component/optical-channel/state/esnr YANG schema element.
type Component_OpticalChannel_EsnrPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_EsnrPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/esnr YANG schema element.
type Component_OpticalChannel_EsnrPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Esnr_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/esnr/avg YANG schema element.
type Component_OpticalChannel_Esnr_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Esnr_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/esnr/avg YANG schema element.
type Component_OpticalChannel_Esnr_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Esnr_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/esnr/instant YANG schema element.
type Component_OpticalChannel_Esnr_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Esnr_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/esnr/instant YANG schema element.
type Component_OpticalChannel_Esnr_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Esnr_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/esnr/interval YANG schema element.
type Component_OpticalChannel_Esnr_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Esnr_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/esnr/interval YANG schema element.
type Component_OpticalChannel_Esnr_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Esnr_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/esnr/max YANG schema element.
type Component_OpticalChannel_Esnr_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Esnr_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/esnr/max YANG schema element.
type Component_OpticalChannel_Esnr_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Esnr_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/esnr/max-time YANG schema element.
type Component_OpticalChannel_Esnr_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Esnr_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/esnr/max-time YANG schema element.
type Component_OpticalChannel_Esnr_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Esnr_MinPath represents the /openconfig-platform/components/component/optical-channel/state/esnr/min YANG schema element.
type Component_OpticalChannel_Esnr_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Esnr_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/esnr/min YANG schema element.
type Component_OpticalChannel_Esnr_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Esnr_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/esnr/min-time YANG schema element.
type Component_OpticalChannel_Esnr_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Esnr_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/esnr/min-time YANG schema element.
type Component_OpticalChannel_Esnr_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/esnr/avg"
func (n *Component_OpticalChannel_EsnrPath) Avg() *Component_OpticalChannel_Esnr_AvgPath {
	return &Component_OpticalChannel_Esnr_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/esnr/avg"
func (n *Component_OpticalChannel_EsnrPathAny) Avg() *Component_OpticalChannel_Esnr_AvgPathAny {
	return &Component_OpticalChannel_Esnr_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/esnr/instant"
func (n *Component_OpticalChannel_EsnrPath) Instant() *Component_OpticalChannel_Esnr_InstantPath {
	return &Component_OpticalChannel_Esnr_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/esnr/instant"
func (n *Component_OpticalChannel_EsnrPathAny) Instant() *Component_OpticalChannel_Esnr_InstantPathAny {
	return &Component_OpticalChannel_Esnr_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/esnr/interval"
func (n *Component_OpticalChannel_EsnrPath) Interval() *Component_OpticalChannel_Esnr_IntervalPath {
	return &Component_OpticalChannel_Esnr_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/esnr/interval"
func (n *Component_OpticalChannel_EsnrPathAny) Interval() *Component_OpticalChannel_Esnr_IntervalPathAny {
	return &Component_OpticalChannel_Esnr_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/esnr/max"
func (n *Component_OpticalChannel_EsnrPath) Max() *Component_OpticalChannel_Esnr_MaxPath {
	return &Component_OpticalChannel_Esnr_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/esnr/max"
func (n *Component_OpticalChannel_EsnrPathAny) Max() *Component_OpticalChannel_Esnr_MaxPathAny {
	return &Component_OpticalChannel_Esnr_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/esnr/max-time"
func (n *Component_OpticalChannel_EsnrPath) MaxTime() *Component_OpticalChannel_Esnr_MaxTimePath {
	return &Component_OpticalChannel_Esnr_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/esnr/max-time"
func (n *Component_OpticalChannel_EsnrPathAny) MaxTime() *Component_OpticalChannel_Esnr_MaxTimePathAny {
	return &Component_OpticalChannel_Esnr_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/esnr/min"
func (n *Component_OpticalChannel_EsnrPath) Min() *Component_OpticalChannel_Esnr_MinPath {
	return &Component_OpticalChannel_Esnr_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/esnr/min"
func (n *Component_OpticalChannel_EsnrPathAny) Min() *Component_OpticalChannel_Esnr_MinPathAny {
	return &Component_OpticalChannel_Esnr_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/esnr/min-time"
func (n *Component_OpticalChannel_EsnrPath) MinTime() *Component_OpticalChannel_Esnr_MinTimePath {
	return &Component_OpticalChannel_Esnr_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/esnr/min-time"
func (n *Component_OpticalChannel_EsnrPathAny) MinTime() *Component_OpticalChannel_Esnr_MinTimePathAny {
	return &Component_OpticalChannel_Esnr_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_InputPowerPath represents the /openconfig-platform/components/component/optical-channel/state/input-power YANG schema element.
type Component_OpticalChannel_InputPowerPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_InputPowerPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/input-power YANG schema element.
type Component_OpticalChannel_InputPowerPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_InputPower_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/input-power/avg YANG schema element.
type Component_OpticalChannel_InputPower_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_InputPower_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/input-power/avg YANG schema element.
type Component_OpticalChannel_InputPower_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_InputPower_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/input-power/instant YANG schema element.
type Component_OpticalChannel_InputPower_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_InputPower_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/input-power/instant YANG schema element.
type Component_OpticalChannel_InputPower_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_InputPower_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/input-power/interval YANG schema element.
type Component_OpticalChannel_InputPower_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_InputPower_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/input-power/interval YANG schema element.
type Component_OpticalChannel_InputPower_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_InputPower_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/input-power/max YANG schema element.
type Component_OpticalChannel_InputPower_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_InputPower_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/input-power/max YANG schema element.
type Component_OpticalChannel_InputPower_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_InputPower_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/input-power/max-time YANG schema element.
type Component_OpticalChannel_InputPower_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_InputPower_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/input-power/max-time YANG schema element.
type Component_OpticalChannel_InputPower_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_InputPower_MinPath represents the /openconfig-platform/components/component/optical-channel/state/input-power/min YANG schema element.
type Component_OpticalChannel_InputPower_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_InputPower_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/input-power/min YANG schema element.
type Component_OpticalChannel_InputPower_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_InputPower_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/input-power/min-time YANG schema element.
type Component_OpticalChannel_InputPower_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_InputPower_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/input-power/min-time YANG schema element.
type Component_OpticalChannel_InputPower_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/input-power/avg"
func (n *Component_OpticalChannel_InputPowerPath) Avg() *Component_OpticalChannel_InputPower_AvgPath {
	return &Component_OpticalChannel_InputPower_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/input-power/avg"
func (n *Component_OpticalChannel_InputPowerPathAny) Avg() *Component_OpticalChannel_InputPower_AvgPathAny {
	return &Component_OpticalChannel_InputPower_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/input-power/instant"
func (n *Component_OpticalChannel_InputPowerPath) Instant() *Component_OpticalChannel_InputPower_InstantPath {
	return &Component_OpticalChannel_InputPower_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/input-power/instant"
func (n *Component_OpticalChannel_InputPowerPathAny) Instant() *Component_OpticalChannel_InputPower_InstantPathAny {
	return &Component_OpticalChannel_InputPower_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/input-power/interval"
func (n *Component_OpticalChannel_InputPowerPath) Interval() *Component_OpticalChannel_InputPower_IntervalPath {
	return &Component_OpticalChannel_InputPower_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/input-power/interval"
func (n *Component_OpticalChannel_InputPowerPathAny) Interval() *Component_OpticalChannel_InputPower_IntervalPathAny {
	return &Component_OpticalChannel_InputPower_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/input-power/max"
func (n *Component_OpticalChannel_InputPowerPath) Max() *Component_OpticalChannel_InputPower_MaxPath {
	return &Component_OpticalChannel_InputPower_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/input-power/max"
func (n *Component_OpticalChannel_InputPowerPathAny) Max() *Component_OpticalChannel_InputPower_MaxPathAny {
	return &Component_OpticalChannel_InputPower_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/input-power/max-time"
func (n *Component_OpticalChannel_InputPowerPath) MaxTime() *Component_OpticalChannel_InputPower_MaxTimePath {
	return &Component_OpticalChannel_InputPower_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/input-power/max-time"
func (n *Component_OpticalChannel_InputPowerPathAny) MaxTime() *Component_OpticalChannel_InputPower_MaxTimePathAny {
	return &Component_OpticalChannel_InputPower_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/input-power/min"
func (n *Component_OpticalChannel_InputPowerPath) Min() *Component_OpticalChannel_InputPower_MinPath {
	return &Component_OpticalChannel_InputPower_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/input-power/min"
func (n *Component_OpticalChannel_InputPowerPathAny) Min() *Component_OpticalChannel_InputPower_MinPathAny {
	return &Component_OpticalChannel_InputPower_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/input-power/min-time"
func (n *Component_OpticalChannel_InputPowerPath) MinTime() *Component_OpticalChannel_InputPower_MinTimePath {
	return &Component_OpticalChannel_InputPower_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/input-power/min-time"
func (n *Component_OpticalChannel_InputPowerPathAny) MinTime() *Component_OpticalChannel_InputPower_MinTimePathAny {
	return &Component_OpticalChannel_InputPower_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_LaserBiasCurrentPath represents the /openconfig-platform/components/component/optical-channel/state/laser-bias-current YANG schema element.
type Component_OpticalChannel_LaserBiasCurrentPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_LaserBiasCurrentPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/laser-bias-current YANG schema element.
type Component_OpticalChannel_LaserBiasCurrentPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_LaserBiasCurrent_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/laser-bias-current/avg YANG schema element.
type Component_OpticalChannel_LaserBiasCurrent_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_LaserBiasCurrent_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/laser-bias-current/avg YANG schema element.
type Component_OpticalChannel_LaserBiasCurrent_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_LaserBiasCurrent_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/laser-bias-current/instant YANG schema element.
type Component_OpticalChannel_LaserBiasCurrent_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_LaserBiasCurrent_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/laser-bias-current/instant YANG schema element.
type Component_OpticalChannel_LaserBiasCurrent_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_LaserBiasCurrent_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/laser-bias-current/interval YANG schema element.
type Component_OpticalChannel_LaserBiasCurrent_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_LaserBiasCurrent_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/laser-bias-current/interval YANG schema element.
type Component_OpticalChannel_LaserBiasCurrent_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_LaserBiasCurrent_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/laser-bias-current/max YANG schema element.
type Component_OpticalChannel_LaserBiasCurrent_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_LaserBiasCurrent_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/laser-bias-current/max YANG schema element.
type Component_OpticalChannel_LaserBiasCurrent_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_LaserBiasCurrent_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/laser-bias-current/max-time YANG schema element.
type Component_OpticalChannel_LaserBiasCurrent_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_LaserBiasCurrent_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/laser-bias-current/max-time YANG schema element.
type Component_OpticalChannel_LaserBiasCurrent_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_LaserBiasCurrent_MinPath represents the /openconfig-platform/components/component/optical-channel/state/laser-bias-current/min YANG schema element.
type Component_OpticalChannel_LaserBiasCurrent_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_LaserBiasCurrent_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/laser-bias-current/min YANG schema element.
type Component_OpticalChannel_LaserBiasCurrent_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_LaserBiasCurrent_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/laser-bias-current/min-time YANG schema element.
type Component_OpticalChannel_LaserBiasCurrent_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_LaserBiasCurrent_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/laser-bias-current/min-time YANG schema element.
type Component_OpticalChannel_LaserBiasCurrent_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/laser-bias-current/avg"
func (n *Component_OpticalChannel_LaserBiasCurrentPath) Avg() *Component_OpticalChannel_LaserBiasCurrent_AvgPath {
	return &Component_OpticalChannel_LaserBiasCurrent_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/laser-bias-current/avg"
func (n *Component_OpticalChannel_LaserBiasCurrentPathAny) Avg() *Component_OpticalChannel_LaserBiasCurrent_AvgPathAny {
	return &Component_OpticalChannel_LaserBiasCurrent_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/laser-bias-current/instant"
func (n *Component_OpticalChannel_LaserBiasCurrentPath) Instant() *Component_OpticalChannel_LaserBiasCurrent_InstantPath {
	return &Component_OpticalChannel_LaserBiasCurrent_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/laser-bias-current/instant"
func (n *Component_OpticalChannel_LaserBiasCurrentPathAny) Instant() *Component_OpticalChannel_LaserBiasCurrent_InstantPathAny {
	return &Component_OpticalChannel_LaserBiasCurrent_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/laser-bias-current/interval"
func (n *Component_OpticalChannel_LaserBiasCurrentPath) Interval() *Component_OpticalChannel_LaserBiasCurrent_IntervalPath {
	return &Component_OpticalChannel_LaserBiasCurrent_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/laser-bias-current/interval"
func (n *Component_OpticalChannel_LaserBiasCurrentPathAny) Interval() *Component_OpticalChannel_LaserBiasCurrent_IntervalPathAny {
	return &Component_OpticalChannel_LaserBiasCurrent_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/laser-bias-current/max"
func (n *Component_OpticalChannel_LaserBiasCurrentPath) Max() *Component_OpticalChannel_LaserBiasCurrent_MaxPath {
	return &Component_OpticalChannel_LaserBiasCurrent_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/laser-bias-current/max"
func (n *Component_OpticalChannel_LaserBiasCurrentPathAny) Max() *Component_OpticalChannel_LaserBiasCurrent_MaxPathAny {
	return &Component_OpticalChannel_LaserBiasCurrent_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/laser-bias-current/max-time"
func (n *Component_OpticalChannel_LaserBiasCurrentPath) MaxTime() *Component_OpticalChannel_LaserBiasCurrent_MaxTimePath {
	return &Component_OpticalChannel_LaserBiasCurrent_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/laser-bias-current/max-time"
func (n *Component_OpticalChannel_LaserBiasCurrentPathAny) MaxTime() *Component_OpticalChannel_LaserBiasCurrent_MaxTimePathAny {
	return &Component_OpticalChannel_LaserBiasCurrent_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/laser-bias-current/min"
func (n *Component_OpticalChannel_LaserBiasCurrentPath) Min() *Component_OpticalChannel_LaserBiasCurrent_MinPath {
	return &Component_OpticalChannel_LaserBiasCurrent_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/laser-bias-current/min"
func (n *Component_OpticalChannel_LaserBiasCurrentPathAny) Min() *Component_OpticalChannel_LaserBiasCurrent_MinPathAny {
	return &Component_OpticalChannel_LaserBiasCurrent_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/laser-bias-current/min-time"
func (n *Component_OpticalChannel_LaserBiasCurrentPath) MinTime() *Component_OpticalChannel_LaserBiasCurrent_MinTimePath {
	return &Component_OpticalChannel_LaserBiasCurrent_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/laser-bias-current/min-time"
func (n *Component_OpticalChannel_LaserBiasCurrentPathAny) MinTime() *Component_OpticalChannel_LaserBiasCurrent_MinTimePathAny {
	return &Component_OpticalChannel_LaserBiasCurrent_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_ModulationErrorRatioPath represents the /openconfig-platform/components/component/optical-channel/state/modulation-error-ratio YANG schema element.
type Component_OpticalChannel_ModulationErrorRatioPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulationErrorRatioPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulation-error-ratio YANG schema element.
type Component_OpticalChannel_ModulationErrorRatioPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulationErrorRatio_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/modulation-error-ratio/avg YANG schema element.
type Component_OpticalChannel_ModulationErrorRatio_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulationErrorRatio_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulation-error-ratio/avg YANG schema element.
type Component_OpticalChannel_ModulationErrorRatio_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulationErrorRatio_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/modulation-error-ratio/instant YANG schema element.
type Component_OpticalChannel_ModulationErrorRatio_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulationErrorRatio_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulation-error-ratio/instant YANG schema element.
type Component_OpticalChannel_ModulationErrorRatio_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulationErrorRatio_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/modulation-error-ratio/interval YANG schema element.
type Component_OpticalChannel_ModulationErrorRatio_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulationErrorRatio_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulation-error-ratio/interval YANG schema element.
type Component_OpticalChannel_ModulationErrorRatio_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulationErrorRatio_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/modulation-error-ratio/max YANG schema element.
type Component_OpticalChannel_ModulationErrorRatio_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulationErrorRatio_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulation-error-ratio/max YANG schema element.
type Component_OpticalChannel_ModulationErrorRatio_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulationErrorRatio_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/modulation-error-ratio/max-time YANG schema element.
type Component_OpticalChannel_ModulationErrorRatio_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulationErrorRatio_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulation-error-ratio/max-time YANG schema element.
type Component_OpticalChannel_ModulationErrorRatio_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulationErrorRatio_MinPath represents the /openconfig-platform/components/component/optical-channel/state/modulation-error-ratio/min YANG schema element.
type Component_OpticalChannel_ModulationErrorRatio_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulationErrorRatio_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulation-error-ratio/min YANG schema element.
type Component_OpticalChannel_ModulationErrorRatio_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulationErrorRatio_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/modulation-error-ratio/min-time YANG schema element.
type Component_OpticalChannel_ModulationErrorRatio_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulationErrorRatio_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulation-error-ratio/min-time YANG schema element.
type Component_OpticalChannel_ModulationErrorRatio_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/modulation-error-ratio/avg"
func (n *Component_OpticalChannel_ModulationErrorRatioPath) Avg() *Component_OpticalChannel_ModulationErrorRatio_AvgPath {
	return &Component_OpticalChannel_ModulationErrorRatio_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/modulation-error-ratio/avg"
func (n *Component_OpticalChannel_ModulationErrorRatioPathAny) Avg() *Component_OpticalChannel_ModulationErrorRatio_AvgPathAny {
	return &Component_OpticalChannel_ModulationErrorRatio_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/modulation-error-ratio/instant"
func (n *Component_OpticalChannel_ModulationErrorRatioPath) Instant() *Component_OpticalChannel_ModulationErrorRatio_InstantPath {
	return &Component_OpticalChannel_ModulationErrorRatio_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/modulation-error-ratio/instant"
func (n *Component_OpticalChannel_ModulationErrorRatioPathAny) Instant() *Component_OpticalChannel_ModulationErrorRatio_InstantPathAny {
	return &Component_OpticalChannel_ModulationErrorRatio_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/modulation-error-ratio/interval"
func (n *Component_OpticalChannel_ModulationErrorRatioPath) Interval() *Component_OpticalChannel_ModulationErrorRatio_IntervalPath {
	return &Component_OpticalChannel_ModulationErrorRatio_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/modulation-error-ratio/interval"
func (n *Component_OpticalChannel_ModulationErrorRatioPathAny) Interval() *Component_OpticalChannel_ModulationErrorRatio_IntervalPathAny {
	return &Component_OpticalChannel_ModulationErrorRatio_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/modulation-error-ratio/max"
func (n *Component_OpticalChannel_ModulationErrorRatioPath) Max() *Component_OpticalChannel_ModulationErrorRatio_MaxPath {
	return &Component_OpticalChannel_ModulationErrorRatio_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/modulation-error-ratio/max"
func (n *Component_OpticalChannel_ModulationErrorRatioPathAny) Max() *Component_OpticalChannel_ModulationErrorRatio_MaxPathAny {
	return &Component_OpticalChannel_ModulationErrorRatio_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/modulation-error-ratio/max-time"
func (n *Component_OpticalChannel_ModulationErrorRatioPath) MaxTime() *Component_OpticalChannel_ModulationErrorRatio_MaxTimePath {
	return &Component_OpticalChannel_ModulationErrorRatio_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/modulation-error-ratio/max-time"
func (n *Component_OpticalChannel_ModulationErrorRatioPathAny) MaxTime() *Component_OpticalChannel_ModulationErrorRatio_MaxTimePathAny {
	return &Component_OpticalChannel_ModulationErrorRatio_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/modulation-error-ratio/min"
func (n *Component_OpticalChannel_ModulationErrorRatioPath) Min() *Component_OpticalChannel_ModulationErrorRatio_MinPath {
	return &Component_OpticalChannel_ModulationErrorRatio_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/modulation-error-ratio/min"
func (n *Component_OpticalChannel_ModulationErrorRatioPathAny) Min() *Component_OpticalChannel_ModulationErrorRatio_MinPathAny {
	return &Component_OpticalChannel_ModulationErrorRatio_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/modulation-error-ratio/min-time"
func (n *Component_OpticalChannel_ModulationErrorRatioPath) MinTime() *Component_OpticalChannel_ModulationErrorRatio_MinTimePath {
	return &Component_OpticalChannel_ModulationErrorRatio_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/modulation-error-ratio/min-time"
func (n *Component_OpticalChannel_ModulationErrorRatioPathAny) MinTime() *Component_OpticalChannel_ModulationErrorRatio_MinTimePathAny {
	return &Component_OpticalChannel_ModulationErrorRatio_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_ModulatorBiasXPhasePath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-x-phase YANG schema element.
type Component_OpticalChannel_ModulatorBiasXPhasePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXPhasePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-x-phase YANG schema element.
type Component_OpticalChannel_ModulatorBiasXPhasePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXPhase_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-x-phase/avg YANG schema element.
type Component_OpticalChannel_ModulatorBiasXPhase_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXPhase_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-x-phase/avg YANG schema element.
type Component_OpticalChannel_ModulatorBiasXPhase_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXPhase_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-x-phase/instant YANG schema element.
type Component_OpticalChannel_ModulatorBiasXPhase_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXPhase_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-x-phase/instant YANG schema element.
type Component_OpticalChannel_ModulatorBiasXPhase_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXPhase_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-x-phase/interval YANG schema element.
type Component_OpticalChannel_ModulatorBiasXPhase_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXPhase_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-x-phase/interval YANG schema element.
type Component_OpticalChannel_ModulatorBiasXPhase_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXPhase_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-x-phase/max YANG schema element.
type Component_OpticalChannel_ModulatorBiasXPhase_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXPhase_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-x-phase/max YANG schema element.
type Component_OpticalChannel_ModulatorBiasXPhase_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXPhase_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-x-phase/max-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasXPhase_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXPhase_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-x-phase/max-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasXPhase_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXPhase_MinPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-x-phase/min YANG schema element.
type Component_OpticalChannel_ModulatorBiasXPhase_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXPhase_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-x-phase/min YANG schema element.
type Component_OpticalChannel_ModulatorBiasXPhase_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXPhase_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-x-phase/min-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasXPhase_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXPhase_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-x-phase/min-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasXPhase_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/modulator-bias-x-phase/avg"
func (n *Component_OpticalChannel_ModulatorBiasXPhasePath) Avg() *Component_OpticalChannel_ModulatorBiasXPhase_AvgPath {
	return &Component_OpticalChannel_ModulatorBiasXPhase_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/modulator-bias-x-phase/avg"
func (n *Component_OpticalChannel_ModulatorBiasXPhasePathAny) Avg() *Component_OpticalChannel_ModulatorBiasXPhase_AvgPathAny {
	return &Component_OpticalChannel_ModulatorBiasXPhase_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/modulator-bias-x-phase/instant"
func (n *Component_OpticalChannel_ModulatorBiasXPhasePath) Instant() *Component_OpticalChannel_ModulatorBiasXPhase_InstantPath {
	return &Component_OpticalChannel_ModulatorBiasXPhase_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/modulator-bias-x-phase/instant"
func (n *Component_OpticalChannel_ModulatorBiasXPhasePathAny) Instant() *Component_OpticalChannel_ModulatorBiasXPhase_InstantPathAny {
	return &Component_OpticalChannel_ModulatorBiasXPhase_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/modulator-bias-x-phase/interval"
func (n *Component_OpticalChannel_ModulatorBiasXPhasePath) Interval() *Component_OpticalChannel_ModulatorBiasXPhase_IntervalPath {
	return &Component_OpticalChannel_ModulatorBiasXPhase_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/modulator-bias-x-phase/interval"
func (n *Component_OpticalChannel_ModulatorBiasXPhasePathAny) Interval() *Component_OpticalChannel_ModulatorBiasXPhase_IntervalPathAny {
	return &Component_OpticalChannel_ModulatorBiasXPhase_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/modulator-bias-x-phase/max"
func (n *Component_OpticalChannel_ModulatorBiasXPhasePath) Max() *Component_OpticalChannel_ModulatorBiasXPhase_MaxPath {
	return &Component_OpticalChannel_ModulatorBiasXPhase_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/modulator-bias-x-phase/max"
func (n *Component_OpticalChannel_ModulatorBiasXPhasePathAny) Max() *Component_OpticalChannel_ModulatorBiasXPhase_MaxPathAny {
	return &Component_OpticalChannel_ModulatorBiasXPhase_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-x-phase/max-time"
func (n *Component_OpticalChannel_ModulatorBiasXPhasePath) MaxTime() *Component_OpticalChannel_ModulatorBiasXPhase_MaxTimePath {
	return &Component_OpticalChannel_ModulatorBiasXPhase_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-x-phase/max-time"
func (n *Component_OpticalChannel_ModulatorBiasXPhasePathAny) MaxTime() *Component_OpticalChannel_ModulatorBiasXPhase_MaxTimePathAny {
	return &Component_OpticalChannel_ModulatorBiasXPhase_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/modulator-bias-x-phase/min"
func (n *Component_OpticalChannel_ModulatorBiasXPhasePath) Min() *Component_OpticalChannel_ModulatorBiasXPhase_MinPath {
	return &Component_OpticalChannel_ModulatorBiasXPhase_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/modulator-bias-x-phase/min"
func (n *Component_OpticalChannel_ModulatorBiasXPhasePathAny) Min() *Component_OpticalChannel_ModulatorBiasXPhase_MinPathAny {
	return &Component_OpticalChannel_ModulatorBiasXPhase_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-x-phase/min-time"
func (n *Component_OpticalChannel_ModulatorBiasXPhasePath) MinTime() *Component_OpticalChannel_ModulatorBiasXPhase_MinTimePath {
	return &Component_OpticalChannel_ModulatorBiasXPhase_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-x-phase/min-time"
func (n *Component_OpticalChannel_ModulatorBiasXPhasePathAny) MinTime() *Component_OpticalChannel_ModulatorBiasXPhase_MinTimePathAny {
	return &Component_OpticalChannel_ModulatorBiasXPhase_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_ModulatorBiasXiPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xi YANG schema element.
type Component_OpticalChannel_ModulatorBiasXiPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXiPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xi YANG schema element.
type Component_OpticalChannel_ModulatorBiasXiPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXi_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xi/avg YANG schema element.
type Component_OpticalChannel_ModulatorBiasXi_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXi_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xi/avg YANG schema element.
type Component_OpticalChannel_ModulatorBiasXi_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXi_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xi/instant YANG schema element.
type Component_OpticalChannel_ModulatorBiasXi_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXi_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xi/instant YANG schema element.
type Component_OpticalChannel_ModulatorBiasXi_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXi_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xi/interval YANG schema element.
type Component_OpticalChannel_ModulatorBiasXi_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXi_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xi/interval YANG schema element.
type Component_OpticalChannel_ModulatorBiasXi_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXi_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xi/max YANG schema element.
type Component_OpticalChannel_ModulatorBiasXi_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXi_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xi/max YANG schema element.
type Component_OpticalChannel_ModulatorBiasXi_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXi_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xi/max-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasXi_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXi_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xi/max-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasXi_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXi_MinPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xi/min YANG schema element.
type Component_OpticalChannel_ModulatorBiasXi_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXi_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xi/min YANG schema element.
type Component_OpticalChannel_ModulatorBiasXi_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXi_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xi/min-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasXi_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXi_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xi/min-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasXi_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xi/avg"
func (n *Component_OpticalChannel_ModulatorBiasXiPath) Avg() *Component_OpticalChannel_ModulatorBiasXi_AvgPath {
	return &Component_OpticalChannel_ModulatorBiasXi_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xi/avg"
func (n *Component_OpticalChannel_ModulatorBiasXiPathAny) Avg() *Component_OpticalChannel_ModulatorBiasXi_AvgPathAny {
	return &Component_OpticalChannel_ModulatorBiasXi_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xi/instant"
func (n *Component_OpticalChannel_ModulatorBiasXiPath) Instant() *Component_OpticalChannel_ModulatorBiasXi_InstantPath {
	return &Component_OpticalChannel_ModulatorBiasXi_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xi/instant"
func (n *Component_OpticalChannel_ModulatorBiasXiPathAny) Instant() *Component_OpticalChannel_ModulatorBiasXi_InstantPathAny {
	return &Component_OpticalChannel_ModulatorBiasXi_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xi/interval"
func (n *Component_OpticalChannel_ModulatorBiasXiPath) Interval() *Component_OpticalChannel_ModulatorBiasXi_IntervalPath {
	return &Component_OpticalChannel_ModulatorBiasXi_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xi/interval"
func (n *Component_OpticalChannel_ModulatorBiasXiPathAny) Interval() *Component_OpticalChannel_ModulatorBiasXi_IntervalPathAny {
	return &Component_OpticalChannel_ModulatorBiasXi_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xi/max"
func (n *Component_OpticalChannel_ModulatorBiasXiPath) Max() *Component_OpticalChannel_ModulatorBiasXi_MaxPath {
	return &Component_OpticalChannel_ModulatorBiasXi_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xi/max"
func (n *Component_OpticalChannel_ModulatorBiasXiPathAny) Max() *Component_OpticalChannel_ModulatorBiasXi_MaxPathAny {
	return &Component_OpticalChannel_ModulatorBiasXi_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xi/max-time"
func (n *Component_OpticalChannel_ModulatorBiasXiPath) MaxTime() *Component_OpticalChannel_ModulatorBiasXi_MaxTimePath {
	return &Component_OpticalChannel_ModulatorBiasXi_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xi/max-time"
func (n *Component_OpticalChannel_ModulatorBiasXiPathAny) MaxTime() *Component_OpticalChannel_ModulatorBiasXi_MaxTimePathAny {
	return &Component_OpticalChannel_ModulatorBiasXi_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xi/min"
func (n *Component_OpticalChannel_ModulatorBiasXiPath) Min() *Component_OpticalChannel_ModulatorBiasXi_MinPath {
	return &Component_OpticalChannel_ModulatorBiasXi_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xi/min"
func (n *Component_OpticalChannel_ModulatorBiasXiPathAny) Min() *Component_OpticalChannel_ModulatorBiasXi_MinPathAny {
	return &Component_OpticalChannel_ModulatorBiasXi_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xi/min-time"
func (n *Component_OpticalChannel_ModulatorBiasXiPath) MinTime() *Component_OpticalChannel_ModulatorBiasXi_MinTimePath {
	return &Component_OpticalChannel_ModulatorBiasXi_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xi/min-time"
func (n *Component_OpticalChannel_ModulatorBiasXiPathAny) MinTime() *Component_OpticalChannel_ModulatorBiasXi_MinTimePathAny {
	return &Component_OpticalChannel_ModulatorBiasXi_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_ModulatorBiasXqPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xq YANG schema element.
type Component_OpticalChannel_ModulatorBiasXqPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXqPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xq YANG schema element.
type Component_OpticalChannel_ModulatorBiasXqPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXq_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xq/avg YANG schema element.
type Component_OpticalChannel_ModulatorBiasXq_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXq_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xq/avg YANG schema element.
type Component_OpticalChannel_ModulatorBiasXq_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXq_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xq/instant YANG schema element.
type Component_OpticalChannel_ModulatorBiasXq_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXq_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xq/instant YANG schema element.
type Component_OpticalChannel_ModulatorBiasXq_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXq_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xq/interval YANG schema element.
type Component_OpticalChannel_ModulatorBiasXq_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXq_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xq/interval YANG schema element.
type Component_OpticalChannel_ModulatorBiasXq_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXq_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xq/max YANG schema element.
type Component_OpticalChannel_ModulatorBiasXq_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXq_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xq/max YANG schema element.
type Component_OpticalChannel_ModulatorBiasXq_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXq_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xq/max-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasXq_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXq_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xq/max-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasXq_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXq_MinPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xq/min YANG schema element.
type Component_OpticalChannel_ModulatorBiasXq_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXq_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xq/min YANG schema element.
type Component_OpticalChannel_ModulatorBiasXq_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXq_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xq/min-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasXq_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasXq_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-xq/min-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasXq_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xq/avg"
func (n *Component_OpticalChannel_ModulatorBiasXqPath) Avg() *Component_OpticalChannel_ModulatorBiasXq_AvgPath {
	return &Component_OpticalChannel_ModulatorBiasXq_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xq/avg"
func (n *Component_OpticalChannel_ModulatorBiasXqPathAny) Avg() *Component_OpticalChannel_ModulatorBiasXq_AvgPathAny {
	return &Component_OpticalChannel_ModulatorBiasXq_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xq/instant"
func (n *Component_OpticalChannel_ModulatorBiasXqPath) Instant() *Component_OpticalChannel_ModulatorBiasXq_InstantPath {
	return &Component_OpticalChannel_ModulatorBiasXq_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xq/instant"
func (n *Component_OpticalChannel_ModulatorBiasXqPathAny) Instant() *Component_OpticalChannel_ModulatorBiasXq_InstantPathAny {
	return &Component_OpticalChannel_ModulatorBiasXq_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xq/interval"
func (n *Component_OpticalChannel_ModulatorBiasXqPath) Interval() *Component_OpticalChannel_ModulatorBiasXq_IntervalPath {
	return &Component_OpticalChannel_ModulatorBiasXq_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xq/interval"
func (n *Component_OpticalChannel_ModulatorBiasXqPathAny) Interval() *Component_OpticalChannel_ModulatorBiasXq_IntervalPathAny {
	return &Component_OpticalChannel_ModulatorBiasXq_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xq/max"
func (n *Component_OpticalChannel_ModulatorBiasXqPath) Max() *Component_OpticalChannel_ModulatorBiasXq_MaxPath {
	return &Component_OpticalChannel_ModulatorBiasXq_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xq/max"
func (n *Component_OpticalChannel_ModulatorBiasXqPathAny) Max() *Component_OpticalChannel_ModulatorBiasXq_MaxPathAny {
	return &Component_OpticalChannel_ModulatorBiasXq_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xq/max-time"
func (n *Component_OpticalChannel_ModulatorBiasXqPath) MaxTime() *Component_OpticalChannel_ModulatorBiasXq_MaxTimePath {
	return &Component_OpticalChannel_ModulatorBiasXq_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xq/max-time"
func (n *Component_OpticalChannel_ModulatorBiasXqPathAny) MaxTime() *Component_OpticalChannel_ModulatorBiasXq_MaxTimePathAny {
	return &Component_OpticalChannel_ModulatorBiasXq_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xq/min"
func (n *Component_OpticalChannel_ModulatorBiasXqPath) Min() *Component_OpticalChannel_ModulatorBiasXq_MinPath {
	return &Component_OpticalChannel_ModulatorBiasXq_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xq/min"
func (n *Component_OpticalChannel_ModulatorBiasXqPathAny) Min() *Component_OpticalChannel_ModulatorBiasXq_MinPathAny {
	return &Component_OpticalChannel_ModulatorBiasXq_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xq/min-time"
func (n *Component_OpticalChannel_ModulatorBiasXqPath) MinTime() *Component_OpticalChannel_ModulatorBiasXq_MinTimePath {
	return &Component_OpticalChannel_ModulatorBiasXq_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-xq/min-time"
func (n *Component_OpticalChannel_ModulatorBiasXqPathAny) MinTime() *Component_OpticalChannel_ModulatorBiasXq_MinTimePathAny {
	return &Component_OpticalChannel_ModulatorBiasXq_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_ModulatorBiasYPhasePath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-y-phase YANG schema element.
type Component_OpticalChannel_ModulatorBiasYPhasePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYPhasePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-y-phase YANG schema element.
type Component_OpticalChannel_ModulatorBiasYPhasePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYPhase_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-y-phase/avg YANG schema element.
type Component_OpticalChannel_ModulatorBiasYPhase_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYPhase_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-y-phase/avg YANG schema element.
type Component_OpticalChannel_ModulatorBiasYPhase_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYPhase_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-y-phase/instant YANG schema element.
type Component_OpticalChannel_ModulatorBiasYPhase_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYPhase_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-y-phase/instant YANG schema element.
type Component_OpticalChannel_ModulatorBiasYPhase_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYPhase_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-y-phase/interval YANG schema element.
type Component_OpticalChannel_ModulatorBiasYPhase_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYPhase_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-y-phase/interval YANG schema element.
type Component_OpticalChannel_ModulatorBiasYPhase_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYPhase_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-y-phase/max YANG schema element.
type Component_OpticalChannel_ModulatorBiasYPhase_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYPhase_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-y-phase/max YANG schema element.
type Component_OpticalChannel_ModulatorBiasYPhase_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYPhase_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-y-phase/max-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasYPhase_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYPhase_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-y-phase/max-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasYPhase_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYPhase_MinPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-y-phase/min YANG schema element.
type Component_OpticalChannel_ModulatorBiasYPhase_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYPhase_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-y-phase/min YANG schema element.
type Component_OpticalChannel_ModulatorBiasYPhase_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYPhase_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-y-phase/min-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasYPhase_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYPhase_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-y-phase/min-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasYPhase_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/modulator-bias-y-phase/avg"
func (n *Component_OpticalChannel_ModulatorBiasYPhasePath) Avg() *Component_OpticalChannel_ModulatorBiasYPhase_AvgPath {
	return &Component_OpticalChannel_ModulatorBiasYPhase_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/modulator-bias-y-phase/avg"
func (n *Component_OpticalChannel_ModulatorBiasYPhasePathAny) Avg() *Component_OpticalChannel_ModulatorBiasYPhase_AvgPathAny {
	return &Component_OpticalChannel_ModulatorBiasYPhase_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/modulator-bias-y-phase/instant"
func (n *Component_OpticalChannel_ModulatorBiasYPhasePath) Instant() *Component_OpticalChannel_ModulatorBiasYPhase_InstantPath {
	return &Component_OpticalChannel_ModulatorBiasYPhase_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/modulator-bias-y-phase/instant"
func (n *Component_OpticalChannel_ModulatorBiasYPhasePathAny) Instant() *Component_OpticalChannel_ModulatorBiasYPhase_InstantPathAny {
	return &Component_OpticalChannel_ModulatorBiasYPhase_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/modulator-bias-y-phase/interval"
func (n *Component_OpticalChannel_ModulatorBiasYPhasePath) Interval() *Component_OpticalChannel_ModulatorBiasYPhase_IntervalPath {
	return &Component_OpticalChannel_ModulatorBiasYPhase_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/modulator-bias-y-phase/interval"
func (n *Component_OpticalChannel_ModulatorBiasYPhasePathAny) Interval() *Component_OpticalChannel_ModulatorBiasYPhase_IntervalPathAny {
	return &Component_OpticalChannel_ModulatorBiasYPhase_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/modulator-bias-y-phase/max"
func (n *Component_OpticalChannel_ModulatorBiasYPhasePath) Max() *Component_OpticalChannel_ModulatorBiasYPhase_MaxPath {
	return &Component_OpticalChannel_ModulatorBiasYPhase_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/modulator-bias-y-phase/max"
func (n *Component_OpticalChannel_ModulatorBiasYPhasePathAny) Max() *Component_OpticalChannel_ModulatorBiasYPhase_MaxPathAny {
	return &Component_OpticalChannel_ModulatorBiasYPhase_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-y-phase/max-time"
func (n *Component_OpticalChannel_ModulatorBiasYPhasePath) MaxTime() *Component_OpticalChannel_ModulatorBiasYPhase_MaxTimePath {
	return &Component_OpticalChannel_ModulatorBiasYPhase_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-y-phase/max-time"
func (n *Component_OpticalChannel_ModulatorBiasYPhasePathAny) MaxTime() *Component_OpticalChannel_ModulatorBiasYPhase_MaxTimePathAny {
	return &Component_OpticalChannel_ModulatorBiasYPhase_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/modulator-bias-y-phase/min"
func (n *Component_OpticalChannel_ModulatorBiasYPhasePath) Min() *Component_OpticalChannel_ModulatorBiasYPhase_MinPath {
	return &Component_OpticalChannel_ModulatorBiasYPhase_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/modulator-bias-y-phase/min"
func (n *Component_OpticalChannel_ModulatorBiasYPhasePathAny) Min() *Component_OpticalChannel_ModulatorBiasYPhase_MinPathAny {
	return &Component_OpticalChannel_ModulatorBiasYPhase_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-y-phase/min-time"
func (n *Component_OpticalChannel_ModulatorBiasYPhasePath) MinTime() *Component_OpticalChannel_ModulatorBiasYPhase_MinTimePath {
	return &Component_OpticalChannel_ModulatorBiasYPhase_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-y-phase/min-time"
func (n *Component_OpticalChannel_ModulatorBiasYPhasePathAny) MinTime() *Component_OpticalChannel_ModulatorBiasYPhase_MinTimePathAny {
	return &Component_OpticalChannel_ModulatorBiasYPhase_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_ModulatorBiasYiPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yi YANG schema element.
type Component_OpticalChannel_ModulatorBiasYiPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYiPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yi YANG schema element.
type Component_OpticalChannel_ModulatorBiasYiPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYi_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yi/avg YANG schema element.
type Component_OpticalChannel_ModulatorBiasYi_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYi_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yi/avg YANG schema element.
type Component_OpticalChannel_ModulatorBiasYi_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYi_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yi/instant YANG schema element.
type Component_OpticalChannel_ModulatorBiasYi_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYi_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yi/instant YANG schema element.
type Component_OpticalChannel_ModulatorBiasYi_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYi_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yi/interval YANG schema element.
type Component_OpticalChannel_ModulatorBiasYi_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYi_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yi/interval YANG schema element.
type Component_OpticalChannel_ModulatorBiasYi_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYi_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yi/max YANG schema element.
type Component_OpticalChannel_ModulatorBiasYi_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYi_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yi/max YANG schema element.
type Component_OpticalChannel_ModulatorBiasYi_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYi_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yi/max-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasYi_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYi_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yi/max-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasYi_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYi_MinPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yi/min YANG schema element.
type Component_OpticalChannel_ModulatorBiasYi_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYi_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yi/min YANG schema element.
type Component_OpticalChannel_ModulatorBiasYi_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYi_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yi/min-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasYi_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYi_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yi/min-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasYi_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yi/avg"
func (n *Component_OpticalChannel_ModulatorBiasYiPath) Avg() *Component_OpticalChannel_ModulatorBiasYi_AvgPath {
	return &Component_OpticalChannel_ModulatorBiasYi_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yi/avg"
func (n *Component_OpticalChannel_ModulatorBiasYiPathAny) Avg() *Component_OpticalChannel_ModulatorBiasYi_AvgPathAny {
	return &Component_OpticalChannel_ModulatorBiasYi_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yi/instant"
func (n *Component_OpticalChannel_ModulatorBiasYiPath) Instant() *Component_OpticalChannel_ModulatorBiasYi_InstantPath {
	return &Component_OpticalChannel_ModulatorBiasYi_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yi/instant"
func (n *Component_OpticalChannel_ModulatorBiasYiPathAny) Instant() *Component_OpticalChannel_ModulatorBiasYi_InstantPathAny {
	return &Component_OpticalChannel_ModulatorBiasYi_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yi/interval"
func (n *Component_OpticalChannel_ModulatorBiasYiPath) Interval() *Component_OpticalChannel_ModulatorBiasYi_IntervalPath {
	return &Component_OpticalChannel_ModulatorBiasYi_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yi/interval"
func (n *Component_OpticalChannel_ModulatorBiasYiPathAny) Interval() *Component_OpticalChannel_ModulatorBiasYi_IntervalPathAny {
	return &Component_OpticalChannel_ModulatorBiasYi_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yi/max"
func (n *Component_OpticalChannel_ModulatorBiasYiPath) Max() *Component_OpticalChannel_ModulatorBiasYi_MaxPath {
	return &Component_OpticalChannel_ModulatorBiasYi_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yi/max"
func (n *Component_OpticalChannel_ModulatorBiasYiPathAny) Max() *Component_OpticalChannel_ModulatorBiasYi_MaxPathAny {
	return &Component_OpticalChannel_ModulatorBiasYi_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yi/max-time"
func (n *Component_OpticalChannel_ModulatorBiasYiPath) MaxTime() *Component_OpticalChannel_ModulatorBiasYi_MaxTimePath {
	return &Component_OpticalChannel_ModulatorBiasYi_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yi/max-time"
func (n *Component_OpticalChannel_ModulatorBiasYiPathAny) MaxTime() *Component_OpticalChannel_ModulatorBiasYi_MaxTimePathAny {
	return &Component_OpticalChannel_ModulatorBiasYi_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yi/min"
func (n *Component_OpticalChannel_ModulatorBiasYiPath) Min() *Component_OpticalChannel_ModulatorBiasYi_MinPath {
	return &Component_OpticalChannel_ModulatorBiasYi_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yi/min"
func (n *Component_OpticalChannel_ModulatorBiasYiPathAny) Min() *Component_OpticalChannel_ModulatorBiasYi_MinPathAny {
	return &Component_OpticalChannel_ModulatorBiasYi_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yi/min-time"
func (n *Component_OpticalChannel_ModulatorBiasYiPath) MinTime() *Component_OpticalChannel_ModulatorBiasYi_MinTimePath {
	return &Component_OpticalChannel_ModulatorBiasYi_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yi/min-time"
func (n *Component_OpticalChannel_ModulatorBiasYiPathAny) MinTime() *Component_OpticalChannel_ModulatorBiasYi_MinTimePathAny {
	return &Component_OpticalChannel_ModulatorBiasYi_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_ModulatorBiasYqPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yq YANG schema element.
type Component_OpticalChannel_ModulatorBiasYqPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYqPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yq YANG schema element.
type Component_OpticalChannel_ModulatorBiasYqPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYq_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yq/avg YANG schema element.
type Component_OpticalChannel_ModulatorBiasYq_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYq_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yq/avg YANG schema element.
type Component_OpticalChannel_ModulatorBiasYq_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYq_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yq/instant YANG schema element.
type Component_OpticalChannel_ModulatorBiasYq_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYq_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yq/instant YANG schema element.
type Component_OpticalChannel_ModulatorBiasYq_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYq_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yq/interval YANG schema element.
type Component_OpticalChannel_ModulatorBiasYq_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYq_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yq/interval YANG schema element.
type Component_OpticalChannel_ModulatorBiasYq_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYq_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yq/max YANG schema element.
type Component_OpticalChannel_ModulatorBiasYq_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYq_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yq/max YANG schema element.
type Component_OpticalChannel_ModulatorBiasYq_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYq_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yq/max-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasYq_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYq_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yq/max-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasYq_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYq_MinPath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yq/min YANG schema element.
type Component_OpticalChannel_ModulatorBiasYq_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYq_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yq/min YANG schema element.
type Component_OpticalChannel_ModulatorBiasYq_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYq_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yq/min-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasYq_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_ModulatorBiasYq_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/modulator-bias-yq/min-time YANG schema element.
type Component_OpticalChannel_ModulatorBiasYq_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yq/avg"
func (n *Component_OpticalChannel_ModulatorBiasYqPath) Avg() *Component_OpticalChannel_ModulatorBiasYq_AvgPath {
	return &Component_OpticalChannel_ModulatorBiasYq_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yq/avg"
func (n *Component_OpticalChannel_ModulatorBiasYqPathAny) Avg() *Component_OpticalChannel_ModulatorBiasYq_AvgPathAny {
	return &Component_OpticalChannel_ModulatorBiasYq_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yq/instant"
func (n *Component_OpticalChannel_ModulatorBiasYqPath) Instant() *Component_OpticalChannel_ModulatorBiasYq_InstantPath {
	return &Component_OpticalChannel_ModulatorBiasYq_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yq/instant"
func (n *Component_OpticalChannel_ModulatorBiasYqPathAny) Instant() *Component_OpticalChannel_ModulatorBiasYq_InstantPathAny {
	return &Component_OpticalChannel_ModulatorBiasYq_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yq/interval"
func (n *Component_OpticalChannel_ModulatorBiasYqPath) Interval() *Component_OpticalChannel_ModulatorBiasYq_IntervalPath {
	return &Component_OpticalChannel_ModulatorBiasYq_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yq/interval"
func (n *Component_OpticalChannel_ModulatorBiasYqPathAny) Interval() *Component_OpticalChannel_ModulatorBiasYq_IntervalPathAny {
	return &Component_OpticalChannel_ModulatorBiasYq_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yq/max"
func (n *Component_OpticalChannel_ModulatorBiasYqPath) Max() *Component_OpticalChannel_ModulatorBiasYq_MaxPath {
	return &Component_OpticalChannel_ModulatorBiasYq_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yq/max"
func (n *Component_OpticalChannel_ModulatorBiasYqPathAny) Max() *Component_OpticalChannel_ModulatorBiasYq_MaxPathAny {
	return &Component_OpticalChannel_ModulatorBiasYq_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yq/max-time"
func (n *Component_OpticalChannel_ModulatorBiasYqPath) MaxTime() *Component_OpticalChannel_ModulatorBiasYq_MaxTimePath {
	return &Component_OpticalChannel_ModulatorBiasYq_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yq/max-time"
func (n *Component_OpticalChannel_ModulatorBiasYqPathAny) MaxTime() *Component_OpticalChannel_ModulatorBiasYq_MaxTimePathAny {
	return &Component_OpticalChannel_ModulatorBiasYq_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yq/min"
func (n *Component_OpticalChannel_ModulatorBiasYqPath) Min() *Component_OpticalChannel_ModulatorBiasYq_MinPath {
	return &Component_OpticalChannel_ModulatorBiasYq_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yq/min"
func (n *Component_OpticalChannel_ModulatorBiasYqPathAny) Min() *Component_OpticalChannel_ModulatorBiasYq_MinPathAny {
	return &Component_OpticalChannel_ModulatorBiasYq_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yq/min-time"
func (n *Component_OpticalChannel_ModulatorBiasYqPath) MinTime() *Component_OpticalChannel_ModulatorBiasYq_MinTimePath {
	return &Component_OpticalChannel_ModulatorBiasYq_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/modulator-bias-yq/min-time"
func (n *Component_OpticalChannel_ModulatorBiasYqPathAny) MinTime() *Component_OpticalChannel_ModulatorBiasYq_MinTimePathAny {
	return &Component_OpticalChannel_ModulatorBiasYq_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_OsnrPath represents the /openconfig-platform/components/component/optical-channel/state/osnr YANG schema element.
type Component_OpticalChannel_OsnrPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_OsnrPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/osnr YANG schema element.
type Component_OpticalChannel_OsnrPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Osnr_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/osnr/avg YANG schema element.
type Component_OpticalChannel_Osnr_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Osnr_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/osnr/avg YANG schema element.
type Component_OpticalChannel_Osnr_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Osnr_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/osnr/instant YANG schema element.
type Component_OpticalChannel_Osnr_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Osnr_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/osnr/instant YANG schema element.
type Component_OpticalChannel_Osnr_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Osnr_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/osnr/interval YANG schema element.
type Component_OpticalChannel_Osnr_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Osnr_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/osnr/interval YANG schema element.
type Component_OpticalChannel_Osnr_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Osnr_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/osnr/max YANG schema element.
type Component_OpticalChannel_Osnr_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Osnr_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/osnr/max YANG schema element.
type Component_OpticalChannel_Osnr_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Osnr_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/osnr/max-time YANG schema element.
type Component_OpticalChannel_Osnr_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Osnr_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/osnr/max-time YANG schema element.
type Component_OpticalChannel_Osnr_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Osnr_MinPath represents the /openconfig-platform/components/component/optical-channel/state/osnr/min YANG schema element.
type Component_OpticalChannel_Osnr_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Osnr_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/osnr/min YANG schema element.
type Component_OpticalChannel_Osnr_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Osnr_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/osnr/min-time YANG schema element.
type Component_OpticalChannel_Osnr_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_Osnr_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/osnr/min-time YANG schema element.
type Component_OpticalChannel_Osnr_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/osnr/avg"
func (n *Component_OpticalChannel_OsnrPath) Avg() *Component_OpticalChannel_Osnr_AvgPath {
	return &Component_OpticalChannel_Osnr_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/osnr/avg"
func (n *Component_OpticalChannel_OsnrPathAny) Avg() *Component_OpticalChannel_Osnr_AvgPathAny {
	return &Component_OpticalChannel_Osnr_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/osnr/instant"
func (n *Component_OpticalChannel_OsnrPath) Instant() *Component_OpticalChannel_Osnr_InstantPath {
	return &Component_OpticalChannel_Osnr_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/osnr/instant"
func (n *Component_OpticalChannel_OsnrPathAny) Instant() *Component_OpticalChannel_Osnr_InstantPathAny {
	return &Component_OpticalChannel_Osnr_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/osnr/interval"
func (n *Component_OpticalChannel_OsnrPath) Interval() *Component_OpticalChannel_Osnr_IntervalPath {
	return &Component_OpticalChannel_Osnr_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/osnr/interval"
func (n *Component_OpticalChannel_OsnrPathAny) Interval() *Component_OpticalChannel_Osnr_IntervalPathAny {
	return &Component_OpticalChannel_Osnr_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/osnr/max"
func (n *Component_OpticalChannel_OsnrPath) Max() *Component_OpticalChannel_Osnr_MaxPath {
	return &Component_OpticalChannel_Osnr_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/osnr/max"
func (n *Component_OpticalChannel_OsnrPathAny) Max() *Component_OpticalChannel_Osnr_MaxPathAny {
	return &Component_OpticalChannel_Osnr_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/osnr/max-time"
func (n *Component_OpticalChannel_OsnrPath) MaxTime() *Component_OpticalChannel_Osnr_MaxTimePath {
	return &Component_OpticalChannel_Osnr_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/osnr/max-time"
func (n *Component_OpticalChannel_OsnrPathAny) MaxTime() *Component_OpticalChannel_Osnr_MaxTimePathAny {
	return &Component_OpticalChannel_Osnr_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/osnr/min"
func (n *Component_OpticalChannel_OsnrPath) Min() *Component_OpticalChannel_Osnr_MinPath {
	return &Component_OpticalChannel_Osnr_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/osnr/min"
func (n *Component_OpticalChannel_OsnrPathAny) Min() *Component_OpticalChannel_Osnr_MinPathAny {
	return &Component_OpticalChannel_Osnr_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/osnr/min-time"
func (n *Component_OpticalChannel_OsnrPath) MinTime() *Component_OpticalChannel_Osnr_MinTimePath {
	return &Component_OpticalChannel_Osnr_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/osnr/min-time"
func (n *Component_OpticalChannel_OsnrPathAny) MinTime() *Component_OpticalChannel_Osnr_MinTimePathAny {
	return &Component_OpticalChannel_Osnr_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_OutputPowerPath represents the /openconfig-platform/components/component/optical-channel/state/output-power YANG schema element.
type Component_OpticalChannel_OutputPowerPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_OutputPowerPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/output-power YANG schema element.
type Component_OpticalChannel_OutputPowerPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_OutputPower_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/output-power/avg YANG schema element.
type Component_OpticalChannel_OutputPower_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_OutputPower_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/output-power/avg YANG schema element.
type Component_OpticalChannel_OutputPower_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_OutputPower_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/output-power/instant YANG schema element.
type Component_OpticalChannel_OutputPower_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_OutputPower_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/output-power/instant YANG schema element.
type Component_OpticalChannel_OutputPower_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_OutputPower_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/output-power/interval YANG schema element.
type Component_OpticalChannel_OutputPower_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_OutputPower_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/output-power/interval YANG schema element.
type Component_OpticalChannel_OutputPower_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_OutputPower_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/output-power/max YANG schema element.
type Component_OpticalChannel_OutputPower_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_OutputPower_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/output-power/max YANG schema element.
type Component_OpticalChannel_OutputPower_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_OutputPower_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/output-power/max-time YANG schema element.
type Component_OpticalChannel_OutputPower_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_OutputPower_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/output-power/max-time YANG schema element.
type Component_OpticalChannel_OutputPower_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_OutputPower_MinPath represents the /openconfig-platform/components/component/optical-channel/state/output-power/min YANG schema element.
type Component_OpticalChannel_OutputPower_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_OutputPower_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/output-power/min YANG schema element.
type Component_OpticalChannel_OutputPower_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_OutputPower_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/output-power/min-time YANG schema element.
type Component_OpticalChannel_OutputPower_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_OutputPower_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/output-power/min-time YANG schema element.
type Component_OpticalChannel_OutputPower_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/output-power/avg"
func (n *Component_OpticalChannel_OutputPowerPath) Avg() *Component_OpticalChannel_OutputPower_AvgPath {
	return &Component_OpticalChannel_OutputPower_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/output-power/avg"
func (n *Component_OpticalChannel_OutputPowerPathAny) Avg() *Component_OpticalChannel_OutputPower_AvgPathAny {
	return &Component_OpticalChannel_OutputPower_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/output-power/instant"
func (n *Component_OpticalChannel_OutputPowerPath) Instant() *Component_OpticalChannel_OutputPower_InstantPath {
	return &Component_OpticalChannel_OutputPower_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/output-power/instant"
func (n *Component_OpticalChannel_OutputPowerPathAny) Instant() *Component_OpticalChannel_OutputPower_InstantPathAny {
	return &Component_OpticalChannel_OutputPower_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/output-power/interval"
func (n *Component_OpticalChannel_OutputPowerPath) Interval() *Component_OpticalChannel_OutputPower_IntervalPath {
	return &Component_OpticalChannel_OutputPower_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/output-power/interval"
func (n *Component_OpticalChannel_OutputPowerPathAny) Interval() *Component_OpticalChannel_OutputPower_IntervalPathAny {
	return &Component_OpticalChannel_OutputPower_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/output-power/max"
func (n *Component_OpticalChannel_OutputPowerPath) Max() *Component_OpticalChannel_OutputPower_MaxPath {
	return &Component_OpticalChannel_OutputPower_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/output-power/max"
func (n *Component_OpticalChannel_OutputPowerPathAny) Max() *Component_OpticalChannel_OutputPower_MaxPathAny {
	return &Component_OpticalChannel_OutputPower_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/output-power/max-time"
func (n *Component_OpticalChannel_OutputPowerPath) MaxTime() *Component_OpticalChannel_OutputPower_MaxTimePath {
	return &Component_OpticalChannel_OutputPower_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/output-power/max-time"
func (n *Component_OpticalChannel_OutputPowerPathAny) MaxTime() *Component_OpticalChannel_OutputPower_MaxTimePathAny {
	return &Component_OpticalChannel_OutputPower_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/output-power/min"
func (n *Component_OpticalChannel_OutputPowerPath) Min() *Component_OpticalChannel_OutputPower_MinPath {
	return &Component_OpticalChannel_OutputPower_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/output-power/min"
func (n *Component_OpticalChannel_OutputPowerPathAny) Min() *Component_OpticalChannel_OutputPower_MinPathAny {
	return &Component_OpticalChannel_OutputPower_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/output-power/min-time"
func (n *Component_OpticalChannel_OutputPowerPath) MinTime() *Component_OpticalChannel_OutputPower_MinTimePath {
	return &Component_OpticalChannel_OutputPower_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/output-power/min-time"
func (n *Component_OpticalChannel_OutputPowerPathAny) MinTime() *Component_OpticalChannel_OutputPower_MinTimePathAny {
	return &Component_OpticalChannel_OutputPower_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_PolarizationDependentLossPath represents the /openconfig-platform/components/component/optical-channel/state/polarization-dependent-loss YANG schema element.
type Component_OpticalChannel_PolarizationDependentLossPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationDependentLossPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/polarization-dependent-loss YANG schema element.
type Component_OpticalChannel_PolarizationDependentLossPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationDependentLoss_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/polarization-dependent-loss/avg YANG schema element.
type Component_OpticalChannel_PolarizationDependentLoss_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationDependentLoss_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/polarization-dependent-loss/avg YANG schema element.
type Component_OpticalChannel_PolarizationDependentLoss_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationDependentLoss_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/polarization-dependent-loss/instant YANG schema element.
type Component_OpticalChannel_PolarizationDependentLoss_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationDependentLoss_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/polarization-dependent-loss/instant YANG schema element.
type Component_OpticalChannel_PolarizationDependentLoss_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationDependentLoss_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/polarization-dependent-loss/interval YANG schema element.
type Component_OpticalChannel_PolarizationDependentLoss_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationDependentLoss_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/polarization-dependent-loss/interval YANG schema element.
type Component_OpticalChannel_PolarizationDependentLoss_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationDependentLoss_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/polarization-dependent-loss/max YANG schema element.
type Component_OpticalChannel_PolarizationDependentLoss_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationDependentLoss_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/polarization-dependent-loss/max YANG schema element.
type Component_OpticalChannel_PolarizationDependentLoss_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationDependentLoss_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/polarization-dependent-loss/max-time YANG schema element.
type Component_OpticalChannel_PolarizationDependentLoss_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationDependentLoss_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/polarization-dependent-loss/max-time YANG schema element.
type Component_OpticalChannel_PolarizationDependentLoss_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationDependentLoss_MinPath represents the /openconfig-platform/components/component/optical-channel/state/polarization-dependent-loss/min YANG schema element.
type Component_OpticalChannel_PolarizationDependentLoss_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationDependentLoss_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/polarization-dependent-loss/min YANG schema element.
type Component_OpticalChannel_PolarizationDependentLoss_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationDependentLoss_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/polarization-dependent-loss/min-time YANG schema element.
type Component_OpticalChannel_PolarizationDependentLoss_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationDependentLoss_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/polarization-dependent-loss/min-time YANG schema element.
type Component_OpticalChannel_PolarizationDependentLoss_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/polarization-dependent-loss/avg"
func (n *Component_OpticalChannel_PolarizationDependentLossPath) Avg() *Component_OpticalChannel_PolarizationDependentLoss_AvgPath {
	return &Component_OpticalChannel_PolarizationDependentLoss_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/polarization-dependent-loss/avg"
func (n *Component_OpticalChannel_PolarizationDependentLossPathAny) Avg() *Component_OpticalChannel_PolarizationDependentLoss_AvgPathAny {
	return &Component_OpticalChannel_PolarizationDependentLoss_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/polarization-dependent-loss/instant"
func (n *Component_OpticalChannel_PolarizationDependentLossPath) Instant() *Component_OpticalChannel_PolarizationDependentLoss_InstantPath {
	return &Component_OpticalChannel_PolarizationDependentLoss_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/polarization-dependent-loss/instant"
func (n *Component_OpticalChannel_PolarizationDependentLossPathAny) Instant() *Component_OpticalChannel_PolarizationDependentLoss_InstantPathAny {
	return &Component_OpticalChannel_PolarizationDependentLoss_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/polarization-dependent-loss/interval"
func (n *Component_OpticalChannel_PolarizationDependentLossPath) Interval() *Component_OpticalChannel_PolarizationDependentLoss_IntervalPath {
	return &Component_OpticalChannel_PolarizationDependentLoss_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/polarization-dependent-loss/interval"
func (n *Component_OpticalChannel_PolarizationDependentLossPathAny) Interval() *Component_OpticalChannel_PolarizationDependentLoss_IntervalPathAny {
	return &Component_OpticalChannel_PolarizationDependentLoss_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/polarization-dependent-loss/max"
func (n *Component_OpticalChannel_PolarizationDependentLossPath) Max() *Component_OpticalChannel_PolarizationDependentLoss_MaxPath {
	return &Component_OpticalChannel_PolarizationDependentLoss_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/polarization-dependent-loss/max"
func (n *Component_OpticalChannel_PolarizationDependentLossPathAny) Max() *Component_OpticalChannel_PolarizationDependentLoss_MaxPathAny {
	return &Component_OpticalChannel_PolarizationDependentLoss_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/polarization-dependent-loss/max-time"
func (n *Component_OpticalChannel_PolarizationDependentLossPath) MaxTime() *Component_OpticalChannel_PolarizationDependentLoss_MaxTimePath {
	return &Component_OpticalChannel_PolarizationDependentLoss_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/polarization-dependent-loss/max-time"
func (n *Component_OpticalChannel_PolarizationDependentLossPathAny) MaxTime() *Component_OpticalChannel_PolarizationDependentLoss_MaxTimePathAny {
	return &Component_OpticalChannel_PolarizationDependentLoss_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/polarization-dependent-loss/min"
func (n *Component_OpticalChannel_PolarizationDependentLossPath) Min() *Component_OpticalChannel_PolarizationDependentLoss_MinPath {
	return &Component_OpticalChannel_PolarizationDependentLoss_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/polarization-dependent-loss/min"
func (n *Component_OpticalChannel_PolarizationDependentLossPathAny) Min() *Component_OpticalChannel_PolarizationDependentLoss_MinPathAny {
	return &Component_OpticalChannel_PolarizationDependentLoss_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/polarization-dependent-loss/min-time"
func (n *Component_OpticalChannel_PolarizationDependentLossPath) MinTime() *Component_OpticalChannel_PolarizationDependentLoss_MinTimePath {
	return &Component_OpticalChannel_PolarizationDependentLoss_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/polarization-dependent-loss/min-time"
func (n *Component_OpticalChannel_PolarizationDependentLossPathAny) MinTime() *Component_OpticalChannel_PolarizationDependentLoss_MinTimePathAny {
	return &Component_OpticalChannel_PolarizationDependentLoss_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_PolarizationModeDispersionPath represents the /openconfig-platform/components/component/optical-channel/state/polarization-mode-dispersion YANG schema element.
type Component_OpticalChannel_PolarizationModeDispersionPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationModeDispersionPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/polarization-mode-dispersion YANG schema element.
type Component_OpticalChannel_PolarizationModeDispersionPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationModeDispersion_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/polarization-mode-dispersion/avg YANG schema element.
type Component_OpticalChannel_PolarizationModeDispersion_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationModeDispersion_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/polarization-mode-dispersion/avg YANG schema element.
type Component_OpticalChannel_PolarizationModeDispersion_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationModeDispersion_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/polarization-mode-dispersion/instant YANG schema element.
type Component_OpticalChannel_PolarizationModeDispersion_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationModeDispersion_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/polarization-mode-dispersion/instant YANG schema element.
type Component_OpticalChannel_PolarizationModeDispersion_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationModeDispersion_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/polarization-mode-dispersion/interval YANG schema element.
type Component_OpticalChannel_PolarizationModeDispersion_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationModeDispersion_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/polarization-mode-dispersion/interval YANG schema element.
type Component_OpticalChannel_PolarizationModeDispersion_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationModeDispersion_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/polarization-mode-dispersion/max YANG schema element.
type Component_OpticalChannel_PolarizationModeDispersion_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationModeDispersion_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/polarization-mode-dispersion/max YANG schema element.
type Component_OpticalChannel_PolarizationModeDispersion_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationModeDispersion_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/polarization-mode-dispersion/max-time YANG schema element.
type Component_OpticalChannel_PolarizationModeDispersion_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationModeDispersion_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/polarization-mode-dispersion/max-time YANG schema element.
type Component_OpticalChannel_PolarizationModeDispersion_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationModeDispersion_MinPath represents the /openconfig-platform/components/component/optical-channel/state/polarization-mode-dispersion/min YANG schema element.
type Component_OpticalChannel_PolarizationModeDispersion_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationModeDispersion_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/polarization-mode-dispersion/min YANG schema element.
type Component_OpticalChannel_PolarizationModeDispersion_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationModeDispersion_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/polarization-mode-dispersion/min-time YANG schema element.
type Component_OpticalChannel_PolarizationModeDispersion_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PolarizationModeDispersion_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/polarization-mode-dispersion/min-time YANG schema element.
type Component_OpticalChannel_PolarizationModeDispersion_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/polarization-mode-dispersion/avg"
func (n *Component_OpticalChannel_PolarizationModeDispersionPath) Avg() *Component_OpticalChannel_PolarizationModeDispersion_AvgPath {
	return &Component_OpticalChannel_PolarizationModeDispersion_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/polarization-mode-dispersion/avg"
func (n *Component_OpticalChannel_PolarizationModeDispersionPathAny) Avg() *Component_OpticalChannel_PolarizationModeDispersion_AvgPathAny {
	return &Component_OpticalChannel_PolarizationModeDispersion_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/polarization-mode-dispersion/instant"
func (n *Component_OpticalChannel_PolarizationModeDispersionPath) Instant() *Component_OpticalChannel_PolarizationModeDispersion_InstantPath {
	return &Component_OpticalChannel_PolarizationModeDispersion_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/polarization-mode-dispersion/instant"
func (n *Component_OpticalChannel_PolarizationModeDispersionPathAny) Instant() *Component_OpticalChannel_PolarizationModeDispersion_InstantPathAny {
	return &Component_OpticalChannel_PolarizationModeDispersion_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/polarization-mode-dispersion/interval"
func (n *Component_OpticalChannel_PolarizationModeDispersionPath) Interval() *Component_OpticalChannel_PolarizationModeDispersion_IntervalPath {
	return &Component_OpticalChannel_PolarizationModeDispersion_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/polarization-mode-dispersion/interval"
func (n *Component_OpticalChannel_PolarizationModeDispersionPathAny) Interval() *Component_OpticalChannel_PolarizationModeDispersion_IntervalPathAny {
	return &Component_OpticalChannel_PolarizationModeDispersion_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/polarization-mode-dispersion/max"
func (n *Component_OpticalChannel_PolarizationModeDispersionPath) Max() *Component_OpticalChannel_PolarizationModeDispersion_MaxPath {
	return &Component_OpticalChannel_PolarizationModeDispersion_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/polarization-mode-dispersion/max"
func (n *Component_OpticalChannel_PolarizationModeDispersionPathAny) Max() *Component_OpticalChannel_PolarizationModeDispersion_MaxPathAny {
	return &Component_OpticalChannel_PolarizationModeDispersion_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/polarization-mode-dispersion/max-time"
func (n *Component_OpticalChannel_PolarizationModeDispersionPath) MaxTime() *Component_OpticalChannel_PolarizationModeDispersion_MaxTimePath {
	return &Component_OpticalChannel_PolarizationModeDispersion_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/polarization-mode-dispersion/max-time"
func (n *Component_OpticalChannel_PolarizationModeDispersionPathAny) MaxTime() *Component_OpticalChannel_PolarizationModeDispersion_MaxTimePathAny {
	return &Component_OpticalChannel_PolarizationModeDispersion_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/polarization-mode-dispersion/min"
func (n *Component_OpticalChannel_PolarizationModeDispersionPath) Min() *Component_OpticalChannel_PolarizationModeDispersion_MinPath {
	return &Component_OpticalChannel_PolarizationModeDispersion_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/polarization-mode-dispersion/min"
func (n *Component_OpticalChannel_PolarizationModeDispersionPathAny) Min() *Component_OpticalChannel_PolarizationModeDispersion_MinPathAny {
	return &Component_OpticalChannel_PolarizationModeDispersion_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/polarization-mode-dispersion/min-time"
func (n *Component_OpticalChannel_PolarizationModeDispersionPath) MinTime() *Component_OpticalChannel_PolarizationModeDispersion_MinTimePath {
	return &Component_OpticalChannel_PolarizationModeDispersion_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/polarization-mode-dispersion/min-time"
func (n *Component_OpticalChannel_PolarizationModeDispersionPathAny) MinTime() *Component_OpticalChannel_PolarizationModeDispersion_MinTimePathAny {
	return &Component_OpticalChannel_PolarizationModeDispersion_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_PostFecBerPath represents the /openconfig-platform/components/component/optical-channel/state/post-fec-ber YANG schema element.
type Component_OpticalChannel_PostFecBerPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PostFecBerPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/post-fec-ber YANG schema element.
type Component_OpticalChannel_PostFecBerPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PostFecBer_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/post-fec-ber/avg YANG schema element.
type Component_OpticalChannel_PostFecBer_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PostFecBer_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/post-fec-ber/avg YANG schema element.
type Component_OpticalChannel_PostFecBer_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PostFecBer_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/post-fec-ber/instant YANG schema element.
type Component_OpticalChannel_PostFecBer_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PostFecBer_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/post-fec-ber/instant YANG schema element.
type Component_OpticalChannel_PostFecBer_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PostFecBer_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/post-fec-ber/interval YANG schema element.
type Component_OpticalChannel_PostFecBer_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PostFecBer_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/post-fec-ber/interval YANG schema element.
type Component_OpticalChannel_PostFecBer_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PostFecBer_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/post-fec-ber/max YANG schema element.
type Component_OpticalChannel_PostFecBer_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PostFecBer_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/post-fec-ber/max YANG schema element.
type Component_OpticalChannel_PostFecBer_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PostFecBer_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/post-fec-ber/max-time YANG schema element.
type Component_OpticalChannel_PostFecBer_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PostFecBer_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/post-fec-ber/max-time YANG schema element.
type Component_OpticalChannel_PostFecBer_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PostFecBer_MinPath represents the /openconfig-platform/components/component/optical-channel/state/post-fec-ber/min YANG schema element.
type Component_OpticalChannel_PostFecBer_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PostFecBer_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/post-fec-ber/min YANG schema element.
type Component_OpticalChannel_PostFecBer_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PostFecBer_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/post-fec-ber/min-time YANG schema element.
type Component_OpticalChannel_PostFecBer_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PostFecBer_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/post-fec-ber/min-time YANG schema element.
type Component_OpticalChannel_PostFecBer_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/post-fec-ber/avg"
func (n *Component_OpticalChannel_PostFecBerPath) Avg() *Component_OpticalChannel_PostFecBer_AvgPath {
	return &Component_OpticalChannel_PostFecBer_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/post-fec-ber/avg"
func (n *Component_OpticalChannel_PostFecBerPathAny) Avg() *Component_OpticalChannel_PostFecBer_AvgPathAny {
	return &Component_OpticalChannel_PostFecBer_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/post-fec-ber/instant"
func (n *Component_OpticalChannel_PostFecBerPath) Instant() *Component_OpticalChannel_PostFecBer_InstantPath {
	return &Component_OpticalChannel_PostFecBer_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/post-fec-ber/instant"
func (n *Component_OpticalChannel_PostFecBerPathAny) Instant() *Component_OpticalChannel_PostFecBer_InstantPathAny {
	return &Component_OpticalChannel_PostFecBer_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/post-fec-ber/interval"
func (n *Component_OpticalChannel_PostFecBerPath) Interval() *Component_OpticalChannel_PostFecBer_IntervalPath {
	return &Component_OpticalChannel_PostFecBer_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/post-fec-ber/interval"
func (n *Component_OpticalChannel_PostFecBerPathAny) Interval() *Component_OpticalChannel_PostFecBer_IntervalPathAny {
	return &Component_OpticalChannel_PostFecBer_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/post-fec-ber/max"
func (n *Component_OpticalChannel_PostFecBerPath) Max() *Component_OpticalChannel_PostFecBer_MaxPath {
	return &Component_OpticalChannel_PostFecBer_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/post-fec-ber/max"
func (n *Component_OpticalChannel_PostFecBerPathAny) Max() *Component_OpticalChannel_PostFecBer_MaxPathAny {
	return &Component_OpticalChannel_PostFecBer_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/post-fec-ber/max-time"
func (n *Component_OpticalChannel_PostFecBerPath) MaxTime() *Component_OpticalChannel_PostFecBer_MaxTimePath {
	return &Component_OpticalChannel_PostFecBer_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/post-fec-ber/max-time"
func (n *Component_OpticalChannel_PostFecBerPathAny) MaxTime() *Component_OpticalChannel_PostFecBer_MaxTimePathAny {
	return &Component_OpticalChannel_PostFecBer_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/post-fec-ber/min"
func (n *Component_OpticalChannel_PostFecBerPath) Min() *Component_OpticalChannel_PostFecBer_MinPath {
	return &Component_OpticalChannel_PostFecBer_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/post-fec-ber/min"
func (n *Component_OpticalChannel_PostFecBerPathAny) Min() *Component_OpticalChannel_PostFecBer_MinPathAny {
	return &Component_OpticalChannel_PostFecBer_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/post-fec-ber/min-time"
func (n *Component_OpticalChannel_PostFecBerPath) MinTime() *Component_OpticalChannel_PostFecBer_MinTimePath {
	return &Component_OpticalChannel_PostFecBer_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/post-fec-ber/min-time"
func (n *Component_OpticalChannel_PostFecBerPathAny) MinTime() *Component_OpticalChannel_PostFecBer_MinTimePathAny {
	return &Component_OpticalChannel_PostFecBer_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_PreFecBerPath represents the /openconfig-platform/components/component/optical-channel/state/pre-fec-ber YANG schema element.
type Component_OpticalChannel_PreFecBerPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PreFecBerPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/pre-fec-ber YANG schema element.
type Component_OpticalChannel_PreFecBerPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PreFecBer_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/pre-fec-ber/avg YANG schema element.
type Component_OpticalChannel_PreFecBer_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PreFecBer_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/pre-fec-ber/avg YANG schema element.
type Component_OpticalChannel_PreFecBer_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PreFecBer_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/pre-fec-ber/instant YANG schema element.
type Component_OpticalChannel_PreFecBer_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PreFecBer_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/pre-fec-ber/instant YANG schema element.
type Component_OpticalChannel_PreFecBer_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PreFecBer_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/pre-fec-ber/interval YANG schema element.
type Component_OpticalChannel_PreFecBer_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PreFecBer_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/pre-fec-ber/interval YANG schema element.
type Component_OpticalChannel_PreFecBer_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PreFecBer_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/pre-fec-ber/max YANG schema element.
type Component_OpticalChannel_PreFecBer_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PreFecBer_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/pre-fec-ber/max YANG schema element.
type Component_OpticalChannel_PreFecBer_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PreFecBer_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/pre-fec-ber/max-time YANG schema element.
type Component_OpticalChannel_PreFecBer_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PreFecBer_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/pre-fec-ber/max-time YANG schema element.
type Component_OpticalChannel_PreFecBer_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PreFecBer_MinPath represents the /openconfig-platform/components/component/optical-channel/state/pre-fec-ber/min YANG schema element.
type Component_OpticalChannel_PreFecBer_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PreFecBer_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/pre-fec-ber/min YANG schema element.
type Component_OpticalChannel_PreFecBer_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PreFecBer_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/pre-fec-ber/min-time YANG schema element.
type Component_OpticalChannel_PreFecBer_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_PreFecBer_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/pre-fec-ber/min-time YANG schema element.
type Component_OpticalChannel_PreFecBer_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/pre-fec-ber/avg"
func (n *Component_OpticalChannel_PreFecBerPath) Avg() *Component_OpticalChannel_PreFecBer_AvgPath {
	return &Component_OpticalChannel_PreFecBer_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/pre-fec-ber/avg"
func (n *Component_OpticalChannel_PreFecBerPathAny) Avg() *Component_OpticalChannel_PreFecBer_AvgPathAny {
	return &Component_OpticalChannel_PreFecBer_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/pre-fec-ber/instant"
func (n *Component_OpticalChannel_PreFecBerPath) Instant() *Component_OpticalChannel_PreFecBer_InstantPath {
	return &Component_OpticalChannel_PreFecBer_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/pre-fec-ber/instant"
func (n *Component_OpticalChannel_PreFecBerPathAny) Instant() *Component_OpticalChannel_PreFecBer_InstantPathAny {
	return &Component_OpticalChannel_PreFecBer_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/pre-fec-ber/interval"
func (n *Component_OpticalChannel_PreFecBerPath) Interval() *Component_OpticalChannel_PreFecBer_IntervalPath {
	return &Component_OpticalChannel_PreFecBer_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/pre-fec-ber/interval"
func (n *Component_OpticalChannel_PreFecBerPathAny) Interval() *Component_OpticalChannel_PreFecBer_IntervalPathAny {
	return &Component_OpticalChannel_PreFecBer_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/pre-fec-ber/max"
func (n *Component_OpticalChannel_PreFecBerPath) Max() *Component_OpticalChannel_PreFecBer_MaxPath {
	return &Component_OpticalChannel_PreFecBer_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/pre-fec-ber/max"
func (n *Component_OpticalChannel_PreFecBerPathAny) Max() *Component_OpticalChannel_PreFecBer_MaxPathAny {
	return &Component_OpticalChannel_PreFecBer_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/pre-fec-ber/max-time"
func (n *Component_OpticalChannel_PreFecBerPath) MaxTime() *Component_OpticalChannel_PreFecBer_MaxTimePath {
	return &Component_OpticalChannel_PreFecBer_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/pre-fec-ber/max-time"
func (n *Component_OpticalChannel_PreFecBerPathAny) MaxTime() *Component_OpticalChannel_PreFecBer_MaxTimePathAny {
	return &Component_OpticalChannel_PreFecBer_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/pre-fec-ber/min"
func (n *Component_OpticalChannel_PreFecBerPath) Min() *Component_OpticalChannel_PreFecBer_MinPath {
	return &Component_OpticalChannel_PreFecBer_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/pre-fec-ber/min"
func (n *Component_OpticalChannel_PreFecBerPathAny) Min() *Component_OpticalChannel_PreFecBer_MinPathAny {
	return &Component_OpticalChannel_PreFecBer_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/pre-fec-ber/min-time"
func (n *Component_OpticalChannel_PreFecBerPath) MinTime() *Component_OpticalChannel_PreFecBer_MinTimePath {
	return &Component_OpticalChannel_PreFecBer_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/pre-fec-ber/min-time"
func (n *Component_OpticalChannel_PreFecBerPathAny) MinTime() *Component_OpticalChannel_PreFecBer_MinTimePathAny {
	return &Component_OpticalChannel_PreFecBer_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_QValuePath represents the /openconfig-platform/components/component/optical-channel/state/q-value YANG schema element.
type Component_OpticalChannel_QValuePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_QValuePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/q-value YANG schema element.
type Component_OpticalChannel_QValuePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_QValue_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/q-value/avg YANG schema element.
type Component_OpticalChannel_QValue_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_QValue_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/q-value/avg YANG schema element.
type Component_OpticalChannel_QValue_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_QValue_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/q-value/instant YANG schema element.
type Component_OpticalChannel_QValue_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_QValue_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/q-value/instant YANG schema element.
type Component_OpticalChannel_QValue_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_QValue_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/q-value/interval YANG schema element.
type Component_OpticalChannel_QValue_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_QValue_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/q-value/interval YANG schema element.
type Component_OpticalChannel_QValue_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_QValue_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/q-value/max YANG schema element.
type Component_OpticalChannel_QValue_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_QValue_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/q-value/max YANG schema element.
type Component_OpticalChannel_QValue_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_QValue_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/q-value/max-time YANG schema element.
type Component_OpticalChannel_QValue_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_QValue_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/q-value/max-time YANG schema element.
type Component_OpticalChannel_QValue_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_QValue_MinPath represents the /openconfig-platform/components/component/optical-channel/state/q-value/min YANG schema element.
type Component_OpticalChannel_QValue_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_QValue_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/q-value/min YANG schema element.
type Component_OpticalChannel_QValue_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_QValue_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/q-value/min-time YANG schema element.
type Component_OpticalChannel_QValue_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_QValue_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/q-value/min-time YANG schema element.
type Component_OpticalChannel_QValue_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/q-value/avg"
func (n *Component_OpticalChannel_QValuePath) Avg() *Component_OpticalChannel_QValue_AvgPath {
	return &Component_OpticalChannel_QValue_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/q-value/avg"
func (n *Component_OpticalChannel_QValuePathAny) Avg() *Component_OpticalChannel_QValue_AvgPathAny {
	return &Component_OpticalChannel_QValue_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/q-value/instant"
func (n *Component_OpticalChannel_QValuePath) Instant() *Component_OpticalChannel_QValue_InstantPath {
	return &Component_OpticalChannel_QValue_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/q-value/instant"
func (n *Component_OpticalChannel_QValuePathAny) Instant() *Component_OpticalChannel_QValue_InstantPathAny {
	return &Component_OpticalChannel_QValue_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/q-value/interval"
func (n *Component_OpticalChannel_QValuePath) Interval() *Component_OpticalChannel_QValue_IntervalPath {
	return &Component_OpticalChannel_QValue_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/q-value/interval"
func (n *Component_OpticalChannel_QValuePathAny) Interval() *Component_OpticalChannel_QValue_IntervalPathAny {
	return &Component_OpticalChannel_QValue_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/q-value/max"
func (n *Component_OpticalChannel_QValuePath) Max() *Component_OpticalChannel_QValue_MaxPath {
	return &Component_OpticalChannel_QValue_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/q-value/max"
func (n *Component_OpticalChannel_QValuePathAny) Max() *Component_OpticalChannel_QValue_MaxPathAny {
	return &Component_OpticalChannel_QValue_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/q-value/max-time"
func (n *Component_OpticalChannel_QValuePath) MaxTime() *Component_OpticalChannel_QValue_MaxTimePath {
	return &Component_OpticalChannel_QValue_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/q-value/max-time"
func (n *Component_OpticalChannel_QValuePathAny) MaxTime() *Component_OpticalChannel_QValue_MaxTimePathAny {
	return &Component_OpticalChannel_QValue_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/q-value/min"
func (n *Component_OpticalChannel_QValuePath) Min() *Component_OpticalChannel_QValue_MinPath {
	return &Component_OpticalChannel_QValue_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/q-value/min"
func (n *Component_OpticalChannel_QValuePathAny) Min() *Component_OpticalChannel_QValue_MinPathAny {
	return &Component_OpticalChannel_QValue_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/q-value/min-time"
func (n *Component_OpticalChannel_QValuePath) MinTime() *Component_OpticalChannel_QValue_MinTimePath {
	return &Component_OpticalChannel_QValue_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/q-value/min-time"
func (n *Component_OpticalChannel_QValuePathAny) MinTime() *Component_OpticalChannel_QValue_MinTimePathAny {
	return &Component_OpticalChannel_QValue_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_SecondOrderPolarizationModeDispersionPath represents the /openconfig-platform/components/component/optical-channel/state/second-order-polarization-mode-dispersion YANG schema element.
type Component_OpticalChannel_SecondOrderPolarizationModeDispersionPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SecondOrderPolarizationModeDispersionPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/second-order-polarization-mode-dispersion YANG schema element.
type Component_OpticalChannel_SecondOrderPolarizationModeDispersionPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SecondOrderPolarizationModeDispersion_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/second-order-polarization-mode-dispersion/avg YANG schema element.
type Component_OpticalChannel_SecondOrderPolarizationModeDispersion_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SecondOrderPolarizationModeDispersion_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/second-order-polarization-mode-dispersion/avg YANG schema element.
type Component_OpticalChannel_SecondOrderPolarizationModeDispersion_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SecondOrderPolarizationModeDispersion_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/second-order-polarization-mode-dispersion/instant YANG schema element.
type Component_OpticalChannel_SecondOrderPolarizationModeDispersion_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SecondOrderPolarizationModeDispersion_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/second-order-polarization-mode-dispersion/instant YANG schema element.
type Component_OpticalChannel_SecondOrderPolarizationModeDispersion_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SecondOrderPolarizationModeDispersion_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/second-order-polarization-mode-dispersion/interval YANG schema element.
type Component_OpticalChannel_SecondOrderPolarizationModeDispersion_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SecondOrderPolarizationModeDispersion_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/second-order-polarization-mode-dispersion/interval YANG schema element.
type Component_OpticalChannel_SecondOrderPolarizationModeDispersion_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/second-order-polarization-mode-dispersion/max YANG schema element.
type Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/second-order-polarization-mode-dispersion/max YANG schema element.
type Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/second-order-polarization-mode-dispersion/max-time YANG schema element.
type Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/second-order-polarization-mode-dispersion/max-time YANG schema element.
type Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MinPath represents the /openconfig-platform/components/component/optical-channel/state/second-order-polarization-mode-dispersion/min YANG schema element.
type Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/second-order-polarization-mode-dispersion/min YANG schema element.
type Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/second-order-polarization-mode-dispersion/min-time YANG schema element.
type Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/second-order-polarization-mode-dispersion/min-time YANG schema element.
type Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/second-order-polarization-mode-dispersion/avg"
func (n *Component_OpticalChannel_SecondOrderPolarizationModeDispersionPath) Avg() *Component_OpticalChannel_SecondOrderPolarizationModeDispersion_AvgPath {
	return &Component_OpticalChannel_SecondOrderPolarizationModeDispersion_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/second-order-polarization-mode-dispersion/avg"
func (n *Component_OpticalChannel_SecondOrderPolarizationModeDispersionPathAny) Avg() *Component_OpticalChannel_SecondOrderPolarizationModeDispersion_AvgPathAny {
	return &Component_OpticalChannel_SecondOrderPolarizationModeDispersion_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/second-order-polarization-mode-dispersion/instant"
func (n *Component_OpticalChannel_SecondOrderPolarizationModeDispersionPath) Instant() *Component_OpticalChannel_SecondOrderPolarizationModeDispersion_InstantPath {
	return &Component_OpticalChannel_SecondOrderPolarizationModeDispersion_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/second-order-polarization-mode-dispersion/instant"
func (n *Component_OpticalChannel_SecondOrderPolarizationModeDispersionPathAny) Instant() *Component_OpticalChannel_SecondOrderPolarizationModeDispersion_InstantPathAny {
	return &Component_OpticalChannel_SecondOrderPolarizationModeDispersion_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/second-order-polarization-mode-dispersion/interval"
func (n *Component_OpticalChannel_SecondOrderPolarizationModeDispersionPath) Interval() *Component_OpticalChannel_SecondOrderPolarizationModeDispersion_IntervalPath {
	return &Component_OpticalChannel_SecondOrderPolarizationModeDispersion_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/second-order-polarization-mode-dispersion/interval"
func (n *Component_OpticalChannel_SecondOrderPolarizationModeDispersionPathAny) Interval() *Component_OpticalChannel_SecondOrderPolarizationModeDispersion_IntervalPathAny {
	return &Component_OpticalChannel_SecondOrderPolarizationModeDispersion_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/second-order-polarization-mode-dispersion/max"
func (n *Component_OpticalChannel_SecondOrderPolarizationModeDispersionPath) Max() *Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MaxPath {
	return &Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time
// interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/second-order-polarization-mode-dispersion/max"
func (n *Component_OpticalChannel_SecondOrderPolarizationModeDispersionPathAny) Max() *Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MaxPathAny {
	return &Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/second-order-polarization-mode-dispersion/max-time"
func (n *Component_OpticalChannel_SecondOrderPolarizationModeDispersionPath) MaxTime() *Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MaxTimePath {
	return &Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/second-order-polarization-mode-dispersion/max-time"
func (n *Component_OpticalChannel_SecondOrderPolarizationModeDispersionPathAny) MaxTime() *Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MaxTimePathAny {
	return &Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/second-order-polarization-mode-dispersion/min"
func (n *Component_OpticalChannel_SecondOrderPolarizationModeDispersionPath) Min() *Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MinPath {
	return &Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/second-order-polarization-mode-dispersion/min"
func (n *Component_OpticalChannel_SecondOrderPolarizationModeDispersionPathAny) Min() *Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MinPathAny {
	return &Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/second-order-polarization-mode-dispersion/min-time"
func (n *Component_OpticalChannel_SecondOrderPolarizationModeDispersionPath) MinTime() *Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MinTimePath {
	return &Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/second-order-polarization-mode-dispersion/min-time"
func (n *Component_OpticalChannel_SecondOrderPolarizationModeDispersionPathAny) MinTime() *Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MinTimePathAny {
	return &Component_OpticalChannel_SecondOrderPolarizationModeDispersion_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_OpticalChannel_SopRocPath represents the /openconfig-platform/components/component/optical-channel/state/sop-roc YANG schema element.
type Component_OpticalChannel_SopRocPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SopRocPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/sop-roc YANG schema element.
type Component_OpticalChannel_SopRocPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SopRoc_AvgPath represents the /openconfig-platform/components/component/optical-channel/state/sop-roc/avg YANG schema element.
type Component_OpticalChannel_SopRoc_AvgPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SopRoc_AvgPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/sop-roc/avg YANG schema element.
type Component_OpticalChannel_SopRoc_AvgPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SopRoc_InstantPath represents the /openconfig-platform/components/component/optical-channel/state/sop-roc/instant YANG schema element.
type Component_OpticalChannel_SopRoc_InstantPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SopRoc_InstantPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/sop-roc/instant YANG schema element.
type Component_OpticalChannel_SopRoc_InstantPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SopRoc_IntervalPath represents the /openconfig-platform/components/component/optical-channel/state/sop-roc/interval YANG schema element.
type Component_OpticalChannel_SopRoc_IntervalPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SopRoc_IntervalPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/sop-roc/interval YANG schema element.
type Component_OpticalChannel_SopRoc_IntervalPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SopRoc_MaxPath represents the /openconfig-platform/components/component/optical-channel/state/sop-roc/max YANG schema element.
type Component_OpticalChannel_SopRoc_MaxPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SopRoc_MaxPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/sop-roc/max YANG schema element.
type Component_OpticalChannel_SopRoc_MaxPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SopRoc_MaxTimePath represents the /openconfig-platform/components/component/optical-channel/state/sop-roc/max-time YANG schema element.
type Component_OpticalChannel_SopRoc_MaxTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SopRoc_MaxTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/sop-roc/max-time YANG schema element.
type Component_OpticalChannel_SopRoc_MaxTimePathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SopRoc_MinPath represents the /openconfig-platform/components/component/optical-channel/state/sop-roc/min YANG schema element.
type Component_OpticalChannel_SopRoc_MinPath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SopRoc_MinPathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/sop-roc/min YANG schema element.
type Component_OpticalChannel_SopRoc_MinPathAny struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SopRoc_MinTimePath represents the /openconfig-platform/components/component/optical-channel/state/sop-roc/min-time YANG schema element.
type Component_OpticalChannel_SopRoc_MinTimePath struct {
	*ygot.NodePath
}

// Component_OpticalChannel_SopRoc_MinTimePathAny represents the wildcard version of the /openconfig-platform/components/component/optical-channel/state/sop-roc/min-time YANG schema element.
type Component_OpticalChannel_SopRoc_MinTimePathAny struct {
	*ygot.NodePath
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/sop-roc/avg"
func (n *Component_OpticalChannel_SopRocPath) Avg() *Component_OpticalChannel_SopRoc_AvgPath {
	return &Component_OpticalChannel_SopRoc_AvgPath{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Avg (leaf): The arithmetic mean value of the statistic over the
// time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "avg"
// Path from root: "/components/component/optical-channel/state/sop-roc/avg"
func (n *Component_OpticalChannel_SopRocPathAny) Avg() *Component_OpticalChannel_SopRoc_AvgPathAny {
	return &Component_OpticalChannel_SopRoc_AvgPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"avg"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/sop-roc/instant"
func (n *Component_OpticalChannel_SopRocPath) Instant() *Component_OpticalChannel_SopRoc_InstantPath {
	return &Component_OpticalChannel_SopRoc_InstantPath{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Instant (leaf): The instantaneous value of the statistic.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "instant"
// Path from root: "/components/component/optical-channel/state/sop-roc/instant"
func (n *Component_OpticalChannel_SopRocPathAny) Instant() *Component_OpticalChannel_SopRoc_InstantPathAny {
	return &Component_OpticalChannel_SopRoc_InstantPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"instant"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/sop-roc/interval"
func (n *Component_OpticalChannel_SopRocPath) Interval() *Component_OpticalChannel_SopRoc_IntervalPath {
	return &Component_OpticalChannel_SopRoc_IntervalPath{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Interval (leaf): If supported by the system, this reports the time interval
// over which the min/max/average statistics are computed by
// the system.
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "interval"
// Path from root: "/components/component/optical-channel/state/sop-roc/interval"
func (n *Component_OpticalChannel_SopRocPathAny) Interval() *Component_OpticalChannel_SopRoc_IntervalPathAny {
	return &Component_OpticalChannel_SopRoc_IntervalPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"interval"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/sop-roc/max"
func (n *Component_OpticalChannel_SopRocPath) Max() *Component_OpticalChannel_SopRoc_MaxPath {
	return &Component_OpticalChannel_SopRoc_MaxPath{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// Max (leaf): The maximum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max"
// Path from root: "/components/component/optical-channel/state/sop-roc/max"
func (n *Component_OpticalChannel_SopRocPathAny) Max() *Component_OpticalChannel_SopRoc_MaxPathAny {
	return &Component_OpticalChannel_SopRoc_MaxPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/sop-roc/max-time"
func (n *Component_OpticalChannel_SopRocPath) MaxTime() *Component_OpticalChannel_SopRoc_MaxTimePath {
	return &Component_OpticalChannel_SopRoc_MaxTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MaxTime (leaf): The absolute time at which the maximum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "max-time"
// Path from root: "/components/component/optical-channel/state/sop-roc/max-time"
func (n *Component_OpticalChannel_SopRocPathAny) MaxTime() *Component_OpticalChannel_SopRoc_MaxTimePathAny {
	return &Component_OpticalChannel_SopRoc_MaxTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"max-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/sop-roc/min"
func (n *Component_OpticalChannel_SopRocPath) Min() *Component_OpticalChannel_SopRoc_MinPath {
	return &Component_OpticalChannel_SopRoc_MinPath{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// Min (leaf): The minimum value of the statistic over the time interval.
// ----------------------------------------
// Defining module: "openconfig-transport-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min"
// Path from root: "/components/component/optical-channel/state/sop-roc/min"
func (n *Component_OpticalChannel_SopRocPathAny) Min() *Component_OpticalChannel_SopRoc_MinPathAny {
	return &Component_OpticalChannel_SopRoc_MinPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/sop-roc/min-time"
func (n *Component_OpticalChannel_SopRocPath) MinTime() *Component_OpticalChannel_SopRoc_MinTimePath {
	return &Component_OpticalChannel_SopRoc_MinTimePath{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// MinTime (leaf): The absolute time at which the minimum value occurred.
// The value is the timestamp in nanoseconds relative to
//
//	the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
//
// ----------------------------------------
// Defining module: "openconfig-types"
// Instantiating module: "openconfig-platform"
// Path from parent: "min-time"
// Path from root: "/components/component/optical-channel/state/sop-roc/min-time"
func (n *Component_OpticalChannel_SopRocPathAny) MinTime() *Component_OpticalChannel_SopRoc_MinTimePathAny {
	return &Component_OpticalChannel_SopRoc_MinTimePathAny{
		NodePath: ygot.NewNodePath(
			[]string{"min-time"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_PciePath represents the /openconfig-platform/components/component/state/pcie YANG schema element.
type Component_PciePath struct {
	*ygot.NodePath
}

// Component_PciePathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie YANG schema element.
type Component_PciePathAny struct {
	*ygot.NodePath
}

// CorrectableErrors (container): The count of the correctable PCIe errors.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "correctable-errors"
// Path from root: "/components/component/state/pcie/correctable-errors"
func (n *Component_PciePath) CorrectableErrors() *Component_Pcie_CorrectableErrorsPath {
	return &Component_Pcie_CorrectableErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"correctable-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// CorrectableErrors (container): The count of the correctable PCIe errors.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "correctable-errors"
// Path from root: "/components/component/state/pcie/correctable-errors"
func (n *Component_PciePathAny) CorrectableErrors() *Component_Pcie_CorrectableErrorsPathAny {
	return &Component_Pcie_CorrectableErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"correctable-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// FatalErrors (container): The count of the fatal PCIe errors.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "fatal-errors"
// Path from root: "/components/component/state/pcie/fatal-errors"
func (n *Component_PciePath) FatalErrors() *Component_Pcie_FatalErrorsPath {
	return &Component_Pcie_FatalErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"fatal-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// FatalErrors (container): The count of the fatal PCIe errors.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "fatal-errors"
// Path from root: "/components/component/state/pcie/fatal-errors"
func (n *Component_PciePathAny) FatalErrors() *Component_Pcie_FatalErrorsPathAny {
	return &Component_Pcie_FatalErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"fatal-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// NonFatalErrors (container): The count of the non-fatal PCIe errors.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "non-fatal-errors"
// Path from root: "/components/component/state/pcie/non-fatal-errors"
func (n *Component_PciePath) NonFatalErrors() *Component_Pcie_NonFatalErrorsPath {
	return &Component_Pcie_NonFatalErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"non-fatal-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// NonFatalErrors (container): The count of the non-fatal PCIe errors.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "non-fatal-errors"
// Path from root: "/components/component/state/pcie/non-fatal-errors"
func (n *Component_PciePathAny) NonFatalErrors() *Component_Pcie_NonFatalErrorsPathAny {
	return &Component_Pcie_NonFatalErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"non-fatal-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_Pcie_CorrectableErrorsPath represents the /openconfig-platform/components/component/state/pcie/correctable-errors YANG schema element.
type Component_Pcie_CorrectableErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/correctable-errors YANG schema element.
type Component_Pcie_CorrectableErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrors_AdvisoryNonFatalErrorsPath represents the /openconfig-platform/components/component/state/pcie/correctable-errors/advisory-non-fatal-errors YANG schema element.
type Component_Pcie_CorrectableErrors_AdvisoryNonFatalErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrors_AdvisoryNonFatalErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/correctable-errors/advisory-non-fatal-errors YANG schema element.
type Component_Pcie_CorrectableErrors_AdvisoryNonFatalErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrors_BadDllpErrorsPath represents the /openconfig-platform/components/component/state/pcie/correctable-errors/bad-dllp-errors YANG schema element.
type Component_Pcie_CorrectableErrors_BadDllpErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrors_BadDllpErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/correctable-errors/bad-dllp-errors YANG schema element.
type Component_Pcie_CorrectableErrors_BadDllpErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrors_BadTlpErrorsPath represents the /openconfig-platform/components/component/state/pcie/correctable-errors/bad-tlp-errors YANG schema element.
type Component_Pcie_CorrectableErrors_BadTlpErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrors_BadTlpErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/correctable-errors/bad-tlp-errors YANG schema element.
type Component_Pcie_CorrectableErrors_BadTlpErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrors_HdrLogOverflowErrorsPath represents the /openconfig-platform/components/component/state/pcie/correctable-errors/hdr-log-overflow-errors YANG schema element.
type Component_Pcie_CorrectableErrors_HdrLogOverflowErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrors_HdrLogOverflowErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/correctable-errors/hdr-log-overflow-errors YANG schema element.
type Component_Pcie_CorrectableErrors_HdrLogOverflowErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrors_InternalErrorsPath represents the /openconfig-platform/components/component/state/pcie/correctable-errors/internal-errors YANG schema element.
type Component_Pcie_CorrectableErrors_InternalErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrors_InternalErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/correctable-errors/internal-errors YANG schema element.
type Component_Pcie_CorrectableErrors_InternalErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrors_ReceiverErrorsPath represents the /openconfig-platform/components/component/state/pcie/correctable-errors/receiver-errors YANG schema element.
type Component_Pcie_CorrectableErrors_ReceiverErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrors_ReceiverErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/correctable-errors/receiver-errors YANG schema element.
type Component_Pcie_CorrectableErrors_ReceiverErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrors_RelayRolloverErrorsPath represents the /openconfig-platform/components/component/state/pcie/correctable-errors/relay-rollover-errors YANG schema element.
type Component_Pcie_CorrectableErrors_RelayRolloverErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrors_RelayRolloverErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/correctable-errors/relay-rollover-errors YANG schema element.
type Component_Pcie_CorrectableErrors_RelayRolloverErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrors_ReplayTimeoutErrorsPath represents the /openconfig-platform/components/component/state/pcie/correctable-errors/replay-timeout-errors YANG schema element.
type Component_Pcie_CorrectableErrors_ReplayTimeoutErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrors_ReplayTimeoutErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/correctable-errors/replay-timeout-errors YANG schema element.
type Component_Pcie_CorrectableErrors_ReplayTimeoutErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrors_TotalErrorsPath represents the /openconfig-platform/components/component/state/pcie/correctable-errors/total-errors YANG schema element.
type Component_Pcie_CorrectableErrors_TotalErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_CorrectableErrors_TotalErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/correctable-errors/total-errors YANG schema element.
type Component_Pcie_CorrectableErrors_TotalErrorsPathAny struct {
	*ygot.NodePath
}

// AdvisoryNonFatalErrors (leaf): Number of advisory non fatal errors detected by PCIe device since
// the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "advisory-non-fatal-errors"
// Path from root: "/components/component/state/pcie/correctable-errors/advisory-non-fatal-errors"
func (n *Component_Pcie_CorrectableErrorsPath) AdvisoryNonFatalErrors() *Component_Pcie_CorrectableErrors_AdvisoryNonFatalErrorsPath {
	return &Component_Pcie_CorrectableErrors_AdvisoryNonFatalErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"advisory-non-fatal-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// AdvisoryNonFatalErrors (leaf): Number of advisory non fatal errors detected by PCIe device since
// the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "advisory-non-fatal-errors"
// Path from root: "/components/component/state/pcie/correctable-errors/advisory-non-fatal-errors"
func (n *Component_Pcie_CorrectableErrorsPathAny) AdvisoryNonFatalErrors() *Component_Pcie_CorrectableErrors_AdvisoryNonFatalErrorsPathAny {
	return &Component_Pcie_CorrectableErrors_AdvisoryNonFatalErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"advisory-non-fatal-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// BadDllpErrors (leaf): Number of DLLPs with bad LCRC detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "bad-dllp-errors"
// Path from root: "/components/component/state/pcie/correctable-errors/bad-dllp-errors"
func (n *Component_Pcie_CorrectableErrorsPath) BadDllpErrors() *Component_Pcie_CorrectableErrors_BadDllpErrorsPath {
	return &Component_Pcie_CorrectableErrors_BadDllpErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"bad-dllp-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// BadDllpErrors (leaf): Number of DLLPs with bad LCRC detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "bad-dllp-errors"
// Path from root: "/components/component/state/pcie/correctable-errors/bad-dllp-errors"
func (n *Component_Pcie_CorrectableErrorsPathAny) BadDllpErrors() *Component_Pcie_CorrectableErrors_BadDllpErrorsPathAny {
	return &Component_Pcie_CorrectableErrors_BadDllpErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"bad-dllp-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// BadTlpErrors (leaf): Number of TLPs with bad LCRC detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "bad-tlp-errors"
// Path from root: "/components/component/state/pcie/correctable-errors/bad-tlp-errors"
func (n *Component_Pcie_CorrectableErrorsPath) BadTlpErrors() *Component_Pcie_CorrectableErrors_BadTlpErrorsPath {
	return &Component_Pcie_CorrectableErrors_BadTlpErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"bad-tlp-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// BadTlpErrors (leaf): Number of TLPs with bad LCRC detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "bad-tlp-errors"
// Path from root: "/components/component/state/pcie/correctable-errors/bad-tlp-errors"
func (n *Component_Pcie_CorrectableErrorsPathAny) BadTlpErrors() *Component_Pcie_CorrectableErrors_BadTlpErrorsPathAny {
	return &Component_Pcie_CorrectableErrors_BadTlpErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"bad-tlp-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// HdrLogOverflowErrors (leaf): Number of header log overflow errors detected by PCIe device since
// the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "hdr-log-overflow-errors"
// Path from root: "/components/component/state/pcie/correctable-errors/hdr-log-overflow-errors"
func (n *Component_Pcie_CorrectableErrorsPath) HdrLogOverflowErrors() *Component_Pcie_CorrectableErrors_HdrLogOverflowErrorsPath {
	return &Component_Pcie_CorrectableErrors_HdrLogOverflowErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"hdr-log-overflow-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// HdrLogOverflowErrors (leaf): Number of header log overflow errors detected by PCIe device since
// the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "hdr-log-overflow-errors"
// Path from root: "/components/component/state/pcie/correctable-errors/hdr-log-overflow-errors"
func (n *Component_Pcie_CorrectableErrorsPathAny) HdrLogOverflowErrors() *Component_Pcie_CorrectableErrors_HdrLogOverflowErrorsPathAny {
	return &Component_Pcie_CorrectableErrors_HdrLogOverflowErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"hdr-log-overflow-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// InternalErrors (leaf): Number of internal errors detected by PCIe device since the system
// booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "internal-errors"
// Path from root: "/components/component/state/pcie/correctable-errors/internal-errors"
func (n *Component_Pcie_CorrectableErrorsPath) InternalErrors() *Component_Pcie_CorrectableErrors_InternalErrorsPath {
	return &Component_Pcie_CorrectableErrors_InternalErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"internal-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// InternalErrors (leaf): Number of internal errors detected by PCIe device since the system
// booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "internal-errors"
// Path from root: "/components/component/state/pcie/correctable-errors/internal-errors"
func (n *Component_Pcie_CorrectableErrorsPathAny) InternalErrors() *Component_Pcie_CorrectableErrors_InternalErrorsPathAny {
	return &Component_Pcie_CorrectableErrors_InternalErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"internal-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// ReceiverErrors (leaf): Number of receiver errors detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "receiver-errors"
// Path from root: "/components/component/state/pcie/correctable-errors/receiver-errors"
func (n *Component_Pcie_CorrectableErrorsPath) ReceiverErrors() *Component_Pcie_CorrectableErrors_ReceiverErrorsPath {
	return &Component_Pcie_CorrectableErrors_ReceiverErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"receiver-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// ReceiverErrors (leaf): Number of receiver errors detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "receiver-errors"
// Path from root: "/components/component/state/pcie/correctable-errors/receiver-errors"
func (n *Component_Pcie_CorrectableErrorsPathAny) ReceiverErrors() *Component_Pcie_CorrectableErrors_ReceiverErrorsPathAny {
	return &Component_Pcie_CorrectableErrors_ReceiverErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"receiver-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// RelayRolloverErrors (leaf): Number of relay rollover errors detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "relay-rollover-errors"
// Path from root: "/components/component/state/pcie/correctable-errors/relay-rollover-errors"
func (n *Component_Pcie_CorrectableErrorsPath) RelayRolloverErrors() *Component_Pcie_CorrectableErrors_RelayRolloverErrorsPath {
	return &Component_Pcie_CorrectableErrors_RelayRolloverErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"relay-rollover-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// RelayRolloverErrors (leaf): Number of relay rollover errors detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "relay-rollover-errors"
// Path from root: "/components/component/state/pcie/correctable-errors/relay-rollover-errors"
func (n *Component_Pcie_CorrectableErrorsPathAny) RelayRolloverErrors() *Component_Pcie_CorrectableErrors_RelayRolloverErrorsPathAny {
	return &Component_Pcie_CorrectableErrors_RelayRolloverErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"relay-rollover-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// ReplayTimeoutErrors (leaf): Number of replay timeout errors detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "replay-timeout-errors"
// Path from root: "/components/component/state/pcie/correctable-errors/replay-timeout-errors"
func (n *Component_Pcie_CorrectableErrorsPath) ReplayTimeoutErrors() *Component_Pcie_CorrectableErrors_ReplayTimeoutErrorsPath {
	return &Component_Pcie_CorrectableErrors_ReplayTimeoutErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"replay-timeout-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// ReplayTimeoutErrors (leaf): Number of replay timeout errors detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "replay-timeout-errors"
// Path from root: "/components/component/state/pcie/correctable-errors/replay-timeout-errors"
func (n *Component_Pcie_CorrectableErrorsPathAny) ReplayTimeoutErrors() *Component_Pcie_CorrectableErrors_ReplayTimeoutErrorsPathAny {
	return &Component_Pcie_CorrectableErrors_ReplayTimeoutErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"replay-timeout-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// TotalErrors (leaf): Total number of correctable errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "total-errors"
// Path from root: "/components/component/state/pcie/correctable-errors/total-errors"
func (n *Component_Pcie_CorrectableErrorsPath) TotalErrors() *Component_Pcie_CorrectableErrors_TotalErrorsPath {
	return &Component_Pcie_CorrectableErrors_TotalErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"total-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// TotalErrors (leaf): Total number of correctable errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "total-errors"
// Path from root: "/components/component/state/pcie/correctable-errors/total-errors"
func (n *Component_Pcie_CorrectableErrorsPathAny) TotalErrors() *Component_Pcie_CorrectableErrors_TotalErrorsPathAny {
	return &Component_Pcie_CorrectableErrors_TotalErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"total-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// Component_Pcie_FatalErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors YANG schema element.
type Component_Pcie_FatalErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors YANG schema element.
type Component_Pcie_FatalErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_AcsViolationErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors/acs-violation-errors YANG schema element.
type Component_Pcie_FatalErrors_AcsViolationErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_AcsViolationErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors/acs-violation-errors YANG schema element.
type Component_Pcie_FatalErrors_AcsViolationErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_AtomicOpBlockedErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors/atomic-op-blocked-errors YANG schema element.
type Component_Pcie_FatalErrors_AtomicOpBlockedErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_AtomicOpBlockedErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors/atomic-op-blocked-errors YANG schema element.
type Component_Pcie_FatalErrors_AtomicOpBlockedErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_BlockedTlpErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors/blocked-tlp-errors YANG schema element.
type Component_Pcie_FatalErrors_BlockedTlpErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_BlockedTlpErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors/blocked-tlp-errors YANG schema element.
type Component_Pcie_FatalErrors_BlockedTlpErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_CompletionAbortErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors/completion-abort-errors YANG schema element.
type Component_Pcie_FatalErrors_CompletionAbortErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_CompletionAbortErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors/completion-abort-errors YANG schema element.
type Component_Pcie_FatalErrors_CompletionAbortErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_CompletionTimeoutErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors/completion-timeout-errors YANG schema element.
type Component_Pcie_FatalErrors_CompletionTimeoutErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_CompletionTimeoutErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors/completion-timeout-errors YANG schema element.
type Component_Pcie_FatalErrors_CompletionTimeoutErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_DataLinkErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors/data-link-errors YANG schema element.
type Component_Pcie_FatalErrors_DataLinkErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_DataLinkErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors/data-link-errors YANG schema element.
type Component_Pcie_FatalErrors_DataLinkErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_EcrcErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors/ecrc-errors YANG schema element.
type Component_Pcie_FatalErrors_EcrcErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_EcrcErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors/ecrc-errors YANG schema element.
type Component_Pcie_FatalErrors_EcrcErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_FlowControlProtocolErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors/flow-control-protocol-errors YANG schema element.
type Component_Pcie_FatalErrors_FlowControlProtocolErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_FlowControlProtocolErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors/flow-control-protocol-errors YANG schema element.
type Component_Pcie_FatalErrors_FlowControlProtocolErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_InternalErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors/internal-errors YANG schema element.
type Component_Pcie_FatalErrors_InternalErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_InternalErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors/internal-errors YANG schema element.
type Component_Pcie_FatalErrors_InternalErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_MalformedTlpErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors/malformed-tlp-errors YANG schema element.
type Component_Pcie_FatalErrors_MalformedTlpErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_MalformedTlpErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors/malformed-tlp-errors YANG schema element.
type Component_Pcie_FatalErrors_MalformedTlpErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_PoisonedTlpErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors/poisoned-tlp-errors YANG schema element.
type Component_Pcie_FatalErrors_PoisonedTlpErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_PoisonedTlpErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors/poisoned-tlp-errors YANG schema element.
type Component_Pcie_FatalErrors_PoisonedTlpErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_ReceiverOverflowErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors/receiver-overflow-errors YANG schema element.
type Component_Pcie_FatalErrors_ReceiverOverflowErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_ReceiverOverflowErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors/receiver-overflow-errors YANG schema element.
type Component_Pcie_FatalErrors_ReceiverOverflowErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_SurpriseDownErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors/surprise-down-errors YANG schema element.
type Component_Pcie_FatalErrors_SurpriseDownErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_SurpriseDownErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors/surprise-down-errors YANG schema element.
type Component_Pcie_FatalErrors_SurpriseDownErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_TlpPrefixBlockedErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors/tlp-prefix-blocked-errors YANG schema element.
type Component_Pcie_FatalErrors_TlpPrefixBlockedErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_TlpPrefixBlockedErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors/tlp-prefix-blocked-errors YANG schema element.
type Component_Pcie_FatalErrors_TlpPrefixBlockedErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_TotalErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors/total-errors YANG schema element.
type Component_Pcie_FatalErrors_TotalErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_TotalErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors/total-errors YANG schema element.
type Component_Pcie_FatalErrors_TotalErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_UndefinedErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors/undefined-errors YANG schema element.
type Component_Pcie_FatalErrors_UndefinedErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_UndefinedErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors/undefined-errors YANG schema element.
type Component_Pcie_FatalErrors_UndefinedErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_UnexpectedCompletionErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors/unexpected-completion-errors YANG schema element.
type Component_Pcie_FatalErrors_UnexpectedCompletionErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_UnexpectedCompletionErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors/unexpected-completion-errors YANG schema element.
type Component_Pcie_FatalErrors_UnexpectedCompletionErrorsPathAny struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_UnsupportedRequestErrorsPath represents the /openconfig-platform/components/component/state/pcie/fatal-errors/unsupported-request-errors YANG schema element.
type Component_Pcie_FatalErrors_UnsupportedRequestErrorsPath struct {
	*ygot.NodePath
}

// Component_Pcie_FatalErrors_UnsupportedRequestErrorsPathAny represents the wildcard version of the /openconfig-platform/components/component/state/pcie/fatal-errors/unsupported-request-errors YANG schema element.
type Component_Pcie_FatalErrors_UnsupportedRequestErrorsPathAny struct {
	*ygot.NodePath
}

// AcsViolationErrors (leaf): Number of access control errors detected by PCIe device since
// the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "acs-violation-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/acs-violation-errors"
func (n *Component_Pcie_FatalErrorsPath) AcsViolationErrors() *Component_Pcie_FatalErrors_AcsViolationErrorsPath {
	return &Component_Pcie_FatalErrors_AcsViolationErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"acs-violation-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// AcsViolationErrors (leaf): Number of access control errors detected by PCIe device since
// the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "acs-violation-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/acs-violation-errors"
func (n *Component_Pcie_FatalErrorsPathAny) AcsViolationErrors() *Component_Pcie_FatalErrors_AcsViolationErrorsPathAny {
	return &Component_Pcie_FatalErrors_AcsViolationErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"acs-violation-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// AtomicOpBlockedErrors (leaf): Number of atomic operation blocked errors detected by PCIe
// device since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "atomic-op-blocked-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/atomic-op-blocked-errors"
func (n *Component_Pcie_FatalErrorsPath) AtomicOpBlockedErrors() *Component_Pcie_FatalErrors_AtomicOpBlockedErrorsPath {
	return &Component_Pcie_FatalErrors_AtomicOpBlockedErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"atomic-op-blocked-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// AtomicOpBlockedErrors (leaf): Number of atomic operation blocked errors detected by PCIe
// device since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "atomic-op-blocked-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/atomic-op-blocked-errors"
func (n *Component_Pcie_FatalErrorsPathAny) AtomicOpBlockedErrors() *Component_Pcie_FatalErrors_AtomicOpBlockedErrorsPathAny {
	return &Component_Pcie_FatalErrors_AtomicOpBlockedErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"atomic-op-blocked-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// BlockedTlpErrors (leaf): Number of blocked TLP errors detected by PCIe device since
// the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "blocked-tlp-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/blocked-tlp-errors"
func (n *Component_Pcie_FatalErrorsPath) BlockedTlpErrors() *Component_Pcie_FatalErrors_BlockedTlpErrorsPath {
	return &Component_Pcie_FatalErrors_BlockedTlpErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"blocked-tlp-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// BlockedTlpErrors (leaf): Number of blocked TLP errors detected by PCIe device since
// the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "blocked-tlp-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/blocked-tlp-errors"
func (n *Component_Pcie_FatalErrorsPathAny) BlockedTlpErrors() *Component_Pcie_FatalErrors_BlockedTlpErrorsPathAny {
	return &Component_Pcie_FatalErrors_BlockedTlpErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"blocked-tlp-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// CompletionAbortErrors (leaf): Number of completion abort errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "completion-abort-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/completion-abort-errors"
func (n *Component_Pcie_FatalErrorsPath) CompletionAbortErrors() *Component_Pcie_FatalErrors_CompletionAbortErrorsPath {
	return &Component_Pcie_FatalErrors_CompletionAbortErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"completion-abort-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// CompletionAbortErrors (leaf): Number of completion abort errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "completion-abort-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/completion-abort-errors"
func (n *Component_Pcie_FatalErrorsPathAny) CompletionAbortErrors() *Component_Pcie_FatalErrors_CompletionAbortErrorsPathAny {
	return &Component_Pcie_FatalErrors_CompletionAbortErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"completion-abort-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// CompletionTimeoutErrors (leaf): Number of completion timeout errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "completion-timeout-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/completion-timeout-errors"
func (n *Component_Pcie_FatalErrorsPath) CompletionTimeoutErrors() *Component_Pcie_FatalErrors_CompletionTimeoutErrorsPath {
	return &Component_Pcie_FatalErrors_CompletionTimeoutErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"completion-timeout-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// CompletionTimeoutErrors (leaf): Number of completion timeout errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "completion-timeout-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/completion-timeout-errors"
func (n *Component_Pcie_FatalErrorsPathAny) CompletionTimeoutErrors() *Component_Pcie_FatalErrors_CompletionTimeoutErrorsPathAny {
	return &Component_Pcie_FatalErrors_CompletionTimeoutErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"completion-timeout-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// DataLinkErrors (leaf): Number of data-link errors detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "data-link-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/data-link-errors"
func (n *Component_Pcie_FatalErrorsPath) DataLinkErrors() *Component_Pcie_FatalErrors_DataLinkErrorsPath {
	return &Component_Pcie_FatalErrors_DataLinkErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"data-link-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// DataLinkErrors (leaf): Number of data-link errors detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "data-link-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/data-link-errors"
func (n *Component_Pcie_FatalErrorsPathAny) DataLinkErrors() *Component_Pcie_FatalErrors_DataLinkErrorsPathAny {
	return &Component_Pcie_FatalErrors_DataLinkErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"data-link-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// EcrcErrors (leaf): Number of ECRC errors detected by PCIe device since the system
// booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "ecrc-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/ecrc-errors"
func (n *Component_Pcie_FatalErrorsPath) EcrcErrors() *Component_Pcie_FatalErrors_EcrcErrorsPath {
	return &Component_Pcie_FatalErrors_EcrcErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"ecrc-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// EcrcErrors (leaf): Number of ECRC errors detected by PCIe device since the system
// booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "ecrc-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/ecrc-errors"
func (n *Component_Pcie_FatalErrorsPathAny) EcrcErrors() *Component_Pcie_FatalErrors_EcrcErrorsPathAny {
	return &Component_Pcie_FatalErrors_EcrcErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"ecrc-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// FlowControlProtocolErrors (leaf): Number of flow control protocol errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "flow-control-protocol-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/flow-control-protocol-errors"
func (n *Component_Pcie_FatalErrorsPath) FlowControlProtocolErrors() *Component_Pcie_FatalErrors_FlowControlProtocolErrorsPath {
	return &Component_Pcie_FatalErrors_FlowControlProtocolErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"flow-control-protocol-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// FlowControlProtocolErrors (leaf): Number of flow control protocol errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "flow-control-protocol-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/flow-control-protocol-errors"
func (n *Component_Pcie_FatalErrorsPathAny) FlowControlProtocolErrors() *Component_Pcie_FatalErrors_FlowControlProtocolErrorsPathAny {
	return &Component_Pcie_FatalErrors_FlowControlProtocolErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"flow-control-protocol-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// InternalErrors (leaf): Number of internal errors detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "internal-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/internal-errors"
func (n *Component_Pcie_FatalErrorsPath) InternalErrors() *Component_Pcie_FatalErrors_InternalErrorsPath {
	return &Component_Pcie_FatalErrors_InternalErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"internal-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// InternalErrors (leaf): Number of internal errors detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "internal-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/internal-errors"
func (n *Component_Pcie_FatalErrorsPathAny) InternalErrors() *Component_Pcie_FatalErrors_InternalErrorsPathAny {
	return &Component_Pcie_FatalErrors_InternalErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"internal-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// MalformedTlpErrors (leaf): Number of malformed TLP errors detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "malformed-tlp-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/malformed-tlp-errors"
func (n *Component_Pcie_FatalErrorsPath) MalformedTlpErrors() *Component_Pcie_FatalErrors_MalformedTlpErrorsPath {
	return &Component_Pcie_FatalErrors_MalformedTlpErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"malformed-tlp-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// MalformedTlpErrors (leaf): Number of malformed TLP errors detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "malformed-tlp-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/malformed-tlp-errors"
func (n *Component_Pcie_FatalErrorsPathAny) MalformedTlpErrors() *Component_Pcie_FatalErrors_MalformedTlpErrorsPathAny {
	return &Component_Pcie_FatalErrors_MalformedTlpErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"malformed-tlp-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// PoisonedTlpErrors (leaf): Number of poisoned TLP errors detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "poisoned-tlp-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/poisoned-tlp-errors"
func (n *Component_Pcie_FatalErrorsPath) PoisonedTlpErrors() *Component_Pcie_FatalErrors_PoisonedTlpErrorsPath {
	return &Component_Pcie_FatalErrors_PoisonedTlpErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"poisoned-tlp-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// PoisonedTlpErrors (leaf): Number of poisoned TLP errors detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "poisoned-tlp-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/poisoned-tlp-errors"
func (n *Component_Pcie_FatalErrorsPathAny) PoisonedTlpErrors() *Component_Pcie_FatalErrors_PoisonedTlpErrorsPathAny {
	return &Component_Pcie_FatalErrors_PoisonedTlpErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"poisoned-tlp-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// ReceiverOverflowErrors (leaf): Number of receiver overflow errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "receiver-overflow-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/receiver-overflow-errors"
func (n *Component_Pcie_FatalErrorsPath) ReceiverOverflowErrors() *Component_Pcie_FatalErrors_ReceiverOverflowErrorsPath {
	return &Component_Pcie_FatalErrors_ReceiverOverflowErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"receiver-overflow-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// ReceiverOverflowErrors (leaf): Number of receiver overflow errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "receiver-overflow-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/receiver-overflow-errors"
func (n *Component_Pcie_FatalErrorsPathAny) ReceiverOverflowErrors() *Component_Pcie_FatalErrors_ReceiverOverflowErrorsPathAny {
	return &Component_Pcie_FatalErrors_ReceiverOverflowErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"receiver-overflow-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// SurpriseDownErrors (leaf): Number of unexpected link down errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "surprise-down-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/surprise-down-errors"
func (n *Component_Pcie_FatalErrorsPath) SurpriseDownErrors() *Component_Pcie_FatalErrors_SurpriseDownErrorsPath {
	return &Component_Pcie_FatalErrors_SurpriseDownErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"surprise-down-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// SurpriseDownErrors (leaf): Number of unexpected link down errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "surprise-down-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/surprise-down-errors"
func (n *Component_Pcie_FatalErrorsPathAny) SurpriseDownErrors() *Component_Pcie_FatalErrors_SurpriseDownErrorsPathAny {
	return &Component_Pcie_FatalErrors_SurpriseDownErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"surprise-down-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// TlpPrefixBlockedErrors (leaf): Number of TLP prefix blocked errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "tlp-prefix-blocked-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/tlp-prefix-blocked-errors"
func (n *Component_Pcie_FatalErrorsPath) TlpPrefixBlockedErrors() *Component_Pcie_FatalErrors_TlpPrefixBlockedErrorsPath {
	return &Component_Pcie_FatalErrors_TlpPrefixBlockedErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"tlp-prefix-blocked-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// TlpPrefixBlockedErrors (leaf): Number of TLP prefix blocked errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "tlp-prefix-blocked-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/tlp-prefix-blocked-errors"
func (n *Component_Pcie_FatalErrorsPathAny) TlpPrefixBlockedErrors() *Component_Pcie_FatalErrors_TlpPrefixBlockedErrorsPathAny {
	return &Component_Pcie_FatalErrors_TlpPrefixBlockedErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"tlp-prefix-blocked-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// TotalErrors (leaf): Total number of uncorrectable errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "total-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/total-errors"
func (n *Component_Pcie_FatalErrorsPath) TotalErrors() *Component_Pcie_FatalErrors_TotalErrorsPath {
	return &Component_Pcie_FatalErrors_TotalErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"total-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// TotalErrors (leaf): Total number of uncorrectable errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "total-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/total-errors"
func (n *Component_Pcie_FatalErrorsPathAny) TotalErrors() *Component_Pcie_FatalErrors_TotalErrorsPathAny {
	return &Component_Pcie_FatalErrors_TotalErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"total-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// UndefinedErrors (leaf): Number of undefined errors detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "undefined-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/undefined-errors"
func (n *Component_Pcie_FatalErrorsPath) UndefinedErrors() *Component_Pcie_FatalErrors_UndefinedErrorsPath {
	return &Component_Pcie_FatalErrors_UndefinedErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"undefined-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// UndefinedErrors (leaf): Number of undefined errors detected by PCIe device since the
// system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "undefined-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/undefined-errors"
func (n *Component_Pcie_FatalErrorsPathAny) UndefinedErrors() *Component_Pcie_FatalErrors_UndefinedErrorsPathAny {
	return &Component_Pcie_FatalErrors_UndefinedErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"undefined-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// UnexpectedCompletionErrors (leaf): Number of unexpected completion errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "unexpected-completion-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/unexpected-completion-errors"
func (n *Component_Pcie_FatalErrorsPath) UnexpectedCompletionErrors() *Component_Pcie_FatalErrors_UnexpectedCompletionErrorsPath {
	return &Component_Pcie_FatalErrors_UnexpectedCompletionErrorsPath{
		NodePath: ygot.NewNodePath(
			[]string{"unexpected-completion-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// UnexpectedCompletionErrors (leaf): Number of unexpected completion errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "openconfig-platform"
// Path from parent: "unexpected-completion-errors"
// Path from root: "/components/component/state/pcie/fatal-errors/unexpected-completion-errors"
func (n *Component_Pcie_FatalErrorsPathAny) UnexpectedCompletionErrors() *Component_Pcie_FatalErrors_UnexpectedCompletionErrorsPathAny {
	return &Component_Pcie_FatalErrors_UnexpectedCompletionErrorsPathAny{
		NodePath: ygot.NewNodePath(
			[]string{"unexpected-completion-errors"},
			map[string]interface{}{},
			n,
		),
	}
}

// UnsupportedRequestErrors (leaf): Number of unsupported request errors detected by PCIe device
// since the system booted, according to PCIe AER driver.
// ----------------------------------------
// Defining module: "openconfig-platform"
// Instantiating module: "op