//+build ignore

package main

import (
	"bytes"
	"fmt"
	"io/ioutil"
	"log"
	"os"
)

func main() {
	if err := run(); err != nil {
		log.Fatal(err)
	}
}

func run() error {
	var buf bytes.Buffer

	buf.WriteString("// Code generated by gentables.go. DO NOT EDIT.\n\n")
	buf.WriteString("package xmlwriter\n\n")
	buf.WriteString("var nameChar = [65536]int8{\n\t")

	w := 0
	for rn := uint16(0); rn < 0xFFFF; rn++ {
		if w == 8 {
			buf.WriteString("\n\t")
			w = 0
		}

		if rn == ':' || rn == '_' ||
			(rn >= 'A' && rn <= 'Z') ||
			(rn >= 'a' && rn <= 'z') ||
			(rn >= 0xC0 && rn <= 0xD6) ||
			(rn >= 0xD8 && rn <= 0xF6) ||
			(rn >= 0xF8 && rn <= 0x2FF) ||
			(rn >= 0x370 && rn <= 0x37D) {
			buf.WriteString(fmt.Sprintf("0x%x: 1, ", rn))
			w++
			continue
		}

		if rn == '-' || rn == '.' || (rn >= '0' && rn <= '9') || rn == 0xB7 ||
			(rn >= 0x300 && rn <= 0x36F) ||
			(rn >= 0x203F && rn <= 0x2040) {
			buf.WriteString(fmt.Sprintf("0x%x: 2, ", rn))
			w++
			continue
		}
	}

	buf.WriteString("\n}\n")

	out := "tables_gen.go"
	orig, err := ioutil.ReadFile(out)
	if err != nil && !os.IsNotExist(err) {
		return err
	}

	if bytes.Compare(orig, buf.Bytes()) != 0 {
		return ioutil.WriteFile(out, buf.Bytes(), 0644)
	}

	return nil
}
