// Code generated by "go generate gonum.org/v1/gonum/unit”; DO NOT EDIT.

// Copyright ©2014 The Gonum Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package unit

import (
	"errors"
	"fmt"
	"math"
	"unicode/utf8"
)

// Power represents a power in Watts.
type Power float64

const Watt Power = 1

// Unit converts the Power to a *Unit.
func (pw Power) Unit() *Unit {
	return New(float64(pw), Dimensions{
		LengthDim: 2,
		MassDim:   1,
		TimeDim:   -3,
	})
}

// Power allows Power to implement a Powerer interface.
func (pw Power) Power() Power {
	return pw
}

// From converts the unit into the receiver. From returns an
// error if there is a mismatch in dimension.
func (pw *Power) From(u Uniter) error {
	if !DimensionsMatch(u, Watt) {
		*pw = Power(math.NaN())
		return errors.New("unit: dimension mismatch")
	}
	*pw = Power(u.Unit().Value())
	return nil
}

func (pw Power) Format(fs fmt.State, c rune) {
	switch c {
	case 'v':
		if fs.Flag('#') {
			fmt.Fprintf(fs, "%T(%v)", pw, float64(pw))
			return
		}
		fallthrough
	case 'e', 'E', 'f', 'F', 'g', 'G':
		p, pOk := fs.Precision()
		w, wOk := fs.Width()
		const unit = " W"
		switch {
		case pOk && wOk:
			fmt.Fprintf(fs, "%*.*"+string(c), pos(w-utf8.RuneCount([]byte(unit))), p, float64(pw))
		case pOk:
			fmt.Fprintf(fs, "%.*"+string(c), p, float64(pw))
		case wOk:
			fmt.Fprintf(fs, "%*"+string(c), pos(w-utf8.RuneCount([]byte(unit))), float64(pw))
		default:
			fmt.Fprintf(fs, "%"+string(c), float64(pw))
		}
		fmt.Fprint(fs, unit)
	default:
		fmt.Fprintf(fs, "%%!%c(%T=%g W)", c, pw, float64(pw))
	}
}
