# Identity Management Plugin Guide [![Slack](https://slack.minio.io/slack?type=svg)](https://slack.minio.io)

## Introduction

To enable the integration of custom authentication methods, MinIO can be configured with an Identity Management Plugin webhook. When configured, this plugin enables the `AssumeRoleWithCustomToken` STS API extension. A user or application can now present a token to the `AssumeRoleWithCustomToken` API, and MinIO verifies this token by sending it to the Identity Management Plugin webhook. This plugin responds with some information and MinIO is able to generate temporary STS credentials to interact with object storage.

The authentication flow is similar to that of OpenID, however the token is "opaque" to MinIO - it is simply sent to the plugin for verification. CAVEAT: There is no console UI integration for this method of authentication and it is intended primarily for machine authentication.

It can be configured via MinIO's standard configuration API (i.e. using `mc admin config set/get`), or equivalently with environment variables. For brevity we show only environment variables here:

```sh
$ mc admin config set myminio identity_plugin --env
KEY:
identity_plugin  enable Identity Plugin via external hook

ARGS:
MINIO_IDENTITY_PLUGIN_URL*          (url)       plugin hook endpoint (HTTP(S)) e.g. "http://localhost:8181/path/to/endpoint"
MINIO_IDENTITY_PLUGIN_AUTH_TOKEN    (string)    authorization token for plugin hook endpoint
MINIO_IDENTITY_PLUGIN_ROLE_POLICY*  (string)    policies to apply for plugin authorized users
MINIO_IDENTITY_PLUGIN_ROLE_ID       (string)    unique ID to generate the ARN
MINIO_IDENTITY_PLUGIN_COMMENT       (sentence)  optionally add a comment to this setting
```

If provided, the auth token parameter is sent as an authorization header.

`MINIO_IDENTITY_PLUGIN_ROLE_POLICY` is a required parameter and can be list of comma separated policy names.

On setting up the plugin, the MinIO server prints the Role ARN to its log. The Role ARN is generated by default based on the given plugin URL. To avoid this and use a configurable value set a unique role ID via `MINIO_IDENTITY_PLUGIN_ROLE_ID`.

## REST API call to plugin

To verify the custom token presented in the `AssumeRoleWithCustomToken` API, MinIO makes a POST request to the configured identity management plugin endpoint and expects a response with some details as shown below:

### Request `POST` to plugin endpoint

Query parameters:

| Parameter Name | Value Type | Purpose                                                                 |
|----------------|------------|-------------------------------------------------------------------------|
| token          | string     | Token from the AssumeRoleWithCustomToken call for external verification |

### Response

If the token is valid and access is approved, the plugin must return a `200` (OK) HTTP status code.

A `200 OK` Response should have `application/json` content-type and body with the following structure:

```json
{
    "user": <string>,
    "maxValiditySeconds": <integer>,
    "claims": <key-value-pairs>
}
```

| Parameter Name     | Value Type                              | Purpose                                                |
|--------------------|-----------------------------------------|--------------------------------------------------------|
| user               | string                                  | Identifier for owner of requested credentials          |
| maxValiditySeconds | integer (>= 900 seconds and < 365 days) | Maximum allowed expiry duration for the credentials    |
| claims             | key-value pairs                         | Claims to be associated with the requested credentials |

The keys "exp", "parent" and "sub" in the `claims` object are reserved and if present are ignored by MinIO.

If the token is not valid or access is not approved, the plugin must return a `403` (forbidden) HTTP status code. The body must have an `application/json` content-type with the following structure:

```json
{
    "reason": <string>
}
```

The reason message is returned to the client.

## Example Plugin Implementation

A toy example for the Identity Management Plugin is given [here](./identity-manager-plugin.go).
