/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.client.shadow;

import com.amazonaws.services.iot.client.AWSIotMessage;
import com.amazonaws.services.iot.client.AWSIotQos;
import com.amazonaws.services.iot.client.AWSIotTopic;
import com.amazonaws.services.iot.client.shadow.AbstractAwsIotDevice;
import java.util.logging.Logger;

public class AwsIotDeviceCommandAckListener
extends AWSIotTopic {
    private static final Logger LOGGER = Logger.getLogger(AwsIotDeviceCommandAckListener.class.getName());
    private final AbstractAwsIotDevice device;

    public AwsIotDeviceCommandAckListener(String topic, AWSIotQos qos, AbstractAwsIotDevice device) {
        super(topic, qos);
        this.device = device;
    }

    @Override
    public void onMessage(AWSIotMessage message) {
        this.device.onCommandAck(message);
    }

    @Override
    public void onSuccess() {
        this.device.onSubscriptionAck(this.topic, true);
    }

    @Override
    public void onFailure() {
        LOGGER.warning("Failed to subscribe to device topic " + this.topic);
        this.device.onSubscriptionAck(this.topic, false);
    }

    @Override
    public void onTimeout() {
        LOGGER.warning("Timeout when subscribing to device topic " + this.topic);
        this.device.onSubscriptionAck(this.topic, false);
    }
}

