/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.client.util.Data;
import com.google.api.client.util.DateTime;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.GcpLaunchStage;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.StorageClass;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BlobInfo
implements Serializable {
    static final Function<BlobInfo, StorageObject> INFO_TO_PB_FUNCTION = new Function<BlobInfo, StorageObject>(){

        public StorageObject apply(BlobInfo blobInfo) {
            return blobInfo.toPb();
        }
    };
    private static final long serialVersionUID = -5625857076205028976L;
    private final BlobId blobId;
    private final String generatedId;
    private final String selfLink;
    private final String cacheControl;
    private final List<Acl> acl;
    private final Acl.Entity owner;
    private final Long size;
    private final String etag;
    private final String md5;
    private final String crc32c;
    private final String mediaLink;
    private final Map<String, String> metadata;
    private final Long metageneration;
    private final Long deleteTime;
    private final Long updateTime;
    private final Long createTime;
    private final String contentType;
    private final String contentEncoding;
    private final String contentDisposition;
    private final String contentLanguage;
    private final StorageClass storageClass;
    private final Integer componentCount;
    private final boolean isDirectory;
    private final CustomerEncryption customerEncryption;
    private final String kmsKeyName;

    BlobInfo(BuilderImpl builder) {
        this.blobId = builder.blobId;
        this.generatedId = builder.generatedId;
        this.cacheControl = builder.cacheControl;
        this.contentEncoding = builder.contentEncoding;
        this.contentType = builder.contentType;
        this.contentDisposition = builder.contentDisposition;
        this.contentLanguage = builder.contentLanguage;
        this.componentCount = builder.componentCount;
        this.customerEncryption = builder.customerEncryption;
        this.acl = builder.acl;
        this.owner = builder.owner;
        this.size = builder.size;
        this.etag = builder.etag;
        this.selfLink = builder.selfLink;
        this.md5 = builder.md5;
        this.crc32c = builder.crc32c;
        this.mediaLink = builder.mediaLink;
        this.metadata = builder.metadata;
        this.metageneration = builder.metageneration;
        this.deleteTime = builder.deleteTime;
        this.updateTime = builder.updateTime;
        this.createTime = builder.createTime;
        this.isDirectory = (Boolean)MoreObjects.firstNonNull((Object)builder.isDirectory, (Object)Boolean.FALSE);
        this.storageClass = builder.storageClass;
        this.kmsKeyName = builder.kmsKeyName;
    }

    public BlobId getBlobId() {
        return this.blobId;
    }

    public String getBucket() {
        return this.getBlobId().getBucket();
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public String getName() {
        return this.getBlobId().getName();
    }

    public String getCacheControl() {
        return Data.isNull((Object)this.cacheControl) ? null : this.cacheControl;
    }

    public List<Acl> getAcl() {
        return this.acl;
    }

    public Acl.Entity getOwner() {
        return this.owner;
    }

    public Long getSize() {
        return this.size;
    }

    public String getContentType() {
        return Data.isNull((Object)this.contentType) ? null : this.contentType;
    }

    public String getContentEncoding() {
        return Data.isNull((Object)this.contentEncoding) ? null : this.contentEncoding;
    }

    public String getContentDisposition() {
        return Data.isNull((Object)this.contentDisposition) ? null : this.contentDisposition;
    }

    public String getContentLanguage() {
        return Data.isNull((Object)this.contentLanguage) ? null : this.contentLanguage;
    }

    public Integer getComponentCount() {
        return this.componentCount;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getMd5() {
        return Data.isNull((Object)this.md5) ? null : this.md5;
    }

    public String getCrc32c() {
        return Data.isNull((Object)this.crc32c) ? null : this.crc32c;
    }

    public String getMediaLink() {
        return this.mediaLink;
    }

    public Map<String, String> getMetadata() {
        return this.metadata == null || Data.isNull(this.metadata) ? null : Collections.unmodifiableMap(this.metadata);
    }

    public Long getGeneration() {
        return this.getBlobId().getGeneration();
    }

    public Long getMetageneration() {
        return this.metageneration;
    }

    public Long getDeleteTime() {
        return this.deleteTime;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public CustomerEncryption getCustomerEncryption() {
        return this.customerEncryption;
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    @GcpLaunchStage.Beta
    public String getKmsKeyName() {
        return this.kmsKeyName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucket", (Object)this.getBucket()).add("name", (Object)this.getName()).add("generation", (Object)this.getGeneration()).add("size", (Object)this.getSize()).add("content-type", (Object)this.getContentType()).add("metadata", this.getMetadata()).toString();
    }

    public int hashCode() {
        return Objects.hash(this.blobId);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(BlobInfo.class) && Objects.equals(this.toPb(), ((BlobInfo)obj).toPb());
    }

    StorageObject toPb() {
        StorageObject storageObject = this.blobId.toPb();
        if (this.acl != null) {
            storageObject.setAcl(Lists.transform(this.acl, (Function)new Function<Acl, ObjectAccessControl>(){

                public ObjectAccessControl apply(Acl acl) {
                    return acl.toObjectPb();
                }
            }));
        }
        if (this.deleteTime != null) {
            storageObject.setTimeDeleted(new DateTime(this.deleteTime.longValue()));
        }
        if (this.updateTime != null) {
            storageObject.setUpdated(new DateTime(this.updateTime.longValue()));
        }
        if (this.createTime != null) {
            storageObject.setTimeCreated(new DateTime(this.createTime.longValue()));
        }
        if (this.size != null) {
            storageObject.setSize(BigInteger.valueOf(this.size));
        }
        if (this.owner != null) {
            storageObject.setOwner(new StorageObject.Owner().setEntity(this.owner.toPb()));
        }
        if (this.storageClass != null) {
            storageObject.setStorageClass(this.storageClass.toString());
        }
        HashMap pbMetadata = this.metadata;
        if (this.metadata != null && !Data.isNull(this.metadata)) {
            pbMetadata = Maps.newHashMapWithExpectedSize((int)this.metadata.size());
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                pbMetadata.put(entry.getKey(), MoreObjects.firstNonNull((Object)entry.getValue(), (Object)Data.nullOf(String.class)));
            }
        }
        if (this.customerEncryption != null) {
            storageObject.setCustomerEncryption(this.customerEncryption.toPb());
        }
        storageObject.setKmsKeyName(this.kmsKeyName);
        storageObject.setMetadata((Map)pbMetadata);
        storageObject.setCacheControl(this.cacheControl);
        storageObject.setContentEncoding(this.contentEncoding);
        storageObject.setCrc32c(this.crc32c);
        storageObject.setContentType(this.contentType);
        storageObject.setMd5Hash(this.md5);
        storageObject.setMediaLink(this.mediaLink);
        storageObject.setMetageneration(this.metageneration);
        storageObject.setContentDisposition(this.contentDisposition);
        storageObject.setComponentCount(this.componentCount);
        storageObject.setContentLanguage(this.contentLanguage);
        storageObject.setEtag(this.etag);
        storageObject.setId(this.generatedId);
        storageObject.setSelfLink(this.selfLink);
        return storageObject;
    }

    public static Builder newBuilder(BucketInfo bucketInfo, String name) {
        return BlobInfo.newBuilder(bucketInfo.getName(), name);
    }

    public static Builder newBuilder(String bucket, String name) {
        return BlobInfo.newBuilder(BlobId.of(bucket, name));
    }

    public static Builder newBuilder(BucketInfo bucketInfo, String name, Long generation) {
        return BlobInfo.newBuilder(bucketInfo.getName(), name, generation);
    }

    public static Builder newBuilder(String bucket, String name, Long generation) {
        return BlobInfo.newBuilder(BlobId.of(bucket, name, generation));
    }

    public static Builder newBuilder(BlobId blobId) {
        return new BuilderImpl(blobId);
    }

    static BlobInfo fromPb(StorageObject storageObject) {
        Builder builder = BlobInfo.newBuilder(BlobId.fromPb(storageObject));
        if (storageObject.getCacheControl() != null) {
            builder.setCacheControl(storageObject.getCacheControl());
        }
        if (storageObject.getContentEncoding() != null) {
            builder.setContentEncoding(storageObject.getContentEncoding());
        }
        if (storageObject.getCrc32c() != null) {
            builder.setCrc32c(storageObject.getCrc32c());
        }
        if (storageObject.getContentType() != null) {
            builder.setContentType(storageObject.getContentType());
        }
        if (storageObject.getMd5Hash() != null) {
            builder.setMd5(storageObject.getMd5Hash());
        }
        if (storageObject.getMediaLink() != null) {
            builder.setMediaLink(storageObject.getMediaLink());
        }
        if (storageObject.getMetageneration() != null) {
            builder.setMetageneration(storageObject.getMetageneration());
        }
        if (storageObject.getContentDisposition() != null) {
            builder.setContentDisposition(storageObject.getContentDisposition());
        }
        if (storageObject.getComponentCount() != null) {
            builder.setComponentCount(storageObject.getComponentCount());
        }
        if (storageObject.getContentLanguage() != null) {
            builder.setContentLanguage(storageObject.getContentLanguage());
        }
        if (storageObject.getEtag() != null) {
            builder.setEtag(storageObject.getEtag());
        }
        if (storageObject.getId() != null) {
            builder.setGeneratedId(storageObject.getId());
        }
        if (storageObject.getSelfLink() != null) {
            builder.setSelfLink(storageObject.getSelfLink());
        }
        if (storageObject.getMetadata() != null) {
            builder.setMetadata(storageObject.getMetadata());
        }
        if (storageObject.getTimeDeleted() != null) {
            builder.setDeleteTime(storageObject.getTimeDeleted().getValue());
        }
        if (storageObject.getUpdated() != null) {
            builder.setUpdateTime(storageObject.getUpdated().getValue());
        }
        if (storageObject.getTimeCreated() != null) {
            builder.setCreateTime(storageObject.getTimeCreated().getValue());
        }
        if (storageObject.getSize() != null) {
            builder.setSize(storageObject.getSize().longValue());
        }
        if (storageObject.getOwner() != null) {
            builder.setOwner(Acl.Entity.fromPb(storageObject.getOwner().getEntity()));
        }
        if (storageObject.getAcl() != null) {
            builder.setAcl(Lists.transform((List)storageObject.getAcl(), (Function)new Function<ObjectAccessControl, Acl>(){

                public Acl apply(ObjectAccessControl objectAccessControl) {
                    return Acl.fromPb(objectAccessControl);
                }
            }));
        }
        if (storageObject.containsKey((Object)"isDirectory")) {
            builder.setIsDirectory(Boolean.TRUE);
        }
        if (storageObject.getCustomerEncryption() != null) {
            builder.setCustomerEncryption(CustomerEncryption.fromPb(storageObject.getCustomerEncryption()));
        }
        if (storageObject.getStorageClass() != null) {
            builder.setStorageClass(StorageClass.valueOf(storageObject.getStorageClass()));
        }
        if (storageObject.getKmsKeyName() != null) {
            builder.setKmsKeyName(storageObject.getKmsKeyName());
        }
        return builder.build();
    }

    static final class BuilderImpl
    extends Builder {
        private BlobId blobId;
        private String generatedId;
        private String contentType;
        private String contentEncoding;
        private String contentDisposition;
        private String contentLanguage;
        private Integer componentCount;
        private String cacheControl;
        private List<Acl> acl;
        private Acl.Entity owner;
        private Long size;
        private String etag;
        private String selfLink;
        private String md5;
        private String crc32c;
        private String mediaLink;
        private Map<String, String> metadata;
        private Long metageneration;
        private Long deleteTime;
        private Long updateTime;
        private Long createTime;
        private Boolean isDirectory;
        private CustomerEncryption customerEncryption;
        private StorageClass storageClass;
        private String kmsKeyName;

        BuilderImpl(BlobId blobId) {
            this.blobId = blobId;
        }

        BuilderImpl(BlobInfo blobInfo) {
            this.blobId = blobInfo.blobId;
            this.generatedId = blobInfo.generatedId;
            this.cacheControl = blobInfo.cacheControl;
            this.contentEncoding = blobInfo.contentEncoding;
            this.contentType = blobInfo.contentType;
            this.contentDisposition = blobInfo.contentDisposition;
            this.contentLanguage = blobInfo.contentLanguage;
            this.componentCount = blobInfo.componentCount;
            this.customerEncryption = blobInfo.customerEncryption;
            this.acl = blobInfo.acl;
            this.owner = blobInfo.owner;
            this.size = blobInfo.size;
            this.etag = blobInfo.etag;
            this.selfLink = blobInfo.selfLink;
            this.md5 = blobInfo.md5;
            this.crc32c = blobInfo.crc32c;
            this.mediaLink = blobInfo.mediaLink;
            this.metadata = blobInfo.metadata;
            this.metageneration = blobInfo.metageneration;
            this.deleteTime = blobInfo.deleteTime;
            this.updateTime = blobInfo.updateTime;
            this.createTime = blobInfo.createTime;
            this.isDirectory = blobInfo.isDirectory;
            this.storageClass = blobInfo.storageClass;
            this.kmsKeyName = blobInfo.kmsKeyName;
        }

        @Override
        public Builder setBlobId(BlobId blobId) {
            this.blobId = (BlobId)Preconditions.checkNotNull((Object)blobId);
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        public Builder setContentType(String contentType) {
            this.contentType = (String)MoreObjects.firstNonNull((Object)contentType, (Object)Data.nullOf(String.class));
            return this;
        }

        @Override
        public Builder setContentDisposition(String contentDisposition) {
            this.contentDisposition = (String)MoreObjects.firstNonNull((Object)contentDisposition, (Object)Data.nullOf(String.class));
            return this;
        }

        @Override
        public Builder setContentLanguage(String contentLanguage) {
            this.contentLanguage = (String)MoreObjects.firstNonNull((Object)contentLanguage, (Object)Data.nullOf(String.class));
            return this;
        }

        @Override
        public Builder setContentEncoding(String contentEncoding) {
            this.contentEncoding = (String)MoreObjects.firstNonNull((Object)contentEncoding, (Object)Data.nullOf(String.class));
            return this;
        }

        @Override
        Builder setComponentCount(Integer componentCount) {
            this.componentCount = componentCount;
            return this;
        }

        @Override
        public Builder setCacheControl(String cacheControl) {
            this.cacheControl = (String)MoreObjects.firstNonNull((Object)cacheControl, (Object)Data.nullOf(String.class));
            return this;
        }

        @Override
        public Builder setAcl(List<Acl> acl) {
            this.acl = acl != null ? ImmutableList.copyOf(acl) : null;
            return this;
        }

        @Override
        Builder setOwner(Acl.Entity owner) {
            this.owner = owner;
            return this;
        }

        @Override
        Builder setSize(Long size) {
            this.size = size;
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        @Override
        Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        @Override
        public Builder setMd5(String md5) {
            this.md5 = (String)MoreObjects.firstNonNull((Object)md5, (Object)Data.nullOf(String.class));
            return this;
        }

        @Override
        public Builder setCrc32c(String crc32c) {
            this.crc32c = (String)MoreObjects.firstNonNull((Object)crc32c, (Object)Data.nullOf(String.class));
            return this;
        }

        @Override
        Builder setMediaLink(String mediaLink) {
            this.mediaLink = mediaLink;
            return this;
        }

        @Override
        public Builder setMetadata(Map<String, String> metadata) {
            this.metadata = metadata != null ? new HashMap<String, String>(metadata) : (Map)Data.nullOf(ImmutableEmptyMap.class);
            return this;
        }

        @Override
        public Builder setStorageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        Builder setMetageneration(Long metageneration) {
            this.metageneration = metageneration;
            return this;
        }

        @Override
        Builder setDeleteTime(Long deleteTime) {
            this.deleteTime = deleteTime;
            return this;
        }

        @Override
        Builder setUpdateTime(Long updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        Builder setCreateTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        @Override
        Builder setIsDirectory(boolean isDirectory) {
            this.isDirectory = isDirectory;
            return this;
        }

        @Override
        Builder setCustomerEncryption(CustomerEncryption customerEncryption) {
            this.customerEncryption = customerEncryption;
            return this;
        }

        @Override
        @GcpLaunchStage.Beta
        Builder setKmsKeyName(String kmsKeyName) {
            this.kmsKeyName = kmsKeyName;
            return this;
        }

        @Override
        public BlobInfo build() {
            Preconditions.checkNotNull((Object)this.blobId);
            return new BlobInfo(this);
        }
    }

    public static abstract class Builder {
        public abstract Builder setBlobId(BlobId var1);

        abstract Builder setGeneratedId(String var1);

        public abstract Builder setContentType(String var1);

        public abstract Builder setContentDisposition(String var1);

        public abstract Builder setContentLanguage(String var1);

        public abstract Builder setContentEncoding(String var1);

        abstract Builder setComponentCount(Integer var1);

        public abstract Builder setCacheControl(String var1);

        public abstract Builder setAcl(List<Acl> var1);

        abstract Builder setOwner(Acl.Entity var1);

        abstract Builder setSize(Long var1);

        abstract Builder setEtag(String var1);

        abstract Builder setSelfLink(String var1);

        public abstract Builder setMd5(String var1);

        public abstract Builder setCrc32c(String var1);

        abstract Builder setMediaLink(String var1);

        public abstract Builder setStorageClass(StorageClass var1);

        public abstract Builder setMetadata(Map<String, String> var1);

        abstract Builder setMetageneration(Long var1);

        abstract Builder setDeleteTime(Long var1);

        abstract Builder setUpdateTime(Long var1);

        abstract Builder setCreateTime(Long var1);

        abstract Builder setIsDirectory(boolean var1);

        abstract Builder setCustomerEncryption(CustomerEncryption var1);

        @GcpLaunchStage.Beta
        abstract Builder setKmsKeyName(String var1);

        public abstract BlobInfo build();
    }

    public static class CustomerEncryption
    implements Serializable {
        private static final long serialVersionUID = -2133042982786959351L;
        private final String encryptionAlgorithm;
        private final String keySha256;

        CustomerEncryption(String encryptionAlgorithm, String keySha256) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            this.keySha256 = keySha256;
        }

        public String getEncryptionAlgorithm() {
            return this.encryptionAlgorithm;
        }

        public String getKeySha256() {
            return this.keySha256;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("encryptionAlgorithm", (Object)this.getEncryptionAlgorithm()).add("keySha256", (Object)this.getKeySha256()).toString();
        }

        public final int hashCode() {
            return Objects.hash(this.encryptionAlgorithm, this.keySha256);
        }

        public final boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(CustomerEncryption.class) && Objects.equals(this.toPb(), ((CustomerEncryption)obj).toPb());
        }

        StorageObject.CustomerEncryption toPb() {
            return new StorageObject.CustomerEncryption().setEncryptionAlgorithm(this.encryptionAlgorithm).setKeySha256(this.keySha256);
        }

        static CustomerEncryption fromPb(StorageObject.CustomerEncryption customerEncryptionPb) {
            return new CustomerEncryption(customerEncryptionPb.getEncryptionAlgorithm(), customerEncryptionPb.getKeySha256());
        }
    }

    public static final class ImmutableEmptyMap<K, V>
    extends AbstractMap<K, V> {
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return ImmutableSet.of();
        }
    }
}

