/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.AnyGene;
import io.jenetics.Chromosome;
import io.jenetics.Gene;
import io.jenetics.VariableChromosome;
import io.jenetics.internal.util.Equality;
import io.jenetics.util.ISeq;
import io.jenetics.util.IntRange;
import io.jenetics.util.Seq;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class AnyChromosome<A>
extends VariableChromosome<AnyGene<A>> {
    private final Supplier<? extends A> _supplier;
    private final Predicate<? super A> _alleleValidator;
    private final Predicate<? super ISeq<A>> _alleleSeqValidator;
    private Boolean _valid = null;

    protected AnyChromosome(ISeq<AnyGene<A>> genes, Supplier<? extends A> supplier, Predicate<? super A> alleleValidator, Predicate<? super ISeq<A>> alleleSeqValidator, IntRange lengthRange) {
        super(genes, lengthRange);
        this._supplier = Objects.requireNonNull(supplier);
        this._alleleValidator = Objects.requireNonNull(alleleValidator);
        this._alleleSeqValidator = Objects.requireNonNull(alleleSeqValidator);
    }

    @Override
    public boolean isValid() {
        Boolean valid;
        Boolean bl = valid = this._alleleValidator == Equality.TRUE && this._alleleSeqValidator == Equality.True() ? Boolean.TRUE : this._valid;
        if (valid == null) {
            Seq alleles = this.toSeq().map(Gene::getAllele);
            valid = this._alleleSeqValidator.test((ISeq<A>)alleles) && alleles.forAll(this._alleleValidator);
        }
        this._valid = valid;
        return this._valid;
    }

    @Override
    public Chromosome<AnyGene<A>> newInstance(ISeq<AnyGene<A>> genes) {
        return new AnyChromosome<A>(genes, this._supplier, this._alleleValidator, this._alleleSeqValidator, this.lengthRange());
    }

    @Override
    public Chromosome<AnyGene<A>> newInstance() {
        return AnyChromosome.of(this._supplier, this._alleleValidator, this._alleleSeqValidator, this.lengthRange());
    }

    public static <A> AnyChromosome<A> of(Supplier<? extends A> supplier, Predicate<? super A> alleleValidator, Predicate<? super ISeq<A>> alleleSeqValidator, IntRange lengthRange) {
        return new AnyChromosome<A>(AnyGene.seq(lengthRange, supplier, alleleValidator), supplier, alleleValidator, alleleSeqValidator, lengthRange);
    }

    public static <A> AnyChromosome<A> of(Supplier<? extends A> supplier, Predicate<? super A> alleleValidator, Predicate<? super ISeq<A>> alleleSeqValidator, int length) {
        return AnyChromosome.of(supplier, alleleValidator, alleleSeqValidator, IntRange.of(length));
    }

    public static <A> AnyChromosome<A> of(Supplier<? extends A> supplier, Predicate<? super A> validator, IntRange lengthRange) {
        return AnyChromosome.of(supplier, validator, Equality.True(), lengthRange);
    }

    public static <A> AnyChromosome<A> of(Supplier<? extends A> supplier, Predicate<? super A> validator, int length) {
        return AnyChromosome.of(supplier, validator, Equality.True(), length);
    }

    public static <A> AnyChromosome<A> of(Supplier<? extends A> supplier, Predicate<? super A> validator) {
        return AnyChromosome.of(supplier, validator, 1);
    }

    public static <A> AnyChromosome<A> of(Supplier<? extends A> supplier, IntRange lengthRange) {
        return AnyChromosome.of(supplier, Equality.TRUE, lengthRange);
    }

    public static <A> AnyChromosome<A> of(Supplier<? extends A> supplier, int length) {
        return AnyChromosome.of(supplier, Equality.TRUE, length);
    }

    public static <A> AnyChromosome<A> of(Supplier<? extends A> supplier) {
        return AnyChromosome.of(supplier, 1);
    }
}

