/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.collection;

import io.jenetics.internal.collection.Array;
import io.jenetics.internal.collection.ArrayIterator;
import io.jenetics.internal.collection.ArraySpliterator;
import io.jenetics.util.Seq;
import java.io.Serializable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class ArraySeq<T>
implements Seq<T>,
RandomAccess,
Serializable {
    private static final long serialVersionUID = 1L;
    public final Array<T> array;

    public ArraySeq(Array<T> array2) {
        this.array = Objects.requireNonNull(array2, "Array must not be null.");
    }

    @Override
    public final T get(int index) {
        this.array.checkIndex(index);
        return this.array.get(index);
    }

    final Array<T> __append(Iterable<? extends T> values) {
        Objects.requireNonNull(values);
        return values instanceof ArraySeq ? this.array.append(((ArraySeq)values).array) : this.array.append(values);
    }

    final Array<T> __prepend(Iterable<? extends T> values) {
        Objects.requireNonNull(values);
        return values instanceof ArraySeq ? ((ArraySeq)values).array.append(this.array) : this.array.prepend(values);
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ArrayIterator<T>(this.array);
    }

    @Override
    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public Stream<T> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    @Override
    public Spliterator<T> spliterator() {
        return new ArraySpliterator<T>(this.array);
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer, "The consumer must not be null.");
        for (int i = 0; i < this.array.length(); ++i) {
            consumer.accept(this.array.get(i));
        }
    }

    @Override
    public boolean forAll(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "Predicate");
        boolean valid = true;
        for (int i = 0; i < this.array.length() && valid; ++i) {
            valid = predicate.test(this.array.get(i));
        }
        return valid;
    }

    @Override
    public int indexWhere(Predicate<? super T> predicate, int start, int end) {
        this.array.checkIndex(start, end);
        Objects.requireNonNull(predicate, "Predicate");
        int index = -1;
        for (int i = start; i < end && index == -1; ++i) {
            if (!predicate.test(this.array.get(i))) continue;
            index = i;
        }
        return index;
    }

    @Override
    public int lastIndexWhere(Predicate<? super T> predicate, int start, int end) {
        this.array.checkIndex(start, end);
        Objects.requireNonNull(predicate, "Predicate must not be null.");
        int index = -1;
        int i = end;
        while (--i >= start && index == -1) {
            if (!predicate.test(this.array.get(i))) continue;
            index = i;
        }
        return index;
    }

    @Override
    public int length() {
        return this.array.length();
    }

    public String toString() {
        return this.toString("[", ",", "]");
    }

    @Override
    public int hashCode() {
        return Seq.hashCode(this);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Seq)) {
            return false;
        }
        Seq seq = (Seq)object;
        return Seq.equals(this, seq);
    }
}

