/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.firewall;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.F.C;
import com.ubnt.model.api.firewall.CombinedTrafficFirewallRuleDto;
import com.ubnt.model.api.firewall.CombinedTrafficFirewallRuleOriginType;
import com.ubnt.model.api.firewall.FirewallRuleDetailsDto;
import com.ubnt.model.api.firewall.ImmutableCombinedTrafficRuleDto;
import com.ubnt.model.api.traffic.TrafficDomainDto;
import com.ubnt.model.api.traffic.TrafficIpDto;
import com.ubnt.model.api.traffic.TrafficIpRangeDto;
import com.ubnt.model.api.traffic.TrafficTargetDeviceDto;
import com.ubnt.model.api.trafficrule.TrafficDirection;
import com.ubnt.model.api.trafficrule.TrafficRuleAction;
import com.ubnt.model.api.trafficrule.TrafficRuleBandwidthLimitDto;
import com.ubnt.model.api.trafficrule.TrafficRuleMatchingTarget;
import com.ubnt.model.api.trafficrule.TrafficRuleScheduleDto;
import com.ubnt.service.firewall.O;
import com.ubnt.service.trafficrule.TrafficRuleDocument;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@C
public interface CombinedTrafficRuleDto
extends CombinedTrafficFirewallRuleDto {
    @Override
    default public CombinedTrafficFirewallRuleOriginType originType() {
        return CombinedTrafficFirewallRuleOriginType.TRAFFIC_RULE;
    }

    @JsonProperty(value="traffic_rule_action")
    public TrafficRuleAction trafficRuleAction();

    @JsonProperty(value="target_devices")
    public List<TrafficTargetDeviceDto> targetDevices();

    @JsonProperty(value="matching_target")
    public TrafficRuleMatchingTarget matchingTarget();

    @JsonProperty(value="app_category_ids")
    public List<Integer> appCategoryIds();

    @JsonProperty(value="app_ids")
    public List<Integer> appIds();

    @JsonProperty(value="domains")
    public List<TrafficDomainDto> domains();

    @JsonProperty(value="ip_addresses")
    public List<TrafficIpDto> ipAddresses();

    @JsonProperty(value="ip_ranges")
    public List<TrafficIpRangeDto> ipRanges();

    @JsonProperty(value="network_ids")
    public List<String> networkIds();

    @JsonProperty(value="firewall_rule_details")
    public List<FirewallRuleDetailsDto> firewallRuleDetails();

    @JsonProperty(value="regions")
    @Size(max=150)
    public @Size(max=150) List<String> regions();

    @JsonProperty(value="schedule")
    public TrafficRuleScheduleDto schedule();

    @JsonProperty(value="bandwidth_limit")
    public TrafficRuleBandwidthLimitDto bandwidthLimit();

    @JsonProperty(value="traffic_direction")
    @Schema(name="Traffic direction used for \"Internet\" and \"Local Network\" targets")
    public Optional<TrafficDirection> trafficDirection();

    public static ImmutableCombinedTrafficRuleDto.Builder builder() {
        return ImmutableCombinedTrafficRuleDto.builder();
    }

    public static CombinedTrafficFirewallRuleDto of(TrafficRuleDocument trafficRuleDocument) {
        return CombinedTrafficRuleDto.of(trafficRuleDocument, List.of());
    }

    public static CombinedTrafficFirewallRuleDto of(TrafficRuleDocument trafficRuleDocument, List<O> list) {
        return ImmutableCombinedTrafficRuleDto.builder().name(trafficRuleDocument.getDescription()).originId(trafficRuleDocument.getId()).trafficRuleAction(trafficRuleDocument.getAction()).enabled(trafficRuleDocument.isEnabled()).firewallRuleDetails(list.stream().map(FirewallRuleDetailsDto::of).toList()).matchingTarget(trafficRuleDocument.getMatchingTarget()).appCategoryIds(trafficRuleDocument.getAppCategoryIds()).appIds(trafficRuleDocument.getAppIds()).domains(trafficRuleDocument.getDomains().stream().map(TrafficDomainDto::fromDocument).toList()).ipAddresses(trafficRuleDocument.getIpAddresses().stream().map(TrafficIpDto::fromDocument).toList()).ipRanges(trafficRuleDocument.getIpRanges().stream().map(TrafficIpRangeDto::fromDocument).toList()).networkIds(trafficRuleDocument.getNetworkIds()).regions(trafficRuleDocument.getRegions()).trafficDirection(Optional.ofNullable(trafficRuleDocument.getTrafficDirection())).targetDevices(trafficRuleDocument.getTargetDevices().stream().map(TrafficTargetDeviceDto::fromDocument).toList()).schedule(TrafficRuleScheduleDto.fromDocument(trafficRuleDocument.getSchedule())).bandwidthLimit(TrafficRuleBandwidthLimitDto.fromDocument(trafficRuleDocument.getBandwidthLimit())).build();
    }
}

