/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.auth.eap;

import com.axlradius.radclient4.ClientReceiveException;
import com.axlradius.radclient4.ClientSendException;
import com.axlradius.radclient4.PacketType;
import com.axlradius.radclient4.RADIUSClient;
import com.axlradius.radclient4.RADIUSException;
import com.axlradius.radclient4.attributes.Attribute;
import com.axlradius.radclient4.attributes.AttributeList;
import com.axlradius.radclient4.auth.eap.EAPClientParameters;
import com.axlradius.radclient4.auth.eap.EAPException;
import com.axlradius.radclient4.auth.eap.EAPPacket;
import com.axlradius.radclient4.auth.eap.EAPParameters;
import com.axlradius.radclient4.auth.eap.EAPType;
import com.axlradius.radclient4.auth.eap.EAPTypeClientParameters;
import com.axlradius.radclient4.auth.eap.PublicState;
import com.axlradius.radclient4.auth.eap.tls.ttls.client.TTLSClient;
import com.axlradius.radclient4.auth.eap.tls.ttls.client.c;
import com.axlradius.radclient4.radutil.Util;
import java.io.IOException;
import java.net.SocketException;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ClientLayer {
    public static final int STATE_NONE = 0;
    private int state = 1;
    private PublicState a;
    private EAPPacket a;
    private int O;
    private EAPTypeClientParameters a;
    private RADIUSClient a;
    private Attribute[] b;
    private boolean debug;
    private a a;
    private c a;
    private AttributeList d;
    private AttributeList e;
    private TUNNEL a;
    private TTLSClient a = TUNNEL.RADIUS;

    public ClientLayer(RADIUSClient rADIUSClient) throws EAPException {
        this.a = rADIUSClient;
        this.debug = rADIUSClient.getDebugIndicator();
        this.a = new a(0);
        this.a = new EAPTypeClientParameters();
        this.a = PublicState.IDENTITY;
    }

    public final void add(EAPClientParameters eAPClientParameters) {
        this.a.add(eAPClientParameters);
        eAPClientParameters.setClientLayer(this);
    }

    public final PublicState authenticate() throws EAPException, SocketException, ClientSendException, ClientReceiveException, RADIUSException, IOException {
        switch (this.a) {
            case CONTINUE: 
            case IDENTITY: {
                break;
            }
            default: {
                return this.a("Error: Authentication previously completed with " + (Object)((Object)this.a));
            }
        }
        if (this.state == 4) {
            return this.a("Error: Authentication previously completed.");
        }
        this.d = new AttributeList();
        Object object = null;
        Object object2 = this.a.b();
        do {
            int n2;
            switch (this.state) {
                case 1: {
                    byte[] byArray = this.a == TUNNEL.RADIUS ? ((EAPClientParameters)object2).getOuterIdentity() : ((EAPClientParameters)object2).getAuthenticationName();
                    this.d = new EAPPacket().createIdentityResponse(0, byArray);
                    if (this.debug) {
                        this.logToDebug("Sending Identity packet, identity (" + Util.toUTF8(byArray) + ")");
                    }
                    this.state = 2;
                    this.a = PublicState.CONTINUE;
                    break;
                }
                case 2: {
                    this.a = new EAPPacket(this.e);
                    n2 = this.a.getType();
                    if (!this.a.contains(new EAPType(n2))) {
                        if (this.debug) {
                            this.logToDebug("Received default EAP type " + this.a.getTypeName());
                        }
                        if (++this.O > 1) {
                            return this.a("More than one NAK received.");
                        }
                        byte[] byArray = this.a.e();
                        this.d = new EAPPacket().createNAKResponse(0, byArray);
                        Util.clean(byArray);
                        break;
                    }
                    this.a.c(n2);
                    object = this.a.a();
                    object2 = this.a.a();
                    ((EAPClientParameters)object2).setClientLayer(this);
                    this.state = 3;
                }
                case 3: {
                    try {
                        this.a = this.a.a((EAPType)object, this.a);
                    }
                    catch (Exception exception) {
                        this.state = 4;
                        return this.a("Error instantiating eap type " + object + " " + exception.getMessage());
                    }
                    try {
                        this.a.a((EAPParameters)object2);
                    }
                    catch (Exception exception) {
                        this.state = 4;
                        return this.a("Error setting parameters for eap type " + object + " " + exception.getMessage());
                    }
                    this.a.a(this.a);
                    this.a = this.a.authenticate();
                    this.a.clean();
                    if (this.a == PublicState.ERROR || this.a == PublicState.FAIL) {
                        this.logToDebug("Error: " + this.a.getMessage() + "\n" + this.a.getStacktrace());
                    }
                    if (this.a == PublicState.COMPLETE) {
                        this.state = 4;
                    }
                    return this.a;
                }
            }
            this.e = this.transaction((EAPClientParameters)object2, this.d);
            switch (this.a) {
                case CONTINUE: {
                    break;
                }
                case COMPLETE: {
                    return this.a;
                }
                case ERROR: {
                    this.logToDebug("Error: " + this.a.getMessage());
                    return this.a;
                }
                case FAIL: {
                    this.logToDebug("Error: " + this.a.getMessage());
                    return this.a;
                }
                default: {
                    return this.a("In illegal public state: " + (Object)((Object)this.a));
                }
            }
            this.a = new EAPPacket(this.e);
            n2 = this.a.getCode();
            if (n2 > 4) {
                return this.a("Illegal EAP code of " + n2 + " found while negotiating EAP connection.");
            }
            if (!(this.a.isSuccess() & this.O > 0)) continue;
            this.state = 0;
            return this.a("Unexpected EAP-Success while negotiating EAP connection.");
        } while (!this.a.isFailure());
        this.state = 0;
        object2 = "EAP-Failure while negotiating EAP connection.";
        object = this;
        this.a = PublicState.FAIL;
        ((ClientLayer)object).a.setMessage((String)object2);
        ((ClientLayer)object).state = 4;
        return ((ClientLayer)object).a;
    }

    public final void setTunneling(TUNNEL tUNNEL, TTLSClient tTLSClient) {
        this.a = tUNNEL;
        if (tUNNEL == TUNNEL.TTLS) {
            if (tTLSClient == null) {
                this.a("Internal Error: cannot enable tunneling without a tunneling client");
            }
            this.a = tTLSClient;
        }
    }

    public final AttributeList transaction(EAPClientParameters object, AttributeList attributeList) throws EAPException, ClientSendException, ClientReceiveException, SocketException, IOException {
        Object object2;
        Object object3 = attributeList;
        ClientLayer clientLayer = this;
        if (((AttributeList)object3).contains(79) && (object2 = ((AttributeList)object3).getAttribute(79).getData())[1] == 0) {
            object2[1] = (byte)clientLayer.a.getEAPPacketIdentifier();
            ((AttributeList)object3).set(79, (byte[])object2);
        }
        switch (this.a) {
            case TTLS: {
                object2 = attributeList;
                object3 = object;
                clientLayer = this;
                if (clientLayer.a == null) {
                    object2 = "Internal Error: Cannot tunnel - no TTLSClient set up.";
                    clientLayer.a((String)object2);
                    throw new EAPException((String)object2);
                }
                object = clientLayer.a.a((AttributeList)object2);
                ((AttributeList)object2).deleteAll(1);
                ((AttributeList)object2).add(1, ((EAPClientParameters)object3).getAuthenticationName());
                switch (clientLayer.a) {
                    case ERROR: 
                    case FAIL: {
                        throw new EAPException(clientLayer.a.getMessage());
                    }
                }
                return object;
            }
            case RADIUS: {
                object2 = attributeList;
                object3 = object;
                clientLayer = this;
                ((AttributeList)object2).add(((EAPClientParameters)object3).getCommonList().copy());
                ((AttributeList)object2).deleteAll(1);
                ((AttributeList)object2).add(1, ((EAPClientParameters)object3).getUserName());
                ((AttributeList)object2).add(clientLayer.b);
                clientLayer.a.reset();
                int n2 = clientLayer.a.authenticate((AttributeList)object2);
                switch (n2) {
                    case 3: {
                        object = "Received Access-Reject";
                        clientLayer.a((String)object);
                        throw new EAPException((String)object);
                    }
                    case 11: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 0: {
                        object = "Error: RADIUS client error - " + clientLayer.a.getErrorString();
                        clientLayer.a((String)object);
                        throw new EAPException((String)object);
                    }
                    default: {
                        object = "Error: RADIUS client error - unexpected packet type " + PacketType.getName(n2);
                        clientLayer.a((String)object);
                        throw new EAPException((String)object);
                    }
                }
                object = clientLayer.a.getAttributes();
                clientLayer.b = ((AttributeList)object).toArray(24);
                if (!((AttributeList)object).contains(79)) {
                    object = "Missing EAP-Message in EAP transaction.";
                    clientLayer.a((String)object);
                    throw new EAPException((String)object);
                }
                return object;
            }
        }
        return new AttributeList();
    }

    public static void verifyPacket(EAPPacket eAPPacket, EAPClientParameters eAPClientParameters) throws EAPException {
        switch (eAPPacket.getCode()) {
            case 1: {
                if (eAPPacket.getLength() < 4) {
                    throw new EAPException("EAP Layer: Malformed EAP REQUEST - missing payload data.");
                }
                if (eAPPacket.getType() == eAPClientParameters.getEAPType().getType()) break;
                throw new EAPException("EAP Layer: Unexpected EAP type: found " + eAPPacket.getTypeName() + ", expecting " + EAPPacket.getTypeName(eAPClientParameters.getEAPType()));
            }
            case 2: 
            case 3: 
            case 4: {
                return;
            }
            default: {
                throw new EAPException("EAP Layer: Illegal EAP code: found " + eAPPacket.getCodeName());
            }
        }
    }

    public final void close() {
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            this.b[i2].clean();
        }
        this.a.clearMessage();
        this.a = PublicState.NONE;
    }

    public final String getStateName() {
        String string;
        switch (this.state) {
            case 0: {
                string = "NO STATE";
                break;
            }
            case 1: {
                string = "IDENTITY";
                break;
            }
            case 2: {
                string = "CHECK ID RESPONSE";
                break;
            }
            case 3: {
                string = "AUTHENTICATE";
                break;
            }
            case 4: {
                string = "COMPLETE";
                break;
            }
            default: {
                string = "Unknown (" + this.state + ")";
            }
        }
        return string;
    }

    private PublicState a(String string) {
        this.a = PublicState.ERROR;
        this.a.setMessage(string);
        this.state = 4;
        return this.a;
    }

    public final void logToDebug(String string) {
        assert (this.a != null);
        if (this.debug) {
            String string2 = this.a == TUNNEL.RADIUS ? "EAP Layer: " : "EAP Layer[Tunnel]: ";
            this.a.logToDebug(string2 + string);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    final class a {
        private Map<EAPType, EAPClientParameters> a;
        private EAPType a = new LinkedHashMap<EAPType, EAPClientParameters>();

        private a() {
        }

        final void add(EAPClientParameters eAPClientParameters) {
            EAPType eAPType = eAPClientParameters.getEAPType();
            this.a.put(eAPType, eAPClientParameters);
        }

        final void c(int n2) {
            this.a = new EAPType(n2);
        }

        public final EAPType a() {
            return this.a;
        }

        public final EAPClientParameters a() {
            return this.a.get(this.a);
        }

        final boolean contains(EAPType eAPType) {
            return this.a.containsKey(eAPType);
        }

        final byte[] e() {
            byte[] byArray = new byte[this.a.size()];
            for (EAPType eAPType : this.a.keySet()) {
                byArray[0] = (byte)eAPType.getType();
            }
            return byArray;
        }

        final EAPClientParameters b() {
            Object object = this;
            if (((a)object).a.isEmpty()) {
                throw new IllegalArgumentException("No client parameters present.");
            }
            object = ((a)object).a.keySet().iterator().next();
            return this.a.get(object);
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }

    public static enum TUNNEL {
        RADIUS,
        TTLS;

    }
}

