/*
 * Decompiled with CFR 0.152.
 */
package rundeck.services;

import com.dtolabs.rundeck.core.authorization.UserAndRolesAuthContext;
import com.dtolabs.rundeck.core.execution.PreparedExecutionReference;
import com.dtolabs.rundeck.core.jobs.JobReference;
import com.dtolabs.rundeck.core.schedule.JobScheduleFailure;
import com.dtolabs.rundeck.core.schedule.JobScheduleManager;
import grails.artefact.Artefact;
import grails.events.annotation.Subscriber;
import grails.events.bus.EventBus;
import grails.events.bus.EventBusAware;
import grails.plugins.mail.MailMessageBuilder;
import grails.plugins.mail.SendMail;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.grails.datastore.mapping.engine.event.AbstractPersistenceEvent;
import org.grails.datastore.mapping.engine.event.PostInsertEvent;
import org.grails.datastore.mapping.engine.event.PostUpdateEvent;
import org.grails.events.gorm.GormAnnotatedSubscriber;
import org.grails.events.transform.AnnotatedSubscriber;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import rundeck.Execution;
import rundeck.data.quartz.QuartzJobSpecifier;
import rundeck.services.FrameworkService;
import rundeck.services.QuartzJobScheduleManagerService;
import rundeck.services.ScheduledExecutionService;

@Artefact(value="Service")
public class QuartzJobScheduleManagerService
implements JobScheduleManager,
InitializingBean,
GroovyObject,
SendMail,
SendMail.Trait.FieldHelper,
GormAnnotatedSubscriber,
EventBusAware.Trait.FieldHelper {
    @Autowired
    private Scheduler quartzScheduler;
    @Autowired
    private FrameworkService frameworkService;
    @Autowired
    private ScheduledExecutionService scheduledExecutionService;
    @Autowired
    private QuartzJobSpecifier quartzJobSpecifier;
    private static String TRIGGER_GROUP_PENDING;
    private ScheduledExecutorService scheduledExecutor;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    @Autowired(required=true)
    private ApplicationContext grails_plugins_mail_SendMail__applicationContext;
    public static final Boolean lazyInit;
    private EventBus grails_events_bus_EventBusAware__eventBus;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public QuartzJobScheduleManagerService() {
        MetaClass metaClass;
        ScheduledExecutorService scheduledExecutorService;
        this.scheduledExecutor = scheduledExecutorService = Executors.newScheduledThreadPool(1);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        SendMail.Trait.Helper.$init$((SendMail)this);
        GormAnnotatedSubscriber.Trait.Helper.$init$((GormAnnotatedSubscriber)this);
        AnnotatedSubscriber.Trait.Helper.$init$((AnnotatedSubscriber)this);
        EventBusAware.Trait.Helper.$init$((EventBusAware)this);
        SendMail.Trait.Helper.$init$((SendMail)this);
        GormAnnotatedSubscriber.Trait.Helper.$init$((GormAnnotatedSubscriber)this);
        AnnotatedSubscriber.Trait.Helper.$init$((AnnotatedSubscriber)this);
        EventBusAware.Trait.Helper.$init$((EventBusAware)this);
        SendMail.Trait.Helper.$init$((SendMail)this);
    }

    public void afterPropertiesSet() {
        GroupMatcher matcher = GroupMatcher.groupEquals((String)TRIGGER_GROUP_PENDING);
        this.quartzScheduler.pauseTriggers(matcher);
        this.scheduledExecutor.scheduleAtFixedRate((Runnable)new _afterPropertiesSet_closure1((Object)this, (Object)this), 15, 15, TimeUnit.SECONDS);
    }

    public void deleteJobSchedule(String quartzJobName, String quartzJobGroup) {
        this.quartzScheduler.deleteJob(new JobKey(quartzJobName, quartzJobGroup));
    }

    public Date scheduleJob(String quartzJobName, String quartzJobGroup, Map data, Date atTime, boolean pending) throws JobScheduleFailure {
        SimpleTrigger trigger;
        JobDetail jobDetail;
        block7: {
            this.interruptScheduleOnPassiveMode();
            data.put("meta.created", Instant.now());
            String triggerGroup = pending ? TRIGGER_GROUP_PENDING : quartzJobGroup;
            Map map = data;
            jobDetail = JobBuilder.newJob((Class)this.quartzJobSpecifier.getJobClass()).withIdentity(quartzJobName, quartzJobGroup).usingJobData(new JobDataMap(DefaultTypeTransformation.booleanUnbox((Object)map) ? map : ScriptBytecodeAdapter.createMap((Object[])new Object[0]))).build();
            trigger = (SimpleTrigger)ScriptBytecodeAdapter.castToType((Object)TriggerBuilder.newTrigger().withIdentity(quartzJobName, triggerGroup).startAt(atTime).build(), SimpleTrigger.class);
            if (!this.quartzScheduler.checkExists(jobDetail.getKey())) break block7;
            Date date = this.quartzScheduler.rescheduleJob(TriggerKey.triggerKey((String)quartzJobName, (String)triggerGroup), (Trigger)trigger);
            return date;
        }
        Date date = this.quartzScheduler.scheduleJob(jobDetail, (Trigger)trigger);
        try {
            return date;
        }
        catch (SchedulerException exc) {
            throw (Throwable)new JobScheduleFailure(StringGroovyMethods.plus((String)"caught exception while adding job: ", (CharSequence)exc.getMessage()), (Throwable)exc);
        }
    }

    public boolean scheduleJobNow(String quartzJobName, String quartzJobGroup, Map data, boolean pending) throws JobScheduleFailure {
        this.interruptScheduleOnPassiveMode();
        data.put("meta.created", Instant.now());
        String triggerGroup = pending ? TRIGGER_GROUP_PENDING : quartzJobGroup;
        Map map = data;
        JobDetail jobDetail = JobBuilder.newJob((Class)this.quartzJobSpecifier.getJobClass()).withIdentity(quartzJobName, quartzJobGroup).usingJobData(new JobDataMap(DefaultTypeTransformation.booleanUnbox((Object)map) ? map : ScriptBytecodeAdapter.createMap((Object[])new Object[0]))).build();
        Trigger trigger = TriggerBuilder.newTrigger().startNow().withIdentity(quartzJobName, triggerGroup).build();
        boolean bl = this.quartzScheduler.scheduleJob(jobDetail, trigger) != null;
        try {
            return bl;
        }
        catch (SchedulerException exc) {
            throw (Throwable)new JobScheduleFailure(StringGroovyMethods.plus((String)"caught exception while adding job: ", (CharSequence)exc.getMessage()), (Throwable)exc);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date reschedulePendingJob(String quartzJobName, String quartzJobGroup) {
        Trigger trigger;
        try {
            trigger = this.quartzScheduler.getTrigger(TriggerKey.triggerKey((String)quartzJobName, (String)TRIGGER_GROUP_PENDING));
            if (trigger == null) {
                Object v0;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{quartzJobName}, new String[]{"Pending trigger not found for reschedule: ", ""})));
                    v0 = null;
                    return (Date)ScriptBytecodeAdapter.castToType(null, Date.class);
                } else {
                    v0 = null;
                }
                return (Date)ScriptBytecodeAdapter.castToType(null, Date.class);
            }
        }
        catch (SchedulerException exc) {
            throw (Throwable)new JobScheduleFailure(StringGroovyMethods.plus((String)"caught exception rescheduling pending job: ", (CharSequence)exc.getMessage()), (Throwable)exc);
        }
        {
            if (!DefaultTypeTransformation.booleanUnbox((Object)trigger)) return (Date)ScriptBytecodeAdapter.castToType(null, Date.class);
            Trigger newTrigger = trigger.getTriggerBuilder().withIdentity(quartzJobName, quartzJobGroup).build();
            return this.quartzScheduler.rescheduleJob(trigger.getKey(), newTrigger);
        }
    }

    public boolean updateScheduleOwner(JobReference job) {
        return true;
    }

    public String determineExecNode(JobReference job) {
        return this.frameworkService.getServerUUID();
    }

    public boolean tryAcquireExecCleanerJob(String uuid, String project) {
        return true;
    }

    public boolean scheduleRemoteJob(Map data) {
        return false;
    }

    public JobScheduleManager.BeforeExecutionBehavior beforeExecution(PreparedExecutionReference execution, Map<String, Object> dataMap, UserAndRolesAuthContext authContext) {
        return JobScheduleManager.BeforeExecutionBehavior.proceed;
    }

    public void afterExecution(PreparedExecutionReference execution, Map<String, Object> dataMap, UserAndRolesAuthContext authContext) {
    }

    private void cleanupTriggers() {
        GroupMatcher matcher = GroupMatcher.groupEquals((String)TRIGGER_GROUP_PENDING);
        if (this.quartzScheduler.isShutdown()) {
            return;
        }
        DefaultGroovyMethods.each((Set)this.quartzScheduler.getTriggerKeys(matcher), (Closure)new _cleanupTriggers_closure2((Object)this, (Object)this));
    }

    @Subscriber
    public void afterUpdate(PostUpdateEvent event) {
        this.handleExecutionEvent((AbstractPersistenceEvent)event);
    }

    @Subscriber
    public void afterInsert(PostInsertEvent event) {
        this.handleExecutionEvent((AbstractPersistenceEvent)event);
    }

    private Object handleExecutionEvent(AbstractPersistenceEvent event) {
        if (!(event.getEntityObject() instanceof Execution)) {
            return null;
        }
        Execution execution = (Execution)ScriptBytecodeAdapter.asType((Object)event.getEntityObject(), Execution.class);
        return this.rescheduleExecutionIfPending(execution);
    }

    private Object rescheduleExecutionIfPending(Execution execution) {
        Object v0;
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{execution.getId()}, new String[]{"Rescheduling pending execution ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        Map ident = this.scheduledExecutionService.getJobIdent(execution.getScheduledExecution(), execution);
        return this.reschedulePendingJob(ShortTypeHandling.castToString(ident.get("jobname")), ShortTypeHandling.castToString(ident.get("groupname")));
    }

    private void interruptScheduleOnPassiveMode() throws JobScheduleFailure {
        if (!this.frameworkService.getConfigurationService().isExecutionModeActive()) {
            throw (Throwable)new JobScheduleFailure("Execution mode is PASSIVE");
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != QuartzJobScheduleManagerService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Traits.TraitBridge(traitClass=SendMail.class, desc="()Lorg/springframework/context/ApplicationContext;")
    public ApplicationContext getApplicationContext() {
        return SendMail.Trait.Helper.getApplicationContext((SendMail)this);
    }

    @Generated
    public /* synthetic */ ApplicationContext grails_plugins_mail_SendMailtrait$super$getApplicationContext() {
        if (this instanceof GeneratedGroovyProxy) {
            return (ApplicationContext)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getApplicationContext", (Object)new Object[0]), ApplicationContext.class);
        }
        return (ApplicationContext)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getApplicationContext"), ApplicationContext.class);
    }

    @Traits.TraitBridge(traitClass=SendMail.class, desc="(Lorg/springframework/context/ApplicationContext;)V")
    public void setApplicationContext(ApplicationContext arg1) {
        SendMail.Trait.Helper.setApplicationContext((SendMail)this, (ApplicationContext)arg1);
    }

    @Generated
    public /* synthetic */ void grails_plugins_mail_SendMailtrait$super$setApplicationContext(ApplicationContext arg0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setApplicationContext", (Object)new Object[]{arg0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setApplicationContext", (Object[])new Object[]{arg0});
        }
    }

    @Traits.TraitBridge(traitClass=SendMail.class, desc="(Lgroovy/lang/Closure;)Ljava/lang/Object;")
    public Object sendMail(@DelegatesTo(strategy=1, genericTypeIndex=-1, type="", value=MailMessageBuilder.class, target="") Closure arg1) {
        return SendMail.Trait.Helper.sendMail((SendMail)this, (Closure)arg1);
    }

    @Generated
    public /* synthetic */ Object grails_plugins_mail_SendMailtrait$super$sendMail(Closure arg0) {
        if (this instanceof GeneratedGroovyProxy) {
            return InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"sendMail", (Object)new Object[]{arg0});
        }
        return ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"sendMail", (Object[])new Object[]{arg0});
    }

    static {
        Logger logger;
        String string;
        Boolean bl;
        lazyInit = bl = Boolean.FALSE;
        TRIGGER_GROUP_PENDING = string = "pending";
        log = logger = LoggerFactory.getLogger((String)"rundeck.services.QuartzJobScheduleManagerService");
        SendMail.Trait.Helper.$static$init$(QuartzJobScheduleManagerService.class);
        GormAnnotatedSubscriber.Trait.Helper.$static$init$(QuartzJobScheduleManagerService.class);
        AnnotatedSubscriber.Trait.Helper.$static$init$(QuartzJobScheduleManagerService.class);
        EventBusAware.Trait.Helper.$static$init$(QuartzJobScheduleManagerService.class);
        SendMail.Trait.Helper.$static$init$(QuartzJobScheduleManagerService.class);
        GormAnnotatedSubscriber.Trait.Helper.$static$init$(QuartzJobScheduleManagerService.class);
        AnnotatedSubscriber.Trait.Helper.$static$init$(QuartzJobScheduleManagerService.class);
        EventBusAware.Trait.Helper.$static$init$(QuartzJobScheduleManagerService.class);
        SendMail.Trait.Helper.$static$init$(QuartzJobScheduleManagerService.class);
    }

    @Generated
    public /* synthetic */ ApplicationContext grails_plugins_mail_SendMail__applicationContext$get() {
        return this.grails_plugins_mail_SendMail__applicationContext;
    }

    @Generated
    public /* synthetic */ ApplicationContext grails_plugins_mail_SendMail__applicationContext$set(ApplicationContext val) {
        ApplicationContext applicationContext;
        this.grails_plugins_mail_SendMail__applicationContext = applicationContext = val;
        return applicationContext;
    }

    @Traits.TraitBridge(traitClass=GormAnnotatedSubscriber.class, desc="()Ljava/util/Set;")
    public Set<Class<? extends AbstractPersistenceEvent>> getSubscribedEvents() {
        return (Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{PostUpdateEvent.class, PostInsertEvent.class}), Set.class);
    }

    @Generated
    public /* synthetic */ Set<Class<? extends AbstractPersistenceEvent>> org_grails_events_gorm_GormAnnotatedSubscribertrait$super$getSubscribedEvents() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Set)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getSubscribedEvents", (Object)new Object[0]), Set.class);
        }
        return (Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getSubscribedEvents"), Set.class);
    }

    @PostConstruct
    @Traits.TraitBridge(traitClass=AnnotatedSubscriber.class, desc="()V")
    public void registerMethods() {
        AnnotatedSubscriber.Trait.Helper.registerMethods((AnnotatedSubscriber)this);
    }

    @Generated
    public /* synthetic */ void org_grails_events_transform_AnnotatedSubscribertrait$super$registerMethods() {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"registerMethods", (Object)new Object[0]);
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"registerMethods");
        }
    }

    @Traits.TraitBridge(traitClass=AnnotatedSubscriber.class, desc="()Ljava/util/List;")
    public List<Method> getSubscribedMethods() {
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{this.getClass().getMethod("afterUpdate", PostUpdateEvent.class), this.getClass().getMethod("afterInsert", PostInsertEvent.class)});
    }

    @Generated
    public /* synthetic */ List<Method> org_grails_events_transform_AnnotatedSubscribertrait$super$getSubscribedMethods() {
        if (this instanceof GeneratedGroovyProxy) {
            return (List)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getSubscribedMethods", (Object)new Object[0]), List.class);
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getSubscribedMethods"), List.class);
    }

    @Autowired(required=true)
    @Traits.TraitBridge(traitClass=EventBusAware.class, desc="(Lgrails/events/bus/EventBus;)V")
    public void setTargetEventBus(EventBus arg1) {
        EventBusAware.Trait.Helper.setTargetEventBus((EventBusAware)this, (EventBus)arg1);
    }

    @Generated
    public /* synthetic */ void grails_events_bus_EventBusAwaretrait$super$setTargetEventBus(EventBus arg0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setTargetEventBus", (Object)new Object[]{arg0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setTargetEventBus", (Object[])new Object[]{arg0});
        }
    }

    @Traits.TraitBridge(traitClass=EventBusAware.class, desc="()Lgrails/events/bus/EventBus;")
    public EventBus getEventBus() {
        return EventBusAware.Trait.Helper.getEventBus((EventBusAware)this);
    }

    @Generated
    public /* synthetic */ EventBus grails_events_bus_EventBusAwaretrait$super$getEventBus() {
        if (this instanceof GeneratedGroovyProxy) {
            return (EventBus)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getEventBus", (Object)new Object[0]), EventBus.class);
        }
        return (EventBus)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getEventBus"), EventBus.class);
    }

    @Generated
    public /* synthetic */ EventBus grails_events_bus_EventBusAware__eventBus$get() {
        return this.grails_events_bus_EventBusAware__eventBus;
    }

    @Generated
    public /* synthetic */ EventBus grails_events_bus_EventBusAware__eventBus$set(EventBus val) {
        EventBus eventBus;
        this.grails_events_bus_EventBusAware__eventBus = eventBus = val;
        return eventBus;
    }

    public static /* synthetic */ void access$0(QuartzJobScheduleManagerService $that) {
        $that.cleanupTriggers();
    }

    public static /* synthetic */ Scheduler pfaccess$0(QuartzJobScheduleManagerService $that) {
        return $that.quartzScheduler;
    }

    public static /* synthetic */ String pfaccess$1(QuartzJobScheduleManagerService $that) {
        return ShortTypeHandling.castToString((Object)ScriptBytecodeAdapter.getField(QuartzJobScheduleManagerService.class, QuartzJobScheduleManagerService.class, (String)"TRIGGER_GROUP_PENDING"));
    }

    public static /* synthetic */ Logger pfaccess$2(QuartzJobScheduleManagerService $that) {
        return (Logger)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getField(QuartzJobScheduleManagerService.class, QuartzJobScheduleManagerService.class, (String)"log"), Logger.class);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public Scheduler getQuartzScheduler() {
        return this.quartzScheduler;
    }

    @Generated
    public void setQuartzScheduler(Scheduler scheduler) {
        this.quartzScheduler = scheduler;
    }

    @Generated
    public FrameworkService getFrameworkService() {
        return this.frameworkService;
    }

    @Generated
    public void setFrameworkService(FrameworkService frameworkService) {
        this.frameworkService = frameworkService;
    }

    @Generated
    public ScheduledExecutionService getScheduledExecutionService() {
        return this.scheduledExecutionService;
    }

    @Generated
    public void setScheduledExecutionService(ScheduledExecutionService scheduledExecutionService) {
        this.scheduledExecutionService = scheduledExecutionService;
    }

    @Generated
    public QuartzJobSpecifier getQuartzJobSpecifier() {
        return this.quartzJobSpecifier;
    }

    @Generated
    public void setQuartzJobSpecifier(QuartzJobSpecifier quartzJobSpecifier) {
        this.quartzJobSpecifier = quartzJobSpecifier;
    }

    @Generated
    public static String getTRIGGER_GROUP_PENDING() {
        return TRIGGER_GROUP_PENDING;
    }

    @Generated
    public static void setTRIGGER_GROUP_PENDING(String string) {
        TRIGGER_GROUP_PENDING = string;
    }

    @Generated
    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    @Generated
    public void setScheduledExecutor(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutor = scheduledExecutorService;
    }
}

