/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.authentication.core;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import redis.clients.authentication.core.AuthXException;
import redis.clients.authentication.core.Dispatcher;
import redis.clients.authentication.core.IdentityProvider;
import redis.clients.authentication.core.RenewalScheduler;
import redis.clients.authentication.core.RenewalTask;
import redis.clients.authentication.core.Token;
import redis.clients.authentication.core.TokenListener;
import redis.clients.authentication.core.TokenManagerConfig;
import redis.clients.authentication.core.TokenRequestException;

public class TokenManager {
    private TokenManagerConfig tokenManagerConfig;
    private TokenListener listener;
    private boolean stopped = false;
    private AtomicInteger numberOfRetries = new AtomicInteger(0);
    private Token currentToken = null;
    private AtomicBoolean started = new AtomicBoolean(false);
    private Dispatcher dispatcher;
    private RenewalScheduler renewalScheduler;
    private int retryDelay;
    private int maxRetries;

    public TokenManager(IdentityProvider identityProvider, TokenManagerConfig tokenManagerConfig) {
        this.tokenManagerConfig = tokenManagerConfig;
        this.maxRetries = tokenManagerConfig.getRetryPolicy().getMaxAttempts();
        this.retryDelay = tokenManagerConfig.getRetryPolicy().getdelayInMs();
        this.renewalScheduler = new RenewalScheduler(this::renewToken);
        this.dispatcher = new Dispatcher(identityProvider, tokenManagerConfig.getTokenRequestExecTimeoutInMs());
    }

    public void start(TokenListener listener, boolean blockForInitialToken) {
        if (!this.started.compareAndSet(false, true)) {
            throw new AuthXException("Token manager already started!");
        }
        this.listener = listener;
        RenewalTask currentTask = this.renewalScheduler.scheduleNext(0L);
        if (blockForInitialToken) {
            try {
                this.renewalScheduler.waitFor(currentTask);
            }
            catch (Exception e) {
                throw this.prepareToPropogate(e);
            }
        }
    }

    protected Token renewToken() {
        if (this.stopped) {
            return null;
        }
        Token newToken = null;
        try {
            this.currentToken = newToken = this.dispatcher.requestTokenAsync().getResult();
            long delay = this.calculateRenewalDelay(newToken.getExpiresAt(), newToken.getReceivedAt());
            this.renewalScheduler.scheduleNext(delay);
            this.listener.onTokenRenewed(newToken);
            return newToken;
        }
        catch (Exception e) {
            if (this.numberOfRetries.getAndIncrement() >= this.maxRetries) {
                RuntimeException propogateExc = this.prepareToPropogate(e);
                this.listener.onError(propogateExc);
                throw propogateExc;
            }
            this.renewalScheduler.scheduleNext(this.retryDelay);
            return null;
        }
    }

    private RuntimeException prepareToPropogate(Exception e) {
        Throwable unwrapped = e;
        if (unwrapped instanceof ExecutionException) {
            unwrapped = e.getCause();
        }
        if (unwrapped instanceof TokenRequestException) {
            return (RuntimeException)unwrapped;
        }
        return new TokenRequestException(unwrapped, this.dispatcher.getError());
    }

    public TokenManagerConfig getConfig() {
        return this.tokenManagerConfig;
    }

    public Token getCurrentToken() {
        return this.currentToken;
    }

    public void stop() {
        this.stopped = true;
        this.renewalScheduler.stop();
        this.dispatcher.stop();
    }

    public long calculateRenewalDelay(long expireDate, long issueDate) {
        long ttlRatioRefresh;
        long ttlLowerRefresh = this.ttlForLowerRefresh(expireDate);
        long delay = Math.min(ttlLowerRefresh, ttlRatioRefresh = this.ttlForRatioRefresh(expireDate, issueDate));
        return delay < 0L ? 0L : delay;
    }

    protected long ttlForLowerRefresh(long expireDate) {
        long startOfRenewalZone = expireDate - (long)this.tokenManagerConfig.getLowerRefreshBoundMillis();
        return startOfRenewalZone - System.currentTimeMillis();
    }

    protected long ttlForRatioRefresh(long expireDate, long issueDate) {
        long totalLifetime = expireDate - issueDate;
        long intendedUsageDuration = (long)((float)totalLifetime * this.tokenManagerConfig.getExpirationRefreshRatio());
        long startOfRenewalZone = issueDate + intendedUsageDuration;
        return startOfRenewalZone - System.currentTimeMillis();
    }
}

