/*
 * Decompiled with CFR 0.152.
 */
package org.vinniks.parsla.syntaxtree;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import org.vinniks.parsla.exception.SyntaxTreeException;
import org.vinniks.parsla.parser.ParserOutputListener;
import org.vinniks.parsla.syntaxtree.SyntaxTreeNode;

public class SyntaxTreeBuilder<P>
implements ParserOutputListener<P> {
    private final Deque<SyntaxTreeNode<P>> nodeStack = new ArrayDeque<SyntaxTreeNode<P>>();

    @Override
    public void enter(P position, String value) {
        SyntaxTreeNode<P> node = new SyntaxTreeNode<P>(position, value, new ArrayList());
        this.addChild(node);
        this.nodeStack.push(node);
    }

    @Override
    public void exit() {
        if (this.nodeStack.isEmpty()) {
            throw new SyntaxTreeException("failed to exit syntax tree top");
        }
        this.nodeStack.pop();
    }

    @Override
    public void tap(P position, String value) {
        this.addChild(new SyntaxTreeNode<P>(position, value, Collections.emptyList()));
    }

    private void addChild(SyntaxTreeNode<P> node) {
        if (!this.nodeStack.isEmpty()) {
            this.nodeStack.getFirst().children().add(node);
        }
    }

    public SyntaxTreeNode<P> build() {
        return this.nodeStack.getFirst();
    }
}

