/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class OutOperation
implements AggregationOperation {
    @Nullable
    private final String databaseName;
    private final String collectionName;
    @Nullable
    private final Document uniqueKey;
    @Nullable
    private final OutMode mode;

    public OutOperation(String outCollectionName) {
        this(null, outCollectionName, null, null);
    }

    private OutOperation(@Nullable String databaseName, String collectionName, @Nullable Document uniqueKey, @Nullable OutMode mode) {
        Assert.notNull((Object)collectionName, (String)"Collection name must not be null");
        this.databaseName = databaseName;
        this.collectionName = collectionName;
        this.uniqueKey = uniqueKey;
        this.mode = mode;
    }

    public OutOperation in(@Nullable String database) {
        return new OutOperation(database, this.collectionName, this.uniqueKey, this.mode);
    }

    @Deprecated(since="4.3.13")
    public OutOperation uniqueKey(@Nullable String key) {
        Document uniqueKey = key == null ? null : BsonUtils.toDocumentOrElse(key, it -> new Document(it, (Object)1));
        return new OutOperation(this.databaseName, this.collectionName, uniqueKey, this.mode);
    }

    @Deprecated(since="4.3.13")
    public OutOperation uniqueKeyOf(Iterable<String> fields) {
        Assert.notNull(fields, (String)"Fields must not be null");
        Document uniqueKey = new Document();
        fields.forEach(it -> uniqueKey.append(it, (Object)1));
        return new OutOperation(this.databaseName, this.collectionName, uniqueKey, this.mode);
    }

    @Deprecated(since="4.3.13")
    public OutOperation mode(OutMode mode) {
        Assert.notNull((Object)((Object)mode), (String)"Mode must not be null");
        return new OutOperation(this.databaseName, this.collectionName, this.uniqueKey, mode);
    }

    @Deprecated(since="4.3.13")
    public OutOperation replaceCollection() {
        return this.mode(OutMode.REPLACE_COLLECTION);
    }

    @Deprecated(since="4.3.13")
    public OutOperation replaceDocuments() {
        return this.mode(OutMode.REPLACE);
    }

    @Deprecated(since="4.3.13")
    public OutOperation insertDocuments() {
        return this.mode(OutMode.INSERT);
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        if (!this.requiresExtendedFormat()) {
            if (!StringUtils.hasText((String)this.databaseName)) {
                return new Document(this.getOperator(), (Object)this.collectionName);
            }
            return new Document(this.getOperator(), (Object)new Document("db", (Object)this.databaseName).append("coll", (Object)this.collectionName));
        }
        Assert.state((this.mode != null ? 1 : 0) != 0, (String)"Mode must not be null");
        Document $out = new Document("to", (Object)this.collectionName).append("mode", (Object)this.mode.getMongoMode());
        if (StringUtils.hasText((String)this.databaseName)) {
            $out.append("db", (Object)this.databaseName);
        }
        if (this.uniqueKey != null) {
            $out.append("uniqueKey", (Object)this.uniqueKey);
        }
        return new Document(this.getOperator(), (Object)$out);
    }

    @Override
    public String getOperator() {
        return "$out";
    }

    private boolean requiresExtendedFormat() {
        return this.mode != null || this.uniqueKey != null;
    }

    @Deprecated(since="4.3.13")
    public static enum OutMode {
        INSERT("insertDocuments"),
        REPLACE("replaceDocuments"),
        REPLACE_COLLECTION("replaceCollection");

        private final String mode;

        private OutMode(String mode) {
            this.mode = mode;
        }

        public String getMongoMode() {
            return this.mode;
        }
    }
}

