/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.CollationUtils;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.ExpressionParser;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class QueryUtils {
    protected static final Log LOGGER = LogFactory.getLog(QueryUtils.class);

    public static Query decorateSort(Query query, Document defaultSort) {
        if (defaultSort.isEmpty()) {
            return query;
        }
        ProxyFactory factory = QueryUtils.prepareQueryProxy(query.getClass(), defaultSort);
        factory.setTarget((Object)query);
        return (Query)factory.getProxy(query.getClass().getClassLoader());
    }

    public static Class<?> queryProxyType(Class<? extends Query> baseType, ClassLoader classLoader) {
        return QueryUtils.prepareQueryProxy(baseType, new Document()).getProxyClass(classLoader);
    }

    static Query applyCollation(Query query, @Nullable String collationExpression, ConvertingParameterAccessor accessor, MongoParameters parameters, ExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        Collation collation = CollationUtils.computeCollation(collationExpression, accessor, parameters, expressionParser, evaluationContextProvider);
        return collation == null ? query : query.collation(collation);
    }

    static int indexOfAssignableParameter(Class<?> type, Class<?>[] parameters) {
        return QueryUtils.indexOfAssignableParameter(type, Arrays.asList(parameters));
    }

    static int indexOfAssignableParameter(Class<?> type, List<Class<?>> parameters) {
        if (parameters.isEmpty()) {
            return -1;
        }
        int i = 0;
        for (Class<?> parameterType : parameters) {
            if (ClassUtils.isAssignable(type, parameterType)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static ProxyFactory prepareQueryProxy(Class<? extends Query> query, Document defaultSort) {
        ProxyFactory factory = new ProxyFactory();
        factory.setTargetClass(query);
        factory.addAdvice((Advice)new DefaultSortingInterceptor(defaultSort));
        factory.setInterfaces(new Class[0]);
        return factory;
    }

    static class DefaultSortingInterceptor
    implements MethodInterceptor {
        private final Document defaultSort;

        public DefaultSortingInterceptor(Document defaultSort) {
            this.defaultSort = defaultSort;
        }

        @Nullable
        public Object invoke(@NonNull MethodInvocation invocation) throws Throwable {
            if (invocation.getMethod().getName().equals("isSorted")) {
                if (!this.defaultSort.isEmpty()) {
                    return true;
                }
                return invocation.proceed();
            }
            if (!invocation.getMethod().getName().equals("getSortObject")) {
                return invocation.proceed();
            }
            Document combinedSort = new Document((Map)this.defaultSort);
            combinedSort.putAll((Map)((Document)invocation.proceed()));
            return combinedSort;
        }
    }
}

