/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4;

import com.axlradius.radclient4.ClientReceiveException;
import com.axlradius.radclient4.ClientSendException;
import com.axlradius.radclient4.PacketType;
import com.axlradius.radclient4.RADIUSException;
import com.axlradius.radclient4.RetransmissionContext;
import com.axlradius.radclient4.TimeoutContext;
import com.axlradius.radclient4.attributes.Attribute;
import com.axlradius.radclient4.attributes.AttributeList;
import com.axlradius.radclient4.attributes.VendorSpecific;
import com.axlradius.radclient4.auth.eap.tls.c;
import com.axlradius.radclient4.auth.mschap.MPPEClient;
import com.axlradius.radclient4.auth.mschap.MSChap;
import com.axlradius.radclient4.auth.mschap.MSChapV2;
import com.axlradius.radclient4.b;
import com.axlradius.radclient4.dictionary.BD;
import com.axlradius.radclient4.dictionary.RADIUSDictionary;
import com.axlradius.radclient4.interimaccounting.InterimAccountingCallback;
import com.axlradius.radclient4.radutil.RADIUSEncode;
import com.axlradius.radclient4.radutil.Rand;
import com.axlradius.radclient4.radutil.Util;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class RADIUSClient {
    public static final String Version = "4.08b";
    public static final int AUTH_PORT = 1812;
    public static final int ALT_AUTH_PORT = 1645;
    public static final int ACCT_PORT = 1813;
    public static final int ALT_ACCT_PORT = 1646;
    public static final int DMCOA_PORT = 3799;
    public static final int MAX_PACKET_SIZE = 4096;
    public static final long EVENT_TIMESTAMP_WINDOW = 300000L;
    public static final int Access_Request = 1;
    public static final int Access_Accept = 2;
    public static final int Access_Reject = 3;
    public static final int Access_Challenge = 11;
    public static final int Disconnect_Request = 40;
    public static final int Disconnect_ACK = 41;
    public static final int Disconnect_NAK = 42;
    public static final int CoA_Request = 43;
    public static final int CoA_ACK = 44;
    public static final int CoA_NAK = 45;
    public static final int Status_Server = 12;
    public static final int BadPacket = 0;
    public static final int Accounting_Request = 4;
    public static final int Accounting_Response = 5;
    private static final byte[] g = new byte[16];
    public static final int ACCT_INTERIM_INTERVAL_DEFAULT = 600;
    public static final int ACCT_INTERIM_INTERVAL_MINIMUM = 60;
    private int m;
    private InetAddress a;
    private DatagramSocket a;
    private byte[] h;
    private int n;
    private byte[] i;
    private int o;
    private byte[] j;
    private int p;
    private AttributeList a;
    private int q = 0;
    private com.axlradius.radclient4.radutil.a a;
    private int r = 4096;
    private b a;
    private RetransmissionContext a;
    private com.axlradius.radclient4.interimaccounting.a a;
    private boolean b;
    private int s;
    private long c;
    private long d;
    private int t;
    private boolean c = false;
    private InetAddress b = false;
    private boolean debug = false;
    private Writer a;
    private ERROR a;
    private static int e;
    private HashMap<Integer, byte[]> a;
    private int u;
    private com.axlradius.misc.a a;
    private byte a;
    private byte[] k;
    private byte[] l;
    private boolean d = true;

    public RADIUSClient(String object, int n2, byte[] byArray, RetransmissionContext retransmissionContext) throws SocketException, UnknownHostException {
        this.a = ERROR.NONE;
        object = InetAddress.getByName((String)object);
        this.a((InetAddress)object, n2, byArray, retransmissionContext);
    }

    public RADIUSClient(InetAddress inetAddress, int n2, byte[] byArray, RetransmissionContext retransmissionContext) throws SocketException {
        this.a = ERROR.NONE;
        this.a(inetAddress, n2, byArray, retransmissionContext);
    }

    private void a(InetAddress inetAddress, int n2, byte[] byArray, RetransmissionContext retransmissionContext) throws SocketException {
        block2: {
            try {
                Rand.start();
            }
            catch (RADIUSException rADIUSException) {
                RADIUSException rADIUSException2 = rADIUSException;
                if (!rADIUSException.getMessage().contains("ERROR")) break block2;
                throw new SocketException(rADIUSException2.getMessage());
            }
        }
        this.a = inetAddress;
        this.m = n2;
        this.a = new com.axlradius.radclient4.radutil.a(byArray);
        this.a = new DatagramSocket();
        this.a.setSoTimeout(2000);
        this.a = retransmissionContext.a();
        this.a = this.a.a(this.a);
        this.o = this.i();
        this.i = this.d();
        this.a = new AttributeList();
        this.s = com.axlradius.radclient4.RADIUSClient$a.x;
    }

    public final void reset() throws SocketException {
        this.o = this.i();
        if (this.i != null) {
            Util.clean(this.i);
        }
        this.i = this.d();
        if (this.s != com.axlradius.radclient4.RADIUSClient$a.v && this.s != com.axlradius.radclient4.RADIUSClient$a.w) {
            this.a.reset();
        }
        if (this.c) {
            this.bind();
            return;
        }
        if (this.t != 0) {
            ++this.t;
            this.bind();
        } else {
            DatagramSocket datagramSocket = this.a;
            this.a = new DatagramSocket();
            this.a.setSoTimeout(2000);
            if (datagramSocket != null) {
                datagramSocket.close();
            }
        }
        ERROR.NONE.clear();
    }

    public final void setEventTimestampWindow(long l2) {
        this.c = l2;
        if (this.c <= 0L) {
            this.c = 300000L;
        }
    }

    public final long getEventTimestampWindow() {
        return this.c;
    }

    public final void setInterimAccountingCallback(InterimAccountingCallback interimAccountingCallback, int n2, boolean bl) throws SocketException, UnknownHostException, IllegalArgumentException {
        if (interimAccountingCallback == null) {
            return;
        }
        this.a = new com.axlradius.radclient4.interimaccounting.a(this.a, this.m, this.a, n2, bl, interimAccountingCallback, this);
    }

    public final void bind(String string) throws SocketException, UnknownHostException {
        this.b = InetAddress.getByName(string);
        this.bind();
    }

    public final void bind(InetAddress inetAddress) throws SocketException {
        this.b = inetAddress;
        this.bind();
    }

    public final void bind(InetAddress inetAddress, int n2) throws SocketException {
        this.b = inetAddress;
        this.t = n2;
        this.c = true;
        this.bind();
    }

    private void bind() throws SocketException {
        if (this.c) {
            if (this.a == null || this.a.getLocalPort() != 3799) {
                if (this.a != null) {
                    this.a.close();
                }
                this.a = new DatagramSocket(this.t, this.b);
                if (this.s == com.axlradius.radclient4.RADIUSClient$a.x) {
                    this.a.reset();
                }
            }
            return;
        }
        int n2 = 0;
        if (this.t == 0) {
            this.t = 2048;
        }
        if (this.a != null) {
            this.a.close();
        }
        while (this.t < 65536) {
            try {
                this.a = new DatagramSocket(this.t, this.b);
                break;
            }
            catch (SocketException socketException) {
                if (this.t >= 65535) {
                    if (++n2 >= 2) {
                        throw new SocketException("Can't find a suitable port to open.");
                    }
                    this.t = 2048;
                }
                ++this.t;
            }
        }
        if (this.s == com.axlradius.radclient4.RADIUSClient$a.x) {
            this.a.reset();
        }
    }

    public final void setMessageAuthenticator(boolean bl) {
        this.d = bl;
    }

    public final void setDebug(boolean bl, String string) throws IOException {
        this.debug = bl;
        this.a = string == null ? new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, "UTF8")) : new BufferedWriter(new FileWriter(string));
        if (bl) {
            new BD();
        }
    }

    public final boolean setDebug(boolean bl) {
        try {
            this.setDebug(bl, null);
        }
        catch (IOException iOException) {
            System.err.println("Can't write to stdout");
            return false;
        }
        return true;
    }

    public final void setDebugWriter(boolean bl, Writer writer) {
        this.debug = bl;
        this.a = writer;
    }

    public final void logToDebug(String string, Exception exception) {
        if (this.a != null) {
            try {
                this.a.write(string, 0, string.length());
                this.a.write(10);
                PrintWriter printWriter = new PrintWriter(this.a);
                exception.printStackTrace(printWriter);
                printWriter.flush();
                this.a.flush();
                return;
            }
            catch (IOException iOException) {
                System.out.print(string);
                return;
            }
        }
        System.out.println(string);
        exception.printStackTrace();
    }

    public final int authenticate(AttributeList attributeList) throws ClientSendException, ClientReceiveException {
        return this.authenticate(1, attributeList);
    }

    public final int authenticate(int n2, AttributeList attributeList) throws ClientSendException, ClientReceiveException {
        int n3;
        block4: {
            this.s = com.axlradius.radclient4.RADIUSClient$a.x;
            n3 = 0;
            try {
                this.a = new AttributeList(attributeList);
                this.a(n2, 1);
                n3 = this.h();
            }
            catch (ClientReceiveException clientReceiveException) {
                if (!this.a.c() || this.a.getCount() <= 0) break block4;
                try {
                    n3 = this.retry();
                }
                catch (ClientReceiveException clientReceiveException2) {}
            }
        }
        return n3;
    }

    public final int sendRawPacket(byte[] byArray) throws ClientSendException, ClientReceiveException, SocketException {
        if (byArray.length < 36 || byArray.length > this.r) {
            this.a = ERROR.PACKET_SIZE;
            return 0;
        }
        this.i = new byte[16];
        System.arraycopy(byArray, 4, this.i, 0, 16);
        this.d(byArray);
        return this.h();
    }

    public final int accounting(AttributeList attributeList) throws ClientSendException, ClientReceiveException {
        this.s = com.axlradius.radclient4.RADIUSClient$a.w;
        return this.accounting(4, attributeList);
    }

    public final int accounting(int n2, AttributeList attributeList) throws ClientSendException, ClientReceiveException {
        int n3;
        block11: {
            this.a = new AttributeList(attributeList);
            this.i = g;
            if (n2 == 4) {
                if (!attributeList.contains(40)) {
                    throw new ClientSendException("Missing required Acct-Status-Type attribute");
                }
                switch (attributeList.getInt(40)) {
                    case 1: 
                    case 2: {
                        this.logToDebug("Not checking for Acct-Session-Id,");
                        break;
                    }
                    default: {
                        this.logToDebug("Checking for Acct-Session-Id,");
                        if (attributeList.contains(44)) break;
                        throw new ClientSendException("Missing required Acct-Session-Id attribute");
                    }
                }
                if (this.a != null) {
                    this.a.b(attributeList);
                }
            }
            Util.clean(this.j);
            n3 = 0;
            try {
                this.a(n2, 2);
                n3 = this.h();
            }
            catch (ClientReceiveException clientReceiveException) {
                if (!this.a.c()) break block11;
                if (this.a.getCount() > 0) {
                    try {
                        n3 = this.g();
                    }
                    catch (ClientReceiveException clientReceiveException2) {}
                }
                new StringBuilder("Failed to receive accounting response after ").append(this.a.j()).append(" retries");
                this.a = ERROR.TIMEOUT;
                n3 = 0;
            }
        }
        return n3;
    }

    public final int dmcoa(int n2, AttributeList attributeList) throws ClientSendException, ClientReceiveException {
        this.s = com.axlradius.radclient4.RADIUSClient$a.v;
        return this.accounting(n2, attributeList);
    }

    public final int statusServer(AttributeList attributeList) throws ClientSendException, ClientReceiveException {
        attributeList = new AttributeList(attributeList);
        attributeList.add(80);
        return this.authenticate(12, attributeList);
    }

    public final int retry() throws ClientSendException, ClientReceiveException {
        if (this.j == null) {
            throw new ClientSendException("There is no packet to retry.");
        }
        this.a.c();
        while (this.a.getCount() > 0) {
            try {
                RADIUSClient rADIUSClient = this;
                rADIUSClient.d(rADIUSClient.j);
                return rADIUSClient.h();
            }
            catch (ClientReceiveException clientReceiveException) {
                if (!this.a.c()) {
                    return this.a.getCount();
                }
                this.a.c();
            }
        }
        throw new ClientReceiveException("Failed to receive authentication response after " + this.a.j() + " retries");
    }

    public final void enableAuthenticationTimeStamps(boolean bl) {
        this.b = bl;
    }

    public final boolean enableAuthenticationTimeStamps() {
        return this.b;
    }

    public final void setTimeout(int n2, int n3, int n4, int n5, int n6) {
        this.a = new RetransmissionContext(n2, n3, n4, n5, n6);
    }

    public final void setFixedTimeout(int n2, int n3) {
        this.a = TimeoutContext.FIXEDTIMEOUT.getContext();
        this.a = this.a.a(this.a);
        this.a = new b(n2, n2, Integer.MAX_VALUE, 10, n3);
    }

    public final byte[] getRawPacket() {
        if (this.j == null) {
            return new byte[0];
        }
        byte[] byArray = new byte[this.j.length];
        System.arraycopy(this.j, 0, byArray, 0, byArray.length);
        return byArray;
    }

    private int g() throws ClientSendException, ClientReceiveException {
        if (this.j == null) {
            throw new ClientSendException("Accounting retry failed: There is no accounting packet to retry.");
        }
        this.s = com.axlradius.radclient4.RADIUSClient$a.v;
        switch (this.p) {
            case 4: 
            case 40: 
            case 43: {
                break;
            }
            default: {
                throw new ClientSendException("Accounting retry failed: The request packet is not an accounting packet.");
            }
        }
        AttributeList attributeList = new AttributeList();
        try {
            attributeList.loadRadiusAttributes(this.j, 20, this.j.length - 20);
        }
        catch (RADIUSException rADIUSException) {
            throw new ClientSendException("Error loading RADIUS attributes - " + rADIUSException.getMessage());
        }
        this.a(this.p, attributeList);
        try {
            this.reset();
        }
        catch (Exception exception) {
            throw new ClientSendException("Error resetting - " + exception.getMessage());
        }
        return this.accounting(this.p, attributeList);
    }

    public final void setMaximumPacketSize(int n2) {
        this.r = n2;
    }

    public final int getMaximumPacketSize() {
        return this.r;
    }

    public final AttributeList getAttributes() {
        if (this.a == null) {
            return this.getRequestAttributes();
        }
        return this.a;
    }

    public final AttributeList getRequestAttributes() {
        AttributeList attributeList = new AttributeList();
        try {
            if (this.j != null) {
                attributeList.loadRadiusAttributes(this.j, 20, this.j.length - 20);
            }
        }
        catch (RADIUSException rADIUSException) {}
        return attributeList;
    }

    public final void clean() {
        Util.clean(this.h);
        Util.clean(this.i);
        Util.clean(this.j);
        if (this.a != null) {
            this.a.clean();
        }
        this.a = null;
        Util.clean(this.k);
        Util.clean(this.l);
        this.u = 0;
        this.p = 0;
        this.o = 0;
        this.n = 0;
        this.q = 0;
        this.t = 0;
        this.a = 0;
        if (this.a != null) {
            this.a.clear();
        }
        if (this.a != null) {
            ((HashMap)((Object)this.a)).clear();
        }
        if (this.a != null) {
            this.a.clear();
        }
        if (this.a != null) {
            this.a.clear();
        }
        if (this.a != null) {
            this.a.close();
        }
        ERROR.NONE.clear();
    }

    public final void close() {
        this.a.close();
        this.a = null;
        this.a = null;
        this.s = com.axlradius.radclient4.RADIUSClient$a.x;
        Rand.updateRandomFile();
        this.clean();
    }

    public final byte[] getAuthenticator() {
        byte[] byArray = new byte[16];
        System.arraycopy(this.i, 0, byArray, 0, 16);
        return byArray;
    }

    public final void createCHAP(byte[] byArray, AttributeList attributeList) {
        MessageDigest messageDigest = com.axlradius.radclient4.auth.eap.tls.c.d();
        byte[] byArray2 = this.createChallenge(16);
        attributeList.add(60, byArray2);
        byte[] byArray3 = new byte[17];
        byte[] byArray4 = byArray3;
        byArray3[0] = Rand.nextByte();
        messageDigest.reset();
        messageDigest.update(byArray4, 0, 1);
        messageDigest.update(byArray);
        messageDigest.update(byArray2);
        System.arraycopy(messageDigest.digest(), 0, byArray4, 1, 16);
        attributeList.add(3, byArray4);
    }

    public final void createPAP(byte[] byArray, AttributeList attributeList) {
        this.a.deleteAll(2);
        attributeList.deleteAll(2);
        byte[] byArray2 = this.getSecret();
        byArray = RADIUSEncode.encodePAPPassword(byArray, byArray2, this.i);
        Util.clean(byArray2);
        attributeList.add(2, byArray);
    }

    public final void createMSCHAP(byte[] byArray, AttributeList attributeList) throws RADIUSException {
        MSChap mSChap;
        try {
            mSChap = new MSChap();
        }
        catch (RADIUSException rADIUSException) {
            this.a = ERROR.DES;
            this.a.a("DES encoding has a problem - " + rADIUSException.getMessage());
            throw rADIUSException;
        }
        byte[] byArray2 = MSChap.createChallenge();
        VendorSpecific vendorSpecific = new VendorSpecific(311);
        vendorSpecific.add(11, byArray2);
        attributeList.add(vendorSpecific.getAttribute());
        vendorSpecific = new VendorSpecific(311);
        byte[] byArray3 = new byte[50];
        byArray3[0] = this.a = mSChap.getIdent(this.a);
        byArray3[1] = 1;
        byArray = mSChap.NtChallengeResponse(byArray2, byArray, MSChap.PasswordType.PLAINTEXT);
        System.arraycopy(byArray, 0, byArray3, 26, byArray.length);
        vendorSpecific.add(1, byArray3);
        attributeList.add(vendorSpecific.getAttribute());
    }

    public final MPPEClient getMSCHAPMPPE(boolean bl) {
        MPPEClient mPPEClient = new MPPEClient();
        mPPEClient.extract(this.getAttributes(), this.getSecret(), this.getAuthenticator());
        return mPPEClient;
    }

    public final void createMSCHAP2(byte[] object, byte[] byArray, AttributeList attributeList) throws RADIUSException {
        MSChapV2 mSChapV2 = new MSChapV2();
        this.k = MSChapV2.createChallenge();
        this.l = MSChapV2.createChallenge();
        byte[] byArray2 = new byte[((byte[])object).length];
        System.arraycopy(object, 0, byArray2, 0, ((byte[])object).length);
        if (this.getDebugIndicator()) {
            this.logToDebug("MSChapV2 Peer challenge: " + Util.toHexString(this.k));
            this.logToDebug("MSChapV2 Authenticator challenge: " + Util.toHexString(this.l));
        }
        VendorSpecific vendorSpecific = new VendorSpecific(311);
        object = vendorSpecific;
        vendorSpecific.add(11, this.l);
        attributeList.add(((VendorSpecific)object).getAttribute());
        object = new VendorSpecific(311);
        byte[] byArray3 = new byte[50];
        byArray3[0] = this.a = mSChapV2.getIdent(this.a);
        System.arraycopy(this.k, 0, byArray3, 2, this.k.length);
        byArray = mSChapV2.GenerateNTResponse(this.l, this.k, byArray2, byArray, MSChap.PasswordType.PLAINTEXT);
        if (this.getDebugIndicator()) {
            this.logToDebug("MSChap V2 NT Response: " + Util.toHexString(byArray));
        }
        System.arraycopy(byArray, 0, byArray3, 26, byArray.length);
        ((AttributeList)object).add(25, byArray3);
        attributeList.add(((VendorSpecific)object).getAttribute());
    }

    public final boolean cmpMSCHAP2(byte[] object, byte[] byArray, AttributeList attributeArray) throws RADIUSException {
        MSChapV2 mSChapV2;
        attributeArray = this.getAttributes();
        byte[] byArray2 = new byte[((byte[])object).length];
        System.arraycopy(object, 0, byArray2, 0, ((byte[])object).length);
        Attribute[] attributeArray2 = attributeArray.getVendorSpecific(311, 2);
        object = attributeArray2;
        if (attributeArray2.length > 0) {
            if (((byte[])(object = object[0].getData())).length < 2) {
                if (this.debug) {
                    object = "MS-CHAP-Error attribute value is too small (" + ((byte[])object).length + ")";
                    this.a((String)object, null);
                }
                Util.clean(byArray2);
                return false;
            }
            byte by = object[0];
            if (!this.d(by)) {
                Util.clean(byArray2);
                return false;
            }
            if (this.debug) {
                object = "MSCHAP2 MS-CHAP-Error found " + new String((byte[])object, 1, ((byte[])object).length - 2);
                this.a((String)object, null);
            }
            Util.clean(byArray2);
            return false;
        }
        if ((attributeArray = attributeArray.getVendorSpecific(311, 26)).length == 0) {
            if (this.debug) {
                object = "MSCHAPV2: missing MS-CHAP2-Success attribute from response";
                this.a((String)object, null);
            }
            Util.clean(byArray2);
            return false;
        }
        object = attributeArray[0].getData();
        if (((byte[])object).length != 43) {
            if (this.debug) {
                object = "MS-CHAP2-Success attribute is not the expected length of 43, but " + ((byte[])object).length;
                this.a((String)object, null);
            }
            Util.clean(byArray2);
            return false;
        }
        byte by = object[0];
        if (!this.d(by)) {
            Util.clean(byArray2);
            return false;
        }
        try {
            mSChapV2 = new MSChapV2();
        }
        catch (RADIUSException rADIUSException) {
            Util.clean(byArray2);
            this.a = ERROR.DES;
            this.a.a("DES encoding has a problem - " + rADIUSException.getMessage());
            throw rADIUSException;
        }
        byte[] byArray3 = mSChapV2.GenerateNTResponse(this.l, this.k, byArray2, byArray, MSChap.PasswordType.PLAINTEXT);
        byte[] byArray4 = new byte[42];
        System.arraycopy(object, 1, byArray4, 0, 42);
        if (!mSChapV2.CheckAuthenticatorResponse(byArray, MSChap.PasswordType.PLAINTEXT, byArray3, this.k, this.l, byArray2, byArray4)) {
            if (this.debug) {
                object = "MS-CHAP2: Authenticator response in MS_CHAP2_Success attribute doesn't match regenerated response.";
                this.a((String)object, null);
            }
            Util.clean(byArray2);
            return false;
        }
        return true;
    }

    private boolean d(byte by) {
        if (by != this.a) {
            if (this.debug) {
                String string = "MSCHAP2 Identifier is " + by + " expecting " + this.a;
                this.a(string, null);
            }
            return false;
        }
        return true;
    }

    public final void addDictionary(RADIUSDictionary rADIUSDictionary) {
        BD.addDictionary(rADIUSDictionary);
    }

    public final String toString() {
        return "Radius Client connected to " + this.a + ":" + this.m + " Local Port: " + this.a.getLocalPort();
    }

    public final int getRequestPacketId() {
        return this.o;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(int n2, int n3) throws ClientSendException {
        int n4;
        int n5;
        int n6;
        Object object;
        int n7;
        block32: {
            AttributeList attributeList = this.a;
            n7 = attributeList.size();
            int n8 = 0;
            while (n8 < n7) {
                object = attributeList.getAttributeAt(n8);
                n6 = ((Attribute)object).getDataLength();
                switch (BD.getDataType(((Attribute)object).getTag())) {
                    case 0: 
                    case 2: 
                    case 4: 
                    case 8192: 
                    case 65536: {
                        break;
                    }
                    case 512: {
                        if (n6 == 6) break;
                        n5 = n8;
                        break block32;
                    }
                    case 1024: {
                        if (n6 == 18) break;
                        n5 = n8;
                        break block32;
                    }
                    case 16384: {
                        if (n6 == 1) break;
                        n5 = n8;
                        break block32;
                    }
                    case 131072: {
                        if (n6 == 4 && n6 == 6) break;
                        n5 = n8;
                        break block32;
                    }
                    case 1: 
                    case 8: 
                    case 16: 
                    case 524288: {
                        if (n6 == 4) break;
                        n5 = n8;
                        break block32;
                    }
                    case 32768: {
                        if (n6 == 2) break;
                        n5 = n8;
                        break block32;
                    }
                    case 2048: {
                        if (n6 == 6) break;
                        n5 = n8;
                        break block32;
                    }
                    case 4096: {
                        if (n6 == 8) break;
                        n5 = n8;
                        break block32;
                    }
                }
                ++n8;
            }
            n5 = n4 = -1;
        }
        if (n5 >= 0) {
            throw new ClientSendException("Invalid Attribute data for: " + this.a.getAttributeAt(n4));
        }
        this.u = 0;
        if (n3 == 2) {
            this.a(n2, this.a);
        }
        this.p = n2;
        if (n3 == 1) {
            if (this.m == 0) {
                this.m = 1812;
            }
            if (this.d || this.a.contains(80) || this.a.contains(79)) {
                this.a.deleteAll(80);
                this.a.add(80, new byte[16]);
            }
        } else {
            if (n3 != 2) {
                throw new ClientSendException("Unknown authORacct value: " + n3);
            }
            if (this.p == 1 && this.m == 0) {
                this.m = 1813;
            }
            if ((this.p == 40 || this.p == 43) && this.m == 0) {
                this.m = 3799;
            }
        }
        byte[] byArray = this.a.createRadiusAttributeBlock();
        n7 = 20 + byArray.length;
        byte[] byArray2 = new byte[n7];
        object = new byte[n7];
        object = new DatagramPacket((byte[])object, n7);
        byArray2[0] = (byte)n2;
        byArray2[1] = (byte)this.o;
        byArray2[2] = (byte)(n7 >> 8);
        byArray2[3] = (byte)n7;
        System.arraycopy(this.i, 0, byArray2, 4, 16);
        System.arraycopy(byArray, 0, byArray2, 20, byArray.length);
        int n9 = 20 + byArray.length;
        if (n3 == 1 && this.a.contains(80)) {
            Object object2 = com.axlradius.radclient4.auth.eap.tls.c.b();
            byte[] byArray3 = this.getSecret();
            try {
                ((Mac)object2).init(new SecretKeySpec(byArray3, "NONE"));
            }
            catch (InvalidKeyException invalidKeyException) {
                Util.clean(byArray3);
                throw new ClientSendException("Internal error creating Message-Authenticator: " + invalidKeyException.getMessage());
            }
            Util.clean(byArray3);
            object2 = ((Mac)object2).doFinal(byArray2);
            n6 = this.a.findPosition(80);
            System.arraycopy(object2, 0, byArray2, n6 + 20 + 1 + 1, 16);
            this.a.set(80, (byte[])object2);
        }
        if (n3 == 2) {
            Object object3 = com.axlradius.radclient4.auth.eap.tls.c.d();
            ((MessageDigest)object3).update(byArray2, 0, n9);
            byte[] byArray4 = this.a.getSecret();
            ((MessageDigest)object3).update(byArray4);
            Util.clean(byArray4);
            this.i = ((MessageDigest)object3).digest();
            System.arraycopy(this.i, 0, byArray2, 4, 16);
            if (this.a == null) {
                this.a = new HashMap();
            }
            object3 = new byte[16];
            System.arraycopy(this.i, 0, object3, 0, 16);
            ((HashMap)((Object)this.a)).put(this.o, object3);
        }
        ((DatagramPacket)object).setData(byArray2);
        ((DatagramPacket)object).setLength(n9);
        ((DatagramPacket)object).setPort(this.m);
        ((DatagramPacket)object).setAddress(this.a);
        if (this.debug) {
            this.a("Request Packet", this.o, n2, byArray2, n9, this.a, this.m);
        }
        this.j = byArray2;
        try {
            this.a = this.a.a(this.a);
            this.a.setSoTimeout(this.a.getTimeout());
            this.a.send((DatagramPacket)object);
        }
        catch (IOException iOException) {
            String string = "Packet Send Failed";
            if (this.debug) {
                this.a(string, iOException);
            }
            throw new ClientSendException(string);
        }
        if (n3 != 2) {
            this.d = Long.MAX_VALUE;
            return;
        }
        if (this.d == Long.MAX_VALUE) {
            this.d = System.currentTimeMillis();
        }
        e = e++ & 0x1F;
        Rand.add$fd0664a(e, com.axlradius.radclient4.a.B, this.d);
    }

    private void d(byte[] byArray) throws ClientSendException {
        if (byArray.length < 20) {
            throw new ClientSendException("Packet is too short.");
        }
        try {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
            datagramPacket.setPort(this.m);
            datagramPacket.setAddress(this.a);
            com.axlradius.misc.b b2 = new com.axlradius.misc.b(byArray, 0);
            int n2 = b2.readUnsignedByte();
            this.o = b2.readUnsignedByte();
            short s2 = b2.readShort();
            b2.a(16);
            if (this.debug) {
                int n3 = s2 - 20;
                if (b2.available() < n3) {
                    throw new ClientSendException("Packet is too short to contain Attributes.");
                }
                byte[] byArray2 = new byte[n3];
                b2.read(byArray2);
                this.a = new AttributeList();
                try {
                    this.a.loadRadiusAttributes(byArray2, 0, n3);
                }
                catch (RADIUSException rADIUSException) {
                    this.a("Error extracting attributes: ", rADIUSException);
                    return;
                }
                this.a("Request Packet", this.o, n2, byArray, s2, this.a, this.m);
            }
            this.j = byArray;
            this.a = this.a.a(this.a);
            this.a.setSoTimeout(this.a.getTimeout());
            this.a.send(datagramPacket);
            return;
        }
        catch (IOException iOException) {
            String string = "Packet Send Failed (" + iOException.getMessage() + ")";
            if (this.debug) {
                this.a(string, iOException);
            }
            throw new ClientSendException(string);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int h() throws ClientReceiveException {
        this.a = null;
        var1_1 = new byte[this.r];
        var1_1 = new DatagramPacket((byte[])var1_1, ((byte[])var1_1).length);
        try {
            this.a.receive((DatagramPacket)var1_1);
        }
        catch (IOException var2_4) {
            var3_9 = "Packet Receive Failed";
            if (this.debug) {
                this.a(var3_9, var2_4);
            }
            throw new ClientReceiveException(var3_9);
        }
        if (!this.a.equals(var1_1.getAddress())) {
            this.a = ERROR.WRONG_HOST;
            return 0;
        }
        this.h = var1_1.getData();
        this.n = var1_1.getLength();
        var2_5 = new com.axlradius.misc.b(this.h, 0);
        if (this.n < 20) {
            if (this.debug) {
                if (this.n > 2) {
                    this.u = var3_10 = var2_5.readUnsignedByte();
                    var4_13 = var2_5.readUnsignedByte();
                    this.a = new AttributeList();
                    this.a("Response Packet - Incomplete packet received", var4_13, var3_10, this.h, this.n, var1_1.getAddress(), var1_1.getPort());
                } else {
                    var3_11 = "Incomplete packet cannot be displayed (not enough information).";
                    this.logToDebug(var3_11);
                }
            }
            this.a = ERROR.PACKET_SIZE;
            return this.u;
        }
        this.u = var3_12 = var2_5.readUnsignedByte();
        var4_14 = var2_5.readUnsignedByte();
        var2_6 = var2_5.readUnsignedShort();
        if (var2_6 > this.n) {
            this.a = new AttributeList();
            this.a("Response Packet - Stated packet length is less than physical packet length", var4_14, var3_12, this.h, this.n, var1_1.getAddress(), var1_1.getPort());
            this.a = ERROR.PACKET_SIZE;
            return 0;
        }
        if (var3_12 == 0) {
            this.a = new AttributeList();
            this.a("Response Packet - Illegal packet code of 0.", var4_14, var3_12, this.h, this.n, var1_1.getAddress(), var1_1.getPort());
            this.a = ERROR.ILLEGAL_CODE;
            return 0;
        }
        this.n = var2_6;
        this.n = var2_6;
        var2_6 = this.o;
        if (var3_12 == 5) {
            var6_15 = var4_14;
            var5_18 = this;
            var5_18 = var5_18.a != null ? (byte[])var5_18.a.get(new Integer(var6_15)) : null;
            if ((byte[])var5_18 != null) {
                var2_6 = this.o;
                this.i = (byte[])var5_18;
            }
        }
        if (var2_6 != this.o) {
            if (this.debug) {
                this.a = new AttributeList();
                var5_18 = "Response Packet - Mismatched packet Id, found " + var4_14 + ", expecting " + this.o;
                this.a((String)var5_18, var4_14, var3_12, this.h, this.n, var1_1.getAddress(), var1_1.getPort());
            }
            this.a = ERROR.MISMATCHED_ID;
            return 0;
        }
        this.a = new AttributeList();
        try {
            this.a.loadRadiusAttributes(this.h, 20, this.n - 20);
        }
        catch (RADIUSException var5_19) {
            if (this.debug) {
                this.a = new AttributeList();
                this.a("Response Packet - Corrupt Attributes (" + var5_19.getMessage() + ")", var4_14, var3_12, this.h, this.n, var1_1.getAddress(), var1_1.getPort());
            }
            this.a = ERROR.CORRUPT;
            return 0;
        }
        switch (var3_12) {
            case 5: 
            case 41: 
            case 42: 
            case 44: 
            case 45: {
                var5_18 = this;
                var6_16 = com.axlradius.radclient4.auth.eap.tls.c.d();
                var6_16.update(var5_18.h, 0, 4);
                var6_16.update(var5_18.i);
                if (var5_18.n > 20) {
                    var6_16.update(var5_18.h, 20, var5_18.n - 20);
                }
                var2_7 = var5_18.getSecret();
                var6_16.update(var2_7);
                var7_20 = var6_16.digest();
                Util.clean(var2_7);
                if (Util.cmp(var7_20, 0, var5_18.h, 4, 16)) break;
                if (this.debug) {
                    this.a("Response Packet - Bad authenticator field", var4_14, var3_12, this.h, this.n, var1_1.getAddress(), var1_1.getPort());
                }
                this.a = ERROR.AUTHENTICATOR;
                return 0;
            }
            case 2: 
            case 3: 
            case 11: {
                if (this.b()) break;
                if (this.debug) {
                    this.a("Response Packet - Bad authenticator field", var4_14, var3_12, this.h, this.n, var1_1.getAddress(), var1_1.getPort());
                }
                this.a = ERROR.AUTHENTICATOR;
                return 0;
            }
        }
        if (!this.a(this.h, this.n, this.a)) {
            if (this.debug) {
                this.a("Response Packet - bad Message-Authenticator ", var4_14, var3_12, this.h, this.n, var1_1.getAddress(), var1_1.getPort());
            }
            this.a = ERROR.MESSAGE_AUTHENTICATOR;
            return 0;
        }
        if (this.debug) {
            this.a("Response Packet", var4_14, var3_12, this.h, this.n, var1_1.getAddress(), var1_1.getPort());
        }
        var6_17 = this.a;
        var5_18 = this;
        if (!var6_17.contains(55)) ** GOTO lbl-1000
        var7_21 = (long)var6_17.getAttribute(55).getInt() * 1000L;
        var9_22 = var5_18.c / 2L;
        var11_23 = System.currentTimeMillis();
        var13_24 = var11_23 - var9_22;
        var15_25 = var11_23 + var9_22;
        var1_2 = var7_21 < var13_24;
        v0 = var2_8 = var7_21 > var15_25;
        if (var5_18.debug) {
            var17_26 = Math.abs(var11_23 - var7_21);
            if (var1_2) {
                var5_18.logToDebug("Event-Timestamp value is invalid - too far in the past by " + Util.getTimeString(var17_26) + " allowed Event Timestamp Window is " + Util.getTimeString(var5_18.c));
            }
            if (var2_8) {
                var5_18.logToDebug("Event-Timestamp value is invalid - too far in the future by " + Util.getTimeString(var17_26) + " allowed Event Timestamp Window is " + Util.getTimeString(var5_18.c));
            }
        }
        if (var1_2 || var2_8) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        if (v1) {
            this.a = ERROR.EVENTTIMESTAMP;
            return 0;
        }
        var5_18 = this;
        if (var5_18.a.contains(79) && (var8_27 = var5_18.a.getAttribute(79).getData()).length > 1) {
            var5_18.q = var8_27[1] & 255;
        }
        if (this.a != null && this.u == 2 && this.a.contains(85)) {
            var1_3 = this.a.getInt(85);
            this.a.f(var1_3);
        }
        return this.u;
    }

    private boolean b() {
        Object object = com.axlradius.radclient4.auth.eap.tls.c.d();
        ((MessageDigest)object).update(this.h, 0, 4);
        ((MessageDigest)object).update(this.i);
        byte[] byArray = this.getSecret();
        ((MessageDigest)object).update(this.h, 20, this.n - 20);
        ((MessageDigest)object).update(byArray);
        object = ((MessageDigest)object).digest();
        Util.clean(byArray);
        if (this.n > 20 && this.h[0] == 3) {
            try {
                this.a = new AttributeList();
                this.a.loadRadiusAttributes(this.h, 20, this.n - 20);
            }
            catch (RADIUSException rADIUSException) {
                return false;
            }
        }
        e = e++ & 0x1F;
        Rand.add$15cbb015(e, com.axlradius.radclient4.a.y, (byte[])object);
        boolean bl = Util.cmp((byte[])object, 0, this.h, 4, 16);
        Util.clean((byte[])object);
        return bl;
    }

    public static boolean checkAuthenticator(byte[] byArray, int n2, byte[] byArray2, byte[] byArray3) {
        MessageDigest messageDigest = com.axlradius.radclient4.auth.eap.tls.c.d();
        messageDigest.update(byArray, 0, 4);
        messageDigest.update(byArray2);
        messageDigest.update(byArray, 20, n2 - 20);
        messageDigest.update(byArray3);
        byte[] byArray4 = messageDigest.digest();
        e = e++ & 0x1F;
        Rand.add$15cbb015(e, com.axlradius.radclient4.a.y, byArray4);
        boolean bl = Util.cmp(byArray4, 0, byArray, 4, 16);
        Util.clean(byArray4);
        return bl;
    }

    private boolean a(byte[] byArray, int n2, AttributeList attributeList) {
        int n3 = attributeList.findPosition(80);
        if (attributeList.findPosition(79) >= 0 && n3 < 0) {
            return false;
        }
        if (n3 < 0) {
            return true;
        }
        byte[] byArray2 = new byte[n2];
        try {
            System.arraycopy(byArray, 0, byArray2, 0, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
        boolean bl = false;
        for (n2 = 0; n2 < 2; ++n2) {
            try {
                if (n2 == 0) {
                    System.arraycopy(this.i, 0, byArray2, 4, 16);
                } else {
                    System.arraycopy(g, 0, byArray2, 4, 16);
                }
                System.arraycopy(g, 0, byArray2, n3 + 20 + 1 + 1, 16);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return false;
            }
            Object object = com.axlradius.radclient4.auth.eap.tls.c.b();
            byte[] byArray3 = this.getSecret();
            try {
                ((Mac)object).init(new SecretKeySpec(byArray3, "NONE"));
            }
            catch (InvalidKeyException invalidKeyException) {
                Util.clean(byArray3);
                return false;
            }
            Util.clean(byArray3);
            byArray3 = ((Mac)object).doFinal(byArray2);
            object = attributeList.getAttribute(80);
            if (object == null || ((Attribute)object).getDataLength() != 16) {
                Util.clean(byArray3);
                return false;
            }
            e = e++ & 0x1F;
            Rand.add$15cbb015(e, com.axlradius.radclient4.a.y, byArray3);
            bl = Util.cmp(byArray3, ((Attribute)object).getData());
            Util.clean(byArray3);
            if (bl) break;
        }
        return bl;
    }

    private byte[] d() {
        this.i = new byte[16];
        Rand.nextBytes(this.i);
        return this.i;
    }

    public final int getPacketType() {
        return this.u;
    }

    public final String getPacketTypeName() {
        return PacketType.getName(this.u);
    }

    public final String getPacketTypeName(int n2) {
        return PacketType.getName(n2);
    }

    public final byte[] getSecret() {
        return this.a.getSecret();
    }

    public final ERROR getError() {
        return this.a;
    }

    public final String getErrorString() {
        return this.a.toString();
    }

    public final String getErrorString(ERROR eRROR) {
        return eRROR.toString();
    }

    private void a(String string, int n2, int n3, byte[] byArray, int n4, InetAddress inetAddress, int n5) {
        String string2 = "<" + n2 + "> ";
        com.axlradius.misc.b b2 = new com.axlradius.misc.b(byArray);
        new PacketType();
        string = "\n" + string2 + "------------------- " + string + " -----------------\n" + string2 + "Address: " + inetAddress.getHostAddress() + ":" + n5 + " Packet Length: " + n4 + " Type: " + PacketType.getName(n3) + "\n" + b2.a(0, n4) + "\nAttributes:\n" + this.a + "\n" + string2 + "---------------------------------------------------\n";
        try {
            this.a.write(string, 0, string.length());
            this.a.flush();
            return;
        }
        catch (IOException iOException) {
            System.out.println(string);
            return;
        }
    }

    private void a(String string, Exception exception) {
        String string2 = "<" + this.getRequestPacketId() + "> ";
        string = "\n" + string2 + "-- " + string;
        if (exception != null) {
            string2 = "Z" + exception.getMessage();
            string = string2 != null && !string2.equals("") ? string + " (" + exception.getMessage() + ")" : string + " (" + exception.getClass().getName() + ")";
        }
        string = string + " ---\n";
        try {
            this.a.write(string, 0, string.length());
            this.a.flush();
            return;
        }
        catch (IOException iOException) {
            System.out.println(string);
            return;
        }
    }

    public final byte[] createChallenge(int n2) {
        byte[] byArray = new byte[n2];
        Rand.nextBytes(byArray);
        return byArray;
    }

    public final InetAddress getServer() {
        return this.a;
    }

    public final int getPacketIdentifier() {
        return this.o;
    }

    public final int getEAPPacketIdentifier() {
        return this.q & 0xFF;
    }

    public final void resetEAPPacketIdentifier() {
        this.q = 0;
    }

    private int i() {
        int n2;
        if (this.a == null) {
            this.a = new com.axlradius.misc.a(256);
        }
        int n3 = Rand.nextUnsignedByte();
        if ((n3 = this.a.nextClearBit(n3)) > 255) {
            n3 = this.a.nextClearBit(0);
        }
        this.a.set(n3);
        int n4 = n2 = this.c ? 253 : 249;
        if (this.a.cardinality() > n2) {
            this.a.clear();
            this.a.set(n3);
            n3 = this.a.nextClearBit(n3);
        }
        return n3;
    }

    private void a(int n2, AttributeList attributeList) {
        long l2 = System.currentTimeMillis();
        e = e++ & 0x1F;
        Rand.add$fd0664a(e, com.axlradius.radclient4.a.B, l2);
        attributeList.deleteAll(55);
        int n3 = Util.roundTime(l2);
        Attribute attribute = new Attribute(55, n3);
        attributeList.add(attribute);
        if (this.s != com.axlradius.radclient4.RADIUSClient$a.v) {
            return;
        }
        if (n2 == 4) {
            attributeList.deleteAll(41);
            n2 = Util.roundTime(l2 - this.d);
            attribute = new Attribute(41, n2);
            attributeList.add(attribute);
        }
    }

    public final Writer getDebugWriter() {
        return this.a;
    }

    public final boolean getDebugIndicator() {
        return this.debug;
    }

    public final void logToDebug(String string) {
        if (!this.debug) {
            return;
        }
        String string2 = "<" + this.o + "> " + string;
        if (this.a != null) {
            try {
                this.a.write(string2, 0, string2.length());
                this.a.write(10);
                this.a.flush();
                return;
            }
            catch (IOException iOException) {
                System.out.println(string);
                return;
            }
        }
        System.out.println(string2);
    }

    static final class a
    extends Enum<a> {
        public static final /* enum */ int v = 1;
        public static final /* enum */ int w = 2;
        public static final /* enum */ int x = 3;

        static {
            int[] nArray = new int[]{1, 2, 3};
        }
    }

    public static enum ERROR {
        NONE("No Error"),
        DUPLICATE("Duplicate packet received"),
        MISSING_USER_NAME("Missing User-Name"),
        MISMATCHED_ID("Mismatched packet id in received packet"),
        CORRUPT("Corrupt attributes"),
        AUTHENTICATOR("Authenticator response field is incorrect"),
        MESSAGE_AUTHENTICATOR("Message-Authenticator value is incorrect, probably mis-matched secret"),
        WRONG_HOST("The reply packet did not arrive from the correct host"),
        PACKET_SIZE("The reply packet was either too small or too large (packet size > physical size)"),
        DES("DES Cryptography Error"),
        TIMEOUT("Time out occurred before packet was received."),
        EVENTTIMESTAMP("Event-Timestamp found outside the time frame window."),
        ILLEGAL_CODE("Packet code has an illegal value of zero (0).");

        private String msg;
        private String b;

        private ERROR(String string2) {
            this.msg = string2;
        }

        protected final void a(String string) {
            this.b = string;
        }

        protected static void clear() {
            Iterator iterator = EnumSet.allOf(ERROR.class).iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }

        public final String toString() {
            String string = this.msg;
            if (this.ordinal() == DES.ordinal()) {
                string = string + " " + this.b;
            }
            return string;
        }
    }
}

