/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.AbstractNumericGene;
import io.jenetics.NumericGene;
import io.jenetics.internal.math.random;
import io.jenetics.util.DoubleRange;
import io.jenetics.util.ISeq;
import io.jenetics.util.IntRange;
import io.jenetics.util.MSeq;
import io.jenetics.util.Mean;
import io.jenetics.util.RandomRegistry;
import java.io.Serializable;
import java.util.Random;

public final class DoubleGene
extends AbstractNumericGene<Double, DoubleGene>
implements NumericGene<Double, DoubleGene>,
Mean<DoubleGene>,
Comparable<DoubleGene>,
Serializable {
    private static final long serialVersionUID = 1L;

    DoubleGene(Double value, Double min, Double max) {
        super(value, min, max);
    }

    @Override
    public int compareTo(DoubleGene other) {
        return ((Double)this._value).compareTo((Double)other._value);
    }

    public static DoubleGene of(double value, double min, double max) {
        return new DoubleGene(value, min, max);
    }

    public static DoubleGene of(double value, DoubleRange range) {
        return new DoubleGene(value, range.getMin(), range.getMax());
    }

    public static DoubleGene of(double min, double max) {
        return DoubleGene.of(random.nextDouble(min, max, RandomRegistry.getRandom()), min, max);
    }

    public static DoubleGene of(DoubleRange range) {
        return DoubleGene.of(random.nextDouble(range.getMin(), range.getMax(), RandomRegistry.getRandom()), range);
    }

    static ISeq<DoubleGene> seq(Double minimum, Double maximum, IntRange lengthRange) {
        double min = minimum;
        double max = maximum;
        Random r = RandomRegistry.getRandom();
        return MSeq.ofLength(random.nextInt(lengthRange, r)).fill(() -> new DoubleGene(random.nextDouble(min, max, r), minimum, maximum)).toISeq();
    }

    @Override
    public DoubleGene newInstance(Number number) {
        return new DoubleGene(number.doubleValue(), (Double)this._min, (Double)this._max);
    }

    @Override
    public DoubleGene newInstance() {
        return new DoubleGene(random.nextDouble((Double)this._min, (Double)this._max, RandomRegistry.getRandom()), (Double)this._min, (Double)this._max);
    }

    @Override
    public DoubleGene mean(DoubleGene that) {
        return new DoubleGene((Double)this._value + ((Double)that._value - (Double)this._value) / 2.0, (Double)this._min, (Double)this._max);
    }
}

