/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Gene;
import io.jenetics.Optimize;
import io.jenetics.Phenotype;
import io.jenetics.Selector;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import io.jenetics.util.RandomRegistry;
import io.jenetics.util.Seq;
import java.util.Objects;
import java.util.Random;

public final class MonteCarloSelector<G extends Gene<?, G>, C extends Comparable<? super C>>
implements Selector<G, C> {
    @Override
    public ISeq<Phenotype<G, C>> select(Seq<Phenotype<G, C>> population, int count, Optimize opt) {
        Objects.requireNonNull(population, "Population");
        Objects.requireNonNull(opt, "Optimization");
        if (count < 0) {
            throw new IllegalArgumentException(String.format("Selection count must be greater or equal then zero, but was %d.", count));
        }
        MSeq<Phenotype<G, C>> selection = MSeq.ofLength(population.isEmpty() ? 0 : count);
        if (count > 0 && !population.isEmpty()) {
            Random random2 = RandomRegistry.getRandom();
            int size = population.size();
            for (int i = 0; i < count; ++i) {
                int pos = random2.nextInt(size);
                selection.set(i, population.get(pos));
            }
        }
        return selection.toISeq();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof MonteCarloSelector;
    }

    public String toString() {
        return String.format("%s", this.getClass().getSimpleName());
    }
}

