/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Crossover;
import io.jenetics.Gene;
import io.jenetics.internal.math.comb;
import io.jenetics.internal.util.Equality;
import io.jenetics.internal.util.Hash;
import io.jenetics.util.MSeq;
import io.jenetics.util.RandomRegistry;
import java.util.Random;

public class MultiPointCrossover<G extends Gene<?, G>, C extends Comparable<? super C>>
extends Crossover<G, C> {
    private final int _n;

    public MultiPointCrossover(double probability2, int n) {
        super(probability2);
        if (n < 1) {
            throw new IllegalArgumentException(String.format("n must be at least 1 but was %d.", n));
        }
        this._n = n;
    }

    public MultiPointCrossover(double probability2) {
        this(probability2, 2);
    }

    public MultiPointCrossover(int n) {
        this(0.05, n);
    }

    public MultiPointCrossover() {
        this(0.05, 2);
    }

    public int getN() {
        return this._n;
    }

    @Override
    protected int crossover(MSeq<G> that, MSeq<G> other) {
        assert (that.length() == other.length());
        int n = Math.min(that.length(), other.length());
        int k = Math.min(n, this._n);
        Random random2 = RandomRegistry.getRandom();
        int[] points = k > 0 ? comb.subset(n, k, random2) : new int[]{};
        MultiPointCrossover.crossover(that, other, points);
        return 2;
    }

    static <T> void crossover(MSeq<T> that, MSeq<T> other, int[] indexes) {
        for (int i = 0; i < indexes.length - 1; i += 2) {
            int start = indexes[i];
            int end = indexes[i + 1];
            that.swap(start, end, other, start);
        }
        if (indexes.length % 2 == 1) {
            int index = indexes[indexes.length - 1];
            that.swap(index, Math.min(that.length(), other.length()), other, index);
        }
    }

    @Override
    public int hashCode() {
        return Hash.of(this.getClass()).and(super.hashCode()).and(this._n).value();
    }

    @Override
    public boolean equals(Object obj) {
        return Equality.of(this, obj).test(mpc -> this._n == mpc._n && super.equals(obj));
    }

    public String toString() {
        return String.format("%s[p=%f, n=%d]", this.getClass().getSimpleName(), this._probability, this._n);
    }
}

