/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;

public final class MutatorResult<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final T _result;
    private final int _mutations;

    private MutatorResult(T result, int mutations) {
        if (mutations < 0) {
            throw new IllegalArgumentException("Mutations must not be negative: " + mutations);
        }
        this._result = Objects.requireNonNull(result);
        this._mutations = mutations;
    }

    <B> MutatorResult<B> map(Function<? super T, ? extends B> mapper) {
        Objects.requireNonNull(mapper);
        return MutatorResult.of(mapper.apply(this._result), this._mutations);
    }

    public T getResult() {
        return this._result;
    }

    public int getMutations() {
        return this._mutations;
    }

    public static <T> MutatorResult<T> of(T result, int mutations) {
        return new MutatorResult<T>(result, mutations);
    }

    public static <T> MutatorResult<T> of(T result) {
        return new MutatorResult<T>(result, 0);
    }

    public int hashCode() {
        int hash = 17;
        hash += 37 * Objects.hashCode(this._result) + 31;
        return hash += 37 * this._mutations + 31;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof MutatorResult && Objects.equals(((MutatorResult)obj)._result, this._result) && ((MutatorResult)obj)._mutations == this._mutations;
    }

    public String toString() {
        return String.format("MutatorResult[%s, %s]", this._result, this._mutations);
    }
}

