/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Gene;
import io.jenetics.Optimize;
import io.jenetics.Phenotype;
import io.jenetics.RouletteWheelSelector;
import io.jenetics.internal.util.Equality;
import io.jenetics.internal.util.Hash;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import io.jenetics.util.RandomRegistry;
import io.jenetics.util.Seq;
import java.util.Objects;

public class StochasticUniversalSelector<G extends Gene<?, G>, N extends Number>
extends RouletteWheelSelector<G, N> {
    public StochasticUniversalSelector() {
        super(true);
    }

    @Override
    public ISeq<Phenotype<G, N>> select(Seq<Phenotype<G, N>> population, int count, Optimize opt) {
        Objects.requireNonNull(population, "Population");
        if (count < 0) {
            throw new IllegalArgumentException("Selection count must be greater or equal then zero, but was " + count);
        }
        if (count == 0 || population.isEmpty()) {
            return ISeq.empty();
        }
        MSeq selection = MSeq.ofLength(count);
        Seq pop = this._sorted ? population.asISeq().copy().sort(this.POPULATION_COMPARATOR) : population;
        double[] probabilities = this.probabilities(pop, count, opt);
        assert (pop.size() == probabilities.length);
        double delta = 1.0 / (double)count;
        double[] points = new double[count];
        points[0] = RandomRegistry.getRandom().nextDouble() * delta;
        for (int i = 1; i < count; ++i) {
            points[i] = delta * (double)i;
        }
        int j = 0;
        double prop = 0.0;
        for (int i = 0; i < count; ++i) {
            while (points[i] > prop) {
                prop += probabilities[j];
                ++j;
            }
            selection.set(i, pop.get(j % pop.size()));
        }
        return selection.toISeq();
    }

    @Override
    public int hashCode() {
        return Hash.of(this.getClass()).and(super.hashCode()).value();
    }

    @Override
    public boolean equals(Object obj) {
        return Equality.of(this, obj).test(x$0 -> super.equals(x$0));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }
}

