/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.util;

import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import io.jenetics.util.Seq;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

final class SeqView<T>
implements Seq<T> {
    private final List<? extends T> _list;

    SeqView(List<? extends T> list) {
        this._list = Objects.requireNonNull(list);
    }

    @Override
    public List<T> asList() {
        return this._list;
    }

    @Override
    public T get(int index) {
        return this._list.get(index);
    }

    @Override
    public int length() {
        return this._list.size();
    }

    @Override
    public Seq<T> subSeq(int start, int end) {
        return new SeqView<T>(this._list.subList(start, end));
    }

    @Override
    public Seq<T> subSeq(int start) {
        return new SeqView<T>(this._list.subList(start, this._list.size()));
    }

    @Override
    public <B> Seq<B> map(Function<? super T, ? extends B> mapper) {
        Objects.requireNonNull(mapper);
        MSeq<B> result = MSeq.ofLength(this.length());
        for (int i = 0; i < this.length(); ++i) {
            result.set(i, mapper.apply(this.get(i)));
        }
        return result.toISeq();
    }

    @Override
    public Seq<T> append(Iterable<? extends T> values) {
        Objects.requireNonNull(values);
        return ISeq.of(this._list).append((Iterable)values);
    }

    @Override
    public Seq<T> prepend(Iterable<? extends T> values) {
        Objects.requireNonNull(values);
        return ISeq.of(this._list).prepend((Iterable)values);
    }

    @Override
    public Object[] toArray() {
        return this._list.toArray();
    }

    @Override
    public <B> B[] toArray(B[] array2) {
        return this._list.toArray(array2);
    }
}

