/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.googlecode.ipv6.IPv6Address;
import com.googlecode.ipv6.IPv6AddressRange;
import com.googlecode.ipv6.IPv6Network;
import com.ubnt.ace.Object;
import com.ubnt.ace.Q;
import com.ubnt.ace.view.D;
import com.ubnt.data.DhcpOption;
import com.ubnt.data.DpiGroup;
import com.ubnt.data.ExternalIdGenerator;
import com.ubnt.data.HasExternalId;
import com.ubnt.data.HasSettingPreference;
import com.ubnt.data.Ipv6RaPriority;
import com.ubnt.data.NetworkConfDefaults;
import com.ubnt.data.OoOO;
import com.ubnt.data.RadiusProfile;
import com.ubnt.data.ReferClasses;
import com.ubnt.data.Sanitizable;
import com.ubnt.data.Setting;
import com.ubnt.data.SettingPreference;
import com.ubnt.data.UserGroup;
import com.ubnt.data.X;
import com.ubnt.model.api.global.config.network.EnabledFor;
import com.ubnt.model.api.network.configuration.NetworkGatewayDeviceType;
import com.ubnt.model.api.network.configuration.NetworkPurpose;
import com.ubnt.model.api.network.configuration.OpenVpnConfigurationStatus;
import com.ubnt.model.api.network.configuration.VpnNetworkProtocol;
import com.ubnt.model.api.network.configuration.WanDnsPreference;
import com.ubnt.model.api.systemlog.admin.activity.changes.AdminChangeKey;
import com.ubnt.model.api.systemlog.admin.activity.changes.AdminChangeSection;
import com.ubnt.model.api.uid.UidVpnType;
import com.ubnt.model.api.wan.Ipv6WanDelegationType;
import com.ubnt.model.api.wan.WanLoadBalanceType;
import com.ubnt.model.api.wan.WanNetworkGroup;
import com.ubnt.model.api.wan.WanType;
import com.ubnt.model.api.wan.WanTypeV6;
import com.ubnt.model.oO0O.A.B;
import com.ubnt.model.oO0O.A.super;
import com.ubnt.model.oO0O.B.A;
import com.ubnt.model.oO0O.B.class;
import com.ubnt.net.F.H;
import com.ubnt.repository.R;
import com.ubnt.service.fabric.return;
import com.ubnt.service.network.ooOO;
import com.ubnt.service.orchestration.OrchestratedConfig;
import com.ubnt.service.orchestration.model.TemplateConfigMetaData;
import com.ubnt.service.system.superclass;
import com.ubnt.service.systemlog.admin.activity.changes.C;
import com.ubnt.service.systemlog.admin.activity.changes.M;
import com.ubnt.service.systemlog.admin.activity.changes.N;
import com.ubnt.service.systemlog.admin.activity.changes.W;
import com.ubnt.service.systemlog.admin.activity.changes.o00O;
import com.ubnt.service.systemlog.admin.activity.changes.oo0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import com.ubnt.service.vpn.ooOO.oOOO;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.slf4j.Logger;

public class NetworkConf
extends X
implements HasSettingPreference,
Sanitizable,
R,
W,
M,
ooOO,
com.ubnt.service.fabric.Object,
OrchestratedConfig,
HasExternalId {
    private static final Logger \u00f8\u00d3O000 = superclass.\u00d2\u00d30000;
    public static final String \u00d8\u00f60000 = "networkconf";
    public static final int \u00d5OO000 = 4094;
    public static final String returnfloat = "-";
    private static final Set<String> whilevoid = Set.of("ether_lighting_raw_color_hex", "ether_lighting_rounded_color_index", "gateway_index_for_intervlan_routing", "ipv6_enabled", "openvpn_id", "openvpn_configuration_status", "purpose", "wireguard_id", "routing_table_id", "external_id", "cloud_template");
    private static final Map<String, com.ubnt.service.referencename.ooOO> \u00f6\u00d2O000 = Map.of("dpigroup_id", com.ubnt.service.referencename.ooOO.o\u00d20000, "firewall_zone_id", com.ubnt.service.referencename.ooOO.intsuper, "radiusprofile_id", com.ubnt.service.referencename.ooOO.voidnew, "usergroup_id", com.ubnt.service.referencename.ooOO.\u00d500000, "remote_site_id", com.ubnt.service.referencename.ooOO.\u00d5O0000, "wan_sla", com.ubnt.service.referencename.ooOO.\u00f400000);
    private static final Set<String> thisif = Set.of("openvpn_configuration", "wireguard_client_configuration_file", "sdwan_remote_site_id");
    private static final Map<String, String> \u00d8\u00d2O000 = Map.ofEntries(Map.entry("nat_outbound_ip_addresses", "wan_network_group"), Map.entry("wan_dhcp_options", "optionNumber"), Map.entry("wan_dhcpv6_options", "optionNumber"));
    @ReferClasses
    public static final List<Class<?>> forif = ImmutableList.of(UserGroup.class, DpiGroup.class, RadiusProfile.class, DhcpOption.class);
    public static final String \u00f8\u00f80000 = "LAN";
    public static final String \u00d6\u00d2O000 = "ROUTE";
    public static final String \u00f8\u00d2O000 = "WAN_LTE_FAILOVER";
    public static final String \u00d30O000 = "WAN_5G";
    public static final String \u00f8\u00f50000 = "WAN";
    static final String Stringif = "MC_LAG_INTER_CHASSIS_ROUTE";
    public static final Set<String> \u00f5\u00f80000 = Set.of("ROUTE", "WAN_5G");
    public static final int \u00d6oO000 = 1;
    public static final String \u00f6\u00d3O000 = "INTERNAL";
    public static final String \u00d8\u00f50000 = "LAN";
    public static final String privatereturn = "LAN2";
    public static final String \u00d3\u00f50000 = "LAN3";
    public static final String o\u00f50000 = "LAN4";
    public static final String Stringfor = "LAN5";
    public static final String \u00d3\u00d4O000 = "LAN6";
    public static final String \u00d2\u00d4O000 = "LAN7";
    public static final String o\u00d4O000 = "LAN8";
    public static final String o\u00d3O000 = "MGMT";
    public static final String[] \u00d6\u00f50000 = new String[]{"LAN", "LAN2", "LAN3", "LAN4", "LAN5", "LAN6", "LAN7", "LAN8"};
    @Deprecated
    public static final String \u00d6\u00f60000 = WanNetworkGroup.WAN.toString();
    @Deprecated
    public static final String \u00f6OO000 = WanNetworkGroup.WAN2.toString();
    @Deprecated
    public static final String \u00d8OO000 = WanNetworkGroup.LTE_FAILOVER.toString();
    public static final String o\u00f80000 = "any";
    public static final String \u00d2\u00f60000 = "localdomain";
    public static final String whileint = "routing";
    @Deprecated
    public static final String \u00f50O000 = NetworkPurpose.VLAN_ONLY.toString();
    @Deprecated
    public static final String returnint = NetworkPurpose.CORPORATE.toString();
    @Deprecated
    public static final String ifvoid = NetworkPurpose.GUEST.toString();
    @Deprecated
    public static final String \u00d5\u00f50000 = NetworkPurpose.WAN.toString();
    @Deprecated
    public static final String \u00d8\u00d3O000 = NetworkPurpose.REMOTE_USER_VPN.toString();
    @Deprecated
    public static final String \u00f8OO000 = NetworkPurpose.SITE_VPN.toString();
    @Deprecated
    public static final String \u00d2\u00d2O000 = NetworkPurpose.VPN_CLIENT.toString();
    public static final Set<String> \u00f5\u00d3O000 = ImmutableSet.of((java.lang.Object)returnint, (java.lang.Object)ifvoid);
    public static final int \u00f6oO000 = 86400;
    public static final int \u00d6OO000 = 86400;
    public static final int \u00f6\u00f50000 = 14400;
    public static final int o\u00f60000 = 1280;
    public static final int \u00d5\u00d3O000 = 1476;
    public static final int \u00d3\u00d2O000 = 4;
    public static final int \u00d3\u00f60000 = 3;
    @Deprecated
    public static final String \u00d3\u00f80000 = com.ubnt.model.oO0O.B.B.\u00f600000.toString();
    @Deprecated
    public static final String newvoid = com.ubnt.model.oO0O.B.B.float.toString();
    @Deprecated
    public static final String \u00d5\u00f60000 = com.ubnt.model.oO0O.B.B.\u00f500000.toString();
    @Deprecated
    public static final String \u00f8oO000 = com.ubnt.model.oO0O.B.B.public.toString();
    @Deprecated
    public static final String ooO000 = com.ubnt.model.oO0O.B.B.Object.toString();
    @Deprecated
    public static final String returnvoid = com.ubnt.model.oO0O.B.B.\u00d400000.toString();
    public static final String \u00d5oO000 = "dhcpd_user_option_";
    public static final String \u00f5\u00f60000 = "dhcpd_user_option_%s";
    public static final String ifint = "Default";
    public static final String o\u00d2O000 = "192.168.1.1/24";
    public static final String \u00d8oO000 = "10.255.252.0/30";
    public static final String \u00f8\u00f60000 = "10.255.253.1/24";
    public static final String \u00d50O000 = "0.0.0.0/24";
    public static final int \u00f5OO000 = 254;
    public static final String \u00d5\u00d2O000 = "10.255.254.0/24";
    public static final String \u00f5oO000 = "100.127.125.128";
    public static final String \u00d2OO000 = "100.127.125.129";
    public static final String \u00d3oO000 = "255.255.255.254";
    public static final String iffloat = "tun900";
    public static final String \u00f5\u00f50000 = "gre1";
    public static final String \u00d6\u00d3O000 = "lo";
    public static final String nullif = "wwan";
    public static final String o0O000 = "wwan0";
    public static final WanNetworkGroup forreturn = WanNetworkGroup.WAN3;
    public static final String oOO000 = "Inter-VLAN routing";
    public static final String[] privatenull = new String[]{"ip_subnet", "dhcpd_enabled", "dhcpd_start", "dhcpd_stop", "dhcpd_tftp_server", "dhcpd_wpad_url", "dhcpd_time_offset", "dhcpd_time_offset_enabled", "dhcpd_unifi_controller", "dhcpd_boot_filename", "dhcpd_boot_server", "dhcpd_boot_enabled", "dhcpd_ntp_enabled", "dhcpd_ntp_1", "dhcpd_ntp_2", "dhcpd_wins_enabled", "dhcpd_wins_1", "dhcpd_wins_2", "dhcpd_leasetime", "dhcpd_dns_enabled", "dhcpd_dns_1", "dhcpd_dns_2", "dhcpd_dns_3", "dhcpd_dns_4", "dhcpd_gateway", "dhcpd_gateway_enabled"};
    public static final int \u00f80O000 = 1;
    public static final int \u00f6\u00f80000 = 4012;
    public static final int nullnull = 4013;
    public static final int \u00d8\u00f80000 = 4014;
    public static final int \u00d6\u00f80000 = 4015;
    public static final int \u00d2\u00f80000 = 4016;
    public static final int thisnull = 4017;
    public static final int \u00f6\u00f60000 = 4018;
    public static final int \u00d5\u00f80000 = 4040;
    public static final int \u00f60O000 = 4050;
    public static final int Stringnull = 1;
    public static final int \u00d3OO000 = 2;
    public static final int \u00d20O000 = 31536000;
    public static final int \u00d2\u00f50000 = 500000;
    public static final int fornull = 3;
    public static final int \u00d60O000 = 86400;
    public static final int privateif = -86400;
    public static final int whilefloat = 1194;
    public static final int newfloat = 127;
    private static final int \u00f5\u00d2O000 = 1000000;
    private static final int \u00d2oO000 = 300000;
    private static final double thisfor = 0.8;
    public static final int \u00d2\u00d3O000 = 4500;
    public static final int \u00d3\u00d3O000 = 500;
    public static OoOO \u00d80O000 = OoOO.\u00f60\u00f8000(NetworkConf.class.getSimpleName());
    public static final NetworkConf newint = (NetworkConf)new NetworkConf().makeImmutable();

    public static String name() {
        return \u00d8\u00f60000;
    }

    @Override
    public String getCollectionName() {
        return NetworkConf.name();
    }

    @Override
    public AdminChangeSection getSection() {
        return switch (this.getNetworkPurpose()) {
            case NetworkPurpose.CORPORATE, NetworkPurpose.GUEST -> AdminChangeSection.NETWORK_LOCAL;
            case NetworkPurpose.REMOTE_USER_VPN -> AdminChangeSection.NETWORK_VPN_SERVER;
            case NetworkPurpose.SITE_VPN -> AdminChangeSection.NETWORK_SITE_VPN;
            case NetworkPurpose.VPN_CLIENT -> AdminChangeSection.NETWORK_VPN_CLIENT;
            case NetworkPurpose.VLAN_ONLY -> AdminChangeSection.NETWORK_VLAN_ONLY;
            case NetworkPurpose.WAN, NetworkPurpose.WAN_MAGIC -> AdminChangeSection.NETWORK_WAN;
            default -> AdminChangeSection.NETWORK;
        };
    }

    @Override
    public AdminChangeKey getChangeKey() {
        return switch (this.getNetworkPurpose()) {
            case NetworkPurpose.REMOTE_USER_VPN, NetworkPurpose.SITE_VPN, NetworkPurpose.VPN_CLIENT -> AdminChangeKey.VPN;
            case NetworkPurpose.WAN, NetworkPurpose.WAN_MAGIC -> AdminChangeKey.INTERNET;
            default -> AdminChangeKey.NETWORK;
        };
    }

    @Override
    public Optional<oo0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO> getDepiction() {
        return oo0OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO.\u00d400000("name", this.getName());
    }

    @Override
    public o00O getChangeLogRule(N n2) {
        if (this.isRemoteUserOpenVpnServer() && n2.\u00d400000() != D.\u00f500000) {
            return o00O.\u00d200000;
        }
        if (this.isWanMagicNetwork()) {
            return o00O.\u00d200000;
        }
        if (this.isWan5gNetwork() && n2.super() != C.\u00d400000) {
            return o00O.\u00d200000;
        }
        return o00O.Object().o00000(whilevoid).null(\u00f6\u00d2O000).\u00d6O0000(thisif).ifsuper(\u00d8\u00d2O000).o\u00d20000(this.\u00d8\u00d80000()).\u00d500000();
    }

    private Map<String, java.lang.Object> \u00d8\u00d80000() {
        return ImmutableMap.builder().putAll(this.\u00d3\u00d60000()).put((java.lang.Object)"enabled", (java.lang.Object)true).build();
    }

    private Map<String, java.lang.Object> \u00d3\u00d60000() {
        if (this.isLocalSiteNetwork()) {
            return ImmutableMap.builder().putAll((Map)((java.lang.Object)NetworkConfDefaults.localNetworkAutoSettings(this.isVlanEnabled()))).put((java.lang.Object)"setting_preference", (java.lang.Object)SettingPreference.\u00d300000.toString()).put((java.lang.Object)"gateway_type", (java.lang.Object)NetworkGatewayDeviceType.DEFAULT.toString()).build();
        }
        if (this.isLteWanFailoverNetwork()) {
            return NetworkConfDefaults.lteWanAutoSettings();
        }
        if (this.isWanNetwork()) {
            return ImmutableMap.builder().putAll((Map)((java.lang.Object)NetworkConfDefaults.wanAutoSettings())).put((java.lang.Object)"wan_pppoe_username_enabled", (java.lang.Object)true).put((java.lang.Object)"wan_pppoe_password_enabled", (java.lang.Object)true).build();
        }
        return Map.of();
    }

    public static int mask() {
        return \u00d8\u00d40000 | \u00d3\u00d30000 | \u00d6\u00d20000;
    }

    @Override
    public synchronized NetworkConf append(String string, java.lang.Object object) {
        super.append(string, object);
        return this;
    }

    public boolean isUidTrafficRulesEnabled() {
        return this.is("uid_traffic_rules_enabled", false);
    }

    public boolean isUidVpnMasqueradeEnabled() {
        return this.is("uid_vpn_masquerade_enabled", false);
    }

    public Optional<String> getSdWanRemoteSiteId() {
        return this.getOptionalString("sdwan_remote_site_id");
    }

    public NetworkConf setSdWanRemoteSiteId(String string) {
        return this.append("sdwan_remote_site_id", string);
    }

    public Optional<String> getSdWanHubSpokeConnectionId() {
        return this.getOptionalString("sdwan_hub_spoke_connection_id");
    }

    public NetworkConf setSdWanHubSpokeConnectionId(String string) {
        return this.append("sdwan_hub_spoke_connection_id", string);
    }

    public Optional<WanNetworkGroup> getSdWanHubSpokeLocalWanId() {
        return Q.private(WanNetworkGroup.class, this.getString("sdwan_hub_spoke_local_wan_id"));
    }

    public NetworkConf setSdWanHubSpokeLocalWanId(WanNetworkGroup wanNetworkGroup) {
        return this.append("sdwan_hub_spoke_local_wan_id", wanNetworkGroup.toString());
    }

    public NetworkConf setUidVpnMasqueradeEnabled(boolean bl) {
        return this.append("uid_vpn_masquerade_enabled", bl);
    }

    public NetworkConf setUidTrafficRulesEnabled(boolean bl) {
        return this.append("uid_traffic_rules_enabled", bl);
    }

    public List<String> getUidTrafficRulesAllowedIpAndHostnames() {
        return this.getStringList("uid_traffic_rules_allowed_ips_and_hostnames");
    }

    public NetworkConf setUidTrafficRulesAllowedIpsAndHostnames(List<String> list) {
        return this.append("uid_traffic_rules_allowed_ips_and_hostnames", list);
    }

    public Optional<String> getUidWorkspaceUrl() {
        return Optional.ofNullable(this.getString("uid_workspace_url"));
    }

    public NetworkConf setUidWorkspaceUrl(String string) {
        return this.append("uid_workspace_url", string);
    }

    public Optional<String> getUidPolicyName() {
        return Optional.ofNullable(this.getString("uid_policy_name"));
    }

    public NetworkConf setUidPolicyName(String string) {
        return this.append("uid_policy_name", string);
    }

    public NetworkConf setUidPolicyEnabled(boolean bl) {
        return this.append("uid_policy_enabled", bl);
    }

    public boolean isUidPolicyEnabled() {
        return this.is("uid_policy_enabled", false);
    }

    public List<String> getUidVpnCustomRouting() {
        return this.getStringList("uid_vpn_custom_routing");
    }

    public NetworkConf setUidVpnCustomRouting(List<String> list) {
        return this.append("uid_vpn_custom_routing", list);
    }

    public Optional<String> getUidVpnDefaultDnsSuffix() {
        return Optional.ofNullable(this.getString("uid_vpn_default_dns_suffix"));
    }

    public NetworkConf setUidVpnDefaultDnsSuffix(String string) {
        return this.append("uid_vpn_default_dns_suffix", string);
    }

    public boolean isUidVpnSyncPublicIp() {
        return this.is("uid_vpn_sync_public_ip", false);
    }

    public NetworkConf setUidVpnSyncPublicIp(boolean bl) {
        return this.append("uid_vpn_sync_public_ip", bl);
    }

    public Optional<Integer> getUidVpnMaxConnectionTime() {
        return this.getOptionalInt("uid_vpn_max_connection_time_seconds");
    }

    public NetworkConf setUidVpnMaxConnectionTime(Integer n2) {
        return this.append("uid_vpn_max_connection_time_seconds", n2);
    }

    public Optional<String> getFirewallZoneId() {
        return Optional.ofNullable(this.getString("firewall_zone_id"));
    }

    public NetworkConf setFirewallZoneId(String string) {
        return this.append("firewall_zone_id", string);
    }

    public Optional<String> getOptionalWanSla() {
        return Optional.ofNullable(this.getWanSla());
    }

    @Nullable
    public String getWanSla() {
        return this.getString("wan_sla");
    }

    public NetworkConf setWanSla(String string) {
        return this.append("wan_sla", string);
    }

    public Optional<Integer> getRoutingTableIdOptional() {
        return this.getOptionalInt("routing_table_id");
    }

    public int getRoutingTableId() {
        return this.getInt("routing_table_id");
    }

    public boolean hasRoutingTableId() {
        return this.getRoutingTableIdOptional().isPresent();
    }

    public NetworkConf setRoutingTableId(Integer n2) {
        return this.append("routing_table_id", n2);
    }

    public NetworkConf removeRoutingTableId() {
        this.remove("routing_table_id");
        return this;
    }

    @Override
    public synchronized NetworkConf mergeFrom(X x2) {
        super.mergeFrom(x2);
        return this;
    }

    @Override
    public void sanitize(X x2) {
        String string2 = x2.getString("purpose");
        if ((returnint.equals(string2) || ifvoid.equals(string2)) && !x2.containsField("networkgroup")) {
            x2.put("networkgroup", (java.lang.Object)"LAN");
        }
        String[] stringArray = x2.keySet().stream().filter(string -> string.startsWith(\u00d5oO000)).collect(Collectors.toSet()).toArray(new String[0]);
        X x3 = new X();
        x3.copyAttrsIfPresent(x2, stringArray);
        x2.removeFields(stringArray);
        boolean bl = false;
        if (x2.getInt("vlan") == 4040) {
            x2.removeFields("vlan");
            bl = true;
        }
        \u00d80O000.\u00f50\u00f8000(x2);
        x2.mergeFrom(x3);
        if (bl) {
            x2.put("vlan", (java.lang.Object)4040);
        }
    }

    public static NetworkConf createLocalAreaNetworkBaseConfForSite(String string) {
        NetworkConf networkConf = new NetworkConf();
        networkConf.mergeFrom(NetworkConfDefaults.localNetworkBaseAutoSettings(false));
        return networkConf.setSiteId(string).setAutoScaleNetworkEnabled(true).setNoDelete(true).setHiddenId("LAN").setIpSubnet(o\u00d2O000).setName(ifint).setDhcpdStart(NetworkConf.getDefaultDHCPStartIP(o\u00d2O000)).setDhcpdStop(NetworkConf.getDefaultDHCPStopIP(o\u00d2O000)).setVlanEnabled(false).setExternalId(ExternalIdGenerator.generateRandomExternalId());
    }

    public static NetworkConf createInterVlanRoutingNetworkConfForSite(String string) {
        return new NetworkConf().setSiteId(string).setExternalId(ExternalIdGenerator.generateRandomExternalId()).setName(oOO000).setPurpose(NetworkPurpose.CORPORATE).setDomainName(whileint).setVlanEnabled(true).setVlan(4040).setIpSubnet(\u00f8\u00f60000).setNoDelete(true).setHiddenId(\u00d6\u00d2O000).setNetworkGroup("LAN").setIpV6InterfaceType(super.\u00d600000).setNat(true).setDhcpdEnabled(false).setDhcpdV6Enabled(false).setIpV6RaEnabled(false).setLteLanEnabled(true);
    }

    public static NetworkConf createVlanForMclagInterChassisLink() {
        return new NetworkConf().setExternalId(ExternalIdGenerator.generateRandomExternalId()).setPurpose(NetworkPurpose.CORPORATE).setVlanEnabled(true).setVlan(4050).setIpSubnet(\u00d8oO000).setHiddenId(Stringif).setNetworkGroup("LAN");
    }

    public static NetworkConf createLteFailoverWanNetworkConf(String string) {
        return new NetworkConf().setHiddenId(\u00f8\u00d2O000).setExternalId(ExternalIdGenerator.generateRandomExternalId()).setSettingPreference(SettingPreference.\u00d300000).setWanNetworkGroup(\u00d8OO000).setPurpose(NetworkPurpose.WAN).setName("LTE Failover WAN").setSiteId(string).setWanType(WanType.STATIC.toString()).setReportWanEvent(true).setWanLoadBalanceType(WanLoadBalanceType.FAILOVER_ONLY).setWanIp(\u00d2OO000).setWanGateway(\u00f5oO000).setWanNetmask(\u00d3oO000).setWanFailOverPriority(WanNetworkGroup.LTE_FAILOVER.index());
    }

    public static NetworkConf createDefaultWan5gNetwork(String string, WanNetworkGroup wanNetworkGroup) {
        return new NetworkConf().mergeFrom(NetworkConfDefaults.wanAutoSettings()).setExternalId(ExternalIdGenerator.generateRandomExternalId()).setNoDelete(true).setWanNetworkGroup(wanNetworkGroup).setName(wanNetworkGroup.defaultDisplayName() + " (Cellular)").setSiteId(string).setWanLoadBalanceType(WanLoadBalanceType.FAILOVER_ONLY).setWanFailOverPriority(wanNetworkGroup.index()).setWan5gNetwork().setInterfaceName(o0O000);
    }

    public static NetworkConf createWanNetworkConfFromConfigNetworkWan(X x2, String string, WanNetworkGroup wanNetworkGroup) {
        return NetworkConf.createWanNetworkConfFromConfigNetworkWan(x2, string, wanNetworkGroup, false, wanNetworkGroup.index());
    }

    public static NetworkConf createWanNetworkConfFromConfigNetworkWan(X x2, String string, WanNetworkGroup wanNetworkGroup, int n2) {
        return NetworkConf.createWanNetworkConfFromConfigNetworkWan(x2, string, wanNetworkGroup, false, n2);
    }

    public static NetworkConf createWanNetworkConfFromConfigNetworkWan(X x2, String string, WanNetworkGroup wanNetworkGroup, boolean bl, int n2) {
        String string2;
        List<X> list;
        String[] stringArray;
        NetworkConf networkConf = new NetworkConf();
        if (bl || WanNetworkGroup.WAN == wanNetworkGroup) {
            networkConf.put("attr_no_delete", (java.lang.Object)true);
        }
        if (WanNetworkGroup.WAN == wanNetworkGroup) {
            networkConf.put("attr_hidden_id", (java.lang.Object)\u00f8\u00f50000);
        }
        networkConf.mergeFrom(NetworkConfDefaults.wanAutoSettings());
        networkConf.setSiteId(string);
        networkConf.setWanNetworkGroup(wanNetworkGroup);
        networkConf.setPurpose(NetworkPurpose.WAN);
        networkConf.setName(wanNetworkGroup.defaultDisplayName());
        networkConf.setWanFailOverPriority(n2);
        networkConf.setExternalId(ExternalIdGenerator.generateRandomExternalId());
        for (String string3 : stringArray = new String[]{"type", "ip", "netmask", "gateway", "username", "dns1", "dns2", "dns3", "dns4", "load_balance_type", "type_v6", "ipv6", "gateway_v6", "dslite_remote_host"}) {
            String string4 = x2.getString(string3);
            if (!StringUtils.isNotEmpty((CharSequence)string4)) continue;
            networkConf.put("wan_" + string3, (java.lang.Object)string4);
        }
        for (String string3 : stringArray = new String[]{"vlan", "smartq_up_rate", "smartq_down_rate", "dhcpv6_pd_size", "load_balance_weight", "prefixlen", "egress_qos"}) {
            if (!x2.containsField(string3)) continue;
            int n3 = x2.getInt(string3);
            networkConf.put("wan_" + string3, (java.lang.Object)n3);
        }
        for (String string3 : stringArray = new String[]{"vlan_enabled", "smartq_enabled"}) {
            if (!x2.containsField(string3)) continue;
            networkConf.put("wan_" + string3, (java.lang.Object)x2.is(string3, false));
        }
        String string5 = x2.getString("x_password");
        if (StringUtils.isNotEmpty((CharSequence)string5)) {
            networkConf.put("x_wan_password", (java.lang.Object)string5);
        }
        if (!(list = x2.getList("dhcp_options")).isEmpty()) {
            networkConf.put("wan_dhcp_options", list);
        }
        if (StringUtils.isNotEmpty((CharSequence)(string2 = x2.getString("mac_override")))) {
            networkConf.setMacOverride(string2);
            networkConf.setMacOverrideEnabled(true);
        }
        networkConf.setWanLoadBalanceType(wanNetworkGroup == WanNetworkGroup.WAN ? WanLoadBalanceType.WEIGHTED : WanLoadBalanceType.FAILOVER_ONLY);
        networkConf.setWanDnsPreference(networkConf.whileclass() ? WanDnsPreference.MANUAL : WanDnsPreference.AUTO);
        networkConf.setSettingPreference(networkConf.matchesAutoWanSettings() ? SettingPreference.\u00d300000 : SettingPreference.super);
        if (wanNetworkGroup == WanNetworkGroup.WAN) {
            networkConf.setWanLoadBalanceWeight(99);
        }
        networkConf.setWanDsLiteRemoteHostAuto(x2.is("wan_dslite_remote_host_auto", false));
        return networkConf;
    }

    public boolean matchesAutoWanSettings() {
        NetworkConf networkConf = this.isLteWanFailoverNetwork() ? NetworkConfDefaults.lteWanAutoSettings() : NetworkConfDefaults.wanAutoSettings();
        NetworkConf networkConf2 = new NetworkConf();
        networkConf2.mergeFrom(networkConf);
        networkConf2.mergeFrom(this);
        networkConf2.retainFields((String[])networkConf.keySet().stream().toArray(String[]::new));
        return networkConf.equals(networkConf2);
    }

    public String getNetworkGroup() {
        if (this.isLocalSiteNetwork()) {
            return this.getString("networkgroup");
        }
        if (this.isWanNetwork()) {
            return this.getWanNetworkGroup().map(WanNetworkGroup::toString).orElse(null);
        }
        return "unknown";
    }

    public NetworkConf setNetworkGroup(String string) {
        this.put("networkgroup", (java.lang.Object)string);
        return this;
    }

    public boolean hasWan1NetworkGroup() {
        return this.getWanNetworkGroup().map(wanNetworkGroup -> WanNetworkGroup.WAN == wanNetworkGroup).orElse(false);
    }

    public boolean hasWan2NetworkGroup() {
        return this.getWanNetworkGroup().map(wanNetworkGroup -> WanNetworkGroup.WAN2 == wanNetworkGroup).orElse(false);
    }

    public boolean isWanNetworkGroup() {
        return this.getWanNetworkGroup().filter(WanNetworkGroup.WAN_NETWORK_GROUPS::contains).isPresent();
    }

    public Optional<WanNetworkGroup> getWanNetworkGroup() {
        return WanNetworkGroup.ofStringValueOptional(this.getString("wan_networkgroup"));
    }

    public NetworkConf setWanNetworkGroup(WanNetworkGroup wanNetworkGroup) {
        this.put("wan_networkgroup", (java.lang.Object)wanNetworkGroup.toString());
        return this;
    }

    public boolean isIpsecSeparateIkeV2Networks() {
        return this.is("ipsec_separate_ikev2_networks", false);
    }

    public NetworkConf setIpsecSeparateIkeV2Networks(boolean bl) {
        return this.append("ipsec_separate_ikev2_networks", bl);
    }

    @Deprecated
    public NetworkConf setWanNetworkGroup(String string) {
        this.put("wan_networkgroup", (java.lang.Object)string);
        return this;
    }

    public boolean isWanLoadBalanceFailoverOnly() {
        return this.getWanLoadBalanceType().map(wanLoadBalanceType -> WanLoadBalanceType.FAILOVER_ONLY == wanLoadBalanceType).orElse(false);
    }

    public boolean isWanLoadBalanceWeighted() {
        return this.getWanLoadBalanceType().map(wanLoadBalanceType -> WanLoadBalanceType.WEIGHTED == wanLoadBalanceType).orElse(false);
    }

    public Optional<WanLoadBalanceType> getWanLoadBalanceType() {
        return this.getOptionalString("wan_load_balance_type").flatMap(WanLoadBalanceType::ofStringValue);
    }

    public NetworkConf setWanLoadBalanceType(WanLoadBalanceType wanLoadBalanceType) {
        this.put("wan_load_balance_type", (java.lang.Object)wanLoadBalanceType.toString());
        return this;
    }

    public Optional<Integer> getWanLoadBalanceWeight() {
        return this.getOptionalInt("wan_load_balance_weight");
    }

    public NetworkConf setWanLoadBalanceWeight(int n2) {
        this.put("wan_load_balance_weight", (java.lang.Object)n2);
        return this;
    }

    public Optional<Integer> getWanFailOverPriority() {
        return this.getOptionalInt("wan_failover_priority");
    }

    public NetworkConf setWanFailOverPriority(int n2) {
        this.put("wan_failover_priority", (java.lang.Object)n2);
        return this;
    }

    @Deprecated
    public String getPurpose() {
        return this.getString("purpose");
    }

    public NetworkPurpose getNetworkPurpose() {
        return this.getOptionalEnum("purpose", NetworkPurpose.class).orElse(null);
    }

    public boolean hasNetworkPurpose(NetworkPurpose networkPurpose) {
        return networkPurpose != null && networkPurpose.toString().equals(this.getString("purpose"));
    }

    public boolean isDefaultLocalAreaNetwork() {
        return "LAN".equals(this.getNetworkGroup()) && "LAN".equals(this.getHiddenId().orElse(null));
    }

    public Optional<String> getMacOverride() {
        return Optional.ofNullable(this.getString("mac_override"));
    }

    public NetworkConf setMacOverride(String string) {
        this.put("mac_override", (java.lang.Object)string);
        return this;
    }

    public boolean isMacOverrideEnabled() {
        return this.is("mac_override_enabled", false);
    }

    public NetworkConf setMacOverrideEnabled(boolean bl) {
        this.put("mac_override_enabled", (java.lang.Object)bl);
        return this;
    }

    public int getMaskbits() {
        return H.newnew(this.getIpSubnet());
    }

    public int getPrefixLength() {
        if (this.isIpv6StandardPrefixLengthInterfaceType()) {
            return 64;
        }
        String string = this.getString("ipv6_subnet");
        String string2 = this.getString("type_v6", "none");
        if (StringUtils.equals((CharSequence)string2, (CharSequence)"track")) {
            return 64;
        }
        if (!Object.\u00d500000(string)) {
            return 0;
        }
        String[] stringArray = this.getString("ipv6_subnet").split("/");
        int n2 = Integer.parseInt(stringArray[1]);
        return n2;
    }

    public String getIpv4() {
        String string = this.getString("ip_subnet");
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        String[] stringArray = string.split("/");
        return stringArray[0];
    }

    public Integer getIpv4Netmask() {
        String string = this.getString("ip_subnet");
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        String[] stringArray = string.split("/");
        return Integer.parseInt(stringArray[1]);
    }

    public String getIpv6() {
        String string = this.getString("ipv6_subnet");
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        String[] stringArray = string.split("/");
        return stringArray[0];
    }

    public int getLocalPort() {
        return this.getInt("local_port");
    }

    public NetworkConf setLocalPort(int n2) {
        this.put("local_port", (java.lang.Object)n2);
        return this;
    }

    public Optional<Integer> getUidPublicGatewayPort() {
        return this.getOptionalInt("uid_public_gateway_port");
    }

    public NetworkConf setUidPublicGatewayPort(int n2) {
        return this.append("uid_public_gateway_port", n2);
    }

    public NetworkConf setIpSubnet(String string) {
        this.put("ip_subnet", (java.lang.Object)string);
        return this;
    }

    public String getIpSubnet() {
        return this.getString("ip_subnet", o\u00d2O000);
    }

    public String getIpSubnetOrNull() {
        return this.getString("ip_subnet");
    }

    public String getSubnet() {
        return this.\u00d2\u00d60000(this.getSubnetInfo());
    }

    public SubnetUtils.SubnetInfo getSubnetInfo() {
        SubnetUtils subnetUtils = new SubnetUtils(this.getString("ip_subnet", o\u00d2O000));
        return subnetUtils.getInfo();
    }

    public Optional<String> getIpV6Subnet() {
        return Optional.ofNullable(this.getString("ipv6_subnet"));
    }

    public NetworkConf setIpV6Subnet(String string) {
        this.put("ipv6_subnet", (java.lang.Object)string);
        return this;
    }

    public String getSubnetv6() {
        String string = this.getString("ipv6_subnet");
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        IPv6Network iPv6Network = IPv6Network.fromString((String)string);
        String string2 = iPv6Network.getFirst().toString();
        String string3 = Integer.toString(iPv6Network.getNetmask().asPrefixLength());
        return string2 + "/" + string3;
    }

    public String getGatewayDeviceMac() {
        return this.getString("gateway_device", "");
    }

    public NetworkConf setGatewayDeviceMac(String string) {
        this.put("gateway_device", (java.lang.Object)string);
        return this;
    }

    public Optional<Integer> getGatewayIndexForInterVlanRouting() {
        return this.getOptionalInt("gateway_index_for_intervlan_routing");
    }

    public NetworkConf setGatewayIndexForInterVlanRouting(int n2) {
        return this.append("gateway_index_for_intervlan_routing", n2);
    }

    public boolean containsIp(String string) {
        String string2 = this.getString("ip_subnet");
        if (StringUtils.isBlank((CharSequence)string2)) {
            return false;
        }
        SubnetUtils subnetUtils = new SubnetUtils(string2);
        SubnetUtils.SubnetInfo subnetInfo = subnetUtils.getInfo();
        try {
            return subnetInfo.isInRange(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean containsIpv6(String string) {
        String string2 = this.getString("ipv6_subnet");
        if (!Object.\u00d500000(string2)) {
            return false;
        }
        IPv6Network iPv6Network = IPv6Network.fromString((String)string2);
        IPv6AddressRange iPv6AddressRange = IPv6AddressRange.fromFirstAndLast((IPv6Address)iPv6Network.getFirst(), (IPv6Address)iPv6Network.getLast());
        try {
            return iPv6AddressRange.contains(IPv6Address.fromString((String)string));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean containsIpOrIpv6(String string) {
        return this.containsIp(string) || this.containsIpv6(string);
    }

    public static String getDefaultDHCPStartIP(SubnetUtils.SubnetInfo subnetInfo) {
        int n2 = Integer.bitCount(subnetInfo.asInteger(subnetInfo.getNetmask()));
        int n3 = n2 < 25 ? (25 - n2) * 5 : 1;
        int n4 = subnetInfo.asInteger(subnetInfo.getLowAddress());
        int n5 = n4 + n3;
        int[] nArray = new int[4];
        for (int i2 = 3; i2 >= 0; --i2) {
            int n6 = i2;
            nArray[n6] = nArray[n6] | n5 >>> 8 * (3 - i2) & 0xFF;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            stringBuilder.append(nArray[i3]);
            if (i3 == nArray.length - 1) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    public static String getDefaultDHCPStartIP(String string) {
        SubnetUtils subnetUtils = new SubnetUtils(string);
        subnetUtils.setInclusiveHostCount(false);
        SubnetUtils.SubnetInfo subnetInfo = subnetUtils.getInfo();
        return NetworkConf.getDefaultDHCPStartIP(subnetInfo);
    }

    public static String getDefaultDHCPStopIP(String string) {
        SubnetUtils subnetUtils = new SubnetUtils(string);
        subnetUtils.setInclusiveHostCount(false);
        return subnetUtils.getInfo().getHighAddress();
    }

    public Optional<VpnNetworkProtocol> getVpnProtocol() {
        return Q.private(VpnNetworkProtocol.class, this.getString("vpn_protocol"));
    }

    public NetworkConf setVpnProtocol(VpnNetworkProtocol vpnNetworkProtocol) {
        this.put("vpn_protocol", (java.lang.Object)vpnNetworkProtocol.toString());
        return this;
    }

    public NetworkConf setPurpose(@NotNull NetworkPurpose networkPurpose) {
        this.put("purpose", (java.lang.Object)networkPurpose.toString());
        return this;
    }

    public boolean isLocalSiteNetwork() {
        return this.isCorpNetwork() || this.isGuestNetwork();
    }

    public boolean isCorpNetwork() {
        return this.hasNetworkPurpose(NetworkPurpose.CORPORATE);
    }

    public boolean isGuestNetwork() {
        return this.hasNetworkPurpose(NetworkPurpose.GUEST);
    }

    public boolean isLoopback() {
        return \u00d6\u00d3O000.equals(this.getInterfaceName());
    }

    public NetworkGatewayDeviceType getGatewayDeviceType() {
        return this.getOptionalEnum("gateway_type", NetworkGatewayDeviceType.class).orElse(NetworkGatewayDeviceType.DEFAULT);
    }

    public boolean isLayer3Network() {
        return this.isLocalSiteNetwork() && NetworkGatewayDeviceType.SWITCH == this.getGatewayDeviceType();
    }

    public boolean hasDefaultGateway() {
        return NetworkGatewayDeviceType.DEFAULT == this.getGatewayDeviceType();
    }

    public boolean isInterVlanRoutingNetwork() {
        return this.getHiddenId().map(string -> StringUtils.equals((CharSequence)string, (CharSequence)\u00d6\u00d2O000)).orElse(false);
    }

    public NetworkConf setLayer3Network(boolean bl) {
        NetworkGatewayDeviceType networkGatewayDeviceType = bl ? NetworkGatewayDeviceType.SWITCH : NetworkGatewayDeviceType.DEFAULT;
        this.put("gateway_type", (java.lang.Object)networkGatewayDeviceType.toString());
        return this;
    }

    public boolean isSiteToSiteVpnNetwork() {
        return this.hasNetworkPurpose(NetworkPurpose.SITE_VPN);
    }

    public boolean isSiteToSiteVpnWithTrafficRoutesSupport() {
        return this.isSiteOpenVpnNetwork() || this.isSiteIpsecVpnNetwork() && this.isIpsecDynamicRouting() || this.isSdWanTunnelNetwork();
    }

    public boolean isSiteAutoVpnNetwork() {
        return this.isSiteToSiteVpnNetwork() && com.ubnt.model.oO0O.B.B.\u00f600000.equals((java.lang.Object)this.getVpnType().orElse(com.ubnt.model.oO0O.B.B.\u00f600000));
    }

    public boolean isSiteManualVpnNetwork() {
        return this.isSiteToSiteVpnNetwork() && !com.ubnt.model.oO0O.B.B.\u00f600000.equals((java.lang.Object)this.getVpnType().orElse(com.ubnt.model.oO0O.B.B.\u00f600000));
    }

    public boolean isSiteIpsecVpnNetwork() {
        return this.isSiteToSiteVpnNetwork() && this.hasVpnType(com.ubnt.model.oO0O.B.B.float);
    }

    public boolean isPolicyBasedIpsecVpn() {
        return this.isSiteIpsecVpnNetwork() && !this.isIpsecDynamicRouting();
    }

    public boolean isSdWanHubSpokeTunnelNetwork() {
        return this.isSiteToSiteVpnNetwork() && this.hasVpnType(com.ubnt.model.oO0O.B.B.void);
    }

    public boolean isSdWanMeshTunnelNetwork() {
        return this.isSiteToSiteVpnNetwork() && this.hasVpnType(com.ubnt.model.oO0O.B.B.\u00d600000);
    }

    public boolean isSdWanTunnelNetwork() {
        return this.isSiteToSiteVpnNetwork() && (this.isSdWanMeshTunnelNetwork() || this.isSdWanHubSpokeTunnelNetwork());
    }

    public boolean isSiteOpenVpnNetwork() {
        return this.isSiteToSiteVpnNetwork() && this.hasVpnType(com.ubnt.model.oO0O.B.B.\u00f500000);
    }

    public boolean isVpnClientNetwork() {
        return this.hasNetworkPurpose(NetworkPurpose.VPN_CLIENT);
    }

    public boolean isPptpClientNetwork() {
        return this.isVpnClientNetwork() && this.hasVpnType(com.ubnt.model.oO0O.B.B.public);
    }

    public boolean isOpenVpnClientNetwork() {
        return this.isVpnClientNetwork() && this.hasVpnType(com.ubnt.model.oO0O.B.B.\u00d4O0000);
    }

    public boolean isAnyOpenVpn() {
        return this.isOpenVpnServer() || this.isOpenVpnClientNetwork() || this.isSiteOpenVpnNetwork();
    }

    public boolean isRemoteUserWireguardVpnServer() {
        return this.isRemoteUserVpnNetwork() && this.hasVpnType(com.ubnt.model.oO0O.B.B.\u00d200000);
    }

    public boolean isWireguardClient() {
        return this.isVpnClientNetwork() && this.hasVpnType(com.ubnt.model.oO0O.B.B.OO0000);
    }

    public boolean isWireguardClientOrServer() {
        return this.isWireguardVpnServer() || this.isWireguardClient();
    }

    public boolean isRemoteUserVpnNetwork() {
        return this.hasNetworkPurpose(NetworkPurpose.REMOTE_USER_VPN);
    }

    public boolean isRemoteUserL2tpVpnNetwork() {
        return this.isRemoteUserVpnNetwork() && this.hasVpnType(com.ubnt.model.oO0O.B.B.\u00d400000);
    }

    public boolean isRemoteUserPptpVpnNetwork() {
        return this.isRemoteUserVpnNetwork() && this.hasVpnType(com.ubnt.model.oO0O.B.B.Object);
    }

    public boolean isAnyVpn() {
        return this.getVpnType().isPresent();
    }

    public boolean useRadiusProfile() {
        return this.isRemoteUserPptpVpnNetwork() || this.isRemoteUserL2tpVpnNetwork() || this.isRemoteUserOpenVpnServer();
    }

    public boolean isRequireMsChapV2() {
        return this.is("require_mschapv2", false);
    }

    public NetworkConf setRequireMsChapV2(java.lang.Object object) {
        this.put("require_mschapv2", object);
        return this;
    }

    public boolean isRemoteUserOpenVpnServer() {
        return \u00d8\u00d3O000.equals(this.getString("purpose")) && com.ubnt.model.oO0O.B.B.\u00f400000.toString().equals(this.getString("vpn_type"));
    }

    public boolean isUidVpnServer() {
        return this.hasNetworkPurpose(NetworkPurpose.REMOTE_USER_VPN) && this.hasVpnType(com.ubnt.model.oO0O.B.B.\u00d5O0000);
    }

    public boolean isUidOpenVpnServer() {
        return this.isUidVpnServer() && this.getUidVpnType().map(uidVpnType -> uidVpnType == UidVpnType.OPENVPN).orElse(true) != false;
    }

    public boolean isUidWireguardVpnServer() {
        return this.isUidVpnServer() && this.getUidVpnType().map(uidVpnType -> uidVpnType == UidVpnType.WIREGUARD).orElse(false) != false;
    }

    public boolean isWireguardVpnServer() {
        return this.isRemoteUserWireguardVpnServer() || this.isUidWireguardVpnServer();
    }

    public boolean isOpenVpnServer() {
        return this.isRemoteUserOpenVpnServer() || this.isUidOpenVpnServer();
    }

    public boolean hasPrivateIpv4Address() {
        String string = this.getIpv4();
        return StringUtils.isNotEmpty((CharSequence)string) && H.\u00d8\u00d20000(string);
    }

    public NetworkConf setVpnType(com.ubnt.model.oO0O.B.B b2) {
        this.put("vpn_type", (java.lang.Object)b2.toString());
        return this;
    }

    public boolean isCustomInterfaceMtuEnabled() {
        return this.is("interface_mtu_enabled", false);
    }

    public NetworkConf setInterfaceMtuEnabled(boolean bl) {
        return this.append("interface_mtu_enabled", bl);
    }

    public Optional<Integer> getInterfaceMtu() {
        return this.getOptionalInt("interface_mtu");
    }

    public NetworkConf setInterfaceMtu(Integer n2) {
        return this.append("interface_mtu", n2);
    }

    public Optional<String> getIpsecKeyExchange() {
        return Optional.ofNullable(this.getString("ipsec_key_exchange"));
    }

    @Deprecated
    public Optional<A> getIpsecEncryption() {
        return Q.private(A.class, this.getString("ipsec_encryption"));
    }

    @Deprecated
    public NetworkConf setIpsecEncryption(A a2) {
        return this.append("ipsec_encryption", a2.toString());
    }

    public Optional<A> getIpsecIkeEncryption() {
        return Q.private(A.class, this.getString("ipsec_ike_encryption"));
    }

    public NetworkConf setIpsecIkeEncryption(A a2) {
        return this.append("ipsec_ike_encryption", a2.toString());
    }

    @Deprecated
    public Optional<class> getIpsecHash() {
        return Q.private(class.class, this.getString("ipsec_hash"));
    }

    @Deprecated
    public NetworkConf setIpsecHash(class clazz) {
        return this.append("ipsec_hash", (java.lang.Object)clazz);
    }

    public Optional<class> getIpsecIkeHash() {
        return Q.private(class.class, this.getString("ipsec_ike_hash"));
    }

    public NetworkConf setIpsecIkeHash(class clazz) {
        return this.append("ipsec_ike_hash", clazz.toString());
    }

    public Optional<Integer> getIpsecIkeLifetime() {
        return this.getOptionalInt("ipsec_ike_lifetime");
    }

    public NetworkConf setIpsecIkeLifetime(int n2) {
        return this.append("ipsec_ike_lifetime", n2);
    }

    public Optional<String> getIpsecPreSharedKey() {
        return this.getOptionalString("x_ipsec_pre_shared_key").filter(StringUtils::isNotEmpty);
    }

    public Optional<Integer> getIpsecEspDhGroup() {
        return this.getOptionalInt("ipsec_esp_dh_group");
    }

    public NetworkConf setIpsecEspDhGroup(int n2) {
        return this.append("ipsec_esp_dh_group", n2);
    }

    public Optional<A> getIpsecEspEncryption() {
        return Q.private(A.class, this.getString("ipsec_esp_encryption"));
    }

    public NetworkConf setIpsecEspEncryption(A a2) {
        return this.append("ipsec_esp_encryption", a2.toString());
    }

    public Optional<class> getIpsecEspHash() {
        return Q.private(class.class, this.getString("ipsec_esp_hash"));
    }

    public NetworkConf setIpsecEspHash(class clazz) {
        return this.append("ipsec_esp_hash", clazz.toString());
    }

    public Optional<Integer> getIpsecEspLifetime() {
        return this.getOptionalInt("ipsec_esp_lifetime");
    }

    public NetworkConf setIpsecEspLifetime(int n2) {
        return this.append("ipsec_esp_lifetime", n2);
    }

    public Optional<Integer> getIpsecIkeDhGroup() {
        return this.getOptionalInt("ipsec_ike_dh_group");
    }

    public NetworkConf setIpsecIkeDhGroup(int n2) {
        return this.append("ipsec_ike_dh_group", n2);
    }

    public NetworkConf setIpsecPreSharedKey(String string) {
        this.put("x_ipsec_pre_shared_key", (java.lang.Object)string);
        return this;
    }

    public NetworkConf setIpsecKeyExchange(String string) {
        this.put("ipsec_key_exchange", (java.lang.Object)string);
        return this;
    }

    public boolean isIpsecLocalIdentifierEnabled() {
        return this.is("ipsec_local_identifier_enabled", false);
    }

    public NetworkConf setIpsecLocalIdentifierEnabled(boolean bl) {
        return this.append("ipsec_local_identifier_enabled", bl);
    }

    public Optional<String> getIpsecLocalIdentifier() {
        return Optional.ofNullable(this.getString("ipsec_local_identifier"));
    }

    public NetworkConf setIpsecLocalIdentifier(String string) {
        return this.append("ipsec_local_identifier", string);
    }

    public boolean isIpsecPerfectForwardSecrecy() {
        return this.is("ipsec_pfs", false);
    }

    public NetworkConf setIpsecPerfectForwardSecrecy(boolean bl) {
        return this.append("ipsec_pfs", bl);
    }

    public boolean isIpsecRemoteIdentifierEnabled() {
        return this.is("ipsec_remote_identifier_enabled", false);
    }

    public NetworkConf setIpsecRemoteIdentifierEnabled(boolean bl) {
        return this.append("ipsec_remote_identifier_enabled", bl);
    }

    public Optional<String> getIpsecRemoteIdentifier() {
        return Optional.ofNullable(this.getString("ipsec_remote_identifier"));
    }

    public NetworkConf setIpsecRemoteIdentifier(String string) {
        return this.append("ipsec_remote_identifier", string);
    }

    public boolean isIpsecTunnelIpEnabled() {
        return this.is("ipsec_tunnel_ip_enabled", false);
    }

    public NetworkConf setIpsecTunnelIpEnabled(boolean bl) {
        return this.append("ipsec_tunnel_ip_enabled", bl);
    }

    public Optional<String> getIpsecTunnelIp() {
        return this.getOptionalString("ipsec_tunnel_ip");
    }

    public NetworkConf setIpsecTunnelIp(String string) {
        return this.append("ipsec_tunnel_ip", string);
    }

    public List<String> getRemoteVpnSubnets() {
        return this.getStringList("remote_vpn_subnets");
    }

    public NetworkConf setRemoteVpnSubnets(List<String> list) {
        this.put("remote_vpn_subnets", list);
        return this;
    }

    public boolean isRemoteVpnDynamicSubnetsEnabled() {
        return this.is("remote_vpn_dynamic_subnets_enabled", false);
    }

    public NetworkConf setRemoteVpnDynamicSubnetsEnabled(boolean bl) {
        return this.append("remote_vpn_dynamic_subnets_enabled", bl);
    }

    public boolean isVlanEnabled() {
        return this.is("vlan_enabled", false);
    }

    public NetworkConf setVlanEnabled(boolean bl) {
        this.put("vlan_enabled", (java.lang.Object)bl);
        return this;
    }

    public boolean isVlanOnlyNetwork() {
        return \u00f50O000.equals(this.getString("purpose"));
    }

    public boolean isWanNetwork() {
        return \u00d5\u00f50000.equals(this.getString("purpose"));
    }

    public boolean isAnyWanNetwork() {
        return this.isWanNetwork() || this.isWanMagicNetwork();
    }

    public boolean isRouteNetwork() {
        return \u00d6\u00d2O000.equals(this.getString("attr_hidden_id"));
    }

    public boolean isLteWanFailoverNetwork() {
        return \u00d5\u00f50000.equals(this.getString("purpose")) && \u00f8\u00d2O000.equals(this.getString("attr_hidden_id"));
    }

    public boolean isMobileBroadbandNetwork() {
        return this.isLteWanFailoverNetwork() || this.isWan5gNetwork();
    }

    public boolean isDsLiteNetwork() {
        return this.getWanType().flatMap(WanType::of).filter(WanType::isDsLiteType).isPresent();
    }

    public boolean isMapENetwork() {
        List<WanType> list = List.of(WanType.MAP_E, WanType.MAP_E_JPIX, WanType.MAP_E_NTT);
        return this.getWanType().flatMap(WanType::of).filter(list::contains).isPresent();
    }

    public boolean isDsLiteOverPppoeNetwork() {
        return this.getWanType().flatMap(WanType::of).filter(wanType -> wanType == WanType.DSLITE_OVER_PPPOE).isPresent();
    }

    public boolean is4in6Network() {
        return this.isDsLiteNetwork() || this.isMapENetwork();
    }

    public boolean isLteLanEnabled() {
        return this.is("lte_lan_enabled", false);
    }

    public NetworkConf setLteLanEnabled(boolean bl) {
        this.put("lte_lan_enabled", (java.lang.Object)bl);
        return this;
    }

    public boolean couldBeNativeNetwork() {
        return this.isLocalSiteLayer2Network() && !this.isInterVlanRoutingNetwork();
    }

    public boolean isLocalSiteLayer2Network() {
        return this.isLocalSiteNetwork() || this.isVlanOnlyNetwork();
    }

    public boolean isDefaultLocalSiteLayer2Network() {
        return this.isLocalSiteNetwork() && "LAN".equals(this.getString("attr_hidden_id"));
    }

    public boolean inNetworkGroup(String string) {
        return StringUtils.equals((CharSequence)this.getNetworkGroup(), (CharSequence)string);
    }

    public static int getNetworkGroupInternalVlan(String string) {
        if (string.equals("LAN")) {
            return 1;
        }
        if (string.equals(privatereturn)) {
            return 4012;
        }
        if (string.equals(\u00d3\u00f50000)) {
            return 4013;
        }
        if (string.equals(o\u00f50000)) {
            return 4014;
        }
        if (string.equals(Stringfor)) {
            return 4015;
        }
        if (string.equals(\u00d3\u00d4O000)) {
            return 4016;
        }
        if (string.equals(\u00d2\u00d4O000)) {
            return 4017;
        }
        if (string.equals(o\u00d4O000)) {
            return 4018;
        }
        return 1;
    }

    public NetworkConf setVlan(int n2) {
        this.put("vlan", (java.lang.Object)n2);
        return this;
    }

    public int getVlan() {
        int n2 = this.getInt("vlan", 1);
        if (this.isVlanEnabled() && n2 > 1 && n2 < 4094) {
            return n2;
        }
        String string = this.getString("networkgroup", "unknown");
        return NetworkConf.getNetworkGroupInternalVlan(string);
    }

    public NetworkConf toConfigNetworkWan() {
        NetworkConf networkConf = new NetworkConf();
        for (String string : this.keySet()) {
            if (string.startsWith("wan_")) {
                networkConf.put(string.substring(4), this.get(string, null));
                continue;
            }
            networkConf.put(string, this.get(string, null));
        }
        String string = networkConf.getString("x_wan_password");
        if (StringUtils.isNotEmpty((CharSequence)string)) {
            networkConf.put("x_password", (java.lang.Object)string);
        }
        if (networkConf.containsField("dhcpv6_pd_size")) {
            networkConf.put("dhcpv6_pd_size", (java.lang.Object)networkConf.getInt("dhcpv6_pd_size"));
        }
        if (this.isLteWanFailoverNetwork()) {
            networkConf.put("type", (java.lang.Object)"lte-failover");
        }
        return networkConf;
    }

    public int getPriority() {
        int n2 = this.getInt("priority", -1);
        return n2;
    }

    public NetworkConf setLanTunnelIpAddress(String string) {
        if (this.isLanTunnelWanNetwork() && Object.\u00f5\u00f40000(string)) {
            this.put("ip_subnet", (java.lang.Object)(string + "/30"));
        }
        return this;
    }

    public String getLTETunnelAddrCidr() {
        if (!this.isLanTunnelWanNetwork()) {
            return null;
        }
        return H.while(this.getString("wan_ip"), this.getString("wan_netmask"));
    }

    public static boolean isIpsecInUse(List<NetworkConf> list) {
        for (NetworkConf networkConf : list) {
            if (!networkConf.isSiteAutoVpnNetwork() && !networkConf.isSiteIpsecVpnNetwork() && !networkConf.isRemoteUserL2tpVpnNetwork()) continue;
            return true;
        }
        return false;
    }

    public void populateSmartQueueFromProviderCapabilities(Setting setting) {
        if (this.containsField("wan_smartq_enabled")) {
            \u00f8\u00d3O000.warn("Not populating smart queues for network (name={}) since setting has been touched.", (java.lang.Object)this.getString("name"));
            return;
        }
        if (!setting.containsField("upload") || !setting.containsField("download")) {
            \u00f8\u00d3O000.warn("Not populating smart queues for network (name={}) since provider capabilities is missing upload or download field: {}", (java.lang.Object)this.getString("name"), (java.lang.Object)setting);
            return;
        }
        int n2 = Math.min(1000000, setting.getInt("upload"));
        int n3 = Math.min(1000000, setting.getInt("download"));
        if (n2 > 300000 || n3 > 300000) {
            \u00f8\u00d3O000.warn("Not populating smart queues for network (name={}) since upload ({}) or download ({}) rate is too high", new java.lang.Object[]{this.getString("name"), n2, n3});
            return;
        }
        this.put("wan_smartq_enabled", (java.lang.Object)true);
        this.put("wan_smartq_up_rate", (java.lang.Object)this.getInt("wan_smartq_up_rate", (int)Math.ceil((double)n2 * 0.8)));
        this.put("wan_smartq_down_rate", (java.lang.Object)this.getInt("wan_smartq_down_rate", (int)Math.ceil((double)n3 * 0.8)));
        \u00f8\u00d3O000.warn("Auto populating smart queues for network (name={}, upload rate={}, download rate={})", new java.lang.Object[]{this.getString("name"), this.getInt("wan_smartq_up_rate"), this.getInt("wan_smartq_down_rate")});
    }

    public String getName() {
        return this.getString("name", "");
    }

    public NetworkConf setName(String string) {
        this.put("name", (java.lang.Object)string);
        return this;
    }

    @Override
    public boolean isEnabled() {
        return this.is("enabled", true);
    }

    public NetworkConf setEnabled(boolean bl) {
        this.put("enabled", (java.lang.Object)bl);
        return this;
    }

    public Optional<Long> getDataUsageLimitInBytes() {
        return this.getOptionalLong("data_usage_limit_in_bytes");
    }

    public NetworkConf setDataUsageLimitInBytes(long l2) {
        this.put("data_usage_limit_in_bytes", (java.lang.Object)l2);
        return this;
    }

    public boolean isDataUsageLimitReachAlertEnabled() {
        return this.is("data_usage_limit_reached_alert", false);
    }

    public NetworkConf setDataUsageLimitReachAlert(boolean bl) {
        this.put("data_usage_limit_reached_alert", (java.lang.Object)bl);
        return this;
    }

    public Optional<SettingPreference> getSettingPreference() {
        return Q.private(SettingPreference.class, this.getString("setting_preference"));
    }

    public Optional<SettingPreference> getIpv6SettingPreference() {
        return Q.private(SettingPreference.class, this.getString("ipv6_setting_preference"));
    }

    public NetworkConf setIpv6SettingPreference(SettingPreference settingPreference) {
        this.put("ipv6_setting_preference", (java.lang.Object)settingPreference.getValue());
        return this;
    }

    public NetworkConf setSettingPreference(SettingPreference settingPreference) {
        this.put("setting_preference", (java.lang.Object)settingPreference.getValue());
        return this;
    }

    @Override
    public boolean hasAutoSettingPreference() {
        return this.getSettingPreference().orElse(SettingPreference.super) == SettingPreference.\u00d300000;
    }

    @Override
    public boolean hasManualSettingPreference() {
        return this.getSettingPreference().orElse(SettingPreference.super) == SettingPreference.super;
    }

    public boolean hasIpv6AutoSettingPreference() {
        return this.getIpv6SettingPreference().orElse(SettingPreference.super) == SettingPreference.\u00d300000;
    }

    public boolean hasIpv6ManualSettingPreference() {
        return this.getIpv6SettingPreference().orElse(SettingPreference.super) == SettingPreference.super;
    }

    public List<String> getRemoteSubnets() {
        if (this.isSiteAutoVpnNetwork()) {
            return this.getRemoteSiteSubnets();
        }
        if (this.isSiteManualVpnNetwork() || this.isVpnClientNetwork() || this.isSdWanMeshTunnelNetwork()) {
            return this.getRemoteVpnSubnets();
        }
        return Collections.emptyList();
    }

    public List<String> getRemoteSiteSubnets() {
        return this.getStringList("remote_site_subnets");
    }

    public NetworkConf setRemoteSiteSubnets(List<String> list) {
        return this.append("remote_site_subnets", list);
    }

    public boolean isAutoScaleNetworkEnabled() {
        return this.is("auto_scale_enabled", false);
    }

    public NetworkConf setAutoScaleNetworkEnabled(boolean bl) {
        this.put("auto_scale_enabled", (java.lang.Object)bl);
        return this;
    }

    @Override
    public String getId() {
        return this.getString("_id");
    }

    public NetworkConf setId(String string) {
        this.put("_id", (java.lang.Object)string);
        return this;
    }

    public Optional<String> getHiddenId() {
        return Optional.ofNullable(this.getString("attr_hidden_id"));
    }

    public NetworkConf setHiddenId(String string) {
        this.put("attr_hidden_id", (java.lang.Object)string);
        return this;
    }

    @Override
    public UUID getExternalId() {
        return this.getUUID("external_id");
    }

    public NetworkConf setExternalId(UUID uUID) {
        this.put("external_id", (java.lang.Object)uUID);
        return this;
    }

    public NetworkConf setNoDelete(boolean bl) {
        this.put("attr_no_delete", (java.lang.Object)bl);
        return this;
    }

    public NetworkConf setNoEdit(boolean bl) {
        this.put("attr_no_edit", (java.lang.Object)bl);
        return this;
    }

    public boolean isNoDeletable() {
        return this.is("attr_no_delete", false);
    }

    public String getSiteId() {
        return this.getString("site_id");
    }

    public NetworkConf setSiteId(String string) {
        this.put("site_id", (java.lang.Object)string);
        return this;
    }

    public Optional<String> getInterfaceNameOptional() {
        return this.getOptionalString("ifname");
    }

    public String getInterfaceName() {
        return this.getString("ifname");
    }

    public NetworkConf setInterfaceName(String string) {
        this.put("ifname", (java.lang.Object)string);
        return this;
    }

    public List<X> getWanDhcpOptions() {
        return this.getList("wan_dhcp_options", Collections.emptyList());
    }

    public NetworkConf setWanDhcpOptions(List<X> list) {
        this.put("wan_dhcp_options", list);
        return this;
    }

    public Optional<String> getWanIp() {
        return Optional.ofNullable(this.getString("wan_ip"));
    }

    public NetworkConf setWanIp(String string) {
        this.put("wan_ip", (java.lang.Object)string);
        return this;
    }

    public List<String> getWanIpAliases() {
        return this.getStringList("wan_ip_aliases");
    }

    public NetworkConf setWanIpAliases(List<String> list) {
        this.put("wan_ip_aliases", list);
        return this;
    }

    public List<String> getLanIpAliases() {
        return this.getStringList("ip_aliases");
    }

    public NetworkConf setLanIpAliases(List<String> list) {
        this.put("ip_aliases", list);
        return this;
    }

    public List<String> getLanIpv6Aliases() {
        return this.getStringList("ipv6_aliases");
    }

    public NetworkConf setLanIpv6Aliases(List<String> list) {
        this.put("ipv6_aliases", list);
        return this;
    }

    public boolean supportsWanIpAliases() {
        return this.getWanType().map(string -> StringUtils.equalsAny((CharSequence)string, (CharSequence[])new CharSequence[]{WanType.STATIC.toString(), WanType.PPPOE.toString()})).orElse(false);
    }

    public boolean supportsOspf() {
        return this.isLocalSiteNetwork() || this.isWanNetwork() && this.isStaticWan() || this.isOpenVpnServer() || this.isOpenVpnClientNetwork() || this.isWireguardClientOrServer() || this.isSiteIpsecVpnNetwork() && this.isIpsecTunnelIpEnabled();
    }

    public Optional<String> getWanGateway() {
        return Optional.ofNullable(this.getString("wan_gateway"));
    }

    public NetworkConf setWanGateway(String string) {
        this.put("wan_gateway", (java.lang.Object)string);
        return this;
    }

    public Optional<String> getWanGatewayV6() {
        return this.getOptionalString("wan_gateway_v6");
    }

    public Optional<String> getWanNetmask() {
        return this.getOptionalString("wan_netmask");
    }

    public NetworkConf setWanNetmask(String string) {
        this.put("wan_netmask", (java.lang.Object)string);
        return this;
    }

    public com.ubnt.model.o0oO.A getWanProviderCapabilities() {
        return com.ubnt.model.o0oO.A.\u00d500000(this.getX("wan_provider_capabilities", X.newObject));
    }

    public NetworkConf setWanProviderCapabilities(com.ubnt.model.o0oO.A a2) {
        this.put("wan_provider_capabilities", (java.lang.Object)a2.new());
        return this;
    }

    public List<X> getLegacyNatOutboundIpAddresses() {
        return this.getList("nat_outbound_ip_addresses");
    }

    public List<com.ubnt.model.o0oO.B> getNatOutboundIpAddresses() {
        return this.getLegacyNatOutboundIpAddresses().stream().map(com.ubnt.model.o0oO.B::\u00f600000).toList();
    }

    public NetworkConf setNatOutboundIpAddresses(List<com.ubnt.model.o0oO.B> list) {
        List list2 = list.stream().map(com.ubnt.model.o0oO.B::\u00f400000).collect(Collectors.toList());
        this.put("nat_outbound_ip_addresses", list2);
        return this;
    }

    public Optional<String> getWanType() {
        return Optional.ofNullable(this.getString("wan_type"));
    }

    public Optional<WanType> getWanTypeOptional() {
        return this.getWanType().flatMap(WanType::of);
    }

    public NetworkConf setWanType(String string) {
        this.put("wan_type", (java.lang.Object)string);
        return this;
    }

    public NetworkConf setWanType(WanType wanType) {
        this.put("wan_type", (java.lang.Object)wanType.toString());
        return this;
    }

    public boolean hasWanType(WanType wanType) {
        return this.getWanType().filter(string -> string.equals(wanType.toString())).isPresent();
    }

    public boolean isWanTypeV6(WanTypeV6 wanTypeV6) {
        return this.getWanTypeV6().filter(string -> string.equals(wanTypeV6.toString())).isPresent();
    }

    public boolean isIpv6WanDelegationType(Ipv6WanDelegationType ipv6WanDelegationType) {
        return this.getIpv6WanDelegationTypeOptional().filter(ipv6WanDelegationType2 -> ipv6WanDelegationType2 == ipv6WanDelegationType).isPresent();
    }

    public boolean isStaticWan() {
        return this.getWanType().map(string -> StringUtils.equals((CharSequence)string, (CharSequence)WanType.STATIC.toString())).orElse(false);
    }

    public boolean isStaticWanV6() {
        return this.getWanTypeV6().map(string -> StringUtils.equals((CharSequence)string, (CharSequence)WanTypeV6.STATIC.toString())).orElse(false);
    }

    public Optional<String> getWanTypeV6() {
        return Optional.ofNullable(this.getString("wan_type_v6"));
    }

    public Optional<WanTypeV6> getWanTypeV6Optional() {
        return this.getWanTypeV6().flatMap(WanTypeV6::ofStringValueOptional);
    }

    public NetworkConf setWanTypeV6(WanTypeV6 wanTypeV6) {
        this.put("wan_type_v6", (java.lang.Object)wanTypeV6);
        return this;
    }

    private Optional<String> \u00d8\u00d50000() {
        return Optional.ofNullable(this.getString("ipv6_wan_delegation_type"));
    }

    public Optional<Ipv6WanDelegationType> getIpv6WanDelegationTypeOptional() {
        return this.\u00d8\u00d50000().flatMap(Ipv6WanDelegationType::ofStringValueOptional);
    }

    public NetworkConf setIpv6WanDelegationType(Ipv6WanDelegationType ipv6WanDelegationType) {
        this.put("ipv6_wan_delegation_type", (java.lang.Object)ipv6WanDelegationType);
        return this;
    }

    public Optional<String> getSingleNetworkLan() {
        return Optional.ofNullable(this.getString("single_network_lan"));
    }

    public Optional<String> getWanDsLiteRemoteHost() {
        return Optional.ofNullable(this.getString("wan_dslite_remote_host"));
    }

    public boolean getWanDsLiteRemoteHostAuto() {
        if (this.isDsLiteNetwork()) {
            return this.is("wan_dslite_remote_host_auto", false);
        }
        return this.isMapENetwork();
    }

    public NetworkConf setWanDsLiteRemoteHost(String string) {
        this.put("wan_dslite_remote_host", (java.lang.Object)string);
        return this;
    }

    public NetworkConf setWanDsLiteRemoteHostAuto(boolean bl) {
        this.put("wan_dslite_remote_host_auto", (java.lang.Object)bl);
        return this;
    }

    public Optional<String> getIpsecInterface() {
        return Optional.ofNullable(this.getString("ipsec_interface"));
    }

    public NetworkConf setIpsecInterface(String string) {
        this.put("ipsec_interface", (java.lang.Object)string);
        return this;
    }

    public boolean isIpsecDynamicRouting() {
        return this.is("ipsec_dynamic_routing", false);
    }

    public NetworkConf setIpsecDynamicRouting(boolean bl) {
        this.put("ipsec_dynamic_routing", (java.lang.Object)bl);
        return this;
    }

    public Optional<String> getIpsecLocalIp() {
        return Optional.ofNullable(this.getString("ipsec_local_ip"));
    }

    public NetworkConf setIpsecLocalIp(String string) {
        this.put("ipsec_local_ip", (java.lang.Object)string);
        return this;
    }

    @Deprecated
    public boolean isVpnType(com.ubnt.model.oO0O.B.B b2) {
        return this.hasVpnType(b2);
    }

    public Optional<String> getIpsecPeerIp() {
        return this.getOptionalString("ipsec_peer_ip");
    }

    public NetworkConf setIpsecPeerIp(String string) {
        this.put("ipsec_peer_ip", (java.lang.Object)string);
        return this;
    }

    public Optional<com.ubnt.model.oO0O.B.B> getVpnType() {
        return this.getOptionalEnum("vpn_type", com.ubnt.model.oO0O.B.B.class);
    }

    public boolean hasVpnType(com.ubnt.model.oO0O.B.B b2) {
        return b2.equals(this.getVpnType().orElse(null));
    }

    public Optional<UidVpnType> getUidVpnType() {
        return Q.private(UidVpnType.class, this.getString("uid_vpn_type"));
    }

    public NetworkConf setUidVpnType(UidVpnType uidVpnType) {
        return this.append("uid_vpn_type", uidVpnType.toString());
    }

    public NetworkConf setVpnType(String string) {
        this.put("vpn_type", (java.lang.Object)string);
        return this;
    }

    public Optional<String> getRadiusProfileId() {
        return Optional.ofNullable(this.getString("radiusprofile_id"));
    }

    public NetworkConf setRadiusProfileId(String string) {
        this.put("radiusprofile_id", (java.lang.Object)string);
        return this;
    }

    public Optional<String> getL2tpInterface() {
        return Optional.ofNullable(this.getString("l2tp_interface"));
    }

    public NetworkConf setL2tpInterface(String string) {
        this.put("l2tp_interface", (java.lang.Object)string);
        return this;
    }

    public Optional<String> getL2tpLocalWanIp() {
        return Optional.ofNullable(this.getString("l2tp_local_wan_ip"));
    }

    public NetworkConf setL2tpLocalWanIp(String string) {
        this.put("l2tp_local_wan_ip", (java.lang.Object)string);
        return this;
    }

    public Optional<String> getDomainName() {
        return Optional.ofNullable(this.getString("domain_name"));
    }

    public String getDomainNameWithDefault() {
        return this.getDomainName().orElse(this.isVlanEnabled() ? "" : \u00d2\u00f60000);
    }

    public NetworkConf setDomainName(String string) {
        this.put("domain_name", (java.lang.Object)string);
        return this;
    }

    public boolean isReportWanEvent() {
        return this.is("report_wan_event", false);
    }

    public NetworkConf setReportWanEvent(boolean bl) {
        this.put("report_wan_event", (java.lang.Object)bl);
        return this;
    }

    public boolean isWanVlanEnabled() {
        return this.is("wan_vlan_enabled", false);
    }

    public NetworkConf setWanVlanEnabled(boolean bl) {
        this.put("wan_vlan_enabled", (java.lang.Object)bl);
        return this;
    }

    public Optional<Integer> getWanVlan() {
        return Optional.ofNullable(this.getIntOrNull("wan_vlan"));
    }

    public NetworkConf setWanVlan(int n2) {
        this.put("wan_vlan", (java.lang.Object)n2);
        return this;
    }

    public boolean isWanSmartqEnabled() {
        return this.is("wan_smartq_enabled", false);
    }

    public NetworkConf setWanSmartqEnabled(boolean bl) {
        this.put("wan_smartq_enabled", (java.lang.Object)bl);
        return this;
    }

    public Optional<Integer> getWanSmartqDownRate() {
        return this.getOptionalInt("wan_smartq_down_rate");
    }

    public Optional<Integer> getEffectiveWanSmartqDownRate() {
        return this.o\u00d60000(this::getWanSmartqDownRate);
    }

    public Optional<Integer> getEffectiveWanSmartqDownRate(int n2) {
        return this.getEffectiveWanSmartqDownRate().map(n3 -> n2 > 0 ? Math.min(n3, n2) : n3);
    }

    public NetworkConf setWanSmartqDownRate(int n2) {
        this.put("wan_smartq_down_rate", (java.lang.Object)n2);
        return this;
    }

    public Optional<Integer> getWanSmartqUpRate() {
        return this.getOptionalInt("wan_smartq_up_rate");
    }

    public Optional<Integer> getEffectiveWanSmartqUpRate() {
        return this.o\u00d60000(this::getWanSmartqUpRate);
    }

    public Optional<Integer> getEffectiveWanSmartqUpRate(int n2) {
        return this.getEffectiveWanSmartqUpRate().map(n3 -> n2 > 0 ? Math.min(n3, n2) : n3);
    }

    public NetworkConf setWanSmartqUpRate(int n2) {
        this.put("wan_smartq_up_rate", (java.lang.Object)n2);
        return this;
    }

    private Optional<Integer> o\u00d60000(Supplier<Optional<Integer>> supplier) {
        return supplier.get().filter(n2 -> this.isWanSmartqEnabled()).filter(n2 -> n2 > 0);
    }

    public Optional<WanDnsPreference> getWanDnsPreference() {
        return Q.private(WanDnsPreference.class, this.getString("wan_dns_preference"));
    }

    public boolean hasAutoDnsPreference() {
        return this.getWanDnsPreference().orElse(WanDnsPreference.MANUAL) == WanDnsPreference.AUTO;
    }

    public boolean hasManualDnsPreference() {
        return this.getWanDnsPreference().orElse(WanDnsPreference.MANUAL) == WanDnsPreference.MANUAL;
    }

    public NetworkConf setWanDnsPreference(WanDnsPreference wanDnsPreference) {
        this.put("wan_dns_preference", (java.lang.Object)wanDnsPreference.toString());
        return this;
    }

    public Optional<String> getWanDns1() {
        return Optional.ofNullable(this.getString("wan_dns1"));
    }

    public NetworkConf setWanDns1(String string) {
        this.put("wan_dns1", (java.lang.Object)string);
        return this;
    }

    public Optional<String> getWanDns2() {
        return Optional.ofNullable(this.getString("wan_dns2"));
    }

    public NetworkConf setWanDns2(String string) {
        this.put("wan_dns2", (java.lang.Object)string);
        return this;
    }

    public NetworkConf setDhcpdIp(int n2, String string) {
        this.put("dhcpd_ip_" + n2, (java.lang.Object)string);
        return this;
    }

    public List<String> getDhcpdIpList() {
        return this.getPrefixedList("dhcpd_ip");
    }

    public NetworkConf setDhcpdNtp(int n2, String string) {
        this.put("dhcpd_ntp_" + n2, (java.lang.Object)string);
        return this;
    }

    public List<String> getNtpIpList() {
        return this.getPrefixedList("dhcpd_ntp");
    }

    public NetworkConf setDhcpdWins(int n2, String string) {
        this.put("dhcpd_wins_" + n2, (java.lang.Object)string);
        return this;
    }

    public NetworkConf setDhcpdDns(int n2, String string) {
        this.put("dhcpd_dns_" + n2, (java.lang.Object)string);
        return this;
    }

    public NetworkConf setDhcpdMac(int n2, String string) {
        this.put("dhcpd_mac_" + n2, (java.lang.Object)string);
        return this;
    }

    public Optional<String> getDhcpdDns1() {
        return this.getOptionalString("dhcpd_dns_1");
    }

    public NetworkConf setDhcpdDns1(String string) {
        this.put("dhcpd_dns_1", (java.lang.Object)string);
        return this;
    }

    public Optional<String> getDhcpdDns2() {
        return this.getOptionalString("dhcpd_dns_2");
    }

    public NetworkConf setDhcpdDns2(String string) {
        this.put("dhcpd_dns_2", (java.lang.Object)string);
        return this;
    }

    public Optional<String> getDhcpdDns3() {
        return this.getOptionalString("dhcpd_dns_3");
    }

    public NetworkConf setDhcpdDns3(String string) {
        this.put("dhcpd_dns_3", (java.lang.Object)string);
        return this;
    }

    public Optional<String> getDhcpdDns4() {
        return this.getOptionalString("dhcpd_dns_4");
    }

    public NetworkConf setDhcpdDns4(String string) {
        this.put("dhcpd_dns_4", (java.lang.Object)string);
        return this;
    }

    public boolean isOpenvpnStrictClientCommonName() {
        return this.is("openvpn_strict_client_common_name", false);
    }

    public NetworkConf setOpenvpnStrictClientCommonName(boolean bl) {
        this.put("openvpn_strict_client_common_name", (java.lang.Object)bl);
        return this;
    }

    public boolean isDhcpdDnsEnabled() {
        return this.is("dhcpd_dns_enabled", false);
    }

    public NetworkConf setDhcpdDnsEnabled(boolean bl) {
        this.put("dhcpd_dns_enabled", (java.lang.Object)bl);
        return this;
    }

    public boolean isIgmpSnooping() {
        return this.is("igmp_snooping", false);
    }

    public NetworkConf setIgmpSnooping(boolean bl) {
        this.put("igmp_snooping", (java.lang.Object)bl);
        return this;
    }

    public boolean isFloodUnknownMulticastEnabled() {
        return this.is("igmp_flood_unknown_multicast", false);
    }

    public NetworkConf setFloodUnknownMulticastEnabled(boolean bl) {
        this.put("igmp_flood_unknown_multicast", (java.lang.Object)bl);
        return this;
    }

    public NetworkConf setIgmpFastLeaveEnabled(boolean bl) {
        this.put("igmp_fastleave", (java.lang.Object)bl);
        return this;
    }

    public List<X> getIgmpQuerierSwitches() {
        return this.getList("igmp_querier_switches", Collections.emptyList());
    }

    public NetworkConf setIgmpQuerierSwitches(List<X> list) {
        this.put("igmp_querier_switches", list);
        return this;
    }

    public EnabledFor getIgmpProxyEnabledFor() {
        return Q.private(EnabledFor.class, this.getString("igmp_proxy_for")).orElse(EnabledFor.NONE);
    }

    public NetworkConf setIgmpProxyEnabledFor(EnabledFor enabledFor) {
        this.append("igmp_proxy_for", enabledFor.toString());
        return this;
    }

    public List<String> getIgmpProxyDownstreamNetworkIds() {
        return this.getStringList("igmp_proxy_downstream_networkconf_ids");
    }

    public NetworkConf setIgmpProxyDownstreamNetworkIds(List<String> list) {
        this.put("igmp_proxy_downstream_networkconf_ids", list);
        return this;
    }

    public boolean isIgmpProxyUpstream() {
        return this.is("igmp_proxy_upstream", false);
    }

    public NetworkConf setIgmpProxyUpstream(boolean bl) {
        this.put("igmp_proxy_upstream", (java.lang.Object)bl);
        return this;
    }

    public Optional<SubnetUtils.SubnetInfo> getIpSubnetInfo() {
        return this.getOptionalString("ip_subnet").flatMap(H::\u00f5\u00d20000);
    }

    public boolean isDhcpdEnabled() {
        return this.is("dhcpd_enabled", false);
    }

    public NetworkConf setDhcpdEnabled(boolean bl) {
        this.put("dhcpd_enabled", (java.lang.Object)bl);
        return this;
    }

    public boolean isDhcpRelayEnabled() {
        return this.is("dhcp_relay_enabled", false);
    }

    public NetworkConf setDhcpRelayEnabled(boolean bl) {
        this.put("dhcp_relay_enabled", (java.lang.Object)bl);
        return this;
    }

    public List<String> getDhcpRelayServers() {
        return this.getStringList("dhcp_relay_servers");
    }

    public NetworkConf setDhcpRelayServers(List<String> list) {
        this.put("dhcp_relay_servers", list);
        return this;
    }

    public boolean isDhcpGuardEnabled() {
        return this.is("dhcpguard_enabled", false);
    }

    public NetworkConf setDhcpGuardEnabled(boolean bl) {
        this.put("dhcpguard_enabled", (java.lang.Object)bl);
        return this;
    }

    public int getDhcpdLeasetime() {
        return this.getInt("dhcpd_leasetime", 86400);
    }

    public NetworkConf setDhcpdLeasetime(int n2) {
        this.put("dhcpd_leasetime", (java.lang.Object)n2);
        return this;
    }

    public Optional<String> getDhcpdStart() {
        return Optional.ofNullable(this.getString("dhcpd_start"));
    }

    public NetworkConf setDhcpdStart(String string) {
        this.put("dhcpd_start", (java.lang.Object)string);
        return this;
    }

    public Optional<String> getDhcpdStop() {
        return Optional.ofNullable(this.getString("dhcpd_stop"));
    }

    public List<String> getDhcpdDnsPrefixedList() {
        return this.getPrefixedList("dhcpd_dns").stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public NetworkConf setDhcpdStop(String string) {
        this.put("dhcpd_stop", (java.lang.Object)string);
        return this;
    }

    public boolean isDhcpdV6Enabled() {
        return this.is("dhcpdv6_enabled", false);
    }

    public NetworkConf setDhcpdV6Enabled(boolean bl) {
        this.put("dhcpdv6_enabled", (java.lang.Object)bl);
        return this;
    }

    public NetworkConf setDhcpdv6Start(String string) {
        this.put("dhcpdv6_start", (java.lang.Object)string);
        return this;
    }

    public String getDhcpdv6Start() {
        return this.getString("dhcpdv6_start", "::2");
    }

    public NetworkConf setDhcpdv6Stop(String string) {
        this.put("dhcpdv6_stop", (java.lang.Object)string);
        return this;
    }

    public String getDhcpdv6Stop() {
        return this.getString("dhcpdv6_stop", "::7d1");
    }

    private String \u00d2\u00d60000(SubnetUtils.SubnetInfo subnetInfo) {
        return String.format("%s/%d", subnetInfo.getNetworkAddress(), Integer.bitCount(subnetInfo.asInteger(subnetInfo.getNetmask())));
    }

    public boolean isInternetAccessEnabled() {
        return this.is("internet_access_enabled", true);
    }

    public NetworkConf setInternetAccessEnabled(boolean bl) {
        this.put("internet_access_enabled", (java.lang.Object)bl);
        return this;
    }

    public boolean isNetworkIsolationEnabled() {
        return this.is("network_isolation_enabled", false);
    }

    public NetworkConf setNetworkIsolationEnabled(boolean bl) {
        this.put("network_isolation_enabled", (java.lang.Object)bl);
        return this;
    }

    public boolean isNat() {
        return this.is("is_nat", true);
    }

    public NetworkConf setNat(boolean bl) {
        this.put("is_nat", (java.lang.Object)bl);
        return this;
    }

    public boolean isWanV6Enabled() {
        return this.getWanTypeV6().map(string -> !string.equals(WanTypeV6.DISABLED.toString())).orElse(false);
    }

    public boolean isIpv6RaEnabled() {
        return this.is("ipv6_ra_enabled", true);
    }

    public NetworkConf setIpV6RaEnabled(boolean bl) {
        this.put("ipv6_ra_enabled", (java.lang.Object)bl);
        return this;
    }

    public NetworkConf setIpV6InterfaceType(super super_) {
        this.put("ipv6_interface_type", (java.lang.Object)super_.toString());
        return this;
    }

    public super getIpV6InterfaceType() {
        return super.o00000(this.getString("ipv6_interface_type"));
    }

    public boolean isIpV6PdNetwork() {
        return super.class == this.getIpV6InterfaceType();
    }

    public boolean isDpiEnabled() {
        return this.is("dpi_enabled", false);
    }

    public NetworkConf setDpiEnabled(boolean bl) {
        this.put("dpi_enabled", (java.lang.Object)bl);
        return this;
    }

    public Optional<String> getDpiGroupId() {
        return this.getOptionalString("dpigroup_id");
    }

    public NetworkConf setDpiGroupId(String string) {
        this.put("dpigroup_id", (java.lang.Object)string);
        return this;
    }

    public boolean isExposedToSiteVpn() {
        return this.is("exposed_to_site_vpn", false);
    }

    public NetworkConf setExposedToSiteVpn(boolean bl) {
        this.put("exposed_to_site_vpn", (java.lang.Object)bl);
        return this;
    }

    private boolean whileclass() {
        return this.getWanDns1().isPresent() || this.getWanDns2().isPresent();
    }

    public boolean isMulticastDnsEnabled() {
        return this.is("mdns_enabled", false);
    }

    public NetworkConf setMulticastDnsEnabled(boolean bl) {
        this.put("mdns_enabled", (java.lang.Object)bl);
        return this;
    }

    public NetworkConf setRouteDistance(int n2) {
        this.put("route_distance", (java.lang.Object)n2);
        return this;
    }

    public Optional<Integer> getRouteDistance() {
        return this.getOptionalInt("route_distance");
    }

    public boolean isL2tpAllowWeakCiphers() {
        return this.getBoolean("l2tp_allow_weak_ciphers", false);
    }

    public NetworkConf setL2tpAllowWeakCiphers(boolean bl) {
        this.put("l2tp_allow_weak_ciphers", (java.lang.Object)bl);
        return this;
    }

    public boolean isDhcpdBootEnabled() {
        return this.is("dhcpd_boot_enabled", false);
    }

    public NetworkConf setDhcpdBootEnabled(boolean bl) {
        this.put("dhcpd_boot_enabled", (java.lang.Object)bl);
        return this;
    }

    public NetworkConf setDhcpdBootServer(String string) {
        this.put("dhcpd_boot_server", (java.lang.Object)string);
        return this;
    }

    public String getDhcpdBootServer() {
        return this.getString("dhcpd_boot_server");
    }

    public NetworkConf setDhcpdBootFilename(String string) {
        this.put("dhcpd_boot_filename", (java.lang.Object)string);
        return this;
    }

    public String getDhcpdBootFilename() {
        return this.getString("dhcpd_boot_filename");
    }

    public boolean isDhcpdGatewayEnabled() {
        return this.is("dhcpd_gateway_enabled", false);
    }

    public NetworkConf setDhcpdGatewayEnabled(boolean bl) {
        this.put("dhcpd_gateway_enabled", (java.lang.Object)bl);
        return this;
    }

    public boolean isDhcpdNtpEnabled() {
        return this.is("dhcpd_ntp_enabled", false);
    }

    public NetworkConf setDhcpNtpEnabled(boolean bl) {
        this.put("dhcpd_ntp_enabled", (java.lang.Object)bl);
        return this;
    }

    public String getDhcpdTftpServer() {
        return this.getString("dhcpd_tftp_server");
    }

    public NetworkConf setDhcpdTftpServer(String string) {
        this.put("dhcpd_tftp_server", (java.lang.Object)string);
        return this;
    }

    public boolean isDhcpdTimeOffsetEnabled() {
        return this.is("dhcpd_time_offset_enabled", false);
    }

    public NetworkConf setDhcpdTimeOffsetEnabled(boolean bl) {
        this.put("dhcpd_time_offset_enabled", (java.lang.Object)bl);
        return this;
    }

    public NetworkConf setDhtpDhcpdTimeOffset(Integer n2) {
        this.put("dhcpd_time_offset", (java.lang.Object)n2);
        return this;
    }

    public Integer getDhcpdTimeOffset() {
        return this.getIntOrNull("dhcpd_time_offset");
    }

    public String getDhcpdUnifiController() {
        return this.getString("dhcpd_unifi_controller");
    }

    public NetworkConf setDhcpdUnifiController(String string) {
        this.put("dhcpd_unifi_controller", (java.lang.Object)string);
        return this;
    }

    public boolean isDhcpdWinsEnabled() {
        return this.is("dhcpd_wins_enabled", false);
    }

    public List<String> getDhcpdWinsIpList() {
        return this.getPrefixedList("dhcpd_wins");
    }

    public NetworkConf setDhcpdWinsEnabled(boolean bl) {
        this.put("dhcpd_wins_enabled", (java.lang.Object)bl);
        return this;
    }

    public String getDhcpdWpadUrl() {
        return this.getString("dhcpd_wpad_url");
    }

    public NetworkConf setDhcpdWpadUrl(String string) {
        this.put("dhcpd_wpad_url", (java.lang.Object)string);
        return this;
    }

    public NetworkConf setDhcpdConflictChecking(boolean bl) {
        this.put("dhcpd_conflict_checking", (java.lang.Object)bl);
        return this;
    }

    public boolean isDhcpdConflictCheckingEnabled() {
        return this.is("dhcpd_conflict_checking", true);
    }

    public boolean isDhcpdV6DnsAuto() {
        return this.is("dhcpdv6_dns_auto", true);
    }

    public NetworkConf setDhcpdV6DnsAuto(boolean bl) {
        this.put("dhcpdv6_dns_auto", (java.lang.Object)bl);
        return this;
    }

    public int getDhcpdV6Leasetime() {
        return this.getInt("dhcpdv6_leasetime", 86400);
    }

    public NetworkConf setDhcpdV6Leasetime(int n2) {
        this.put("dhcpdv6_leasetime", (java.lang.Object)n2);
        return this;
    }

    public String getIpv6PdInterface() {
        return this.getString("ipv6_pd_interface", "");
    }

    public NetworkConf setIpv6PdInterface(String string) {
        this.put("ipv6_pd_interface", (java.lang.Object)string);
        return this;
    }

    public String getIpv6SingleNetworkInterface() {
        return this.getString("ipv6_single_network_interface", "");
    }

    public NetworkConf setIpv6SingleNetworkInterface(String string) {
        this.put("ipv6_single_network_interface", (java.lang.Object)string);
        return this;
    }

    public String getIpv6PdStart() {
        return this.getString("ipv6_pd_start", "::2");
    }

    public NetworkConf setIpv6PdStart(String string) {
        this.put("ipv6_pd_start", (java.lang.Object)string);
        return this;
    }

    public String getIpv6PdStop() {
        return this.getString("ipv6_pd_stop", "::7d1");
    }

    public NetworkConf setIpv6PdStop(String string) {
        this.put("ipv6_pd_stop", (java.lang.Object)string);
        return this;
    }

    public String getIpv6RaPreferredLifetime() {
        return this.getString("ipv6_ra_preferred_lifetime", NetworkConfDefaults.Objectsuper);
    }

    public NetworkConf setIpv6RaPreferredLifetime(int n2) {
        this.put("ipv6_ra_preferred_lifetime", (java.lang.Object)n2);
        return this;
    }

    public Ipv6RaPriority getIpv6RaPriority() {
        return Ipv6RaPriority.ofStringValue(this.getString("ipv6_ra_priority")).orElse(NetworkConfDefaults.super);
    }

    public NetworkConf setIpv6RaPriority(Ipv6RaPriority ipv6RaPriority) {
        this.put("ipv6_ra_priority", (java.lang.Object)ipv6RaPriority.toString());
        return this;
    }

    public boolean isUpnpLanEnabled() {
        return this.is("upnp_lan_enabled", false);
    }

    public NetworkConf setUpnpLanEnabled(boolean bl) {
        this.put("upnp_lan_enabled", (java.lang.Object)bl);
        return this;
    }

    public String getDhcpGateway() {
        return this.getString("dhcpd_gateway");
    }

    public NetworkConf setDhcpGateway(String string) {
        return this.append("dhcpd_gateway", string);
    }

    public Optional<String> getOpenVpnLocalAddress() {
        return Optional.ofNullable(this.getString("openvpn_local_address"));
    }

    public NetworkConf setOpenVpnLocalAddress(String string) {
        return this.append("openvpn_local_address", string);
    }

    public Optional<String> getOpenVpnRemoteHost() {
        return Optional.ofNullable(this.getString("openvpn_remote_host"));
    }

    public NetworkConf setOpenVpnRemoteHost(String string) {
        return this.append("openvpn_remote_host", string);
    }

    public Optional<String> getOpenVpnRemoteAddress() {
        return Optional.ofNullable(this.getString("openvpn_remote_address"));
    }

    public NetworkConf setOpenVpnRemoteAddress(String string) {
        this.put("openvpn_remote_address", (java.lang.Object)string);
        return this;
    }

    public Optional<Integer> getOpenVpnTlsRenegotiationTimeout() {
        return this.getOptionalInt("openvpn_tls_renegotiation_timeout");
    }

    public NetworkConf setOpenVpnTlsRenegotiationTimeout(Integer n2) {
        this.put("openvpn_tls_renegotiation_timeout", (java.lang.Object)n2);
        return this;
    }

    public Optional<String> getOpenVpnConfiguration() {
        return Optional.ofNullable(this.getString("openvpn_configuration"));
    }

    public Optional<String> getOpenVpnConfigurationFilename() {
        return Optional.ofNullable(this.getString("openvpn_configuration_filename"));
    }

    public NetworkConf setOpenVpnConfiguration(String string) {
        return this.append("openvpn_configuration", string);
    }

    public NetworkConf setOpenVpnConfigurationFilename(String string) {
        return this.append("openvpn_configuration_filename", string);
    }

    public Optional<OpenVpnConfigurationStatus> getOpenVpnConfigurationStatus() {
        return Q.private(OpenVpnConfigurationStatus.class, this.getString("openvpn_configuration_status"));
    }

    public NetworkConf setOpenVpnConfigurationStatus(OpenVpnConfigurationStatus openVpnConfigurationStatus) {
        return this.append("openvpn_configuration_status", openVpnConfigurationStatus.toString());
    }

    public Optional<String> getOpenVpnUsername() {
        return Optional.ofNullable(this.getString("openvpn_username"));
    }

    public NetworkConf setOpenVpnUsername(String string) {
        return this.append("openvpn_username", string);
    }

    public Optional<String> getOpenVpnPassword() {
        return Optional.ofNullable(this.getString("x_openvpn_password"));
    }

    public NetworkConf setOpenVpnPassword(String string) {
        return this.append("x_openvpn_password", string);
    }

    public Optional<Integer> getOpenVpnId() {
        return this.getOptionalInt("openvpn_id");
    }

    public Optional<oOOO> getOpenVpnEncryptionCipher() {
        return this.getOptionalEnum("openvpn_encryption_cipher", oOOO.class);
    }

    public NetworkConf setOpenVpnEncryptionCipher(oOOO oOOO2) {
        return this.append("openvpn_encryption_cipher", oOOO2.toString());
    }

    public boolean isVpnClientConfigurationRemoteIpOverrideEnabled() {
        return this.is("vpn_client_configuration_remote_ip_override_enabled", false);
    }

    public NetworkConf setVpnClientConfigurationRemoteIpOverrideEnabled(boolean bl) {
        return this.append("vpn_client_configuration_remote_ip_override_enabled", bl);
    }

    public Optional<String> getVpnClientConfigurationRemoteIpOverride() {
        return Optional.ofNullable(this.getString("vpn_client_configuration_remote_ip_override")).filter(StringUtils::isNotBlank);
    }

    public NetworkConf setVpnClientConfigurationRemoteIpOverride(String string) {
        return this.append("vpn_client_configuration_remote_ip_override", string);
    }

    public NetworkConf setOpenVpnId(int n2) {
        return this.append("openvpn_id", n2);
    }

    public Optional<com.ubnt.model.oO0O.B.Object> getWireguardClientMode() {
        return Q.private(com.ubnt.model.oO0O.B.Object.class, this.getString("wireguard_client_mode"));
    }

    public Optional<String> getWireguardClientConfigurationFile() {
        return Optional.ofNullable(this.getString("wireguard_client_configuration_file"));
    }

    public NetworkConf setWireguardClientConfigurationFile(String string) {
        return this.append("wireguard_client_configuration_file", string);
    }

    public Optional<String> getWireguardClientPeerPublicKey() {
        return Optional.ofNullable(this.getString("wireguard_client_peer_public_key"));
    }

    public NetworkConf setWireguardClientPeerPublicKey(String string) {
        return this.append("wireguard_client_peer_public_key", string);
    }

    public Optional<String> getWireguardClientPeerIp() {
        return Optional.ofNullable(this.getString("wireguard_client_peer_ip"));
    }

    public NetworkConf setWireguardClientPeerIp(String string) {
        return this.append("wireguard_client_peer_ip", string);
    }

    public Optional<Integer> getWireguardClientPeerPort() {
        return Optional.ofNullable(this.getIntOrNull("wireguard_client_peer_port"));
    }

    public NetworkConf setWireguardClientPeerPort(Integer n2) {
        return this.append("wireguard_client_peer_port", n2);
    }

    public Optional<String> getWireguardClientPreSharedKey() {
        return Optional.ofNullable(this.getString("wireguard_client_preshared_key"));
    }

    public NetworkConf setWireguardClientPresharedKey(String string) {
        return this.append("wireguard_client_preshared_key", string);
    }

    public boolean isWireguardClientPreSharedKeyEnabled() {
        return this.is("wireguard_client_preshared_key_enabled", false);
    }

    public NetworkConf setWireguardClientPresharedKeyEnabled(boolean bl) {
        return this.append("wireguard_client_preshared_key_enabled", bl);
    }

    public NetworkConf setWireguardClientMode(com.ubnt.model.oO0O.B.Object object) {
        return this.append("wireguard_client_mode", object.toString());
    }

    public Optional<String> getWireguardPrivateKey() {
        return this.getOptionalString("x_wireguard_private_key").filter(StringUtils::isNotEmpty);
    }

    public NetworkConf setWireguardPrivateKey(String string) {
        return this.append("x_wireguard_private_key", string);
    }

    public Optional<Integer> getWireguardId() {
        return this.getOptionalInt("wireguard_id");
    }

    public NetworkConf setWireguardId(int n2) {
        return this.append("wireguard_id", n2);
    }

    public Optional<String> getWireguardInterface() {
        return Optional.ofNullable(this.getString("wireguard_interface"));
    }

    public NetworkConf setWireguardInterface(String string) {
        return this.append("wireguard_interface", string);
    }

    public Optional<String> getWireguardLocalWanIp() {
        return Optional.ofNullable(this.getString("wireguard_local_wan_ip"));
    }

    public NetworkConf setWireguardLocalWanIp(String string) {
        return this.append("wireguard_local_wan_ip", string);
    }

    public boolean isSmartSubnetDetected() {
        return this.getOptionalBoolean("is_smart_subnet_detected").orElse(false);
    }

    public NetworkConf setSmartSubnetDetected(boolean bl) {
        this.put("is_smart_subnet_detected", (java.lang.Object)bl);
        return this;
    }

    public Optional<String> getVrrpPrimaryGatewaySubnetIp() {
        return this.getOptionalString("vrrp_ip_subnet_gw1");
    }

    public Optional<String> getVrrpSecondaryGatewaySubnetIp() {
        return this.getOptionalString("vrrp_ip_subnet_gw2");
    }

    public Optional<Integer> getVrrpVrid() {
        return this.getOptionalInt("vrrp_vrid");
    }

    public boolean isEqualToLocalNetworkAutoSettings() {
        NetworkConf networkConf = NetworkConfDefaults.localNetworkAutoSettings(this.isVlanEnabled());
        return (this.getFirewallZoneId().isPresent() || StringUtils.equals((CharSequence)this.getPurpose(), (CharSequence)networkConf.getPurpose())) && this.isDhcpdEnabled() == networkConf.isDhcpdEnabled() && this.isDhcpdV6Enabled() == networkConf.isDhcpdV6Enabled() && this.isDhcpGuardEnabled() == networkConf.isDhcpGuardEnabled() && StringUtils.equals((CharSequence)this.getDomainNameWithDefault(), (CharSequence)networkConf.getDomainNameWithDefault()) && this.isIgmpSnooping() == networkConf.isIgmpSnooping() && this.getIpV6InterfaceType().equals((java.lang.Object)networkConf.getIpV6InterfaceType()) && this.isNat() == networkConf.isNat() && this.isIpv6RaEnabled() == networkConf.isIpv6RaEnabled() && this.isMulticastDnsEnabled() == networkConf.isMulticastDnsEnabled();
    }

    public Optional<Integer> getWanEgressQos() {
        return this.getOptionalInt("wan_egress_qos");
    }

    public NetworkConf setWanEgressQos(int n2) {
        this.put("wan_egress_qos", (java.lang.Object)n2);
        return this;
    }

    public Optional<String> getOpenVpnAuthKey() {
        return Optional.ofNullable(this.getString("x_auth_key")).filter(StringUtils::isNotEmpty);
    }

    public NetworkConf setOpenVpnAuthKey(String string) {
        return this.append("x_auth_key", string);
    }

    public Optional<String> getOpenVpnAuthorityCertificate() {
        return Optional.ofNullable(this.getString("x_ca_crt")).filter(StringUtils::isNotEmpty);
    }

    public NetworkConf setOpenVpnAuthorityCertificate(String string) {
        return this.append("x_ca_crt", string);
    }

    public Optional<String> getOpenVpnAuthorityKey() {
        return Optional.ofNullable(this.getString("x_ca_key")).filter(StringUtils::isNotEmpty);
    }

    public NetworkConf setOpenVpnAuthorityKey(String string) {
        return this.append("x_ca_key", string);
    }

    public Optional<String> getOpenVpnInterface() {
        return Optional.ofNullable(this.getString("openvpn_interface"));
    }

    public NetworkConf setOpenVpnInterface(WanNetworkGroup wanNetworkGroup) {
        return this.append("openvpn_interface", wanNetworkGroup.toString().toLowerCase());
    }

    public Optional<String> getOpenVpnLocalWanIp() {
        return Optional.ofNullable(this.getString("openvpn_local_wan_ip"));
    }

    public NetworkConf setOpenVpnLocalWanIp(String string) {
        this.put("openvpn_local_wan_ip", (java.lang.Object)string);
        return this;
    }

    public Optional<String> getOpenVpnServerCertificate() {
        return Optional.ofNullable(this.getString("x_server_crt")).filter(StringUtils::isNotEmpty);
    }

    public NetworkConf setOpenVpnServerCertificate(String string) {
        return this.append("x_server_crt", string);
    }

    public Optional<String> getOpenVpnServerKey() {
        return Optional.ofNullable(this.getString("x_server_key")).filter(StringUtils::isNotEmpty);
    }

    public NetworkConf setOpenVpnServerKey(String string) {
        return this.append("x_server_key", string);
    }

    public Optional<String> getOpenVpnDhKey() {
        return Optional.ofNullable(this.getString("x_dh_key")).filter(StringUtils::isNotEmpty);
    }

    public NetworkConf setOpenVpnDhKey(String string) {
        return this.append("x_dh_key", string);
    }

    public Optional<String> getOpenVpnSharedClientCertificate() {
        return Optional.ofNullable(this.getString("x_shared_client_crt")).filter(StringUtils::isNotEmpty);
    }

    public NetworkConf setOpenVpnSharedClientCertificate(String string) {
        return this.append("x_shared_client_crt", string);
    }

    public Optional<String> getOpenVpnSharedClientKey() {
        return Optional.ofNullable(this.getString("x_shared_client_key")).filter(StringUtils::isNotEmpty);
    }

    public NetworkConf setOpenVpnSharedClientKey(String string) {
        return this.append("x_shared_client_key", string);
    }

    public boolean hasRequiredOpenVpnServerCertificatesAndKeys() {
        return this.getOpenVpnAuthorityCertificate().isPresent() && this.getOpenVpnServerCertificate().isPresent() && this.getOpenVpnAuthKey().isPresent() && this.getOpenVpnDhKey().isPresent();
    }

    public Optional<Integer> getWanDhcpCos() {
        return this.getOptionalInt("wan_dhcp_cos").filter(n2 -> n2 > 0);
    }

    public Optional<Integer> getWanDhcpV6Cos() {
        return this.getOptionalInt("wan_dhcpv6_cos").filter(n2 -> n2 > 0);
    }

    public boolean isIpv6Enabled() {
        return this.is("ipv6_enabled", true);
    }

    public NetworkConf setIpv6Enabled(boolean bl) {
        this.put("ipv6_enabled", (java.lang.Object)bl);
        return this;
    }

    public NetworkConf setClientAddressAssignment(B b2) {
        this.put("ipv6_client_address_assignment", (java.lang.Object)b2.toString());
        return this;
    }

    public B getClientAddressAssignment() {
        return B.\u00d200000(this.getString("ipv6_client_address_assignment"));
    }

    public NetworkConf setDhcpv6dDns(int n2, String string) {
        this.put("dhcpdv6_dns_" + n2, (java.lang.Object)string);
        return this;
    }

    public List<String> getDhcpdV6DnsIpList() {
        return this.getPrefixedList("dhcpdv6_dns");
    }

    public boolean isAllowSlaacEnabled() {
        return this.is("dhcpdv6_allow_slaac", true);
    }

    public NetworkConf setDhcpdv6AllowSlaac(boolean bl) {
        this.put("dhcpdv6_allow_slaac", (java.lang.Object)bl);
        return this;
    }

    public boolean isIpv6DefaultPrefixLength() {
        return this.getPrefixLength() == 64;
    }

    public boolean isIpv6StaticInterfaceType() {
        return this.getIpV6InterfaceType() == super.\u00d200000;
    }

    public boolean isDhcpv6AddressAssignment() {
        return this.getClientAddressAssignment() == B.new;
    }

    public boolean isIpv6AutoPreference() {
        return this.getIpv6SettingPreference().filter(settingPreference -> settingPreference == SettingPreference.\u00d300000).isPresent();
    }

    public NetworkConf setIPv6PdPrefixId(int n2) {
        this.put("ipv6_pd_prefixid", (java.lang.Object)n2);
        return this;
    }

    public Optional<Integer> getIPv6PdPrefixId() {
        return Optional.of(this.getInt("ipv6_pd_prefixid", -1)).filter(n2 -> n2 >= 0);
    }

    public NetworkConf setIPv6PdAutoPrefixIdEnabled(boolean bl) {
        this.put("ipv6_pd_auto_prefixid_enabled", (java.lang.Object)bl);
        return this;
    }

    public boolean isIPv6PdAutoPrefixIdEnabled() {
        return this.is("ipv6_pd_auto_prefixid_enabled", true);
    }

    public boolean isIPv6PdPrefixIdAutoCalculated() {
        return this.isIPv6PdAutoPrefixIdEnabled() || this.getIPv6PdPrefixId().isEmpty();
    }

    public boolean isDhcpv6Configured() {
        return this.isIpv6StaticInterfaceType() && (this.isDhcpdV6Enabled() || this.getClientAddressAssignment() == B.new);
    }

    public NetworkConf setDhcpv6PdSize(int n2) {
        this.put("wan_dhcpv6_pd_size", (java.lang.Object)n2);
        return this;
    }

    public int getWanDhcpv6PdSize() {
        return this.getInt("wan_dhcpv6_pd_size", 64);
    }

    public NetworkConf setWanDhcpv6PdSizeAuto(boolean bl) {
        this.put("wan_dhcpv6_pd_size_auto", (java.lang.Object)bl);
        return this;
    }

    public boolean isWanDhcpv6PdSizeAuto() {
        return this.is("wan_dhcpv6_pd_size_auto", false);
    }

    public Optional<String> getWanIpv6() {
        return this.getOptionalString("wan_ipv6");
    }

    public NetworkConf setWanIpv6(String string) {
        this.put("wan_ipv6", (java.lang.Object)string);
        return this;
    }

    public NetworkConf setWanGatewayIpv6(String string) {
        this.put("wan_gateway_v6", (java.lang.Object)string);
        return this;
    }

    public boolean isWanIpV6PdNetwork() {
        return this.isWanTypeV6(WanTypeV6.DHCPV6) || this.isWanTypeV6(WanTypeV6.SLAAC) && this.isIpv6WanDelegationType(Ipv6WanDelegationType.PD);
    }

    public NetworkConf setWanIpv6Dns1(String string) {
        this.put("wan_ipv6_dns1", (java.lang.Object)string);
        return this;
    }

    public Optional<String> getWanIpv6Dns1() {
        return Optional.ofNullable(this.getString("wan_ipv6_dns1"));
    }

    public NetworkConf setWanIpv6Dns2(String string) {
        this.put("wan_ipv6_dns2", (java.lang.Object)string);
        return this;
    }

    public Optional<String> getWanIpv6Dns2() {
        return Optional.ofNullable(this.getString("wan_ipv6_dns2"));
    }

    public NetworkConf setWanIpv6DnsPreference(WanDnsPreference wanDnsPreference) {
        this.put("wan_ipv6_dns_preference", (java.lang.Object)wanDnsPreference);
        return this;
    }

    public Optional<WanDnsPreference> getWanIpv6DnsPreference() {
        return Q.private(WanDnsPreference.class, this.getString("wan_ipv6_dns_preference"));
    }

    public boolean hasAutoIpv6DnsPreference() {
        return this.getWanIpv6DnsPreference().orElse(WanDnsPreference.AUTO) == WanDnsPreference.AUTO;
    }

    public NetworkConf setRemoteSiteId(String string) {
        this.append("remote_site_id", string);
        return this;
    }

    public Optional<String> getRemoteSiteId() {
        return this.getOptionalString("remote_site_id");
    }

    public boolean isIgmpFastleaveEnabled() {
        return this.is("igmp_fastleave", false);
    }

    public int getIgmpMaxResponseTime() {
        return this.getInt("igmp_maxresponse", 10);
    }

    public int getIgmpMcrtrExpireTime() {
        return this.getInt("igmp_mcrtrexpiretime", 180);
    }

    public int getIgmpGroupMembershipInterval() {
        return this.getInt("igmp_groupmembership", 260);
    }

    public boolean isIgmpReportSuppressionEnabled() {
        return this.is("igmp_supression", false);
    }

    public boolean isWanPppoeUsernameEnabled() {
        return this.is("wan_pppoe_username_enabled", true);
    }

    public NetworkConf setWanPppoeUsernameEnabled(boolean bl) {
        this.append("wan_pppoe_username_enabled", bl);
        return this;
    }

    public boolean isWanPppoePasswordEnabled() {
        return this.is("wan_pppoe_password_enabled", true);
    }

    public NetworkConf setWanPppoePasswordEnabled(boolean bl) {
        this.append("wan_pppoe_password_enabled", bl);
        return this;
    }

    public Optional<String> getWanPppoeUsername() {
        return this.getOptionalString("wan_username");
    }

    public NetworkConf setWanPppoeUsername(String string) {
        this.append("wan_username", string);
        return this;
    }

    public Optional<String> getWanPppoePassword() {
        return this.getOptionalString("x_wan_password");
    }

    public NetworkConf setWanPppoePassword(String string) {
        this.append("x_wan_password", string);
        return this;
    }

    public boolean isIpv6StandardPrefixLengthInterfaceType() {
        return com.ubnt.service.config.ubios.null.Object.\u00d300000(this.getIpV6InterfaceType());
    }

    public boolean isIpv6SlaacClientAddressAssignment() {
        return this.getClientAddressAssignment() == B.\u00d400000;
    }

    public boolean isIPv6SingleNetwork() {
        return super.super == this.getIpV6InterfaceType();
    }

    public boolean isWanFailoverFirstPriority() {
        return this.getWanFailOverPriority().map(n2 -> n2 == 1).orElse(false);
    }

    public boolean isWanNetworkAndNotLteFailover() {
        return this.isWanNetwork() && !this.isLteWanFailoverNetwork();
    }

    public boolean isWan5gNetwork() {
        return this.getHiddenId().filter(string -> StringUtils.equals((CharSequence)\u00d30O000, (CharSequence)string)).isPresent();
    }

    public boolean isBuiltinWan5gNetwork() {
        return this.isWan5gNetwork() && this.getWanNetworkGroup().filter(wanNetworkGroup -> wanNetworkGroup == forreturn).isPresent() && StringUtils.equals((CharSequence)this.getInterfaceName(), (CharSequence)o0O000);
    }

    public boolean isWanMagicEnabled() {
        return this.is("wan_magic_enabled", false);
    }

    public NetworkConf setWanMagicEnabled(boolean bl) {
        this.append("wan_magic_enabled", bl);
        return this;
    }

    public NetworkConf setWan5gNetwork() {
        this.setHiddenId(\u00d30O000);
        return this;
    }

    public boolean isWanMagicNetwork() {
        return this.getNetworkPurpose() == NetworkPurpose.WAN_MAGIC;
    }

    public NetworkConf setLanTunnelWanDevice(String string) {
        this.put("lan_tunnel_wan_device", (java.lang.Object)string);
        return this;
    }

    public Optional<String> getLanTunnelWanDevice() {
        return this.getOptionalString("lan_tunnel_wan_device");
    }

    public boolean isLanTunnelWanNetwork() {
        return this.isLteWanFailoverNetwork() || this.isWan5gNetwork() && this.getLanTunnelWanDevice().isPresent();
    }

    @Override
    public void setCloudTemplate(TemplateConfigMetaData templateConfigMetaData) {
        this.append("cloud_template", templateConfigMetaData.toLegacy());
    }

    @Override
    public void setCloudTemplateRevisionId(String string) {
        this.getOptionalX("cloud_template").ifPresent(x2 -> x2.append("revision_id", string));
    }

    @Override
    public void setCloudTemplateId(String string) {
        this.getOptionalX("cloud_template").ifPresent(x2 -> x2.append("template_id", string));
    }

    @Override
    public boolean isOrchestrated() {
        return this.containsField("cloud_template");
    }

    @Override
    @Nullable
    public String getCloudConfigId() {
        return this.getX("cloud_template", X.newObject).getString("config_id");
    }

    @Override
    @Nullable
    public String getCloudTemplateId() {
        return this.getX("cloud_template", X.newObject).getString("template_id");
    }

    @Override
    @Nullable
    public String getCloudRevisionId() {
        return this.getX("cloud_template", X.newObject).getString("revision_id");
    }

    @Override
    @Nullable
    public String getCloudOrganizationId() {
        return this.getX("cloud_template", X.newObject).getString("organization_id");
    }

    @Override
    @Nullable
    public String getCloudOrchestrationId() {
        return this.getX("cloud_template", X.newObject).getString("orchestration_id");
    }

    @Override
    public void setNotDeletable(boolean bl) {
        this.append("attr_no_delete", bl);
    }

    public boolean isNotDeletable() {
        return this.is("attr_no_delete", false);
    }

    @Override
    public void setNotEditable(boolean bl) {
        this.append("attr_no_edit", bl);
    }

    public boolean isNotEditable() {
        return this.is("attr_no_edit", false);
    }

    @Override
    public return getConfigOwnership() {
        return this.containsField("cloud_template") ? return.o00000 : return.Object;
    }

    @Override
    public <T extends X> T duplicate(Class<T> clazz) {
        T t2 = super.duplicate(clazz);
        if (this.getExternalId() != null) {
            ((NetworkConf)t2).setExternalId(this.getExternalId());
        }
        return t2;
    }
}

