/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.data.X;
import com.ubnt.model.api.ImmutableHistoricalActivityDto;
import com.ubnt.return.OoOO;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@OoOO
@Value.Immutable
public interface HistoricalActivityDto {
    @JsonProperty(value="timestamp")
    public long timestamp();

    @JsonProperty(value="activity_seconds")
    public Optional<Long> activitySeconds();

    @JsonProperty(value="not_reported")
    public Optional<Boolean> notReported();

    public static HistoricalActivityDto of(long l2, long l3) {
        return ImmutableHistoricalActivityDto.builder().timestamp(l2).activitySeconds(l3).build();
    }

    public static HistoricalActivityDto missingInterval(long l2) {
        return ImmutableHistoricalActivityDto.builder().timestamp(l2).notReported(true).build();
    }

    public static HistoricalActivityDto ofLegacy(X x2) {
        long l4 = x2.getLong("time");
        return x2.getOptionalLong("duration").filter(l2 -> l2 > 0L).map(l3 -> HistoricalActivityDto.of(l4, TimeUnit.MILLISECONDS.toSeconds((long)l3))).orElseGet(() -> HistoricalActivityDto.missingInterval(l4));
    }
}

