/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.topology;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.ubnt.model.api.topology.ImmutableTopologyGraphDto;
import com.ubnt.model.api.topology.TopologyEdgeDto;
import com.ubnt.model.api.topology.TopologyVertexDto;
import com.ubnt.return.C;
import com.ubnt.service.topology.M;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableTopologyGraphDto.class)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@Value.Immutable(builder=false)
@C
public abstract class TopologyGraphDto {
    @JsonProperty(value="vertices")
    @Value.Parameter
    public abstract Set<TopologyVertexDto> getVertices();

    @JsonProperty(value="edges")
    @Value.Parameter
    public abstract Set<TopologyEdgeDto> getEdges();

    @JsonProperty(value="has_unknown_switch")
    @Value.Parameter
    public abstract Optional<Boolean> hasUnknownSwitch();

    public static TopologyGraphDto of(M m2) {
        return ImmutableTopologyGraphDto.of(TopologyGraphDto.\u00d200000(m2), TopologyGraphDto.o00000(m2), m2.new());
    }

    private static Set<TopologyVertexDto> \u00d200000(M m2) {
        return m2.vertexSet().stream().map(TopologyVertexDto::of).collect(Collectors.toSet());
    }

    private static Set<TopologyEdgeDto> o00000(M m2) {
        return m2.edgeSet().stream().map(TopologyEdgeDto::of).collect(Collectors.toSet());
    }
}

