/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.wifiman;

import com.ubnt.data.Site;
import com.ubnt.model.api.report.IncorrectWifiExperience;
import com.ubnt.model.api.wifiman.WifiManClientInfoDto;
import com.ubnt.model.api.wifiman.WifiManDevice;
import com.ubnt.model.api.wifiman.WifiManFeedback;
import com.ubnt.model.api.wifiman.WifiManFeedbackRequest;
import com.ubnt.model.api.wifiman.WifiManFeedbackResponse;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowApiToken;
import com.ubnt.net.v2.validation.constraints.Ip;
import com.ubnt.service.wifiman.A;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="WiFiman")
public class WifiManController {
    private final A super;

    public WifiManController(A a2) {
        this.super = a2;
    }

    @GetMapping(value={"/api/site/{siteName}/wifiman"})
    @Operation(summary="Get WiFiman Feedback")
    public List<WifiManFeedback> getFeedbackList(@PathVariable(value="siteName") Site site) {
        return this.super.\u00d300000(site.getId());
    }

    @GetMapping(value={"/api/site/{siteName}/wifiman/{clientIp}/devices"})
    @Operation(summary="Get list of connected devices and clients")
    @AllowApiToken
    public List<WifiManDevice> getDevices(@PathVariable(value="siteName") Site site, @PathVariable(value="clientIp") @Ip String string) {
        return this.super.\u00d500000(site.getId(), string);
    }

    @GetMapping(value={"/api/site/{siteName}/wifiman/{clientIp}"})
    @Operation(summary="Get WiFiman Client Info")
    @AllowApiToken
    public WifiManClientInfoDto getClientInfo(@PathVariable(value="siteName") Site site, @PathVariable(value="clientIp") @Ip String string) {
        return this.super.o00000(site.getId(), string);
    }

    @PostMapping(value={"/api/site/{siteName}/wifiman/{clientIp}/feedback"})
    @ResponseStatus(value=HttpStatus.CREATED)
    @Operation(summary="Send WiFiman Speed Test Feedback")
    @AllowApiToken
    public WifiManFeedbackResponse sendFeedback(@PathVariable(value="siteName") Site site, @PathVariable(value="clientIp") @Ip String string, @Valid @NotNull @RequestBody WifiManFeedbackRequest wifiManFeedbackRequest) {
        return this.super.\u00d600000(site.getId(), string, wifiManFeedbackRequest);
    }

    @PutMapping(value={"/api/site/{siteName}/wifiman/{clientIp}/feedback/{feedbackId}/wifi_experience"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @Operation(summary="Report Incorrect WiFi Experience")
    @AllowApiToken
    public void reportIncorrectWifiExperience(@PathVariable(value="siteName") Site site, @PathVariable(value="clientIp") @Ip String string, @PathVariable(value="feedbackId") String string2, @RequestBody IncorrectWifiExperience incorrectWifiExperience) {
        this.super.\u00d800000(site.getId(), string, string2, incorrectWifiExperience);
    }
}

