/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.orchestration.template.device.sw.validator;

import com.google.common.collect.ImmutableMap;
import com.ubnt.data.Device;
import com.ubnt.service.orchestration.dto.report.IssueDetailReportDto;
import com.ubnt.service.orchestration.template.TemplateProvisioningValidationIssue;
import com.ubnt.service.orchestration.template.TemplateValidator;
import com.ubnt.service.orchestration.template.device.sw.validator.SwitchDeviceTemplateErrorValidator;
import com.ubnt.service.orchestration.template.device.sw.validator.SwitchDeviceTemplateWarningValidator;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SwitchDeviceTemplateValidator
implements TemplateValidator<Device> {
    private final SwitchDeviceTemplateWarningValidator switchDeviceTemplateWarningValidator;
    private final SwitchDeviceTemplateErrorValidator switchDeviceTemplateErrorValidator;

    @Override
    public Map<TemplateProvisioningValidationIssue, List<IssueDetailReportDto>> validate(List<Device> list) {
        List<IssueDetailReportDto> list2 = this.switchDeviceTemplateWarningValidator.checkTemplateForWarnings(list);
        List<IssueDetailReportDto> list3 = this.switchDeviceTemplateErrorValidator.checkTemplateForErrors(list);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (!list2.isEmpty()) {
            builder.put((Object)TemplateProvisioningValidationIssue.WARNING, list2);
        }
        if (!list3.isEmpty()) {
            builder.put((Object)TemplateProvisioningValidationIssue.ERROR, list3);
        }
        return builder.build();
    }

    @ConstructorProperties(value={"switchDeviceTemplateWarningValidator", "switchDeviceTemplateErrorValidator"})
    @Generated
    public SwitchDeviceTemplateValidator(SwitchDeviceTemplateWarningValidator switchDeviceTemplateWarningValidator, SwitchDeviceTemplateErrorValidator switchDeviceTemplateErrorValidator) {
        this.switchDeviceTemplateWarningValidator = switchDeviceTemplateWarningValidator;
        this.switchDeviceTemplateErrorValidator = switchDeviceTemplateErrorValidator;
    }
}

