/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.trace.api.device;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.data.Device;
import com.ubnt.data.Model;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TraceDeviceStats {
    @JsonProperty(value="model")
    private Model model;
    @JsonProperty(value="firmwareVersion")
    private String firmwareVersion;
    @JsonProperty(value="manufacturerId")
    private Integer manufacturerId;
    @JsonProperty(value="boardRev")
    private String boardRev;
    @JsonProperty(value="anonymousDeviceId")
    private String anonymousDeviceId;
    @JsonProperty(value="setupId")
    private String setupId;

    public Model getModel() {
        return this.model;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public Integer getManufacturerId() {
        return this.manufacturerId;
    }

    public String getBoardRev() {
        return this.boardRev;
    }

    public String getAnonymousDeviceId() {
        return this.anonymousDeviceId;
    }

    public String getSetupId() {
        return this.setupId;
    }

    public static TraceDeviceStats of(Device device) {
        if (device == null) {
            return null;
        }
        TraceDeviceStats traceDeviceStats = new TraceDeviceStats();
        traceDeviceStats.model = device.getModel();
        traceDeviceStats.firmwareVersion = device.getFirmwareVersion();
        traceDeviceStats.manufacturerId = device.getManufacturerId().orElse(null);
        traceDeviceStats.boardRev = device.getBoardRevision();
        traceDeviceStats.anonymousDeviceId = device.getAnonymousDeviceId();
        traceDeviceStats.setupId = device.getSetupId();
        return traceDeviceStats;
    }
}

