/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jgrapht.Graph;
import org.jgrapht.WeightedGraph;
import org.jgrapht.ext.EdgeProvider;
import org.jgrapht.ext.GraphImporter;
import org.jgrapht.ext.ImportException;
import org.jgrapht.ext.VertexProvider;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class GraphMLImporter<V, E>
implements GraphImporter<V, E> {
    private static final String GRAPHML_SCHEMA_FILENAME = "graphml.xsd";
    private static final String XLINK_SCHEMA_FILENAME = "xlink.xsd";
    private VertexProvider<V> vertexProvider;
    private EdgeProvider<V, E> edgeProvider;
    private static final String EDGE_WEIGHT_DEFAULT_ATTRIBUTE_NAME = "weight";
    private String edgeWeightAttributeName = "weight";

    public GraphMLImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider) {
        if (vertexProvider == null) {
            throw new IllegalArgumentException("Vertex provider cannot be null");
        }
        this.vertexProvider = vertexProvider;
        if (edgeProvider == null) {
            throw new IllegalArgumentException("Edge provider cannot be null");
        }
        this.edgeProvider = edgeProvider;
    }

    public VertexProvider<V> getVertexProvider() {
        return this.vertexProvider;
    }

    public void setVertexProvider(VertexProvider<V> vertexProvider) {
        if (vertexProvider == null) {
            throw new IllegalArgumentException("Vertex provider cannot be null");
        }
        this.vertexProvider = vertexProvider;
    }

    public EdgeProvider<V, E> getEdgeProvider() {
        return this.edgeProvider;
    }

    public void setEdgeProvider(EdgeProvider<V, E> edgeProvider) {
        if (edgeProvider == null) {
            throw new IllegalArgumentException("Edge provider cannot be null");
        }
        this.edgeProvider = edgeProvider;
    }

    public String getEdgeWeightAttributeName() {
        return this.edgeWeightAttributeName;
    }

    public void setEdgeWeightAttributeName(String edgeWeightAttributeName) {
        if (edgeWeightAttributeName == null) {
            throw new IllegalArgumentException("Edge weight attribute name cannot be null");
        }
        this.edgeWeightAttributeName = edgeWeightAttributeName;
    }

    @Override
    public void importGraph(Graph<V, E> graph, Reader input) throws ImportException {
        try {
            XMLReader xmlReader = this.createXMLReader();
            GraphMLHandler handler = new GraphMLHandler();
            xmlReader.setContentHandler(handler);
            xmlReader.setErrorHandler(handler);
            xmlReader.parse(new InputSource(input));
            handler.updateGraph(graph);
        }
        catch (Exception se) {
            throw new ImportException("Failed to parse GraphML", se);
        }
    }

    private XMLReader createXMLReader() throws ImportException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            InputStream xsdStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(GRAPHML_SCHEMA_FILENAME);
            if (xsdStream == null) {
                throw new ImportException("Failed to locate GraphML xsd");
            }
            InputStream xlinkStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(XLINK_SCHEMA_FILENAME);
            if (xlinkStream == null) {
                throw new ImportException("Failed to locate XLink xsd");
            }
            Source[] sources = new Source[]{new StreamSource(xlinkStream), new StreamSource(xsdStream)};
            Schema schema = schemaFactory.newSchema(sources);
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            spf.setSchema(schema);
            SAXParser saxParser = spf.newSAXParser();
            return saxParser.getXMLReader();
        }
        catch (Exception se) {
            throw new ImportException("Failed to parse GraphML", se);
        }
    }

    private class GraphElement {
        String id1;
        String id2;
        Map<String, String> attributes;

        public GraphElement(String id1) {
            this.id1 = id1;
            this.id2 = null;
            this.attributes = new HashMap<String, String>();
        }

        public GraphElement(String id1, String id2) {
            this.id1 = id1;
            this.id2 = id2;
            this.attributes = new HashMap<String, String>();
        }
    }

    private class Data {
        String key;
        String value;

        public Data(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public boolean isValid() {
            return this.key != null && this.value != null;
        }
    }

    private class Key {
        String id;
        String attributeName;
        String defaultValue;
        KeyTarget target;

        public Key(String id, String attributeName, String defaultValue, KeyTarget target) {
            this.id = id;
            this.attributeName = attributeName;
            this.defaultValue = defaultValue;
            this.target = target;
        }

        public boolean isValid() {
            return this.id != null && this.attributeName != null && this.target != null;
        }
    }

    private static enum KeyTarget {
        NODE,
        EDGE,
        ALL;

    }

    private class GraphMLHandler
    extends DefaultHandler {
        private static final String GRAPH = "graph";
        private static final String GRAPH_ID = "id";
        private static final String NODE = "node";
        private static final String NODE_ID = "id";
        private static final String EDGE = "edge";
        private static final String ALL = "all";
        private static final String EDGE_SOURCE = "source";
        private static final String EDGE_TARGET = "target";
        private static final String KEY = "key";
        private static final String KEY_FOR = "for";
        private static final String KEY_ATTR_NAME = "attr.name";
        private static final String KEY_ID = "id";
        private static final String DEFAULT = "default";
        private static final String DATA = "data";
        private static final String DATA_KEY = "key";
        private Map<String, GraphElement> nodes;
        private List<GraphElement> edges;
        private boolean insideDefault;
        private boolean insideData;
        private Data currentData;
        private Key currentKey;
        private Deque<GraphElement> currentGraphElement;
        private Map<String, Key> nodeValidKeys;
        private Map<String, Key> edgeValidKeys;

        private GraphMLHandler() {
        }

        public void updateGraph(Graph<V, E> graph) throws ImportException {
            if (this.nodes.isEmpty()) {
                return;
            }
            HashMap graphNodes = new HashMap();
            for (Map.Entry<String, GraphElement> en : this.nodes.entrySet()) {
                String nodeId = en.getKey();
                Map<String, String> collectedAttributes = en.getValue().attributes;
                HashMap<String, String> finalAttributes = new HashMap<String, String>();
                for (Key validKey : this.nodeValidKeys.values()) {
                    String validId = validKey.id;
                    if (collectedAttributes.containsKey(validId)) {
                        finalAttributes.put(validKey.attributeName, collectedAttributes.get(validId));
                        continue;
                    }
                    if (validKey.defaultValue == null) continue;
                    finalAttributes.put(validKey.attributeName, validKey.defaultValue);
                }
                Object v = GraphMLImporter.this.vertexProvider.buildVertex(nodeId, finalAttributes);
                graphNodes.put(nodeId, v);
                graph.addVertex(v);
            }
            boolean handleSpecialEdgeWeights = false;
            double defaultSpecialEdgeWeight = 1.0;
            if (graph instanceof WeightedGraph) {
                for (Key k : this.edgeValidKeys.values()) {
                    if (!k.attributeName.equals(GraphMLImporter.this.edgeWeightAttributeName)) continue;
                    handleSpecialEdgeWeights = true;
                    String defaultValue = k.defaultValue;
                    try {
                        if (defaultValue == null) break;
                        defaultSpecialEdgeWeight = Double.parseDouble(defaultValue);
                    }
                    catch (NumberFormatException validKey) {}
                    break;
                }
            }
            for (GraphElement p : this.edges) {
                Object from = graphNodes.get(p.id1);
                if (from == null) {
                    throw new ImportException("Source vertex " + p.id1 + " not found");
                }
                Object to = graphNodes.get(p.id2);
                if (to == null) {
                    throw new ImportException("Target vertex " + p.id2 + " not found");
                }
                Map<String, String> collectedAttributes = p.attributes;
                HashMap<String, String> finalAttributes = new HashMap<String, String>();
                for (Key validKey : this.edgeValidKeys.values()) {
                    String validId = validKey.id;
                    if (collectedAttributes.containsKey(validId)) {
                        finalAttributes.put(validKey.attributeName, collectedAttributes.get(validId));
                        continue;
                    }
                    if (validKey.defaultValue == null) continue;
                    finalAttributes.put(validKey.attributeName, validKey.defaultValue);
                }
                Object e = GraphMLImporter.this.edgeProvider.buildEdge(from, to, "e_" + from + "_" + to, finalAttributes);
                graph.addEdge(from, to, e);
                if (!handleSpecialEdgeWeights || !finalAttributes.containsKey(GraphMLImporter.this.edgeWeightAttributeName)) continue;
                try {
                    ((WeightedGraph)graph).setEdgeWeight(e, Double.parseDouble((String)finalAttributes.get(GraphMLImporter.this.edgeWeightAttributeName)));
                }
                catch (NumberFormatException nfe) {
                    ((WeightedGraph)graph).setEdgeWeight(e, defaultSpecialEdgeWeight);
                }
            }
        }

        @Override
        public void startDocument() throws SAXException {
            this.nodes = new HashMap<String, GraphElement>();
            this.edges = new ArrayList<GraphElement>();
            this.nodeValidKeys = new HashMap<String, Key>();
            this.edgeValidKeys = new HashMap<String, Key>();
            this.insideDefault = false;
            this.insideData = false;
            this.currentKey = null;
            this.currentData = null;
            this.currentGraphElement = new ArrayDeque<GraphElement>();
            this.currentGraphElement.push(new GraphElement("graphml"));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (localName) {
                case "graph": {
                    this.currentGraphElement.push(new GraphElement(this.findAttribute("id", attributes)));
                    break;
                }
                case "node": {
                    this.currentGraphElement.push(new GraphElement(this.findAttribute("id", attributes)));
                    break;
                }
                case "edge": {
                    this.currentGraphElement.push(new GraphElement(this.findAttribute(EDGE_SOURCE, attributes), this.findAttribute(EDGE_TARGET, attributes)));
                    break;
                }
                case "key": {
                    String keyId = this.findAttribute("id", attributes);
                    String keyFor = this.findAttribute(KEY_FOR, attributes);
                    String keyAttrName = this.findAttribute(KEY_ATTR_NAME, attributes);
                    this.currentKey = new Key(keyId, keyAttrName, null, null);
                    if (keyFor == null) break;
                    switch (keyFor) {
                        case "edge": {
                            this.currentKey.target = KeyTarget.EDGE;
                            break;
                        }
                        case "node": {
                            this.currentKey.target = KeyTarget.NODE;
                            break;
                        }
                        case "all": {
                            this.currentKey.target = KeyTarget.ALL;
                        }
                    }
                    break;
                }
                case "default": {
                    this.insideDefault = true;
                    break;
                }
                case "data": {
                    this.insideData = true;
                    this.currentData = new Data(this.findAttribute("key", attributes), null);
                    break;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            switch (localName) {
                case "graph": {
                    this.currentGraphElement.pop();
                    break;
                }
                case "node": {
                    GraphElement currentNode = this.currentGraphElement.pop();
                    if (this.nodes.containsKey(currentNode.id1)) {
                        throw new SAXException("Node with id " + currentNode.id1 + " already exists");
                    }
                    this.nodes.put(currentNode.id1, currentNode);
                    break;
                }
                case "edge": {
                    GraphElement currentEdge = this.currentGraphElement.pop();
                    this.edges.add(currentEdge);
                    break;
                }
                case "key": {
                    if (this.currentKey.isValid()) {
                        switch (this.currentKey.target) {
                            case NODE: {
                                this.nodeValidKeys.put(this.currentKey.id, this.currentKey);
                                break;
                            }
                            case EDGE: {
                                this.edgeValidKeys.put(this.currentKey.id, this.currentKey);
                                break;
                            }
                            case ALL: {
                                this.nodeValidKeys.put(this.currentKey.id, this.currentKey);
                                this.edgeValidKeys.put(this.currentKey.id, this.currentKey);
                            }
                        }
                    }
                    this.currentKey = null;
                    break;
                }
                case "default": {
                    this.insideDefault = false;
                    break;
                }
                case "data": {
                    if (this.currentData.isValid()) {
                        this.currentGraphElement.peek().attributes.put(this.currentData.key, this.currentData.value);
                    }
                    this.insideData = false;
                    this.currentData = null;
                    break;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.insideDefault) {
                this.currentKey.defaultValue = new String(ch, start, length);
            } else if (this.insideData) {
                this.currentData.value = new String(ch, start, length);
            }
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        private String findAttribute(String localName, Attributes attributes) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrLocalName = attributes.getLocalName(i);
                if (!attrLocalName.equals(localName)) continue;
                return attributes.getValue(i);
            }
            return null;
        }
    }
}

