## upterm

Instant Terminal Sharing

### Synopsis

Upterm is an open-source solution for sharing terminal sessions instantly over secure SSH tunnels to the public internet.

Configuration Priority (highest to lowest):
  1. Command-line flags
  2. Environment variables (UPTERM_ prefix)
  3. Config file (see below)
  4. Default values

Config File:
  ~/.config/upterm/config.yaml (Linux)
  ~/Library/Application Support/upterm/config.yaml (macOS)
  %LOCALAPPDATA%\upterm\config.yaml (Windows)

  Run 'upterm config path' to see your config file location.
  Run 'upterm config edit' to create and edit the config file.

Environment Variables:
  All flags can be set via environment variables with the UPTERM_ prefix.
  Flag names are converted by replacing hyphens (-) with underscores (_).

  Examples:
    --hide-client-ip  → UPTERM_HIDE_CLIENT_IP=true
    --read-only       → UPTERM_READ_ONLY=true
    --accept          → UPTERM_ACCEPT=true

### Examples

```
  # Host a terminal session running $SHELL, attaching client's IO to the host's:
  $ upterm host

  # Display the SSH connection string for sharing with client(s):
  $ upterm session current
  === SESSION_ID
  Command:                /bin/bash
  Force Command:          n/a
  Host:                   ssh://uptermd.upterm.dev:22
  SSH Session:            ssh TOKEN@uptermd.upterm.dev

  # A client connects to the host session via SSH:
  $ ssh TOKEN@uptermd.upterm.dev

  # Set flags via environment variables:
  $ UPTERM_HIDE_CLIENT_IP=true upterm host
```

### Options

```
      --debug   enable debug level logging (log file: /home/user/.local/state/upterm/upterm.log).
  -h, --help    help for upterm
```

### SEE ALSO

* [upterm config](upterm_config.md)	 - Manage upterm configuration
* [upterm host](upterm_host.md)	 - Host a terminal session
* [upterm proxy](upterm_proxy.md)	 - Proxy a terminal session via WebSocket
* [upterm session](upterm_session.md)	 - Display and manage terminal sessions
* [upterm upgrade](upterm_upgrade.md)	 - Upgrade the CLI
* [upterm version](upterm_version.md)	 - Show version

###### Auto generated by spf13/cobra on 12-Jan-2026
